/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	resolutionv1alpha1 "github.com/tektoncd/pipeline/pkg/apis/resolution/v1alpha1"
	scheme "github.com/tektoncd/pipeline/pkg/client/resolution/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ResolutionRequestsGetter has a method to return a ResolutionRequestInterface.
// A group's client should implement this interface.
type ResolutionRequestsGetter interface {
	ResolutionRequests(namespace string) ResolutionRequestInterface
}

// ResolutionRequestInterface has methods to work with ResolutionRequest resources.
type ResolutionRequestInterface interface {
	Create(ctx context.Context, resolutionRequest *resolutionv1alpha1.ResolutionRequest, opts v1.CreateOptions) (*resolutionv1alpha1.ResolutionRequest, error)
	Update(ctx context.Context, resolutionRequest *resolutionv1alpha1.ResolutionRequest, opts v1.UpdateOptions) (*resolutionv1alpha1.ResolutionRequest, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, resolutionRequest *resolutionv1alpha1.ResolutionRequest, opts v1.UpdateOptions) (*resolutionv1alpha1.ResolutionRequest, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*resolutionv1alpha1.ResolutionRequest, error)
	List(ctx context.Context, opts v1.ListOptions) (*resolutionv1alpha1.ResolutionRequestList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *resolutionv1alpha1.ResolutionRequest, err error)
	ResolutionRequestExpansion
}

// resolutionRequests implements ResolutionRequestInterface
type resolutionRequests struct {
	*gentype.ClientWithList[*resolutionv1alpha1.ResolutionRequest, *resolutionv1alpha1.ResolutionRequestList]
}

// newResolutionRequests returns a ResolutionRequests
func newResolutionRequests(c *ResolutionV1alpha1Client, namespace string) *resolutionRequests {
	return &resolutionRequests{
		gentype.NewClientWithList[*resolutionv1alpha1.ResolutionRequest, *resolutionv1alpha1.ResolutionRequestList](
			"resolutionrequests",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *resolutionv1alpha1.ResolutionRequest { return &resolutionv1alpha1.ResolutionRequest{} },
			func() *resolutionv1alpha1.ResolutionRequestList { return &resolutionv1alpha1.ResolutionRequestList{} },
		),
	}
}
