/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	pipelinev1beta1 "github.com/tektoncd/pipeline/pkg/apis/pipeline/v1beta1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// PipelineRunLister helps list PipelineRuns.
// All objects returned here must be treated as read-only.
type PipelineRunLister interface {
	// List lists all PipelineRuns in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*pipelinev1beta1.PipelineRun, err error)
	// PipelineRuns returns an object that can list and get PipelineRuns.
	PipelineRuns(namespace string) PipelineRunNamespaceLister
	PipelineRunListerExpansion
}

// pipelineRunLister implements the PipelineRunLister interface.
type pipelineRunLister struct {
	listers.ResourceIndexer[*pipelinev1beta1.PipelineRun]
}

// NewPipelineRunLister returns a new PipelineRunLister.
func NewPipelineRunLister(indexer cache.Indexer) PipelineRunLister {
	return &pipelineRunLister{listers.New[*pipelinev1beta1.PipelineRun](indexer, pipelinev1beta1.Resource("pipelinerun"))}
}

// PipelineRuns returns an object that can list and get PipelineRuns.
func (s *pipelineRunLister) PipelineRuns(namespace string) PipelineRunNamespaceLister {
	return pipelineRunNamespaceLister{listers.NewNamespaced[*pipelinev1beta1.PipelineRun](s.ResourceIndexer, namespace)}
}

// PipelineRunNamespaceLister helps list and get PipelineRuns.
// All objects returned here must be treated as read-only.
type PipelineRunNamespaceLister interface {
	// List lists all PipelineRuns in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*pipelinev1beta1.PipelineRun, err error)
	// Get retrieves the PipelineRun from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*pipelinev1beta1.PipelineRun, error)
	PipelineRunNamespaceListerExpansion
}

// pipelineRunNamespaceLister implements the PipelineRunNamespaceLister
// interface.
type pipelineRunNamespaceLister struct {
	listers.ResourceIndexer[*pipelinev1beta1.PipelineRun]
}
