/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	pipelinev1 "github.com/tektoncd/pipeline/pkg/apis/pipeline/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// TaskRunLister helps list TaskRuns.
// All objects returned here must be treated as read-only.
type TaskRunLister interface {
	// List lists all TaskRuns in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*pipelinev1.TaskRun, err error)
	// TaskRuns returns an object that can list and get TaskRuns.
	TaskRuns(namespace string) TaskRunNamespaceLister
	TaskRunListerExpansion
}

// taskRunLister implements the TaskRunLister interface.
type taskRunLister struct {
	listers.ResourceIndexer[*pipelinev1.TaskRun]
}

// NewTaskRunLister returns a new TaskRunLister.
func NewTaskRunLister(indexer cache.Indexer) TaskRunLister {
	return &taskRunLister{listers.New[*pipelinev1.TaskRun](indexer, pipelinev1.Resource("taskrun"))}
}

// TaskRuns returns an object that can list and get TaskRuns.
func (s *taskRunLister) TaskRuns(namespace string) TaskRunNamespaceLister {
	return taskRunNamespaceLister{listers.NewNamespaced[*pipelinev1.TaskRun](s.ResourceIndexer, namespace)}
}

// TaskRunNamespaceLister helps list and get TaskRuns.
// All objects returned here must be treated as read-only.
type TaskRunNamespaceLister interface {
	// List lists all TaskRuns in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*pipelinev1.TaskRun, err error)
	// Get retrieves the TaskRun from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*pipelinev1.TaskRun, error)
	TaskRunNamespaceListerExpansion
}

// taskRunNamespaceLister implements the TaskRunNamespaceLister
// interface.
type taskRunNamespaceLister struct {
	listers.ResourceIndexer[*pipelinev1.TaskRun]
}
