/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	pipelinev1alpha1 "github.com/tektoncd/pipeline/pkg/apis/pipeline/v1alpha1"
	scheme "github.com/tektoncd/pipeline/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// VerificationPoliciesGetter has a method to return a VerificationPolicyInterface.
// A group's client should implement this interface.
type VerificationPoliciesGetter interface {
	VerificationPolicies(namespace string) VerificationPolicyInterface
}

// VerificationPolicyInterface has methods to work with VerificationPolicy resources.
type VerificationPolicyInterface interface {
	Create(ctx context.Context, verificationPolicy *pipelinev1alpha1.VerificationPolicy, opts v1.CreateOptions) (*pipelinev1alpha1.VerificationPolicy, error)
	Update(ctx context.Context, verificationPolicy *pipelinev1alpha1.VerificationPolicy, opts v1.UpdateOptions) (*pipelinev1alpha1.VerificationPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*pipelinev1alpha1.VerificationPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*pipelinev1alpha1.VerificationPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *pipelinev1alpha1.VerificationPolicy, err error)
	VerificationPolicyExpansion
}

// verificationPolicies implements VerificationPolicyInterface
type verificationPolicies struct {
	*gentype.ClientWithList[*pipelinev1alpha1.VerificationPolicy, *pipelinev1alpha1.VerificationPolicyList]
}

// newVerificationPolicies returns a VerificationPolicies
func newVerificationPolicies(c *TektonV1alpha1Client, namespace string) *verificationPolicies {
	return &verificationPolicies{
		gentype.NewClientWithList[*pipelinev1alpha1.VerificationPolicy, *pipelinev1alpha1.VerificationPolicyList](
			"verificationpolicies",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *pipelinev1alpha1.VerificationPolicy { return &pipelinev1alpha1.VerificationPolicy{} },
			func() *pipelinev1alpha1.VerificationPolicyList { return &pipelinev1alpha1.VerificationPolicyList{} },
		),
	}
}
