/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	pipelinev1alpha1 "github.com/tektoncd/pipeline/pkg/apis/pipeline/v1alpha1"
	scheme "github.com/tektoncd/pipeline/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// RunsGetter has a method to return a RunInterface.
// A group's client should implement this interface.
type RunsGetter interface {
	Runs(namespace string) RunInterface
}

// RunInterface has methods to work with Run resources.
type RunInterface interface {
	Create(ctx context.Context, run *pipelinev1alpha1.Run, opts v1.CreateOptions) (*pipelinev1alpha1.Run, error)
	Update(ctx context.Context, run *pipelinev1alpha1.Run, opts v1.UpdateOptions) (*pipelinev1alpha1.Run, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, run *pipelinev1alpha1.Run, opts v1.UpdateOptions) (*pipelinev1alpha1.Run, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*pipelinev1alpha1.Run, error)
	List(ctx context.Context, opts v1.ListOptions) (*pipelinev1alpha1.RunList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *pipelinev1alpha1.Run, err error)
	RunExpansion
}

// runs implements RunInterface
type runs struct {
	*gentype.ClientWithList[*pipelinev1alpha1.Run, *pipelinev1alpha1.RunList]
}

// newRuns returns a Runs
func newRuns(c *TektonV1alpha1Client, namespace string) *runs {
	return &runs{
		gentype.NewClientWithList[*pipelinev1alpha1.Run, *pipelinev1alpha1.RunList](
			"runs",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *pipelinev1alpha1.Run { return &pipelinev1alpha1.Run{} },
			func() *pipelinev1alpha1.RunList { return &pipelinev1alpha1.RunList{} },
		),
	}
}
