// Code generated by goa v3.20.0, DO NOT EDIT.
//
// catalog service
//
// Command:
// $ goa gen github.com/tektoncd/hub/api/v1/design

package catalog

import (
	"context"

	catalogviews "github.com/tektoncd/hub/api/v1/gen/catalog/views"
	goa "goa.design/goa/v3/pkg"
)

// The catalog service provides details about catalogs.
type Service interface {
	// List all Catalogs
	List(context.Context) (res *ListResult, err error)
}

// APIName is the name of the API as defined in the design.
const APIName = "v1"

// APIVersion is the version of the API as defined in the design.
const APIVersion = "1.0"

// ServiceName is the name of the service as defined in the design. This is the
// same value that is set in the endpoint request contexts under the ServiceKey
// key.
const ServiceName = "catalog"

// MethodNames lists the service method names as defined in the design. These
// are the same values that are set in the endpoint request contexts under the
// MethodKey key.
var MethodNames = [1]string{"List"}

type Catalog struct {
	// ID is the unique id of the catalog
	ID uint
	// Name of catalog
	Name string
	// Type of catalog
	Type string
	// URL of catalog
	URL string
	// Provider of catalog
	Provider string
}

// ListResult is the result type of the catalog service List method.
type ListResult struct {
	Data []*Catalog
}

// MakeInternalError builds a goa.ServiceError from an error.
func MakeInternalError(err error) *goa.ServiceError {
	return goa.NewServiceError(err, "internal-error", false, false, false)
}

// newCatalogMin converts projected type Catalog to service type Catalog.
func newCatalogMin(vres *catalogviews.CatalogView) *Catalog {
	res := &Catalog{}
	if vres.ID != nil {
		res.ID = *vres.ID
	}
	if vres.Name != nil {
		res.Name = *vres.Name
	}
	if vres.Type != nil {
		res.Type = *vres.Type
	}
	return res
}

// newCatalog converts projected type Catalog to service type Catalog.
func newCatalog(vres *catalogviews.CatalogView) *Catalog {
	res := &Catalog{}
	if vres.ID != nil {
		res.ID = *vres.ID
	}
	if vres.Name != nil {
		res.Name = *vres.Name
	}
	if vres.Type != nil {
		res.Type = *vres.Type
	}
	if vres.URL != nil {
		res.URL = *vres.URL
	}
	if vres.Provider != nil {
		res.Provider = *vres.Provider
	}
	return res
}

// newCatalogViewMin projects result type Catalog to projected type CatalogView
// using the "min" view.
func newCatalogViewMin(res *Catalog) *catalogviews.CatalogView {
	vres := &catalogviews.CatalogView{
		ID:   &res.ID,
		Name: &res.Name,
		Type: &res.Type,
	}
	return vres
}

// newCatalogView projects result type Catalog to projected type CatalogView
// using the "default" view.
func newCatalogView(res *Catalog) *catalogviews.CatalogView {
	vres := &catalogviews.CatalogView{
		ID:       &res.ID,
		Name:     &res.Name,
		Type:     &res.Type,
		URL:      &res.URL,
		Provider: &res.Provider,
	}
	return vres
}
