/* C:B**************************************************************************
   This software is © 2014 Bright Plaza Inc. <drivetrust@drivetrust.com>

   This file is part of sedutil.

   sedutil is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   sedutil is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with sedutil.  If not, see <http://www.gnu.org/licenses/>.

   * C:E********************************************************************** */
#pragma once
#include "DtaOS.h"

#define className DtaLinux
#define Linux (*(static_cast<className *>(&OS)))

class className : public DtaOS {
public:
  using DtaOS::DtaOS;

  /** Default destructor, does nothing*/
  virtual OSDEVICEHANDLE openDeviceHandle(const char * devref, bool & accessDenied);

  virtual void closeDeviceHandle(OSDEVICEHANDLE osDeviceHandle);

  virtual std::vector<std::string> generateDtaDriveDevRefs();

  virtual void errorNoAccess(const char * devref);

  virtual
  dictionary* getOSSpecificInformation(OSDEVICEHANDLE osDeviceHandle,
                                       const char* devref,
                                       InterfaceDeviceID& interfaceDeviceIdentification,
                                       DTA_DEVICE_INFO& device_info);

  virtual void * alloc_aligned_MIN_BUFFER_LENGTH_buffer ();

  virtual void free_aligned_MIN_BUFFER_LENGTH_buffer (void * aligned_buffer);


  /** Perform an ATA command using the current operating system HD interface
   *
   * @param osDeviceHandle    OSDEVICEHANDLE of already-opened raw device file
   * @param cmd               ATACOMMAND opcode IDENTIFY, IF_SEND, or IF_RECV
   * @param securityProtocol  security protocol ID per ATA command spec
   * @param comID             communication channel ID per TCG spec
   * @param buffer            address of data buffer
   * @param bufferlen         data buffer len, also output transfer length
   *
   * Returns the result of the os system call
   */
  virtual int PerformATACommand_via_HD(OSDEVICEHANDLE osDeviceHandle,
                                       ATACOMMAND cmd, uint8_t securityProtocol, uint16_t comID,
                                       void * buffer,  unsigned int & bufferlen)
  {
#undef PerformATACommand_via_HD_show
#ifdef PerformATACommand_via_HD_show
    LOG(E) << "DtaLinux::PerformATACommand_via_HD((OSDEVICEHANDLE)" << HEXON( 8) << osDeviceHandle        << HEXOFF << ", "
           <<                                    "(ATACOMMAND)"     << HEXON( 2) << (int)cmd                        << ", "
           <<                                                          HEXON( 1) << (int)securityProtocol           << ", "
           <<                                                          HEXON( 4) << comID                 << HEXOFF << ", "
           <<                                                          HEXON(16) << buffer                << HEXOFF << ", "
           <<                                                          HEXON( 4) << bufferlen             << HEXOFF << ")"
           << " unimplemented!" << std::endl << std::endl;
#else //  PerformATACommand_via_HD_show
    (void)osDeviceHandle;
    (void)cmd;
    (void)securityProtocol;
    (void)comID;
    (void)buffer;
    (void)bufferlen;
#endif //  PerformATACommand_via_HD_show
    return DTAERROR_FAILURE;
  }




  /** Perform a SCSI command using the current operating system SCSI interface
   *
   * @param osDeviceHandle  OSDEVICEHANDLE of already-opened raw device file
   * @param dxfer_direction direction of transfer PSC_FROM/TO_DEV
   * @param cdb             address of SCSI standard CDB (command data buffer)
   * @param cdb_len         length of SCSI command data buffer (often 12)
   * @param buffer          address of SCSI data buffer
   * @param bufferlen       SCSI data buffer len, also output transfer length
   * @param sense           SCSI sense data buffer
   * @param senselen        SCSI sense data buffer len (usually 32?)
   * @param pmasked_status  pointer to storage for masked_status, or NULL if not desired
   * @param timeout         optional timeout (in msecs)
   *
   * Returns the result of the os system call, as well as possibly setting *pmasked_status
   */
  virtual int PerformSCSICommand(OSDEVICEHANDLE osDeviceHandle,
                                 int dxfer_direction,
                                 uint8_t * cdb,   unsigned char cdb_len,
                                 void * buffer,   unsigned int& bufferlen,
                                 unsigned char * sense, unsigned char & senselen,
                                 SCSI_STATUS_CODE * pmasked_status,
                                 unsigned int timeout);



  /** Perform a NVMe command using the Linux `nvme_admin_cmd' (NVMe standard) interface with ioctl `NVME_IOCTL_ADMIN_CMD'
   *
   * @param osDeviceHandle  `OSDEVICEHANDLE' of already-opened raw device file
   * @param pcmd            address of NVMe standard `nvme_admin_cmd' (command struct)
   *
   * Returns the result of the os system call, as well as possibly setting *pmasked_status
   */
  virtual int PerformNVMeCommand(OSDEVICEHANDLE osDeviceHandle,
                                 uint8_t * pcmd,
                                 uint32_t *pstatus);
};
