/* 
 * $Id: ChemTests.java 131 2011-01-20 22:01:29Z ebakke $
 *
 *  Copyright (c) 2010, Novartis Institutes for BioMedical Research Inc.
 *  All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 
 *
 *     * Redistributions of source code must retain the above copyright 
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following 
 *       disclaimer in the documentation and/or other materials provided 
 *       with the distribution.
 *     * Neither the name of Novartis Institutes for BioMedical Research Inc. 
 *       nor the names of its contributors may be used to endorse or promote 
 *       products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.RDKit;
import static org.junit.Assert.*;

import org.junit.Test;

public class ChemTests extends GraphMolTest {
	
	/* Pickling tests skipped for the time being */
	@Test
	public void testRings() {
		ROMol m = RWMol.MolFromSmiles("OC1C(O)C2C1C(O)C2O");
		for (int i = 0; i < m.getNumAtoms(); i++) {
			Atom at = m.getAtomWithIdx(i);
			if (at.getAtomicNum() == 8) {
				assertFalse(String.format("atom %d improperly in ring", i), at.IsInRingSize(4));
			}
			else {
				assertTrue(String.format("atom %d not in ring of size 4", i), at.IsInRingSize(4));

			}
		}
	}

        @Test
        public void testBondRings() {
          ROMol m = RWMol.MolFromSmiles("OC1C(O)C2C1C(O)C2O");
          // Test with an acyclic bond
          Bond bd = m.getBondWithIdx(0);
          assertFalse("bond 0 improperly in 4-membered ring",
                      bd.IsInRingSize(4));
          assertFalse("bond 0 improperly in 5-membered ring",
                      bd.IsInRingSize(5));
          assertFalse("bond 0 improperly in ring", bd.IsInRing());

          // Now witha bond in a 4-mr
          bd = m.getBondWithIdx(1);
          assertTrue("bond 1 not in ring of size 4", bd.IsInRingSize(4));
          assertFalse("bond 1 improperly in 5-membered ring",
                      bd.IsInRingSize(5));
          assertTrue("bond 1 not in ring", bd.IsInRing());
        }

        public static void main(String args[]) {
		org.junit.runner.JUnitCore.main("org.RDKit.ChemTests");
	}

}
