% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascat.loadData.R
\name{ascat.loadData}
\alias{ascat.loadData}
\title{ascat.loadData}
\usage{
ascat.loadData(
  Tumor_LogR_file,
  Tumor_BAF_file,
  Germline_LogR_file = NULL,
  Germline_BAF_file = NULL,
  chrs = c(1:22, "X", "Y"),
  gender = NULL,
  sexchromosomes = c("X", "Y"),
  genomeVersion = NULL,
  isTargetedSeq = FALSE
)
}
\arguments{
\item{Tumor_LogR_file}{file containing logR of tumour sample(s)}

\item{Tumor_BAF_file}{file containing BAF of tumour sample(s)}

\item{Germline_LogR_file}{file containing logR of germline sample(s), NULL}

\item{Germline_BAF_file}{file containing BAF of germline sample(s), NULL}

\item{chrs}{a vector containing the names for the chromosomes (e.g. c(1:22, "X"))}

\item{gender}{a vector of gender for each cases ("XX" or "XY"). Default = all female ("XX")}

\item{sexchromosomes}{a vector containing the names for the sex chromosomes. Default = c("X", "Y")}

\item{genomeVersion}{a string ('hg19', 'hg38' or 'CHM13') so nonPAR coordinates on X can be stored, NULL}

\item{isTargetedSeq}{a boolean indicating whether data come from a targeted sequencing experiment. Default = F}
}
\value{
ascat data structure containing:\cr
1. Tumor_LogR data matrix\cr
2. Tumor_BAF data matrix\cr
3. Tumor_LogR_segmented: placeholder, NULL\cr
4. Tumor_BAF_segmented: placeholder, NULL\cr
5. Germline_LogR data matrix\cr
6. Germline_BAF data matrix\cr
7. SNPpos: position of all SNPs\cr
8. ch: a list containing vectors with the indices for each chromosome (e.g. Tumor_LogR[ch[[13]], ] will output the Tumor_LogR data of chromosome 13\cr
9. chr: a list containing vectors with the indices for each distinct part that can be segmented separately (e.g. chromosome arm, stretch of DNA between gaps in the array design)\cr
10. chrs: a vector containing chromosome names\cr
11. samples: a vector containing sample name(s)\cr
12. gender: a vector of gender for each cases ("XX" or "XY"). Default = NULL: all female ("XX")\cr
13. sexchromosomes: a vector containingg names of sex chromosomes\cr
14. X_nonPAR: a vector of two values (start and stop) to define where the nonPAR region is on X\cr
15. isTargetedSeq:  boolean indicating whether data come from a targeted sequencing experiment\cr
16. failedarrays: placeholder, NULL\cr
}
\description{
Function to read in SNP array data
}
\details{
germline data files can be NULL - in that case these are not read in
}
