% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_function.R
\name{describe_function}
\alias{describe_function}
\alias{describe_args}
\alias{args_tip}
\alias{call_tip}
\alias{descFun}
\alias{descArgs}
\alias{argsTip}
\alias{callTip}
\title{Get textual help on function or function arguments, or get a call tip}
\usage{
describe_function(fun, package, lib.loc = NULL)

describe_args(fun, args = NULL, package = NULL, lib.loc = NULL)

args_tip(name, only.args = FALSE, width = getOption("width"))

call_tip(
  code,
  only.args = FALSE,
  location = FALSE,
  description = FALSE,
  methods = FALSE,
  width = getOption("width")
)

descFun(fun, package, lib.loc = NULL)

descArgs(fun, args = NULL, package = NULL, lib.loc = NULL)

argsTip(name, only.args = FALSE, width = getOption("width"))

callTip(
  code,
  only.args = FALSE,
  location = FALSE,
  description = FALSE,
  methods = FALSE,
  width = getOption("width")
)
}
\arguments{
\item{fun}{A character string with the name of a function (several functions
accepted too for \code{describe_function()}.}

\item{package}{A character string with the name of the package that contains
\code{fun}, or \code{NULL} for searching in all loaded packages.}

\item{lib.loc}{A character vector of directory names of \R libraries, or
\code{NULL}. The default value of \code{NULL} corresponds to all libraries currently
known. If the default is used, the loaded packages are searched before the
libraries.}

\item{args}{Either \code{NULL} (by default) to return the description of all
arguments from the corresponding man page, or a character vector with names
of the arguments to search for.}

\item{name}{A string with the name of a function.}

\item{only.args}{Do we return only arguments of the function
(\verb{arg1, arg2 = TRUE, ...}), or the full call, like
(\code{myfun(arg1, arg2 = TRUE, ...)}).}

\item{width}{Reformat the tip to fit to fit in that width, except if
\code{width = NULL}.}

\item{code}{A fraction of R code ending with the name of a function,
eventually followed by '('.}

\item{location}{If \code{TRUE} then the location (in which package the function
resides) is appended to the calltip between square brackets.}

\item{description}{If \code{TRUE} then a short description of the function is
added to the call_tip (in fact, the title of the corresponding help page, if
it exists).}

\item{methods}{If \code{TRUE} then a short message indicating if this is a generic
function and that lists, in this case, available methods.}
}
\value{
A string with the description of the function or of its arguments, or
the calling syntax of the function, plus additional information depending on
the flags used. If the man page is not found, a vector of empty strings is
returned. Empty strings are also returned for arguments that are not found in
the man page.
}
\description{
Textual help on functions or their arguments is extracted for
text online help for a given function. By default, all arguments from the
online help are returned for \code{describe_args()}. If the file contains help for
several functions, one probably gets also some irrelevant information. Use of
'args' to limit result is strongly encouraged. \code{args_tip()} provides a
human-readable textual description of function arguments in a better way than
\code{args()} does. It is primarily intended for code tips in GUIs. \code{call_tip()}
has a similar purpose to show how some code could be completed.
}
\note{
\code{args_tip()} is supposed to display S3 and S4 methods, and primitives
adequately,... but this is not implemented yet in the current version! For
\code{call_tip()}, the use of \code{methods = TRUE} slows down the execution of the
function, especially for generic functions that have many methods like
\code{print()} or \code{summary()}.
}
\examples{
describe_function("ls", "base")
describe_function("library", "base")
describe_function("descFun", "svMisc")
describe_function("descArgs")

describe_args("ls")
describe_args("library", args = c("package", "pos"))

args_tip("ls")

call_tip("myvar <- lm(")
}
\seealso{
\code{\link[=completion]{completion()}}, \code{\link[=args]{args()}}, \code{\link[=argsAnywhere]{argsAnywhere()}}
}
\concept{graphical user interface (GUI) control}
\keyword{utilities}
