% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/List.R
\name{List}
\alias{List}
\title{Create a \code{List environment} that wraps given \code{data} and
most list functions are defined for chainable operations.}
\usage{
List(data = list())
}
\arguments{
\item{data}{A \code{list} or \code{vector}}
}
\description{
Create a \code{List environment} that wraps given \code{data} and
most list functions are defined for chainable operations.
}
\details{
Most list functions are defined in \code{List environment}.
In addition to these functions, \code{call(fun,...)} calls
external function \code{fun} with additional parameters specifies in
\code{...}.

To extract the data from List \code{x}, call \code{x$data} or simply
\code{x[]}.
}
\examples{
x <- list(p1 = list(type='A',score=list(c1=10,c2=8)),
       p2 = list(type='B',score=list(c1=9,c2=9)),
       p3 = list(type='B',score=list(c1=9,c2=7)))
m <- List(x)
m$filter(type=='B')$
  map(score$c1) []

m$group(type)$
  map(g ~ List(g)$
      map(score)$
      call(unlist)$
      call(mean) []) []

# Subsetting, extracting, and assigning

p <- List(list(a=1,b=2))
p['a']
p[['a']]
p$a <- 2
p['b'] <- NULL
p[['a']] <- 3
}
