/*
 * Copyright (C) 2015 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if ENABLE(CONTENT_EXTENSIONS)

#include "CombinedFiltersAlphabet.h"
#include "ContentExtensionsDebugging.h"
#include "NFA.h"
#include <wtf/Function.h>
#include <wtf/Forward.h>

namespace WebCore {

namespace ContentExtensions {

struct PrefixTreeVertex;

class WEBCORE_EXPORT CombinedURLFilters {
public:
    CombinedURLFilters();
    ~CombinedURLFilters();

    void addPattern(uint64_t actionId, const Vector<Term>& pattern);
    void addDomain(uint64_t actionId, const String& domain);

    void processNFAs(size_t maxNFASize, const WTF::Function<void(NFA&&)>& handler);
    bool isEmpty() const;

#if CONTENT_EXTENSIONS_PERFORMANCE_REPORTING
    size_t memoryUsed() const;
#endif
#if CONTENT_EXTENSIONS_STATE_MACHINE_DEBUGGING
    void print() const;
#endif

private:
    CombinedFiltersAlphabet m_alphabet;
    std::unique_ptr<PrefixTreeVertex> m_prefixTreeRoot;
    HashMap<const PrefixTreeVertex*, ActionList> m_actions;
};

} // namespace ContentExtensions
} // namespace WebCore

#endif // ENABLE(CONTENT_EXTENSIONS)
