---
title: "December OpenBao RFC Update"
description: "Overview of in-progress OpenBao RFCs and their status"
slug: rfcs-dec-2024
authors: cipherboy
tags: [community, mentee, rfcs]
---

The second half of 2024 saw several fabulous RFCs from different contributors to OpenBao. Here's a few worth highlighting and how you can get involved!

<!-- truncate -->

## In-Progress

### [openbao#697 / vault#17189 - SSH CA Multi-Issuer](https://github.com/openbao/openbao/issues/679)

**Description**: Vault and OpenBao have [long had issues](https://github.com/hashicorp/vault/issues/17189) supporting proper rotation of CAs in both the SSH and PKI engines. Previously, an operator would either have to remount an entirely new engine, manually copying configuration and policy, or they'd have to destructively remove the existing CA and create a new one, creating a downtime window. While PKI got updates to add multi-issuer support [in Vault v1.11](https://developer.hashicorp.com/vault/docs/release-notes/1.11.0#improved-ca-rotation), neither Vault nor OpenBao saw improvements to SSH CA rotation. This RFC by one our OpenBao Mentees, [Gabriel](https://github.com/Gabrielopesantos), brings parity by adding multi-issuer support to the SSH engine for zero-downtime CA rotation.

**How you can help**: Gabriel is working hard on the implementation for this feature, but we'd appreciate feedback on the design from any users of the SSH CA!

### [openbao#753 - CEL for PKI Policy](https://github.com/openbao/openbao/issues/753)

**Description**: The PKI Engine's role-based certificate validation method is inflexible: every possible certificate field and extension, complete with desired validation mechanism must be implemented in the engine itself, requiring a release for users to adopt. For instance, `allowed_domains` on a role today doesn't support setting default domains or rejecting requests with only a partial list of allowed domains. While functionally equivalent (in that, a user could request multiple certificates each with a subset of approved domains), it is hard for a PKI operator to ensure that all approved domains have been issued for in a single certificate. Fatima, another OpenBao Mentee, proposes to use Google's Common Expression Language (CEL), widely used in GCP and Kubernetes for validation and templating, to enforce issuance policy and template the final certificate from request parameters.

**How you can help**: Have experience using CEL or doing complex, company-specific PKI integrations? We'd love to hear from you about the proposed design!

### [openbao#787 - Add Namespace Support](https://github.com/openbao/openbao/issues/787)

**Description**: Vault Enterpise supports Namespaces, a way of creating multi-tenancy and delegating permissions without running multiple clusters. [Users](https://lists.lfedge.org/g/OpenBao-TSC/topic/openbao_dev_wg_proposal_to/108266694) [have](https://github.com/openbao/openbao/issues/486) [requested](https://github.com/orgs/openbao/discussions/293) similar abilities with OpenBao, so a temporary working group was formed to create the design and initial implementation. This RFC, published by [Peter](https://github.com/genelet/), proposes API compatibility for consuming applications but suggests many future improvements to scalability and tenant isolation.

**How you can help**: While the initial implementation will be done by the Namespace WG, we welcome feedback on the design, testing of the feature, and designs and implementations for future enhancements.

### [openbao#549 / vault#5275 - Recursively List Keys](https://github.com/openbao/openbao/issues/549)

**Description**: The [most widely requested Vault feature](https://github.com/hashicorp/vault/issues?q=is%3Aissue+is%3Aopen+sort%3Areactions-%2B1-desc) with no solution [is adding the ability to recursively list keys](https://github.com/hashicorp/vault/issues/5275). Prior to [transactions](https://openbao.org/docs/rfcs/transactions/) (for consistency) and [pagination](https://openbao.org/docs/rfcs/paginated-lists/) (for resource constraining expensive calls), this was hard to do safely. This RFC proposes introducing a new operation, with HTTP verb `SCAN` or via `GET` with `?scan=true`, and ACL capability (`scan`) to allow plugin authors to introduce recursive list endpoints and operators to secure access to them.

**How you can help**: After the initial implementation is merged, it would be great to have feedback or PRs on additional endpoints to use this new operation.

### ACL Improvements - [openbao#769 / vault#5362 - Filter LIST Results](https://github.com/openbao/openbao/issues/769) and [openbao#791 - Enforce List Pagination](https://github.com/openbao/openbao/issues/791)

**Description**: The [fourth-most widely requested Vault feature](https://github.com/hashicorp/vault/issues?q=is%3Aissue+is%3Aopen+sort%3Areactions-%2B1-desc) with no solution [is filtering LIST results](https://github.com/openbao/openbao/issues/769) to only show accessible paths. [This RFC](https://github.com/openbao/openbao/issues/769) proposes a new ACL policy parameter, `list_scan_response_keys_filter_path`, which contains a path to template with each list response item (from `.keys`) to check against the ACL system for visibility under the same token policy. While this is an expensive operation, a [follow-up RFC](https://github.com/openbao/openbao/issues/791) proposes another parameter, `pagination_limit`, to allow policy authors to require usage of paginated lists (thereby reducing the load on path filtering).

**How you can help**: It would be great to have feedback on the templating design and how support for multiple paths could potentially behave (with an `AND` or `OR` conjunctions).

## Completed

### [openbao#296 - Transactional Storage](https://github.com/openbao/openbao/issues/432)

**Description**: Recently merged and released in [v2.1.0](https://openbao.org/docs/release-notes/2-1-0/) was support for transactional storage across the entire OpenBao stack (from underlying physical storage backend to plugins). This allowed us to [improve the scalability](https://github.com/openbao/openbao/issues/432) and fault-tolerance of OpenBao above and beyond what HashiCorp Vault had.

**How you can help**: A follow-up [tracking issue](https://github.com/openbao/openbao/issues/607) invites contributions of places where transactions should be used. As always, we welcome testing of this feature.

## Upcoming

### [openbao#235 - Add XChaCha20-Poly1305 Barrier Encryption Support](https://github.com/openbao/openbao/issues/235)

**Description**: OpenBao uses AES256-GCM96 as its barrier encryption algorithm. While suitably secure and FIPS compliant, this requires frequent key rotation to compensate for the 96-bit nonce (which is not collision resistant). Switching to XChaCha20-Poly1305 would allow us to maintain a smaller barrier keyring (as key rotation would not need to be done automatically) and avoid concerns over nonce collisions.

**How you can help**: While a proof of concept was proposed, we're looking for a volunteer to take over polishing the feature!

### [openbao#17 - Add ACME Support to the TLS Listener](https://github.com/openbao/openbao/issues/17)

**Description**: While OpenBao supports PKI capabilities, due to a chicken-and-egg problem, it is hard to issue the TLS listener's own certificate via a CA stored in OpenBao. With auto-unseal and ACME support, however, it would be possible to do and greatly improve operator's experience when using other CAs as well.

**How you can help**: While a proof of concept was proposed, much polish was needed to complete this feature and we're looking for a volunteer to take over development!
