---
title: "Announcing OpenBao v2.1.0!"
description: "We are thrilled to announce the availability of OpenBao v2.1.0, focused on safety and scalability improvements!"
slug: release-v2-1-0
authors: cipherboy
tags: [release, announcement, release]
---

![openbao-logo](https://raw.githubusercontent.com/openbao/artwork/refs/heads/main/color/openbao-text-color.svg)

We are thrilled to announce [the availability](https://openbao.org/downloads/?version=v2.1.0) of [OpenBao v2.1.0](https://openbao.org/docs/release-notes/2-1-0/), focused on safety and scalability improvements!

This release spent some time laying the groundwork for safety and scalability improvements for releases to come. With the help of the community, OpenBao will now take advantage of transactional storage semantics from its underlying data store, giving operators and plugin developers confidence in the consistency of storage writes. This storage safety allows us to focus on alternative storage layouts for improving scalability, for instance, increasing the maximum number of mount table entries past the single-entry limit.

This release also features contributions from many new and repeat contributors; thank you all!

<!-- truncate -->

## Key highlights of the release

Major features:

 - **Remove Mount Table Limits**: Using transactional storage, we've split the auth and secret mount tables into separate storage entires, removing the requirement that the entire table fit into a single storage entry limited by max_entry_size. This allows potentially hundreds of thousands of mounts on a single scaled-up server.
 - **Transactional Storage**: Plugin developers can now take advantage of safe storage modification APIs when the underlying physical storage supports them. The physical.TransactionalBackend and logical.TransactionalStorage types allow developers to begin read-only and writable transactions, committing or rolling back the desired changes.
 - **Transit**: Support PKI CSR and certificate storage alongside key material. This allows callers to securely create keys and submit requests for certificates without the key material leaving Transit. Storage of the certificate on the key avoids the need for an additional K/V mount. Rotation of this certificate and its chain is also supported.
 - `physical/postgres`: Reintroduce Postgres database for OpenBao storage, implementing paginated list support. This feature is currently in **preview** and breaking changes may occur.

Plugin improvements:

 - `auth/jwt`: Allow templating ACL policies from data in claims on JWT or OIDC ID tokens.
 - `auth/oidc`: Add a new oauth2_metadata configuration option to enable sending any of the tokens from the token issuer to the client.
 - `auth/oidc`: Add a new callback_mode role option value **device** to use the oidc device flow instead of a callback, add a new poll_interval role option to control how often to poll for a response, and add a new callbackmode=device option to the oidc login method in the cli.
 - `auth/oidc`: Add new **callback_mode=direct** role option to cause the oidc callback to be direct to the server instead of the client, and add a callbackmode=direct option to the oidc login method in the cli.
 - `docker`: add /bin/vault symlink to docker images.
 - `rpm`: Fix packaging to properly annotate configs entries for noreplace.
 - `secrets/kv`: Implement transactions to prevent canceled operations from corrupting storage.
 - `secrets/pki`: Use transactions for root generation, issuer import.
 - `secrets/pki`: add not_before parameter to precisely define a certificate's "not before" field.
 - `secrets/pki`: Add revoked_safety_buffer to control retention on revoked certificates separately from expired certificates.
 - `secrets/pki`: Delete invalid certificates during tidy via tidy_invalid_certs=true if they cannot be parsed due to Go's x509 handling.
 - `secrets/pki`: Support revoking expired certificates with the allow_expired_cert_revocation CRL configuration.
 - `storage/postgresql`: Allow table creation to improve first-start UX.

Stay tuned for more great features to come!

## Looking ahead

Several feature-related working groups have spun up, including one around Namespaces which will bring welcomed multi-tenancy improvements in the future. OpenBao's mentees have also been making great improvements! Stay tuned for progress on [multi-issuer SSH CA support](https://github.com/openbao/openbao/issues/679) and [Common Expression Language (CEL)-based PKI issuance policy](https://github.com/openbao/openbao/issues/753).

Changes are well underway for the next release, including usability enhancements to the PKI engine, improvements to the K/V engine based on paginated lists and transactional storage, additions to the ACL system to handle recursive listing, and an RFC for restricting the results of [list operations to only visible entries](https://github.com/openbao/openbao/issues/769).

If anyone has private forks of HashiCorp Vault, we are happy to collaborate around timely security fixes or syncing modifications to the core or plugins.

As always, we appreciate any and all contributions!
