---
title: OpenBao's First Roadmap and Community Direction
description: An explanation of OpenBao's proposed roadmap and direction for the community.
slug: roadmap
authors: cipherboy
tags: [direction, community, collaboration]
image: https://raw.githubusercontent.com/openbao/artwork/refs/heads/main/color/openbao-vertical-text-color.svg
---

I'm pleased to announce that our first [direction and roadmap document](https://github.com/openbao/openbao/issues/569) has been approved by the TSC!

This represents a major commitment to openness for this project. Historically, upstream hasn't published an open roadmap or collaborated with the community on a shared vision and direction for their project. <!-- truncate --> As part of this fork, we wanted to take the time to address some long-standing community-requested issues and make sure we intentionally collaborate with our users and contributors, regardless of employer, contribution status, or any monetary payment or contract.

_Aside_: Sure, this roadmap may not be perfect. It doesn't have timelines for one! It may not reflect everything that anyone has ever dreamed of for this project. But it prioritizes some key issues where we feel that we can make some immediate progress and lead the project in key, focused directions.

We've categorize the roadmap into three main areas:

 1. "**Safer**": to enable safer operation of OpenBao, through transactions, break-glass procedures, and improved ACL and audit capabilities,
 2. "**Community**": to encourage community maintainership of external plugins and client libraries, and
 3. "**Scalability**": to improve scalability of the core, through reducing resource consumption and removing design limitations.

Each of these areas are places were the community has _wanted more_ from OpenBao and its upstream and where we think we can deliver.

I'll save the details for the [roadmap tracking issue](https://github.com/openbao/openbao/issues/569), but some highlights are:

1. Finishing transactional storage and using it improve scalability, such as by expanding the mount table limits.
2. Parallel seal mechanisms and HSM/PKCS#11 auto-unseal capabilities.
3. Reviving the PostgreSQL storage backend and bringing transactional storage to it.
4. Namespace support for true multi-tenancy.
5. Reviving and refreshing the UI.
6. Building a first-class plugin ecosystem, through community-maintained plugins and a registry for efficient use.
7. ...and many more!

:::info
Interested in some of these features? We need your help!

React (:+1:) to issues on GitHub to show your support, help contribute use cases or design documents, or submit code implementing these features! If you need help getting started, [just reach out](https://github.com/openbao/#contact)!
:::
