---
title: Maintainers, Commiters, and Moderators Oh-My!
description: OpenBao's Community Roles policy is an important step towards open governance.
slug: maintainers
authors: cipherboy
tags: [community, policies, governance]
image: https://raw.githubusercontent.com/openbao/artwork/refs/heads/main/color/openbao-vertical-text-color.svg
---

\o Hello OpenBao community!

In our last [community post](/blog/kickoff/), we said:

> **Join the community and its leadership today.**

But you said: _it is not clear how!_

Good news: Our community roles are [approved and live](https://github.com/openbao/openbao/blob/main/MAINTAINERS.md#openbao-community-roles)!

<!-- truncate -->

## How were the community roles created?

Open discussions on what roles should exist in the community started [early in the community's history](https://github.com/orgs/openbao/discussions/228). Eventually, I put forward [a proposal](https://lists.lfedge.org/g/openbao/topic/proposal_community/108163995) for review [by the community](https://lf-edge.atlassian.net/wiki/spaces/OP/pages/15211863/OpenBao+Meetings) (on August 29th, 2024) and with the support of the [TSC](https://lf-edge.atlassian.net/wiki/spaces/OP/pages/15212291/2024-08-08+OpenBao+TSC+Meeting). This was adopted officially on September 30th, 2024 thanks to unanimous votes [by the TSC](https://lists.lfedge.org/g/OpenBao-TSC/topic/announce_roadmap/108738128)!

## What are our community roles?

The accepted proposal [introduced three roles](https://github.com/openbao/openbao/blob/main/MAINTAINERS.md#overview), open for anyone, regardless of employer, to apply:

1. Org-wide [**Moderators**](https://github.com/openbao/openbao/blob/main/MAINTAINERS.md#organization-level-moderators-1), to help triage issues and pull requests across all of our repositories.
2. Repository [**Committers**](https://github.com/openbao/openbao/blob/main/MAINTAINERS.md#repository-level-committers), to help maintain specific plugins, libraries, or portions of the core.
3. Org-wide [**Maintainers**](https://github.com/openbao/openbao/blob/main/MAINTAINERS.md#organization-level-maintainers-1), which are given broader permissions across all repositories and are automatically voting members of the Dev WG.

These roles have _increasing barriers to entry_: being a security-sensitive project, we need to balance our desire for open governance with an adequate vetting process for contributing.

## How do I apply?

When eligibility requirements are met, application is usually as simple as collecting some evidence and accomplishments in the community and sending an email to [the mailing list](https://lists.lfedge.org/g/openbao)! Then a relevant body of contributors will vote on applicants.

## Why is this important?

A project defining its own governance is an important step along the [project maturity process](https://lf-edge.atlassian.net/wiki/spaces/LE/pages/15848760/Project+Stages+Definitions+and+Expectations).

But more than that, OpenBao is an open-source project under open-governance. Unlike HashiCorp's [Core Contributors](https://www.credly.com/org/hashicorp/badge/hashicorp-core-contributor-2024) _award_, these positions can give community members _maintainer_ access to OpenBao repositories, something HashiCorp never allowed non-employees to have. Achieving organization-level maintainer allows you a vote on the Development Working Group and passing a vote by the TSC is a testament to the impact of your work. It gives you, the contributor, a voice in this project's leadership. And increasing the diversity and preventing a monoculture by a single employer is what will help make this experiment succeed.

## What's next for OpenBao?

Glad you asked! Next up is ratifying the [Development Working Group charter](https://gist.github.com/cipherboy/f6fc1f970f9c5feb753e2dd58e145eff) and defining how one [joins the TSC](https://lf-edge.atlassian.net/wiki/spaces/OP/pages/62586881/2024-10-10+OpenBao+TSC+Meeting). These two documents are the last key pieces of governance our community needs to define as it works towards stage 2 in the LF Edge project maturity model.

:::info
Interested in joining to help maintain OpenBao going forward? Apply today!

We're especially looking for candidates who are interested in helping to own specific plugins (including GCP and AWS) and Kubernetes support!
:::
