---
title: Announcing the OpenBao Blog!
description: OpenBao Blog Kickoff - Focused on the Community and Technical Challenges
slug: kickoff
authors: cipherboy
tags: [intro, trends, community]
image: https://raw.githubusercontent.com/openbao/artwork/main/color/openbao-text-color.svg
---

We asked one of our Gen Z community members to describe OpenBao recently. They wrote the following:

<!-- truncate -->

> <p align="center"><img src="https://raw.githubusercontent.com/openbao/artwork/main/color/openbao-color.svg" height="30%" width="30%" /></p>
>
> See the three bao representing different [auth](https://openbao.org/docs/auth/) and [secret](https://openbao.org/docs/secrets/) [engines](https://openbao.org/docs/plugins/) or nodes in a [cluster](https://openbao.org/docs/concepts/ha/)? Very _cutesy_.
>
> See how secrets can be [dynamically](https://openbao.org/docs/use-cases/#dynamic-secrets) [rotated](https://openbao.org/docs/secrets/databases/)? Very _considerate_.
>
> See our project running under [open governance](https://github.com/openbao/openbao/blob/main/CONTRIBUTING.md#technical-steering-committee-tsc-members) and with [OSI licenses](https://github.com/openbao/openbao/blob/main/LICENSE)? Very _mindful_.
>
> See us promise [API compatibility](https://openbao.org/docs/policies/migration/#proposal) with drop-in compatibility for Raft users? Very _respectful_.
>
> See all of the nicely packaged [release binaries](https://openbao.org/downloads/) ready for [installation](https://openbao.org/docs/install/)? [Very _demure_](https://www.nytimes.com/2024/08/14/style/demure-tiktok-mindful-cutesy.html).

---

Not all [trends](https://www.mongodb.com/legal/licensing/server-side-public-license/faq) are worth jumping on.

While attackers have only gotten [more](https://www.pcmag.com/news/microsoft-details-how-chinese-hackers-acquired-signing-key-for-outlook) [sophisticated](https://www.npr.org/2021/04/16/985439655/a-worst-nightmare-cyberattack-the-untold-story-of-the-solarwinds-hack), the importance of central inventory, observability, and facilitating organization-wide rotation of secrets can make the difference in a proactive security posture. More than that, being confident that your solution won't disappear over night because of a license change ensures long-term peace of mind and stability.

That's why OpenBao was launched with open governance [under the Linux Foundation's LF Edge](https://lfedge.org/projects/openbao/).

**Join the community and its leadership today.**

:::info

Welcome to the start of our blog series.

At the end of every blog post, we'll post a way you can get involved based on the topics discussed.

Interested in writing a blog post with us? Feel free to [reach out](https://github.com/openbao#contact), we'd love to see what you have in mind!

If you're looking for ideas, consider talking about your experience as an operator of OpenBao and deploying it, or as a developer or architect integrating and designing against it. Or maybe consider writing about an existing or upcoming feature you're excited about.

:::
