---
title: "Announcing OpenBao v2.0.0, the Initial GA Release!"
description: "We are thrilled to announce the availability of OpenBao v2.0.0, its initial GA release!"
slug: release-v2-0-0
authors: cipherboy
tags: [release, announcement, release]
image: https://lfedge.org/wp-content/uploads/sites/24/2024/07/Screenshot-2024-07-24-at-12.49.18-PM.png
---

![openbao-logo](https://raw.githubusercontent.com/openbao/artwork/refs/heads/main/color/openbao-text-color.svg)

We are thrilled to announce the availability of [OpenBao v2.0.0](https://openbao.org/docs/release-notes/2-0-0/), its initial GA release!

It was fabulous to see contributors and member companies from a wide range of backgrounds come together to support OpenBao over the past several months and build an initial GA release in the open. This release focuses mostly on stabilizing the fork, reducing the binary size, and giving the community room to make the decisions it needs to ensure a healthy start to the ecosystem.

<!-- truncate -->

## Key highlights of the release

Major features:

 - **Paginated Lists**: Allow plugins to support pagination on LIST requests, reducing server and client burden by limiting large responses. This uses optional after and limit parameters for clients to control the size of responses with a relative indexing into result entry sets.

Plugin improvements:

 - `secret/pki`: Add Delta CRL Distribution Point to AIA URLs, allowing AIA-aware clients to find Delta CRLs dynamically.
 - `sdk/helper/shamir`: move Shamir’s code into public SDK namespace to encourage external reuse
 - `core`: Remove mlock functionality from OpenBao and make the “disable_mlock” config option obsolete.
 - `secret/transit`: Add support for XChaCha20-Poly1305 keys, preventing nonce-reuse without key rotation.
 - `secret/transit`: Allow choosing export key format, specifying format=der or format=pem for consistent PKIX encoded public keys.
 - `secret/transit`: Allow soft deletion of keys, preventing their use and rotation but retaining key material until restored or fully deleted.
 - `secret/rabbitmq`: Fix role reading causing audit log panic when vhost_topics are set.
 - `secret/pki`: Use user-submitted ordering for SANs, fixing issues where automatic ordering causes parse failures in some browsers.
 - `auth`: Add token_strictly_bind_ip to support strictly binding tokens to source IP address.

Stay tuned for more great features to come!

![openbao-quote](https://lfedge.org/wp-content/uploads/sites/24/2024/07/Screenshot-2024-07-24-at-12.49.18-PM.png)

## Looking ahead

As the community matures and puts processes in place for project leadership, we’re looking for contributors to help maintain the external plugin ecosystem with the fork. If you’re willing to help out, check out [https://github.com/openbao/openbao/issues/134](https://github.com/openbao/openbao/issues/134)!

We’ve also already seen some fairly ambitious contributions from the community for the next release, from PKCS#11 and KMIP auto-unseal methods, to transactional storage, and to overall improvements in the JWT/OIDC authentication method. Additionally there’s been great progress on forking the Kubernetes ecosystem tooling and we expect that to GA soon.

---

This blog post was originally posted on the [LF Edge Blog](https://lfedge.org/announcing-openbao-v2-0-0-the-initial-ga-release/).

Check out our website and follow [LF Edge on LinkedIn](https://www.linkedin.com/company/lf-edge/) to keep up to date on the latest, and learn how you can participate!
