/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */

import Component from '@glimmer/component';
import { action } from '@ember/object';
import { tracked } from '@glimmer/tracking';

export default class inputSelect extends Component {
  /*
   * @public
   * @param Function
   *
   * Function called when any of the inputs change
   *
   */
  @tracked searchInput = '';

  constructor() {
    super(...arguments);
    this.searchInput = this.args?.initialValue;
  }

  @action
  inputChanged() {
    this.args.onChange(this.searchInput);
  }
}
