// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

package jwtauth

import "fmt"

const successHTML = `
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>OpenBao Authentication Succeeded</title>
    <style>
      body {
        font-size: 14px;
        font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI",
          "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans",
          "Helvetica Neue", sans-serif;
      }
      hr {
        border-color: #fdfdfe;
        margin: 24px 0;
      }
      .container {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 70vh;
      }
      #logo {
        display: block;
        fill: #6f7682;
        margin-bottom: 16px;
      }
      .message {
        display: flex;
        min-width: 40vw;
        background: #fafdfa;
        border: 1px solid #c6e9c9;
        margin-bottom: 12px;
        padding: 12px 16px 16px 12px;
        position: relative;
        border-radius: 2px;
        font-size: 14px;
      }
      .message-content {
        margin-left: 4px;
      }
      .message #checkbox {
        fill: #2eb039;
      }
      .message .message-title {
        color: #1e7125;
        font-size: 16px;
        font-weight: 700;
        line-height: 1.25;
      }
      .message .message-body {
        border: 0;
        margin-top: 4px;
      }
      .message p {
        font-size: 12px;
        margin: 0;
        padding: 0;
        color: #17421b;
      }
      a {
        display: block;
        margin: 8px 0;
        color: #1563ff;
        text-decoration: none;
        font-weight: 600;
      }
      a:hover {
        color: black;
      }
      a svg {
        fill: currentcolor;
      }
      .icon {
        align-items: center;
        display: inline-flex;
        justify-content: center;
        height: 21px;
        width: 21px;
        vertical-align: middle;
      }
      h1 {
        font-size: 17.5px;
        font-weight: 700;
        margin-bottom: 0;
      }
      h1 + p {
        margin: 8px 0 16px 0;
      }
    </style>
  </head>
  <body translate="no" >
    <div class="container">
      <div>
        <svg id="logo" width="160" height="75" viewBox="0 0 2638.1936 1215.5009" xmlns="http://www.w3.org/2000/svg" xmlns:svg="http://www.w3.org/2000/svg">
	  <g
	     id="g1"
	     transform="translate(-92.473222,-129.48373)">
	    <g
	       id="g2">
	      <path
		 id="path7"
		 style="fill:#fdfccf"
		 d="m 1276.1588,589.18295 -4.2246,2.18359 c -46.6401,24.11848 -85.7727,83.26334 -91.7676,138.69532 -2.0918,19.34113 -8.0461,31.06831 -20.5723,40.52148 -12.3544,9.32359 -18.2881,11.24949 -34.9277,11.33789 -14.1915,0.0754 -14.9177,-0.063 -22.4063,-4.30664 -31.3875,-17.78677 -35.985,-50.44489 -13.4629,-95.61523 4.7534,-9.53333 12.463,-23.03334 17.1329,-30 4.6698,-6.96667 8.3519,-12.81154 8.1816,-12.98829 -0.9419,-0.97812 -17.0596,4.3695 -28.9746,9.61329 -55.6391,24.48668 -107.00763,65.92167 -147.99416,119.375 -47.35612,61.76035 -72.24163,119.1656 -87.85742,202.66796 -3.63743,19.45047 -4.92168,54.08538 -2.71094,73.10158 2.84678,24.4871 10.5094,47.2435 21.09375,62.6484 11.69027,17.0144 31.74133,30.1498 49.09766,32.1621 13.98443,1.6215 800.11361,1.6799 814.24611,0.061 13.469,-1.5432 19.7159,-3.7352 31.3008,-10.9844 8.63,-5.4003 24.8459,-21.7804 23.584,-23.8223 -0.3967,-0.6418 -0.2116,-1.166 0.4101,-1.166 3.5499,0 17.6668,-32.8073 15.5742,-36.1933 -0.4895,-0.7919 -0.2726,-1.8211 0.4824,-2.2891 1.9171,-1.1884 4.3051,-26.8349 4.2911,-46.084 -0.05,-66.51852 -28.3048,-155.4073 -69.1133,-217.43358 -13.9413,-21.18982 -36.8418,-50 -39.7442,-50 -1.1396,0 -1.5575,-0.64413 -1.0019,-1.54296 1.198,-1.9385 -28.7215,-31.13452 -46.1348,-45.01954 -16.1896,-12.90917 -37.4954,-27.30854 -52.1328,-35.23242 -21.9679,-11.8922 -67.1622,-31.34955 -68.8633,-29.64844 -0.4512,0.45115 0.4931,2.46018 2.0977,4.46485 19.1282,23.89693 35.1226,55.29551 39.7168,77.96875 3.8981,19.238 0.3275,32.08121 -12.4766,44.88476 -22.1239,22.12288 -55.2163,23.03435 -75.6699,2.08204 -9.8364,-10.0762 -14.1655,-19.71885 -15.4844,-34.48633 -1.4356,-16.07497 -1.8848,-18.32723 -6.4472,-32.25196 -12.2301,-37.32675 -26.8086,-63.043 -47.6934,-84.13476 -11.5951,-11.71001 -30.809,-25.75195 -35.2383,-25.75195 -2.1446,-1e-5 -2.3055,4.86496 -2.4121,73.30078 -0.063,40.31513 -0.6825,76.30446 -1.3789,79.97656 -4.8225,25.42868 -33.2989,42.97273 -60.7383,37.41992 -10.1413,-2.05224 -16.7169,-5.90333 -26.1992,-15.33984 -12.8688,-12.80669 -12.3709,-8.6497 -11.9473,-99.76563 z m 178.9492,100.59766 c 0.3142,-0.31428 0.9724,1.02646 1.4629,2.98046 0.4904,1.95402 0.6346,3.81071 0.3203,4.125 -0.3143,0.31429 -0.9725,-1.02645 -1.4629,-2.98046 -0.4904,-1.95402 -0.6346,-3.81072 -0.3203,-4.125 z m 62.1426,139.96679 c 27.1451,0.38348 56.3607,14.86162 70.9824,36.25196 16.741,24.49056 13.1007,43.74834 -10.4649,55.3496 -15.1785,7.47243 -28.5375,6.78892 -46.5117,-2.38085 -9.3282,-4.75887 -14.3647,-5.03597 -22.4062,-1.22852 -23.8814,11.30731 -43.5266,10.15893 -60.9571,-3.56445 -9.1698,-7.21958 -12.5781,-13.64761 -12.4687,-23.50782 0.2644,-23.80852 37.1961,-55.40288 70.3691,-60.19921 3.7448,-0.54145 7.5792,-0.77549 11.4571,-0.72071 z m -428.5469,0.19141 c 6.7581,-0.53687 13.6047,-0.15431 20.4844,1.16797 26.6746,5.12693 51.7467,22.84667 62.0644,43.86328 8.7843,17.89341 7.6965,26.40182 -4.8125,37.64844 -12.8019,11.50999 -35.29,16.0734 -50.1074,10.16992 -3.85,-1.5339 -9.9936,-3.9827 -13.6523,-5.44336 -6.2862,-2.50962 -7.0016,-2.54067 -13,-0.53516 -3.4912,1.16725 -10.5463,3.9697 -15.6797,6.22656 -7.545,3.31717 -11.5062,4.18318 -20.668,4.51758 -13.4884,0.49231 -18.8202,-1.20092 -28.0117,-8.89648 -17.9736,-15.04831 -15.6175,-37.07957 6.3711,-59.57227 17.2503,-17.64591 36.7373,-27.53589 57.0117,-29.14648 z"
		 sodipodi:nodetypes="ccsssssscsssssssssssscssssssssssssssssssccssssssssssssssssssssssssss" />
	      <path
		 style="fill:#fdd0a4"
		 d="m 389.16327,822.99995 c -1.65849,-2.11474 -1.61133,-2.1619 0.50341,-0.50341 1.28333,1.00646 2.33333,2.05646 2.33333,2.33334 0,1.09738 -1.09491,0.39107 -2.83674,-1.82993 z m 116.83675,-39.13716 c -18.38385,-0.85255 -27.99445,-3.44955 -41.02473,-11.0858 -18.14604,-10.63429 -35.30007,-33.21042 -43.64745,-57.4437 -13.81828,-40.11581 -5.74614,-109.84754 21.22263,-183.33332 10.94274,-29.81728 26.85107,-64 29.78504,-64 0.63537,0 0.7844,-0.6 0.33117,-1.33333 -0.45322,-0.73333 -0.15322,-1.33333 0.66667,-1.33333 0.81989,0 1.17605,-0.50914 0.79146,-1.13141 -0.38459,-0.62228 0.33,-2.2957 1.58798,-3.71873 1.25797,-1.42303 2.43296,-3.30111 2.61109,-4.17351 0.62319,-3.05223 12.85674,-21.14571 27.70534,-40.97635 41.56101,-55.50565 88.63246,-95.53392 146.63747,-124.69648 19.42344,-9.76532 48.66666,-20.76478 48.66666,-18.30534 0,0.77923 -1.41534,3.27342 -3.1452,5.54264 -8.71089,11.4269 -25.88456,43.25873 -31.35961,58.12585 -13.87577,37.67871 -12.10781,61.44835 6.00612,80.74995 9.99321,10.64843 23.81732,15.82878 39.83203,14.92638 13.59506,-0.76607 23.28866,-5.23586 33.80033,-15.58559 10.57132,-10.40846 13.52755,-17.18647 13.55389,-31.07621 0.0382,-20.12782 8.44193,-50.49331 21.82855,-78.87362 9.50775,-20.1569 18.95744,-33.89195 32.68764,-47.5112 10.75121,-10.66433 31.48603,-25.85149 33.5517,-24.57484 0.51143,0.31608 1.03219,35.83304 1.15725,78.92658 0.12507,43.09353 0.7912,80.86969 1.4803,83.94701 2.62437,11.7197 12.94948,23.38302 26.60701,30.05545 4.53863,2.21737 9.09632,3.05779 18.71271,3.45058 11.82064,0.48281 13.31763,0.24299 21.33334,-3.41761 13.03514,-5.95287 22.24487,-13.90736 26.42513,-22.82351 l 3.52882,-7.52671 0.34684,-80.61349 c 0.19076,-44.33743 0.79807,-81.06474 1.34957,-81.61624 1.89369,-1.89369 23.52098,14.23972 36.9491,27.56307 17.47473,17.33837 28.30983,33.61259 40.39083,60.66667 4.3318,9.70063 11.3922,30.52421 13.7883,40.66666 0.8662,3.66667 1.6708,12.42699 1.7879,19.46738 0.1845,11.09693 0.7157,13.82846 3.9906,20.52221 2.0778,4.24683 7.4421,11.54813 11.9207,16.22512 7.8042,8.14998 8.6095,8.61973 19.3642,11.29534 12.6483,3.1467 18.3035,2.84217 32.4559,-1.74769 17.3125,-5.61478 30.612,-22.1729 32.4725,-40.42903 1.5556,-15.26371 -6.853,-47.34674 -18.3846,-70.14675 -5.7082,-11.2861 -15.6836,-27.16462 -22.6963,-36.12738 -4.0902,-5.2276 -5.8453,-10.39253 -3.5314,-10.39253 0.7614,0 2.977,0.84026 4.9235,1.86724 1.9465,1.02698 7.439,3.49462 12.2057,5.48365 34.8937,14.5604 80.7788,43.04595 108.3639,67.27242 18.6795,16.40516 44.8026,42.84532 48.7586,49.35048 2.5411,4.17861 2.5651,4.59428 0.4477,7.77979 -3.5921,5.40431 -20.5129,37.35651 -35.5689,67.16612 -10.4875,20.76447 -14.5185,27.55634 -16.3005,27.46494 -5.8336,-0.2992 -39.0138,7.28647 -74.1774,16.95847 -4.2954,1.1815 -7.9439,1.96263 -8.1077,1.73586 -0.1638,-0.22677 -3.5022,-5.10277 -7.4188,-10.83555 -8.6145,-12.6094 -17.9607,-21.03224 -31.6913,-28.56042 -16.1203,-8.83837 -22.1462,-10.26188 -43.6389,-10.30886 -16.2026,-0.0354 -19.8108,0.36711 -27.3334,3.04936 -24.1344,8.60531 -47.64039,29.10322 -54.54907,47.56832 -4.57205,12.2199 -3.01655,21.00597 5.41468,30.58436 9.34658,10.61827 22.61969,13.69764 47.98869,11.13335 l 6.1876,-0.62544 -3.5209,2.92822 c -3.6071,2.99988 -21.9782,15.02554 -31.52097,20.63352 -7.97353,4.68579 -22.03011,15.03852 -40.66667,29.95117 -17.37478,13.903 -66.65869,62.10073 -81.19239,79.40298 -14.75342,17.56381 -39.19017,50.82375 -49.47117,67.33333 -5.48002,8.8 -10.42628,16.20124 -10.9917,16.44721 -0.56541,0.24597 -0.7275,0.93347 -0.3602,1.52778 0.36731,0.59431 -0.37895,2.34592 -1.65836,3.89247 l -2.32618,2.8119 -144.00001,0.32698 c -79.2,0.17985 -151.8,-0.0347 -161.33333,-0.47684 z M 629.07663,561.95268 c 3.79167,-1.126 11.41479,-4.48579 16.94027,-7.46619 5.52547,-2.98041 11.9821,-5.46312 14.34805,-5.51715 2.61517,-0.0597 9.3907,2.42278 17.28159,6.33182 11.02696,5.46262 14.4532,6.5246 22.77251,7.05851 17.763,1.13996 33.08158,-6.19488 42.47198,-20.33642 6.10732,-9.19736 6.11318,-16.8707 0.0221,-28.87119 -13.41264,-26.42502 -41.2495,-44.31162 -73.67383,-47.3392 -25.50651,-2.38162 -56.80972,12.07352 -76.18003,35.17829 -13.34739,15.92067 -18.05008,29.87159 -13.811,40.97147 2.92128,7.64926 13.66284,17.48689 21.20939,19.42457 3.04832,0.7827 6.14241,1.6434 6.87574,1.91267 3.40714,1.25105 15.52161,0.50046 21.74328,-1.34718 z"
		 id="path6"
		 sodipodi:nodetypes="sssssssssssssssssssssssssssssssscsssssssssssssssssssssssssssssscsssssssscssssssssssssssss" />
	      <path
		 style="fill:#dab991"
		 d="m 161.16326,1014.9949 c -1.65849,-2.1147 -1.61133,-2.1619 0.50341,-0.5034 2.221,1.7419 2.92731,2.8368 1.82993,2.8368 -0.27688,0 -1.32688,-1.05 -2.33334,-2.3334 z M 1826.3016,763.19579 c -13.7257,-19.90214 -27.1633,-38.74522 -37.4753,-51.41295 -4.3496,-5.34319 -8.7687,-8.37902 -9.4577,-9.44625 -2.0664,-3.20106 -2.6806,-5.03527 -6.6487,-8.17183 l -28.9551,-31.39729 c -9.489,-9.2718 -16.3492,-15.97013 -25.4996,-23.97083 -30.9229,-27.45247 -88.2825,-71.94892 -106.0972,-81.13332 -5.3778,-2.77254 -5.5233,-5.34914 -0.4214,-7.46243 4.75,-1.96752 9.6254,-2.23878 23.0119,3.24822 8.4815,3.47644 11.4639,5.26454 21.0762,5.2546 9.3471,-0.01 12.6466,-0.61529 18.8267,-3.45573 16.0738,-7.38768 25.1162,-20.80868 22.3411,-33.15955 -3.488,-15.52416 -20.3805,-33.88354 -39.9263,-43.39352 -19.3756,-9.42712 -23.8978,-10.53854 -42.5749,-10.46373 -26.616,0.10662 -42.2376,5.63038 -63.5231,22.46164 -10.0282,7.92966 -17.6077,16.72237 -22.3946,25.97919 -1.1829,2.28749 -3.1233,4.15907 -4.3119,4.15907 -1.1887,0 -7.8769,-1.8309 -14.8628,-4.06867 -47.6383,-15.25993 -104.2424,-25.41151 -159.5742,-28.61863 -18.9808,-1.10016 -18.5428,-0.92368 -15.5649,-6.27108 1.34,-2.40622 5.9489,-10.97495 10.2419,-19.04161 22.9935,-43.20508 47.2249,-75.40708 82.8304,-110.07655 29.0948,-28.32998 58.5591,-49.64807 91.2777,-66.04165 20.6198,-10.3315 55.7279,-22.47988 58.1027,-20.10512 0.4091,0.40911 -1.3686,3.32673 -3.9505,6.48358 -25.4097,31.06831 -44.804,72.37001 -46.6517,99.34845 -1.2237,17.86665 2.8443,29.80348 13.79,40.4649 17.6389,17.18084 41.0623,21.87218 59.6747,11.95187 11.4164,-6.08484 20.8502,-14.92856 25.0232,-23.45789 3.2763,-6.69656 3.5295,-8.27894 2.7671,-17.29803 -1.0419,-12.32563 1.0442,-22.92397 9.3045,-47.26956 12.7882,-37.69128 26.4585,-60.73203 48.6803,-82.04881 12.5784,-12.06605 28.2982,-23.78777 30.7883,-22.95773 1.2978,0.43261 1.6614,18.21093 1.6723,81.77966 0.016,93.24581 -0.7452,87.24959 12.6515,99.65262 11.8694,10.98895 27.1721,16.8559 39.1892,15.02484 12.5705,-1.91537 27.4527,-9.81474 35.2749,-18.72367 8.9647,-10.21027 8.8619,-9.64019 9.2678,-51.39357 0.2031,-20.9 -0.122,-57.2 -0.7226,-80.66667 -0.6006,-23.46666 -0.6858,-43.16772 -0.1893,-43.78012 1.2392,-1.52846 8.0845,2.19189 19.3582,10.521 27.0825,20.00864 48.7367,44.90761 61.1728,76.38428 8.7936,22.25742 13.5769,44.53942 14.6242,62.62853 0.945,16.32164 0.3067,13.68032 5.7077,21.35725 10.7874,15.33293 27.8612,24.62138 46.004,22.9438 24.4122,-2.25728 47.6824,-21.33464 49.9738,-43.53662 2.5138,-24.3566 -18.5778,-72.13095 -45.5106,-103.08547 -4.0999,-4.71205 -7.4543,-9.13873 -7.4543,-9.83708 0,-3.62337 33.6818,7.85357 56.0902,19.11253 28.0781,14.10766 67.4303,41.15309 94.3246,65.59249 19.8569,18.04438 45.4312,47.11098 62.3536,70.86829 48.698,68.36661 72.7303,143.41805 72.7303,227.13169 0,35.93568 -2.0686,48.61108 -11.6747,71.53496 -6.4186,15.31734 -14.2353,27.05819 -24.4628,36.74382 -10.3117,9.76525 -19.8769,15.37756 -33.1958,19.47731 l -10.6187,4.57482 -160.0509,0.98585 -162.0346,-1.8717 c -8.9661,-10.29535 -3.2605,-6.09325 -14.3276,-22.0476 z m 253.8596,-202.35196 c 12.3022,-4.60284 22.7642,-17.91053 22.7777,-28.97338 0.01,-7.96263 -7.7452,-22.92508 -18.2832,-35.2755 -17.0535,-19.98661 -41.3254,-25.07825 -69.6406,-25.11071 -25.7524,-0.0295 -52.4294,15.06516 -68.4994,36.37792 -7.0525,9.35331 -13.6547,16.35998 -13.633,21.70708 0.04,9.85913 8.0649,21.18866 20.6326,26.74797 13.8418,6.12286 26.039,6.8523 47.6195,-3.247 13.567,-6.3491 18.0045,-6.23263 31.7661,0.83373 19.1247,9.82029 33.8015,11.97549 47.2603,6.93989 z"
		 id="path5"
		 sodipodi:nodetypes="sssssssccsssscssssssssssssssssssssssssssssssssssssssssssssscccsssssssssss" />
	      <path
		 style="fill:#87d6be"
		 d="m 1841.3417,1187.531 c 2.1899,-3.043 5.4721,-7.3328 7.2938,-9.5328 4.8947,-5.9111 5.1964,-6.3408 7.2565,-10.3333 1.0406,-2.0167 2.3906,-3.6667 3,-3.6667 0.6094,0 1.1081,-0.6933 1.1081,-1.5408 0,-0.8474 1.5,-3.5074 3.3333,-5.911 1.8333,-2.4036 3.3333,-4.9674 3.3333,-5.6973 0,-0.7299 0.771,-2.1199 1.7132,-3.089 2.4055,-2.4739 19.6202,-37.4872 19.6202,-39.906 0,-1.094 0.72,-2.7092 1.6,-3.5892 0.88,-0.88 1.1065,-1.6 0.5034,-1.6 -0.6032,0 -0.3497,-0.9 0.5632,-2 0.9129,-1.1 1.317,-2 0.898,-2 -0.4191,0 0.1155,-2.1 1.188,-4.6667 1.0724,-2.5666 1.6206,-4.6666 1.2183,-4.6666 -0.4023,0 -0.1704,-1.05 0.5152,-2.3334 0.6857,-1.2833 1.5995,-4.4333 2.0306,-7 0.7515,-4.4741 1.3088,-7.3749 2.8175,-14.6666 0.3794,-1.8334 1.0182,-6.0334 1.4197,-9.3334 0.4015,-3.3 1.4461,-6.6857 2.3214,-7.5237 1.7145,-1.6418 266.0673,-166.9899 274.9247,-171.96072 2.9333,-1.64621 9.2333,-4.32008 14,-5.94195 9.5431,-3.24708 32.4075,-14.39012 33.1111,-16.13682 0.2444,-0.60689 1.2119,-1.10343 2.15,-1.10343 1.4173,0 6.4291,-3.38389 13.4055,-9.05131 0.7334,-0.59574 2.3834,-1.48407 3.6667,-1.97407 1.2833,-0.49001 2.3333,-1.50975 2.3333,-2.2661 0,-0.75635 0.6911,-1.37518 1.5357,-1.37518 1.5289,0 10.0222,-7.71809 16.8694,-15.32956 1.9772,-2.19792 6.2949,-6.77065 9.5949,-10.16161 3.3,-3.39096 7.5,-8.0316 9.3334,-10.31253 1.8333,-2.28093 4.9738,-6.05561 6.9788,-8.38818 2.0051,-2.33256 3.9955,-5.34363 4.4232,-6.69124 0.4277,-1.34762 1.3372,-2.45021 2.0212,-2.45021 0.6839,0 1.2434,-0.9 1.2434,-2 0,-1.1 0.6,-2 1.3334,-2 0.7333,0 1.3333,-0.8082 1.3333,-1.79599 0,-0.98779 1.1903,-3.16845 2.6452,-4.8459 1.4548,-1.67745 3.3754,-5.06925 4.2678,-7.53734 0.8925,-2.46809 2.1376,-4.48744 2.7669,-4.48744 0.6293,0 0.7733,-0.6 0.3201,-1.33333 -0.4532,-0.73334 -0.089,-1.33334 0.8102,-1.33334 0.8988,0 1.2628,-0.37142 0.8088,-0.82539 -0.4539,-0.45397 0.052,-1.70234 1.1234,-2.77416 1.0718,-1.07182 1.6079,-2.50039 1.1912,-3.1746 -0.4167,-0.67422 -0.087,-1.22584 0.7331,-1.22584 0.8199,0 1.1498,-0.55163 0.7331,-1.22585 -0.4167,-0.67421 0.1907,-2.17421 1.3499,-3.33333 1.1591,-1.15912 1.6911,-2.10749 1.1823,-2.10749 -0.5089,0 -0.2569,-0.80521 0.5598,-1.78935 0.8168,-0.98414 1.0903,-2.18414 0.6077,-2.66666 -0.4825,-0.48253 -0.1773,-0.87732 0.6783,-0.87732 0.8555,0 1.4586,-0.45 1.3402,-1 -0.1184,-0.55 0.5412,-2.8 1.4658,-5 0.9245,-2.2 1.8755,-4.9 2.1132,-6 0.2378,-1.1 0.5532,-2.15 0.701,-2.33334 0.1478,-0.18333 0.3955,-0.78333 0.5505,-1.33333 0.155,-0.55 0.7262,-2.00315 1.2694,-3.22921 0.5431,-1.22607 1.1954,-3.32607 1.4495,-4.66667 0.254,-1.3406 0.5828,-2.58745 0.7306,-2.77079 0.1478,-0.18333 0.4187,-0.93333 0.602,-1.66666 0.1833,-0.73334 0.4833,-1.63334 0.6667,-2 0.1833,-0.36667 0.4833,-1.26667 0.6666,-2 0.1834,-0.73334 0.4543,-1.48334 0.6021,-1.66667 0.1477,-0.18333 0.4877,-1.23333 0.7553,-2.33333 0.2677,-1.1 0.8218,-3.35 1.2314,-5 1.9032,-7.66823 2.2637,-9.21571 2.873,-12.33333 0.3583,-1.83334 0.6641,-4.37152 0.6797,-5.64042 0.015,-1.26889 0.59,-2.6543 1.2767,-3.07869 0.6867,-0.42438 1.2485,-2.7362 1.2485,-5.13736 0,-4.96007 1.0884,-6.6457 3.2107,-4.9724 0.8008,0.63141 3.856,1.88759 6.7893,2.79152 8.9928,2.7712 61.3334,29.01328 79.1617,39.68945 41.6724,24.95468 64.777,42.04199 86.885,64.25684 18.3033,18.39183 33.5141,39.29786 38.5089,52.92763 1.5781,4.30654 3.2469,8.73008 3.7084,9.83008 0.4615,1.1 0.9144,2.3 1.0066,2.66667 5.4056,21.50317 5.429,21.87448 2.6018,41.33333 -0.3729,2.56667 -0.7285,5.56667 -0.7903,6.66667 -0.062,1.1 -0.6821,2.72371 -1.3786,3.60826 -0.6965,0.88454 -0.905,2.19308 -0.4632,2.90787 0.4418,0.71478 0.1836,1.68252 -0.5736,2.15053 -0.7573,0.46801 -1.0317,1.40947 -0.6098,2.09213 0.422,0.68267 0.1317,1.24121 -0.6449,1.24121 -0.7766,0 -1.412,0.67497 -1.412,1.49994 0,1.96902 -6.8527,17.26467 -8.8857,19.83339 -0.8706,1.1 -4.8278,6.8 -8.7939,12.66666 -10.9374,16.17881 -18.1757,24.00929 -38.8242,42 -6.3125,5.5 -11.4815,10.45 -11.4867,11 -0.01,0.55 -0.8797,1 -1.9432,1 -1.0636,0 -2.4136,0.76441 -3,1.69868 -0.5865,0.93427 -2.5663,2.66508 -4.3996,3.84625 -1.8334,1.18117 -4.6472,3.26676 -6.2531,4.63466 -6.8317,5.81937 -43.5573,29.82037 -45.6303,29.82037 -0.7975,0 -1.45,0.4795 -1.45,1.0655 0,0.586 -1.9662,1.7765 -4.3693,2.6455 -2.4031,0.869 -5.5531,2.4773 -7,3.5742 -3.1094,2.3571 -44.7333,23.0509 -55.2973,27.4917 -4.0334,1.6955 -7.7742,3.7143 -8.3129,4.4862 -0.5388,0.772 -0.9888,0.9382 -1,0.3694 -0.011,-0.5689 -1.9705,0 -4.3538,1.2605 -2.3833,1.2622 -4.9333,2.4048 -5.6667,2.5391 -0.7333,0.1343 -5.2333,2.0409 -10,4.2369 -8.3068,3.827 -12.2165,5.3964 -14.3473,5.7594 -0.5423,0.092 -2.186,0.8362 -3.6527,1.6531 -1.4666,0.8168 -3.1166,1.3576 -3.6666,1.2018 -0.55,-0.1558 -1,0.4167 -1,1.2723 0,0.8555 -0.3948,1.1608 -0.8774,0.6782 -0.4825,-0.4825 -1.6825,-0.209 -2.6666,0.6077 -0.9842,0.8168 -1.7894,1.0905 -1.7894,0.6082 0,-0.4822 -1.35,-0.127 -3,0.7895 -1.65,0.9165 -3.4,1.6876 -3.8889,1.7136 -0.4888,0.026 -1.3388,0.4972 -1.8888,1.0472 -0.55,0.55 -1.761,1 -2.691,1 -0.9301,0 -3.3801,0.6998 -5.4445,1.555 -2.0644,0.8552 -4.2034,1.6802 -4.7534,1.8333 -0.55,0.1531 -1.3,0.4284 -1.6667,0.6117 -0.3667,0.1834 -1.1167,0.4176 -1.6667,0.5205 -0.55,0.1028 -1.75,0.6633 -2.6666,1.2453 -0.9167,0.5821 -1.6667,0.7356 -1.6667,0.3412 0,-0.581 -10.239,2.7355 -21.3333,6.9102 -1.1,0.4139 -2.45,0.8793 -3,1.0343 -0.55,0.155 -1.3,0.4319 -1.6667,0.6152 -0.3667,0.1833 -1.2667,0.4833 -2,0.6667 -0.7333,0.1833 -1.4833,0.4529 -1.6667,0.599 -0.1833,0.1462 -1.8333,0.5282 -3.6666,0.8489 -1.8334,0.3207 -4.2334,0.9743 -5.3334,1.4524 -1.1,0.4782 -2.45,0.9962 -3,1.1512 -0.55,0.155 -1.15,0.4014 -1.3333,0.5475 -0.1833,0.1462 -1.8333,0.5282 -3.6667,0.8489 -1.8333,0.3207 -4.2333,0.9667 -5.3333,1.4356 -2.0891,0.8906 -3.7625,1.403 -7.6667,2.3478 -1.2833,0.3105 -2.4833,0.6855 -2.6666,0.8333 -0.1834,0.1478 -0.9334,0.4187 -1.6667,0.602 -0.7333,0.1834 -1.4833,0.4577 -1.6667,0.6097 -0.1833,0.1519 -2.1183,0.5656 -4.3001,0.9191 -2.1817,0.3536 -4.7317,1.2777 -5.6666,2.0536 -0.935,0.776 -1.6999,1.0522 -1.6999,0.6139 0,-0.4383 -1.65,-0.1585 -3.6667,0.6218 -2.0167,0.7803 -4.8667,1.7005 -6.3333,2.0449 -5.4647,1.2833 -6.675,1.6063 -7,1.8684 -0.4,0.3223 -0.8351,0.4237 -7.6565,1.7832 -2.9278,0.5835 -5.9278,1.4395 -6.6667,1.9023 -0.7389,0.4628 -2.2435,1.0304 -3.3435,1.2612 -3.2917,0.6909 -6,1.438 -6,1.6553 0,0.1122 -0.9,0.423 -2,0.6907 -1.1,0.2677 -3.35,0.8218 -5,1.2313 -1.65,0.4096 -4.35,1.0797 -6,1.4892 -1.65,0.4096 -3.9,0.9637 -5,1.2314 -1.1,0.2677 -2,0.5819 -2,0.6983 0,0.1164 -1.8,0.4916 -4,0.8337 -2.2,0.3421 -6.4,1.2938 -9.3333,2.1149 -2.9334,0.8212 -5.9334,1.6568 -6.6667,1.8571 -3.2443,0.886 -8.2633,2.0384 -11.3333,2.6023 -1.8334,0.3367 -4.8334,0.9997 -6.6667,1.4735 -5.8947,1.5231 -7.2827,1.8537 -10,2.382 -1.4667,0.2852 -4.1667,0.8966 -6,1.3587 -1.8333,0.4621 -4.5333,1.1045 -6,1.4275 -1.4667,0.323 -4.1667,0.9246 -6,1.3368 -1.8333,0.4123 -4.8333,1.0189 -6.6667,1.348 -4.1217,0.74 -7.667,1.4786 -12,2.4998 -1.8333,0.4321 -4.8333,1.0732 -6.6666,1.4248 -1.8334,0.3515 -4.8334,0.9515 -6.6667,1.3333 -1.8333,0.3818 -4.8333,0.9853 -6.6667,1.3411 -1.8333,0.3558 -5.1333,1.0039 -7.3333,1.4402 -2.2,0.4363 -5.3516,1.0243 -7.0036,1.3067 -6.6638,1.1392 -13.9183,2.5468 -20.3297,3.9445 -1.8334,0.3997 -5.4334,1.045 -8,1.434 -8.5612,1.2976 -11.3084,1.767 -14.6667,2.5059 -3.3259,0.7317 -9.6891,1.8157 -16,2.7256 -1.8333,0.2644 -4.8333,0.77 -6.6667,1.1236 -1.8333,0.3536 -5.7333,1.0309 -8.6666,1.5051 -2.9334,0.4741 -6.8334,1.1136 -8.6667,1.4211 -1.8333,0.3074 -5.4333,0.8502 -8,1.2062 -2.5667,0.3559 -6.4667,0.9505 -8.6667,1.3213 -2.2,0.3707 -6.1,1.012 -8.6666,1.4251 -2.5667,0.4131 -6.1667,1.0055 -8,1.3165 -8.8098,1.4943 -16.1531,2.6073 -26.6667,4.0418 -2.5667,0.3501 -6.7667,0.9362 -9.3333,1.3024 -4.2256,0.6028 -9.8814,1.2562 -22.32,2.5785 l -4.32,0.4592 z m -1040.62257,-4.7813 c -0.42439,-0.6866 -1.8098,-1.2566 -3.07869,-1.2665 -3.84684,-0.03 -25.3238,-3.7892 -42.80591,-7.4922 -9.07435,-1.9221 -18.07435,-3.7317 -20,-4.0214 -1.92565,-0.2897 -8.90118,-1.7775 -15.50118,-3.3062 -29.80563,-6.9035 -33.45029,-7.7033 -35.33333,-7.7537 -1.1,-0.029 -5.3,-0.9561 -9.33333,-2.0592 -4.03334,-1.1032 -9.13334,-2.322 -11.33334,-2.7085 -2.2,-0.3865 -19.89281,-4.6525 -39.31737,-9.48 -19.42455,-4.8276 -36.22455,-8.9617 -37.33333,-9.1869 -1.10878,-0.2253 -2.91597,-0.7824 -4.01597,-1.238 -1.1,-0.4556 -3.5,-1.1161 -5.33333,-1.4676 -1.83333,-0.3515 -7.1698,-1.84 -11.85882,-3.3078 -4.68902,-1.4678 -8.88902,-2.6023 -9.33333,-2.5211 -0.44432,0.081 -1.70785,-0.216 -2.80785,-0.6606 -4.62278,-1.868 -16,-4.7455 -16,-4.0466 0,0.4169 -0.76495,0.1232 -1.6999,-0.6528 -0.93494,-0.7759 -3.18494,-1.6146 -5,-1.8637 -1.81505,-0.2491 -4.0501,-0.9231 -4.96677,-1.4978 -0.91666,-0.5747 -1.66666,-0.636 -1.66666,-0.1363 0,0.4997 -0.9,0.1617 -2,-0.7512 -1.1,-0.913 -2,-1.2653 -2,-0.783 0,0.4822 -1.10718,0.2842 -2.4604,-0.44 -1.35322,-0.7242 -4.20322,-1.6768 -6.33334,-2.1169 -5.24896,-1.0846 -7.87293,-1.749 -7.87293,-1.9935 0,-0.1122 -0.9,-0.4062 -2,-0.6534 -1.1,-0.2471 -4.55,-1.3746 -7.66667,-2.5055 -3.11667,-1.1308 -5.66667,-1.7093 -5.66667,-1.2853 0,0.4239 -0.75,0.1483 -1.66666,-0.6125 -0.91667,-0.7607 -1.96667,-1.392 -2.33334,-1.4028 -0.36666,-0.011 -2.35572,-0.6618 -4.42013,-1.4467 -2.06441,-0.7849 -4.79441,-1.4271 -6.06667,-1.4271 -1.27226,0 -3.0332,-0.72 -3.9132,-1.6 -0.88,-0.88 -1.6,-1.1065 -1.6,-0.5034 0,0.6031 -0.9,0.3497 -2,-0.5633 -1.1,-0.9129 -2,-1.2129 -2,-0.6666 0,0.5462 -0.9,0.2462 -2,-0.6667 -1.1,-0.9129 -2,-1.2129 -2,-0.6667 0,0.5463 -0.75,0.3979 -1.66666,-0.3296 -1.3918,-1.1047 -9.76484,-4.3158 -13.33334,-5.1135 -0.55,-0.1229 -1.3,-0.3735 -1.66666,-0.5569 -0.36667,-0.1833 -1.26667,-0.4833 -2,-0.6666 -0.73334,-0.1834 -1.63334,-0.4834 -2,-0.6667 -0.36667,-0.1833 -1.11667,-0.4296 -1.66667,-0.5472 -0.55,-0.1177 -2.35,-0.9638 -4,-1.8803 -1.65,-0.9165 -3,-1.3314 -3,-0.922 0,0.4094 -1.35,-0.1402 -3,-1.2214 -1.65,-1.0811 -3.6,-2.0668 -4.33333,-2.1904 -0.73334,-0.1237 -2.7224,-0.753 -4.42014,-1.3984 -1.69774,-0.6455 -3.65588,-1.1736 -4.35142,-1.1736 -1.2999,0 -2.77006,-0.6536 -10.19543,-4.5322 -2.36518,-1.2354 -4.76518,-2.293 -5.33334,-2.3501 -0.56815,-0.057 -2.53301,-0.7317 -4.36634,-1.4991 -1.83333,-0.7673 -3.63334,-1.4667 -4,-1.5542 -0.36667,-0.087 -2.16667,-0.9891 -4,-2.0037 -1.83334,-1.0145 -3.63334,-1.8076 -4,-1.7623 -0.36667,0.045 -3.06667,-1.1421 -6,-2.6385 -2.93334,-1.4965 -5.47077,-2.6596 -5.63875,-2.5847 -1.12888,0.5033 -48.83201,-22.5658 -52.02792,-25.1605 -0.91667,-0.7443 -1.67585,-0.8795 -1.68708,-0.3006 -0.0112,0.5789 -0.46123,0.3831 -1,-0.435 -1.16667,-1.7717 -12.54627,-7.835 -13.97959,-7.4487 -0.55,0.1483 -1,-0.194 -1,-0.7606 0,-0.5665 -2.25,-2.2108 -5,-3.6539 -2.75,-1.443 -5.3,-2.9295 -5.66666,-3.3032 -1.46858,-1.4967 -21.18697,-14.6794 -21.95711,-14.6794 -0.45427,0 -2.44363,-1.5 -4.4208,-3.3333 -1.97716,-1.8334 -4.0763,-3.33336 -4.66475,-3.33336 -1.2055,0 -2.3274,-0.8488 -8.95735,-6.77684 -2.56666,-2.29494 -6.16666,-5.16934 -8,-6.38756 -6.61053,-4.39259 -36,-32.61488 -36,-34.5703 0,-0.61475 -1.42543,-2.35714 -3.16764,-3.87196 -1.7422,-1.51483 -4.27156,-4.62303 -5.62081,-6.90712 -1.34924,-2.28408 -2.9238,-4.15288 -3.49902,-4.15288 -0.57523,0 -1.04586,-0.9 -1.04586,-2 0,-1.1 -0.6,-2 -1.33333,-2 -0.73334,0 -1.33334,-0.9 -1.33334,-2 0,-1.1 -0.6,-2 -1.33333,-2 -0.73333,0 -1.33333,-0.85714 -1.33333,-1.90476 0,-1.04762 -0.75,-2.69762 -1.66667,-3.66667 -2.06162,-2.17942 -6.90103,-12.06545 -6.57357,-13.42857 0.13213,-0.55 -0.45976,-1 -1.31532,-1 -0.85556,0 -1.16076,-0.3948 -0.67823,-0.87732 0.48252,-0.48253 0.20905,-1.68253 -0.60771,-2.66667 -0.81676,-0.98414 -1.09045,-1.78934 -0.60819,-1.78934 0.48226,0 0.13459,-1.35 -0.77261,-3 -0.9072,-1.65 -1.7821,-3.79686 -1.94422,-4.77079 -0.16212,-0.97393 -0.72428,-2.77393 -1.24925,-4 -2.81086,-6.56478 -3.66718,-23.04513 -1.86696,-35.93076 2.16992,-15.53186 2.13794,-15.34349 2.99413,-17.63178 0.98473,-2.63182 5.47988,-16.47747 5.62747,-17.33334 0.18164,-1.05333 5.65306,-10.81533 9.34136,-16.66666 1.84898,-2.93333 3.72231,-6.38333 4.16295,-7.66667 0.44064,-1.28333 1.33119,-2.33333 1.97899,-2.33333 0.6478,0 1.17783,-0.9 1.17783,-2 0,-1.1 0.6,-2 1.33333,-2 0.73333,0 1.33333,-0.61622 1.33333,-1.36938 0,-0.75316 1.95,-3.45396 4.33334,-6.00179 12.82817,-13.71354 26.21007,-27.02135 30.12898,-29.96216 7.45965,-5.59784 11.04235,-8.56049 13.30218,-11 1.18881,-1.28333 2.94697,-2.33333 3.90701,-2.33333 0.96003,0 2.09088,-0.9 2.51299,-2 0.42211,-1.1 1.53909,-2 2.48217,-2 0.94308,0 2.06006,-0.9 2.48217,-2 0.42211,-1.1 1.6863,-2 2.80932,-2 1.12301,0 2.04184,-0.46356 2.04184,-1.03013 0,-0.56657 2.1,-2.16105 4.66667,-3.5433 2.56667,-1.38224 4.66667,-3.01868 4.66667,-3.63653 0,-0.61786 0.9,-1.12338 2,-1.12338 1.1,0 2,-0.6 2,-1.33333 0,-0.73333 0.9,-1.33333 2,-1.33333 1.1,0 2,-0.6 2,-1.33334 0,-0.73333 0.9,-1.33333 2,-1.33333 1.1,0 2,-0.6 2,-1.33333 0,-0.73334 0.62532,-1.33334 1.38961,-1.33334 0.76428,0 2.11428,-0.60845 3,-1.35211 3.2811,-2.75487 11.8188,-8.00002 23.61258,-14.50641 11.83474,-6.52899 13.13503,-6.67549 13.09015,-1.47481 -0.0195,2.25714 1.01675,9.67195 2.32984,16.67134 0.48407,2.5803 1.42189,5.02628 2.08405,5.43552 0.66217,0.40924 0.87056,1.28348 0.4631,1.94277 -2.49644,4.03932 17.94512,48.20341 31.45116,67.95037 28.17876,41.19972 72.83667,68.51908 118.1205,81.70878 11.63593,3.38916 17.62404,12.46543 142.27393,89.62454 72.26631,44.73329 131.7521,82.35249 132.19063,83.59809 0.43852,1.2457 1.04201,4.8457 1.34107,8 1.31726,13.8937 2.21428,19.0152 5.82632,33.2649 4.97889,19.642 12.05457,38.5181 20.66802,55.137 9.02038,17.4041 19.71706,35.3333 21.08,35.3333 0.59348,0 1.07905,0.9 1.07905,2 0,1.1 0.67347,2 1.4966,2 1.03401,0 0.98354,0.6182 -0.16326,2 -1.9013,2.291 -3.50173,2.5516 -4.61423,0.7515 z M 497.08335,879.08913 c 0.9625,-0.38516 2.1125,-0.33779 2.55555,0.10526 0.44306,0.44306 -0.34444,0.75819 -1.75,0.70029 -1.55325,-0.064 -1.8692,-0.37992 -0.80555,-0.80555 z"
		 id="path4"
		 sodipodi:nodetypes="ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssscsssssssscssssssssssscssssssssssscssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssscsssssscsssssssscsssssssssssssssssssssssssssssssssssssscscsssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss" />
	      <path
		 id="path3"
		 style="fill:#79c0ab"
		 d="m 2179.0006,872.53256 c -22.9654,5.27761 -20.0386,5.17311 -160.9512,5.73633 -131.3422,0.52497 -140.9237,0.82571 -138.7422,4.35547 1.5019,2.43007 9.0056,33.44529 13.2363,54.70898 6.0424,30.36829 9.2162,66.75266 8.375,95.99996 -0.3481,12.1 -0.2202,20.5034 0.2832,18.6739 0.7308,-2.6557 28.3242,-20.4813 136.8575,-88.41019 74.7676,-46.79563 137.8901,-86.06006 140.2734,-87.2539 5.2854,-2.64758 5.6922,-4.96517 0.668,-3.81055 z m -1687.24027,5.31836 c -0.79174,-0.48932 -1.21206,-0.23502 -0.93359,0.56445 0.27847,0.79947 59.60671,38.09217 131.83984,82.87305 123.21818,76.38898 131.35996,81.66758 131.75195,85.40038 0.97634,9.2973 1.39426,2.3175 1.38086,-23.0215 -0.0122,-23.1472 1.44243,-48.18859 3.34961,-57.66794 0.29509,-1.46666 0.94792,-5.36602 1.45118,-8.66602 1.80239,-11.81897 7.47657,-39.64156 11.5957,-56.86523 2.30616,-9.64299 3.82349,-18.49407 3.37305,-19.66797 -0.74391,-1.9386 -13.73017,-2.13011 -141.59375,-2.09571 -77.42612,0.0208 -141.42312,-0.36419 -142.21485,-0.85351 z"
		 sodipodi:nodetypes="ssssssssssssssssssss" />
	      <path
		 id="path2"
		 style="fill:#091a28"
		 d="m 886.36385,130.80014 c -87.24656,1.12056 -190.25283,27.35813 -266.56641,69.16992 -70.01526,38.36098 -129.70311,89.13185 -181.06641,154.01562 -18.83223,23.78949 -34.23254,48.98963 -55.41601,90.68164 -26.32141,51.8042 -41.56924,95.4066 -52.09961,148.97657 -1.26782,6.4496 -3.24036,12.48858 -4.41992,13.53515 -1.17129,1.03924 -6.02826,3.51921 -10.79492,5.51172 -4.76667,1.99251 -15.26734,6.91746 -23.33399,10.94531 -101.19333,50.52804 -175.3774,126.11317 -193.36328,197.01563 -14.410562,56.80811 -1.130307,112.63637 39.5957,166.46094 44.32346,58.57906 132.76157,116.48606 245.08985,160.47856 24.03858,9.4145 100.67685,35.5629 129.34375,44.1308 81.53604,24.3692 176.32422,45.605 289.44922,64.8477 73.06887,12.4291 193.38686,26.9743 271.21878,32.7871 77.8682,5.8155 141.7043,10.0079 180.666,11.8633 120.4444,5.7361 427.776,-2.1521 693.334,-48.6289 104.3413,-18.2614 174.4107,-34.0107 249.332,-56.043 88.426,-26.0036 144.3149,-47.3548 207.334,-79.209 84.6937,-42.8101 134.8208,-77.7466 172.8672,-120.47852 51.8974,-58.28886 68.2412,-111.66696 52.5195,-171.52734 -7.0838,-26.97176 -15.2836,-44.43435 -32.6992,-69.63281 -13.7107,-19.83784 -49.8888,-56.96471 -72.6875,-74.59375 -44.5888,-34.47833 -95.6059,-61.81388 -162.666,-87.15821 -13.2,-4.98872 -24.71,-9.60767 -25.5762,-10.26367 -0.8662,-0.656 -2.2293,-4.24425 -3.0293,-7.97461 -2.041,-9.51674 -9.9797,-37.435 -15.625,-54.94726 -20.3229,-63.04356 -56.3847,-127.60406 -102.3691,-183.26563 -13.3344,-16.14048 -50.3236,-53.26468 -68.7344,-68.98633 -65.1982,-55.67507 -139.9263,-94.461 -226.6836,-117.65234 -16.5602,-4.42675 -61.9101,-13.25317 -84.6504,-16.47656 -18.9105,-2.68052 -26.6333,-3.02358 -68,-3.01758 -36.8674,0.005 -50.7264,0.50954 -66,2.40625 -130.549,16.21178 -237.5616,63.59697 -326,144.35352 -6.6,6.0267 -20.0895,19.1151 -29.9785,29.08398 -9.8891,9.96887 -18.3968,18.125 -18.9063,18.125 -0.5095,0 -13.4193,-12.47911 -28.6875,-27.73047 -36.6502,-36.60997 -65.4466,-59.31186 -105.2851,-83.00391 -80.3478,-47.78304 -169.2502,-75.03634 -269.80862,-82.71289 -11.69682,-0.89292 -23.83894,-1.24601 -36.30273,-1.08593 z m 832.58205,100.70507 c 0.5796,0.35823 1.068,37.36689 1.084,82.24024 0.033,93.05832 -0.6578,87.28761 11.9023,99.52148 13.8999,13.53888 32.9358,18.15793 49.7422,12.06836 15.0999,-5.47119 26.7818,-15.06206 31.4102,-25.78711 1.2262,-2.84167 1.6264,-22.71213 1.6054,-79.77929 -0.015,-41.798 -0.4043,-78.34618 -0.8633,-81.2168 -1.0684,-6.68148 0.4608,-6.74499 10.918,-0.45313 25.0212,15.05475 47.4553,39.79271 61.5899,67.91211 11.6172,23.11156 20.1686,52.98412 21.5839,75.40235 0.8431,13.35591 1.4806,16.34535 4.7676,22.38476 4.8165,8.84937 13.4086,16.78646 23.0801,21.32032 6.6877,3.13506 9.193,3.54882 21.5664,3.54882 13.004,0 14.6467,-0.30699 23.0703,-4.29687 12.2559,-5.80504 23.5069,-17.07538 27.3809,-27.42969 3.5163,-9.39805 3.7902,-22.42413 0.7539,-35.77344 -2.4497,-10.77066 -10.6492,-31.57802 -16.711,-42.40625 -6.3768,-11.39096 -20.8334,-31.95286 -28.0312,-39.86914 -3.5543,-3.90908 -6.4629,-7.5681 -6.4629,-8.13281 0,-3.86481 35.0194,7.98514 58.1836,19.68945 65.3365,33.01311 130.3867,94.15984 171.1582,160.88477 35.4994,58.09687 54.1971,121.44075 56.8926,192.75 1.433,37.90853 -2.7339,62.45486 -14.877,87.6543 -14.311,29.69823 -34.4113,46.17068 -64.0234,52.46679 -6.1975,1.31772 -40.7458,1.71366 -153.334,1.75586 -79.9332,0.03 -150.8836,-0.12107 -157.668,-0.33593 -11.8016,-0.37376 -12.4308,-0.54773 -14.5312,-4.00782 -19.1772,-31.59044 -51.6906,-74.25707 -80.2149,-105.26562 -30.1166,-32.73959 -83.0058,-76.46182 -133.4004,-110.27735 -9.6343,-6.46482 -17.5178,-12.12583 -17.5078,-12.58007 0.019,-1.47437 7.088,-4.16016 10.9512,-4.16016 2.0696,0 9.2988,2.16519 16.0664,4.81055 11.5753,4.52466 13.0159,4.77565 24.3047,4.24609 9.1489,-0.42918 13.4255,-1.29777 18,-3.6543 15.2631,-7.8628 22.2246,-17.8536 20.9355,-30.04882 -1.6355,-15.47315 -18.6076,-34.73082 -39.6425,-44.98243 -18.4534,-8.99345 -26.1083,-10.94306 -42.625,-10.85156 -27.4354,0.15199 -49.24,8.99095 -69.8243,28.30664 -6.0061,5.63607 -16.8437,19.98344 -16.8437,22.29883 0,3.24483 -4.0463,2.89069 -18.1758,-1.58789 -50.3293,-15.9527 -94.8371,-23.5874 -169.5801,-29.08594 -8.3818,-0.61661 -9.3811,-1.32244 -7.082,-5.0039 0.9495,-1.52041 5.0404,-9.14322 9.0918,-16.93946 8.2685,-15.91177 14.0367,-25.88292 22.7871,-39.39258 48.9523,-75.57762 127.5519,-138.46488 196.7754,-157.43945 6.7011,-1.83681 12.935,-3.34127 13.8516,-3.3418 2.9281,-0.002 1.8083,2.76233 -3.6153,8.92383 -14.6691,16.665 -31.7772,47.47463 -40.207,72.40821 -3.8738,11.45795 -4.2932,14.25771 -4.3965,29.33398 -0.1071,15.62702 0.1081,17.08953 3.4668,23.45508 4.4811,8.49257 16.0477,19.18394 26.086,24.11328 6.9335,3.40477 9.0041,3.76562 21.666,3.76562 13.4562,0 14.3108,-0.17614 22,-4.52539 9.9428,-5.62391 17.2937,-11.8318 21.8066,-18.41406 3.1997,-4.66694 3.5348,-6.51434 4.2969,-23.72851 0.8075,-18.24269 1.0009,-19.17967 8.4844,-41.28321 12.6959,-37.49976 22.3677,-55.71089 40.4961,-76.25 13.1379,-14.88511 38.6301,-34.95789 41.8613,-32.96094 z m -771.01174,0.84766 c 5.47238,0.53912 24.03142,14.14151 38.76367,28.91211 22.63277,22.69165 38.39617,49.55347 49.72267,84.73438 5.811,18.04952 6.6014,22.20248 6.9082,36.27148 0.256,11.74445 0.7941,14.61851 3.9277,21.02344 4.608,9.41826 14.8545,19.9838 23.0528,23.76953 5.3493,2.47018 8.6818,2.93145 21.0234,2.90625 13.1929,-0.0269 15.4105,-0.39192 22.0625,-3.63477 4.0674,-1.9828 10.1839,-6.27765 13.5918,-9.54297 11.5447,-11.0617 15.295,-23.0917 12.9883,-41.65429 -3.853,-31.00648 -19.9477,-67.20504 -42.3086,-95.1543 -7.9747,-9.96777 -10.2532,-14.38483 -6.666,-12.92187 0.9167,0.37382 7.3653,2.96117 14.332,5.75 34.6956,13.889 78.9639,39.44466 104.0664,60.07812 20.3696,16.74314 61.4159,57.24636 65.2227,64.35938 1.2399,2.31674 1.1722,3.53808 -0.3204,5.83984 -4.3016,6.63401 -28.1871,51.18636 -40.5195,75.57812 l -10.4492,20.66602 -10.666,1.63281 c -5.8667,0.89852 -22.6674,4.70597 -37.334,8.45899 -14.6667,3.75301 -29.3236,7.49359 -32.5723,8.3125 -4.6183,1.16413 -6.0285,1.12328 -6.4648,-0.18555 -2.5058,-7.51727 -19.3039,-26.90811 -29.2227,-33.73242 -17.3392,-11.92969 -34.5986,-16.60887 -56.9941,-15.45508 -22.75,1.17206 -43.2295,10.5479 -60.2754,27.59375 -22.79387,22.79387 -23.13742,47.3362 -0.81445,58.25781 10.29098,5.03491 25.46565,5.84105 38.17775,2.02735 8.6232,-2.58702 12.834,-2.64831 12.834,-0.18555 0,0.60824 -8.1356,6.39413 -18.0782,12.85742 -9.9425,6.46329 -24.1919,15.74805 -31.66597,20.63281 -22.25649,14.54599 -48.01298,36.20514 -75.05079,63.11328 -28.38476,28.24866 -41.53841,43.20816 -62.14257,70.67188 -15.80344,21.06472 -26.8033,37.60614 -34.51563,51.9043 -5.15609,9.55907 -5.36655,9.75427 -11.41992,10.58398 -9.37587,1.2851 -304.12882,0.70025 -312.03125,-0.61914 -18.29786,-3.05501 -36.74709,-13.38738 -50.57813,-28.32617 -21.24398,-22.94547 -31.66366,-52.36305 -31.48242,-88.87695 0.22453,-45.23271 14.27018,-105.39262 37.16797,-159.20118 19.28719,-45.32385 48.96388,-91.03299 84.05664,-129.46484 45.03541,-49.32054 101.23745,-87.49692 156.32227,-106.18359 6.18756,-2.09903 11.43887,-3.81641 11.66797,-3.81641 1.73097,0 -0.34353,5.35915 -4.06055,10.48828 -7.51161,10.36531 -19.33566,31.41137 -25.74805,45.83399 -12.84267,28.88546 -16.71983,59.0992 -9.5625,74.5039 14.91394,32.09921 56.43504,40.45817 81.5293,16.41211 11.94178,-11.44297 13.21876,-14.44149 14.32617,-33.62305 0.5625,-9.74317 2.23937,-22.05061 3.94531,-28.94921 8.60402,-34.79352 29.48103,-74.92255 49.6211,-95.38282 10.79051,-10.96204 34.8626,-27.89599 36.84375,-25.91797 0.47014,0.4694 1.15482,37.85521 1.52148,83.07813 l 0.66602,82.22266 3.79883,6.46289 c 4.91087,8.35485 12.14862,15.31217 21.07031,20.2539 6.63317,3.67413 8.10842,3.95117 21.13086,3.95117 12.39874,0 14.87291,-0.40951 21.625,-3.57421 9.63927,-4.51792 20.68131,-14.71739 24.00976,-22.17774 2.44178,-5.47299 2.56467,-9.65984 2.53907,-86.66601 -0.0148,-44.50365 0.40361,-81.9856 0.93164,-83.29297 0.19824,-0.49085 0.71432,-0.68054 1.49609,-0.60352 z M 2017.3326,467.6224 c -11.5397,0.06 -15.8738,0.70221 -24.666,3.66016 -18.1852,6.11806 -28.2118,12.19187 -40.7461,24.67969 -19.2175,19.14624 -24.3212,33.91873 -16.1582,46.77734 5.9804,9.42053 14.9504,15.4495 26.9043,18.08594 4.0334,0.88955 8.5568,1.66701 10.0527,1.72851 4.7109,0.19354 16.8925,-3.52853 27.6738,-8.45703 16.6787,-7.6243 18.3413,-7.59096 35.8809,0.70508 14.4347,6.82745 15.5994,7.14385 28.0625,7.64844 11.9764,0.48488 13.58,0.24406 20.3184,-3.05274 7.5102,-3.67441 15.3766,-11.80191 17.9336,-18.52734 2.693,-7.08314 1.6363,-13.44833 -4.1602,-25.0293 -8.0887,-16.16078 -24.1402,-32.13106 -39.7617,-39.5625 -14.254,-6.78095 -23.652,-8.74825 -41.334,-8.65625 z m -1360.36914,0.40821 c -4.8881,0.28508 -9.54136,0.94727 -13.6836,2.01171 -35.01112,8.99696 -68.43222,44.51543 -64.01953,68.03711 1.59944,8.52572 13.87427,19.85957 24.6582,22.76758 12.4124,3.34715 22.57219,1.49245 41.19141,-7.51562 7.57754,-3.66606 14.96088,-6.66407 16.40625,-6.66407 1.44536,0 8.95644,3.12922 16.69141,6.95508 13.84738,6.8492 14.25147,6.9564 26.26172,6.9668 9.57646,0.008 13.48666,-0.58721 18.19726,-2.77149 14.12922,-6.55163 24.99413,-21.02603 23.59766,-31.4375 -2.48917,-18.55815 -21.93045,-40.08591 -46.39258,-51.37304 -11.46308,-5.28921 -28.24393,-7.83183 -42.9082,-6.97656 z m 618.81444,119.96875 c 1.1684,-10e-6 1.5525,19.84657 1.5625,79.66796 0,53.9882 0.4813,81.37465 1.4785,84.9668 1.8035,6.49611 15.2926,20.23511 24.0098,24.45508 24.1327,11.68241 55.973,1.19043 67.4766,-22.23438 l 3.6953,-7.52148 0.4004,-79 c 0.3027,-59.5506 0.7895,-79 1.9746,-79 0.8647,0 5.1832,2.20039 9.5976,4.89062 32.234,19.6438 54.3721,48.69256 72.1328,94.64649 7.4606,19.30337 9.5068,27.45235 11.0723,44.125 1.5735,16.75794 5.5957,25.6888 15.7734,35.01562 13.5168,12.3868 30.0129,16.9385 46.5743,12.85157 16.3379,-4.03182 30.6864,-15.26629 36.8632,-28.86328 3.7022,-8.14956 3.6225,-23.70076 -0.1972,-38 -3.8455,-14.39632 -18.1521,-42.82013 -28.8946,-57.41016 -16.2454,-22.064 -16.6488,-23.45168 -5.5761,-19.12891 38.4183,14.99848 68.8664,30.43838 92.2793,46.79492 24.5109,17.12369 33.1617,24.3842 56.0937,47.07813 67.5308,66.8296 112.2522,158.43239 124.0371,254.06641 2.5648,20.81345 1.8664,60.85625 -1.3359,76.59965 -5.8276,28.6506 -21.0152,52.7467 -41.8438,66.3886 -12.0535,7.8946 -18.2106,10.0817 -32.6914,11.6074 -15.733,1.6577 -802.13194,1.4843 -814.25973,-0.1796 -17.95428,-2.4632 -38.72698,-16.8239 -50.51954,-34.9239 -7.16238,-10.9932 -14.12563,-28.1187 -17.82031,-43.83 -2.58668,-10.9997 -2.91603,-16.1474 -2.92773,-45.7286 -0.0149,-37.5112 0.80351,-43.45595 11.99023,-87.07027 7.25214,-28.27436 16.38649,-53.10855 29.48438,-80.15625 14.7831,-30.52777 23.79405,-45.2857 45.57226,-74.63672 39.1655,-52.78429 86.78004,-93.73137 138.79884,-119.36719 20.5606,-10.13266 46.7539,-19.95776 46.7539,-17.53711 0,0.46972 -3.2089,5.48476 -7.1309,11.14453 -16.2798,23.49297 -28.5162,49.66695 -32.2285,68.93555 -4.4564,23.13119 -0.433,38.51662 13.3711,51.13281 10.1307,9.25889 17.5965,12.56277 30.0078,13.28125 17.7229,1.02596 32.4661,-5.12595 44.5801,-18.59961 7.5186,-8.36246 10.6659,-16.89807 12.6758,-34.36914 4.0682,-35.3645 26.7956,-80.6796 54.9082,-109.48242 9.1019,-9.32535 38.4878,-30.60937 42.2617,-30.60937 z m 1066.8125,78.66796 c 8.3937,0 66.7795,28.80752 98.8516,48.77344 54.2664,33.78264 85.0591,60.90505 105.8418,93.22656 8.1881,12.73419 10.0691,16.68213 14.5976,30.62891 2.8318,8.72134 3.4487,13.14908 3.4297,24.66602 -0.041,24.81374 -5.6203,42.03427 -21.2734,65.6582 -22.6929,34.2483 -68.5703,73.38305 -119.7813,102.17965 -44.8696,25.2308 -109.9083,53.7984 -161.5898,70.9746 -47.0462,15.6357 -120.9656,35.9297 -176.666,48.502 -64.2568,14.5037 -177.4437,34.5315 -230,40.6973 -6.9667,0.8173 -13.9515,1.8058 -15.5215,2.1972 -5.0924,1.2694 -4.516,-1.6213 1.789,-8.9707 16.2047,-18.8886 39.1489,-59.4197 47.002,-83.0293 14.5478,-43.7369 15.7096,-102.29609 3.2715,-164.83786 -4.2279,-21.25861 -11.7312,-52.27681 -13.2344,-54.70898 -2.1815,-3.52976 7.3998,-3.8305 138.7422,-4.35547 146.0061,-0.58358 139.7233,-0.30235 167.9512,-7.55469 38.212,-9.81751 82.4352,-44.47039 111.0976,-87.05664 19.6513,-29.19754 37.5197,-76.04624 42.2071,-110.6582 0.6665,-4.92099 1.3999,-6.33204 3.2851,-6.33204 z M 324.18221,692.88607 c 1.95838,0.59378 2.29866,3.62953 2.93164,9.68555 1.19602,11.44288 9.53034,37.63334 16.91601,53.15625 16.85709,35.42954 38.58876,62.60037 67.04492,83.82422 23.30671,17.38316 38.08738,24.92728 66.06446,33.7207 l 17.16211,5.39453 h 140.22461 c 127.32578,0 140.29942,0.19515 141.04297,2.13282 0.45037,1.17367 -1.06689,10.02498 -3.37305,19.66797 -7.42753,31.0575 -13.71695,66.40214 -15.52735,87.27148 -1.33348,15.37181 -0.87241,61.96451 0.71094,71.90231 6.16372,38.6858 20.48433,76.173 41.39453,108.3575 4.52624,6.9666 8.51856,13.4172 8.8711,14.3339 0.75137,1.9536 -4.78342,1.9994 -14.97852,0.125 -3.66666,-0.6741 -15.06733,-2.7361 -25.33398,-4.582 -52.71093,-9.4772 -162.10672,-35.6232 -228,-54.4941 -84.31348,-24.1463 -142.59728,-45.9909 -203.33203,-76.2071 -48.56528,-24.1616 -88.69251,-51.90527 -119.33204,-82.50778 -29.26897,-29.23361 -48.66796,-66.95831 -48.66796,-94.63671 0,-16.09686 5.78691,-40.45281 12.98632,-54.66016 12.12794,-23.93333 34.6426,-49.76642 61.76368,-70.86133 21.63025,-16.82413 55.027,-39.4772 68.78906,-46.66016 7.10681,-3.70932 10.6842,-5.55667 12.64258,-4.96289 z m 767.01169,138.58789 c -17.8871,0.95567 -35.3627,7.97334 -50.7422,20.57422 -19.582,16.04432 -29.5215,37.25825 -24.5351,52.36719 2.332,7.06604 14.1809,17.35358 22.9687,19.94141 13.0252,3.83562 23.0837,2.45666 41.4141,-5.67969 6.6204,-2.93863 13.5354,-5.34375 15.3672,-5.34375 1.8317,0 8.2071,2.22195 14.166,4.9375 14.2868,6.51059 24.8722,7.33728 38.3672,2.99805 17.7402,-5.70422 29.0943,-18.66202 27.2324,-31.07813 -3.8012,-25.34834 -34.5622,-52.09609 -66.2773,-57.63281 -5.9919,-1.04604 -11.9986,-1.40254 -17.961,-1.08399 z m 424.8496,0.23243 c -22.8814,0.016 -42.7093,8.7163 -61.4472,26.96093 -25.6174,24.94311 -24.1603,45.94461 4.2265,60.88672 6.4927,3.41757 8.4479,3.77642 20.5098,3.77735 12.5223,9.7e-4 14.017,-0.30219 24.5684,-4.99805 6.1791,-2.75 12.9001,-5 14.9355,-5 2.0354,0 8.4695,2.09719 14.2988,4.66016 5.8292,2.56296 12.9096,5.20186 15.7325,5.86523 7.791,1.83082 12.6213,1.67959 20.4277,-0.63867 12.9892,-3.85737 23.4578,-12.71864 26.7266,-22.62305 6.1193,-18.54187 -12.6574,-45.87008 -41.3946,-60.24609 -12.1375,-6.07186 -23.667,-8.65493 -38.584,-8.64453 z"
		 sodipodi:nodetypes="sssssssssssssssssssssssssssssscssssssssssssscsssssssssssssssssssscsscssssssssssssscscsssssssssssssssssssssssssssccccssssssssssssssssssssssssssssssccssssssssssssssssssssssssssssscssssscsscccsssssssssssssssssssssssssssssssssssssssssssssssssssssssssccssssssssssssssssssssssssssssssssssssssss" />
	    </g>
	  </g>
        </svg>
        <div class="message is-success">
          <svg id="checkbox" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 512 512">
            <path d="M256 32C132.3 32 32 132.3 32 256s100.3 224 224 224 224-100.3 224-224S379.7 32 256 32zm114.9 149.1L231.8 359.6c-1.1 1.1-2.9 3.5-5.1 3.5-2.3 0-3.8-1.6-5.1-2.9-1.3-1.3-78.9-75.9-78.9-75.9l-1.5-1.5c-.6-.9-1.1-2-1.1-3.2 0-1.2.5-2.3 1.1-3.2.4-.4.7-.7 1.1-1.2 7.7-8.1 23.3-24.5 24.3-25.5 1.3-1.3 2.4-3 4.8-3 2.5 0 4.1 2.1 5.3 3.3 1.2 1.2 45 43.3 45 43.3l111.3-143c1-.8 2.2-1.4 3.5-1.4 1.3 0 2.5.5 3.5 1.3l30.6 24.1c.8 1 1.3 2.2 1.3 3.5.1 1.3-.4 2.4-1 3.3z"></path>
        </svg>
          <div class="message-content">
            <div class="message-title">
              Signed in via your OIDC provider
            </div>
            <p class="message-body">
              You can now close this window and start using OpenBao.
            </p>
          </div>
        </div>
        <hr />
        <h1>Not sure how to get started?</h1>
        <a href="https://openbao.org/docs" rel="noreferrer noopener">
         <span class="icon">
          <svg width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
    <path d="M13.307 1H11.5a.5.5 0 1 1 0-1h3a.499.499 0 0 1 .5.65V3.5a.5.5 0 1 1-1 0V1.72l-1.793 1.774a.5.5 0 0 1-.713-.701L13.307 1zM12 14V8a.5.5 0 1 1 1 0v6.5a.5.5 0 0 1-.5.5H.563a.5.5 0 0 1-.5-.5v-13a.5.5 0 0 1 .5-.5H8a.5.5 0 0 1 0 1H1v12h11zM4 6a.5.5 0 0 1 0-1h3a.5.5 0 0 1 0 1H4zm0 2.5a.5.5 0 0 1 0-1h5a.5.5 0 0 1 0 1H4zM4 11a.5.5 0 1 1 0-1h5a.5.5 0 1 1 0 1H4z"/>
  </svg> 
          </span>
          Check out the official OpenBao documentation
        </a>
      </div>
    </div>
  </body>
</html>
`

func errorHTML(summary, detail string) string {
	const html = `
<!DOCTYPE html>
<html lang="en" >

<head>

  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
<title>OpenBao</title>
      <style>
      body {
  font-size: 14px;
  font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI",
    "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans",
    "Helvetica Neue", sans-serif;
}
hr {
  border-color: #fdfdfe;
  margin: 24px 0;
}
.container {
  display: flex;
  justify-content: center;
  align-items: center;
  height: 70vh;
}
#logo {
  display: block;
  fill: #6f7682;
  margin-bottom: 16px;
}
.message {
  display: flex;
  min-width: 40vw;
  background: #fafdfa;
  border: 1px solid #c6e9c9;
  margin-bottom: 12px;
  padding: 12px 16px 16px 12px;
  position: relative;
  border-radius: 2px;
  font-size: 14px;
}
.message.is-danger {
  background: #fdfafb;
  border-color: #f9ecee;
}
.message-content {
  margin-left: 4px;
}
.message svg {
  fill: #2eb039;
}

.message.is-danger svg {
  fill: #c73445;
}
.message .message-title {
  color: #1e7125;
  font-size: 16px;
  font-weight: 700;
  line-height: 1.25;
}
.message.is-danger .message-title {
  color: #7f222c;
  
}
.message .message-body {
  border: 0;
  margin-top: 4px;
}
.message p {
  font-size: 12px;
  margin: 0;
  padding: 0;
  color: #17421b;
}
.message.is-danger p {
  color: #1f2124;
}
a {
  display: block;
  margin: 8px 0;
  color: #1563ff;
  text-decoration: none;
  font-weight: 600;
}
a:hover {
  color: black;
}
a svg {
  fill: currentcolor;
}
.icon {
  align-items: center;
  display: inline-flex;
  justify-content: center;
  height: 21px;
  width: 21px;
  vertical-align: middle;
}

h1 {
  font-size: 17.5px;
  font-weight: 700;
  margin-bottom: 0;
}

h1 + p {
  margin: 8px 0 16px 0;
}
    </style>
</head>
<body translate="no" >
  <div class="container">
    <div>
      <svg id="logo" width="160" height="75" viewBox="0 0 2638.1936 1215.5009" xmlns="http://www.w3.org/2000/svg" xmlns:svg="http://www.w3.org/2000/svg">
	<g
	   id="g1"
	   transform="translate(-92.473222,-129.48373)">
	  <g
	     id="g2">
	    <path
	       id="path7"
	       style="fill:#fdfccf"
	       d="m 1276.1588,589.18295 -4.2246,2.18359 c -46.6401,24.11848 -85.7727,83.26334 -91.7676,138.69532 -2.0918,19.34113 -8.0461,31.06831 -20.5723,40.52148 -12.3544,9.32359 -18.2881,11.24949 -34.9277,11.33789 -14.1915,0.0754 -14.9177,-0.063 -22.4063,-4.30664 -31.3875,-17.78677 -35.985,-50.44489 -13.4629,-95.61523 4.7534,-9.53333 12.463,-23.03334 17.1329,-30 4.6698,-6.96667 8.3519,-12.81154 8.1816,-12.98829 -0.9419,-0.97812 -17.0596,4.3695 -28.9746,9.61329 -55.6391,24.48668 -107.00763,65.92167 -147.99416,119.375 -47.35612,61.76035 -72.24163,119.1656 -87.85742,202.66796 -3.63743,19.45047 -4.92168,54.08538 -2.71094,73.10158 2.84678,24.4871 10.5094,47.2435 21.09375,62.6484 11.69027,17.0144 31.74133,30.1498 49.09766,32.1621 13.98443,1.6215 800.11361,1.6799 814.24611,0.061 13.469,-1.5432 19.7159,-3.7352 31.3008,-10.9844 8.63,-5.4003 24.8459,-21.7804 23.584,-23.8223 -0.3967,-0.6418 -0.2116,-1.166 0.4101,-1.166 3.5499,0 17.6668,-32.8073 15.5742,-36.1933 -0.4895,-0.7919 -0.2726,-1.8211 0.4824,-2.2891 1.9171,-1.1884 4.3051,-26.8349 4.2911,-46.084 -0.05,-66.51852 -28.3048,-155.4073 -69.1133,-217.43358 -13.9413,-21.18982 -36.8418,-50 -39.7442,-50 -1.1396,0 -1.5575,-0.64413 -1.0019,-1.54296 1.198,-1.9385 -28.7215,-31.13452 -46.1348,-45.01954 -16.1896,-12.90917 -37.4954,-27.30854 -52.1328,-35.23242 -21.9679,-11.8922 -67.1622,-31.34955 -68.8633,-29.64844 -0.4512,0.45115 0.4931,2.46018 2.0977,4.46485 19.1282,23.89693 35.1226,55.29551 39.7168,77.96875 3.8981,19.238 0.3275,32.08121 -12.4766,44.88476 -22.1239,22.12288 -55.2163,23.03435 -75.6699,2.08204 -9.8364,-10.0762 -14.1655,-19.71885 -15.4844,-34.48633 -1.4356,-16.07497 -1.8848,-18.32723 -6.4472,-32.25196 -12.2301,-37.32675 -26.8086,-63.043 -47.6934,-84.13476 -11.5951,-11.71001 -30.809,-25.75195 -35.2383,-25.75195 -2.1446,-1e-5 -2.3055,4.86496 -2.4121,73.30078 -0.063,40.31513 -0.6825,76.30446 -1.3789,79.97656 -4.8225,25.42868 -33.2989,42.97273 -60.7383,37.41992 -10.1413,-2.05224 -16.7169,-5.90333 -26.1992,-15.33984 -12.8688,-12.80669 -12.3709,-8.6497 -11.9473,-99.76563 z m 178.9492,100.59766 c 0.3142,-0.31428 0.9724,1.02646 1.4629,2.98046 0.4904,1.95402 0.6346,3.81071 0.3203,4.125 -0.3143,0.31429 -0.9725,-1.02645 -1.4629,-2.98046 -0.4904,-1.95402 -0.6346,-3.81072 -0.3203,-4.125 z m 62.1426,139.96679 c 27.1451,0.38348 56.3607,14.86162 70.9824,36.25196 16.741,24.49056 13.1007,43.74834 -10.4649,55.3496 -15.1785,7.47243 -28.5375,6.78892 -46.5117,-2.38085 -9.3282,-4.75887 -14.3647,-5.03597 -22.4062,-1.22852 -23.8814,11.30731 -43.5266,10.15893 -60.9571,-3.56445 -9.1698,-7.21958 -12.5781,-13.64761 -12.4687,-23.50782 0.2644,-23.80852 37.1961,-55.40288 70.3691,-60.19921 3.7448,-0.54145 7.5792,-0.77549 11.4571,-0.72071 z m -428.5469,0.19141 c 6.7581,-0.53687 13.6047,-0.15431 20.4844,1.16797 26.6746,5.12693 51.7467,22.84667 62.0644,43.86328 8.7843,17.89341 7.6965,26.40182 -4.8125,37.64844 -12.8019,11.50999 -35.29,16.0734 -50.1074,10.16992 -3.85,-1.5339 -9.9936,-3.9827 -13.6523,-5.44336 -6.2862,-2.50962 -7.0016,-2.54067 -13,-0.53516 -3.4912,1.16725 -10.5463,3.9697 -15.6797,6.22656 -7.545,3.31717 -11.5062,4.18318 -20.668,4.51758 -13.4884,0.49231 -18.8202,-1.20092 -28.0117,-8.89648 -17.9736,-15.04831 -15.6175,-37.07957 6.3711,-59.57227 17.2503,-17.64591 36.7373,-27.53589 57.0117,-29.14648 z"
	       sodipodi:nodetypes="ccsssssscsssssssssssscssssssssssssssssssccssssssssssssssssssssssssss" />
	    <path
	       style="fill:#fdd0a4"
	       d="m 389.16327,822.99995 c -1.65849,-2.11474 -1.61133,-2.1619 0.50341,-0.50341 1.28333,1.00646 2.33333,2.05646 2.33333,2.33334 0,1.09738 -1.09491,0.39107 -2.83674,-1.82993 z m 116.83675,-39.13716 c -18.38385,-0.85255 -27.99445,-3.44955 -41.02473,-11.0858 -18.14604,-10.63429 -35.30007,-33.21042 -43.64745,-57.4437 -13.81828,-40.11581 -5.74614,-109.84754 21.22263,-183.33332 10.94274,-29.81728 26.85107,-64 29.78504,-64 0.63537,0 0.7844,-0.6 0.33117,-1.33333 -0.45322,-0.73333 -0.15322,-1.33333 0.66667,-1.33333 0.81989,0 1.17605,-0.50914 0.79146,-1.13141 -0.38459,-0.62228 0.33,-2.2957 1.58798,-3.71873 1.25797,-1.42303 2.43296,-3.30111 2.61109,-4.17351 0.62319,-3.05223 12.85674,-21.14571 27.70534,-40.97635 41.56101,-55.50565 88.63246,-95.53392 146.63747,-124.69648 19.42344,-9.76532 48.66666,-20.76478 48.66666,-18.30534 0,0.77923 -1.41534,3.27342 -3.1452,5.54264 -8.71089,11.4269 -25.88456,43.25873 -31.35961,58.12585 -13.87577,37.67871 -12.10781,61.44835 6.00612,80.74995 9.99321,10.64843 23.81732,15.82878 39.83203,14.92638 13.59506,-0.76607 23.28866,-5.23586 33.80033,-15.58559 10.57132,-10.40846 13.52755,-17.18647 13.55389,-31.07621 0.0382,-20.12782 8.44193,-50.49331 21.82855,-78.87362 9.50775,-20.1569 18.95744,-33.89195 32.68764,-47.5112 10.75121,-10.66433 31.48603,-25.85149 33.5517,-24.57484 0.51143,0.31608 1.03219,35.83304 1.15725,78.92658 0.12507,43.09353 0.7912,80.86969 1.4803,83.94701 2.62437,11.7197 12.94948,23.38302 26.60701,30.05545 4.53863,2.21737 9.09632,3.05779 18.71271,3.45058 11.82064,0.48281 13.31763,0.24299 21.33334,-3.41761 13.03514,-5.95287 22.24487,-13.90736 26.42513,-22.82351 l 3.52882,-7.52671 0.34684,-80.61349 c 0.19076,-44.33743 0.79807,-81.06474 1.34957,-81.61624 1.89369,-1.89369 23.52098,14.23972 36.9491,27.56307 17.47473,17.33837 28.30983,33.61259 40.39083,60.66667 4.3318,9.70063 11.3922,30.52421 13.7883,40.66666 0.8662,3.66667 1.6708,12.42699 1.7879,19.46738 0.1845,11.09693 0.7157,13.82846 3.9906,20.52221 2.0778,4.24683 7.4421,11.54813 11.9207,16.22512 7.8042,8.14998 8.6095,8.61973 19.3642,11.29534 12.6483,3.1467 18.3035,2.84217 32.4559,-1.74769 17.3125,-5.61478 30.612,-22.1729 32.4725,-40.42903 1.5556,-15.26371 -6.853,-47.34674 -18.3846,-70.14675 -5.7082,-11.2861 -15.6836,-27.16462 -22.6963,-36.12738 -4.0902,-5.2276 -5.8453,-10.39253 -3.5314,-10.39253 0.7614,0 2.977,0.84026 4.9235,1.86724 1.9465,1.02698 7.439,3.49462 12.2057,5.48365 34.8937,14.5604 80.7788,43.04595 108.3639,67.27242 18.6795,16.40516 44.8026,42.84532 48.7586,49.35048 2.5411,4.17861 2.5651,4.59428 0.4477,7.77979 -3.5921,5.40431 -20.5129,37.35651 -35.5689,67.16612 -10.4875,20.76447 -14.5185,27.55634 -16.3005,27.46494 -5.8336,-0.2992 -39.0138,7.28647 -74.1774,16.95847 -4.2954,1.1815 -7.9439,1.96263 -8.1077,1.73586 -0.1638,-0.22677 -3.5022,-5.10277 -7.4188,-10.83555 -8.6145,-12.6094 -17.9607,-21.03224 -31.6913,-28.56042 -16.1203,-8.83837 -22.1462,-10.26188 -43.6389,-10.30886 -16.2026,-0.0354 -19.8108,0.36711 -27.3334,3.04936 -24.1344,8.60531 -47.64039,29.10322 -54.54907,47.56832 -4.57205,12.2199 -3.01655,21.00597 5.41468,30.58436 9.34658,10.61827 22.61969,13.69764 47.98869,11.13335 l 6.1876,-0.62544 -3.5209,2.92822 c -3.6071,2.99988 -21.9782,15.02554 -31.52097,20.63352 -7.97353,4.68579 -22.03011,15.03852 -40.66667,29.95117 -17.37478,13.903 -66.65869,62.10073 -81.19239,79.40298 -14.75342,17.56381 -39.19017,50.82375 -49.47117,67.33333 -5.48002,8.8 -10.42628,16.20124 -10.9917,16.44721 -0.56541,0.24597 -0.7275,0.93347 -0.3602,1.52778 0.36731,0.59431 -0.37895,2.34592 -1.65836,3.89247 l -2.32618,2.8119 -144.00001,0.32698 c -79.2,0.17985 -151.8,-0.0347 -161.33333,-0.47684 z M 629.07663,561.95268 c 3.79167,-1.126 11.41479,-4.48579 16.94027,-7.46619 5.52547,-2.98041 11.9821,-5.46312 14.34805,-5.51715 2.61517,-0.0597 9.3907,2.42278 17.28159,6.33182 11.02696,5.46262 14.4532,6.5246 22.77251,7.05851 17.763,1.13996 33.08158,-6.19488 42.47198,-20.33642 6.10732,-9.19736 6.11318,-16.8707 0.0221,-28.87119 -13.41264,-26.42502 -41.2495,-44.31162 -73.67383,-47.3392 -25.50651,-2.38162 -56.80972,12.07352 -76.18003,35.17829 -13.34739,15.92067 -18.05008,29.87159 -13.811,40.97147 2.92128,7.64926 13.66284,17.48689 21.20939,19.42457 3.04832,0.7827 6.14241,1.6434 6.87574,1.91267 3.40714,1.25105 15.52161,0.50046 21.74328,-1.34718 z"
	       id="path6"
	       sodipodi:nodetypes="sssssssssssssssssssssssssssssssscsssssssssssssssssssssssssssssscsssssssscssssssssssssssss" />
	    <path
	       style="fill:#dab991"
	       d="m 161.16326,1014.9949 c -1.65849,-2.1147 -1.61133,-2.1619 0.50341,-0.5034 2.221,1.7419 2.92731,2.8368 1.82993,2.8368 -0.27688,0 -1.32688,-1.05 -2.33334,-2.3334 z M 1826.3016,763.19579 c -13.7257,-19.90214 -27.1633,-38.74522 -37.4753,-51.41295 -4.3496,-5.34319 -8.7687,-8.37902 -9.4577,-9.44625 -2.0664,-3.20106 -2.6806,-5.03527 -6.6487,-8.17183 l -28.9551,-31.39729 c -9.489,-9.2718 -16.3492,-15.97013 -25.4996,-23.97083 -30.9229,-27.45247 -88.2825,-71.94892 -106.0972,-81.13332 -5.3778,-2.77254 -5.5233,-5.34914 -0.4214,-7.46243 4.75,-1.96752 9.6254,-2.23878 23.0119,3.24822 8.4815,3.47644 11.4639,5.26454 21.0762,5.2546 9.3471,-0.01 12.6466,-0.61529 18.8267,-3.45573 16.0738,-7.38768 25.1162,-20.80868 22.3411,-33.15955 -3.488,-15.52416 -20.3805,-33.88354 -39.9263,-43.39352 -19.3756,-9.42712 -23.8978,-10.53854 -42.5749,-10.46373 -26.616,0.10662 -42.2376,5.63038 -63.5231,22.46164 -10.0282,7.92966 -17.6077,16.72237 -22.3946,25.97919 -1.1829,2.28749 -3.1233,4.15907 -4.3119,4.15907 -1.1887,0 -7.8769,-1.8309 -14.8628,-4.06867 -47.6383,-15.25993 -104.2424,-25.41151 -159.5742,-28.61863 -18.9808,-1.10016 -18.5428,-0.92368 -15.5649,-6.27108 1.34,-2.40622 5.9489,-10.97495 10.2419,-19.04161 22.9935,-43.20508 47.2249,-75.40708 82.8304,-110.07655 29.0948,-28.32998 58.5591,-49.64807 91.2777,-66.04165 20.6198,-10.3315 55.7279,-22.47988 58.1027,-20.10512 0.4091,0.40911 -1.3686,3.32673 -3.9505,6.48358 -25.4097,31.06831 -44.804,72.37001 -46.6517,99.34845 -1.2237,17.86665 2.8443,29.80348 13.79,40.4649 17.6389,17.18084 41.0623,21.87218 59.6747,11.95187 11.4164,-6.08484 20.8502,-14.92856 25.0232,-23.45789 3.2763,-6.69656 3.5295,-8.27894 2.7671,-17.29803 -1.0419,-12.32563 1.0442,-22.92397 9.3045,-47.26956 12.7882,-37.69128 26.4585,-60.73203 48.6803,-82.04881 12.5784,-12.06605 28.2982,-23.78777 30.7883,-22.95773 1.2978,0.43261 1.6614,18.21093 1.6723,81.77966 0.016,93.24581 -0.7452,87.24959 12.6515,99.65262 11.8694,10.98895 27.1721,16.8559 39.1892,15.02484 12.5705,-1.91537 27.4527,-9.81474 35.2749,-18.72367 8.9647,-10.21027 8.8619,-9.64019 9.2678,-51.39357 0.2031,-20.9 -0.122,-57.2 -0.7226,-80.66667 -0.6006,-23.46666 -0.6858,-43.16772 -0.1893,-43.78012 1.2392,-1.52846 8.0845,2.19189 19.3582,10.521 27.0825,20.00864 48.7367,44.90761 61.1728,76.38428 8.7936,22.25742 13.5769,44.53942 14.6242,62.62853 0.945,16.32164 0.3067,13.68032 5.7077,21.35725 10.7874,15.33293 27.8612,24.62138 46.004,22.9438 24.4122,-2.25728 47.6824,-21.33464 49.9738,-43.53662 2.5138,-24.3566 -18.5778,-72.13095 -45.5106,-103.08547 -4.0999,-4.71205 -7.4543,-9.13873 -7.4543,-9.83708 0,-3.62337 33.6818,7.85357 56.0902,19.11253 28.0781,14.10766 67.4303,41.15309 94.3246,65.59249 19.8569,18.04438 45.4312,47.11098 62.3536,70.86829 48.698,68.36661 72.7303,143.41805 72.7303,227.13169 0,35.93568 -2.0686,48.61108 -11.6747,71.53496 -6.4186,15.31734 -14.2353,27.05819 -24.4628,36.74382 -10.3117,9.76525 -19.8769,15.37756 -33.1958,19.47731 l -10.6187,4.57482 -160.0509,0.98585 -162.0346,-1.8717 c -8.9661,-10.29535 -3.2605,-6.09325 -14.3276,-22.0476 z m 253.8596,-202.35196 c 12.3022,-4.60284 22.7642,-17.91053 22.7777,-28.97338 0.01,-7.96263 -7.7452,-22.92508 -18.2832,-35.2755 -17.0535,-19.98661 -41.3254,-25.07825 -69.6406,-25.11071 -25.7524,-0.0295 -52.4294,15.06516 -68.4994,36.37792 -7.0525,9.35331 -13.6547,16.35998 -13.633,21.70708 0.04,9.85913 8.0649,21.18866 20.6326,26.74797 13.8418,6.12286 26.039,6.8523 47.6195,-3.247 13.567,-6.3491 18.0045,-6.23263 31.7661,0.83373 19.1247,9.82029 33.8015,11.97549 47.2603,6.93989 z"
	       id="path5"
	       sodipodi:nodetypes="sssssssccsssscssssssssssssssssssssssssssssssssssssssssssssscccsssssssssss" />
	    <path
	       style="fill:#87d6be"
	       d="m 1841.3417,1187.531 c 2.1899,-3.043 5.4721,-7.3328 7.2938,-9.5328 4.8947,-5.9111 5.1964,-6.3408 7.2565,-10.3333 1.0406,-2.0167 2.3906,-3.6667 3,-3.6667 0.6094,0 1.1081,-0.6933 1.1081,-1.5408 0,-0.8474 1.5,-3.5074 3.3333,-5.911 1.8333,-2.4036 3.3333,-4.9674 3.3333,-5.6973 0,-0.7299 0.771,-2.1199 1.7132,-3.089 2.4055,-2.4739 19.6202,-37.4872 19.6202,-39.906 0,-1.094 0.72,-2.7092 1.6,-3.5892 0.88,-0.88 1.1065,-1.6 0.5034,-1.6 -0.6032,0 -0.3497,-0.9 0.5632,-2 0.9129,-1.1 1.317,-2 0.898,-2 -0.4191,0 0.1155,-2.1 1.188,-4.6667 1.0724,-2.5666 1.6206,-4.6666 1.2183,-4.6666 -0.4023,0 -0.1704,-1.05 0.5152,-2.3334 0.6857,-1.2833 1.5995,-4.4333 2.0306,-7 0.7515,-4.4741 1.3088,-7.3749 2.8175,-14.6666 0.3794,-1.8334 1.0182,-6.0334 1.4197,-9.3334 0.4015,-3.3 1.4461,-6.6857 2.3214,-7.5237 1.7145,-1.6418 266.0673,-166.9899 274.9247,-171.96072 2.9333,-1.64621 9.2333,-4.32008 14,-5.94195 9.5431,-3.24708 32.4075,-14.39012 33.1111,-16.13682 0.2444,-0.60689 1.2119,-1.10343 2.15,-1.10343 1.4173,0 6.4291,-3.38389 13.4055,-9.05131 0.7334,-0.59574 2.3834,-1.48407 3.6667,-1.97407 1.2833,-0.49001 2.3333,-1.50975 2.3333,-2.2661 0,-0.75635 0.6911,-1.37518 1.5357,-1.37518 1.5289,0 10.0222,-7.71809 16.8694,-15.32956 1.9772,-2.19792 6.2949,-6.77065 9.5949,-10.16161 3.3,-3.39096 7.5,-8.0316 9.3334,-10.31253 1.8333,-2.28093 4.9738,-6.05561 6.9788,-8.38818 2.0051,-2.33256 3.9955,-5.34363 4.4232,-6.69124 0.4277,-1.34762 1.3372,-2.45021 2.0212,-2.45021 0.6839,0 1.2434,-0.9 1.2434,-2 0,-1.1 0.6,-2 1.3334,-2 0.7333,0 1.3333,-0.8082 1.3333,-1.79599 0,-0.98779 1.1903,-3.16845 2.6452,-4.8459 1.4548,-1.67745 3.3754,-5.06925 4.2678,-7.53734 0.8925,-2.46809 2.1376,-4.48744 2.7669,-4.48744 0.6293,0 0.7733,-0.6 0.3201,-1.33333 -0.4532,-0.73334 -0.089,-1.33334 0.8102,-1.33334 0.8988,0 1.2628,-0.37142 0.8088,-0.82539 -0.4539,-0.45397 0.052,-1.70234 1.1234,-2.77416 1.0718,-1.07182 1.6079,-2.50039 1.1912,-3.1746 -0.4167,-0.67422 -0.087,-1.22584 0.7331,-1.22584 0.8199,0 1.1498,-0.55163 0.7331,-1.22585 -0.4167,-0.67421 0.1907,-2.17421 1.3499,-3.33333 1.1591,-1.15912 1.6911,-2.10749 1.1823,-2.10749 -0.5089,0 -0.2569,-0.80521 0.5598,-1.78935 0.8168,-0.98414 1.0903,-2.18414 0.6077,-2.66666 -0.4825,-0.48253 -0.1773,-0.87732 0.6783,-0.87732 0.8555,0 1.4586,-0.45 1.3402,-1 -0.1184,-0.55 0.5412,-2.8 1.4658,-5 0.9245,-2.2 1.8755,-4.9 2.1132,-6 0.2378,-1.1 0.5532,-2.15 0.701,-2.33334 0.1478,-0.18333 0.3955,-0.78333 0.5505,-1.33333 0.155,-0.55 0.7262,-2.00315 1.2694,-3.22921 0.5431,-1.22607 1.1954,-3.32607 1.4495,-4.66667 0.254,-1.3406 0.5828,-2.58745 0.7306,-2.77079 0.1478,-0.18333 0.4187,-0.93333 0.602,-1.66666 0.1833,-0.73334 0.4833,-1.63334 0.6667,-2 0.1833,-0.36667 0.4833,-1.26667 0.6666,-2 0.1834,-0.73334 0.4543,-1.48334 0.6021,-1.66667 0.1477,-0.18333 0.4877,-1.23333 0.7553,-2.33333 0.2677,-1.1 0.8218,-3.35 1.2314,-5 1.9032,-7.66823 2.2637,-9.21571 2.873,-12.33333 0.3583,-1.83334 0.6641,-4.37152 0.6797,-5.64042 0.015,-1.26889 0.59,-2.6543 1.2767,-3.07869 0.6867,-0.42438 1.2485,-2.7362 1.2485,-5.13736 0,-4.96007 1.0884,-6.6457 3.2107,-4.9724 0.8008,0.63141 3.856,1.88759 6.7893,2.79152 8.9928,2.7712 61.3334,29.01328 79.1617,39.68945 41.6724,24.95468 64.777,42.04199 86.885,64.25684 18.3033,18.39183 33.5141,39.29786 38.5089,52.92763 1.5781,4.30654 3.2469,8.73008 3.7084,9.83008 0.4615,1.1 0.9144,2.3 1.0066,2.66667 5.4056,21.50317 5.429,21.87448 2.6018,41.33333 -0.3729,2.56667 -0.7285,5.56667 -0.7903,6.66667 -0.062,1.1 -0.6821,2.72371 -1.3786,3.60826 -0.6965,0.88454 -0.905,2.19308 -0.4632,2.90787 0.4418,0.71478 0.1836,1.68252 -0.5736,2.15053 -0.7573,0.46801 -1.0317,1.40947 -0.6098,2.09213 0.422,0.68267 0.1317,1.24121 -0.6449,1.24121 -0.7766,0 -1.412,0.67497 -1.412,1.49994 0,1.96902 -6.8527,17.26467 -8.8857,19.83339 -0.8706,1.1 -4.8278,6.8 -8.7939,12.66666 -10.9374,16.17881 -18.1757,24.00929 -38.8242,42 -6.3125,5.5 -11.4815,10.45 -11.4867,11 -0.01,0.55 -0.8797,1 -1.9432,1 -1.0636,0 -2.4136,0.76441 -3,1.69868 -0.5865,0.93427 -2.5663,2.66508 -4.3996,3.84625 -1.8334,1.18117 -4.6472,3.26676 -6.2531,4.63466 -6.8317,5.81937 -43.5573,29.82037 -45.6303,29.82037 -0.7975,0 -1.45,0.4795 -1.45,1.0655 0,0.586 -1.9662,1.7765 -4.3693,2.6455 -2.4031,0.869 -5.5531,2.4773 -7,3.5742 -3.1094,2.3571 -44.7333,23.0509 -55.2973,27.4917 -4.0334,1.6955 -7.7742,3.7143 -8.3129,4.4862 -0.5388,0.772 -0.9888,0.9382 -1,0.3694 -0.011,-0.5689 -1.9705,0 -4.3538,1.2605 -2.3833,1.2622 -4.9333,2.4048 -5.6667,2.5391 -0.7333,0.1343 -5.2333,2.0409 -10,4.2369 -8.3068,3.827 -12.2165,5.3964 -14.3473,5.7594 -0.5423,0.092 -2.186,0.8362 -3.6527,1.6531 -1.4666,0.8168 -3.1166,1.3576 -3.6666,1.2018 -0.55,-0.1558 -1,0.4167 -1,1.2723 0,0.8555 -0.3948,1.1608 -0.8774,0.6782 -0.4825,-0.4825 -1.6825,-0.209 -2.6666,0.6077 -0.9842,0.8168 -1.7894,1.0905 -1.7894,0.6082 0,-0.4822 -1.35,-0.127 -3,0.7895 -1.65,0.9165 -3.4,1.6876 -3.8889,1.7136 -0.4888,0.026 -1.3388,0.4972 -1.8888,1.0472 -0.55,0.55 -1.761,1 -2.691,1 -0.9301,0 -3.3801,0.6998 -5.4445,1.555 -2.0644,0.8552 -4.2034,1.6802 -4.7534,1.8333 -0.55,0.1531 -1.3,0.4284 -1.6667,0.6117 -0.3667,0.1834 -1.1167,0.4176 -1.6667,0.5205 -0.55,0.1028 -1.75,0.6633 -2.6666,1.2453 -0.9167,0.5821 -1.6667,0.7356 -1.6667,0.3412 0,-0.581 -10.239,2.7355 -21.3333,6.9102 -1.1,0.4139 -2.45,0.8793 -3,1.0343 -0.55,0.155 -1.3,0.4319 -1.6667,0.6152 -0.3667,0.1833 -1.2667,0.4833 -2,0.6667 -0.7333,0.1833 -1.4833,0.4529 -1.6667,0.599 -0.1833,0.1462 -1.8333,0.5282 -3.6666,0.8489 -1.8334,0.3207 -4.2334,0.9743 -5.3334,1.4524 -1.1,0.4782 -2.45,0.9962 -3,1.1512 -0.55,0.155 -1.15,0.4014 -1.3333,0.5475 -0.1833,0.1462 -1.8333,0.5282 -3.6667,0.8489 -1.8333,0.3207 -4.2333,0.9667 -5.3333,1.4356 -2.0891,0.8906 -3.7625,1.403 -7.6667,2.3478 -1.2833,0.3105 -2.4833,0.6855 -2.6666,0.8333 -0.1834,0.1478 -0.9334,0.4187 -1.6667,0.602 -0.7333,0.1834 -1.4833,0.4577 -1.6667,0.6097 -0.1833,0.1519 -2.1183,0.5656 -4.3001,0.9191 -2.1817,0.3536 -4.7317,1.2777 -5.6666,2.0536 -0.935,0.776 -1.6999,1.0522 -1.6999,0.6139 0,-0.4383 -1.65,-0.1585 -3.6667,0.6218 -2.0167,0.7803 -4.8667,1.7005 -6.3333,2.0449 -5.4647,1.2833 -6.675,1.6063 -7,1.8684 -0.4,0.3223 -0.8351,0.4237 -7.6565,1.7832 -2.9278,0.5835 -5.9278,1.4395 -6.6667,1.9023 -0.7389,0.4628 -2.2435,1.0304 -3.3435,1.2612 -3.2917,0.6909 -6,1.438 -6,1.6553 0,0.1122 -0.9,0.423 -2,0.6907 -1.1,0.2677 -3.35,0.8218 -5,1.2313 -1.65,0.4096 -4.35,1.0797 -6,1.4892 -1.65,0.4096 -3.9,0.9637 -5,1.2314 -1.1,0.2677 -2,0.5819 -2,0.6983 0,0.1164 -1.8,0.4916 -4,0.8337 -2.2,0.3421 -6.4,1.2938 -9.3333,2.1149 -2.9334,0.8212 -5.9334,1.6568 -6.6667,1.8571 -3.2443,0.886 -8.2633,2.0384 -11.3333,2.6023 -1.8334,0.3367 -4.8334,0.9997 -6.6667,1.4735 -5.8947,1.5231 -7.2827,1.8537 -10,2.382 -1.4667,0.2852 -4.1667,0.8966 -6,1.3587 -1.8333,0.4621 -4.5333,1.1045 -6,1.4275 -1.4667,0.323 -4.1667,0.9246 -6,1.3368 -1.8333,0.4123 -4.8333,1.0189 -6.6667,1.348 -4.1217,0.74 -7.667,1.4786 -12,2.4998 -1.8333,0.4321 -4.8333,1.0732 -6.6666,1.4248 -1.8334,0.3515 -4.8334,0.9515 -6.6667,1.3333 -1.8333,0.3818 -4.8333,0.9853 -6.6667,1.3411 -1.8333,0.3558 -5.1333,1.0039 -7.3333,1.4402 -2.2,0.4363 -5.3516,1.0243 -7.0036,1.3067 -6.6638,1.1392 -13.9183,2.5468 -20.3297,3.9445 -1.8334,0.3997 -5.4334,1.045 -8,1.434 -8.5612,1.2976 -11.3084,1.767 -14.6667,2.5059 -3.3259,0.7317 -9.6891,1.8157 -16,2.7256 -1.8333,0.2644 -4.8333,0.77 -6.6667,1.1236 -1.8333,0.3536 -5.7333,1.0309 -8.6666,1.5051 -2.9334,0.4741 -6.8334,1.1136 -8.6667,1.4211 -1.8333,0.3074 -5.4333,0.8502 -8,1.2062 -2.5667,0.3559 -6.4667,0.9505 -8.6667,1.3213 -2.2,0.3707 -6.1,1.012 -8.6666,1.4251 -2.5667,0.4131 -6.1667,1.0055 -8,1.3165 -8.8098,1.4943 -16.1531,2.6073 -26.6667,4.0418 -2.5667,0.3501 -6.7667,0.9362 -9.3333,1.3024 -4.2256,0.6028 -9.8814,1.2562 -22.32,2.5785 l -4.32,0.4592 z m -1040.62257,-4.7813 c -0.42439,-0.6866 -1.8098,-1.2566 -3.07869,-1.2665 -3.84684,-0.03 -25.3238,-3.7892 -42.80591,-7.4922 -9.07435,-1.9221 -18.07435,-3.7317 -20,-4.0214 -1.92565,-0.2897 -8.90118,-1.7775 -15.50118,-3.3062 -29.80563,-6.9035 -33.45029,-7.7033 -35.33333,-7.7537 -1.1,-0.029 -5.3,-0.9561 -9.33333,-2.0592 -4.03334,-1.1032 -9.13334,-2.322 -11.33334,-2.7085 -2.2,-0.3865 -19.89281,-4.6525 -39.31737,-9.48 -19.42455,-4.8276 -36.22455,-8.9617 -37.33333,-9.1869 -1.10878,-0.2253 -2.91597,-0.7824 -4.01597,-1.238 -1.1,-0.4556 -3.5,-1.1161 -5.33333,-1.4676 -1.83333,-0.3515 -7.1698,-1.84 -11.85882,-3.3078 -4.68902,-1.4678 -8.88902,-2.6023 -9.33333,-2.5211 -0.44432,0.081 -1.70785,-0.216 -2.80785,-0.6606 -4.62278,-1.868 -16,-4.7455 -16,-4.0466 0,0.4169 -0.76495,0.1232 -1.6999,-0.6528 -0.93494,-0.7759 -3.18494,-1.6146 -5,-1.8637 -1.81505,-0.2491 -4.0501,-0.9231 -4.96677,-1.4978 -0.91666,-0.5747 -1.66666,-0.636 -1.66666,-0.1363 0,0.4997 -0.9,0.1617 -2,-0.7512 -1.1,-0.913 -2,-1.2653 -2,-0.783 0,0.4822 -1.10718,0.2842 -2.4604,-0.44 -1.35322,-0.7242 -4.20322,-1.6768 -6.33334,-2.1169 -5.24896,-1.0846 -7.87293,-1.749 -7.87293,-1.9935 0,-0.1122 -0.9,-0.4062 -2,-0.6534 -1.1,-0.2471 -4.55,-1.3746 -7.66667,-2.5055 -3.11667,-1.1308 -5.66667,-1.7093 -5.66667,-1.2853 0,0.4239 -0.75,0.1483 -1.66666,-0.6125 -0.91667,-0.7607 -1.96667,-1.392 -2.33334,-1.4028 -0.36666,-0.011 -2.35572,-0.6618 -4.42013,-1.4467 -2.06441,-0.7849 -4.79441,-1.4271 -6.06667,-1.4271 -1.27226,0 -3.0332,-0.72 -3.9132,-1.6 -0.88,-0.88 -1.6,-1.1065 -1.6,-0.5034 0,0.6031 -0.9,0.3497 -2,-0.5633 -1.1,-0.9129 -2,-1.2129 -2,-0.6666 0,0.5462 -0.9,0.2462 -2,-0.6667 -1.1,-0.9129 -2,-1.2129 -2,-0.6667 0,0.5463 -0.75,0.3979 -1.66666,-0.3296 -1.3918,-1.1047 -9.76484,-4.3158 -13.33334,-5.1135 -0.55,-0.1229 -1.3,-0.3735 -1.66666,-0.5569 -0.36667,-0.1833 -1.26667,-0.4833 -2,-0.6666 -0.73334,-0.1834 -1.63334,-0.4834 -2,-0.6667 -0.36667,-0.1833 -1.11667,-0.4296 -1.66667,-0.5472 -0.55,-0.1177 -2.35,-0.9638 -4,-1.8803 -1.65,-0.9165 -3,-1.3314 -3,-0.922 0,0.4094 -1.35,-0.1402 -3,-1.2214 -1.65,-1.0811 -3.6,-2.0668 -4.33333,-2.1904 -0.73334,-0.1237 -2.7224,-0.753 -4.42014,-1.3984 -1.69774,-0.6455 -3.65588,-1.1736 -4.35142,-1.1736 -1.2999,0 -2.77006,-0.6536 -10.19543,-4.5322 -2.36518,-1.2354 -4.76518,-2.293 -5.33334,-2.3501 -0.56815,-0.057 -2.53301,-0.7317 -4.36634,-1.4991 -1.83333,-0.7673 -3.63334,-1.4667 -4,-1.5542 -0.36667,-0.087 -2.16667,-0.9891 -4,-2.0037 -1.83334,-1.0145 -3.63334,-1.8076 -4,-1.7623 -0.36667,0.045 -3.06667,-1.1421 -6,-2.6385 -2.93334,-1.4965 -5.47077,-2.6596 -5.63875,-2.5847 -1.12888,0.5033 -48.83201,-22.5658 -52.02792,-25.1605 -0.91667,-0.7443 -1.67585,-0.8795 -1.68708,-0.3006 -0.0112,0.5789 -0.46123,0.3831 -1,-0.435 -1.16667,-1.7717 -12.54627,-7.835 -13.97959,-7.4487 -0.55,0.1483 -1,-0.194 -1,-0.7606 0,-0.5665 -2.25,-2.2108 -5,-3.6539 -2.75,-1.443 -5.3,-2.9295 -5.66666,-3.3032 -1.46858,-1.4967 -21.18697,-14.6794 -21.95711,-14.6794 -0.45427,0 -2.44363,-1.5 -4.4208,-3.3333 -1.97716,-1.8334 -4.0763,-3.33336 -4.66475,-3.33336 -1.2055,0 -2.3274,-0.8488 -8.95735,-6.77684 -2.56666,-2.29494 -6.16666,-5.16934 -8,-6.38756 -6.61053,-4.39259 -36,-32.61488 -36,-34.5703 0,-0.61475 -1.42543,-2.35714 -3.16764,-3.87196 -1.7422,-1.51483 -4.27156,-4.62303 -5.62081,-6.90712 -1.34924,-2.28408 -2.9238,-4.15288 -3.49902,-4.15288 -0.57523,0 -1.04586,-0.9 -1.04586,-2 0,-1.1 -0.6,-2 -1.33333,-2 -0.73334,0 -1.33334,-0.9 -1.33334,-2 0,-1.1 -0.6,-2 -1.33333,-2 -0.73333,0 -1.33333,-0.85714 -1.33333,-1.90476 0,-1.04762 -0.75,-2.69762 -1.66667,-3.66667 -2.06162,-2.17942 -6.90103,-12.06545 -6.57357,-13.42857 0.13213,-0.55 -0.45976,-1 -1.31532,-1 -0.85556,0 -1.16076,-0.3948 -0.67823,-0.87732 0.48252,-0.48253 0.20905,-1.68253 -0.60771,-2.66667 -0.81676,-0.98414 -1.09045,-1.78934 -0.60819,-1.78934 0.48226,0 0.13459,-1.35 -0.77261,-3 -0.9072,-1.65 -1.7821,-3.79686 -1.94422,-4.77079 -0.16212,-0.97393 -0.72428,-2.77393 -1.24925,-4 -2.81086,-6.56478 -3.66718,-23.04513 -1.86696,-35.93076 2.16992,-15.53186 2.13794,-15.34349 2.99413,-17.63178 0.98473,-2.63182 5.47988,-16.47747 5.62747,-17.33334 0.18164,-1.05333 5.65306,-10.81533 9.34136,-16.66666 1.84898,-2.93333 3.72231,-6.38333 4.16295,-7.66667 0.44064,-1.28333 1.33119,-2.33333 1.97899,-2.33333 0.6478,0 1.17783,-0.9 1.17783,-2 0,-1.1 0.6,-2 1.33333,-2 0.73333,0 1.33333,-0.61622 1.33333,-1.36938 0,-0.75316 1.95,-3.45396 4.33334,-6.00179 12.82817,-13.71354 26.21007,-27.02135 30.12898,-29.96216 7.45965,-5.59784 11.04235,-8.56049 13.30218,-11 1.18881,-1.28333 2.94697,-2.33333 3.90701,-2.33333 0.96003,0 2.09088,-0.9 2.51299,-2 0.42211,-1.1 1.53909,-2 2.48217,-2 0.94308,0 2.06006,-0.9 2.48217,-2 0.42211,-1.1 1.6863,-2 2.80932,-2 1.12301,0 2.04184,-0.46356 2.04184,-1.03013 0,-0.56657 2.1,-2.16105 4.66667,-3.5433 2.56667,-1.38224 4.66667,-3.01868 4.66667,-3.63653 0,-0.61786 0.9,-1.12338 2,-1.12338 1.1,0 2,-0.6 2,-1.33333 0,-0.73333 0.9,-1.33333 2,-1.33333 1.1,0 2,-0.6 2,-1.33334 0,-0.73333 0.9,-1.33333 2,-1.33333 1.1,0 2,-0.6 2,-1.33333 0,-0.73334 0.62532,-1.33334 1.38961,-1.33334 0.76428,0 2.11428,-0.60845 3,-1.35211 3.2811,-2.75487 11.8188,-8.00002 23.61258,-14.50641 11.83474,-6.52899 13.13503,-6.67549 13.09015,-1.47481 -0.0195,2.25714 1.01675,9.67195 2.32984,16.67134 0.48407,2.5803 1.42189,5.02628 2.08405,5.43552 0.66217,0.40924 0.87056,1.28348 0.4631,1.94277 -2.49644,4.03932 17.94512,48.20341 31.45116,67.95037 28.17876,41.19972 72.83667,68.51908 118.1205,81.70878 11.63593,3.38916 17.62404,12.46543 142.27393,89.62454 72.26631,44.73329 131.7521,82.35249 132.19063,83.59809 0.43852,1.2457 1.04201,4.8457 1.34107,8 1.31726,13.8937 2.21428,19.0152 5.82632,33.2649 4.97889,19.642 12.05457,38.5181 20.66802,55.137 9.02038,17.4041 19.71706,35.3333 21.08,35.3333 0.59348,0 1.07905,0.9 1.07905,2 0,1.1 0.67347,2 1.4966,2 1.03401,0 0.98354,0.6182 -0.16326,2 -1.9013,2.291 -3.50173,2.5516 -4.61423,0.7515 z M 497.08335,879.08913 c 0.9625,-0.38516 2.1125,-0.33779 2.55555,0.10526 0.44306,0.44306 -0.34444,0.75819 -1.75,0.70029 -1.55325,-0.064 -1.8692,-0.37992 -0.80555,-0.80555 z"
	       id="path4"
	       sodipodi:nodetypes="ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssscsssssssscssssssssssscssssssssssscssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssscsssssscsssssssscsssssssssssssssssssssssssssssssssssssscscsssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss" />
	    <path
	       id="path3"
	       style="fill:#79c0ab"
	       d="m 2179.0006,872.53256 c -22.9654,5.27761 -20.0386,5.17311 -160.9512,5.73633 -131.3422,0.52497 -140.9237,0.82571 -138.7422,4.35547 1.5019,2.43007 9.0056,33.44529 13.2363,54.70898 6.0424,30.36829 9.2162,66.75266 8.375,95.99996 -0.3481,12.1 -0.2202,20.5034 0.2832,18.6739 0.7308,-2.6557 28.3242,-20.4813 136.8575,-88.41019 74.7676,-46.79563 137.8901,-86.06006 140.2734,-87.2539 5.2854,-2.64758 5.6922,-4.96517 0.668,-3.81055 z m -1687.24027,5.31836 c -0.79174,-0.48932 -1.21206,-0.23502 -0.93359,0.56445 0.27847,0.79947 59.60671,38.09217 131.83984,82.87305 123.21818,76.38898 131.35996,81.66758 131.75195,85.40038 0.97634,9.2973 1.39426,2.3175 1.38086,-23.0215 -0.0122,-23.1472 1.44243,-48.18859 3.34961,-57.66794 0.29509,-1.46666 0.94792,-5.36602 1.45118,-8.66602 1.80239,-11.81897 7.47657,-39.64156 11.5957,-56.86523 2.30616,-9.64299 3.82349,-18.49407 3.37305,-19.66797 -0.74391,-1.9386 -13.73017,-2.13011 -141.59375,-2.09571 -77.42612,0.0208 -141.42312,-0.36419 -142.21485,-0.85351 z"
	       sodipodi:nodetypes="ssssssssssssssssssss" />
	    <path
	       id="path2"
	       style="fill:#091a28"
	       d="m 886.36385,130.80014 c -87.24656,1.12056 -190.25283,27.35813 -266.56641,69.16992 -70.01526,38.36098 -129.70311,89.13185 -181.06641,154.01562 -18.83223,23.78949 -34.23254,48.98963 -55.41601,90.68164 -26.32141,51.8042 -41.56924,95.4066 -52.09961,148.97657 -1.26782,6.4496 -3.24036,12.48858 -4.41992,13.53515 -1.17129,1.03924 -6.02826,3.51921 -10.79492,5.51172 -4.76667,1.99251 -15.26734,6.91746 -23.33399,10.94531 -101.19333,50.52804 -175.3774,126.11317 -193.36328,197.01563 -14.410562,56.80811 -1.130307,112.63637 39.5957,166.46094 44.32346,58.57906 132.76157,116.48606 245.08985,160.47856 24.03858,9.4145 100.67685,35.5629 129.34375,44.1308 81.53604,24.3692 176.32422,45.605 289.44922,64.8477 73.06887,12.4291 193.38686,26.9743 271.21878,32.7871 77.8682,5.8155 141.7043,10.0079 180.666,11.8633 120.4444,5.7361 427.776,-2.1521 693.334,-48.6289 104.3413,-18.2614 174.4107,-34.0107 249.332,-56.043 88.426,-26.0036 144.3149,-47.3548 207.334,-79.209 84.6937,-42.8101 134.8208,-77.7466 172.8672,-120.47852 51.8974,-58.28886 68.2412,-111.66696 52.5195,-171.52734 -7.0838,-26.97176 -15.2836,-44.43435 -32.6992,-69.63281 -13.7107,-19.83784 -49.8888,-56.96471 -72.6875,-74.59375 -44.5888,-34.47833 -95.6059,-61.81388 -162.666,-87.15821 -13.2,-4.98872 -24.71,-9.60767 -25.5762,-10.26367 -0.8662,-0.656 -2.2293,-4.24425 -3.0293,-7.97461 -2.041,-9.51674 -9.9797,-37.435 -15.625,-54.94726 -20.3229,-63.04356 -56.3847,-127.60406 -102.3691,-183.26563 -13.3344,-16.14048 -50.3236,-53.26468 -68.7344,-68.98633 -65.1982,-55.67507 -139.9263,-94.461 -226.6836,-117.65234 -16.5602,-4.42675 -61.9101,-13.25317 -84.6504,-16.47656 -18.9105,-2.68052 -26.6333,-3.02358 -68,-3.01758 -36.8674,0.005 -50.7264,0.50954 -66,2.40625 -130.549,16.21178 -237.5616,63.59697 -326,144.35352 -6.6,6.0267 -20.0895,19.1151 -29.9785,29.08398 -9.8891,9.96887 -18.3968,18.125 -18.9063,18.125 -0.5095,0 -13.4193,-12.47911 -28.6875,-27.73047 -36.6502,-36.60997 -65.4466,-59.31186 -105.2851,-83.00391 -80.3478,-47.78304 -169.2502,-75.03634 -269.80862,-82.71289 -11.69682,-0.89292 -23.83894,-1.24601 -36.30273,-1.08593 z m 832.58205,100.70507 c 0.5796,0.35823 1.068,37.36689 1.084,82.24024 0.033,93.05832 -0.6578,87.28761 11.9023,99.52148 13.8999,13.53888 32.9358,18.15793 49.7422,12.06836 15.0999,-5.47119 26.7818,-15.06206 31.4102,-25.78711 1.2262,-2.84167 1.6264,-22.71213 1.6054,-79.77929 -0.015,-41.798 -0.4043,-78.34618 -0.8633,-81.2168 -1.0684,-6.68148 0.4608,-6.74499 10.918,-0.45313 25.0212,15.05475 47.4553,39.79271 61.5899,67.91211 11.6172,23.11156 20.1686,52.98412 21.5839,75.40235 0.8431,13.35591 1.4806,16.34535 4.7676,22.38476 4.8165,8.84937 13.4086,16.78646 23.0801,21.32032 6.6877,3.13506 9.193,3.54882 21.5664,3.54882 13.004,0 14.6467,-0.30699 23.0703,-4.29687 12.2559,-5.80504 23.5069,-17.07538 27.3809,-27.42969 3.5163,-9.39805 3.7902,-22.42413 0.7539,-35.77344 -2.4497,-10.77066 -10.6492,-31.57802 -16.711,-42.40625 -6.3768,-11.39096 -20.8334,-31.95286 -28.0312,-39.86914 -3.5543,-3.90908 -6.4629,-7.5681 -6.4629,-8.13281 0,-3.86481 35.0194,7.98514 58.1836,19.68945 65.3365,33.01311 130.3867,94.15984 171.1582,160.88477 35.4994,58.09687 54.1971,121.44075 56.8926,192.75 1.433,37.90853 -2.7339,62.45486 -14.877,87.6543 -14.311,29.69823 -34.4113,46.17068 -64.0234,52.46679 -6.1975,1.31772 -40.7458,1.71366 -153.334,1.75586 -79.9332,0.03 -150.8836,-0.12107 -157.668,-0.33593 -11.8016,-0.37376 -12.4308,-0.54773 -14.5312,-4.00782 -19.1772,-31.59044 -51.6906,-74.25707 -80.2149,-105.26562 -30.1166,-32.73959 -83.0058,-76.46182 -133.4004,-110.27735 -9.6343,-6.46482 -17.5178,-12.12583 -17.5078,-12.58007 0.019,-1.47437 7.088,-4.16016 10.9512,-4.16016 2.0696,0 9.2988,2.16519 16.0664,4.81055 11.5753,4.52466 13.0159,4.77565 24.3047,4.24609 9.1489,-0.42918 13.4255,-1.29777 18,-3.6543 15.2631,-7.8628 22.2246,-17.8536 20.9355,-30.04882 -1.6355,-15.47315 -18.6076,-34.73082 -39.6425,-44.98243 -18.4534,-8.99345 -26.1083,-10.94306 -42.625,-10.85156 -27.4354,0.15199 -49.24,8.99095 -69.8243,28.30664 -6.0061,5.63607 -16.8437,19.98344 -16.8437,22.29883 0,3.24483 -4.0463,2.89069 -18.1758,-1.58789 -50.3293,-15.9527 -94.8371,-23.5874 -169.5801,-29.08594 -8.3818,-0.61661 -9.3811,-1.32244 -7.082,-5.0039 0.9495,-1.52041 5.0404,-9.14322 9.0918,-16.93946 8.2685,-15.91177 14.0367,-25.88292 22.7871,-39.39258 48.9523,-75.57762 127.5519,-138.46488 196.7754,-157.43945 6.7011,-1.83681 12.935,-3.34127 13.8516,-3.3418 2.9281,-0.002 1.8083,2.76233 -3.6153,8.92383 -14.6691,16.665 -31.7772,47.47463 -40.207,72.40821 -3.8738,11.45795 -4.2932,14.25771 -4.3965,29.33398 -0.1071,15.62702 0.1081,17.08953 3.4668,23.45508 4.4811,8.49257 16.0477,19.18394 26.086,24.11328 6.9335,3.40477 9.0041,3.76562 21.666,3.76562 13.4562,0 14.3108,-0.17614 22,-4.52539 9.9428,-5.62391 17.2937,-11.8318 21.8066,-18.41406 3.1997,-4.66694 3.5348,-6.51434 4.2969,-23.72851 0.8075,-18.24269 1.0009,-19.17967 8.4844,-41.28321 12.6959,-37.49976 22.3677,-55.71089 40.4961,-76.25 13.1379,-14.88511 38.6301,-34.95789 41.8613,-32.96094 z m -771.01174,0.84766 c 5.47238,0.53912 24.03142,14.14151 38.76367,28.91211 22.63277,22.69165 38.39617,49.55347 49.72267,84.73438 5.811,18.04952 6.6014,22.20248 6.9082,36.27148 0.256,11.74445 0.7941,14.61851 3.9277,21.02344 4.608,9.41826 14.8545,19.9838 23.0528,23.76953 5.3493,2.47018 8.6818,2.93145 21.0234,2.90625 13.1929,-0.0269 15.4105,-0.39192 22.0625,-3.63477 4.0674,-1.9828 10.1839,-6.27765 13.5918,-9.54297 11.5447,-11.0617 15.295,-23.0917 12.9883,-41.65429 -3.853,-31.00648 -19.9477,-67.20504 -42.3086,-95.1543 -7.9747,-9.96777 -10.2532,-14.38483 -6.666,-12.92187 0.9167,0.37382 7.3653,2.96117 14.332,5.75 34.6956,13.889 78.9639,39.44466 104.0664,60.07812 20.3696,16.74314 61.4159,57.24636 65.2227,64.35938 1.2399,2.31674 1.1722,3.53808 -0.3204,5.83984 -4.3016,6.63401 -28.1871,51.18636 -40.5195,75.57812 l -10.4492,20.66602 -10.666,1.63281 c -5.8667,0.89852 -22.6674,4.70597 -37.334,8.45899 -14.6667,3.75301 -29.3236,7.49359 -32.5723,8.3125 -4.6183,1.16413 -6.0285,1.12328 -6.4648,-0.18555 -2.5058,-7.51727 -19.3039,-26.90811 -29.2227,-33.73242 -17.3392,-11.92969 -34.5986,-16.60887 -56.9941,-15.45508 -22.75,1.17206 -43.2295,10.5479 -60.2754,27.59375 -22.79387,22.79387 -23.13742,47.3362 -0.81445,58.25781 10.29098,5.03491 25.46565,5.84105 38.17775,2.02735 8.6232,-2.58702 12.834,-2.64831 12.834,-0.18555 0,0.60824 -8.1356,6.39413 -18.0782,12.85742 -9.9425,6.46329 -24.1919,15.74805 -31.66597,20.63281 -22.25649,14.54599 -48.01298,36.20514 -75.05079,63.11328 -28.38476,28.24866 -41.53841,43.20816 -62.14257,70.67188 -15.80344,21.06472 -26.8033,37.60614 -34.51563,51.9043 -5.15609,9.55907 -5.36655,9.75427 -11.41992,10.58398 -9.37587,1.2851 -304.12882,0.70025 -312.03125,-0.61914 -18.29786,-3.05501 -36.74709,-13.38738 -50.57813,-28.32617 -21.24398,-22.94547 -31.66366,-52.36305 -31.48242,-88.87695 0.22453,-45.23271 14.27018,-105.39262 37.16797,-159.20118 19.28719,-45.32385 48.96388,-91.03299 84.05664,-129.46484 45.03541,-49.32054 101.23745,-87.49692 156.32227,-106.18359 6.18756,-2.09903 11.43887,-3.81641 11.66797,-3.81641 1.73097,0 -0.34353,5.35915 -4.06055,10.48828 -7.51161,10.36531 -19.33566,31.41137 -25.74805,45.83399 -12.84267,28.88546 -16.71983,59.0992 -9.5625,74.5039 14.91394,32.09921 56.43504,40.45817 81.5293,16.41211 11.94178,-11.44297 13.21876,-14.44149 14.32617,-33.62305 0.5625,-9.74317 2.23937,-22.05061 3.94531,-28.94921 8.60402,-34.79352 29.48103,-74.92255 49.6211,-95.38282 10.79051,-10.96204 34.8626,-27.89599 36.84375,-25.91797 0.47014,0.4694 1.15482,37.85521 1.52148,83.07813 l 0.66602,82.22266 3.79883,6.46289 c 4.91087,8.35485 12.14862,15.31217 21.07031,20.2539 6.63317,3.67413 8.10842,3.95117 21.13086,3.95117 12.39874,0 14.87291,-0.40951 21.625,-3.57421 9.63927,-4.51792 20.68131,-14.71739 24.00976,-22.17774 2.44178,-5.47299 2.56467,-9.65984 2.53907,-86.66601 -0.0148,-44.50365 0.40361,-81.9856 0.93164,-83.29297 0.19824,-0.49085 0.71432,-0.68054 1.49609,-0.60352 z M 2017.3326,467.6224 c -11.5397,0.06 -15.8738,0.70221 -24.666,3.66016 -18.1852,6.11806 -28.2118,12.19187 -40.7461,24.67969 -19.2175,19.14624 -24.3212,33.91873 -16.1582,46.77734 5.9804,9.42053 14.9504,15.4495 26.9043,18.08594 4.0334,0.88955 8.5568,1.66701 10.0527,1.72851 4.7109,0.19354 16.8925,-3.52853 27.6738,-8.45703 16.6787,-7.6243 18.3413,-7.59096 35.8809,0.70508 14.4347,6.82745 15.5994,7.14385 28.0625,7.64844 11.9764,0.48488 13.58,0.24406 20.3184,-3.05274 7.5102,-3.67441 15.3766,-11.80191 17.9336,-18.52734 2.693,-7.08314 1.6363,-13.44833 -4.1602,-25.0293 -8.0887,-16.16078 -24.1402,-32.13106 -39.7617,-39.5625 -14.254,-6.78095 -23.652,-8.74825 -41.334,-8.65625 z m -1360.36914,0.40821 c -4.8881,0.28508 -9.54136,0.94727 -13.6836,2.01171 -35.01112,8.99696 -68.43222,44.51543 -64.01953,68.03711 1.59944,8.52572 13.87427,19.85957 24.6582,22.76758 12.4124,3.34715 22.57219,1.49245 41.19141,-7.51562 7.57754,-3.66606 14.96088,-6.66407 16.40625,-6.66407 1.44536,0 8.95644,3.12922 16.69141,6.95508 13.84738,6.8492 14.25147,6.9564 26.26172,6.9668 9.57646,0.008 13.48666,-0.58721 18.19726,-2.77149 14.12922,-6.55163 24.99413,-21.02603 23.59766,-31.4375 -2.48917,-18.55815 -21.93045,-40.08591 -46.39258,-51.37304 -11.46308,-5.28921 -28.24393,-7.83183 -42.9082,-6.97656 z m 618.81444,119.96875 c 1.1684,-10e-6 1.5525,19.84657 1.5625,79.66796 0,53.9882 0.4813,81.37465 1.4785,84.9668 1.8035,6.49611 15.2926,20.23511 24.0098,24.45508 24.1327,11.68241 55.973,1.19043 67.4766,-22.23438 l 3.6953,-7.52148 0.4004,-79 c 0.3027,-59.5506 0.7895,-79 1.9746,-79 0.8647,0 5.1832,2.20039 9.5976,4.89062 32.234,19.6438 54.3721,48.69256 72.1328,94.64649 7.4606,19.30337 9.5068,27.45235 11.0723,44.125 1.5735,16.75794 5.5957,25.6888 15.7734,35.01562 13.5168,12.3868 30.0129,16.9385 46.5743,12.85157 16.3379,-4.03182 30.6864,-15.26629 36.8632,-28.86328 3.7022,-8.14956 3.6225,-23.70076 -0.1972,-38 -3.8455,-14.39632 -18.1521,-42.82013 -28.8946,-57.41016 -16.2454,-22.064 -16.6488,-23.45168 -5.5761,-19.12891 38.4183,14.99848 68.8664,30.43838 92.2793,46.79492 24.5109,17.12369 33.1617,24.3842 56.0937,47.07813 67.5308,66.8296 112.2522,158.43239 124.0371,254.06641 2.5648,20.81345 1.8664,60.85625 -1.3359,76.59965 -5.8276,28.6506 -21.0152,52.7467 -41.8438,66.3886 -12.0535,7.8946 -18.2106,10.0817 -32.6914,11.6074 -15.733,1.6577 -802.13194,1.4843 -814.25973,-0.1796 -17.95428,-2.4632 -38.72698,-16.8239 -50.51954,-34.9239 -7.16238,-10.9932 -14.12563,-28.1187 -17.82031,-43.83 -2.58668,-10.9997 -2.91603,-16.1474 -2.92773,-45.7286 -0.0149,-37.5112 0.80351,-43.45595 11.99023,-87.07027 7.25214,-28.27436 16.38649,-53.10855 29.48438,-80.15625 14.7831,-30.52777 23.79405,-45.2857 45.57226,-74.63672 39.1655,-52.78429 86.78004,-93.73137 138.79884,-119.36719 20.5606,-10.13266 46.7539,-19.95776 46.7539,-17.53711 0,0.46972 -3.2089,5.48476 -7.1309,11.14453 -16.2798,23.49297 -28.5162,49.66695 -32.2285,68.93555 -4.4564,23.13119 -0.433,38.51662 13.3711,51.13281 10.1307,9.25889 17.5965,12.56277 30.0078,13.28125 17.7229,1.02596 32.4661,-5.12595 44.5801,-18.59961 7.5186,-8.36246 10.6659,-16.89807 12.6758,-34.36914 4.0682,-35.3645 26.7956,-80.6796 54.9082,-109.48242 9.1019,-9.32535 38.4878,-30.60937 42.2617,-30.60937 z m 1066.8125,78.66796 c 8.3937,0 66.7795,28.80752 98.8516,48.77344 54.2664,33.78264 85.0591,60.90505 105.8418,93.22656 8.1881,12.73419 10.0691,16.68213 14.5976,30.62891 2.8318,8.72134 3.4487,13.14908 3.4297,24.66602 -0.041,24.81374 -5.6203,42.03427 -21.2734,65.6582 -22.6929,34.2483 -68.5703,73.38305 -119.7813,102.17965 -44.8696,25.2308 -109.9083,53.7984 -161.5898,70.9746 -47.0462,15.6357 -120.9656,35.9297 -176.666,48.502 -64.2568,14.5037 -177.4437,34.5315 -230,40.6973 -6.9667,0.8173 -13.9515,1.8058 -15.5215,2.1972 -5.0924,1.2694 -4.516,-1.6213 1.789,-8.9707 16.2047,-18.8886 39.1489,-59.4197 47.002,-83.0293 14.5478,-43.7369 15.7096,-102.29609 3.2715,-164.83786 -4.2279,-21.25861 -11.7312,-52.27681 -13.2344,-54.70898 -2.1815,-3.52976 7.3998,-3.8305 138.7422,-4.35547 146.0061,-0.58358 139.7233,-0.30235 167.9512,-7.55469 38.212,-9.81751 82.4352,-44.47039 111.0976,-87.05664 19.6513,-29.19754 37.5197,-76.04624 42.2071,-110.6582 0.6665,-4.92099 1.3999,-6.33204 3.2851,-6.33204 z M 324.18221,692.88607 c 1.95838,0.59378 2.29866,3.62953 2.93164,9.68555 1.19602,11.44288 9.53034,37.63334 16.91601,53.15625 16.85709,35.42954 38.58876,62.60037 67.04492,83.82422 23.30671,17.38316 38.08738,24.92728 66.06446,33.7207 l 17.16211,5.39453 h 140.22461 c 127.32578,0 140.29942,0.19515 141.04297,2.13282 0.45037,1.17367 -1.06689,10.02498 -3.37305,19.66797 -7.42753,31.0575 -13.71695,66.40214 -15.52735,87.27148 -1.33348,15.37181 -0.87241,61.96451 0.71094,71.90231 6.16372,38.6858 20.48433,76.173 41.39453,108.3575 4.52624,6.9666 8.51856,13.4172 8.8711,14.3339 0.75137,1.9536 -4.78342,1.9994 -14.97852,0.125 -3.66666,-0.6741 -15.06733,-2.7361 -25.33398,-4.582 -52.71093,-9.4772 -162.10672,-35.6232 -228,-54.4941 -84.31348,-24.1463 -142.59728,-45.9909 -203.33203,-76.2071 -48.56528,-24.1616 -88.69251,-51.90527 -119.33204,-82.50778 -29.26897,-29.23361 -48.66796,-66.95831 -48.66796,-94.63671 0,-16.09686 5.78691,-40.45281 12.98632,-54.66016 12.12794,-23.93333 34.6426,-49.76642 61.76368,-70.86133 21.63025,-16.82413 55.027,-39.4772 68.78906,-46.66016 7.10681,-3.70932 10.6842,-5.55667 12.64258,-4.96289 z m 767.01169,138.58789 c -17.8871,0.95567 -35.3627,7.97334 -50.7422,20.57422 -19.582,16.04432 -29.5215,37.25825 -24.5351,52.36719 2.332,7.06604 14.1809,17.35358 22.9687,19.94141 13.0252,3.83562 23.0837,2.45666 41.4141,-5.67969 6.6204,-2.93863 13.5354,-5.34375 15.3672,-5.34375 1.8317,0 8.2071,2.22195 14.166,4.9375 14.2868,6.51059 24.8722,7.33728 38.3672,2.99805 17.7402,-5.70422 29.0943,-18.66202 27.2324,-31.07813 -3.8012,-25.34834 -34.5622,-52.09609 -66.2773,-57.63281 -5.9919,-1.04604 -11.9986,-1.40254 -17.961,-1.08399 z m 424.8496,0.23243 c -22.8814,0.016 -42.7093,8.7163 -61.4472,26.96093 -25.6174,24.94311 -24.1603,45.94461 4.2265,60.88672 6.4927,3.41757 8.4479,3.77642 20.5098,3.77735 12.5223,9.7e-4 14.017,-0.30219 24.5684,-4.99805 6.1791,-2.75 12.9001,-5 14.9355,-5 2.0354,0 8.4695,2.09719 14.2988,4.66016 5.8292,2.56296 12.9096,5.20186 15.7325,5.86523 7.791,1.83082 12.6213,1.67959 20.4277,-0.63867 12.9892,-3.85737 23.4578,-12.71864 26.7266,-22.62305 6.1193,-18.54187 -12.6574,-45.87008 -41.3946,-60.24609 -12.1375,-6.07186 -23.667,-8.65493 -38.584,-8.64453 z"
	       sodipodi:nodetypes="sssssssssssssssssssssssssssssscssssssssssssscsssssssssssssssssssscsscssssssssssssscscsssssssssssssssssssssssssssccccssssssssssssssssssssssssssssssccssssssssssssssssssssssssssssscssssscsscccsssssssssssssssssssssssssssssssssssssssssssssssssssssssssccssssssssssssssssssssssssssssssssssssssss" />
	  </g>
	</g>
      </svg>
      <div class="message is-danger">
       <svg width="20" height="20" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
  <path d="M19 3c1.1 0 2 .9 2 2v14c0 1.1-.9 2-2 2H5c-1.1 0-2-.9-2-2V5c0-1.1.9-2 2-2h14zm-2 12.59L13.41 12 17 8.41 15.59 7 12 10.59 8.41 7 7 8.41 10.59 12 7 15.59 8.41 17 12 13.41 15.59 17 17 15.59z"></path>
</svg> 
        <div class="message-content">
          <div class="message-title">
            %s
          </div>
          <p class="message-body">
            %s
          </p>
        </div>
      </div>
      <hr />

      <h1>Not sure how to get started?</h1>
      <a href="https://openbao.org/docs" rel="noreferrer noopener">
       <span class="icon">
        <svg width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
  <path d="M13.307 1H11.5a.5.5 0 1 1 0-1h3a.499.499 0 0 1 .5.65V3.5a.5.5 0 1 1-1 0V1.72l-1.793 1.774a.5.5 0 0 1-.713-.701L13.307 1zM12 14V8a.5.5 0 1 1 1 0v6.5a.5.5 0 0 1-.5.5H.563a.5.5 0 0 1-.5-.5v-13a.5.5 0 0 1 .5-.5H8a.5.5 0 0 1 0 1H1v12h11zM4 6a.5.5 0 0 1 0-1h3a.5.5 0 0 1 0 1H4zm0 2.5a.5.5 0 0 1 0-1h5a.5.5 0 0 1 0 1H4zM4 11a.5.5 0 1 1 0-1h5a.5.5 0 1 1 0 1H4z"/>
</svg> 
        </span>
        Check out the official OpenBao documentation
      </a>
    </div>
  </div>
</body>

</html>
`
	return fmt.Sprintf(html, summary, detail)
}

func formpostHTML(path, code, state string) string {
	const html = `
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Complete sign-in process</title>
    <style>
      body {
        font-size: 14px;
        font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI",
          "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans",
          "Helvetica Neue", sans-serif;
      }
      hr {
        border-color: #fdfdfe;
        margin: 24px 0;
      }
      .container {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 70vh;
      }
      #logo {
        display: block;
        fill: #6f7682;
        margin-bottom: 16px;
      }
      .message {
        display: flex;
        min-width: 40vw;
        background: #fafdfa;
        border: 1px solid #c6e9c9;
        margin-bottom: 12px;
        padding: 12px 16px 16px 12px;
        position: relative;
        border-radius: 2px;
        font-size: 14px;
      }
      .message-content {
        margin-left: 4px;
      }
      .message #checkbox {
        fill: #2eb039;
      }
      .message .message-title {
        color: #1e7125;
        font-size: 16px;
        font-weight: 700;
        line-height: 1.25;
      }
      .message .message-body {
        border: 0;
        margin-top: 4px;
      }
      .message p {
        font-size: 12px;
        margin: 0;
        padding: 0;
        color: #17421b;
      }
      a {
        display: block;
        margin: 8px 0;
        color: #1563ff;
        text-decoration: none;
        font-weight: 600;
      }
      a:hover {
        color: black;
      }
      a svg {
        fill: currentcolor;
      }
      .icon {
        align-items: center;
        display: inline-flex;
        justify-content: center;
        height: 21px;
        width: 21px;
        vertical-align: middle;
      }
      h1 {
        font-size: 17.5px;
        font-weight: 700;
        margin-bottom: 0;
      }
      h1 + p {
        margin: 8px 0 16px 0;
      }
    </style>
  </head>
  <body translate="no" >
    <div class="container">
      <div>
        <svg id="logo" width="160" height="75" viewBox="0 0 2638.1936 1215.5009" xmlns="http://www.w3.org/2000/svg" xmlns:svg="http://www.w3.org/2000/svg">
	  <g
	     id="g1"
	     transform="translate(-92.473222,-129.48373)">
	    <g
	       id="g2">
	      <path
		 id="path7"
		 style="fill:#fdfccf"
		 d="m 1276.1588,589.18295 -4.2246,2.18359 c -46.6401,24.11848 -85.7727,83.26334 -91.7676,138.69532 -2.0918,19.34113 -8.0461,31.06831 -20.5723,40.52148 -12.3544,9.32359 -18.2881,11.24949 -34.9277,11.33789 -14.1915,0.0754 -14.9177,-0.063 -22.4063,-4.30664 -31.3875,-17.78677 -35.985,-50.44489 -13.4629,-95.61523 4.7534,-9.53333 12.463,-23.03334 17.1329,-30 4.6698,-6.96667 8.3519,-12.81154 8.1816,-12.98829 -0.9419,-0.97812 -17.0596,4.3695 -28.9746,9.61329 -55.6391,24.48668 -107.00763,65.92167 -147.99416,119.375 -47.35612,61.76035 -72.24163,119.1656 -87.85742,202.66796 -3.63743,19.45047 -4.92168,54.08538 -2.71094,73.10158 2.84678,24.4871 10.5094,47.2435 21.09375,62.6484 11.69027,17.0144 31.74133,30.1498 49.09766,32.1621 13.98443,1.6215 800.11361,1.6799 814.24611,0.061 13.469,-1.5432 19.7159,-3.7352 31.3008,-10.9844 8.63,-5.4003 24.8459,-21.7804 23.584,-23.8223 -0.3967,-0.6418 -0.2116,-1.166 0.4101,-1.166 3.5499,0 17.6668,-32.8073 15.5742,-36.1933 -0.4895,-0.7919 -0.2726,-1.8211 0.4824,-2.2891 1.9171,-1.1884 4.3051,-26.8349 4.2911,-46.084 -0.05,-66.51852 -28.3048,-155.4073 -69.1133,-217.43358 -13.9413,-21.18982 -36.8418,-50 -39.7442,-50 -1.1396,0 -1.5575,-0.64413 -1.0019,-1.54296 1.198,-1.9385 -28.7215,-31.13452 -46.1348,-45.01954 -16.1896,-12.90917 -37.4954,-27.30854 -52.1328,-35.23242 -21.9679,-11.8922 -67.1622,-31.34955 -68.8633,-29.64844 -0.4512,0.45115 0.4931,2.46018 2.0977,4.46485 19.1282,23.89693 35.1226,55.29551 39.7168,77.96875 3.8981,19.238 0.3275,32.08121 -12.4766,44.88476 -22.1239,22.12288 -55.2163,23.03435 -75.6699,2.08204 -9.8364,-10.0762 -14.1655,-19.71885 -15.4844,-34.48633 -1.4356,-16.07497 -1.8848,-18.32723 -6.4472,-32.25196 -12.2301,-37.32675 -26.8086,-63.043 -47.6934,-84.13476 -11.5951,-11.71001 -30.809,-25.75195 -35.2383,-25.75195 -2.1446,-1e-5 -2.3055,4.86496 -2.4121,73.30078 -0.063,40.31513 -0.6825,76.30446 -1.3789,79.97656 -4.8225,25.42868 -33.2989,42.97273 -60.7383,37.41992 -10.1413,-2.05224 -16.7169,-5.90333 -26.1992,-15.33984 -12.8688,-12.80669 -12.3709,-8.6497 -11.9473,-99.76563 z m 178.9492,100.59766 c 0.3142,-0.31428 0.9724,1.02646 1.4629,2.98046 0.4904,1.95402 0.6346,3.81071 0.3203,4.125 -0.3143,0.31429 -0.9725,-1.02645 -1.4629,-2.98046 -0.4904,-1.95402 -0.6346,-3.81072 -0.3203,-4.125 z m 62.1426,139.96679 c 27.1451,0.38348 56.3607,14.86162 70.9824,36.25196 16.741,24.49056 13.1007,43.74834 -10.4649,55.3496 -15.1785,7.47243 -28.5375,6.78892 -46.5117,-2.38085 -9.3282,-4.75887 -14.3647,-5.03597 -22.4062,-1.22852 -23.8814,11.30731 -43.5266,10.15893 -60.9571,-3.56445 -9.1698,-7.21958 -12.5781,-13.64761 -12.4687,-23.50782 0.2644,-23.80852 37.1961,-55.40288 70.3691,-60.19921 3.7448,-0.54145 7.5792,-0.77549 11.4571,-0.72071 z m -428.5469,0.19141 c 6.7581,-0.53687 13.6047,-0.15431 20.4844,1.16797 26.6746,5.12693 51.7467,22.84667 62.0644,43.86328 8.7843,17.89341 7.6965,26.40182 -4.8125,37.64844 -12.8019,11.50999 -35.29,16.0734 -50.1074,10.16992 -3.85,-1.5339 -9.9936,-3.9827 -13.6523,-5.44336 -6.2862,-2.50962 -7.0016,-2.54067 -13,-0.53516 -3.4912,1.16725 -10.5463,3.9697 -15.6797,6.22656 -7.545,3.31717 -11.5062,4.18318 -20.668,4.51758 -13.4884,0.49231 -18.8202,-1.20092 -28.0117,-8.89648 -17.9736,-15.04831 -15.6175,-37.07957 6.3711,-59.57227 17.2503,-17.64591 36.7373,-27.53589 57.0117,-29.14648 z"
		 sodipodi:nodetypes="ccsssssscsssssssssssscssssssssssssssssssccssssssssssssssssssssssssss" />
	      <path
		 style="fill:#fdd0a4"
		 d="m 389.16327,822.99995 c -1.65849,-2.11474 -1.61133,-2.1619 0.50341,-0.50341 1.28333,1.00646 2.33333,2.05646 2.33333,2.33334 0,1.09738 -1.09491,0.39107 -2.83674,-1.82993 z m 116.83675,-39.13716 c -18.38385,-0.85255 -27.99445,-3.44955 -41.02473,-11.0858 -18.14604,-10.63429 -35.30007,-33.21042 -43.64745,-57.4437 -13.81828,-40.11581 -5.74614,-109.84754 21.22263,-183.33332 10.94274,-29.81728 26.85107,-64 29.78504,-64 0.63537,0 0.7844,-0.6 0.33117,-1.33333 -0.45322,-0.73333 -0.15322,-1.33333 0.66667,-1.33333 0.81989,0 1.17605,-0.50914 0.79146,-1.13141 -0.38459,-0.62228 0.33,-2.2957 1.58798,-3.71873 1.25797,-1.42303 2.43296,-3.30111 2.61109,-4.17351 0.62319,-3.05223 12.85674,-21.14571 27.70534,-40.97635 41.56101,-55.50565 88.63246,-95.53392 146.63747,-124.69648 19.42344,-9.76532 48.66666,-20.76478 48.66666,-18.30534 0,0.77923 -1.41534,3.27342 -3.1452,5.54264 -8.71089,11.4269 -25.88456,43.25873 -31.35961,58.12585 -13.87577,37.67871 -12.10781,61.44835 6.00612,80.74995 9.99321,10.64843 23.81732,15.82878 39.83203,14.92638 13.59506,-0.76607 23.28866,-5.23586 33.80033,-15.58559 10.57132,-10.40846 13.52755,-17.18647 13.55389,-31.07621 0.0382,-20.12782 8.44193,-50.49331 21.82855,-78.87362 9.50775,-20.1569 18.95744,-33.89195 32.68764,-47.5112 10.75121,-10.66433 31.48603,-25.85149 33.5517,-24.57484 0.51143,0.31608 1.03219,35.83304 1.15725,78.92658 0.12507,43.09353 0.7912,80.86969 1.4803,83.94701 2.62437,11.7197 12.94948,23.38302 26.60701,30.05545 4.53863,2.21737 9.09632,3.05779 18.71271,3.45058 11.82064,0.48281 13.31763,0.24299 21.33334,-3.41761 13.03514,-5.95287 22.24487,-13.90736 26.42513,-22.82351 l 3.52882,-7.52671 0.34684,-80.61349 c 0.19076,-44.33743 0.79807,-81.06474 1.34957,-81.61624 1.89369,-1.89369 23.52098,14.23972 36.9491,27.56307 17.47473,17.33837 28.30983,33.61259 40.39083,60.66667 4.3318,9.70063 11.3922,30.52421 13.7883,40.66666 0.8662,3.66667 1.6708,12.42699 1.7879,19.46738 0.1845,11.09693 0.7157,13.82846 3.9906,20.52221 2.0778,4.24683 7.4421,11.54813 11.9207,16.22512 7.8042,8.14998 8.6095,8.61973 19.3642,11.29534 12.6483,3.1467 18.3035,2.84217 32.4559,-1.74769 17.3125,-5.61478 30.612,-22.1729 32.4725,-40.42903 1.5556,-15.26371 -6.853,-47.34674 -18.3846,-70.14675 -5.7082,-11.2861 -15.6836,-27.16462 -22.6963,-36.12738 -4.0902,-5.2276 -5.8453,-10.39253 -3.5314,-10.39253 0.7614,0 2.977,0.84026 4.9235,1.86724 1.9465,1.02698 7.439,3.49462 12.2057,5.48365 34.8937,14.5604 80.7788,43.04595 108.3639,67.27242 18.6795,16.40516 44.8026,42.84532 48.7586,49.35048 2.5411,4.17861 2.5651,4.59428 0.4477,7.77979 -3.5921,5.40431 -20.5129,37.35651 -35.5689,67.16612 -10.4875,20.76447 -14.5185,27.55634 -16.3005,27.46494 -5.8336,-0.2992 -39.0138,7.28647 -74.1774,16.95847 -4.2954,1.1815 -7.9439,1.96263 -8.1077,1.73586 -0.1638,-0.22677 -3.5022,-5.10277 -7.4188,-10.83555 -8.6145,-12.6094 -17.9607,-21.03224 -31.6913,-28.56042 -16.1203,-8.83837 -22.1462,-10.26188 -43.6389,-10.30886 -16.2026,-0.0354 -19.8108,0.36711 -27.3334,3.04936 -24.1344,8.60531 -47.64039,29.10322 -54.54907,47.56832 -4.57205,12.2199 -3.01655,21.00597 5.41468,30.58436 9.34658,10.61827 22.61969,13.69764 47.98869,11.13335 l 6.1876,-0.62544 -3.5209,2.92822 c -3.6071,2.99988 -21.9782,15.02554 -31.52097,20.63352 -7.97353,4.68579 -22.03011,15.03852 -40.66667,29.95117 -17.37478,13.903 -66.65869,62.10073 -81.19239,79.40298 -14.75342,17.56381 -39.19017,50.82375 -49.47117,67.33333 -5.48002,8.8 -10.42628,16.20124 -10.9917,16.44721 -0.56541,0.24597 -0.7275,0.93347 -0.3602,1.52778 0.36731,0.59431 -0.37895,2.34592 -1.65836,3.89247 l -2.32618,2.8119 -144.00001,0.32698 c -79.2,0.17985 -151.8,-0.0347 -161.33333,-0.47684 z M 629.07663,561.95268 c 3.79167,-1.126 11.41479,-4.48579 16.94027,-7.46619 5.52547,-2.98041 11.9821,-5.46312 14.34805,-5.51715 2.61517,-0.0597 9.3907,2.42278 17.28159,6.33182 11.02696,5.46262 14.4532,6.5246 22.77251,7.05851 17.763,1.13996 33.08158,-6.19488 42.47198,-20.33642 6.10732,-9.19736 6.11318,-16.8707 0.0221,-28.87119 -13.41264,-26.42502 -41.2495,-44.31162 -73.67383,-47.3392 -25.50651,-2.38162 -56.80972,12.07352 -76.18003,35.17829 -13.34739,15.92067 -18.05008,29.87159 -13.811,40.97147 2.92128,7.64926 13.66284,17.48689 21.20939,19.42457 3.04832,0.7827 6.14241,1.6434 6.87574,1.91267 3.40714,1.25105 15.52161,0.50046 21.74328,-1.34718 z"
		 id="path6"
		 sodipodi:nodetypes="sssssssssssssssssssssssssssssssscsssssssssssssssssssssssssssssscsssssssscssssssssssssssss" />
	      <path
		 style="fill:#dab991"
		 d="m 161.16326,1014.9949 c -1.65849,-2.1147 -1.61133,-2.1619 0.50341,-0.5034 2.221,1.7419 2.92731,2.8368 1.82993,2.8368 -0.27688,0 -1.32688,-1.05 -2.33334,-2.3334 z M 1826.3016,763.19579 c -13.7257,-19.90214 -27.1633,-38.74522 -37.4753,-51.41295 -4.3496,-5.34319 -8.7687,-8.37902 -9.4577,-9.44625 -2.0664,-3.20106 -2.6806,-5.03527 -6.6487,-8.17183 l -28.9551,-31.39729 c -9.489,-9.2718 -16.3492,-15.97013 -25.4996,-23.97083 -30.9229,-27.45247 -88.2825,-71.94892 -106.0972,-81.13332 -5.3778,-2.77254 -5.5233,-5.34914 -0.4214,-7.46243 4.75,-1.96752 9.6254,-2.23878 23.0119,3.24822 8.4815,3.47644 11.4639,5.26454 21.0762,5.2546 9.3471,-0.01 12.6466,-0.61529 18.8267,-3.45573 16.0738,-7.38768 25.1162,-20.80868 22.3411,-33.15955 -3.488,-15.52416 -20.3805,-33.88354 -39.9263,-43.39352 -19.3756,-9.42712 -23.8978,-10.53854 -42.5749,-10.46373 -26.616,0.10662 -42.2376,5.63038 -63.5231,22.46164 -10.0282,7.92966 -17.6077,16.72237 -22.3946,25.97919 -1.1829,2.28749 -3.1233,4.15907 -4.3119,4.15907 -1.1887,0 -7.8769,-1.8309 -14.8628,-4.06867 -47.6383,-15.25993 -104.2424,-25.41151 -159.5742,-28.61863 -18.9808,-1.10016 -18.5428,-0.92368 -15.5649,-6.27108 1.34,-2.40622 5.9489,-10.97495 10.2419,-19.04161 22.9935,-43.20508 47.2249,-75.40708 82.8304,-110.07655 29.0948,-28.32998 58.5591,-49.64807 91.2777,-66.04165 20.6198,-10.3315 55.7279,-22.47988 58.1027,-20.10512 0.4091,0.40911 -1.3686,3.32673 -3.9505,6.48358 -25.4097,31.06831 -44.804,72.37001 -46.6517,99.34845 -1.2237,17.86665 2.8443,29.80348 13.79,40.4649 17.6389,17.18084 41.0623,21.87218 59.6747,11.95187 11.4164,-6.08484 20.8502,-14.92856 25.0232,-23.45789 3.2763,-6.69656 3.5295,-8.27894 2.7671,-17.29803 -1.0419,-12.32563 1.0442,-22.92397 9.3045,-47.26956 12.7882,-37.69128 26.4585,-60.73203 48.6803,-82.04881 12.5784,-12.06605 28.2982,-23.78777 30.7883,-22.95773 1.2978,0.43261 1.6614,18.21093 1.6723,81.77966 0.016,93.24581 -0.7452,87.24959 12.6515,99.65262 11.8694,10.98895 27.1721,16.8559 39.1892,15.02484 12.5705,-1.91537 27.4527,-9.81474 35.2749,-18.72367 8.9647,-10.21027 8.8619,-9.64019 9.2678,-51.39357 0.2031,-20.9 -0.122,-57.2 -0.7226,-80.66667 -0.6006,-23.46666 -0.6858,-43.16772 -0.1893,-43.78012 1.2392,-1.52846 8.0845,2.19189 19.3582,10.521 27.0825,20.00864 48.7367,44.90761 61.1728,76.38428 8.7936,22.25742 13.5769,44.53942 14.6242,62.62853 0.945,16.32164 0.3067,13.68032 5.7077,21.35725 10.7874,15.33293 27.8612,24.62138 46.004,22.9438 24.4122,-2.25728 47.6824,-21.33464 49.9738,-43.53662 2.5138,-24.3566 -18.5778,-72.13095 -45.5106,-103.08547 -4.0999,-4.71205 -7.4543,-9.13873 -7.4543,-9.83708 0,-3.62337 33.6818,7.85357 56.0902,19.11253 28.0781,14.10766 67.4303,41.15309 94.3246,65.59249 19.8569,18.04438 45.4312,47.11098 62.3536,70.86829 48.698,68.36661 72.7303,143.41805 72.7303,227.13169 0,35.93568 -2.0686,48.61108 -11.6747,71.53496 -6.4186,15.31734 -14.2353,27.05819 -24.4628,36.74382 -10.3117,9.76525 -19.8769,15.37756 -33.1958,19.47731 l -10.6187,4.57482 -160.0509,0.98585 -162.0346,-1.8717 c -8.9661,-10.29535 -3.2605,-6.09325 -14.3276,-22.0476 z m 253.8596,-202.35196 c 12.3022,-4.60284 22.7642,-17.91053 22.7777,-28.97338 0.01,-7.96263 -7.7452,-22.92508 -18.2832,-35.2755 -17.0535,-19.98661 -41.3254,-25.07825 -69.6406,-25.11071 -25.7524,-0.0295 -52.4294,15.06516 -68.4994,36.37792 -7.0525,9.35331 -13.6547,16.35998 -13.633,21.70708 0.04,9.85913 8.0649,21.18866 20.6326,26.74797 13.8418,6.12286 26.039,6.8523 47.6195,-3.247 13.567,-6.3491 18.0045,-6.23263 31.7661,0.83373 19.1247,9.82029 33.8015,11.97549 47.2603,6.93989 z"
		 id="path5"
		 sodipodi:nodetypes="sssssssccsssscssssssssssssssssssssssssssssssssssssssssssssscccsssssssssss" />
	      <path
		 style="fill:#87d6be"
		 d="m 1841.3417,1187.531 c 2.1899,-3.043 5.4721,-7.3328 7.2938,-9.5328 4.8947,-5.9111 5.1964,-6.3408 7.2565,-10.3333 1.0406,-2.0167 2.3906,-3.6667 3,-3.6667 0.6094,0 1.1081,-0.6933 1.1081,-1.5408 0,-0.8474 1.5,-3.5074 3.3333,-5.911 1.8333,-2.4036 3.3333,-4.9674 3.3333,-5.6973 0,-0.7299 0.771,-2.1199 1.7132,-3.089 2.4055,-2.4739 19.6202,-37.4872 19.6202,-39.906 0,-1.094 0.72,-2.7092 1.6,-3.5892 0.88,-0.88 1.1065,-1.6 0.5034,-1.6 -0.6032,0 -0.3497,-0.9 0.5632,-2 0.9129,-1.1 1.317,-2 0.898,-2 -0.4191,0 0.1155,-2.1 1.188,-4.6667 1.0724,-2.5666 1.6206,-4.6666 1.2183,-4.6666 -0.4023,0 -0.1704,-1.05 0.5152,-2.3334 0.6857,-1.2833 1.5995,-4.4333 2.0306,-7 0.7515,-4.4741 1.3088,-7.3749 2.8175,-14.6666 0.3794,-1.8334 1.0182,-6.0334 1.4197,-9.3334 0.4015,-3.3 1.4461,-6.6857 2.3214,-7.5237 1.7145,-1.6418 266.0673,-166.9899 274.9247,-171.96072 2.9333,-1.64621 9.2333,-4.32008 14,-5.94195 9.5431,-3.24708 32.4075,-14.39012 33.1111,-16.13682 0.2444,-0.60689 1.2119,-1.10343 2.15,-1.10343 1.4173,0 6.4291,-3.38389 13.4055,-9.05131 0.7334,-0.59574 2.3834,-1.48407 3.6667,-1.97407 1.2833,-0.49001 2.3333,-1.50975 2.3333,-2.2661 0,-0.75635 0.6911,-1.37518 1.5357,-1.37518 1.5289,0 10.0222,-7.71809 16.8694,-15.32956 1.9772,-2.19792 6.2949,-6.77065 9.5949,-10.16161 3.3,-3.39096 7.5,-8.0316 9.3334,-10.31253 1.8333,-2.28093 4.9738,-6.05561 6.9788,-8.38818 2.0051,-2.33256 3.9955,-5.34363 4.4232,-6.69124 0.4277,-1.34762 1.3372,-2.45021 2.0212,-2.45021 0.6839,0 1.2434,-0.9 1.2434,-2 0,-1.1 0.6,-2 1.3334,-2 0.7333,0 1.3333,-0.8082 1.3333,-1.79599 0,-0.98779 1.1903,-3.16845 2.6452,-4.8459 1.4548,-1.67745 3.3754,-5.06925 4.2678,-7.53734 0.8925,-2.46809 2.1376,-4.48744 2.7669,-4.48744 0.6293,0 0.7733,-0.6 0.3201,-1.33333 -0.4532,-0.73334 -0.089,-1.33334 0.8102,-1.33334 0.8988,0 1.2628,-0.37142 0.8088,-0.82539 -0.4539,-0.45397 0.052,-1.70234 1.1234,-2.77416 1.0718,-1.07182 1.6079,-2.50039 1.1912,-3.1746 -0.4167,-0.67422 -0.087,-1.22584 0.7331,-1.22584 0.8199,0 1.1498,-0.55163 0.7331,-1.22585 -0.4167,-0.67421 0.1907,-2.17421 1.3499,-3.33333 1.1591,-1.15912 1.6911,-2.10749 1.1823,-2.10749 -0.5089,0 -0.2569,-0.80521 0.5598,-1.78935 0.8168,-0.98414 1.0903,-2.18414 0.6077,-2.66666 -0.4825,-0.48253 -0.1773,-0.87732 0.6783,-0.87732 0.8555,0 1.4586,-0.45 1.3402,-1 -0.1184,-0.55 0.5412,-2.8 1.4658,-5 0.9245,-2.2 1.8755,-4.9 2.1132,-6 0.2378,-1.1 0.5532,-2.15 0.701,-2.33334 0.1478,-0.18333 0.3955,-0.78333 0.5505,-1.33333 0.155,-0.55 0.7262,-2.00315 1.2694,-3.22921 0.5431,-1.22607 1.1954,-3.32607 1.4495,-4.66667 0.254,-1.3406 0.5828,-2.58745 0.7306,-2.77079 0.1478,-0.18333 0.4187,-0.93333 0.602,-1.66666 0.1833,-0.73334 0.4833,-1.63334 0.6667,-2 0.1833,-0.36667 0.4833,-1.26667 0.6666,-2 0.1834,-0.73334 0.4543,-1.48334 0.6021,-1.66667 0.1477,-0.18333 0.4877,-1.23333 0.7553,-2.33333 0.2677,-1.1 0.8218,-3.35 1.2314,-5 1.9032,-7.66823 2.2637,-9.21571 2.873,-12.33333 0.3583,-1.83334 0.6641,-4.37152 0.6797,-5.64042 0.015,-1.26889 0.59,-2.6543 1.2767,-3.07869 0.6867,-0.42438 1.2485,-2.7362 1.2485,-5.13736 0,-4.96007 1.0884,-6.6457 3.2107,-4.9724 0.8008,0.63141 3.856,1.88759 6.7893,2.79152 8.9928,2.7712 61.3334,29.01328 79.1617,39.68945 41.6724,24.95468 64.777,42.04199 86.885,64.25684 18.3033,18.39183 33.5141,39.29786 38.5089,52.92763 1.5781,4.30654 3.2469,8.73008 3.7084,9.83008 0.4615,1.1 0.9144,2.3 1.0066,2.66667 5.4056,21.50317 5.429,21.87448 2.6018,41.33333 -0.3729,2.56667 -0.7285,5.56667 -0.7903,6.66667 -0.062,1.1 -0.6821,2.72371 -1.3786,3.60826 -0.6965,0.88454 -0.905,2.19308 -0.4632,2.90787 0.4418,0.71478 0.1836,1.68252 -0.5736,2.15053 -0.7573,0.46801 -1.0317,1.40947 -0.6098,2.09213 0.422,0.68267 0.1317,1.24121 -0.6449,1.24121 -0.7766,0 -1.412,0.67497 -1.412,1.49994 0,1.96902 -6.8527,17.26467 -8.8857,19.83339 -0.8706,1.1 -4.8278,6.8 -8.7939,12.66666 -10.9374,16.17881 -18.1757,24.00929 -38.8242,42 -6.3125,5.5 -11.4815,10.45 -11.4867,11 -0.01,0.55 -0.8797,1 -1.9432,1 -1.0636,0 -2.4136,0.76441 -3,1.69868 -0.5865,0.93427 -2.5663,2.66508 -4.3996,3.84625 -1.8334,1.18117 -4.6472,3.26676 -6.2531,4.63466 -6.8317,5.81937 -43.5573,29.82037 -45.6303,29.82037 -0.7975,0 -1.45,0.4795 -1.45,1.0655 0,0.586 -1.9662,1.7765 -4.3693,2.6455 -2.4031,0.869 -5.5531,2.4773 -7,3.5742 -3.1094,2.3571 -44.7333,23.0509 -55.2973,27.4917 -4.0334,1.6955 -7.7742,3.7143 -8.3129,4.4862 -0.5388,0.772 -0.9888,0.9382 -1,0.3694 -0.011,-0.5689 -1.9705,0 -4.3538,1.2605 -2.3833,1.2622 -4.9333,2.4048 -5.6667,2.5391 -0.7333,0.1343 -5.2333,2.0409 -10,4.2369 -8.3068,3.827 -12.2165,5.3964 -14.3473,5.7594 -0.5423,0.092 -2.186,0.8362 -3.6527,1.6531 -1.4666,0.8168 -3.1166,1.3576 -3.6666,1.2018 -0.55,-0.1558 -1,0.4167 -1,1.2723 0,0.8555 -0.3948,1.1608 -0.8774,0.6782 -0.4825,-0.4825 -1.6825,-0.209 -2.6666,0.6077 -0.9842,0.8168 -1.7894,1.0905 -1.7894,0.6082 0,-0.4822 -1.35,-0.127 -3,0.7895 -1.65,0.9165 -3.4,1.6876 -3.8889,1.7136 -0.4888,0.026 -1.3388,0.4972 -1.8888,1.0472 -0.55,0.55 -1.761,1 -2.691,1 -0.9301,0 -3.3801,0.6998 -5.4445,1.555 -2.0644,0.8552 -4.2034,1.6802 -4.7534,1.8333 -0.55,0.1531 -1.3,0.4284 -1.6667,0.6117 -0.3667,0.1834 -1.1167,0.4176 -1.6667,0.5205 -0.55,0.1028 -1.75,0.6633 -2.6666,1.2453 -0.9167,0.5821 -1.6667,0.7356 -1.6667,0.3412 0,-0.581 -10.239,2.7355 -21.3333,6.9102 -1.1,0.4139 -2.45,0.8793 -3,1.0343 -0.55,0.155 -1.3,0.4319 -1.6667,0.6152 -0.3667,0.1833 -1.2667,0.4833 -2,0.6667 -0.7333,0.1833 -1.4833,0.4529 -1.6667,0.599 -0.1833,0.1462 -1.8333,0.5282 -3.6666,0.8489 -1.8334,0.3207 -4.2334,0.9743 -5.3334,1.4524 -1.1,0.4782 -2.45,0.9962 -3,1.1512 -0.55,0.155 -1.15,0.4014 -1.3333,0.5475 -0.1833,0.1462 -1.8333,0.5282 -3.6667,0.8489 -1.8333,0.3207 -4.2333,0.9667 -5.3333,1.4356 -2.0891,0.8906 -3.7625,1.403 -7.6667,2.3478 -1.2833,0.3105 -2.4833,0.6855 -2.6666,0.8333 -0.1834,0.1478 -0.9334,0.4187 -1.6667,0.602 -0.7333,0.1834 -1.4833,0.4577 -1.6667,0.6097 -0.1833,0.1519 -2.1183,0.5656 -4.3001,0.9191 -2.1817,0.3536 -4.7317,1.2777 -5.6666,2.0536 -0.935,0.776 -1.6999,1.0522 -1.6999,0.6139 0,-0.4383 -1.65,-0.1585 -3.6667,0.6218 -2.0167,0.7803 -4.8667,1.7005 -6.3333,2.0449 -5.4647,1.2833 -6.675,1.6063 -7,1.8684 -0.4,0.3223 -0.8351,0.4237 -7.6565,1.7832 -2.9278,0.5835 -5.9278,1.4395 -6.6667,1.9023 -0.7389,0.4628 -2.2435,1.0304 -3.3435,1.2612 -3.2917,0.6909 -6,1.438 -6,1.6553 0,0.1122 -0.9,0.423 -2,0.6907 -1.1,0.2677 -3.35,0.8218 -5,1.2313 -1.65,0.4096 -4.35,1.0797 -6,1.4892 -1.65,0.4096 -3.9,0.9637 -5,1.2314 -1.1,0.2677 -2,0.5819 -2,0.6983 0,0.1164 -1.8,0.4916 -4,0.8337 -2.2,0.3421 -6.4,1.2938 -9.3333,2.1149 -2.9334,0.8212 -5.9334,1.6568 -6.6667,1.8571 -3.2443,0.886 -8.2633,2.0384 -11.3333,2.6023 -1.8334,0.3367 -4.8334,0.9997 -6.6667,1.4735 -5.8947,1.5231 -7.2827,1.8537 -10,2.382 -1.4667,0.2852 -4.1667,0.8966 -6,1.3587 -1.8333,0.4621 -4.5333,1.1045 -6,1.4275 -1.4667,0.323 -4.1667,0.9246 -6,1.3368 -1.8333,0.4123 -4.8333,1.0189 -6.6667,1.348 -4.1217,0.74 -7.667,1.4786 -12,2.4998 -1.8333,0.4321 -4.8333,1.0732 -6.6666,1.4248 -1.8334,0.3515 -4.8334,0.9515 -6.6667,1.3333 -1.8333,0.3818 -4.8333,0.9853 -6.6667,1.3411 -1.8333,0.3558 -5.1333,1.0039 -7.3333,1.4402 -2.2,0.4363 -5.3516,1.0243 -7.0036,1.3067 -6.6638,1.1392 -13.9183,2.5468 -20.3297,3.9445 -1.8334,0.3997 -5.4334,1.045 -8,1.434 -8.5612,1.2976 -11.3084,1.767 -14.6667,2.5059 -3.3259,0.7317 -9.6891,1.8157 -16,2.7256 -1.8333,0.2644 -4.8333,0.77 -6.6667,1.1236 -1.8333,0.3536 -5.7333,1.0309 -8.6666,1.5051 -2.9334,0.4741 -6.8334,1.1136 -8.6667,1.4211 -1.8333,0.3074 -5.4333,0.8502 -8,1.2062 -2.5667,0.3559 -6.4667,0.9505 -8.6667,1.3213 -2.2,0.3707 -6.1,1.012 -8.6666,1.4251 -2.5667,0.4131 -6.1667,1.0055 -8,1.3165 -8.8098,1.4943 -16.1531,2.6073 -26.6667,4.0418 -2.5667,0.3501 -6.7667,0.9362 -9.3333,1.3024 -4.2256,0.6028 -9.8814,1.2562 -22.32,2.5785 l -4.32,0.4592 z m -1040.62257,-4.7813 c -0.42439,-0.6866 -1.8098,-1.2566 -3.07869,-1.2665 -3.84684,-0.03 -25.3238,-3.7892 -42.80591,-7.4922 -9.07435,-1.9221 -18.07435,-3.7317 -20,-4.0214 -1.92565,-0.2897 -8.90118,-1.7775 -15.50118,-3.3062 -29.80563,-6.9035 -33.45029,-7.7033 -35.33333,-7.7537 -1.1,-0.029 -5.3,-0.9561 -9.33333,-2.0592 -4.03334,-1.1032 -9.13334,-2.322 -11.33334,-2.7085 -2.2,-0.3865 -19.89281,-4.6525 -39.31737,-9.48 -19.42455,-4.8276 -36.22455,-8.9617 -37.33333,-9.1869 -1.10878,-0.2253 -2.91597,-0.7824 -4.01597,-1.238 -1.1,-0.4556 -3.5,-1.1161 -5.33333,-1.4676 -1.83333,-0.3515 -7.1698,-1.84 -11.85882,-3.3078 -4.68902,-1.4678 -8.88902,-2.6023 -9.33333,-2.5211 -0.44432,0.081 -1.70785,-0.216 -2.80785,-0.6606 -4.62278,-1.868 -16,-4.7455 -16,-4.0466 0,0.4169 -0.76495,0.1232 -1.6999,-0.6528 -0.93494,-0.7759 -3.18494,-1.6146 -5,-1.8637 -1.81505,-0.2491 -4.0501,-0.9231 -4.96677,-1.4978 -0.91666,-0.5747 -1.66666,-0.636 -1.66666,-0.1363 0,0.4997 -0.9,0.1617 -2,-0.7512 -1.1,-0.913 -2,-1.2653 -2,-0.783 0,0.4822 -1.10718,0.2842 -2.4604,-0.44 -1.35322,-0.7242 -4.20322,-1.6768 -6.33334,-2.1169 -5.24896,-1.0846 -7.87293,-1.749 -7.87293,-1.9935 0,-0.1122 -0.9,-0.4062 -2,-0.6534 -1.1,-0.2471 -4.55,-1.3746 -7.66667,-2.5055 -3.11667,-1.1308 -5.66667,-1.7093 -5.66667,-1.2853 0,0.4239 -0.75,0.1483 -1.66666,-0.6125 -0.91667,-0.7607 -1.96667,-1.392 -2.33334,-1.4028 -0.36666,-0.011 -2.35572,-0.6618 -4.42013,-1.4467 -2.06441,-0.7849 -4.79441,-1.4271 -6.06667,-1.4271 -1.27226,0 -3.0332,-0.72 -3.9132,-1.6 -0.88,-0.88 -1.6,-1.1065 -1.6,-0.5034 0,0.6031 -0.9,0.3497 -2,-0.5633 -1.1,-0.9129 -2,-1.2129 -2,-0.6666 0,0.5462 -0.9,0.2462 -2,-0.6667 -1.1,-0.9129 -2,-1.2129 -2,-0.6667 0,0.5463 -0.75,0.3979 -1.66666,-0.3296 -1.3918,-1.1047 -9.76484,-4.3158 -13.33334,-5.1135 -0.55,-0.1229 -1.3,-0.3735 -1.66666,-0.5569 -0.36667,-0.1833 -1.26667,-0.4833 -2,-0.6666 -0.73334,-0.1834 -1.63334,-0.4834 -2,-0.6667 -0.36667,-0.1833 -1.11667,-0.4296 -1.66667,-0.5472 -0.55,-0.1177 -2.35,-0.9638 -4,-1.8803 -1.65,-0.9165 -3,-1.3314 -3,-0.922 0,0.4094 -1.35,-0.1402 -3,-1.2214 -1.65,-1.0811 -3.6,-2.0668 -4.33333,-2.1904 -0.73334,-0.1237 -2.7224,-0.753 -4.42014,-1.3984 -1.69774,-0.6455 -3.65588,-1.1736 -4.35142,-1.1736 -1.2999,0 -2.77006,-0.6536 -10.19543,-4.5322 -2.36518,-1.2354 -4.76518,-2.293 -5.33334,-2.3501 -0.56815,-0.057 -2.53301,-0.7317 -4.36634,-1.4991 -1.83333,-0.7673 -3.63334,-1.4667 -4,-1.5542 -0.36667,-0.087 -2.16667,-0.9891 -4,-2.0037 -1.83334,-1.0145 -3.63334,-1.8076 -4,-1.7623 -0.36667,0.045 -3.06667,-1.1421 -6,-2.6385 -2.93334,-1.4965 -5.47077,-2.6596 -5.63875,-2.5847 -1.12888,0.5033 -48.83201,-22.5658 -52.02792,-25.1605 -0.91667,-0.7443 -1.67585,-0.8795 -1.68708,-0.3006 -0.0112,0.5789 -0.46123,0.3831 -1,-0.435 -1.16667,-1.7717 -12.54627,-7.835 -13.97959,-7.4487 -0.55,0.1483 -1,-0.194 -1,-0.7606 0,-0.5665 -2.25,-2.2108 -5,-3.6539 -2.75,-1.443 -5.3,-2.9295 -5.66666,-3.3032 -1.46858,-1.4967 -21.18697,-14.6794 -21.95711,-14.6794 -0.45427,0 -2.44363,-1.5 -4.4208,-3.3333 -1.97716,-1.8334 -4.0763,-3.33336 -4.66475,-3.33336 -1.2055,0 -2.3274,-0.8488 -8.95735,-6.77684 -2.56666,-2.29494 -6.16666,-5.16934 -8,-6.38756 -6.61053,-4.39259 -36,-32.61488 -36,-34.5703 0,-0.61475 -1.42543,-2.35714 -3.16764,-3.87196 -1.7422,-1.51483 -4.27156,-4.62303 -5.62081,-6.90712 -1.34924,-2.28408 -2.9238,-4.15288 -3.49902,-4.15288 -0.57523,0 -1.04586,-0.9 -1.04586,-2 0,-1.1 -0.6,-2 -1.33333,-2 -0.73334,0 -1.33334,-0.9 -1.33334,-2 0,-1.1 -0.6,-2 -1.33333,-2 -0.73333,0 -1.33333,-0.85714 -1.33333,-1.90476 0,-1.04762 -0.75,-2.69762 -1.66667,-3.66667 -2.06162,-2.17942 -6.90103,-12.06545 -6.57357,-13.42857 0.13213,-0.55 -0.45976,-1 -1.31532,-1 -0.85556,0 -1.16076,-0.3948 -0.67823,-0.87732 0.48252,-0.48253 0.20905,-1.68253 -0.60771,-2.66667 -0.81676,-0.98414 -1.09045,-1.78934 -0.60819,-1.78934 0.48226,0 0.13459,-1.35 -0.77261,-3 -0.9072,-1.65 -1.7821,-3.79686 -1.94422,-4.77079 -0.16212,-0.97393 -0.72428,-2.77393 -1.24925,-4 -2.81086,-6.56478 -3.66718,-23.04513 -1.86696,-35.93076 2.16992,-15.53186 2.13794,-15.34349 2.99413,-17.63178 0.98473,-2.63182 5.47988,-16.47747 5.62747,-17.33334 0.18164,-1.05333 5.65306,-10.81533 9.34136,-16.66666 1.84898,-2.93333 3.72231,-6.38333 4.16295,-7.66667 0.44064,-1.28333 1.33119,-2.33333 1.97899,-2.33333 0.6478,0 1.17783,-0.9 1.17783,-2 0,-1.1 0.6,-2 1.33333,-2 0.73333,0 1.33333,-0.61622 1.33333,-1.36938 0,-0.75316 1.95,-3.45396 4.33334,-6.00179 12.82817,-13.71354 26.21007,-27.02135 30.12898,-29.96216 7.45965,-5.59784 11.04235,-8.56049 13.30218,-11 1.18881,-1.28333 2.94697,-2.33333 3.90701,-2.33333 0.96003,0 2.09088,-0.9 2.51299,-2 0.42211,-1.1 1.53909,-2 2.48217,-2 0.94308,0 2.06006,-0.9 2.48217,-2 0.42211,-1.1 1.6863,-2 2.80932,-2 1.12301,0 2.04184,-0.46356 2.04184,-1.03013 0,-0.56657 2.1,-2.16105 4.66667,-3.5433 2.56667,-1.38224 4.66667,-3.01868 4.66667,-3.63653 0,-0.61786 0.9,-1.12338 2,-1.12338 1.1,0 2,-0.6 2,-1.33333 0,-0.73333 0.9,-1.33333 2,-1.33333 1.1,0 2,-0.6 2,-1.33334 0,-0.73333 0.9,-1.33333 2,-1.33333 1.1,0 2,-0.6 2,-1.33333 0,-0.73334 0.62532,-1.33334 1.38961,-1.33334 0.76428,0 2.11428,-0.60845 3,-1.35211 3.2811,-2.75487 11.8188,-8.00002 23.61258,-14.50641 11.83474,-6.52899 13.13503,-6.67549 13.09015,-1.47481 -0.0195,2.25714 1.01675,9.67195 2.32984,16.67134 0.48407,2.5803 1.42189,5.02628 2.08405,5.43552 0.66217,0.40924 0.87056,1.28348 0.4631,1.94277 -2.49644,4.03932 17.94512,48.20341 31.45116,67.95037 28.17876,41.19972 72.83667,68.51908 118.1205,81.70878 11.63593,3.38916 17.62404,12.46543 142.27393,89.62454 72.26631,44.73329 131.7521,82.35249 132.19063,83.59809 0.43852,1.2457 1.04201,4.8457 1.34107,8 1.31726,13.8937 2.21428,19.0152 5.82632,33.2649 4.97889,19.642 12.05457,38.5181 20.66802,55.137 9.02038,17.4041 19.71706,35.3333 21.08,35.3333 0.59348,0 1.07905,0.9 1.07905,2 0,1.1 0.67347,2 1.4966,2 1.03401,0 0.98354,0.6182 -0.16326,2 -1.9013,2.291 -3.50173,2.5516 -4.61423,0.7515 z M 497.08335,879.08913 c 0.9625,-0.38516 2.1125,-0.33779 2.55555,0.10526 0.44306,0.44306 -0.34444,0.75819 -1.75,0.70029 -1.55325,-0.064 -1.8692,-0.37992 -0.80555,-0.80555 z"
		 id="path4"
		 sodipodi:nodetypes="ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssscsssssssscssssssssssscssssssssssscssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssscsssssscsssssssscsssssssssssssssssssssssssssssssssssssscscsssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss" />
	      <path
		 id="path3"
		 style="fill:#79c0ab"
		 d="m 2179.0006,872.53256 c -22.9654,5.27761 -20.0386,5.17311 -160.9512,5.73633 -131.3422,0.52497 -140.9237,0.82571 -138.7422,4.35547 1.5019,2.43007 9.0056,33.44529 13.2363,54.70898 6.0424,30.36829 9.2162,66.75266 8.375,95.99996 -0.3481,12.1 -0.2202,20.5034 0.2832,18.6739 0.7308,-2.6557 28.3242,-20.4813 136.8575,-88.41019 74.7676,-46.79563 137.8901,-86.06006 140.2734,-87.2539 5.2854,-2.64758 5.6922,-4.96517 0.668,-3.81055 z m -1687.24027,5.31836 c -0.79174,-0.48932 -1.21206,-0.23502 -0.93359,0.56445 0.27847,0.79947 59.60671,38.09217 131.83984,82.87305 123.21818,76.38898 131.35996,81.66758 131.75195,85.40038 0.97634,9.2973 1.39426,2.3175 1.38086,-23.0215 -0.0122,-23.1472 1.44243,-48.18859 3.34961,-57.66794 0.29509,-1.46666 0.94792,-5.36602 1.45118,-8.66602 1.80239,-11.81897 7.47657,-39.64156 11.5957,-56.86523 2.30616,-9.64299 3.82349,-18.49407 3.37305,-19.66797 -0.74391,-1.9386 -13.73017,-2.13011 -141.59375,-2.09571 -77.42612,0.0208 -141.42312,-0.36419 -142.21485,-0.85351 z"
		 sodipodi:nodetypes="ssssssssssssssssssss" />
	      <path
		 id="path2"
		 style="fill:#091a28"
		 d="m 886.36385,130.80014 c -87.24656,1.12056 -190.25283,27.35813 -266.56641,69.16992 -70.01526,38.36098 -129.70311,89.13185 -181.06641,154.01562 -18.83223,23.78949 -34.23254,48.98963 -55.41601,90.68164 -26.32141,51.8042 -41.56924,95.4066 -52.09961,148.97657 -1.26782,6.4496 -3.24036,12.48858 -4.41992,13.53515 -1.17129,1.03924 -6.02826,3.51921 -10.79492,5.51172 -4.76667,1.99251 -15.26734,6.91746 -23.33399,10.94531 -101.19333,50.52804 -175.3774,126.11317 -193.36328,197.01563 -14.410562,56.80811 -1.130307,112.63637 39.5957,166.46094 44.32346,58.57906 132.76157,116.48606 245.08985,160.47856 24.03858,9.4145 100.67685,35.5629 129.34375,44.1308 81.53604,24.3692 176.32422,45.605 289.44922,64.8477 73.06887,12.4291 193.38686,26.9743 271.21878,32.7871 77.8682,5.8155 141.7043,10.0079 180.666,11.8633 120.4444,5.7361 427.776,-2.1521 693.334,-48.6289 104.3413,-18.2614 174.4107,-34.0107 249.332,-56.043 88.426,-26.0036 144.3149,-47.3548 207.334,-79.209 84.6937,-42.8101 134.8208,-77.7466 172.8672,-120.47852 51.8974,-58.28886 68.2412,-111.66696 52.5195,-171.52734 -7.0838,-26.97176 -15.2836,-44.43435 -32.6992,-69.63281 -13.7107,-19.83784 -49.8888,-56.96471 -72.6875,-74.59375 -44.5888,-34.47833 -95.6059,-61.81388 -162.666,-87.15821 -13.2,-4.98872 -24.71,-9.60767 -25.5762,-10.26367 -0.8662,-0.656 -2.2293,-4.24425 -3.0293,-7.97461 -2.041,-9.51674 -9.9797,-37.435 -15.625,-54.94726 -20.3229,-63.04356 -56.3847,-127.60406 -102.3691,-183.26563 -13.3344,-16.14048 -50.3236,-53.26468 -68.7344,-68.98633 -65.1982,-55.67507 -139.9263,-94.461 -226.6836,-117.65234 -16.5602,-4.42675 -61.9101,-13.25317 -84.6504,-16.47656 -18.9105,-2.68052 -26.6333,-3.02358 -68,-3.01758 -36.8674,0.005 -50.7264,0.50954 -66,2.40625 -130.549,16.21178 -237.5616,63.59697 -326,144.35352 -6.6,6.0267 -20.0895,19.1151 -29.9785,29.08398 -9.8891,9.96887 -18.3968,18.125 -18.9063,18.125 -0.5095,0 -13.4193,-12.47911 -28.6875,-27.73047 -36.6502,-36.60997 -65.4466,-59.31186 -105.2851,-83.00391 -80.3478,-47.78304 -169.2502,-75.03634 -269.80862,-82.71289 -11.69682,-0.89292 -23.83894,-1.24601 -36.30273,-1.08593 z m 832.58205,100.70507 c 0.5796,0.35823 1.068,37.36689 1.084,82.24024 0.033,93.05832 -0.6578,87.28761 11.9023,99.52148 13.8999,13.53888 32.9358,18.15793 49.7422,12.06836 15.0999,-5.47119 26.7818,-15.06206 31.4102,-25.78711 1.2262,-2.84167 1.6264,-22.71213 1.6054,-79.77929 -0.015,-41.798 -0.4043,-78.34618 -0.8633,-81.2168 -1.0684,-6.68148 0.4608,-6.74499 10.918,-0.45313 25.0212,15.05475 47.4553,39.79271 61.5899,67.91211 11.6172,23.11156 20.1686,52.98412 21.5839,75.40235 0.8431,13.35591 1.4806,16.34535 4.7676,22.38476 4.8165,8.84937 13.4086,16.78646 23.0801,21.32032 6.6877,3.13506 9.193,3.54882 21.5664,3.54882 13.004,0 14.6467,-0.30699 23.0703,-4.29687 12.2559,-5.80504 23.5069,-17.07538 27.3809,-27.42969 3.5163,-9.39805 3.7902,-22.42413 0.7539,-35.77344 -2.4497,-10.77066 -10.6492,-31.57802 -16.711,-42.40625 -6.3768,-11.39096 -20.8334,-31.95286 -28.0312,-39.86914 -3.5543,-3.90908 -6.4629,-7.5681 -6.4629,-8.13281 0,-3.86481 35.0194,7.98514 58.1836,19.68945 65.3365,33.01311 130.3867,94.15984 171.1582,160.88477 35.4994,58.09687 54.1971,121.44075 56.8926,192.75 1.433,37.90853 -2.7339,62.45486 -14.877,87.6543 -14.311,29.69823 -34.4113,46.17068 -64.0234,52.46679 -6.1975,1.31772 -40.7458,1.71366 -153.334,1.75586 -79.9332,0.03 -150.8836,-0.12107 -157.668,-0.33593 -11.8016,-0.37376 -12.4308,-0.54773 -14.5312,-4.00782 -19.1772,-31.59044 -51.6906,-74.25707 -80.2149,-105.26562 -30.1166,-32.73959 -83.0058,-76.46182 -133.4004,-110.27735 -9.6343,-6.46482 -17.5178,-12.12583 -17.5078,-12.58007 0.019,-1.47437 7.088,-4.16016 10.9512,-4.16016 2.0696,0 9.2988,2.16519 16.0664,4.81055 11.5753,4.52466 13.0159,4.77565 24.3047,4.24609 9.1489,-0.42918 13.4255,-1.29777 18,-3.6543 15.2631,-7.8628 22.2246,-17.8536 20.9355,-30.04882 -1.6355,-15.47315 -18.6076,-34.73082 -39.6425,-44.98243 -18.4534,-8.99345 -26.1083,-10.94306 -42.625,-10.85156 -27.4354,0.15199 -49.24,8.99095 -69.8243,28.30664 -6.0061,5.63607 -16.8437,19.98344 -16.8437,22.29883 0,3.24483 -4.0463,2.89069 -18.1758,-1.58789 -50.3293,-15.9527 -94.8371,-23.5874 -169.5801,-29.08594 -8.3818,-0.61661 -9.3811,-1.32244 -7.082,-5.0039 0.9495,-1.52041 5.0404,-9.14322 9.0918,-16.93946 8.2685,-15.91177 14.0367,-25.88292 22.7871,-39.39258 48.9523,-75.57762 127.5519,-138.46488 196.7754,-157.43945 6.7011,-1.83681 12.935,-3.34127 13.8516,-3.3418 2.9281,-0.002 1.8083,2.76233 -3.6153,8.92383 -14.6691,16.665 -31.7772,47.47463 -40.207,72.40821 -3.8738,11.45795 -4.2932,14.25771 -4.3965,29.33398 -0.1071,15.62702 0.1081,17.08953 3.4668,23.45508 4.4811,8.49257 16.0477,19.18394 26.086,24.11328 6.9335,3.40477 9.0041,3.76562 21.666,3.76562 13.4562,0 14.3108,-0.17614 22,-4.52539 9.9428,-5.62391 17.2937,-11.8318 21.8066,-18.41406 3.1997,-4.66694 3.5348,-6.51434 4.2969,-23.72851 0.8075,-18.24269 1.0009,-19.17967 8.4844,-41.28321 12.6959,-37.49976 22.3677,-55.71089 40.4961,-76.25 13.1379,-14.88511 38.6301,-34.95789 41.8613,-32.96094 z m -771.01174,0.84766 c 5.47238,0.53912 24.03142,14.14151 38.76367,28.91211 22.63277,22.69165 38.39617,49.55347 49.72267,84.73438 5.811,18.04952 6.6014,22.20248 6.9082,36.27148 0.256,11.74445 0.7941,14.61851 3.9277,21.02344 4.608,9.41826 14.8545,19.9838 23.0528,23.76953 5.3493,2.47018 8.6818,2.93145 21.0234,2.90625 13.1929,-0.0269 15.4105,-0.39192 22.0625,-3.63477 4.0674,-1.9828 10.1839,-6.27765 13.5918,-9.54297 11.5447,-11.0617 15.295,-23.0917 12.9883,-41.65429 -3.853,-31.00648 -19.9477,-67.20504 -42.3086,-95.1543 -7.9747,-9.96777 -10.2532,-14.38483 -6.666,-12.92187 0.9167,0.37382 7.3653,2.96117 14.332,5.75 34.6956,13.889 78.9639,39.44466 104.0664,60.07812 20.3696,16.74314 61.4159,57.24636 65.2227,64.35938 1.2399,2.31674 1.1722,3.53808 -0.3204,5.83984 -4.3016,6.63401 -28.1871,51.18636 -40.5195,75.57812 l -10.4492,20.66602 -10.666,1.63281 c -5.8667,0.89852 -22.6674,4.70597 -37.334,8.45899 -14.6667,3.75301 -29.3236,7.49359 -32.5723,8.3125 -4.6183,1.16413 -6.0285,1.12328 -6.4648,-0.18555 -2.5058,-7.51727 -19.3039,-26.90811 -29.2227,-33.73242 -17.3392,-11.92969 -34.5986,-16.60887 -56.9941,-15.45508 -22.75,1.17206 -43.2295,10.5479 -60.2754,27.59375 -22.79387,22.79387 -23.13742,47.3362 -0.81445,58.25781 10.29098,5.03491 25.46565,5.84105 38.17775,2.02735 8.6232,-2.58702 12.834,-2.64831 12.834,-0.18555 0,0.60824 -8.1356,6.39413 -18.0782,12.85742 -9.9425,6.46329 -24.1919,15.74805 -31.66597,20.63281 -22.25649,14.54599 -48.01298,36.20514 -75.05079,63.11328 -28.38476,28.24866 -41.53841,43.20816 -62.14257,70.67188 -15.80344,21.06472 -26.8033,37.60614 -34.51563,51.9043 -5.15609,9.55907 -5.36655,9.75427 -11.41992,10.58398 -9.37587,1.2851 -304.12882,0.70025 -312.03125,-0.61914 -18.29786,-3.05501 -36.74709,-13.38738 -50.57813,-28.32617 -21.24398,-22.94547 -31.66366,-52.36305 -31.48242,-88.87695 0.22453,-45.23271 14.27018,-105.39262 37.16797,-159.20118 19.28719,-45.32385 48.96388,-91.03299 84.05664,-129.46484 45.03541,-49.32054 101.23745,-87.49692 156.32227,-106.18359 6.18756,-2.09903 11.43887,-3.81641 11.66797,-3.81641 1.73097,0 -0.34353,5.35915 -4.06055,10.48828 -7.51161,10.36531 -19.33566,31.41137 -25.74805,45.83399 -12.84267,28.88546 -16.71983,59.0992 -9.5625,74.5039 14.91394,32.09921 56.43504,40.45817 81.5293,16.41211 11.94178,-11.44297 13.21876,-14.44149 14.32617,-33.62305 0.5625,-9.74317 2.23937,-22.05061 3.94531,-28.94921 8.60402,-34.79352 29.48103,-74.92255 49.6211,-95.38282 10.79051,-10.96204 34.8626,-27.89599 36.84375,-25.91797 0.47014,0.4694 1.15482,37.85521 1.52148,83.07813 l 0.66602,82.22266 3.79883,6.46289 c 4.91087,8.35485 12.14862,15.31217 21.07031,20.2539 6.63317,3.67413 8.10842,3.95117 21.13086,3.95117 12.39874,0 14.87291,-0.40951 21.625,-3.57421 9.63927,-4.51792 20.68131,-14.71739 24.00976,-22.17774 2.44178,-5.47299 2.56467,-9.65984 2.53907,-86.66601 -0.0148,-44.50365 0.40361,-81.9856 0.93164,-83.29297 0.19824,-0.49085 0.71432,-0.68054 1.49609,-0.60352 z M 2017.3326,467.6224 c -11.5397,0.06 -15.8738,0.70221 -24.666,3.66016 -18.1852,6.11806 -28.2118,12.19187 -40.7461,24.67969 -19.2175,19.14624 -24.3212,33.91873 -16.1582,46.77734 5.9804,9.42053 14.9504,15.4495 26.9043,18.08594 4.0334,0.88955 8.5568,1.66701 10.0527,1.72851 4.7109,0.19354 16.8925,-3.52853 27.6738,-8.45703 16.6787,-7.6243 18.3413,-7.59096 35.8809,0.70508 14.4347,6.82745 15.5994,7.14385 28.0625,7.64844 11.9764,0.48488 13.58,0.24406 20.3184,-3.05274 7.5102,-3.67441 15.3766,-11.80191 17.9336,-18.52734 2.693,-7.08314 1.6363,-13.44833 -4.1602,-25.0293 -8.0887,-16.16078 -24.1402,-32.13106 -39.7617,-39.5625 -14.254,-6.78095 -23.652,-8.74825 -41.334,-8.65625 z m -1360.36914,0.40821 c -4.8881,0.28508 -9.54136,0.94727 -13.6836,2.01171 -35.01112,8.99696 -68.43222,44.51543 -64.01953,68.03711 1.59944,8.52572 13.87427,19.85957 24.6582,22.76758 12.4124,3.34715 22.57219,1.49245 41.19141,-7.51562 7.57754,-3.66606 14.96088,-6.66407 16.40625,-6.66407 1.44536,0 8.95644,3.12922 16.69141,6.95508 13.84738,6.8492 14.25147,6.9564 26.26172,6.9668 9.57646,0.008 13.48666,-0.58721 18.19726,-2.77149 14.12922,-6.55163 24.99413,-21.02603 23.59766,-31.4375 -2.48917,-18.55815 -21.93045,-40.08591 -46.39258,-51.37304 -11.46308,-5.28921 -28.24393,-7.83183 -42.9082,-6.97656 z m 618.81444,119.96875 c 1.1684,-10e-6 1.5525,19.84657 1.5625,79.66796 0,53.9882 0.4813,81.37465 1.4785,84.9668 1.8035,6.49611 15.2926,20.23511 24.0098,24.45508 24.1327,11.68241 55.973,1.19043 67.4766,-22.23438 l 3.6953,-7.52148 0.4004,-79 c 0.3027,-59.5506 0.7895,-79 1.9746,-79 0.8647,0 5.1832,2.20039 9.5976,4.89062 32.234,19.6438 54.3721,48.69256 72.1328,94.64649 7.4606,19.30337 9.5068,27.45235 11.0723,44.125 1.5735,16.75794 5.5957,25.6888 15.7734,35.01562 13.5168,12.3868 30.0129,16.9385 46.5743,12.85157 16.3379,-4.03182 30.6864,-15.26629 36.8632,-28.86328 3.7022,-8.14956 3.6225,-23.70076 -0.1972,-38 -3.8455,-14.39632 -18.1521,-42.82013 -28.8946,-57.41016 -16.2454,-22.064 -16.6488,-23.45168 -5.5761,-19.12891 38.4183,14.99848 68.8664,30.43838 92.2793,46.79492 24.5109,17.12369 33.1617,24.3842 56.0937,47.07813 67.5308,66.8296 112.2522,158.43239 124.0371,254.06641 2.5648,20.81345 1.8664,60.85625 -1.3359,76.59965 -5.8276,28.6506 -21.0152,52.7467 -41.8438,66.3886 -12.0535,7.8946 -18.2106,10.0817 -32.6914,11.6074 -15.733,1.6577 -802.13194,1.4843 -814.25973,-0.1796 -17.95428,-2.4632 -38.72698,-16.8239 -50.51954,-34.9239 -7.16238,-10.9932 -14.12563,-28.1187 -17.82031,-43.83 -2.58668,-10.9997 -2.91603,-16.1474 -2.92773,-45.7286 -0.0149,-37.5112 0.80351,-43.45595 11.99023,-87.07027 7.25214,-28.27436 16.38649,-53.10855 29.48438,-80.15625 14.7831,-30.52777 23.79405,-45.2857 45.57226,-74.63672 39.1655,-52.78429 86.78004,-93.73137 138.79884,-119.36719 20.5606,-10.13266 46.7539,-19.95776 46.7539,-17.53711 0,0.46972 -3.2089,5.48476 -7.1309,11.14453 -16.2798,23.49297 -28.5162,49.66695 -32.2285,68.93555 -4.4564,23.13119 -0.433,38.51662 13.3711,51.13281 10.1307,9.25889 17.5965,12.56277 30.0078,13.28125 17.7229,1.02596 32.4661,-5.12595 44.5801,-18.59961 7.5186,-8.36246 10.6659,-16.89807 12.6758,-34.36914 4.0682,-35.3645 26.7956,-80.6796 54.9082,-109.48242 9.1019,-9.32535 38.4878,-30.60937 42.2617,-30.60937 z m 1066.8125,78.66796 c 8.3937,0 66.7795,28.80752 98.8516,48.77344 54.2664,33.78264 85.0591,60.90505 105.8418,93.22656 8.1881,12.73419 10.0691,16.68213 14.5976,30.62891 2.8318,8.72134 3.4487,13.14908 3.4297,24.66602 -0.041,24.81374 -5.6203,42.03427 -21.2734,65.6582 -22.6929,34.2483 -68.5703,73.38305 -119.7813,102.17965 -44.8696,25.2308 -109.9083,53.7984 -161.5898,70.9746 -47.0462,15.6357 -120.9656,35.9297 -176.666,48.502 -64.2568,14.5037 -177.4437,34.5315 -230,40.6973 -6.9667,0.8173 -13.9515,1.8058 -15.5215,2.1972 -5.0924,1.2694 -4.516,-1.6213 1.789,-8.9707 16.2047,-18.8886 39.1489,-59.4197 47.002,-83.0293 14.5478,-43.7369 15.7096,-102.29609 3.2715,-164.83786 -4.2279,-21.25861 -11.7312,-52.27681 -13.2344,-54.70898 -2.1815,-3.52976 7.3998,-3.8305 138.7422,-4.35547 146.0061,-0.58358 139.7233,-0.30235 167.9512,-7.55469 38.212,-9.81751 82.4352,-44.47039 111.0976,-87.05664 19.6513,-29.19754 37.5197,-76.04624 42.2071,-110.6582 0.6665,-4.92099 1.3999,-6.33204 3.2851,-6.33204 z M 324.18221,692.88607 c 1.95838,0.59378 2.29866,3.62953 2.93164,9.68555 1.19602,11.44288 9.53034,37.63334 16.91601,53.15625 16.85709,35.42954 38.58876,62.60037 67.04492,83.82422 23.30671,17.38316 38.08738,24.92728 66.06446,33.7207 l 17.16211,5.39453 h 140.22461 c 127.32578,0 140.29942,0.19515 141.04297,2.13282 0.45037,1.17367 -1.06689,10.02498 -3.37305,19.66797 -7.42753,31.0575 -13.71695,66.40214 -15.52735,87.27148 -1.33348,15.37181 -0.87241,61.96451 0.71094,71.90231 6.16372,38.6858 20.48433,76.173 41.39453,108.3575 4.52624,6.9666 8.51856,13.4172 8.8711,14.3339 0.75137,1.9536 -4.78342,1.9994 -14.97852,0.125 -3.66666,-0.6741 -15.06733,-2.7361 -25.33398,-4.582 -52.71093,-9.4772 -162.10672,-35.6232 -228,-54.4941 -84.31348,-24.1463 -142.59728,-45.9909 -203.33203,-76.2071 -48.56528,-24.1616 -88.69251,-51.90527 -119.33204,-82.50778 -29.26897,-29.23361 -48.66796,-66.95831 -48.66796,-94.63671 0,-16.09686 5.78691,-40.45281 12.98632,-54.66016 12.12794,-23.93333 34.6426,-49.76642 61.76368,-70.86133 21.63025,-16.82413 55.027,-39.4772 68.78906,-46.66016 7.10681,-3.70932 10.6842,-5.55667 12.64258,-4.96289 z m 767.01169,138.58789 c -17.8871,0.95567 -35.3627,7.97334 -50.7422,20.57422 -19.582,16.04432 -29.5215,37.25825 -24.5351,52.36719 2.332,7.06604 14.1809,17.35358 22.9687,19.94141 13.0252,3.83562 23.0837,2.45666 41.4141,-5.67969 6.6204,-2.93863 13.5354,-5.34375 15.3672,-5.34375 1.8317,0 8.2071,2.22195 14.166,4.9375 14.2868,6.51059 24.8722,7.33728 38.3672,2.99805 17.7402,-5.70422 29.0943,-18.66202 27.2324,-31.07813 -3.8012,-25.34834 -34.5622,-52.09609 -66.2773,-57.63281 -5.9919,-1.04604 -11.9986,-1.40254 -17.961,-1.08399 z m 424.8496,0.23243 c -22.8814,0.016 -42.7093,8.7163 -61.4472,26.96093 -25.6174,24.94311 -24.1603,45.94461 4.2265,60.88672 6.4927,3.41757 8.4479,3.77642 20.5098,3.77735 12.5223,9.7e-4 14.017,-0.30219 24.5684,-4.99805 6.1791,-2.75 12.9001,-5 14.9355,-5 2.0354,0 8.4695,2.09719 14.2988,4.66016 5.8292,2.56296 12.9096,5.20186 15.7325,5.86523 7.791,1.83082 12.6213,1.67959 20.4277,-0.63867 12.9892,-3.85737 23.4578,-12.71864 26.7266,-22.62305 6.1193,-18.54187 -12.6574,-45.87008 -41.3946,-60.24609 -12.1375,-6.07186 -23.667,-8.65493 -38.584,-8.64453 z"
		 sodipodi:nodetypes="sssssssssssssssssssssssssssssscssssssssssssscsssssssssssssssssssscsscssssssssssssscscsssssssssssssssssssssssssssccccssssssssssssssssssssssssssssssccssssssssssssssssssssssssssssscssssscsscccsssssssssssssssssssssssssssssssssssssssssssssssssssssssssccssssssssssssssssssssssssssssssssssssssss" />
	    </g>
	  </g>
        </svg>
        <div class="message is-success">
          <svg id="checkbox" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 512 512">
            <path d="M256 32C132.3 32 32 132.3 32 256s100.3 224 224 224 224-100.3 224-224S379.7 32 256 32zm114.9 149.1L231.8 359.6c-1.1 1.1-2.9 3.5-5.1 3.5-2.3 0-3.8-1.6-5.1-2.9-1.3-1.3-78.9-75.9-78.9-75.9l-1.5-1.5c-.6-.9-1.1-2-1.1-3.2 0-1.2.5-2.3 1.1-3.2.4-.4.7-.7 1.1-1.2 7.7-8.1 23.3-24.5 24.3-25.5 1.3-1.3 2.4-3 4.8-3 2.5 0 4.1 2.1 5.3 3.3 1.2 1.2 45 43.3 45 43.3l111.3-143c1-.8 2.2-1.4 3.5-1.4 1.3 0 2.5.5 3.5 1.3l30.6 24.1c.8 1 1.3 2.2 1.3 3.5.1 1.3-.4 2.4-1 3.3z"></path>
        </svg>
          <div class="message-content">
            <div class="message-title">
              Completing the sign-in process...
            </div>
          </div>
        </div>
        <hr />
        <h1>Not sure how to get started?</h1>
        <a href="https://openbao.org/docs" rel="noreferrer noopener">
         <span class="icon">
          <svg width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
    <path d="M13.307 1H11.5a.5.5 0 1 1 0-1h3a.499.499 0 0 1 .5.65V3.5a.5.5 0 1 1-1 0V1.72l-1.793 1.774a.5.5 0 0 1-.713-.701L13.307 1zM12 14V8a.5.5 0 1 1 1 0v6.5a.5.5 0 0 1-.5.5H.563a.5.5 0 0 1-.5-.5v-13a.5.5 0 0 1 .5-.5H8a.5.5 0 0 1 0 1H1v12h11zM4 6a.5.5 0 0 1 0-1h3a.5.5 0 0 1 0 1H4zm0 2.5a.5.5 0 0 1 0-1h5a.5.5 0 0 1 0 1H4zM4 11a.5.5 0 1 1 0-1h5a.5.5 0 1 1 0 1H4z"/>
  </svg> 
          </span>
          Check out the official OpenBao documentation
        </a>
      </div>
    </div>
	<script>
		window.opener.postMessage({ source: 'oidc-callback', path: "%s", code: "%s", state: "%s"}, window.origin);
	</script>
  </body>
</html>
`
	return fmt.Sprintf(html, path, code, state)
}
