/* ----- core/scale3sntrup761, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_scale3sntrup761_checksums[] = {
  "f6b9859408d1cc2e2701b8df30a0f1d79d7f5a2ecdd6540b2b0581dfda36cdb2",
  "d6657470f469bfb6616dcac8f672f028e435e89289a47b1987ce736dc189aef5",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_scale3sntrup761_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_scale3sntrup761_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_scale3sntrup761_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_scale3sntrup761_CONSTBYTES

static void *storage_core_scale3sntrup761_h;
static unsigned char *test_core_scale3sntrup761_h;
static void *storage_core_scale3sntrup761_n;
static unsigned char *test_core_scale3sntrup761_n;
static void *storage_core_scale3sntrup761_k;
static unsigned char *test_core_scale3sntrup761_k;
static void *storage_core_scale3sntrup761_c;
static unsigned char *test_core_scale3sntrup761_c;
static void *storage_core_scale3sntrup761_h2;
static unsigned char *test_core_scale3sntrup761_h2;
static void *storage_core_scale3sntrup761_n2;
static unsigned char *test_core_scale3sntrup761_n2;
static void *storage_core_scale3sntrup761_k2;
static unsigned char *test_core_scale3sntrup761_k2;
static void *storage_core_scale3sntrup761_c2;
static unsigned char *test_core_scale3sntrup761_c2;

#define precomputed_core_scale3sntrup761_NUM 4

static const unsigned char precomputed_core_scale3sntrup761_h[precomputed_core_scale3sntrup761_NUM][crypto_core_OUTPUTBYTES] = {
  {38,238,24,95,161,201,53,216,35,52,75,156,214,3,13,28,26,54,58,166,0,3,155,8,77,50,14,194,188,3,200,94,78,94,118,4,84,176,246,64,235,158,231,50,254,177,19,239,177,26,187,62,209,163,89,70,54,250,225,216,153,205,99,237,41,37,172,221,0,90,28,251,238,98,136,0,244,0,26,10,21,250,186,1,35,57,166,15,60,19,237,59,53,0,226,4,133,61,46,9,17,198,125,158,116,77,48,204,60,213,58,71,255,158,183,2,223,211,82,6,13,176,125,220,167,30,113,191,115,112,146,163,189,18,64,245,157,35,20,208,131,203,145,191,145,155,189,113,233,85,220,52,11,8,243,92,105,164,80,196,202,2,157,249,45,23,87,183,216,101,18,68,15,198,172,8,1,6,149,246,164,51,137,176,100,112,5,28,86,118,124,10,198,249,119,91,95,184,66,160,86,236,174,3,31,199,155,248,250,14,215,248,232,168,175,175,137,172,139,171,231,26,29,194,68,218,254,221,89,0,56,251,198,160,247,60,31,4,88,45,150,1,101,76,208,205,30,251,127,221,155,83,79,110,235,178,138,12,96,6,229,199,20,18,23,55,168,225,192,35,60,41,39,3,15,81,134,98,93,14,181,28,213,250,62,202,224,219,44,90,216,11,173,10,214,254,51,69,167,255,190,220,13,68,30,98,125,4,31,203,156,5,76,11,5,114,110,229,235,2,112,197,204,237,106,248,144,8,62,243,74,227,248,162,37,251,168,111,208,67,136,161,83,230,21,65,208,254,47,47,218,252,32,214,149,62,233,69,72,251,177,171,183,48,10,199,41,22,58,251,13,188,181,4,53,50,199,182,16,22,243,184,227,86,142,194,73,0,143,54,134,86,29,114,251,169,184,23,93,186,217,209,71,7,120,103,176,24,68,249,133,54,161,211,232,0,89,201,201,21,89,220,113,63,102,207,193,18,196,178,152,197,193,77,135,249,75,18,4,23,244,115,103,214,157,243,22,162,104,44,218,17,103,8,80,255,233,96,243,250,16,24,125,116,97,98,248,94,78,89,101,181,74,249,190,3,126,215,250,154,126,35,190,114,151,231,254,210,67,25,187,27,50,193,253,53,86,50,39,73,17,41,198,187,173,44,80,229,69,233,250,241,130,195,191,28,74,239,65,222,225,225,211,102,155,69,135,205,7,44,167,109,121,8,135,255,24,174,127,226,102,78,4,86,22,4,152,177,220,91,3,220,198,47,98,192,37,88,95,93,40,158,72,1,142,80,31,247,77,101,111,218,50,253,177,5,143,36,26,98,93,6,220,3,82,179,50,195,204,231,147,248,111,227,115,214,227,71,241,94,34,249,155,220,35,227,82,7,67,60,242,5,183,163,249,70,62,93,212,106,119,225,156,112,240,255,236,36,68,31,121,191,81,179,101,171,194,222,227,63,236,193,104,218,254,155,4,164,0,110,65,10,60,21,12,100,56,19,145,110,250,199,205,237,28,37,197,17,99,61,0,52,228,160,92,214,34,111,88,35,170,249,21,19,12,173,123,182,114,182,207,2,39,10,96,189,89,115,222,0,150,33,87,35,233,193,70,185,80,251,206,252,230,56,65,192,102,41,253,213,150,207,198,0,150,77,104,211,212,100,91,160,117,190,69,32,95,72,173,237,10,104,22,67,88,199,132,243,237,67,189,118,185,213,187,230,244,94,225,225,114,164,182,247,136,220,133,86,158,12,198,14,150,66,133,221,137,211,15,176,122,247,65,180,105,56,64,3,206,193,166,2,181,206,215,65,236,164,150,222,15,195,207,172,238,28,150,188,92,221,154,66,22,85,58,219,136,67,209,118,43,63,45,49,61,249,56,61,45,0,213,64,5,231,215,117,229,77,228,118,81,109,82,99,197,34,27,246,71,177,25,167,237,37,55,90,81,25,108,4,23,3,209,114,23,117,161,85,68,32,127,25,19,101,68,176,100,178,86,253,93,211,61,19,253,219,225,178,167,13,44,246,109,102,50,79,60,103,104,231,82,2,5,118,39,7,246,204,225,188,170,23,28,182,127,89,138,1,50,97,91,111,60,207,88,45,126,105,39,168,71,7,60,243,206,81,196,248,123,38,144,234,247,1,171,182,73,106,114,16,200,199,94,209,237,216,231,157,251,50,44,237,107,97,117,246,149,253,229,250,120,51,211,59,141,14,194,2,152,3,244,238,28,168,209,47,202,118,250,171,112,247,214,75,162,8,236,221,206,240,118,215,172,114,147,50,109,38,28,42,35,173,129,159,31,36,186,161,37,39,230,6,7,200,45,228,35,47,107,70,213,4,56,183,88,236,137,195,198,2,253,58,75,219,123,4,197,167,221,44,146,46,150,53,223,4,53,253,46,74,31,93,126,47,101,173,24,198,48,203,239,36,219,173,9,178,221,100,116,69,46,5,32,65,34,241,161,41,209,115,183,247,104,180,108,205,200,237,204,58,53,250,4,222,212,97,124,70,117,192,190,78,227,3,97,181,78,55,220,209,149,15,96,247,122,203,177,251,170,2,187,251,254,62,134,53,78,184,102,161,118,1,159,242,30,21,24,6,156,207,119,87,41,221,232,210,98,38,230,11,156,4,226,177,185,27,187,3,214,206,131,28,247,93,229,169,208,251,135,101,81,24,145,254,248,219,84,39,51,88,34,30,42,188,56,178,26,81,100,82,25,21,233,182,181,230,85,82,202,82,200,194,244,62,185,181,89,241,135,59,40,117,22,3,216,25,88,78,127,185,25,4,123,198,107,250,87,195,9,186,88,24,225,10,115,248,29,155,84,247,156,210,71,30,149,245,209,84,49,30,253,246,183,92,229,245,232,254,101,252,53,109,87,246,26,0,62,246,189,70,19,80,241,174,110,233,124,108,8,58,17,198,253,82,40,255,208,53,111,195,93,83,70,25,59,2,86,249,161,200,207,250,222,85,168,62,2,194,196,157,43,28,225,249,80,205,220,100,185,239,18,78,93,103,0,109,63,50,246,20,110,183,219,184,10,185,63,173,208,67,42,53,218,247,189,94,99,3,164,249,105,253,5,88,211,99,250,214,135,98,26,182,102,75,147,174,42,97,227,54,46,205,230,104,75,8,65,170,147,91,160,181,77,4,204,176,250,109,185,215,41,97,255,194,102,79,232,239,158,165,25,7,38,248,127,19,63,2,113,24,222,50,107,157,47,102,19,254,111,17,175,223,103,227,131,219,115,50,225,253,214,168,107,86,214,6,97,209,105,102,211,71,116,78,199,34,100,80,52,108,114,114,160,77,150,4,162,253,120,233,212,91,89,71,101,65,117,174,239,5,232,196,83,156,188,46,200,114,230,112,195,21,17,17,162,55,124,97,84,251,235,247,22,181,131,118,165,8,4,186,226,69,175,217,15,109,50,76,53,6,236,99},
  {83,42,186,7,2,79,96,195,46,22,76,12,104,113,241,247,231,206,65,87,94,8,13,7,48,254,175,60,91,106,202,51,235,95,113,72,35,169,85,239,86,42,168,39,2,243,74,67,187,241,202,85,104,111,0,53,252,207,88,165,174,39,8,195,1,233,157,113,246,69,27,171,184,83,231,77,48,30,37,195,106,70,6,7,148,69,121,176,127,62,63,110,147,176,205,97,224,180,243,75,21,253,73,194,231,82,149,51,89,9,1,211,122,176,130,71,43,203,80,157,53,52,76,77,118,38,56,105,97,92,31,3,62,107,15,77,113,59,85,199,196,2,195,48,130,159,85,219,11,250,174,107,88,254,129,165,139,165,176,168,234,162,12,109,231,47,46,221,90,76,174,75,148,178,100,166,0,177,8,240,65,206,144,184,19,161,71,253,4,210,176,86,109,77,202,158,63,8,169,176,199,1,73,46,157,247,39,252,179,6,82,5,216,46,77,113,44,253,130,255,129,80,184,55,92,250,245,71,107,228,82,201,179,169,177,167,176,215,189,49,250,7,206,110,236,49,235,4,16,50,3,168,36,254,194,172,45,39,44,175,116,5,89,178,16,45,159,175,239,97,199,155,232,194,174,93,108,244,113,36,8,3,187,196,126,24,12,225,57,8,28,198,182,11,87,223,187,2,141,233,94,109,165,102,102,201,68,248,221,99,253,107,107,85,54,235,254,248,187,109,71,161,1,251,71,60,242,229,164,22,182,174,78,197,226,15,6,155,19,196,126,76,105,15,180,249,21,253,22,55,217,183,79,200,136,54,105,79,230,80,255,68,34,197,203,167,235,7,140,90,243,15,143,20,134,245,110,31,37,231,216,108,168,182,40,167,128,115,11,19,116,78,80,46,98,85,19,111,129,48,13,17,29,15,243,164,2,228,110,39,88,106,125,209,196,195,113,216,210,237,173,156,44,108,137,200,231,162,137,91,159,220,253,11,255,159,177,193,255,100,63,209,3,76,10,108,82,250,93,7,55,81,223,70,153,195,146,67,123,171,104,247,28,25,172,45,122,236,11,40,0,12,235,211,135,215,152,160,117,54,117,198,242,175,85,251,149,58,139,161,242,199,136,249,20,31,243,210,222,61,154,215,11,8,232,225,75,112,9,46,188,193,2,5,171,160,12,52,19,169,0,234,23,15,200,227,150,253,89,5,240,12,16,171,137,160,79,61,76,57,65,163,152,113,188,248,19,112,90,42,181,224,44,37,12,249,58,57,224,215,45,109,184,117,241,31,226,173,239,7,214,68,251,116,203,206,130,211,48,248,64,164,125,221,182,105,251,57,109,15,102,162,20,163,70,88,77,104,236,255,238,176,36,46,236,247,235,9,118,79,251,240,93,8,252,220,36,100,193,6,32,40,116,202,157,22,27,24,162,85,77,33,9,47,161,74,246,252,196,4,157,33,3,83,128,32,98,208,4,218,127,162,129,43,144,182,48,71,144,196,39,55,188,51,247,58,14,23,94,27,66,185,91,103,102,77,26,59,4,37,243,113,192,249,38,214,120,99,224,241,131,85,16,248,235,178,5,8,41,17,248,101,2,108,147,255,105,115,27,190,195,100,248,88,86,240,200,193,227,7,48,2,255,57,87,7,19,59,38,163,176,103,78,28,249,3,229,62,252,182,59,41,160,65,242,247,250,161,178,52,211,8,197,22,205,201,92,216,201,202,77,248,230,114,176,192,247,90,206,39,124,252,83,0,52,168,32,240,144,43,28,167,68,77,54,250,11,11,211,0,229,19,22,75,46,95,173,167,116,0,68,57,7,43,164,9,38,41,46,70,14,71,210,236,9,87,105,182,25,202,23,51,140,194,216,70,119,107,239,33,53,179,179,215,199,171,5,4,238,212,178,169,194,51,142,98,59,253,123,74,65,235,5,90,127,252,90,185,29,41,141,76,46,176,154,200,32,82,99,255,167,212,111,245,156,197,219,47,155,53,138,48,108,1,196,165,209,220,7,253,37,17,125,14,37,18,98,114,230,93,119,228,169,194,80,2,96,228,151,73,76,104,111,102,32,65,100,206,67,2,7,76,71,84,153,200,86,190,249,250,110,14,215,244,131,112,93,105,52,88,211,251,3,224,159,58,243,82,121,173,148,1,71,95,194,48,195,209,162,14,186,213,132,0,246,54,61,0,97,60,244,51,125,2,185,156,239,188,74,213,150,176,153,162,160,100,81,1,210,217,210,73,156,83,249,53,216,6,251,84,251,50,23,227,253,107,30,14,103,251,80,65,228,5,169,90,55,101,246,12,79,251,217,249,240,23,75,84,8,232,157,235,52,4,205,176,20,180,53,208,246,215,214,205,108,253,80,5,185,252,207,59,74,6,114,56,183,191,81,219,220,215,173,244,83,1,240,35,240,205,179,52,242,202,23,25,239,17,21,164,44,166,63,210,224,40,137,239,124,23,7,5,155,171,212,73,116,23,201,6,131,15,169,100,244,19,103,2,25,0,127,247,111,83,1,252,113,245,186,96,50,225,147,186,101,255,218,250,93,91,196,110,139,4,180,161,146,100,89,156,54,191,254,4,222,159,107,53,89,33,43,74,149,26,82,174,61,229,184,188,180,52,193,13,125,189,17,241,135,220,115,55,72,254,253,55,102,91,237,104,176,55,180,208,216,247,131,93,122,214,250,223,44,65,237,204,199,171,181,94,199,231,247,255,243,213,180,76,59,81,210,198,211,92,149,255,147,249,209,52,105,253,114,3,205,28,18,239,66,104,69,2,205,252,122,110,204,1,207,203,150,193,188,192,249,18,43,65,131,223,223,244,175,207,21,169,121,87,41,215,140,199,204,238,51,38,207,109,55,8,89,9,110,204,250,235,133,217,8,94,169,6,95,104,193,65,68,253,167,169,74,173,148,33,39,2,134,157,204,33,141,212,156,117,164,178,98,194,244,50,156,35,12,166,135,173,91,207,138,34,15,96,157,198,255,248,182,247,224,183,125,80,89,251,165,251,161,197,62,7,36,252,180,101,189,13,98,166,53,54,116,112,24,97,202,103,172,6,144,220,53,75,176,17,123,68,216,0,63,102,149,182,110,87,83,247,88,83,228,172,83,208,214,5,192,99,182,171,89,212,220,26,73,8,238,230,50,7,29,231,8,207,231,247,78,254,111,81,68,73,121,117,239,50,95,89,239,211,29,69,149,60,245,31,106,42,76,48,34,221,163,1,72,185,62,25,221,247,16,65,238,168,36,250,114,117,128,53,173,170,174,68,140,201,70,197,72,99,5,253,166,84,16,255,226,33,197,156,5,71,229,238,9,12,168,104,236,39,64,53,138,212,94,73,140,90,94,107,80,253,19,231,86,221,51,82,216,7,223,91,226,249,108,234,22,8,154,2,251,220,167,118,202,55,242,2,229,116,101,105,136,4},
  {153,78,235,163,251,195,171,224,233,53,26,173,82,253,103,193,224,76,105,163,190,3,231,24,227,70,104,189,141,174,218,186,51,84,239,47,162,107,139,91,129,247,171,116,2,253,116,104,242,219,220,74,50,207,67,229,229,253,127,247,6,174,158,160,21,90,151,60,224,179,180,251,198,36,129,28,108,16,34,246,43,5,168,60,197,4,25,237,222,248,222,242,216,187,215,45,155,245,12,216,76,63,200,57,141,27,189,86,34,240,15,227,173,249,69,50,126,53,148,81,156,101,239,234,202,55,11,193,175,242,230,248,99,187,208,39,206,85,42,53,58,2,171,218,229,64,101,236,188,235,112,5,236,56,182,23,157,166,237,164,12,51,78,252,89,80,1,252,51,172,27,234,19,252,42,255,163,4,24,176,208,172,211,252,202,158,255,0,76,253,10,180,58,252,172,217,212,117,173,222,129,115,62,235,144,2,56,254,176,1,252,81,51,4,82,23,165,223,9,255,37,38,215,116,50,248,123,94,4,2,148,219,233,220,211,194,128,169,156,117,31,109,255,248,57,252,61,247,167,202,43,79,57,176,219,254,9,200,157,91,27,189,150,159,196,187,174,16,11,104,223,198,56,247,206,55,238,6,121,89,216,250,3,10,219,248,84,71,102,28,188,60,38,3,79,1,86,2,170,251,255,247,171,98,105,82,239,185,208,111,167,166,180,238,141,2,38,60,246,186,136,106,35,85,231,92,95,195,203,255,45,244,169,250,162,188,95,196,109,156,30,158,131,106,216,62,150,83,110,57,7,72,88,209,167,247,129,89,171,73,236,104,252,49,155,227,4,28,236,251,48,237,74,55,122,232,64,97,222,221,164,46,9,201,157,68,219,110,163,188,237,102,106,2,121,59,240,97,142,246,250,21,34,10,215,95,204,17,140,248,156,66,175,219,2,94,252,7,212,254,156,65,179,0,43,114,96,24,206,101,139,232,127,237,85,179,162,32,154,14,89,2,54,254,227,165,223,83,0,53,244,87,142,73,4,191,205,252,140,55,197,32,24,15,241,28,232,159,235,213,243,113,177,220,14,234,115,43,114,246,134,1,39,82,200,57,245,65,69,205,29,245,105,75,202,55,59,56,242,112,226,34,121,7,51,3,235,208,145,46,99,80,216,16,171,0,234,160,64,250,123,35,13,114,165,5,85,98,169,118,244,55,246,249,109,157,73,250,196,53,192,82,229,183,210,1,169,0,13,255,110,254,141,253,170,89,90,202,214,1,207,0,205,250,135,49,18,247,241,48,9,101,48,42,46,186,119,175,91,255,153,166,87,203,83,76,12,8,250,24,151,175,49,255,179,248,141,5,109,113,214,71,188,204,125,104,121,6,93,51,201,177,36,191,17,97,91,6,62,255,29,57,159,94,219,85,85,4,90,200,123,204,13,249,112,184,52,224,92,249,201,63,185,20,231,192,167,233,20,37,72,227,234,242,204,204,183,33,56,252,27,90,28,99,252,201,136,217,60,9,127,236,4,73,105,203,94,19,106,225,247,222,69,36,140,192,149,2,172,211,53,250,182,3,211,243,192,203,171,103,251,238,95,102,49,225,81,36,51,217,39,19,164,223,52,196,17,2,21,18,24,88,242,207,81,3,210,12,29,46,96,74,18,45,114,189,156,250,163,34,196,155,126,199,90,255,143,51,128,84,100,209,94,6,48,26,48,78,82,87,97,37,204,181,40,243,75,236,89,48,51,164,142,164,31,24,12,48,26,55,180,208,152,7,126,85,179,164,210,237,6,180,32,5,82,0,230,220,38,81,180,103,15,57,174,69,33,176,55,205,146,228,111,42,124,214,26,161,149,183,64,203,136,186,233,118,27,156,205,241,235,39,85,29,102,90,1,118,20,78,176,80,30,56,243,1,171,190,208,242,168,55,58,105,49,255,132,108,242,190,87,245,209,63,11,117,60,255,192,250,46,247,173,93,118,5,246,197,108,8,142,54,208,254,51,208,73,95,206,181,74,33,195,3,1,199,101,7,144,234,250,217,33,252,216,37,202,175,137,179,106,79,182,225,73,67,50,242,49,95,210,11,64,197,200,97,251,162,137,43,52,172,127,118,73,106,5,155,226,238,52,6,62,180,237,155,220,56,75,210,44,164,37,163,120,91,18,89,75,185,204,171,193,249,120,39,42,219,37,0,87,118,141,197,125,241,240,38,214,51,71,62,39,82,132,104,9,88,15,249,207,174,112,74,159,19,150,174,115,73,100,5,240,22,80,36,168,81,185,210,151,220,253,192,237,9,24,249,94,96,191,108,87,203,39,8,88,216,0,17,175,6,135,243,112,204,144,161,146,179,111,88,146,184,35,233,203,70,200,227,52,40,67,249,202,50,186,225,255,11,221,96,29,197,92,41,12,95,226,0,145,226,65,236,249,3,123,253,77,189,254,162,144,209,203,246,29,225,80,32,176,216,112,203,70,236,235,70,198,191,65,112,251,220,212,216,29,254,26,8,38,43,228,186,243,216,57,20,112,240,216,51,220,17,134,177,147,64,69,56,194,30,112,47,36,38,156,218,62,176,239,21,172,222,206,77,143,224,184,57,106,185,166,181,88,4,159,243,218,189,133,106,238,115,242,1,54,221,2,23,235,90,159,112,183,156,98,1,5,45,203,44,235,112,242,216,176,97,28,200,225,56,211,248,187,98,77,45,15,251,109,248,31,94,254,212,25,95,195,0,48,200,213,2,89,24,99,159,1,21,200,35,102,193,234,74,7,8,203,52,172,173,75,254,35,31,129,4,219,116,146,2,21,7,17,43,172,103,179,191,164,217,216,1,138,232,242,203,121,241,30,56,232,208,222,78,139,29,85,251,98,254,201,158,242,103,146,2,83,249,224,86,9,76,165,241,43,72,38,32,59,108,28,97,170,1,241,210,74,44,197,180,114,250,63,223,41,17,214,212,71,158,46,48,231,3,243,50,20,21,174,205,22,243,24,2,107,58,91,110,147,170,182,92,188,19,146,7,86,52,85,113,179,113,239,77,6,214,103,222,145,98,28,41,50,112,107,29,120,7,236,17,89,234,230,77,113,237,83,74,209,192,137,248,75,93,1,79,204,251,97,22,121,246,197,5,111,98,230,163,11,252,96,244,198,108,6,175,239,255,6,171,31,226,172,157,223,219,85,63,194,194,135,24,7,22,43,252,239,0,110,47,229,222,243,250,250,43,43,195,58,195,189,226,248,32,73,171,240,252,84,40,24,162,212,4,125,193,114,251,231,168,245,216,84,63,228,224,38,166,40,55,195,167,126,165,127,10,10,40,254,154,107,185,115,245,138,221,16,64,76,24,74,189,54,52,72,238,125,158,185,156,237,36,222,93,253,94,234,247,91,247,49,186,195,237,210,229,162,188,116,42,80,4,16,217,133,23,190,188,94,43},
  {14,20,251,229,42,28,131,216,28,38,170,72,220,70,177,6,173,251,104,1,163,79,130,95,127,4,127,105,38,248,51,4,177,84,196,58,67,115,200,227,232,202,231,173,52,199,92,102,52,197,122,1,216,62,190,114,85,169,162,0,94,207,221,188,9,116,209,31,6,64,246,247,193,86,78,78,78,12,64,87,186,176,41,241,130,72,155,220,194,0,211,179,114,171,234,88,146,202,250,161,54,171,187,213,75,219,172,60,73,255,227,198,104,254,25,187,145,201,14,25,99,250,48,227,182,116,244,2,99,91,204,170,43,97,63,2,24,251,99,18,94,254,137,76,47,247,36,80,122,12,16,254,214,64,157,197,28,16,19,77,2,8,227,197,168,239,232,240,147,13,156,60,207,71,251,5,77,199,125,7,74,1,144,97,29,244,250,247,35,101,220,244,129,228,255,246,211,211,199,245,56,173,136,178,170,79,175,248,77,42,229,32,130,84,242,165,205,247,175,188,160,41,168,4,179,199,85,158,204,211,207,2,24,193,69,27,123,165,254,105,107,245,140,252,124,9,117,171,64,99,195,35,31,48,97,58,172,227,158,175,140,206,112,48,148,169,165,217,228,0,14,196,248,160,152,4,190,184,70,109,249,245,219,41,57,242,85,33,129,255,201,177,111,249,146,33,9,110,187,80,180,178,240,43,29,188,49,252,206,226,157,114,189,178,220,104,85,201,236,209,134,102,206,240,143,231,253,7,29,107,29,91,153,2,41,5,2,221,128,247,163,165,180,105,62,98,210,165,226,65,209,59,240,8,227,4,158,49,192,179,168,174,43,17,215,96,20,162,62,89,19,3,124,205,93,170,49,199,119,4,139,219,3,254,6,27,202,99,132,161,91,4,80,19,205,214,116,167,164,213,245,93,225,55,188,45,154,253,234,74,37,255,34,118,106,19,63,248,112,16,130,252,173,238,233,54,27,166,76,217,200,8,30,55,90,88,219,109,21,250,188,179,71,4,138,1,212,7,65,249,239,25,69,167,49,4,50,23,174,103,66,243,75,231,90,174,240,253,33,255,174,233,237,84,136,181,95,248,233,45,116,242,110,232,113,157,66,187,152,76,10,205,39,180,137,245,109,13,56,237,187,37,89,5,139,7,10,8,232,50,176,156,123,59,124,215,159,3,159,240,40,175,62,28,114,250,205,173,159,183,43,232,96,26,39,220,50,55,240,214,122,190,204,100,156,247,135,203,126,232,20,249,245,183,3,1,241,207,242,247,89,85,110,7,239,112,7,36,53,250,164,181,51,42,129,102,1,109,225,108,143,70,11,56,149,24,191,54,149,8,219,234,131,253,34,247,228,171,133,116,190,17,109,251,196,52,58,210,27,243,98,100,75,29,202,172,134,244,205,1,131,36,209,195,68,198,120,6,181,8,108,62,187,170,152,211,111,115,16,254,117,192,86,105,116,199,30,248,202,5,117,100,120,229,83,249,254,100,24,221,75,250,221,101,193,163,44,8,165,38,231,250,255,90,57,169,237,170,204,77,119,184,97,44,215,43,1,248,127,79,155,80,14,175,19,255,13,66,73,58,180,252,121,166,206,184,74,93,51,215,227,43,114,247,174,214,112,2,202,56,127,68,245,38,186,194,168,31,8,195,56,156,137,157,98,177,146,5,79,2,184,110,38,28,96,219,219,1,77,196,190,173,136,101,69,83,77,55,241,67,178,6,28,211,9,194,237,20,128,204,77,184,177,247,195,251,138,175,80,75,0,192,61,181,212,232,123,80,228,114,51,70,117,8,61,169,60,231,146,32,203,248,98,246,60,16,78,196,50,59,197,222,39,195,14,252,36,76,169,117,173,181,135,95,81,90,97,97,14,178,45,52,132,251,67,21,106,195,168,233,199,215,82,253,154,159,104,4,126,191,107,186,105,49,96,4,164,187,35,251,137,17,88,229,93,30,35,212,47,98,74,236,48,51,119,68,21,166,37,94,31,184,158,174,75,224,187,94,216,79,155,84,207,249,229,189,131,180,171,224,221,16,126,155,52,35,33,254,81,249,249,236,50,230,59,15,136,17,209,6,135,218,211,247,45,228,239,30,252,250,244,62,253,34,243,185,211,3,12,34,255,251,121,60,145,74,206,240,160,5,193,0,197,76,88,201,100,192,77,250,19,115,206,28,14,6,106,3,128,32,34,20,190,75,10,87,151,220,62,188,153,102,171,80,62,193,57,240,243,59,194,246,60,99,90,81,115,110,69,181,198,22,228,85,142,81,37,0,208,240,180,248,63,59,224,171,110,244,89,253,226,170,174,174,56,9,164,176,170,155,96,254,163,248,94,107,124,1,6,58,218,217,18,12,132,211,228,6,233,40,13,105,192,87,33,116,125,32,106,216,232,214,198,104,85,190,92,200,110,19,100,4,206,5,5,198,186,185,5,39,49,235,220,169,106,52,218,49,205,24,29,247,115,51,84,222,136,247,194,248,4,15,231,243,245,163,154,3,122,90,137,4,183,237,144,197,151,158,37,56,28,19,183,188,83,194,31,21,83,177,9,200,141,194,124,82,235,87,232,192,173,106,204,165,41,204,80,160,178,12,149,91,17,68,136,198,198,0,141,191,47,77,77,253,165,186,91,192,237,239,166,5,159,75,6,6,183,245,22,95,234,177,198,216,105,18,203,100,126,0,149,103,96,95,88,230,138,247,186,3,194,253,66,37,64,156,224,180,42,254,194,160,2,11,48,6,143,72,12,247,113,75,140,221,114,44,233,25,26,251,122,159,55,155,8,3,206,197,192,249,139,166,111,68,113,62,236,5,12,3,218,167,26,32,6,57,16,174,250,85,60,182,20,100,49,107,38,250,104,222,248,234,172,7,27,27,52,0,122,2,22,8,157,218,69,215,220,6,41,234,76,113,12,46,162,156,204,200,33,239,84,251,97,67,240,176,165,79,42,62,181,55,157,11,224,102,69,4,103,81,222,66,227,23,255,202,198,233,2,202,61,15,133,44,234,15,28,19,97,165,232,94,157,51,134,168,2,13,174,54,88,33,254,176,143,157,195,249,230,0,72,111,123,187,178,17,99,39,253,252,119,48,161,185,195,210,102,30,57,200,56,172,166,110,126,242,64,1,35,238,204,248,227,16,103,111,137,71,195,181,166,160,4,214,39,192,233,102,153,54,159,59,146,8,142,252,106,58,243,162,132,202,51,218,118,174,133,79,215,161,185,4,73,253,131,159,233,252,39,76,98,193,241,6,139,173,249,163,174,84,119,190,100,5,15,218,52,160,75,247,216,116,137,117,90,254,71,209,63,48,123,4,227,249,209,236,8,75,46,104,221,254,28,8,237,228,53,181,165,8,86,206,202,82,15,63,119,173,29,245,226,253,169,2,61,65,230,245,31,82,252,174,121,214,211,178,186,6,1,254,78,2},
} ;

static const unsigned char precomputed_core_scale3sntrup761_n[precomputed_core_scale3sntrup761_NUM][crypto_core_INPUTBYTES] = {
  {189,158,173,37,230,231,194,236,6,194,116,131,242,171,84,15,3,24,25,220,0,1,137,173,20,108,181,58,148,86,61,208,191,122,45,166,119,223,247,112,84,132,242,22,5,224,12,159,224,14,142,197,246,133,24,200,18,254,166,151,142,62,124,158,8,189,63,153,165,206,180,83,159,209,216,170,87,250,3,180,7,254,227,91,6,25,135,96,185,97,244,25,12,6,246,86,124,26,95,94,182,230,218,46,33,117,107,147,111,150,99,200,176,217,226,6,80,235,198,172,10,138,218,152,50,16,214,57,118,43,225,133,228,182,27,161,132,188,183,148,220,61,54,143,54,131,228,43,72,205,153,23,89,173,246,36,126,219,203,144,238,0,58,77,180,13,120,140,237,39,171,28,96,145,63,82,80,93,226,246,49,23,222,52,113,43,252,185,23,216,121,9,66,83,34,207,208,140,113,47,205,72,223,177,16,231,137,253,163,181,248,76,83,50,64,223,222,136,52,51,242,14,186,58,199,66,5,68,24,6,195,77,157,47,162,111,16,166,109,106,215,91,28,202,75,233,175,89,48,153,46,119,106,213,84,224,211,180,197,178,82,231,1,12,2,195,147,154,229,17,185,19,104,80,170,203,39,124,196,10,140,15,162,77,197,146,251,237,9,36,237,9,52,180,77,164,182,199,141,170,69,238,84,199,175,38,218,80,16,147,52,87,105,180,252,43,213,155,84,80,43,145,159,158,115,3,48,88,197,245,201,69,3,219,183,83,221,213,149,28,51,133,204,70,172,27,149,5,10,107,249,248,187,150,44,112,72,29,24,169,150,136,226,192,9,231,8,184,25,163,10,142,140,7,12,108,72,140,85,13,172,55,70,120,53,144,195,170,42,24,39,120,4,44,4,136,141,184,122,141,78,149,109,2,205,125,53,14,199,247,124,109,230,149,248,170,206,231,232,183,206,152,32,27,125,148,144,97,71,224,227,59,144,202,136,162,190,182,81,184,161,44,40,236,58,75,13,48,29,106,67,97,40,82,203,249,72,38,81,254,85,99,36,130,112,209,77,208,191,35,210,139,110,168,143,92,133,236,89,216,207,17,143,129,56,71,5,235,102,14,142,100,193,143,164,194,23,108,178,115,0,105,157,56,52,106,203,155,114,242,89,245,49,59,58,186,201,73,198,238,166,154,150,125,46,29,136,62,82,191,50,213,46,82,45,85,99,137,48,240,199,202,81,205,178,86,227,223,153,36,92,67,231,21,209,228,92,35,26,37,19,132,24,171,127,203,90,88,20,125,128,237,193,163,224,7,42,18,3,124,31,2,153,92,33,139,193,229,159,156,214,88,128,240,44,236,70,115,160,37,17,77,228,152,188,69,198,87,102,111,166,172,152,48,248,114,15,37,65,212,216,239,217,128,171,164,73,18,17,187,46,143,118,224,210,221,241,238,70,27,255,143,211,66,5,46,7,134,165,42,16,180,185,183,169,124,13,183,128,213,89,231,74,73,89,18,60,97,198,111,165,108,167,47,207,150,91,128,109,188,51,89,172,97,95,222,132,225,129,225,160,165,178,94,123,142,24,215,239,176,215,187,194,17,254,143,29,141,112,254,63,90,71,110,198,228,199,19,90,65,141,148,231,176,215,31,211,149,65,210,36,218,130,57,188,16,26,30,234,243,83,211,87,28,35,231,135,160,244,113,228,130,238,235,68,156,161,37,166,154,129,219,237,161,51,238,124,205,47,10,231,10,215,198,50,153,222,149,96,223,35,3,198,224,200,24,192,171,245,143,226,0,66,148,66,113,255,48,141,153,96,144,160,51,159,15,141,227,207,67,131,113,87,34,25,67,125,28,64,216,94,112,180,107,191,253,13,197,15,0,236,112,178,241,66,45,156,202,241,130,192,127,107,124,60,188,100,161,200,223,14,135,244,103,98,121,192,99,36,172,2,7,64,44,2,45,48,205,17,102,122,14,86,210,199,52,39,224,114,84,122,64,100,12,90,67,166,53,50,181,191,246,116,125,11,203,185,125,211,241,33,80,252,215,13,173,173,147,166,227,51,99,15,140,122,206,137,250,11,209,110,128,111,148,109,106,207,211,104,135,109,2,111,160,63,33,236,82,206,18,139,157,162,6,148,225,104,41,203,96,243,145,37,149,170,151,168,46,78,108,191,243,30,209,130,161,135,84,247,168,205,193,150,196,212,10,59,92,136,86,87,244,15,50,64,107,147,45,89,51,117,88,151,116,219,8,255,67,245,244,45,151,137,129,214,22,116,189,89,105,188,51,134,132,90,103,153,218,92,104,71,8,8,146,106,155,6,107,30,200,162,251,195,225,35,158,222,229,231,6,164,25,116,152,41,172,242,49,68,106,43,192,215,23,154,7,103,84,95,201,90,122,207,21,210,51,99,145,107,232,74,18,164,222,94,53,68,210,33,29,21,81,5,113,17,245,48,105,64,215,226,173,211,224,127,62,243,243,233,110,103,83,7,68,65,209,121,29,130,143,143,117,252,165,38,225,191,109,79,149,44,11,32,253,217,61,224,89,142,171,68,163,79,112,39,109,117,55,125,218,45,165,144,245,175,183,173,178,143,148,34,35,190,67,83,64,27,104,71,95,52,172,81,53,56,15,142,92,77,148,38,186,162,122,82,221,75,163,210,39,192,184,54,164,3,238,193,189,182,120,91,101,105,227,195,138,3,33,113,33,88,98,254,54,66,156,108,33,147,33,243,58,161,197,238,139,206,159,210,25,93,130,178,171,237,99,109,117,48,141,14,166,132,145,30,4,120,144,94,141,109,99,240,94,118,3,186,45,193,173,143,149,18,16,226,75,64,34,96,101,90,76,226,36,82,161,248,84,28,90,12,213,120,161,3,6,197,246,228,114,86,203,86,52,213,71,121,127,253,195,182,230,164,33,93,176,149,194,128,144,196,33,103,14,105,171,205,247,230,60,69,254,239,119,221,26,177,58,71,217,94,15,75,83,203,147,153,39,238,73,171,202,196,125,165,127,186,22,247,12,213,225,164,55,9,141,112,222,149,28,179,23,158,82,228,122,124,80,231,247,126,78,252,205,150,124,89,236,210,38,185,54,199,201,140,137,179,123,70,24,21,233,71,126,116,167,198,50,214,121,59,225,111,1,159,223,163,42,238,65,8,209,176,229,199,117,83,159,229,219,88,8,98,253,122,12,186,6,32,14,239,22,212,131,10,40,86,5,202,11,64,239,40,155,220,237,118,193,240,175,77,50,30,120,151,93,38,149,200,210,150,200,33,32,146,17,113,203,97,127,203,214,133,202,141,251,54,255,131,242,65,207,24,115,28,113,130,137,165,172,83,230,204,216,57,192,61,44,71,214,230,183,0,97,219,109,121,38,28,169,249,167,13,225,38,216,55,88,7,56,155,114,64,237,170,127,11,202,12,8,73,39},
  {22,20,227,93,251,202,123,144,95,13,105,95,29,129,160,88,168,233,16,35,111,179,84,8,181,90,138,111,110,41,147,108,158,208,32,30,188,135,34,159,23,20,221,189,177,245,19,199,68,245,147,34,29,43,165,23,175,148,35,49,223,189,179,229,6,157,132,214,247,199,100,136,141,204,242,31,181,186,18,59,115,29,167,93,129,114,46,138,122,197,186,42,140,223,148,38,251,224,246,201,172,175,30,144,242,118,44,23,24,9,6,235,217,52,123,200,20,147,203,131,12,194,105,202,119,189,13,41,112,207,16,251,15,127,170,31,32,111,34,231,71,80,230,192,49,47,34,67,254,3,223,41,200,84,134,134,52,49,235,220,169,133,169,127,242,21,21,153,195,116,223,201,55,224,39,220,91,138,179,244,198,62,139,55,12,133,18,5,7,64,53,120,116,202,73,132,21,88,62,138,146,6,104,21,223,167,178,4,54,8,198,1,237,106,20,129,100,84,49,79,208,32,141,24,207,162,76,115,212,240,33,61,236,135,150,220,235,65,228,107,163,8,63,128,73,193,249,86,85,193,92,135,177,90,241,136,180,189,191,137,215,251,206,138,85,106,144,52,74,209,72,131,83,144,223,207,127,75,32,18,88,86,68,230,207,184,95,154,184,8,15,60,55,95,120,68,68,80,138,242,111,42,220,210,125,146,199,76,68,39,164,212,30,205,109,72,79,174,142,42,200,47,6,163,18,26,1,156,49,184,237,222,117,230,155,96,93,216,12,230,207,116,200,181,60,83,7,255,87,24,78,55,32,146,125,109,200,117,71,118,250,28,17,145,244,49,158,8,41,36,246,181,42,98,221,75,31,187,18,71,237,212,147,225,19,135,37,215,254,182,33,32,21,192,27,205,86,128,208,192,84,182,4,11,172,219,177,240,31,19,109,41,218,63,71,59,214,236,161,158,234,216,9,42,222,60,168,133,40,207,144,67,164,180,176,132,150,58,250,124,112,234,166,116,83,127,107,89,196,93,98,118,154,29,142,144,43,199,132,136,211,161,89,14,137,106,217,72,254,189,165,180,84,235,136,236,227,132,204,194,130,145,1,138,108,4,44,196,52,133,1,146,216,253,1,187,172,149,239,111,57,151,180,252,83,69,190,128,168,106,239,143,251,92,148,47,169,108,12,221,91,157,2,11,243,69,141,78,206,251,245,180,11,51,222,132,106,26,105,110,198,133,45,129,239,76,86,43,195,190,66,154,9,189,169,3,99,110,251,65,180,127,141,130,160,16,81,137,0,82,151,199,78,130,244,62,49,235,16,168,27,134,218,67,55,41,78,25,116,96,125,133,183,133,103,35,20,126,255,249,85,138,177,106,164,82,158,94,119,32,4,245,196,8,175,67,177,124,144,93,5,190,215,146,132,13,174,184,219,119,20,17,168,21,48,116,173,163,145,7,132,102,166,33,37,102,209,148,7,152,48,48,208,105,139,225,181,29,139,59,178,109,57,23,162,25,255,98,111,100,113,226,110,40,199,31,3,111,81,18,246,43,155,162,189,150,205,209,251,159,38,205,176,82,84,224,178,252,8,97,77,125,251,41,49,85,200,129,100,57,230,124,77,206,205,244,243,143,70,179,16,86,250,195,120,252,86,196,189,133,53,211,191,100,83,1,156,197,175,225,14,105,133,198,166,82,89,133,139,23,150,179,60,184,74,61,207,236,158,61,20,174,71,44,235,228,162,121,63,19,212,254,204,164,23,50,187,244,213,105,15,135,17,117,18,254,254,94,241,170,156,12,87,116,95,208,234,49,124,85,17,25,82,20,49,9,7,105,95,29,255,114,161,243,168,205,126,225,14,232,2,23,223,58,237,114,34,127,74,17,194,53,236,65,72,51,178,80,85,150,65,221,59,23,127,209,105,84,206,30,198,157,252,35,48,78,121,226,4,105,212,116,21,138,57,146,5,204,33,85,232,64,128,246,143,230,238,21,46,109,211,192,36,171,71,49,246,152,173,169,92,182,36,96,92,97,27,44,71,37,216,240,62,144,21,92,123,155,130,30,105,211,202,210,5,113,39,148,28,80,82,31,18,34,142,231,205,142,248,174,31,96,248,160,38,214,196,211,97,35,150,4,92,239,218,110,246,118,46,137,55,165,18,123,59,22,156,234,219,10,153,150,44,0,247,194,191,170,112,111,161,108,36,92,238,216,0,57,201,235,141,223,142,133,133,39,192,91,161,66,235,115,217,33,248,23,237,178,78,34,78,108,184,69,164,212,175,10,205,83,21,113,241,7,136,121,98,210,247,180,106,4,78,77,245,13,190,204,179,156,58,243,23,166,74,138,183,224,194,148,173,236,77,233,201,175,21,93,238,248,234,25,110,87,203,24,152,228,118,152,79,151,234,160,204,79,245,17,171,62,54,194,1,147,2,185,74,97,98,219,191,134,112,149,69,190,222,73,121,184,8,81,228,221,65,201,33,99,67,2,38,11,136,39,161,12,40,80,14,250,122,88,202,33,6,78,214,75,227,208,193,239,140,141,28,91,158,83,196,121,145,213,126,7,151,218,43,210,206,216,109,228,5,81,165,132,30,109,24,17,94,201,44,100,33,52,26,241,67,142,225,108,144,10,218,227,182,159,136,67,118,24,189,90,164,24,199,121,244,40,53,195,151,63,72,253,38,37,217,150,89,239,9,113,170,147,72,51,140,37,72,71,253,255,172,150,225,116,14,33,161,145,150,207,44,91,214,3,64,194,126,78,129,80,148,15,97,244,187,40,188,6,148,175,35,128,68,171,160,232,141,58,239,228,248,182,94,198,220,153,80,246,64,63,98,50,120,120,190,65,223,145,159,73,182,18,234,127,24,82,24,9,213,232,89,243,50,237,253,207,136,93,26,126,144,198,108,84,232,135,201,51,129,102,104,165,221,131,233,187,138,235,217,215,231,138,209,58,161,193,217,17,95,49,136,222,36,63,211,102,170,208,58,60,176,247,237,161,251,225,36,118,24,175,146,248,230,59,197,81,103,163,225,39,228,95,209,134,12,24,33,214,173,123,147,40,63,252,139,67,12,31,53,97,206,28,72,0,186,210,226,54,31,35,113,82,109,204,167,51,204,148,77,81,229,209,237,221,206,64,153,185,104,179,85,156,11,179,186,241,179,233,77,253,26,170,202,203,17,201,120,130,74,108,26,121,0,150,4,29,44,26,76,187,115,105,105,107,17,153,134,6,115,226,15,185,68,3,85,198,85,50,12,254,203,215,37,109,234,50,223,28,223,231,29,145,189,209,252,4,135,119,11,79,155,102,242,216,252,114,82,244,168,180,221,40,73,19,101,194,137,235,111,30,41,36,111,212,203,163,12,71,205,67,182,118,72,173,154,36,155,174,127,157,13,82,222,0,4,153,50,216,147,24,75,92,156,215,28,41,51,166},
  {216,202,84,219,4,230,148,239,72,109,185,51,33,249,40,229,69,202,126,48,143,92,242,184,70,200,211,227,138,137,249,226,182,204,74,107,219,41,126,36,43,253,222,44,86,84,33,126,1,238,153,201,193,233,28,241,156,90,213,167,93,137,229,132,172,206,130,111,251,53,225,89,231,188,208,100,201,96,17,76,94,178,221,196,60,178,14,73,74,168,165,245,163,56,66,21,228,75,95,151,105,112,61,25,212,185,228,34,17,74,96,240,52,89,188,22,207,23,129,118,217,39,0,243,147,24,180,143,64,160,253,76,124,56,149,104,63,205,179,23,190,0,148,237,156,27,210,72,239,157,117,178,73,110,55,99,58,220,170,219,169,193,191,4,24,118,80,175,108,51,100,157,86,175,14,85,134,7,99,223,75,222,76,78,73,132,85,0,105,90,9,54,99,175,63,237,65,45,234,238,208,129,197,157,139,165,13,176,53,177,249,203,108,251,107,184,146,68,3,85,92,189,66,130,11,174,206,122,7,80,55,67,254,152,76,144,219,135,217,215,90,42,85,168,110,163,26,247,232,146,94,32,110,223,238,90,94,231,132,36,100,142,141,132,71,227,223,96,254,125,80,60,195,161,63,195,159,93,120,206,163,77,166,94,238,88,193,29,199,100,57,26,7,7,197,85,23,92,51,175,85,253,222,38,200,118,0,56,149,128,232,134,151,73,47,86,7,26,173,141,125,41,6,205,242,36,208,229,62,91,106,75,62,248,145,227,208,144,42,46,101,217,38,212,237,26,215,33,31,25,82,115,35,149,232,161,208,35,222,115,73,126,249,107,228,69,81,15,255,77,107,158,19,195,217,156,101,38,165,238,49,192,94,146,132,199,238,42,60,142,244,210,115,177,120,196,245,123,53,76,163,98,91,9,66,123,233,11,223,76,217,198,64,67,251,207,175,252,247,78,217,27,145,85,94,129,197,184,63,125,52,242,48,73,34,139,219,16,131,181,24,92,183,90,252,219,154,204,165,23,161,120,127,30,7,143,74,78,41,195,60,102,173,181,160,15,83,47,84,65,246,43,150,67,181,242,118,20,129,161,130,0,178,118,61,25,76,113,114,62,186,75,200,201,147,24,14,110,75,214,155,17,120,8,108,80,84,234,128,21,198,32,237,96,57,0,169,47,101,89,206,17,84,129,55,87,108,209,136,45,161,24,173,162,42,217,195,168,145,194,229,118,82,55,70,171,62,250,84,176,31,176,47,255,51,121,121,61,242,85,69,0,74,248,210,107,97,76,160,107,168,39,181,190,21,56,216,137,201,255,142,49,120,232,22,202,95,167,163,99,56,223,22,79,54,174,138,166,116,214,151,200,239,232,36,126,211,172,196,193,158,138,103,228,0,209,201,172,197,249,4,25,218,122,238,119,199,86,121,231,132,147,10,77,43,226,23,154,207,247,232,197,56,98,168,143,232,71,1,189,115,240,169,245,159,147,226,187,13,90,174,206,89,124,175,146,51,237,185,179,48,158,81,30,126,232,111,12,41,69,88,68,188,188,223,228,135,171,63,235,194,162,55,7,76,75,155,232,222,125,4,159,26,40,22,69,192,188,108,66,178,97,231,153,23,230,91,171,172,182,173,120,1,234,27,1,235,180,4,192,197,30,171,191,129,142,217,174,134,17,71,131,133,60,121,164,42,23,37,34,39,149,111,93,181,14,181,202,107,120,112,18,159,54,19,75,116,243,24,22,108,219,53,134,90,99,169,192,3,195,151,63,45,179,207,119,236,48,161,158,93,139,187,251,33,250,253,152,7,33,225,125,170,195,223,199,102,223,24,233,225,240,202,190,47,236,185,47,226,225,27,147,51,56,72,216,100,131,74,245,158,104,108,186,199,206,80,45,1,32,53,118,175,24,246,91,148,57,75,160,221,109,99,126,22,79,209,212,1,143,120,246,64,27,254,44,185,5,64,254,21,247,52,37,210,1,173,230,201,8,127,109,240,84,108,63,104,208,245,139,19,17,230,177,6,231,210,81,139,157,89,237,102,163,237,103,73,223,222,53,115,32,237,239,104,28,193,74,96,208,235,9,27,145,61,209,4,219,40,191,23,222,122,45,104,41,178,45,81,244,97,93,197,224,170,216,153,195,116,149,191,48,18,219,205,121,171,35,116,226,159,136,70,77,205,189,105,152,183,170,194,130,138,230,218,159,245,18,151,108,18,112,178,118,209,40,168,120,96,162,160,137,117,201,218,97,141,137,118,30,39,81,245,98,21,18,221,203,238,234,56,238,90,58,244,179,173,3,111,123,58,42,120,232,104,167,35,66,165,11,138,93,136,160,43,62,139,218,225,53,202,120,225,140,188,71,62,200,243,69,97,19,28,77,147,193,153,154,250,9,68,38,186,59,25,105,169,37,155,91,54,240,198,72,174,80,41,255,202,227,5,219,139,234,244,246,186,239,21,102,235,236,43,147,29,158,158,29,157,228,16,214,4,153,247,236,186,78,185,252,7,191,167,141,172,151,184,12,43,74,237,193,153,182,221,223,214,112,188,24,59,16,117,192,177,18,143,237,197,52,74,13,63,68,63,117,224,68,141,110,41,141,61,225,109,7,144,160,249,227,124,41,159,44,75,177,109,238,251,98,158,121,218,128,152,131,209,79,252,20,62,106,158,43,1,237,53,209,15,146,240,24,150,3,142,209,20,21,96,248,207,82,90,37,5,65,88,208,65,0,107,231,162,165,24,14,124,132,80,98,61,103,125,58,243,30,173,2,62,194,63,137,116,249,6,187,134,251,238,44,225,250,98,252,0,191,137,40,236,57,231,151,163,250,137,71,1,62,46,245,175,24,83,234,239,202,126,186,108,4,209,78,158,217,75,211,225,250,204,247,69,120,168,116,146,74,94,115,7,102,14,42,89,38,142,0,86,64,19,106,242,224,203,174,112,68,8,97,77,150,200,46,95,107,77,1,246,22,1,13,149,62,13,75,99,165,30,196,110,213,140,221,55,122,57,183,134,2,23,194,108,214,54,129,74,117,93,65,40,68,128,209,89,190,11,214,30,101,205,93,73,97,206,242,71,117,214,243,22,116,246,228,40,174,190,207,80,32,68,169,112,13,46,76,151,172,202,38,253,133,254,89,123,75,231,212,93,52,165,170,93,136,16,240,63,217,80,67,108,112,241,58,210,184,82,13,94,175,0,165,31,107,82,68,81,254,163,20,20,59,25,59,154,69,77,102,30,51,245,4,193,104,99,133,247,80,218,143,203,89,168,135,2,237,193,197,167,239,189,134,93,24,156,220,133,134,122,9,83,19,5,131,212,55,44,161,137,238,85,27,105,99,201,227,183,108,115,73,218,46,238,216,244,188,239,207,164,37,169,76,36,247,22,56,156,158,161,70,145,227,33,20,203,80,11,237,124,184,69,142,111,20},
  {255,97,4,156,179,100,220,236,89,189,51,30,153,29,224,178,52,175,211,79,134,32,123,208,48,166,122,126,98,253,17,172,224,204,145,25,102,44,243,69,83,232,168,222,23,231,25,40,23,145,217,79,237,26,143,129,34,221,54,0,37,63,250,56,168,44,64,187,167,112,173,76,144,205,191,202,191,180,101,120,153,223,190,159,123,115,228,152,150,85,76,139,129,136,243,120,225,146,89,133,109,136,68,65,116,152,137,111,195,255,252,230,211,78,14,227,54,61,255,184,198,174,107,240,55,130,87,80,198,121,159,221,94,38,21,86,173,89,198,182,202,84,40,202,10,3,177,32,35,10,85,5,151,27,58,145,89,11,86,202,251,93,252,59,147,244,83,74,214,95,217,196,234,29,4,252,202,145,218,81,201,79,213,123,186,160,89,247,6,125,79,246,134,155,176,161,76,235,72,161,195,51,51,224,51,203,64,162,20,20,156,187,123,119,1,220,148,88,64,142,133,190,147,251,236,145,34,132,159,64,160,165,99,58,188,185,132,134,79,41,212,75,41,90,121,94,130,136,101,124,230,17,90,107,112,25,63,155,229,137,223,62,117,107,55,221,146,66,76,0,181,144,3,133,227,80,69,226,103,42,174,246,238,19,110,245,108,102,208,5,158,138,202,3,43,17,168,42,142,203,151,53,245,105,186,56,22,78,245,154,132,129,154,53,153,211,34,61,255,63,39,40,245,244,224,241,164,8,4,127,4,207,51,86,190,251,177,67,219,161,60,49,225,211,15,124,161,134,155,198,64,111,245,8,252,80,47,193,155,224,147,137,94,182,66,38,183,218,15,121,86,92,47,233,122,221,22,231,125,1,52,67,1,170,167,185,147,124,135,218,201,86,21,183,74,236,215,49,231,235,76,37,240,109,57,21,57,249,243,30,92,176,91,45,115,12,112,247,117,11,123,175,234,158,72,24,100,49,31,237,61,94,175,109,195,120,238,127,98,77,239,53,18,178,137,250,247,81,16,89,74,185,114,220,22,166,11,99,223,125,113,160,116,156,121,137,245,175,176,5,149,242,244,204,51,225,117,253,72,21,215,74,213,156,214,131,113,56,45,202,9,233,104,139,222,75,116,10,195,243,142,18,24,93,126,8,83,179,157,193,235,216,206,25,47,151,218,177,144,159,19,223,15,186,129,77,74,137,144,140,20,242,197,14,104,67,11,195,171,65,217,142,233,124,217,173,136,232,133,71,1,89,2,226,92,250,86,63,1,162,24,205,31,179,74,214,82,103,12,4,231,139,182,190,208,210,80,42,240,212,42,200,254,109,44,14,58,24,44,94,164,157,129,84,182,167,167,136,124,215,143,182,116,4,145,23,25,64,100,160,27,210,190,15,73,222,221,160,239,85,38,18,246,229,199,230,131,81,231,2,201,26,68,136,227,149,202,129,11,164,130,143,23,41,215,145,101,247,147,178,204,124,131,70,22,89,79,210,99,238,116,77,68,125,70,219,9,94,220,18,77,254,250,206,110,50,170,221,233,31,216,140,112,191,66,191,6,162,122,32,46,118,181,137,86,176,84,113,104,25,151,163,46,220,245,140,19,37,108,236,70,191,129,76,149,65,43,80,147,195,122,199,76,104,153,229,221,101,179,229,195,216,222,131,209,223,225,251,32,80,141,213,7,186,123,152,164,250,202,144,69,137,125,210,188,33,20,195,160,28,230,172,15,235,94,229,244,12,219,232,202,140,224,173,65,169,137,52,21,31,91,143,26,225,247,156,206,32,241,214,182,114,39,88,26,221,111,156,43,102,244,76,209,246,185,96,117,59,11,111,242,238,104,144,255,89,177,116,136,130,234,139,210,37,192,206,112,38,181,138,180,108,135,248,102,98,41,59,147,242,72,151,107,90,57,47,211,80,133,228,212,226,200,107,32,172,231,141,97,254,40,97,35,241,196,186,188,64,10,124,201,72,181,193,34,114,98,49,92,37,16,226,229,222,116,239,142,37,237,117,46,34,160,162,82,57,220,224,148,239,68,182,133,216,97,188,102,249,118,162,174,243,193,70,14,11,125,182,155,87,136,237,241,167,106,155,74,16,249,174,161,197,164,17,172,226,150,92,169,102,250,89,120,111,128,201,245,244,133,178,144,91,60,202,35,61,39,58,202,162,86,44,63,186,90,87,41,251,37,102,91,183,143,116,83,120,56,238,197,56,216,210,222,32,197,143,110,159,246,25,241,246,185,209,195,203,118,213,114,54,231,98,241,119,127,118,183,170,75,74,151,247,186,25,251,221,213,160,115,84,81,136,149,137,13,9,231,52,233,45,32,170,225,82,111,212,212,85,167,110,249,151,171,180,135,64,76,2,72,190,84,126,229,205,176,44,36,102,41,66,83,236,231,40,34,228,207,60,31,183,39,166,63,93,178,230,153,226,252,18,22,243,79,221,115,23,67,193,148,99,4,3,118,108,119,153,216,167,241,76,81,96,168,160,2,134,131,92,35,36,131,1,152,158,139,230,56,132,92,195,89,12,152,227,204,58,90,98,204,223,94,231,138,229,121,33,158,120,83,58,52,212,159,134,190,232,203,132,139,95,44,207,0,114,51,60,231,176,138,228,10,117,20,5,146,141,36,58,170,244,135,178,218,201,2,2,152,246,87,208,169,138,157,151,200,182,62,210,42,0,44,211,197,37,35,156,137,76,227,177,241,163,187,103,27,46,251,224,14,170,241,132,251,94,16,2,42,30,95,76,32,31,223,67,203,20,72,185,185,77,217,217,24,131,253,6,245,59,229,3,52,220,202,28,32,112,73,93,169,177,249,49,3,102,167,195,11,52,163,34,111,225,1,210,96,212,98,83,211,238,3,243,63,167,174,185,97,91,35,92,178,2,58,152,114,236,79,252,190,242,105,214,169,106,145,131,159,231,102,244,193,89,112,28,171,223,220,117,179,26,140,24,132,180,69,40,114,251,114,118,239,198,70,99,176,61,157,242,177,146,100,96,124,191,243,181,89,12,38,49,157,37,132,108,221,220,251,180,223,194,109,102,5,53,224,131,156,162,162,85,189,213,132,56,139,182,198,189,90,78,34,22,230,55,156,149,199,186,110,231,195,136,135,213,133,245,192,85,188,158,68,168,70,182,114,128,40,115,156,54,61,218,7,236,104,143,72,40,216,194,218,25,134,173,127,175,115,25,172,133,135,61,108,237,45,52,124,32,248,47,147,1,30,249,220,217,163,169,178,116,209,143,160,93,52,137,174,48,223,204,216,142,39,81,96,237,23,218,190,173,237,44,40,45,30,170,200,63,186,192,206,92,70,89,246,72,253,30,95,211,68,176,180,2,170,155,194,139,55,88,205,62,147,33,170,197,216,51,186,75,81,249,227,0,100,198,253,75,90,33,175,137,46,236,76,224,62,2,171,84,117,165},
} ;

static const unsigned char precomputed_core_scale3sntrup761_k[precomputed_core_scale3sntrup761_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_scale3sntrup761_c[precomputed_core_scale3sntrup761_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_scale3sntrup761_impl(long long impl)
{
  unsigned char *h = test_core_scale3sntrup761_h;
  unsigned char *n = test_core_scale3sntrup761_n;
  unsigned char *k = test_core_scale3sntrup761_k;
  unsigned char *c = test_core_scale3sntrup761_c;
  unsigned char *h2 = test_core_scale3sntrup761_h2;
  unsigned char *n2 = test_core_scale3sntrup761_n2;
  unsigned char *k2 = test_core_scale3sntrup761_k2;
  unsigned char *c2 = test_core_scale3sntrup761_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_scale3sntrup761_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_scale3sntrup761(impl);
    printf("core_scale3sntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_scale3sntrup761_implementation(impl),ntruprime_dispatch_core_scale3sntrup761_compiler(impl));
  } else {
    crypto_core = ntruprime_core_scale3sntrup761;
    printf("core_scale3sntrup761 selected implementation %s compiler %s\n",ntruprime_core_scale3sntrup761_implementation(),ntruprime_core_scale3sntrup761_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_scale3sntrup761_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_scale3sntrup761_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_scale3sntrup761_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_scale3sntrup761_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_scale3sntrup761_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_scale3sntrup761_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_scale3sntrup761_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_scale3sntrup761_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_scale3sntrup761_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_scale3sntrup761_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_scale3sntrup761(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"scale3sntrup761")) return;
  storage_core_scale3sntrup761_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_scale3sntrup761_h = aligned(storage_core_scale3sntrup761_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_scale3sntrup761_n = callocplus(crypto_core_INPUTBYTES);
  test_core_scale3sntrup761_n = aligned(storage_core_scale3sntrup761_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_scale3sntrup761_k = callocplus(crypto_core_KEYBYTES);
  test_core_scale3sntrup761_k = aligned(storage_core_scale3sntrup761_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_scale3sntrup761_c = callocplus(crypto_core_CONSTBYTES);
  test_core_scale3sntrup761_c = aligned(storage_core_scale3sntrup761_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_scale3sntrup761_h2 = callocplus(maxalloc);
  test_core_scale3sntrup761_h2 = aligned(storage_core_scale3sntrup761_h2,crypto_core_OUTPUTBYTES);
  storage_core_scale3sntrup761_n2 = callocplus(maxalloc);
  test_core_scale3sntrup761_n2 = aligned(storage_core_scale3sntrup761_n2,crypto_core_INPUTBYTES);
  storage_core_scale3sntrup761_k2 = callocplus(maxalloc);
  test_core_scale3sntrup761_k2 = aligned(storage_core_scale3sntrup761_k2,crypto_core_KEYBYTES);
  storage_core_scale3sntrup761_c2 = callocplus(maxalloc);
  test_core_scale3sntrup761_c2 = aligned(storage_core_scale3sntrup761_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_scale3sntrup761 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_scale3sntrup761();++impl)
      forked(test_core_scale3sntrup761_impl,impl);
    ++test_core_scale3sntrup761_h;
    ++test_core_scale3sntrup761_n;
    ++test_core_scale3sntrup761_k;
    ++test_core_scale3sntrup761_c;
    ++test_core_scale3sntrup761_h2;
    ++test_core_scale3sntrup761_n2;
    ++test_core_scale3sntrup761_k2;
    ++test_core_scale3sntrup761_c2;
  }
  free(storage_core_scale3sntrup761_c2);
  free(storage_core_scale3sntrup761_k2);
  free(storage_core_scale3sntrup761_n2);
  free(storage_core_scale3sntrup761_h2);
  free(storage_core_scale3sntrup761_c);
  free(storage_core_scale3sntrup761_k);
  free(storage_core_scale3sntrup761_n);
  free(storage_core_scale3sntrup761_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

