#!/usr/bin/env bash

set -e

# DELETE CLUSTER

kind delete cluster --name ${KIND_NAME:-argo} || true

# CREATE CLUSTER

kind create cluster --name ${KIND_NAME:-argo} --image ${KIND_IMAGE:-kindest/node:v1.26.2} --config - <<EOF
kind: Cluster
apiVersion: kind.x-k8s.io/v1alpha4
kubeadmConfigPatches:
  - |-
    kind: ClusterConfiguration
    controllerManager:
      extraArgs:
        bind-address: 0.0.0.0
    etcd:
      local:
        extraArgs:
          listen-metrics-urls: http://0.0.0.0:2381
    scheduler:
      extraArgs:
        bind-address: 0.0.0.0
  - |-
    kind: KubeProxyConfiguration
    metricsBindAddress: 0.0.0.0
nodes:
  - role: control-plane
    kubeadmConfigPatches:
      - |-
        kind: InitConfiguration
        nodeRegistration:
          kubeletExtraArgs:
            node-labels: "ingress-ready=true"
    extraPortMappings:
      - containerPort: 80
        hostPort: 80
        protocol: TCP
      - containerPort: 443
        hostPort: 443
        protocol: TCP
  - role: worker
  - role: worker
  - role: worker
EOF
