/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	reportsv1 "github.com/kyverno/kyverno/api/reports/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// EphemeralReportLister helps list EphemeralReports.
// All objects returned here must be treated as read-only.
type EphemeralReportLister interface {
	// List lists all EphemeralReports in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*reportsv1.EphemeralReport, err error)
	// EphemeralReports returns an object that can list and get EphemeralReports.
	EphemeralReports(namespace string) EphemeralReportNamespaceLister
	EphemeralReportListerExpansion
}

// ephemeralReportLister implements the EphemeralReportLister interface.
type ephemeralReportLister struct {
	listers.ResourceIndexer[*reportsv1.EphemeralReport]
}

// NewEphemeralReportLister returns a new EphemeralReportLister.
func NewEphemeralReportLister(indexer cache.Indexer) EphemeralReportLister {
	return &ephemeralReportLister{listers.New[*reportsv1.EphemeralReport](indexer, reportsv1.Resource("ephemeralreport"))}
}

// EphemeralReports returns an object that can list and get EphemeralReports.
func (s *ephemeralReportLister) EphemeralReports(namespace string) EphemeralReportNamespaceLister {
	return ephemeralReportNamespaceLister{listers.NewNamespaced[*reportsv1.EphemeralReport](s.ResourceIndexer, namespace)}
}

// EphemeralReportNamespaceLister helps list and get EphemeralReports.
// All objects returned here must be treated as read-only.
type EphemeralReportNamespaceLister interface {
	// List lists all EphemeralReports in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*reportsv1.EphemeralReport, err error)
	// Get retrieves the EphemeralReport from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*reportsv1.EphemeralReport, error)
	EphemeralReportNamespaceListerExpansion
}

// ephemeralReportNamespaceLister implements the EphemeralReportNamespaceLister
// interface.
type ephemeralReportNamespaceLister struct {
	listers.ResourceIndexer[*reportsv1.EphemeralReport]
}
