/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	reportsv1 "github.com/kyverno/kyverno/api/reports/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// ClusterEphemeralReportLister helps list ClusterEphemeralReports.
// All objects returned here must be treated as read-only.
type ClusterEphemeralReportLister interface {
	// List lists all ClusterEphemeralReports in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*reportsv1.ClusterEphemeralReport, err error)
	// Get retrieves the ClusterEphemeralReport from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*reportsv1.ClusterEphemeralReport, error)
	ClusterEphemeralReportListerExpansion
}

// clusterEphemeralReportLister implements the ClusterEphemeralReportLister interface.
type clusterEphemeralReportLister struct {
	listers.ResourceIndexer[*reportsv1.ClusterEphemeralReport]
}

// NewClusterEphemeralReportLister returns a new ClusterEphemeralReportLister.
func NewClusterEphemeralReportLister(indexer cache.Indexer) ClusterEphemeralReportLister {
	return &clusterEphemeralReportLister{listers.New[*reportsv1.ClusterEphemeralReport](indexer, reportsv1.Resource("clusterephemeralreport"))}
}
