/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha2

import (
	policyreportv1alpha2 "github.com/kyverno/kyverno/api/policyreport/v1alpha2"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// PolicyReportLister helps list PolicyReports.
// All objects returned here must be treated as read-only.
type PolicyReportLister interface {
	// List lists all PolicyReports in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*policyreportv1alpha2.PolicyReport, err error)
	// PolicyReports returns an object that can list and get PolicyReports.
	PolicyReports(namespace string) PolicyReportNamespaceLister
	PolicyReportListerExpansion
}

// policyReportLister implements the PolicyReportLister interface.
type policyReportLister struct {
	listers.ResourceIndexer[*policyreportv1alpha2.PolicyReport]
}

// NewPolicyReportLister returns a new PolicyReportLister.
func NewPolicyReportLister(indexer cache.Indexer) PolicyReportLister {
	return &policyReportLister{listers.New[*policyreportv1alpha2.PolicyReport](indexer, policyreportv1alpha2.Resource("policyreport"))}
}

// PolicyReports returns an object that can list and get PolicyReports.
func (s *policyReportLister) PolicyReports(namespace string) PolicyReportNamespaceLister {
	return policyReportNamespaceLister{listers.NewNamespaced[*policyreportv1alpha2.PolicyReport](s.ResourceIndexer, namespace)}
}

// PolicyReportNamespaceLister helps list and get PolicyReports.
// All objects returned here must be treated as read-only.
type PolicyReportNamespaceLister interface {
	// List lists all PolicyReports in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*policyreportv1alpha2.PolicyReport, err error)
	// Get retrieves the PolicyReport from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*policyreportv1alpha2.PolicyReport, error)
	PolicyReportNamespaceListerExpansion
}

// policyReportNamespaceLister implements the PolicyReportNamespaceLister
// interface.
type policyReportNamespaceLister struct {
	listers.ResourceIndexer[*policyreportv1alpha2.PolicyReport]
}
