/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha2

import (
	policyreportv1alpha2 "github.com/kyverno/kyverno/api/policyreport/v1alpha2"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// ClusterPolicyReportLister helps list ClusterPolicyReports.
// All objects returned here must be treated as read-only.
type ClusterPolicyReportLister interface {
	// List lists all ClusterPolicyReports in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*policyreportv1alpha2.ClusterPolicyReport, err error)
	// Get retrieves the ClusterPolicyReport from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*policyreportv1alpha2.ClusterPolicyReport, error)
	ClusterPolicyReportListerExpansion
}

// clusterPolicyReportLister implements the ClusterPolicyReportLister interface.
type clusterPolicyReportLister struct {
	listers.ResourceIndexer[*policyreportv1alpha2.ClusterPolicyReport]
}

// NewClusterPolicyReportLister returns a new ClusterPolicyReportLister.
func NewClusterPolicyReportLister(indexer cache.Indexer) ClusterPolicyReportLister {
	return &clusterPolicyReportLister{listers.New[*policyreportv1alpha2.ClusterPolicyReport](indexer, policyreportv1alpha2.Resource("clusterpolicyreport"))}
}
