/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	policieskyvernoiov1alpha1 "github.com/kyverno/kyverno/api/policies.kyverno.io/v1alpha1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// PolicyExceptionLister helps list PolicyExceptions.
// All objects returned here must be treated as read-only.
type PolicyExceptionLister interface {
	// List lists all PolicyExceptions in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*policieskyvernoiov1alpha1.PolicyException, err error)
	// PolicyExceptions returns an object that can list and get PolicyExceptions.
	PolicyExceptions(namespace string) PolicyExceptionNamespaceLister
	PolicyExceptionListerExpansion
}

// policyExceptionLister implements the PolicyExceptionLister interface.
type policyExceptionLister struct {
	listers.ResourceIndexer[*policieskyvernoiov1alpha1.PolicyException]
}

// NewPolicyExceptionLister returns a new PolicyExceptionLister.
func NewPolicyExceptionLister(indexer cache.Indexer) PolicyExceptionLister {
	return &policyExceptionLister{listers.New[*policieskyvernoiov1alpha1.PolicyException](indexer, policieskyvernoiov1alpha1.Resource("policyexception"))}
}

// PolicyExceptions returns an object that can list and get PolicyExceptions.
func (s *policyExceptionLister) PolicyExceptions(namespace string) PolicyExceptionNamespaceLister {
	return policyExceptionNamespaceLister{listers.NewNamespaced[*policieskyvernoiov1alpha1.PolicyException](s.ResourceIndexer, namespace)}
}

// PolicyExceptionNamespaceLister helps list and get PolicyExceptions.
// All objects returned here must be treated as read-only.
type PolicyExceptionNamespaceLister interface {
	// List lists all PolicyExceptions in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*policieskyvernoiov1alpha1.PolicyException, err error)
	// Get retrieves the PolicyException from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*policieskyvernoiov1alpha1.PolicyException, error)
	PolicyExceptionNamespaceListerExpansion
}

// policyExceptionNamespaceLister implements the PolicyExceptionNamespaceLister
// interface.
type policyExceptionNamespaceLister struct {
	listers.ResourceIndexer[*policieskyvernoiov1alpha1.PolicyException]
}
