/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v2alpha1

import (
	kyvernov2alpha1 "github.com/kyverno/kyverno/api/kyverno/v2alpha1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// GlobalContextEntryLister helps list GlobalContextEntries.
// All objects returned here must be treated as read-only.
type GlobalContextEntryLister interface {
	// List lists all GlobalContextEntries in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kyvernov2alpha1.GlobalContextEntry, err error)
	// Get retrieves the GlobalContextEntry from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kyvernov2alpha1.GlobalContextEntry, error)
	GlobalContextEntryListerExpansion
}

// globalContextEntryLister implements the GlobalContextEntryLister interface.
type globalContextEntryLister struct {
	listers.ResourceIndexer[*kyvernov2alpha1.GlobalContextEntry]
}

// NewGlobalContextEntryLister returns a new GlobalContextEntryLister.
func NewGlobalContextEntryLister(indexer cache.Indexer) GlobalContextEntryLister {
	return &globalContextEntryLister{listers.New[*kyvernov2alpha1.GlobalContextEntry](indexer, kyvernov2alpha1.Resource("globalcontextentry"))}
}
