/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v2

import (
	kyvernov2 "github.com/kyverno/kyverno/api/kyverno/v2"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// UpdateRequestLister helps list UpdateRequests.
// All objects returned here must be treated as read-only.
type UpdateRequestLister interface {
	// List lists all UpdateRequests in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kyvernov2.UpdateRequest, err error)
	// UpdateRequests returns an object that can list and get UpdateRequests.
	UpdateRequests(namespace string) UpdateRequestNamespaceLister
	UpdateRequestListerExpansion
}

// updateRequestLister implements the UpdateRequestLister interface.
type updateRequestLister struct {
	listers.ResourceIndexer[*kyvernov2.UpdateRequest]
}

// NewUpdateRequestLister returns a new UpdateRequestLister.
func NewUpdateRequestLister(indexer cache.Indexer) UpdateRequestLister {
	return &updateRequestLister{listers.New[*kyvernov2.UpdateRequest](indexer, kyvernov2.Resource("updaterequest"))}
}

// UpdateRequests returns an object that can list and get UpdateRequests.
func (s *updateRequestLister) UpdateRequests(namespace string) UpdateRequestNamespaceLister {
	return updateRequestNamespaceLister{listers.NewNamespaced[*kyvernov2.UpdateRequest](s.ResourceIndexer, namespace)}
}

// UpdateRequestNamespaceLister helps list and get UpdateRequests.
// All objects returned here must be treated as read-only.
type UpdateRequestNamespaceLister interface {
	// List lists all UpdateRequests in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kyvernov2.UpdateRequest, err error)
	// Get retrieves the UpdateRequest from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kyvernov2.UpdateRequest, error)
	UpdateRequestNamespaceListerExpansion
}

// updateRequestNamespaceLister implements the UpdateRequestNamespaceLister
// interface.
type updateRequestNamespaceLister struct {
	listers.ResourceIndexer[*kyvernov2.UpdateRequest]
}
