/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	kyvernov1 "github.com/kyverno/kyverno/api/kyverno/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// PolicyLister helps list Policies.
// All objects returned here must be treated as read-only.
type PolicyLister interface {
	// List lists all Policies in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kyvernov1.Policy, err error)
	// Policies returns an object that can list and get Policies.
	Policies(namespace string) PolicyNamespaceLister
	PolicyListerExpansion
}

// policyLister implements the PolicyLister interface.
type policyLister struct {
	listers.ResourceIndexer[*kyvernov1.Policy]
}

// NewPolicyLister returns a new PolicyLister.
func NewPolicyLister(indexer cache.Indexer) PolicyLister {
	return &policyLister{listers.New[*kyvernov1.Policy](indexer, kyvernov1.Resource("policy"))}
}

// Policies returns an object that can list and get Policies.
func (s *policyLister) Policies(namespace string) PolicyNamespaceLister {
	return policyNamespaceLister{listers.NewNamespaced[*kyvernov1.Policy](s.ResourceIndexer, namespace)}
}

// PolicyNamespaceLister helps list and get Policies.
// All objects returned here must be treated as read-only.
type PolicyNamespaceLister interface {
	// List lists all Policies in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kyvernov1.Policy, err error)
	// Get retrieves the Policy from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kyvernov1.Policy, error)
	PolicyNamespaceListerExpansion
}

// policyNamespaceLister implements the PolicyNamespaceLister
// interface.
type policyNamespaceLister struct {
	listers.ResourceIndexer[*kyvernov1.Policy]
}
