/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1

import (
	context "context"
	time "time"

	apireportsv1 "github.com/kyverno/kyverno/api/reports/v1"
	versioned "github.com/kyverno/kyverno/pkg/client/clientset/versioned"
	internalinterfaces "github.com/kyverno/kyverno/pkg/client/informers/externalversions/internalinterfaces"
	reportsv1 "github.com/kyverno/kyverno/pkg/client/listers/reports/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// ClusterEphemeralReportInformer provides access to a shared informer and lister for
// ClusterEphemeralReports.
type ClusterEphemeralReportInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() reportsv1.ClusterEphemeralReportLister
}

type clusterEphemeralReportInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// NewClusterEphemeralReportInformer constructs a new informer for ClusterEphemeralReport type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewClusterEphemeralReportInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredClusterEphemeralReportInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredClusterEphemeralReportInformer constructs a new informer for ClusterEphemeralReport type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredClusterEphemeralReportInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options metav1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ReportsV1().ClusterEphemeralReports().List(context.TODO(), options)
			},
			WatchFunc: func(options metav1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ReportsV1().ClusterEphemeralReports().Watch(context.TODO(), options)
			},
		},
		&apireportsv1.ClusterEphemeralReport{},
		resyncPeriod,
		indexers,
	)
}

func (f *clusterEphemeralReportInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredClusterEphemeralReportInformer(client, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *clusterEphemeralReportInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&apireportsv1.ClusterEphemeralReport{}, f.defaultInformer)
}

func (f *clusterEphemeralReportInformer) Lister() reportsv1.ClusterEphemeralReportLister {
	return reportsv1.NewClusterEphemeralReportLister(f.Informer().GetIndexer())
}
