/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v2alpha1

import (
	context "context"
	time "time"

	apikyvernov2alpha1 "github.com/kyverno/kyverno/api/kyverno/v2alpha1"
	versioned "github.com/kyverno/kyverno/pkg/client/clientset/versioned"
	internalinterfaces "github.com/kyverno/kyverno/pkg/client/informers/externalversions/internalinterfaces"
	kyvernov2alpha1 "github.com/kyverno/kyverno/pkg/client/listers/kyverno/v2alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// GlobalContextEntryInformer provides access to a shared informer and lister for
// GlobalContextEntries.
type GlobalContextEntryInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kyvernov2alpha1.GlobalContextEntryLister
}

type globalContextEntryInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// NewGlobalContextEntryInformer constructs a new informer for GlobalContextEntry type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewGlobalContextEntryInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredGlobalContextEntryInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredGlobalContextEntryInformer constructs a new informer for GlobalContextEntry type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredGlobalContextEntryInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.KyvernoV2alpha1().GlobalContextEntries().List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.KyvernoV2alpha1().GlobalContextEntries().Watch(context.TODO(), options)
			},
		},
		&apikyvernov2alpha1.GlobalContextEntry{},
		resyncPeriod,
		indexers,
	)
}

func (f *globalContextEntryInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredGlobalContextEntryInformer(client, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *globalContextEntryInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&apikyvernov2alpha1.GlobalContextEntry{}, f.defaultInformer)
}

func (f *globalContextEntryInformer) Lister() kyvernov2alpha1.GlobalContextEntryLister {
	return kyvernov2alpha1.NewGlobalContextEntryLister(f.Informer().GetIndexer())
}
