/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v2

import (
	context "context"
	time "time"

	apikyvernov2 "github.com/kyverno/kyverno/api/kyverno/v2"
	versioned "github.com/kyverno/kyverno/pkg/client/clientset/versioned"
	internalinterfaces "github.com/kyverno/kyverno/pkg/client/informers/externalversions/internalinterfaces"
	kyvernov2 "github.com/kyverno/kyverno/pkg/client/listers/kyverno/v2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// UpdateRequestInformer provides access to a shared informer and lister for
// UpdateRequests.
type UpdateRequestInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kyvernov2.UpdateRequestLister
}

type updateRequestInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewUpdateRequestInformer constructs a new informer for UpdateRequest type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewUpdateRequestInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredUpdateRequestInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredUpdateRequestInformer constructs a new informer for UpdateRequest type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredUpdateRequestInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.KyvernoV2().UpdateRequests(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.KyvernoV2().UpdateRequests(namespace).Watch(context.TODO(), options)
			},
		},
		&apikyvernov2.UpdateRequest{},
		resyncPeriod,
		indexers,
	)
}

func (f *updateRequestInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredUpdateRequestInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *updateRequestInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&apikyvernov2.UpdateRequest{}, f.defaultInformer)
}

func (f *updateRequestInformer) Lister() kyvernov2.UpdateRequestLister {
	return kyvernov2.NewUpdateRequestLister(f.Informer().GetIndexer())
}
