/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package externalversions

import (
	fmt "fmt"

	v1 "github.com/kyverno/kyverno/api/kyverno/v1"
	v2 "github.com/kyverno/kyverno/api/kyverno/v2"
	v2alpha1 "github.com/kyverno/kyverno/api/kyverno/v2alpha1"
	v1alpha1 "github.com/kyverno/kyverno/api/policies.kyverno.io/v1alpha1"
	v1alpha2 "github.com/kyverno/kyverno/api/policyreport/v1alpha2"
	reportsv1 "github.com/kyverno/kyverno/api/reports/v1"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	cache "k8s.io/client-go/tools/cache"
)

// GenericInformer is type of SharedIndexInformer which will locate and delegate to other
// sharedInformers based on type
type GenericInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() cache.GenericLister
}

type genericInformer struct {
	informer cache.SharedIndexInformer
	resource schema.GroupResource
}

// Informer returns the SharedIndexInformer.
func (f *genericInformer) Informer() cache.SharedIndexInformer {
	return f.informer
}

// Lister returns the GenericLister.
func (f *genericInformer) Lister() cache.GenericLister {
	return cache.NewGenericLister(f.Informer().GetIndexer(), f.resource)
}

// ForResource gives generic access to a shared informer of the matching type
// TODO extend this to unknown resources with a client pool
func (f *sharedInformerFactory) ForResource(resource schema.GroupVersionResource) (GenericInformer, error) {
	switch resource {
	// Group=kyverno.io, Version=v1
	case v1.SchemeGroupVersion.WithResource("clusterpolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Kyverno().V1().ClusterPolicies().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("policies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Kyverno().V1().Policies().Informer()}, nil

		// Group=kyverno.io, Version=v2
	case v2.SchemeGroupVersion.WithResource("cleanuppolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Kyverno().V2().CleanupPolicies().Informer()}, nil
	case v2.SchemeGroupVersion.WithResource("clustercleanuppolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Kyverno().V2().ClusterCleanupPolicies().Informer()}, nil
	case v2.SchemeGroupVersion.WithResource("policyexceptions"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Kyverno().V2().PolicyExceptions().Informer()}, nil
	case v2.SchemeGroupVersion.WithResource("updaterequests"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Kyverno().V2().UpdateRequests().Informer()}, nil

		// Group=kyverno.io, Version=v2alpha1
	case v2alpha1.SchemeGroupVersion.WithResource("globalcontextentries"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Kyverno().V2alpha1().GlobalContextEntries().Informer()}, nil

		// Group=policies.kyverno.io, Version=v1alpha1
	case v1alpha1.SchemeGroupVersion.WithResource("deletingpolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Policies().V1alpha1().DeletingPolicies().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("generatingpolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Policies().V1alpha1().GeneratingPolicies().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("imagevalidatingpolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Policies().V1alpha1().ImageValidatingPolicies().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("mutatingpolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Policies().V1alpha1().MutatingPolicies().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("policyexceptions"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Policies().V1alpha1().PolicyExceptions().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("validatingpolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Policies().V1alpha1().ValidatingPolicies().Informer()}, nil

		// Group=reports.kyverno.io, Version=v1
	case reportsv1.SchemeGroupVersion.WithResource("clusterephemeralreports"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Reports().V1().ClusterEphemeralReports().Informer()}, nil
	case reportsv1.SchemeGroupVersion.WithResource("ephemeralreports"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Reports().V1().EphemeralReports().Informer()}, nil

		// Group=wgpolicyk8s.io, Version=v1alpha2
	case v1alpha2.SchemeGroupVersion.WithResource("clusterpolicyreports"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Wgpolicyk8s().V1alpha2().ClusterPolicyReports().Informer()}, nil
	case v1alpha2.SchemeGroupVersion.WithResource("policyreports"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Wgpolicyk8s().V1alpha2().PolicyReports().Informer()}, nil

	}

	return nil, fmt.Errorf("no informer found for %v", resource)
}
