/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	reportsv1 "github.com/kyverno/kyverno/api/reports/v1"
	scheme "github.com/kyverno/kyverno/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// EphemeralReportsGetter has a method to return a EphemeralReportInterface.
// A group's client should implement this interface.
type EphemeralReportsGetter interface {
	EphemeralReports(namespace string) EphemeralReportInterface
}

// EphemeralReportInterface has methods to work with EphemeralReport resources.
type EphemeralReportInterface interface {
	Create(ctx context.Context, ephemeralReport *reportsv1.EphemeralReport, opts metav1.CreateOptions) (*reportsv1.EphemeralReport, error)
	Update(ctx context.Context, ephemeralReport *reportsv1.EphemeralReport, opts metav1.UpdateOptions) (*reportsv1.EphemeralReport, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*reportsv1.EphemeralReport, error)
	List(ctx context.Context, opts metav1.ListOptions) (*reportsv1.EphemeralReportList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *reportsv1.EphemeralReport, err error)
	EphemeralReportExpansion
}

// ephemeralReports implements EphemeralReportInterface
type ephemeralReports struct {
	*gentype.ClientWithList[*reportsv1.EphemeralReport, *reportsv1.EphemeralReportList]
}

// newEphemeralReports returns a EphemeralReports
func newEphemeralReports(c *ReportsV1Client, namespace string) *ephemeralReports {
	return &ephemeralReports{
		gentype.NewClientWithList[*reportsv1.EphemeralReport, *reportsv1.EphemeralReportList](
			"ephemeralreports",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *reportsv1.EphemeralReport { return &reportsv1.EphemeralReport{} },
			func() *reportsv1.EphemeralReportList { return &reportsv1.EphemeralReportList{} },
		),
	}
}
