/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	reportsv1 "github.com/kyverno/kyverno/api/reports/v1"
	scheme "github.com/kyverno/kyverno/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ClusterEphemeralReportsGetter has a method to return a ClusterEphemeralReportInterface.
// A group's client should implement this interface.
type ClusterEphemeralReportsGetter interface {
	ClusterEphemeralReports() ClusterEphemeralReportInterface
}

// ClusterEphemeralReportInterface has methods to work with ClusterEphemeralReport resources.
type ClusterEphemeralReportInterface interface {
	Create(ctx context.Context, clusterEphemeralReport *reportsv1.ClusterEphemeralReport, opts metav1.CreateOptions) (*reportsv1.ClusterEphemeralReport, error)
	Update(ctx context.Context, clusterEphemeralReport *reportsv1.ClusterEphemeralReport, opts metav1.UpdateOptions) (*reportsv1.ClusterEphemeralReport, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*reportsv1.ClusterEphemeralReport, error)
	List(ctx context.Context, opts metav1.ListOptions) (*reportsv1.ClusterEphemeralReportList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *reportsv1.ClusterEphemeralReport, err error)
	ClusterEphemeralReportExpansion
}

// clusterEphemeralReports implements ClusterEphemeralReportInterface
type clusterEphemeralReports struct {
	*gentype.ClientWithList[*reportsv1.ClusterEphemeralReport, *reportsv1.ClusterEphemeralReportList]
}

// newClusterEphemeralReports returns a ClusterEphemeralReports
func newClusterEphemeralReports(c *ReportsV1Client) *clusterEphemeralReports {
	return &clusterEphemeralReports{
		gentype.NewClientWithList[*reportsv1.ClusterEphemeralReport, *reportsv1.ClusterEphemeralReportList](
			"clusterephemeralreports",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *reportsv1.ClusterEphemeralReport { return &reportsv1.ClusterEphemeralReport{} },
			func() *reportsv1.ClusterEphemeralReportList { return &reportsv1.ClusterEphemeralReportList{} },
		),
	}
}
