/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	context "context"

	policyreportv1alpha2 "github.com/kyverno/kyverno/api/policyreport/v1alpha2"
	scheme "github.com/kyverno/kyverno/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ClusterPolicyReportsGetter has a method to return a ClusterPolicyReportInterface.
// A group's client should implement this interface.
type ClusterPolicyReportsGetter interface {
	ClusterPolicyReports() ClusterPolicyReportInterface
}

// ClusterPolicyReportInterface has methods to work with ClusterPolicyReport resources.
type ClusterPolicyReportInterface interface {
	Create(ctx context.Context, clusterPolicyReport *policyreportv1alpha2.ClusterPolicyReport, opts v1.CreateOptions) (*policyreportv1alpha2.ClusterPolicyReport, error)
	Update(ctx context.Context, clusterPolicyReport *policyreportv1alpha2.ClusterPolicyReport, opts v1.UpdateOptions) (*policyreportv1alpha2.ClusterPolicyReport, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*policyreportv1alpha2.ClusterPolicyReport, error)
	List(ctx context.Context, opts v1.ListOptions) (*policyreportv1alpha2.ClusterPolicyReportList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *policyreportv1alpha2.ClusterPolicyReport, err error)
	ClusterPolicyReportExpansion
}

// clusterPolicyReports implements ClusterPolicyReportInterface
type clusterPolicyReports struct {
	*gentype.ClientWithList[*policyreportv1alpha2.ClusterPolicyReport, *policyreportv1alpha2.ClusterPolicyReportList]
}

// newClusterPolicyReports returns a ClusterPolicyReports
func newClusterPolicyReports(c *Wgpolicyk8sV1alpha2Client) *clusterPolicyReports {
	return &clusterPolicyReports{
		gentype.NewClientWithList[*policyreportv1alpha2.ClusterPolicyReport, *policyreportv1alpha2.ClusterPolicyReportList](
			"clusterpolicyreports",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *policyreportv1alpha2.ClusterPolicyReport { return &policyreportv1alpha2.ClusterPolicyReport{} },
			func() *policyreportv1alpha2.ClusterPolicyReportList {
				return &policyreportv1alpha2.ClusterPolicyReportList{}
			},
		),
	}
}
