/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	policieskyvernoiov1alpha1 "github.com/kyverno/kyverno/api/policies.kyverno.io/v1alpha1"
	scheme "github.com/kyverno/kyverno/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ValidatingPoliciesGetter has a method to return a ValidatingPolicyInterface.
// A group's client should implement this interface.
type ValidatingPoliciesGetter interface {
	ValidatingPolicies() ValidatingPolicyInterface
}

// ValidatingPolicyInterface has methods to work with ValidatingPolicy resources.
type ValidatingPolicyInterface interface {
	Create(ctx context.Context, validatingPolicy *policieskyvernoiov1alpha1.ValidatingPolicy, opts v1.CreateOptions) (*policieskyvernoiov1alpha1.ValidatingPolicy, error)
	Update(ctx context.Context, validatingPolicy *policieskyvernoiov1alpha1.ValidatingPolicy, opts v1.UpdateOptions) (*policieskyvernoiov1alpha1.ValidatingPolicy, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, validatingPolicy *policieskyvernoiov1alpha1.ValidatingPolicy, opts v1.UpdateOptions) (*policieskyvernoiov1alpha1.ValidatingPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*policieskyvernoiov1alpha1.ValidatingPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*policieskyvernoiov1alpha1.ValidatingPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *policieskyvernoiov1alpha1.ValidatingPolicy, err error)
	ValidatingPolicyExpansion
}

// validatingPolicies implements ValidatingPolicyInterface
type validatingPolicies struct {
	*gentype.ClientWithList[*policieskyvernoiov1alpha1.ValidatingPolicy, *policieskyvernoiov1alpha1.ValidatingPolicyList]
}

// newValidatingPolicies returns a ValidatingPolicies
func newValidatingPolicies(c *PoliciesV1alpha1Client) *validatingPolicies {
	return &validatingPolicies{
		gentype.NewClientWithList[*policieskyvernoiov1alpha1.ValidatingPolicy, *policieskyvernoiov1alpha1.ValidatingPolicyList](
			"validatingpolicies",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *policieskyvernoiov1alpha1.ValidatingPolicy {
				return &policieskyvernoiov1alpha1.ValidatingPolicy{}
			},
			func() *policieskyvernoiov1alpha1.ValidatingPolicyList {
				return &policieskyvernoiov1alpha1.ValidatingPolicyList{}
			},
		),
	}
}
