/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	policieskyvernoiov1alpha1 "github.com/kyverno/kyverno/api/policies.kyverno.io/v1alpha1"
	scheme "github.com/kyverno/kyverno/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// MutatingPoliciesGetter has a method to return a MutatingPolicyInterface.
// A group's client should implement this interface.
type MutatingPoliciesGetter interface {
	MutatingPolicies() MutatingPolicyInterface
}

// MutatingPolicyInterface has methods to work with MutatingPolicy resources.
type MutatingPolicyInterface interface {
	Create(ctx context.Context, mutatingPolicy *policieskyvernoiov1alpha1.MutatingPolicy, opts v1.CreateOptions) (*policieskyvernoiov1alpha1.MutatingPolicy, error)
	Update(ctx context.Context, mutatingPolicy *policieskyvernoiov1alpha1.MutatingPolicy, opts v1.UpdateOptions) (*policieskyvernoiov1alpha1.MutatingPolicy, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, mutatingPolicy *policieskyvernoiov1alpha1.MutatingPolicy, opts v1.UpdateOptions) (*policieskyvernoiov1alpha1.MutatingPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*policieskyvernoiov1alpha1.MutatingPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*policieskyvernoiov1alpha1.MutatingPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *policieskyvernoiov1alpha1.MutatingPolicy, err error)
	MutatingPolicyExpansion
}

// mutatingPolicies implements MutatingPolicyInterface
type mutatingPolicies struct {
	*gentype.ClientWithList[*policieskyvernoiov1alpha1.MutatingPolicy, *policieskyvernoiov1alpha1.MutatingPolicyList]
}

// newMutatingPolicies returns a MutatingPolicies
func newMutatingPolicies(c *PoliciesV1alpha1Client) *mutatingPolicies {
	return &mutatingPolicies{
		gentype.NewClientWithList[*policieskyvernoiov1alpha1.MutatingPolicy, *policieskyvernoiov1alpha1.MutatingPolicyList](
			"mutatingpolicies",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *policieskyvernoiov1alpha1.MutatingPolicy { return &policieskyvernoiov1alpha1.MutatingPolicy{} },
			func() *policieskyvernoiov1alpha1.MutatingPolicyList {
				return &policieskyvernoiov1alpha1.MutatingPolicyList{}
			},
		),
	}
}
