/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	policieskyvernoiov1alpha1 "github.com/kyverno/kyverno/api/policies.kyverno.io/v1alpha1"
	scheme "github.com/kyverno/kyverno/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// DeletingPoliciesGetter has a method to return a DeletingPolicyInterface.
// A group's client should implement this interface.
type DeletingPoliciesGetter interface {
	DeletingPolicies() DeletingPolicyInterface
}

// DeletingPolicyInterface has methods to work with DeletingPolicy resources.
type DeletingPolicyInterface interface {
	Create(ctx context.Context, deletingPolicy *policieskyvernoiov1alpha1.DeletingPolicy, opts v1.CreateOptions) (*policieskyvernoiov1alpha1.DeletingPolicy, error)
	Update(ctx context.Context, deletingPolicy *policieskyvernoiov1alpha1.DeletingPolicy, opts v1.UpdateOptions) (*policieskyvernoiov1alpha1.DeletingPolicy, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, deletingPolicy *policieskyvernoiov1alpha1.DeletingPolicy, opts v1.UpdateOptions) (*policieskyvernoiov1alpha1.DeletingPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*policieskyvernoiov1alpha1.DeletingPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*policieskyvernoiov1alpha1.DeletingPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *policieskyvernoiov1alpha1.DeletingPolicy, err error)
	DeletingPolicyExpansion
}

// deletingPolicies implements DeletingPolicyInterface
type deletingPolicies struct {
	*gentype.ClientWithList[*policieskyvernoiov1alpha1.DeletingPolicy, *policieskyvernoiov1alpha1.DeletingPolicyList]
}

// newDeletingPolicies returns a DeletingPolicies
func newDeletingPolicies(c *PoliciesV1alpha1Client) *deletingPolicies {
	return &deletingPolicies{
		gentype.NewClientWithList[*policieskyvernoiov1alpha1.DeletingPolicy, *policieskyvernoiov1alpha1.DeletingPolicyList](
			"deletingpolicies",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *policieskyvernoiov1alpha1.DeletingPolicy { return &policieskyvernoiov1alpha1.DeletingPolicy{} },
			func() *policieskyvernoiov1alpha1.DeletingPolicyList {
				return &policieskyvernoiov1alpha1.DeletingPolicyList{}
			},
		),
	}
}
