/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v2

import (
	context "context"

	kyvernov2 "github.com/kyverno/kyverno/api/kyverno/v2"
	scheme "github.com/kyverno/kyverno/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ClusterCleanupPoliciesGetter has a method to return a ClusterCleanupPolicyInterface.
// A group's client should implement this interface.
type ClusterCleanupPoliciesGetter interface {
	ClusterCleanupPolicies() ClusterCleanupPolicyInterface
}

// ClusterCleanupPolicyInterface has methods to work with ClusterCleanupPolicy resources.
type ClusterCleanupPolicyInterface interface {
	Create(ctx context.Context, clusterCleanupPolicy *kyvernov2.ClusterCleanupPolicy, opts v1.CreateOptions) (*kyvernov2.ClusterCleanupPolicy, error)
	Update(ctx context.Context, clusterCleanupPolicy *kyvernov2.ClusterCleanupPolicy, opts v1.UpdateOptions) (*kyvernov2.ClusterCleanupPolicy, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, clusterCleanupPolicy *kyvernov2.ClusterCleanupPolicy, opts v1.UpdateOptions) (*kyvernov2.ClusterCleanupPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*kyvernov2.ClusterCleanupPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*kyvernov2.ClusterCleanupPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *kyvernov2.ClusterCleanupPolicy, err error)
	ClusterCleanupPolicyExpansion
}

// clusterCleanupPolicies implements ClusterCleanupPolicyInterface
type clusterCleanupPolicies struct {
	*gentype.ClientWithList[*kyvernov2.ClusterCleanupPolicy, *kyvernov2.ClusterCleanupPolicyList]
}

// newClusterCleanupPolicies returns a ClusterCleanupPolicies
func newClusterCleanupPolicies(c *KyvernoV2Client) *clusterCleanupPolicies {
	return &clusterCleanupPolicies{
		gentype.NewClientWithList[*kyvernov2.ClusterCleanupPolicy, *kyvernov2.ClusterCleanupPolicyList](
			"clustercleanuppolicies",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *kyvernov2.ClusterCleanupPolicy { return &kyvernov2.ClusterCleanupPolicy{} },
			func() *kyvernov2.ClusterCleanupPolicyList { return &kyvernov2.ClusterCleanupPolicyList{} },
		),
	}
}
