/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v2

import (
	context "context"

	kyvernov2 "github.com/kyverno/kyverno/api/kyverno/v2"
	scheme "github.com/kyverno/kyverno/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// CleanupPoliciesGetter has a method to return a CleanupPolicyInterface.
// A group's client should implement this interface.
type CleanupPoliciesGetter interface {
	CleanupPolicies(namespace string) CleanupPolicyInterface
}

// CleanupPolicyInterface has methods to work with CleanupPolicy resources.
type CleanupPolicyInterface interface {
	Create(ctx context.Context, cleanupPolicy *kyvernov2.CleanupPolicy, opts v1.CreateOptions) (*kyvernov2.CleanupPolicy, error)
	Update(ctx context.Context, cleanupPolicy *kyvernov2.CleanupPolicy, opts v1.UpdateOptions) (*kyvernov2.CleanupPolicy, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, cleanupPolicy *kyvernov2.CleanupPolicy, opts v1.UpdateOptions) (*kyvernov2.CleanupPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*kyvernov2.CleanupPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*kyvernov2.CleanupPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *kyvernov2.CleanupPolicy, err error)
	CleanupPolicyExpansion
}

// cleanupPolicies implements CleanupPolicyInterface
type cleanupPolicies struct {
	*gentype.ClientWithList[*kyvernov2.CleanupPolicy, *kyvernov2.CleanupPolicyList]
}

// newCleanupPolicies returns a CleanupPolicies
func newCleanupPolicies(c *KyvernoV2Client, namespace string) *cleanupPolicies {
	return &cleanupPolicies{
		gentype.NewClientWithList[*kyvernov2.CleanupPolicy, *kyvernov2.CleanupPolicyList](
			"cleanuppolicies",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *kyvernov2.CleanupPolicy { return &kyvernov2.CleanupPolicy{} },
			func() *kyvernov2.CleanupPolicyList { return &kyvernov2.CleanupPolicyList{} },
		),
	}
}
