# Kyverno Adopters

This is the list of organizations and users that have publicly shared how they are using Kyverno.

💡 **Add your organization by creating a PR or [submitting this form](https://forms.gle/K5CApcBAD5D4H1AG8)**

Note: There are several other organizations and users that are unable to publicly share their stories but are active in the Kyverno community. We appreciate all our users and their contributions to making Kyverno a successful CNCF project.

The list of organizations that have publicly shared the usage of Kyverno:

| Organization                                                                                                  | Success Story                                                                                                                                                                                                                |
|:--------------------------------------------------------------------------------------------------------------|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Amazon EKS Best Practice Guides](https://github.com/aws/aws-eks-best-practices/tree/master/policies/kyverno) | Policies for security and best practices                                                                                                                                                                                     |
| [Arrikto Inc.](https://www.arrikto.com)                                                                       | Kubeflow policies                                                                                                                                                                                                            |
| [Flux2](https://github.com/fluxcd/flux2-multi-tenancy#enforce-tenant-isolation)                               | Manage multi-tenancy and tenant isolation with GitOps                                                                                                                                                                        |
| [Nirmata](https://nirmata.com)                                                                                | Kubernetes Policy and Governance                                                                                                                                                                                             |
| [Ohio Supercomputer Center](https://www.osc.edu/)                                                             | Support Kubernetes multi-user workflows through [Open OnDemand](http://openondemand.org/)                                                                                                                                    |
| [Coinbase](https://www.coinbase.com/)                                                                         | Use Kyverno for mutation, to replace hand-written Webhooks, and generation to project common Kubernetes objects into many similar namespaces.                                                                                |
| [Mandiant](https://www.mandiant.com/)                                                                         | Use Kyverno for policy enforcement in all clusters, as well as part of our onboarding systems, populating new namespaces with requisite resources and secrets.                                                               |
| [Giant Swarm](https://www.giantswarm.io/)                                                                     | Use Kyverno extensively to handle defaulting logic on resources (primarily cluster-api resources) and some scenarios to replace PSPs to enforce certain restrictions.                                                        |
| [Vodafone Group Plc](https://www.vodafone.com/)                                                               | Policy enforcement and automation on an internal k8s service offering.                                                                                                                                                       |
| [Deutsche Telekom](https://www.telekom.com/en)                                                                | Use Kyverno to enforce Policies on managed clusters to prevent right escalation of internal customers and to enforce security rules.                                                                                         |
| [VSHN AG - APPUiO Cloud](https://www.vshn.ch/)                                                                | OpenShift Multi-Tenancy Self-Service for [APPUiO Cloud](https://www.appuio.ch), managed with [Project Syn](https://syn.tools). Kyverno policies are available on [GitHub](https://github.com/appuio/component-appuio-cloud). |
| [Bloomberg](https://www.techatbloomberg.com/)                                                                 | Use Kyverno for replacing custom validation and mutation webhooks in their internal Kubernetes based platforms                                                                                                               |
| [Techcombank](https://www.techcombank.com.vn/trang-chu)                                                       | Use Kyverno to enforce security policies rules, Kubernetes best practices for their internal container based workload on Kubernetes                                                                                          |
| [Trendyol](https://www.trendyol.com)                                                                          | In adoption planning to roll out to hundreds of production clusters using GitOps                                                                                                                                             |
| [Rafay Systems](https://rafay.co/)                                                                            | Platform supports centralized deployment of Kyverno across clusters                                                                                                                                                          |
| [Wayfair](https://wayfair.com)                                                                                | Policy enforcement on managed clusters. Replacement of some in-house mutating webhooks.                                                                                                                                      |
| [Yahoo](https://www.yahoo.com/)                                                                               | Use Kyverno for mutation, to replace image tags to digest and also for validation for checking freshness of images.                                                                                                          |
| [T-Systems](https://www.t-systems.com)                                                                        |                                                                                                                                                                                                                              |
| [Red Hat](https://www.redhat.com)                                                                             | Learn more about Red Hat Advanced Cluster Management for Kubernetes for [Generating Governance Policies Using Kustomize and GitOps](https://cloud.redhat.com/blog/generating-governance-policies-using-kustomize-and-gitops).|
| [DE-CIX](https://www.de-cix.net)                                                                              | Kyvernos policy enforcement is used to enforce the company's security guidelines. This is done using validation, mutation and generation techniques.                                                                        |
| [Saxo Bank](https://www.home.saxo/)                                                                           | We use Kyverno to enforce security and best practises.                                                                                                                                                                      |
| [Velux](https://www.velux.com/)                                                                               | We successfully use Kyverno in our clusters for security, best practice enforcement, resource mutation, secret copying and more!                                                                                             |
| [HCS Company](https://www.hcs-company.com/)                                                                   | Policy enforcement and enabling selfservice for DevOps teams.                                                                                                                                                                |
| [Hexagon](https://hexagon.com/)                                                                               | We leverage Kyverno to robustly enforce security policies. Additionally, as a Kubernetes swiss-knife, Kyverno fills our gap in our GitOps workflow by allowing us to apply complex configurations and customizations which are beyond the native capabilities of Kubernetes operators. |
| [Grover Group GmbH](https://www.grover.com)                                                                   | We have been using Kyverno to streamline our K8s security standards and also follow industry best practices for running workloads in K8s using policy enforcements.                                                          |
| [IITS Consulting](https://iits-consulting.de/)                                                                | Security is a piece of cake with Kyverno. Kyverno helped us to implement proper security for different kind of clients (medical/telecommunication/trading...). It solves problems like security enforcement, container image verification, distribution of imagePullSecrets and many more. |
| [LinkedIn](https://www.linkedin.com/)                                                                | Policy enforcement on our on-prem Kubernetes clusters. |
| [Groww](https://groww.in/) | We have implemented Kyverno as a part of Auto compliance. We put policies to satisfy CIS Compliance for GKE as well as block anomalies detected by the Red Team. |
| [Spotify](https://www.cncf.io/announcements/2023/11/08/cloud-native-computing-foundation-presents-the-top-end-user-award-to-spotify/) | Spotify uses Kyverno extensively for its admission controller capabilities, including best practices and environment-specific data. |
| [US DoD Platform One](https://p1.dso.mil/) |  The US Department of Defense (DoD) Platform One uses Kyverno as its default policy engine for Kubernetes. |
| [Censhare](https://www.censhare.com/) | We use Kyverno in almost all possible areas of security and automation, we call Kyverno as a "Multi-tenancy engine" since we host a multi-tenancy environment for our partners and customers. We have deprecated our own tooling that was complicated and hard to maintain, Thanks to Kyverno.  |
| [Coinone](https://coinone.co.kr) | Use Kyverno to enforce security hardening and best practices, and mutate pod specs related to graceful shutdown handling, such as tGPS<sup>terminationGracePeriodSeconds</sup> and custom preStop script. |
| [Davidson consulting](https://www.davidson.group) | We are using Kyverno mutation policies in our pre-production environment to add default NetworkPolicy and to add labels to OKD resources. | 
| [InfraCloud Technologies](https://www.infracloud.io/) | We have successfully implemented Kyverno as a crucial component of our SOC2 compliance, alongside other essential security hardening measures & best practices. Kyverno's policies offer a significantly streamlined implementation process, far exceeding the complexities associated with cloud services. | 
| [North IT](https://www.northit.co.uk/) | North IT use Kyverno to help deploy Kubernetes for our pen-testing and SOC platform. | 
| [Corestream](https://corp.corestream.com/) | At our organization, we've leveraged Kyverno to significantly enhance our Kubernetes-based DevOps practices. We use Kyverno's policy-as-code approach to automate and enforce best practices across our clusters. Our policies cover a wide range of scenarios, from managing Azure Key Vault integrations and secret protections to enforcing image registry restrictions and implementing multi-region deployment strategies. Kyverno allows us to automatically inject configuration, create role-based access controls, and ensure consistent labeling across our resources. This automation not only improves our security posture by preventing misconfigurations and unauthorized changes but also streamlines our deployment processes. By using Kyverno, we've been able to standardize our environments, reduce manual errors, and maintain compliance with our organization's policies. |
| [Tigera](https://www.tigera.io/) | Kubernetes Policy and Governance |
| [kubriX platform](kubrix.io) | Policy enforcement and automation of your kubrix platform using GitOps |
| [OVHcloud](https://www.ovhcloud.com/) | At OVHcloud, we advise our customers to [deploy Kyverno as a policy engine on their Managed Kubernetes (MKS) clusters](https://help.ovhcloud.com/csm/en-gb-public-cloud-kubernetes-install-kyverno?id=kb_article_view&sysparm_article=KB0049839) and we also use it internally to enforce the security of several of our products. |
| [X3M Ads](https://x3mads.com/) | At X3M Ads, we primarily use Kyverno for mutating resources, such as changing pod images to our internal Harbor registry, managing topology distribution and adding node metadata to pods for improved observability. |
| [Tails.com](https://tails.com/) | Big changes start small; we use Kyverno to build up best practices in development environments so that we can easily enforce stringent security measures in our production environments. |
| [ONZACK AG](https://www.onzack.com/) | The operator for everything; we use Kyverno to completely automate resource management (limits & requests). |
| [Finastra](https://www.finastra.com/) | Currently exploring and leveraging Kyverno to enforce our security and compliance for our K8s deployments in a financial context. | 
| [SingleStore](https://www.singlestore.com/) | We use Kyverno to enforce container images were signed by SingleStore, ensure safer rollouts, and ensure other security practices such as restrict escalation on roles. |
| [Educates Training Platform](https://educates.dev) | Educates is a FOSS Cloud Native Hands-on Training Platform in which we use Kyverno to provide proper workshop isolation between different sessions and enforcing workshop specific related policies | 
| [Kubermatic](https://www.kubermatic.com) | Kyverno is fully integrated across platform, project, and cluster levels in KKP - enabling platform teams to declaratively define, automate, and consistently enforce security, compliance, and operational policies across multi-tenant Kubernetes environments, all seamlessly managed through the KKP UI. | 
<!-- append the line below to the table
| [name](URL) | brief description of how you are using Kyverno | 
-->
