searchData={"items":[{"type":"extras","title":"Kaisen Linux | Manpages","doc":"# Kaisen Linux | Manpages\n\nThis documentation contains **697** of configuration manuals from section 5 of **kaisenlinux** manpages.\n\n![kaisen-menu](assets/kaisen_menu.png)","ref":"readme.html"},{"type":"extras","title":"Manpages by command name - Kaisen Linux | Manpages","doc":"You can switch to sorted manpages by **command name** [by clicking here](../commands/readme.html)","ref":"readme.html#manpages-by-command-name"},{"type":"extras","title":"Tools by categories manpages - Kaisen Linux | Manpages","doc":"You can also switch to sorted manpages **tools categories** [by clicking here](../readme.html)","ref":"readme.html#tools-by-categories-manpages"},{"type":"extras","title":"Other Links - Kaisen Linux | Manpages","doc":"* Check the [official Kaisen Linux](https://kaisenlinux.org/) website.\n* Check the [official Kaisen Linux documentation](https://kaisenlinux.org/documentation/).\n* Check [Debian testing manpages](https://manpages.debian.org/contents-testing.html) for additionnal help.","ref":"readme.html#other-links"},{"type":"extras","title":"Contributors - Kaisen Linux | Manpages","doc":"Manpages for Kaisen Linux made by Arnaud Cormier and Kevin Chevreuil","ref":"readme.html#contributors"},{"type":"extras","title":"access.conf","doc":"ACCESS.CONF(5)                                                                         Linux-PAM Manual                                                                         ACCESS.CONF(5)\n\nNAME\n       access.conf - the login access control table file\n\nDESCRIPTION\n       The /etc/security/access.conf file specifies (user/group, host), (user/group, network/netmask), (user/group, tty), (user/group, X-$DISPLAY-value), or (user/group, pam-service-name)\n       combinations for which a login will be either accepted or refused.\n\n       When someone logs in, the file access.conf is scanned for the first entry that matches the (user/group, host) or (user/group, network/netmask) combination, or, in case of\n       non-networked logins, the first entry that matches the (user/group, tty) combination, or in the case of non-networked logins without a tty, the first entry that matches the\n       (user/group, X-$DISPLAY-value) or (user/group, pam-service-name/) combination. The permissions field of that table entry determines whether the login will be accepted or refused.\n\n       Each line of the login access control table has three fields separated by a \":\" character (colon):\n\n       permission:users/groups:origins\n\n       The first field, the permission field, can be either a \"+\" character (plus) for access granted or a \"-\" character (minus) for access denied.\n\n       The second field, the users/group field, should be a list of one or more login names, group names, uid, gid, or ALL (which always matches). To differentiate user entries from group\n       entries, group entries should be written with brackets, e.g.  (group) or (gid).\n\n       The third field, the origins field, should be a list of one or more tty names (for non-networked logins), X $DISPLAY values or PAM service names (for non-networked logins without a\n       tty), host names, domain names (begin with \".\"), host addresses, internet network numbers (end with \".\"), internet network addresses with network mask (where network mask can be a\n       decimal number or an internet address also), ALL (which always matches) or LOCAL. The LOCAL keyword matches when the user connects without a network connection (e.g., su, login). A\n       connection through the loopback device (e.g., ssh user@localhost) is considered a network connection, and thus, the LOCAL keyword does not match.\n\n       If supported by the system you can use @netgroupname in host or user patterns. The @@netgroupname syntax is supported in the user pattern only and it makes the local system hostname\n       to be passed to the netgroup match call in addition to the user name. This might not work correctly on some libc implementations causing the match to always fail.\n\n       The EXCEPT operator makes it possible to write very compact rules.\n\n       If the nodefgroup is not set, the group file is searched when a name does not match that of the logged-in user. Only groups are matched in which users are explicitly listed. However\n       the PAM module does not look at the primary group id of a user.\n\n       The \"#\" character at start of line (no space at front) can be used to mark this line as a comment line.\n\nEXAMPLES\n       These are some example lines which might be specified in /etc/security/access.conf.\n\n       User root should be allowed to get access via cron, X11 terminal :0, tty1, ..., tty5, tty6.\n\n       +:root:crond :0 tty1 tty2 tty3 tty4 tty5 tty6\n\n       User root should be allowed to get access from hosts which own the IPv4 addresses. This does not mean that the connection have to be a IPv4 one, a IPv6 connection from a host with one\n       of this IPv4 addresses does work, too.\n\n       +:root:192.168.200.1 192.168.200.4 192.168.200.9\n\n       +:root:127.0.0.1\n\n       User root should get access from network 192.168.201.  where the term will be evaluated by string matching. But it might be better to use network/netmask instead. The same meaning of\n       192.168.201.  is 192.168.201.0/24 or 192.168.201.0/255.255.255.0.\n\n       +:root:192.168.201.\n\n       User root should be able to have access from hosts foo1.bar.org and foo2.bar.org (uses string matching also).\n\n       +:root:foo1.bar.org foo2.bar.org\n\n       User root should be able to have access from domain foo.bar.org (uses string matching also).\n\n       +:root:.foo.bar.org\n\n       User root should be denied to get access from all other sources.\n\n       -:root:ALL\n\n       A user with uid 1003 and a group with gid 1000 should be allowed to get access from all other sources.\n\n       +:(1000) 1003:ALL\n\n       User foo and members of netgroup admins should be allowed to get access from all sources. This will only work if netgroup service is available.\n\n       +:@admins foo:ALL\n\n       User john and foo should get access from IPv6 host address.\n\n       +:john foo:2001:db8:0:101::1\n\n       User john and foo should get access from IPv6 link local host address.\n\n       +:john foo:fe80::de95:818c:1b55:7e42%eth1\n\n       User john should get access from IPv6 net/mask.\n\n       +:john:2001:db8:0:101::/64\n\n       Members of group wheel should be allowed to get access from all sources.\n\n       +:(wheel):ALL\n\n       Disallow console logins to all but the shutdown, sync and all other accounts, which are a member of the wheel group.\n\n       -:ALL EXCEPT (wheel) shutdown sync:LOCAL\n\n       All other users should be denied to get access from all sources.\n\n       -:ALL:ALL\n\nNOTES\n       The default separators of list items in a field are space, ',', and tabulator characters. Thus conveniently if spaces are put at the beginning and the end of the fields they are\n       ignored. However if the list separator is changed with the listsep option, the spaces will become part of the actual item and the line will be most probably ignored. For this reason,\n       it is not recommended to put spaces around the ':' characters.\n\n       An IPv6 link local host address must contain the interface identifier. IPv6 link local network/netmask is not supported.\n\n       Hostnames should be written as Fully-Qualified Host Name (FQHN) to avoid confusion with device names or PAM service names.\n\nSEE ALSO\n       pam_access(8), pam.d(5), pam(7)\n\nAUTHORS\n       Original login.access(5) manual was provided by Guido van Rooij which was renamed to access.conf(5) to reflect relation to default config file.\n\n       Network address / netmask description and example text was introduced by Mike Becher  .\n\n[FIXME: source]                                                                           06/29/2025                                                                            ACCESS.CONF(5)","ref":"access-conf.html"},{"type":"extras","title":"acct","doc":"acct(2)                                                                               System Calls Manual                                                                              acct(2)\n\nNAME\n       acct - switch process accounting on or off\n\nLIBRARY\n       Standard C library (libc, -lc)\n\nSYNOPSIS\n       #include  \n\n       int acct(const char *_Nullable filename);\n\n   Feature Test Macro Requirements for glibc (see feature_test_macros(7)):\n\n       acct():\n           Since glibc 2.21:\n               _DEFAULT_SOURCE\n           In glibc 2.19 and 2.20:\n               _DEFAULT_SOURCE || (_XOPEN_SOURCE && _XOPEN_SOURCE < 500)\n           Up to and including glibc 2.19:\n               _BSD_SOURCE || (_XOPEN_SOURCE && _XOPEN_SOURCE < 500)\n\nDESCRIPTION\n       The  acct() system call enables or disables process accounting.  If called with the name of an existing file as its argument, accounting is turned on, and records for each terminating\n       process are appended to filename as it terminates.  An argument of NULL causes accounting to be turned off.\n\nRETURN VALUE\n       On success, zero is returned.  On error, -1 is returned, and errno is set to indicate the error.\n\nERRORS\n       EACCES Write permission is denied for the specified file, or search permission is denied for one of the directories in the path prefix of filename (see  also  path_resolution(7)),  or\n              filename is not a regular file.\n\n       EFAULT filename points outside your accessible address space.\n\n       EIO    Error writing to the file filename.\n\n       EISDIR filename is a directory.\n\n       ELOOP  Too many symbolic links were encountered in resolving filename.\n\n       ENAMETOOLONG\n              filename was too long.\n\n       ENFILE The system-wide limit on the total number of open files has been reached.\n\n       ENOENT The specified file does not exist.\n\n       ENOMEM Out of memory.\n\n       ENOSYS BSD  process  accounting  has  not  been  enabled  when  the  operating  system  kernel  was  compiled.   The  kernel  configuration  parameter controlling this feature is CON‐\n              FIG_BSD_PROCESS_ACCT.\n\n       ENOTDIR\n              A component used as a directory in filename is not in fact a directory.\n\n       EPERM  The calling process has insufficient privilege to enable process accounting.  On Linux, the CAP_SYS_PACCT capability is required.\n\n       EROFS  filename refers to a file on a read-only filesystem.\n\n       EUSERS There are no more free file structures or we ran out of memory.\n\nSTANDARDS\n       None.\n\nHISTORY\n       SVr4, 4.3BSD.\n\nNOTES\n       No accounting is produced for programs running when a system crash occurs.  In particular, nonterminating processes are never accounted for.\n\n       The structure of the records written to the accounting file is described in acct(5).\n\nSEE ALSO\n       acct(5)\n\nLinux man-pages 6.9.1                                                                     2024-05-02                                                                                   acct(2)","ref":"acct.html"},{"type":"extras","title":"acl","doc":"ACL(5)                                                                                File Formats Manual                                                                               ACL(5)\n\nNAME\n       acl — Access Control Lists\n\nDESCRIPTION\n       This manual page describes POSIX Access Control Lists, which are used to define more fine-grained discretionary access rights for files and directories.\n\nACL TYPES\n       Every  object  can be thought of as having associated with it an ACL that governs the discretionary access to that object; this ACL is referred to as an access ACL. In addition, a di‐\n       rectory may have an associated ACL that governs the initial access ACL for objects created within that directory; this ACL is referred to as a default ACL.\n\nACL ENTRIES\n       An ACL consists of a set of ACL entries. An ACL entry specifies the access permissions on the associated object for an individual user or a group of users as a  combination  of  read,\n       write and search/execute permissions.\n\n       An ACL entry contains an entry tag type, an optional entry tag qualifier, and a set of permissions.  We use the term qualifier to denote the entry tag qualifier of an ACL entry.\n\n       The  qualifier  denotes the identifier of a user or a group, for entries with tag types of ACL_USER or ACL_GROUP, respectively. Entries with tag types other than ACL_USER or ACL_GROUP\n       have no defined qualifiers.\n\n       The following entry tag types are defined:\n\n             ACL_USER_OBJ    The ACL_USER_OBJ entry denotes access rights for the file owner.\n\n             ACL_USER        ACL_USER entries denote access rights for users identified by the entry's qualifier.\n\n             ACL_GROUP_OBJ   The ACL_GROUP_OBJ entry denotes access rights for the file group.\n\n             ACL_GROUP       ACL_GROUP entries denote access rights for groups identified by the entry's qualifier.\n\n             ACL_MASK        The ACL_MASK entry denotes the maximum access rights that can be granted by entries of type ACL_USER, ACL_GROUP_OBJ, or ACL_GROUP.\n\n             ACL_OTHER       The ACL_OTHER entry denotes access rights for processes that do not match any other entry in the ACL.\n\n       When an access check is performed, the ACL_USER_OBJ and ACL_USER entries are tested against the effective user ID. The effective group ID, as well as all supplementary group  IDs  are\n       tested against the ACL_GROUP_OBJ and ACL_GROUP entries.\n\nVALID ACLs\n       A  valid  ACL  contains  exactly one entry with each of the ACL_USER_OBJ, ACL_GROUP_OBJ, and ACL_OTHER tag types. Entries with ACL_USER and ACL_GROUP tag types may appear zero or more\n       times in an ACL. An ACL that contains entries of ACL_USER or ACL_GROUP tag types must contain exactly one entry of the ACL_MASK tag type. If an ACL contains no entries of ACL_USER  or\n       ACL_GROUP tag types, the ACL_MASK entry is optional.\n\n       All user ID qualifiers must be unique among all entries of ACL_USER tag type, and all group IDs must be unique among all entries of ACL_GROUP tag type.\n\n         The  acl_get_file()  function returns an ACL with zero ACL entries as the default ACL of a directory, if the directory is not associated with a default ACL. The acl_set_file() func‐\n       tion also accepts an ACL with zero ACL entries as a valid default ACL for directories, denoting that the directory shall not be associated with a default ACL. This  is  equivalent  to\n       using the acl_delete_def_file() function.\n\nCORRESPONDENCE BETWEEN ACL ENTRIES AND FILE PERMISSION BITS\n       The permissions defined by ACLs are a superset of the permissions specified by the file permission bits.\n\n       There is a correspondence between the file owner, group, and other permissions and specific ACL entries: the owner permissions correspond to the permissions of the ACL_USER_OBJ entry.\n       If the ACL has an ACL_MASK entry, the group permissions correspond to the permissions of the ACL_MASK entry.  Otherwise, if the ACL has no ACL_MASK entry, the group permissions corre‐\n       spond to the permissions of the ACL_GROUP_OBJ entry.  The other permissions correspond to the permissions of the ACL_OTHER entry.\n\n       The  file  owner, group, and other permissions always match the permissions of the corresponding ACL entry. Modification of the file permission bits results in the modification of the\n       associated ACL entries, and modification of these ACL entries results in the modification of the file permission bits.\n\nOBJECT CREATION AND DEFAULT ACLs\n       The access ACL of a file object is initialized when the object is created with any of the creat(), mkdir(), mknod(), mkfifo(), or open() functions. If a default ACL is associated with\n       a directory, the mode parameter to the functions creating file objects and the default ACL of the directory are used to determine the ACL of the new object:\n\n       1.   The new object inherits the default ACL of the containing directory as its access ACL.\n\n       2.   The access ACL entries corresponding to the file permission bits are modified so that they contain no permissions that are not contained in the permissions specified by the  mode\n            parameter.\n\n       If  no default ACL is associated with a directory, the mode parameter to the functions creating file objects and the file creation mask (see umask(2)) are used to determine the ACL of\n       the new object:\n\n       1.   The new object is assigned an access ACL containing entries of tag types ACL_USER_OBJ, ACL_GROUP_OBJ, and ACL_OTHER. The permissions of these entries are set to  the  permissions\n            specified by the file creation mask.\n\n       2.   The  access ACL entries corresponding to the file permission bits are modified so that they contain no permissions that are not contained in the permissions specified by the mode\n            parameter.\n\nACCESS CHECK ALGORITHM\n       A process may request read, write, or execute/search access to a file object protected by an ACL. The access check algorithm determines whether access to the object will be granted.\n\n       1.   If the effective user ID of the process matches the user ID of the file object owner, then\n\n                  if the ACL_USER_OBJ entry contains the requested permissions, access is granted,\n\n                  else access is denied.\n\n       2.   else if the effective user ID of the process matches the qualifier of any entry of type ACL_USER, then\n\n                  if the matching ACL_USER entry and the ACL_MASK entry contain the requested permissions, access is granted,\n\n                  else access is denied.\n\n       3.   else if the effective group ID or any of the supplementary group IDs of the process match the file group or the qualifier of any entry of type ACL_GROUP, then\n\n                  if the ACL contains an ACL_MASK entry, then\n\n                        if the ACL_MASK entry and any of the matching ACL_GROUP_OBJ or ACL_GROUP entries contain the requested permissions, access is granted,\n\n                        else access is denied.\n\n                  else (note that there can be no ACL_GROUP entries without an ACL_MASK entry)\n\n                        if the ACL_GROUP_OBJ entry contains the requested permissions, access is granted,\n\n                        else access is denied.\n\n       4.   else if the ACL_OTHER entry contains the requested permissions, access is granted.\n\n       5.   else access is denied.\n\nACL TEXT FORMS\n       A long and a short text form for representing ACLs is defined. In both forms, ACL entries are represented as three colon separated fields: an ACL entry tag type, an ACL  entry  quali‐\n       fier, and the discretionary access permissions. The first field contains one of the following entry tag type keywords:\n\n             user    A user ACL entry specifies the access granted to either the file owner (entry tag type ACL_USER_OBJ) or a specified user (entry tag type ACL_USER).\n\n             group   A group ACL entry specifies the access granted to either the file group (entry tag type ACL_GROUP_OBJ) or a specified group (entry tag type ACL_GROUP).\n\n             mask    A  mask  ACL  entry  specifies  the  maximum  access  which  can be granted by any ACL entry except the user entry for the file owner and the other entry (entry tag type\n                     ACL_MASK).\n\n             other   An other ACL entry specifies the access granted to any process that does not match any user or group ACL entries (entry tag type ACL_OTHER).\n\n       The second field contains the user or group identifier of the user or group associated with the ACL entry for entries of entry tag type ACL_USER or ACL_GROUP, and  is  empty  for  all\n       other entries. A user identifier can be a user name or a user ID number in decimal form. A group identifier can be a group name or a group ID number in decimal form.\n\n       The  third  field  contains  the discretionary access permissions. The read, write and search/execute permissions are represented by the r, w, and x characters, in this order. Each of\n       these characters is replaced by the - character to denote that a permission is absent in the ACL entry.  When converting from the text form to the internal representation, permissions\n       that are absent need not be specified.\n\n       White space is permitted at the beginning and end of each ACL entry, and immediately before and after a field separator (the colon character).\n\n   LONG TEXT FORM\n       The long text form contains one ACL entry per line. In addition, a number sign (#) may start a comment that extends until the end  of  the  line.  If  an  ACL_USER,  ACL_GROUP_OBJ  or\n       ACL_GROUP  ACL  entry contains permissions that are not also contained in the ACL_MASK entry, the entry is followed by a number sign, the string “effective:”, and the effective access\n       permissions defined by that entry. This is an example of the long text form:\n\n             user::rw-\n             user:lisa:rw-         #effective:r--\n             group::r--\n             group:toolies:rw-     #effective:r--\n             mask::r--\n             other::r--\n\n   SHORT TEXT FORM\n       The short text form is a sequence of ACL entries separated by commas, and is used for input. Comments are not supported. Entry tag type keywords may either appear in their full  unab‐\n       breviated  form,  or in their single letter abbreviated form. The abbreviation for user is u, the abbreviation for group is g, the abbreviation for mask is m, and the abbreviation for\n       other is o.  The permissions may contain at most one each of the following characters in any order: r, w, x.  These are examples of the short text form:\n\n             u::rw-,u:lisa:rw-,g::r--,g:toolies:rw-,m::r--,o::r--\n             g:toolies:rw,u:lisa:rw,u::wr,g::r,o::r,m::r\n\nRATIONALE\n       IEEE 1003.1e draft 17 defines Access Control Lists that include entries of tag type ACL_MASK, and defines a mapping between file permission bits that is  not  constant.  The  standard\n       working group defined this relatively complex interface in order to ensure that applications that are compliant with IEEE 1003.1 (“POSIX.1”) will still function as expected on systems\n       with ACLs. The IEEE 1003.1e draft 17 contains the rationale for choosing this interface in section B.23.\n\nCHANGES TO THE FILE UTILITIES\n       On a system that supports ACLs, the file utilities ls(1), cp(1), and mv(1) change their behavior in the following way:\n\n       •   For  files  that  have  a default ACL or an access ACL that contains more than the three required ACL entries, the ls(1) utility in the long form produced by ls -l displays a plus\n           sign (+) after the permission string.\n\n       •   If the -p flag is specified, the cp(1) utility also preserves ACLs.  If this is not possible, a warning is produced.\n\n       •     The mv(1) utility always preserves ACLs. If this is not possible, a warning is produced.\n\n       The effect of the chmod(1) utility, and of the chmod(2) system call, on the access ACL is described in “CORRESPONDENCE BETWEEN ACL ENTRIES AND FILE PERMISSION BITS”.\n\nSTANDARDS\n       The IEEE 1003.1e draft 17 (“POSIX.1e”) document describes several security extensions to the IEEE 1003.1 standard. While the work on 1003.1e has been abandoned, many UNIX  style  sys‐\n       tems implement parts of POSIX.1e draft 17, or of earlier drafts.\n\n       Linux Access Control Lists implement the full set of functions and utilities defined for Access Control Lists in POSIX.1e, and several extensions.  The implementation is fully compli‐\n       ant  with  POSIX.1e draft 17; extensions are marked as such.  The Access Control List manipulation functions are defined in the ACL library (libacl, -lacl). The POSIX compliant inter‐\n       faces are declared in the   header.  Linux-specific extensions to these functions are declared in the   header.\n\nNOTES\n   DENIED PERMISSIONS AND LINUX USER NAMESPACES\n       While ACLs can be used to deny processes permissions based on the groups they are in, this is considered bad practice.  Privileged helpers such as newuidmap(1) can  give  unprivileged\n       processes  access  to the setgroups(2) system call, which allows them to drop supplementary group membership and render restrictions based on that membership ineffective.  For further\n       details, see user_namespaces(7).\n\nSEE ALSO\n       chmod(1), creat(2), getfacl(1), ls(1), mkdir(2), mkfifo(2), mknod(2), mount(8), open(2), setfacl(1), stat(2), umask(1)\n\n   POSIX 1003.1e DRAFT 17\n       https://wt.tuxomania.net/publications/posix.1e/download.html\n\n   POSIX 1003.1e FUNCTIONS BY CATEGORY\n       ACL storage management\n            acl_dup(3), acl_free(3), acl_init(3)\n\n       ACL entry manipulation\n            acl_copy_entry(3), acl_create_entry(3), acl_delete_entry(3), acl_get_entry(3), acl_valid(3)\n\n            acl_add_perm(3), acl_calc_mask(3), acl_clear_perms(3), acl_delete_perm(3), acl_get_permset(3), acl_set_permset(3)\n\n            acl_get_qualifier(3), acl_get_tag_type(3), acl_set_qualifier(3), acl_set_tag_type(3)\n\n       ACL manipulation on an object\n            acl_delete_def_file(3), acl_get_fd(3), acl_get_file(3), acl_set_fd(3), acl_set_file(3)\n\n       ACL format translation\n            acl_copy_entry(3), acl_copy_ext(3), acl_from_text(3), acl_to_text(3), acl_size(3)\n\n   POSIX 1003.1e FUNCTIONS BY AVAILABILITY\n       The first group of functions is supported on most systems with POSIX-like access control lists, while the second group is supported on fewer systems.  For applications  that  will  be\n       ported the second group is best avoided.\n\n       acl_delete_def_file(3), acl_dup(3), acl_free(3), acl_from_text(3), acl_get_fd(3), acl_get_file(3), acl_init(3), acl_set_fd(3), acl_set_file(3), acl_to_text(3), acl_valid(3)\n\n       acl_add_perm(3),   acl_calc_mask(3),   acl_clear_perms(3),   acl_copy_entry(3),   acl_copy_ext(3),   acl_copy_int(3),   acl_create_entry(3),  acl_delete_entry(3),  acl_delete_perm(3),\n       acl_get_entry(3), acl_get_permset(3), acl_get_qualifier(3), acl_get_tag_type(3), acl_set_permset(3), acl_set_qualifier(3), acl_set_tag_type(3), acl_size(3)\n\n   LINUX EXTENSIONS\n       These non-portable extensions are available on Linux systems.\n\n       acl_check(3), acl_cmp(3), acl_entries(3), acl_equiv_mode(3), acl_error(3), acl_extended_fd(3), acl_extended_file(3), acl_extended_file_nofollow(3), acl_from_mode(3),  acl_get_perm(3),\n       acl_to_any_text(3)\n\nAUTHOR\n       Andreas Gruenbacher,  \n\nLinux ACL                                                                               March 23, 2002                                                                                  ACL(5)","ref":"acl.html"},{"type":"extras","title":"adduser.conf","doc":"ADDUSER.CONF(5)                                                                       File Formats Manual                                                                      ADDUSER.CONF(5)\n\nNAME\n       /etc/adduser.conf - configuration file for adduser(8) and addgroup(8)\n\nDESCRIPTION\n       The  file  /etc/adduser.conf  contains  defaults for the programs adduser(8), addgroup(8), deluser(8) and delgroup(8).  Each line holds a single value pair in the form option = value.\n       Double or single quotes are allowed around the value, as is whitespace around the equals sign.  Comment lines must have a hash sign (#) in the first column.\n\n       The valid configuration options are:\n\n       STDERRMSGLEVEL ,  STDOUTMSGLEVEL , and  LOGMSGLEVEL\n              Minimum priority for messages logged to syslog/journal and the console, respectively. See LOGGING in adduser(8).  Defaults to warn for  STDOUTMSGLEVEL  and  STDERRMSGLEVEL  and\n              info for LOGMSGLEVEL.\n\n       ADD_EXTRA_GROUPS\n              Setting this to something other than 0 will cause adduser to add newly created non-system users to the list of groups defined by EXTRA_GROUPS (below).  Defaults to 0.\n\n       DIR_MODE\n              The  permissions  mode for home directories of non-system users that are created by adduser(8).  Defaults to 0700.  Note that there are potential configurations (such as ~/user\n              web services, or in-home mail delivery) which will require changes to the default.  See also SYS_DIR_MODE.\n\n       DHOME  The directory in which new home directories should be created.  Defaults to /home.\n\n       DSHELL The login shell to be used for all new users.  Defaults to /bin/bash.\n\n       EXTRA_GROUPS\n              This is the space-separated list of groups that new non-system users will be added to.  Defaults to users.\n\n       FIRST_SYSTEM_GID  and  LAST_SYSTEM_GID\n              specify an inclusive range of GIDs from which GIDs for system groups can be dynamically allocated.  Defaults to 100 - 999.\n\n       FIRST_GID  and  LAST_GID\n              specify an inclusive range of GIDs from which GIDs for non-system groups can be dynamically allocated.  Defaults to 1000 - 59999.\n\n       FIRST_SYSTEM_UID  and  LAST_SYSTEM_UID\n              specify an inclusive range of UIDs from which UIDs for system users can be dynamically allocated.  Defaults to 100 - 999.  Please note that system software, such as  the  users\n              allocated by the base-passwd package, may assume that UIDs less than 100 are unallocated.\n\n       FIRST_UID  and  LAST_UID\n              specify an inclusive range of UIDs from which UIDs for non-system users can be dynamically allocated.  Defaults to 1000 - 59999.\n\n       GID_POOL\n              See UID_POOL.\n\n       GROUPHOMES\n              If this is set to yes, the home directories will be created as /home/groupname/user.  Defaults to no. This option is deprecated and will be removed.\n\n       LAST_SYSTEM_GID\n       LAST_GID\n       LAST_SYSTEM_UID\n       LAST_UID\n              See the FIRST_ variants of the option.\n\n       LETTERHOMES\n              If this is set to yes, then the home directories created will have an extra directory inserted which is the first letter of the loginname.  For example: /home/u/user.  Defaults\n              to no. This option is deprecated and will be removed.\n\n       NAME_REGEX\n              Non-system  user-  and  groupnames  are checked against this regular expression.  If the name doesn't match this regexp, user and group creation in adduser(8) is refused unless\n              --allow-bad-names is set.  With --allow-bad-names set, weaker checks are performed.  Defaults to the most  conservative  ^[a-zA-Z][a-zA-Z0-9_-]*\\$?$.   See  SYS_NAME_REGEX  and\n              Valid names, below, for more information.\n\n       QUOTAUSER\n              If set to a nonempty value, new users will have quotas copied from that user using edquota -p QUOTAUSER newuser.  Defaults to the empty string.\n\n       RESERVE_UID_POOL  and  RESERVE_GID_POOL\n              Controls whether the UID and GID values that are listed in the pool files are truly reserved.  See UID AND GID POOLS in the NOTES section.  Defaults to yes.\n\n       SETGID_HOME\n              If  this  is  set  to yes, then home directories for users with their own group (USERGROUPS = yes) will have the set-group-ID bit set.  Note that this feature is deprecated and\n              will be removed in a future version of adduser(8).  Please use DIR_MODE instead.  Defaults to no.\n\n       SKEL   The directory from which skeletal user configuration files will be copied.  Defaults to /etc/skel.\n\n       SKEL_IGNORE_REGEX\n              When populating the newly created home directory of a non-system user, files in SKEL matching this regex are not copied.  Defaults to to (.(dpkg|ucf)-(old|new|dist)$), the reg‐\n              ular expression matching files left over from unmerged config files.\n\n       SYS_DIR_MODE\n              The permissions mode for home directories of system users that are created by adduser(8).  Defaults to 0755.  Note that changing the default permissions for  system  users  may\n              cause some packages to behave unreliably, if the program relies on the default setting.  See also DIR_MODE.\n\n       SYS_NAME_REGEX\n              System  user-  and  groupnames  are checked against this regular expression.  If the name doesn't match this regexp, system user and group creation in adduser is refused unless\n              --allow-bad-names is set.  With --allow-bad-names set, weaker checks are performed.  Defaults to the most conservative ^[a-zA-Z_][a-zA-Z0-9_-]*\\$?$.  See NAME_REGEX, above, and\n              Valid names, below, for more information.\n\n       UID_POOL  and  GID_POOL\n              specify a file or a directory containing UID and GID pool files.  See UID AND GID POOLS in the NOTES section.  Both default to empty.\n\n       USERGROUPS\n              Specify whether each created non-system user will be given their own group to use.  Defaults to yes.\n\n       USERS_GID  and  USERS_GROUP\n              Defines the groupname or GID of the group all newly-created non-system users are placed into.  If USERGROUPS is yes, the group will be added as a supplementary group; if  USER‐\n              GROUPS  is  no,,  it  will  be  the  primary group.  If you don't want all your users to be in one group, set USERGROUPS=yes, leave USERS_GROUP empty and set USERS_GID to \"-1\".\n              USERS_GROUP defaults to users, which has GID 100 on all Debian systems since it's defined statically by the base-passwd package.  It is a configuration  error  to  define  both\n              variables even if the values are consistent.\n\nNOTES\n   UID AND GID POOLS\n       Some  installations desire that a non-system account gets preconfigured properties when it is generated.  Commonly, the local admin wants to make sure that even without using a direc‐\n       tory service, an account or a group with a certain name has the same numeric UID/GID on all systems where it exists.\n\n       To enable this feature, define configuration variables UID_POOL (for user accounts) and/or GID_POOL (for groups) in /etc/adduser.conf and install the respective files in  the  config‐\n       ured places.  The value is either a file or a directory.  In the latter case all files named *.conf in that directory are considered.\n\n       The  file format is similar to /etc/passwd: Text lines, fields separated by a colon.  The values are username/groupname (mandatory), UID/GID (mandatory), comment field (optional, use‐\n       ful for user IDs only), home directory (ditto), shell (ditto).\n\n       It is possible to use the same file/directory for UID_POOL and GID_POOL.\n\n       If an account / group is created, adduser(8) searches in all UID/GID pool files for a line matching the name of the newly created account and uses the data found there  to  initialize\n       the new account instead of using the defaults.  Settings may be overridden from the command line.\n\n       In  the  default  configuration, UID and GID values listed in the pool will be reserved and thus not be used by the normal UID and GID selection processes.  This is usually what you'd\n       want.  With the RESERVE_UID_POOL and RESERVE_GID_POOL configuration options, you can switch this behavior off if you want pooled UIDs and GIDs used by regular  accounts.   This  might\n       cause conflicts and cause your pool UIDs and GIDs to be used by accounts that are not in the pool.\n\nFILES\n       /etc/adduser.conf\n\nSEE ALSO\n       deluser.conf(5), addgroup(8), adduser(8), delgroup(8), deluser(8)\n\nDebian GNU/Linux                                                                                                                                                               ADDUSER.CONF(5)","ref":"adduser-conf.html"},{"type":"extras","title":"adjtime_config","doc":"ADJTIME_CONFIG(5)                                                                        File formats                                                                        ADJTIME_CONFIG(5)\n\nNAME\n       adjtime_config - information about hardware clock setting and drift factor\n\nSYNOPSIS\n       /etc/adjtime\n\nDESCRIPTION\n       The file /etc/adjtime contains descriptive information about the hardware mode clock setting and clock drift factor. The file is read and write by hwclock(8); and read by programs\n       like rtcwake to get RTC time mode.\n\n       The file is usually located in /etc, but tools like hwclock(8) or rtcwake(8) can use alternative location by command line options if write access to /etc is unwanted. The default\n       clock mode is \"UTC\" if the file is missing.\n\n       The Hardware Clock is usually not very accurate. However, much of its inaccuracy is completely predictable - it gains or loses the same amount of time every day. This is called\n       systematic drift. The util hwclock(8) keeps the file /etc/adjtime, that keeps some historical information. For more details see \"The Adjust Function\" and \"The Adjtime File\" sections\n       from hwclock(8) man page.\n\n       The adjtime file is formatted in ASCII.\n\n   First line\n       Three numbers, separated by blanks:\n\n       drift factor\n           the systematic drift rate in seconds per day (floating point decimal)\n\n       last adjust time\n           the resulting number of seconds since 1969 UTC of most recent adjustment or calibration (decimal integer)\n\n       adjustment status\n           zero (for compatibility with clock(8)) as a floating point decimal\n\n   Second line\n       last calibration time\n           The resulting number of seconds since 1969 UTC of most recent calibration. Zero if there has been no calibration yet or it is known that any previous calibration is moot (for\n           example, because the Hardware Clock has been found, since that calibration, not to contain a valid time). This is a decimal integer.\n\n   Third line\n       clock mode\n           Supported values are UTC or LOCAL. Tells whether the Hardware Clock is set to Coordinated Universal Time or local time. You can always override this value with options on the\n           hwclock(8) command line.\n\nFILES\n       /etc/adjtime\n\nSEE ALSO\n       hwclock(8), rtcwake(8)\n\nREPORTING BUGS\n       For bug reports, use the issue tracker  .\n\nAVAILABILITY\n       adjtime_config is part of the util-linux package which can be downloaded from Linux Kernel Archive  .\n\nutil-linux 2.41                                                                           2025-02-26                                                                         ADJTIME_CONFIG(5)","ref":"adjtime_config.html"},{"type":"extras","title":"american-english","doc":"american-english(5)                                                                      Users' Manual                                                                     american-english(5)\n\nNAME\n       american-english - a list of English words\n\nDESCRIPTION\n       /usr/share/dict/american-english is an ASCII file which contains an alphabetic list of words, one per line.\n\nFILES\n       There  may  be  any  number  of  word  lists  in  /usr/share/dict/.   /etc/dictionaries-common/words  is  a  symbolic  link  to  the  currently-chosen /usr/share/dict/  file.\n       /usr/share/dict/words is a symbolic link to /etc/dictionaries-common/words, and is the name by which other software  should  refer  to  the  system  word  list.   See  select-default-\n       wordlist(8) for more information, and/or to change the currently-chosen word list.\n\n       The  directory /usr/share/dict can contain word lists for many languages, with name of the language in English, e.g., /usr/share/dict/french and /usr/share/dict/danish contain respec‐\n       tively lists of French and Danish words if they exist.  Such lists should be coded using the ISO 8859-1 character set encoding.\n\nSEE ALSO\n       ispell(1), select-default-wordlist(8), and the Filesystem Hierarchy Standard.\n\nHISTORY\n       The words lists are not specific, and may be generated from any number of sources.\n\n       The system word list used to be /usr/dict/words.  For compatibility, software should check that location if /usr/share/dict/words does not exist.\n\nAUTHOR\n       Word lists are collected and maintained by various authors.  The Debian English word lists are built from the SCOWL (Spell- Checker Oriented Word Lists) package, whose upstream editor\n       is Kevin Atkinson  .\n\nDebian                                                                                   16 June 2003                                                                      american-english(5)","ref":"american-english.html"},{"type":"extras","title":"apparmor.d","doc":"APPARMOR.D(5)                                                                              AppArmor                                                                              APPARMOR.D(5)\n\nNAME\n       apparmor.d - syntax of security profiles for AppArmor.\n\nDESCRIPTION\n       AppArmor profiles describe mandatory access rights granted to given programs and are fed to the AppArmor policy enforcement module using apparmor_parser(8). This man page describes\n       the format of the AppArmor configuration files; see apparmor(7) for an overview of AppArmor.\n\n       Some features are not supported on Debian yet:\n\n       Network Rules\n       DBus rules\n       Unix socket rules\n\nFORMAT\n       AppArmor  policy  is  written  in  a  declarative  language, in which the order of rules within a given section or block does not matter. Policy is by convention written so that it is\n       contained in multiple files, but this is not a requirement. It could just as easily be written in a single file. The policy language is compiled to a architecture  independent  binary\n       format that is loaded into the kernel for enforcement.\n\n       The base unit of AppArmor confinement is the profile. It contains a set of rules which are enforced when the profile is associated with a running program. The rules within the profile\n       provide a whitelist of different permission that are allowed, along with a few other special rules.\n\n       The  text  in AppArmor policy is split into two sections, the preamble and the profile definitions. The preamble must occur at the head of the file and once profile definitions begin,\n       no more preamble rules are allowed (even in files that are included into the profile). When AppArmor policy (set of profiles) is split across multiple files, each file  can  have  its\n       own preamble section, which may be the same or different from other files preamble. Files included within a profile section can not have a preamble section.\n\n       The  following  is  a  BNF-style  description of AppArmor policy configuration files; see below for an example AppArmor policy file.  AppArmor configuration files are line-oriented; #\n       introduces a comment, similar to shell scripting languages. The exception to this rule is that #include will include the contents of a file inline to the  policy;  this  behaviour  is\n       modelled after cpp(1).\n\n           PROFILE FILE = ( [ PREAMBLE ] [ PROFILE ] )*\n\n           PREAMBLE = ( COMMENT | VARIABLE ASSIGNMENT | ALIAS RULE | INCLUDE | ABI )*\n             Variable assignment and alias rules must come before the profile.\n\n           VARIABLE ASSIGNMENT = VARIABLE ('=' | '+=') (space separated values)\n\n           VARIABLE = '@{' ALPHA [ ( ALPHANUMERIC | '_' ) ... ] '}'\n\n           ALIAS RULE = 'alias' ABS PATH '->' REWRITTEN ABS PATH ','\n\n           INCLUDE = ( '#include' | 'include' ) [ 'if exists' ] ( ABS PATH | MAGIC PATH )\n\n           ABI = ( 'abi' ) ( ABS PATH | MAGIC PATH ) ','\n\n           ABS PATH = '\"' path '\"' (the path is passed to open(2))\n\n           MAGIC PATH = '<' relative path '>'\n             The path is relative to /etc/apparmor.d/.\n\n           COMMENT = '#' TEXT [ '\\r' ] '\\n'\n\n           TEXT = any characters\n\n           PROFILE = ( PROFILE HEAD ) [ ATTACHMENT SPECIFICATION ] [ PROFILE FLAG CONDS ] '{' ( RULES )* '}'\n\n           PROFILE HEAD = [ 'profile' ] FILEGLOB | 'profile' PROFILE NAME\n\n           PROFILE NAME ( UNQUOTED PROFILE NAME | QUOTED PROFILE NAME )\n\n           QUOTED PROFILE NAME = '\"' UNQUOTED PROFILE NAME '\"'\n\n           UNQUOTED PROFILE NAME = (must start with alphanumeric character (after variable expansion), or '/' AARE have special meanings; see below. May include VARIABLE. Rules with embedded\n           spaces or tabs must be quoted.)\n\n           ATTACHMENT SPECIFICATION = [ PROFILE_EXEC_COND ] [ PROFILE XATTR CONDS ]\n\n           PROFILE_EXEC_COND = FILEGLOB\n\n           PROFILE XATTR CONDS =  [ 'xattrs=' ] '(' comma or white space separated list of PROFILE XATTR ')'\n\n           PROFILE XATTR = extended attribute name '=' XATTR VALUE FILEGLOB\n\n           XATTR VALUE FILEGLOB = FILEGLOB\n\n           PROFILE FLAG CONDS =  [ 'flags=' ] '(' comma or white space separated list of PROFILE FLAGS ')'\n\n           PROFILE  FLAGS  =  PROFILE  MODE  |  AUDIT_MODE | 'mediate_deleted' | 'attach_disconnected' | 'attach_disconnected.path='ABS PATH | 'chroot_relative' | 'debug' | 'interruptible' |\n           'kill.signal='SIGNAL | 'error='ERROR CODE\n\n           ERROR CODE = (case insensitive error code name starting with 'E'; see errno(3))\n\n           PROFILE MODE = 'enforce' | 'complain' | 'kill' | 'default_allow' | 'unconfined' | 'prompt'\n\n           AUDIT MODE = 'audit'\n\n           RULES = [ ( LINE RULES | COMMA RULES ',' | BLOCK RULES )\n\n           LINE RULES = ( COMMENT | INCLUDE ) [ '\\r' ] '\\n'\n\n           COMMA RULES = ( CAPABILITY RULE | NETWORK RULE | MOUNT RULE | PIVOT ROOT RULE | UNIX RULE | FILE RULE | LINK RULE | CHANGE_PROFILE RULE | RLIMIT RULE | DBUS RULE | MQUEUE  RULE  |\n           IO_URING RULE | USERNS RULE | ALL RULE)\n\n           BLOCK RULES = ( SUBPROFILE | HAT | QUALIFIER BLOCK )\n\n           SUBPROFILE = 'profile' PROFILE NAME [ ATTACHMENT SPECIFICATION ] [ PROFILE FLAG CONDS ] '{' ( RULES )* '}'\n\n           HAT = ('hat' | '^') HATNAME [ PROFILE FLAG CONDS ] '{' ( RULES )* '}'\n\n           HATNAME  =  (must start with alphanumeric character. See aa_change_hat(2) for a description of how this \"hat\" is used. If '^' is used to start a hat then there is no space between\n           the '^' and HATNAME)\n\n           QUALIFIER BLOCK = QUALIFIERS BLOCK\n\n           INTEGER = (+ | -)? [[:digit:]]+\n\n           ACCESS TYPE = ( 'allow' | 'deny' )\n\n           QUALIFIERS = [ 'priority' '='   ] [ 'audit' ] [ ACCESS TYPE ]\n\n           CAPABILITY RULE = [ QUALIFIERS ] 'capability' [ CAPABILITY LIST ]\n\n           CAPABILITY LIST = ( CAPABILITY )+\n\n           CAPABILITY = (lowercase capability name without 'CAP_' prefix; see capabilities(7))\n\n           NETWORK RULE = [ QUALIFIERS ] 'network' [ NETWORK ACCESS EXPR ] [ DOMAIN ] [ TYPE | PROTOCOL ] [ NETWORK LOCAL EXPR ] [ NETWORK PEER EXPR ]\n\n           NETWORK ACCESS EXPR = ( NETWORK ACCESS | NETWORK ACCESS LIST )\n\n           NETWORK ACCESS = ( 'create' | 'bind' | 'listen' | 'accept' | 'connect' | 'shutdown' | 'getattr' | 'setattr' | 'getopt' | 'setopt' | 'send' | 'receive' | 'r' | 'w' | 'rw' )\n             Some access modes are incompatible with some rules.\n\n           NETWORK ACCESS LIST = '(' NETWORK ACCESS ( [','] NETWORK ACCESS )* ')'\n\n           DOMAIN = ( 'unix' | 'inet' | 'ax25' | 'ipx' | 'appletalk' | 'netrom' | 'bridge' | 'atmpvc' | 'x25' | 'inet6' | 'rose' | 'netbeui' | 'security' | 'key' |  'netlink'  |  'packet'  |\n           'ash'  |  'econet'  |  'atmsvc'  |  'rds'  |  'sna'  | 'irda' | 'pppox' | 'wanpipe' | 'llc' | 'ib' | 'mpls' | 'can' | 'tipc' | 'bluetooth' | 'iucv' | 'rxrpc' | 'isdn' | 'phonet' |\n           'ieee802154' | 'caif' | 'alg' | 'nfc' | 'vsock' | 'kcm' | 'qipcrtr' | 'smc' | 'xdp' | 'mctp' ) ','\n\n           TYPE = ( 'stream' | 'dgram' | 'seqpacket' |  'rdm' | 'raw' | 'packet' )\n\n           PROTOCOL = ( 'tcp' | 'udp' | 'icmp' )\n\n           NETWORK LOCAL EXPR = ( NETWORK IP COND | NETWORK PORT COND )*\n             Each cond can appear at most once.\n\n           NETWORK PEER EXPR = 'peer' '=' '(' ( NETWORK IP COND | NETWORK PORT COND )+ ')'\n             Each cond can appear at most once.\n\n           NETWORK IP COND = 'ip' '=' ( 'none' | NETWORK IPV4 | NETWORK IPV6 )\n\n           NETWORK PORT COND = 'port' '=' ( NETWORK PORT | NETWORK PORT '-' NETWORK PORT )\n\n           NETWORK IPV4 = IPv4, represented by four 8-bit decimal numbers separated by '.'\n\n           NETWORK IPV6 = IPv6, represented by eight groups of four hexadecimal numbers separated by ':'. Shortened representation of contiguous zeros is allowed by using '::'\n\n           NETWORK PORT = 16-bit number ranging from 0 to 65535\n\n           MOUNT RULE = ( MOUNT | REMOUNT | UMOUNT )\n\n           MOUNT = [ QUALIFIERS ] 'mount' [ MOUNT CONDITIONS ] [ SOURCE FILEGLOB ] [ '->' [ MOUNTPOINT FILEGLOB ]\n\n           REMOUNT = [ QUALIFIERS ] 'remount' [ MOUNT CONDITIONS ] MOUNTPOINT FILEGLOB\n\n           UMOUNT = [ QUALIFIERS ] 'umount' [ MOUNT CONDITIONS ] MOUNTPOINT FILEGLOB\n\n           MOUNT CONDITIONS = [ ( 'fstype' | 'vfstype' ) ( '=' | 'in' ) MOUNT FSTYPE EXPRESSION ] [ 'options' ( '=' | 'in' ) MOUNT FLAGS EXPRESSION ]\n\n           MOUNT FSTYPE EXPRESSION = ( MOUNT FSTYPE LIST | MOUNT EXPRESSION )\n\n           MOUNT FSTYPE LIST = Comma separated list of valid filesystem and virtual filesystem types (eg ext4, debugfs, devfs, etc)\n\n           MOUNT FLAGS EXPRESSION = ( MOUNT FLAGS LIST | MOUNT EXPRESSION )\n\n           MOUNT FLAGS LIST = Comma separated list of MOUNT FLAGS.\n\n           MOUNT FLAGS = ( 'ro' | 'rw' | 'nosuid' | 'suid' | 'nodev' | 'dev' | 'noexec' | 'exec' | 'sync' | 'async' | 'remount' | 'mand' | 'nomand'  |  'dirsync'  |  'noatime'  |  'atime'  |\n           'nodiratime'  |  'diratime'  |  'bind'  |  'rbind'  |  'move' | 'verbose' | 'silent' | 'loud' | 'acl' | 'noacl' | 'unbindable' | 'runbindable' | 'private' | 'rprivate' | 'slave' |\n           'rslave' | 'shared' | 'rshared' | 'relatime' | 'norelatime' | 'iversion' | 'noiversion' | 'strictatime' | 'nostrictatime' |  'lazytime'  |  'nolazytime'  |  'nouser'  |  'user'  |\n           'symfollow' | 'nosymfollow' )\n\n           MOUNT EXPRESSION = ( ALPHANUMERIC | AARE ) ...\n\n           MQUEUE_RULE = [ QUALIFIERS ] 'mqueue' [ MQUEUE ACCESS PERMISSIONS ] [ MQUEUE TYPE ] [ MQUEUE LABEL ] [ MQUEUE NAME ]\n\n           MQUEUE ACCESS PERMISSIONS = MQUEUE ACCESS | MQUEUE ACCESS LIST\n\n           MQUEUE ACCESS LIST = '(' Comma or space separated list of MQUEUE ACCESS ')'\n\n           MQUEUE ACCESS = ( 'r' | 'w' | 'rw' | 'read' | 'write' | 'create' | 'open' | 'delete' | 'getattr' | 'setattr' )\n\n           MQUEUE TYPE = 'type' '=' ( 'posix' | 'sysv' )\n\n           MQUEUE LABEL = 'label' '=' '(' '\"' AARE '\"' | AARE ')'\n\n           MQUEUE NAME = AARE\n\n           USERNS RULE = [ QUALIFIERS ] 'userns' [ USERNS ACCESS PERMISSIONS ]\n\n           USERNS ACCESS PERMISSIONS = ( 'create' )\n\n           IO_URING RULE = [ QUALIFIERS ] 'io_uring' [ IO_URING ACCESS PERMISSIONS [ IO_URING LABEL ]\n\n           IO_URING ACCESS PERMISSIONS = ( 'sqpoll' | 'override_creds' )\n\n           IO_URING LABEL = 'label' '=' '(' '\"' AARE '\"' | AARE ')'\n\n           PIVOT ROOT RULE = [ QUALIFIERS ] pivot_root [ oldroot=OLD PUT FILEGLOB ] [ NEW ROOT FILEGLOB ] [ '->' PROFILE NAME ]\n\n           SOURCE FILEGLOB = FILEGLOB\n\n           MOUNTPOINT FILEGLOB = FILEGLOB\n\n           OLD PUT FILEGLOB = FILEGLOB\n\n           PTRACE_RULE = [ QUALIFIERS ] 'ptrace' [ PTRACE ACCESS PERMISSIONS ] [ PTRACE PEER ]\n\n           PTRACE ACCESS PERMISSIONS = PTRACE ACCESS | PTRACE ACCESS LIST\n\n           PTRACE ACCESS LIST = '(' Comma or space separated list of PTRACE ACCESS ')'\n\n           PTRACE ACCESS = ( 'r' | 'w' | 'rw' | 'read' | 'readby' | 'trace' | 'tracedby' )\n\n           PTRACE PEER = 'peer' '=' AARE\n\n           SIGNAL_RULE = [ QUALIFIERS ] 'signal' [ SIGNAL ACCESS PERMISSIONS ] [ SIGNAL SET ] [ SIGNAL PEER ]\n\n           SIGNAL ACCESS PERMISSIONS = SIGNAL ACCESS | SIGNAL ACCESS LIST\n\n           SIGNAL ACCESS LIST = '(' Comma or space separated list of SIGNAL ACCESS ')'\n\n           SIGNAL ACCESS = ( 'r' | 'w' | 'rw' | 'read' | 'write' | 'send' | 'receive' )\n\n           SIGNAL SET = 'set' '=' '(' SIGNAL LIST ')'\n\n           SIGNAL LIST = Comma or space separated list of SIGNALs\n\n           SIGNAL  = ( 'hup' | 'int' | 'quit' | 'ill' | 'trap' | 'abrt' | 'bus' | 'fpe' | 'kill' | 'usr1' | 'segv' | 'usr2' | 'pipe' | 'alrm' | 'term' | 'stkflt' | 'chld' | 'cont' | 'stop' |\n           'stp' | 'ttin' | 'ttou' | 'urg' | 'xcpu' | 'xfsz' | 'vtalrm' | 'prof' | 'winch' | 'io' | 'pwr' | 'sys' | 'emt' | 'exists' | 'rtmin+0' ... 'rtmin+32' )\n\n           SIGNAL PEER = 'peer' '=' AARE\n\n           DBUS RULE = ( DBUS MESSAGE RULE | DBUS SERVICE RULE | DBUS EAVESDROP RULE | DBUS COMBINED RULE )\n\n           DBUS MESSAGE RULE = [ QUALIFIERS ] 'dbus' [ DBUS ACCESS EXPRESSION ] [ DBUS BUS ] [ DBUS PATH ] [ DBUS INTERFACE ] [ DBUS MEMBER ] [ DBUS PEER ]\n\n           DBUS SERVICE RULE = [ QUALIFIERS ] 'dbus' [ DBUS ACCESS EXPRESSION ] [ DBUS BUS ] [ DBUS NAME ]\n\n           DBUS EAVESDROP RULE = [ QUALIFIERS ] 'dbus' [ DBUS ACCESS EXPRESSION ] [ DBUS BUS ]\n\n           DBUS COMBINED RULE = [ QUALIFIERS ] 'dbus' [ DBUS ACCESS EXPRESSION ] [ DBUS BUS ]\n\n           DBUS ACCESS EXPRESSION = ( DBUS ACCESS | '(' DBUS ACCESS LIST ')' )\n\n           DBUS BUS = 'bus' '=' '(' 'system' | 'session' | '\"' AARE '\"' | AARE ')'\n\n           DBUS PATH = 'path' '=' '(' '\"' AARE '\"' | AARE ')'\n\n           DBUS INTERFACE = 'interface' '=' '(' '\"' AARE '\"' | AARE ')'\n\n           DBUS MEMBER = 'member' '=' '(' '\"' AARE '\"' | AARE ')'\n\n           DBUS PEER = 'peer' '=' '(' [ DBUS NAME ] [ DBUS LABEL ] ')'\n\n           DBUS NAME = 'name' '=' '(' '\"' AARE '\"' | AARE ')'\n\n           DBUS LABEL = 'label' '=' '(' '\"' AARE '\"' | AARE ')'\n\n           DBUS ACCESS LIST = Comma separated list of DBUS ACCESS\n\n           DBUS ACCESS = ( 'send' | 'receive' | 'bind' | 'eavesdrop' | 'r' | 'read' | 'w' | 'write' | 'rw' )\n             Some accesses are incompatible with some rules; see below.\n\n           UNIX RULE = [ QUALIFIERS ] 'unix' [ UNIX ACCESS EXPR ] [ UNIX RULE CONDS ] [ UNIX LOCAL EXPR ] [ UNIX PEER EXPR ]\n\n           UNIX ACCESS EXPR = ( UNIX ACCESS | UNIX ACCESS LIST )\n\n           UNIX ACCESS = ( 'create' | 'bind' | 'listen' | 'accept' | 'connect' | 'shutdown' | 'getattr' | 'setattr' | 'getopt' | 'setopt' | 'send' | 'receive' | 'r' | 'w' | 'rw' )\n             Some access modes are incompatible with some rules or require additional parameters.\n\n           UNIX ACCESS LIST = '(' UNIX ACCESS ( [','] UNIX ACCESS )* ')'\n\n           UNIX RULE CONDS = ( TYPE COND | PROTO COND )\n             Each cond can appear at most once.\n\n           TYPE COND = 'type' '='  ( AARE | '(' ( '\"' AARE '\"' | AARE )+ ')' )\n\n           PROTO COND = 'protocol' '='  ( AARE | '(' ( '\"' AARE '\"' | AARE )+ ')' )\n\n           UNIX LOCAL EXPR = ( UNIX ADDRESS COND | UNIX LABEL COND | UNIX ATTR COND | UNIX OPT COND )*\n             Each cond can appear at most once.\n\n           UNIX PEER EXPR = 'peer' '=' ( UNIX ADDRESS COND | UNIX LABEL COND )+\n             Each cond can appear at most once.\n\n           UNIX ADDRESS COND 'addr' '=' ( AARE | '(' '\"' AARE '\"' | AARE ')' )\n\n           UNIX LABEL COND 'label' '=' ( AARE | '(' '\"' AARE '\"' | AARE ')' )\n\n           UNIX ATTR COND 'attr' '=' ( AARE | '(' '\"' AARE '\"' | AARE ')' )\n\n           UNIX OPT COND 'opt' '=' ( AARE | '(' '\"' AARE '\"' | AARE ')' )\n\n           RLIMIT RULE = 'set' 'rlimit' [RLIMIT '<=' RLIMIT VALUE ]\n\n           RLIMIT = ( 'cpu' | 'fsize' | 'data' | 'stack' | 'core' | 'rss' | 'nofile' | 'ofile' | 'as' | 'nproc' | 'memlock' | 'locks' | 'sigpending'  |  'msgqueue'  |  'nice'  |  'rtprio'  |\n           'rttime' )\n\n           RLIMIT VALUE = ( RLIMIT SIZE | RLIMIT NUMBER | RLIMIT TIME | RLIMIT NICE )\n\n           RLIMIT SIZE = NUMBER ( 'K' | 'M' | 'G' )\n             Only applies to RLIMIT of 'fsize', 'data', 'stack', 'core', 'rss', 'as', 'memlock', 'msgqueue'.\n\n           RLIMIT NUMBER = number from 0 to max rlimit value.\n             Only applies to RLIMIT of 'ofile', 'nofile', 'locks', 'sigpending', 'nproc', 'rtprio'.\n\n           RLIMIT  TIME  =  NUMBER ( 'us' | 'microsecond' | 'microseconds' | 'ms' | 'millisecond' | 'milliseconds' | 's' | 'sec' | 'second' | 'seconds' | 'min' | 'minute' | 'minutes' | 'h' |\n           'hour' | 'hours' | 'd' | 'day' | 'days' | 'week' | 'weeks' )\n             Only applies to RLIMIT of 'cpu' and 'rttime'. RLIMIT 'cpu' only allows units >= 'seconds'.\n\n           RLIMIT NICE = a number between -20 and 19.\n             Only applies to RLIMIT of 'nice'.\n\n           FILE RULE = [ QUALIFIERS ] [ 'owner' ] ( 'file' | [ 'file' ] ( FILEGLOB ACCESS  | ACCESS FILEGLOB ) [ '->' EXEC TARGET ] )\n\n           FILEGLOB = ( QUOTED FILEGLOB | UNQUOTED FILEGLOB )\n\n           QUOTED FILEGLOB = '\"' UNQUOTED FILEGLOB '\"'\n\n           UNQUOTED FILEGLOB = (must start with '/' (after variable expansion), AARE have special meanings; see below. May include VARIABLE. Rules  with  embedded  spaces  or  tabs  must  be\n           quoted. Rules must end with '/' to apply to directories.)\n\n           AARE = ?*[]{}^\n             See section \"Globbing (AARE)\" below for meanings.\n\n           ACCESS = ( 'r' | 'w' | 'a' | 'l' | 'k' | 'm' | EXEC TRANSITION )+  (not all combinations are allowed; see below.)\n\n           EXEC TRANSITION =  ( 'ix' | 'ux' | 'Ux' | 'px' | 'Px' | 'cx' | 'Cx' | 'pix' | 'Pix' | 'cix' | 'Cix' | 'pux' | 'PUx' | 'cux' | 'CUx' | 'x' )\n             A bare 'x' is only allowed in rules with the deny qualifier, everything else only without the deny qualifier.\n\n           EXEC TARGET = name\n             Requires EXEC TRANSITION specified.\n\n           LINK RULE = QUALIFIERS [ 'owner' ] 'link' [ 'subset' ] FILEGLOB '->' FILEGLOB\n\n           ALPHA = ('a', 'b', 'c', ... 'z', 'A', 'B', ... 'Z')\n\n           ALPHANUMERIC = ('0', '1', '2', ... '9', 'a', 'b', 'c', ... 'z', 'A', 'B', ... 'Z')\n\n           CHANGE_PROFILE RULE = 'change_profile' [ [ EXEC MODE ] EXEC COND ] [ '->' PROFILE NAME ]\n\n           EXEC_MODE = ( 'safe' | 'unsafe' )\n\n           EXEC COND = FILEGLOB\n\n           ALL RULE = 'all'\n\n       All  resources  and programs need a full path. There may be any number of subprofiles (aka child profiles) in a profile, limited only by kernel memory. Subprofile names are limited to\n       974 characters.  Child profiles can be used to confine an application in a special way, or when you want the child to be unconfined on the system, but confined when  called  from  the\n       parent.   Hats  are  a  special  child  profile  that  can  be used with the aa_change_hat(2) API call.  Applications written or modified to use aa_change_hat(2) can take advantage of\n       subprofiles to run under different confinements, dependent on program logic. Several aa_change_hat(2)-aware applications exist, including an  Apache  module,  mod_apparmor(5);  a  PAM\n       module,  pam_apparmor;  and  a Tomcat valve, tomcat_apparmor. Applications written or modified to use change_profile(2) transition permanently to the specified profile. libvirt is one\n       such application.\n\n   Profile Head\n       The profile head consists of a required name that is unique and optional attachment conditionals and control flags.\n\n       Name\n\n       The name of the profile is its identifier. It is what is displayed during introspection (eg. ps -Z), and defines how  the  profile  is  referenced  by  policy  rules  for  any  policy\n       interaction  via  ipc or domain changes. It is recommended that the name be kept short and have meaning for the application it is being applied eg. firefox for the firefox web browser\n       or its functional role eg. log_admin.\n\n       If the name is an applications full absolute path name eg. /usr/bin/firefox and an exec attachment conditional is not specified the name is also used as the profile's exec  attachment\n       conditional.  This use however has been deprecated and is discouraged as it makes for long names that can make profile rules difficult to understand, and may not be fully displayed by\n       some introspection tools.\n\n       Attachment Conditionals\n\n       The attachment conditionals are used during profile changes to determine whether a profile is a match for the proposed profile transition. The attachment  conditionals  are  optional,\n       how and when they are applied is determined by the specific condition(s) used.\n\n       When attachment conditionals are used, the attachment conditionals for all profiles in the namespace will be evaluated. The profile with the set of attachments that result in the best\n       match will become the new profile after a transition operation. Attachments that don't match will result in the profile not being available for transition.\n\n       If no conditionals are specified the profile will only be used if a transition explicitly specifies the profile name.\n\n       Exec Attachment Conditional\n\n       The  exec  attachment  conditional  governs  how  closely the profile matches an executable program. This conditional is only used during an exec operation when the matching exec rule\n       specifies either a px or cx (or their derivatives) transition type. The exec attachment conditional will also be used by tasks that are unconfined as they use a pix transition rule.\n\n       If there are no attachment matches then it is up to the exec rule to determine what happens (fail or a fallback option).\n\n       Note: see profile Name for information around using the profile name as an attachment conditional.\n\n       Exec attachment conditionals can contain variable names and pattern matching.  They use a longest left match heuristic to deterime the winner in the case of multiple  matches  at  run\n       time.  The  exact implementation of this resolution is kernel specific and has improved over time, while retaining backwards compatibility. If the heuristic can not determine a winner\n       between multiple matches the exec will be denied.\n\n       Extended Attributes Attachment Conditional\n\n       AppArmor profiles have the ability to target files based on their xattr(7) values in addition to their path. For example, the following profile matches  files  in  /usr/bin  with  the\n       attribute \"security.apparmor\" and value \"trusted\":\n\n         /usr/bin/* xattrs(security.apparmor=\"trusted\") {\n           # ...\n         }\n\n       See apparmor_xattrs(7) for further details.\n\n       Flags\n\n       The  profile  flags  allow  modifying the behavior of the profile. If a profile flag is specified it takes priority over any conflicting flags that have been specified by rules in the\n       profile body.\n\n       Profile Mode\n\n       The profile mode allow controlling the enforcement behavior of the profile rules.\n\n       If no mode is specified the profile defaults to enforce mode.\n\n       enforce For a given action, if the profile rules do not grant permission the action will be denied, with an EACCES or EPERM error code returned to userspace, and the violation will be\n       logged with a tag of the access being DENIED.\n       kill This is a variant of enforce mode where in addition to returning EACCES or EPERM for a violation, the task is also sent a signal to kill it.\n       complain For a given action, if the profile rules do not grant permission the action will be allowed, but the violation will be logged with a tag of the access being ALLOWED.\n       default_allow This mode changes the default behavior of apparmor from default deny to default allow. When default_allow is specified the resulting profile will allow operations that\n       the profile does not have a rule for. This mode is similar to unconfined but allows for allow and deny rules, specifying audit, and domain transitions.  Profiles in this mode may be\n       be reported as being in enforce mode or allow mode when introspected from the kernel.\n               Note: default_allow is similar and for many profiles will be equivalent to specifying an allow all, rule in the profile. The default_allow flag does not provide all  the  same\n               option that the allow all, rule provides.\n\n       unconfined This mode allows a task confined by the profile to behave as though it is unconfined. The unconfined behavior can be later changed to confinement by using profile\n       replacement. This mode should not be used under regular deployment but can be useful during debugging and some system initialization scenarios.\n               This mode is similar to default_allow and may be emulated by default_allow in kernels that no longer support a true unconfined mode. It does not generally allow for specifying\n               deny  rules,  or  allow  rules  that override the default behavior, except in a few custom kernels where unconfined restricts a few operations. It relies on special customized\n               behavior of the unconfined profile in the kernel and as such should only be used for debugging.\n\n               Note: true unconfined is being phased out, with unconfined becoming a replaceable profile. As such unconfined mode will be emulated by a  special  profile  compiled  with  the\n               default_allow flag in newer kernels.\n\n       prompt This mode allows task mediation to send an up call to userspace to ask for a decision when there isn't a rule covering the permission request. If userspace does not respond\n       then the access will be denied.\n\n       Audit Mode\n\n       The audit mode allows control of how AppArmor messages are are logged to the audit system.\n\n       audit This flag causes all actions whether allowed or denied to be logged.\n\n       Misc modes\n\n       mediate_deleted This forces AppArmor to mediate deleted files as if they still exist in the file system.\n       attach_disconnected This forces AppArmor to attach disconnected objects to the task's namespace and mediate them as though they are part of the namespace. WARNING this mode is unsafe\n       and can result in aliasing and access to objects that should not be allowed. Its intent is a debug and policy development tool.\n       attach_disconnected.path=ABS PATH Like attach_disconnected, but attach disconnected objects to the supplied path instead of the root of the namespace.\n       chroot_relative This forces file names to be relative to a chroot and behave as if the chroot is a mount namespace.\n       debug This flag allows turning on kernel debug messages on a per profile basis. It works in conjunction with other kernel debug flags to control what messages will be output. Its\n       effect is kernel dependent, and it should never appear in policy except when trying to debug kernel or policy problems.\n       interruptible Enables interrupts for prompt upcall to userspace.\n       kill.signal=SIGNAL This changes the signal that will be sent by AppArmor when in kill mode or a kill rule has been violated.\n       error=ERROR CODE This changes the error code returned by AppArmor when a rule has been violated.\n\n   Access Modes\n       File permission access modes consists of combinations of the following modes:\n\n       r       - read\n\n       w       - write -- conflicts with append\n\n       a       - append -- conflicts with write\n\n       ux      - unconfined execute\n\n       Ux      - unconfined execute -- scrub the environment\n\n       px      - discrete profile execute\n\n       Px      - discrete profile execute -- scrub the environment\n\n       cx      - transition to subprofile on execute\n\n       Cx      - transition to subprofile on execute -- scrub the environment\n\n       ix      - inherit execute\n\n       pix     - discrete profile execute with inherit fallback\n\n       Pix     - discrete profile execute with inherit fallback -- scrub the environment\n\n       cix     - transition to subprofile on execute with inherit fallback\n\n       Cix     - transition to subprofile on execute with inherit fallback -- scrub the environment\n\n       pux     - discrete profile execute with fallback to unconfined\n\n       PUx     - discrete profile execute with fallback to unconfined -- scrub the environment\n\n       cux     - transition to subprofile on execute with fallback to unconfined\n\n       CUx     - transition to subprofile on execute with fallback to unconfined -- scrub the environment\n\n       deny x  - disallow execute (in rules with the deny qualifier)\n\n       m       - allow PROT_EXEC with mmap(2) calls\n\n       l       - link\n\n       k       - lock\n\n   Access Modes Details\n       r - Read mode\n           Allows the program to have read access to the file or directory listing. Read access is required for shell scripts and other interpreted content.\n\n       w - Write mode\n           Allows  the  program  to  have  write  access  to  the file. Files and directories must have this permission if they are to be unlinked (removed.)  Write mode is not required on a\n           directory to rename or create files within the directory.\n\n           This mode conflicts with append mode.\n\n       a - Append mode\n           Allows the program to have a limited appending only write access to the file.  Append mode will prevent an application from opening  the  file  for  write  unless  it  passes  the\n           O_APPEND parameter flag on open.\n\n           The mode conflicts with Write mode.\n\n       ux - Unconfined execute mode\n           Allows the program to execute the program without any AppArmor profile being applied to the program.\n\n           This  mode  is  useful  when  a  confined  program  needs to be able to perform a privileged operation, such as rebooting the machine. By placing the privileged section in another\n           executable and granting unconfined execution rights, it is possible to bypass the mandatory constraints imposed on  all  confined  processes.  For  more  information  on  what  is\n           constrained, see the apparmor(7) man page.\n\n           WARNING  'ux'  should only be used in very special cases. It enables the designated child processes to be run without any AppArmor protection.  'ux' does not scrub the environment\n           of variables such as LD_PRELOAD; as a result, the calling domain may have an undue amount of influence over the callee.  Use this mode only if the child  absolutely  must  be  run\n           unconfined and LD_PRELOAD must be used. Any profile using this mode provides negligible security. Use at your own risk.\n\n           Incompatible with other exec transition modes and the deny qualifier.\n\n       Ux - unconfined execute -- scrub the environment\n           'Ux'  allows  the  named  program  to run in 'ux' mode, but AppArmor will invoke the Linux Kernel's unsafe_exec routines to scrub the environment, similar to setuid programs. (See\n           ld.so(8) for some information on setuid/setgid environment scrubbing.)\n\n           WARNING 'Ux' should only be used in very special cases. It enables the designated child processes to be run without any AppArmor protection.  Use  this  mode  only  if  the  child\n           absolutely must be run unconfined. Use at your own risk.\n\n           Incompatible with other exec transition modes and the deny qualifier.\n\n       px - Discrete Profile execute mode\n           This mode requires that a discrete security profile is defined for a program executed and forces an AppArmor domain transition. If there is no profile defined then the access will\n           be denied.\n\n           WARNING 'px' does not scrub the environment of variables such as LD_PRELOAD; as a result, the calling domain may have an undue amount of influence over the callee.\n\n           Incompatible with other exec transition modes and the deny qualifier.\n\n       Px - Discrete Profile execute mode -- scrub the environment\n           'Px'  allows  the  named  program  to run in 'px' mode, but AppArmor will invoke the Linux Kernel's unsafe_exec routines to scrub the environment, similar to setuid programs. (See\n           ld.so(8) for some information on setuid/setgid environment scrubbing.)\n\n           Incompatible with other exec transition modes and the deny qualifier.\n\n       cx - Transition to Subprofile execute mode\n           This mode requires that a local security profile is defined and forces an AppArmor domain transition to the named profile. If there is no profile defined then the access  will  be\n           denied.\n\n           WARNING 'cx' does not scrub the environment of variables such as LD_PRELOAD; as a result, the calling domain may have an undue amount of influence over the callee.\n\n           Incompatible with other exec transition modes and the deny qualifier.\n\n       Cx - Transition to Subprofile execute mode -- scrub the environment\n           'Cx'  allows  the  named  program  to run in 'cx' mode, but AppArmor will invoke the Linux Kernel's unsafe_exec routines to scrub the environment, similar to setuid programs. (See\n           ld.so(8) for some information on setuid/setgid environment scrubbing.)\n\n           Incompatible with other exec transition modes and the deny qualifier.\n\n       ix - Inherit execute mode\n           Prevent the normal AppArmor domain transition on execve(2) when the profiled program executes the named program. Instead, the executed resource will inherit the current profile.\n\n           This mode is useful when a confined program needs to call another confined program without gaining the permissions of the target's  profile,  or  losing  the  permissions  of  the\n           current profile. There is no version to scrub the environment because 'ix' executions don't change privileges.\n\n           Incompatible with other exec transition modes and the deny qualifier.\n\n       Profile transition with inheritance fallback execute mode\n           These  modes  attempt  to  perform  a  domain transition as specified by the matching permission (shown below) and if that transition fails to find the matching profile the domain\n           transition proceeds using the 'ix' transition mode.\n\n             'Pix' == 'Px' with fallback to 'ix'\n             'pix' == 'px' with fallback to 'ix'\n             'Cix' == 'Cx' with fallback to 'ix'\n             'cix' == 'cx' with fallback to 'ix'\n\n           Incompatible with other exec transition modes and the deny qualifier.\n\n       Profile transition with unconfined fallback execute mode\n           These modes attempt to perform a domain transition as specified by the matching permission (shown below) and if that transition fails to  find  the  matching  profile  the  domain\n           transition proceeds using the 'ux' transition mode if 'pux', 'cux' or the 'Ux' transition mode if 'PUx', 'CUx' is used.\n\n             'PUx' == 'Px' with fallback to 'Ux'\n             'pux' == 'px' with fallback to 'ux'\n             'CUx' == 'Cx' with fallback to 'Ux'\n             'cux' == 'cx' with fallback to 'ux'\n\n           Incompatible with other exec transition modes and the deny qualifier.\n\n       deny x - Deny execute\n           For rules including the deny modifier, only 'x' is allowed to deny execute.\n\n           The 'ix', 'Px', 'px', 'Cx', 'cx' and the fallback modes conflict with the deny modifier.\n\n       Directed profile transitions\n           The  directed  ('px', 'Px', 'pix', 'Pix', 'pux', 'PUx') profile and subprofile ('cx', 'Cx', 'cix', 'Cix', 'cux', 'CUx') transitions normally determine the profile to transition to\n           from the executable name. It is however possible to specify the name of the profile that the transition should use.\n\n           The name of the profile to transition to is specified using the '->' followed by the name of the profile to transition to. Eg.\n\n             /bin/** px -> profile,\n\n           Incompatible with other exec transition modes.\n\n       m - Allow executable mapping\n           This mode allows a file to be mapped into memory using mmap(2)'s PROT_EXEC flag. This flag marks the pages executable; it is used on some architectures to  provide  non-executable\n           data  pages,  which  can  complicate  exploit  attempts.  AppArmor  uses  this mode to limit which files a well-behaved program (or all programs on architectures that enforce non-\n           executable memory access controls) may use as libraries, to limit the effect of invalid -L flags given to ld(1) and LD_PRELOAD, LD_LIBRARY_PATH, given to ld.so(8).\n\n       l - Link mode\n           Allows the program to be able to create a link with this name.  When a link is created, the new link MUST have a subset of permissions as the original  file  (with  the  exception\n           that the destination does not have to have link access.) If there is an 'x' rule on the new link, it must match the original file exactly.\n\n       k - lock mode\n           Allows the program to be able lock a file with this name.  This permission covers both advisory and mandatory locking.\n\n       leading OR trailing access permissions\n           File rules can be specified with the access permission either leading or trailing the file glob. Eg.\n\n             rw /**,               # leading permissions\n\n             /** rw,               # trailing permissions\n\n           When leading permissions are used further rule options and context may be allowed, Eg.\n\n             l /foo -> /bar,       # lead 'l' link permission is equivalent to link rules\n\n   Link rules\n       Link  rules  allow specifying permission to form a hard link as a link target pair.  If the subset condition is specified then the permissions to access the link file must be a subset\n       of the profiles permissions to access the target file. If there is an 'x' rule on the new link, it must match the original file exactly.\n\n       Eg.\n\n         /file1  r,\n         /file2  rwk,\n         /link*  rw,\n         link subset /link* -> /**,\n\n       The link rule allows linking of /link to both /file1 or /file2 by name however because the /link file has 'rw' permissions it is not allowed to link to /file1 because that would grant\n       an access path to /file1 with more permissions than the 'r' permissions the profile specifies.\n\n       A link of /link to /file2 would be allowed because the 'rw' permissions of /link are a subset of the 'rwk' permissions for /file1.\n\n       The link rule is equivalent to specifying the 'l' link permission as a leading permission with no other file access permissions. When this  is  done  the  link  rule  options  can  be\n       specified.\n\n       The following link rule is equivalent to the 'l' permission file rule\n\n         link /foo -> bar,\n         l /foo -> /bar,\n\n       File rules that specify the 'l' permission and don't specify the extend link permissions map to link rules as follows.\n\n         /foo l,\n         l /foo,\n         link subset /foo -> /**,\n\n   Comments\n       Comments start with # and may begin at any place within a line. The comment ends when the line ends. This is the same comment style as shell scripts.\n\n   Capabilities\n       The  only  capabilities  a  confined  process  may use may be enumerated; for the complete list, please refer to capabilities(7). Note that granting some capabilities renders AppArmor\n       confinement for that domain advisory; while open(2), read(2), write(2), etc., will still return error when access is not granted,  some  capabilities  allow  loading  kernel  modules,\n       arbitrary access to IPC, ability to bypass discretionary access controls, and other operations that are typically reserved for the root user.\n\n   Network Rules\n       AppArmor supports simple coarse grained network mediation.  The network rule restrict all socket(2) based operations.  The mediation done is a coarse-grained check on whether a socket\n       of a given type and family can be created, read, or written. Network netlink(7) rules may only specify type 'dgram' and 'raw'.\n\n       AppArmor network rules are accumulated so that the granted network permissions are the union of all the listed network rule permissions.\n\n       AppArmor network rules are broad and general and become more restrictive as further information is specified.\n\n       eg.\n\n        network,               #allow access to all networking\n        network tcp,           #allow access to tcp\n        network inet tcp,      #allow access to tcp only for inet4 addresses\n        network inet6 tcp,     #allow access to tcp only for inet6 addresses\n        network netlink raw,   #allow access to AF_NETLINK SOCK_RAW\n\n       Network permissions\n\n       Network  rule  permissions are implied when a rule does not explicitly state an access list. By default if a rule does not have an access list all permissions that are compatible with\n       the specified set of local and peer conditionals are implied.\n\n       The create, bind, listen, shutdown, getattr, setattr, getopt, and setopt permissions are local socket permissions. They are only applied to the local socket and can't be specified  in\n       rules  that  have  a  peer  conditional.  The  accept  permission  applies  to  the  combination of a local and peer socket. The connect, send, and receive permissions are peer socket\n       permissions.\n\n       Mediation of inet/inet6 family\n\n       AppArmor supports fine grained mediation of the inet and inet6 families by using the ip and port conditionals. The ip  conditional  accepts  both  IPv4  and  IPv6  using  the  regular\n       representation  of four octets separated by '.' for IPv4 and eight groups of four hexadecimal numbers separated by ':' for IPv6. Contiguous leading zeros can be replaced by '::' once.\n       On a connected socket, the sender and receiver don't need to be specified in the recvfrom and sendto system calls. In that case, and with unbounded sockets, the IP address is none, or\n       unknown. Unknown or Unbound IP addresses are represented in policy by the 'none' keyword. When the ip conditional is omitted, then all IP addresses will be  allowed:  IPv4,  IPv6  and\n       none. If INADDR_ANY or in6addr_any is used, then the ip conditional can be omitted or they can be represented by:\n\n        network ip=::,         #allow in6addr_any\n        network ip=0.0.0.0;    #allow INADDR_ANY\n\n       The network rules support the specification of local and remote IP addresses, ports, and port ranges.\n\n        network ip=127.0.0.1 port=8080,\n        network peer=(ip=10.139.15.23 port=8081),\n        network ip=fd74:1820:b03a:b361::cf32 peer=(ip=fd74:1820:b03a:b361::a0f9),\n        network port=8080 peer=(port=8081),\n        network ip=127.0.0.1 port=8080 peer=(ip=10.139.15.23 port=8081),\n        network ip=127.0.0.1 port=8080-8084,\n\n   Mount Rules\n       AppArmor  supports  mount  mediation and allows specifying filesystem types and mount flags. The syntax of mount rules in AppArmor is based on the mount(8) command syntax. Mount rules\n       must contain one of the mount, remount or umount keywords, but all mount conditions are optional. Unspecified  optional  conditionals  are  assumed  to  match  all  entries  (eg,  not\n       specifying  fstype means all fstypes are matched). Due to the complexity of the mount command and how options may be specified, AppArmor allows specifying conditionals three different\n       ways:\n\n       1.  If a conditional is specified using '=', then the rule only grants permission for mounts matching the exactly specified options. For example, an AppArmor policy with the following\n           rule:\n\n               mount options=ro /dev/foo -> /mnt/,\n\n           Would match:\n\n               $ mount -o ro /dev/foo /mnt\n\n           but not either of these:\n\n               $ mount -o ro,atime /dev/foo /mnt\n\n               $ mount -o rw /dev/foo /mnt\n\n       2.  If a conditional is specified using 'in', then the rule grants permission for mounts matching any combination of the specified options. For example, if an AppArmor policy has  the\n           following rule:\n\n               mount options in (ro,atime) /dev/foo -> /mnt/,\n\n           all of these mount commands will match:\n\n               $ mount -o ro /dev/foo /mnt\n\n               $ mount -o ro,atime /dev/foo /mnt\n\n               $ mount -o atime /dev/foo /mnt\n\n           but none of these will:\n\n               $ mount -o ro,sync /dev/foo /mnt\n\n               $ mount -o ro,atime,sync /dev/foo /mnt\n\n               $ mount -o rw /dev/foo /mnt\n\n               $ mount -o rw,noatime /dev/foo /mnt\n\n               $ mount /dev/foo /mnt\n\n       3.  If  multiple  conditionals  are specified in a single mount rule, then the rule grants permission for each set of options. This provides a shorthand when writing mount rules which\n           might help to logically break up a conditional. For example, if an AppArmor policy has the following rule:\n\n               mount options=ro options=atime,\n\n           both of these mount commands will match:\n\n               $ mount -o ro /dev/foo /mnt\n\n               $ mount -o atime /dev/foo /mnt\n\n           but this one will not:\n\n               $ mount -o ro,atime /dev/foo /mnt\n\n       Note that separate mount rules are distinct and the options do not accumulate.  For example, these AppArmor mount rules:\n\n           mount options=ro,\n\n           mount options=atime,\n\n       are not equivalent to either of these mount rules:\n\n           mount options=(ro,atime),\n\n           mount options in (ro,atime),\n\n       To help clarify the flexibility and complexity of mount rules, here are some example rules with accompanying matching commands:\n\n       mount,\n           the 'mount' rule without any conditionals is the most generic and allows any mount. Equivalent to 'mount fstype=** options=** ** -> /**'.\n\n       mount /dev/foo,\n           allow mounting of /dev/foo anywhere with any options. Some matching mount commands:\n\n               $ mount /dev/foo /mnt\n\n               $ mount -t ext3 /dev/foo /mnt\n\n               $ mount -t vfat /dev/foo /mnt\n\n               $ mount -o ro,atime,noexec,nodiratime /dev/foo /srv/some/mountpoint\n\n       mount options=ro /dev/foo,\n           allow mounting of /dev/foo anywhere, as read only. Some matching mount commands:\n\n               $ mount -o ro /dev/foo /mnt\n\n               $ mount -o ro /dev/foo /some/where/else\n\n       mount options=(ro,atime) /dev/foo,\n           allow mount of /dev/foo anywhere, as read only and using inode access times.  Some matching mount commands:\n\n               $ mount -o ro,atime /dev/foo /mnt\n\n               $ mount -o ro,atime /dev/foo /some/where/else\n\n       mount options in (ro,atime) /dev/foo,\n           allow mount of /dev/foo anywhere using some combination of 'ro' and 'atime' (see above). Some matching mount commands:\n\n               $ mount -o ro /dev/foo /mnt\n\n               $ mount -o atime /dev/foo /some/where/else\n\n               $ mount -o ro,atime /dev/foo /some/other/place\n\n       mount options=ro /dev/foo, mount options=atime /dev/foo,\n           allow mount of /dev/foo anywhere as read only, and allow mount of /dev/foo anywhere using inode access times. Note this is expressed as two different rules. Matches:\n\n               $ mount -o ro /dev/foo /mnt/1\n\n               $ mount -o atime /dev/foo /mnt/2\n\n       mount -> /mnt/**,\n           allow mounting anything under a directory in /mnt/**. Some matching mount commands:\n\n               $ mount /dev/foo1 /mnt/1\n\n               $ mount -o ro,atime,noexec,nodiratime /dev/foo2 /mnt/deep/path/foo2\n\n       mount options=ro -> /mnt/**,\n           allow mounting anything under /mnt/**, as read only. Some matching mount commands:\n\n               $ mount -o ro /dev/foo1 /mnt/1\n\n               $ mount -o ro /dev/foo2 /mnt/deep/path/foo2\n\n       mount fstype=ext3 options=(rw,atime) /dev/sdb1 -> /mnt/stick/,\n           allow mounting an ext3 filesystem in /dev/sdb1 on /mnt/stick as read/write and using inode access times. Matches only:\n\n               $ mount -o rw,atime /dev/sdb1 /mnt/stick\n\n       mount options=(ro, atime) options in (nodev, user) /dev/foo -> /mnt/,\n           allow mounting /dev/foo on /mmt/ read only and using inode access times or allow mounting /dev/foo on /mnt/ with some combination of 'nodev' and 'user'.  Matches only:\n\n               $ mount -o ro,atime /dev/foo /mnt\n\n               $ mount -o nodev /dev/foo /mnt\n\n               $ mount -o user /dev/foo /mnt\n\n               $ mount -o nodev,user /dev/foo /mnt\n\n   Message Queue rules\n       AppArmor supports mediation of POSIX and SYSV message queues.\n\n       AppArmor Message Queue permissions are implied when a rule does not explicitly state an access list. By default, all Message Queue permissions are implied.\n\n       AppArmor Message Queue permissions become more restricted as further information is specified. Policy can be specified by determining its access mode, type, label, and  message  queue\n       name.\n\n       Regarding access modes, 'r' and 'read' are used to read messages from the queue.  'w' and 'write' are used to write to the message queue. 'create' is used to create the message queue,\n       and  'open'  is used to get the message queue identifier when the queue is already created. 'delete' is used to remove the message queue. The access modes to get and set attributes of\n       the message queue are 'setattr' and 'getattr'.\n\n       The type of the policy can be either 'posix' or 'sysv'. This information is relevant when the message queue name is not specified, and when specified can  be  inferred  by  the  queue\n       name, since message queues' name for posix must start with '/', and message queues' key for SYSV must be a positive integer.\n\n       The policy label is the label assigned to the message queue when it is created.\n\n       The message queue name can be either a string starting with '/' if the type is POSIX, or a positive integer if the type is SYSV. If the type is not specified, then it will be inferred\n       by the queue name.\n\n       Example AppArmor Message Queue rules:\n\n           # Allow all Message Queue access\n           mqueue,\n\n           # Explicitly allow all Message Queue access,\n           mqueue (create, open, delete, read, write, getattr, setattr),\n\n           # Explicitly deny use of Message Queue\n           deny mqueue,\n\n           # Allow all access for POSIX queue of name /bar\n           mqueue type=posix /bar,\n\n           # Allow create permission for a SYSV queue of label foo\n           mqueue create label=foo 123,\n\n   User Namespace Rules\n       User namespaces are part of many sandboxing and containerization solutions.  They provide a way for a non-system root process to be root within the container. Unfortunately this opens\n       up attack surface in the kernel and has been part of several exploit chains. As such AppArmor can be used to restrict the creation of user namespaces to select processes.\n\n       User namespace permission are implied when a rule does not explicitly state an access list. The rule becomes more restrictive as further information is specified.\n\n       Note:  user namespace creation may be restricted so that it is not available to unprivieged unconfined processes. If this is the case any process trying to create user namespaces will\n       require a profile that allows the necessary permissions.\n\n       create\n           Allow creation of user namespaces.\n\n       Example userns rules:\n\n         # Allow all userns perms\n         userns,\n\n         # Allow creation of a userns\n         userns create,\n\n   IO_URing Rules\n       AppArmor supports mediation of the new Linux high speed IO interface.  There is limited mediation at this time to just a few permissions at the moment.\n\n       IO Uring permission are implied when a rule does not explicitly state an access list. The rule becomes more restrictive as further information is specified.\n\n       Note: io_uring access may be restricted so that it is not available to unprivileged unconfined processes. If this is the case any process trying to use io_uring will require a profile\n       that allows the necessary io_uring permissions.\n\n       sqpoll\n           All the task confined by the profile to spawn a io_uring polling thread.\n\n       override_creds\n           Grants the task confined by the profile to override (change) its credentials to the specified label, when executing an io_uring operation.\n\n       Example IO_URING rules:\n\n         # Allow io_uring operations\n         io_uring,\n\n         # Allow creation of a polling thread\n         io_uring sqpoll,\n\n         # Allow task to override credentials during io_uring operation\n         io_uring override_creds label=new_creds,\n\n   Pivot Root Rules\n       AppArmor mediates changing of the root filesystem through the pivot_root(2) system call. The syntax of 'pivot_root' rules in  AppArmor  is  based  on  the  pivot_root(2)  system  call\n       parameters  with the notable exception that the ordering is reversed. The path corresponding to the put_old parameter of pivot_root(2) is optionally specified in the 'pivot_root' rule\n       using the 'oldroot=' prefix.\n\n       AppArmor 'pivot_root' rules can specify a profile transition to occur during the pivot_root(2) system call. Note that currently, this feature is not supported by any kernel. When this\n       feature will be supported, AppArmor will only transition the process calling pivot_root(2) to the new profile.\n\n       The paths specified in 'pivot_root' rules must end with '/' since they are directories.\n\n       Here are some example 'pivot_root' rules:\n\n           # Allow any pivot\n           pivot_root,\n\n           # Allow pivoting to any new root directory and putting the old root\n           # directory at /mnt/root/old/\n           pivot_root oldroot=/mnt/root/old/,\n\n           # Allow pivoting the root directory to /mnt/root/\n           pivot_root /mnt/root/,\n\n           # Allow pivoting to /mnt/root/ and putting the old root directory at\n           # /mnt/root/old/\n           pivot_root oldroot=/mnt/root/old/ /mnt/root/,\n\n           # Allow pivoting to /mnt/root/, putting the old root directory at\n           # /mnt/root/old/ and transition to the /mnt/root/sbin/init profile\n           pivot_root oldroot=/mnt/root/old/ /mnt/root/ -> /mnt/root/sbin/init,\n\n   PTrace rules\n       AppArmor supports mediation of ptrace(2). AppArmor PTrace rules are accumulated so that the granted PTrace permissions are the union of all the listed PTrace rule permissions.\n\n       AppArmor PTrace permissions are implied when a rule does not explicitly state an access list. By default, all PTrace permissions are implied.\n\n       The trace and tracedby permissions govern ptrace(2) while read and readby govern certain proc(5) filesystem accesses, kcmp(2), futexes (get_robust_list(2)) and perf trace events.\n\n       For a ptrace operation to be allowed the profile of the tracing process and the profile of the target task must both have the correct permissions. For  example,  the  profile  of  the\n       process  attaching  to  another task must have the trace permission for the target task's profile, and the task being traced must have the tracedby permission for the tracing process'\n       profile.\n\n       Example AppArmor PTrace rules:\n\n           # Allow all PTrace access\n           ptrace,\n\n           # Explicitly allow all PTrace access,\n           ptrace (read, readby, trace, tracedby),\n\n           # Explicitly deny use of ptrace(2)\n           deny ptrace (trace),\n\n           # Allow unconfined processes (eg, a debugger) to ptrace us\n           ptrace (readby, tracedby) peer=unconfined,\n\n           # Allow ptrace of a process running under the /usr/bin/foo profile\n           ptrace (trace) peer=/usr/bin/foo,\n\n   Signal rules\n       AppArmor supports mediation of signal(7). AppArmor signal rules are accumulated so that the granted signal permissions are the union of all the listed signal rule permissions.\n\n       AppArmor signal permissions are implied when a rule does not explicitly state an access list. By default, all signal permissions are implied.\n\n       For the sending of a signal to be allowed, the profile of the sending process and the profile of the target task must both have the correct permissions. For example, the profile of  a\n       process  sending a signal to another task must have the send permission for the target task's profile, and the task receiving the signal must have a receive permission for the sending\n       process' profile.\n\n       Example AppArmor signal rules:\n\n           # Allow all signal access\n           signal,\n\n           # Explicitly deny sending the HUP and INT signals\n           deny signal (send) set=(hup, int),\n\n           # Allow unconfined processes to send us signals\n           signal (receive) peer=unconfined,\n\n           # Allow sending of signals to a process running under the /usr/bin/foo\n           # profile\n           signal (send) peer=/usr/bin/foo,\n\n           # Allow checking for PID existence\n           signal (receive, send) set=(\"exists\"),\n\n           # Allow us to signal ourselves using the built-in @{profile_name} variable\n           signal peer=@{profile_name},\n\n           # Allow two real-time signals\n           signal set=(rtmin+0 rtmin+32),\n\n   DBus rules\n       AppArmor supports DBus mediation. The mediation is performed in conjunction with the DBus daemon. The DBus daemon verifies that communications over the bus are permitted  by  AppArmor\n       policy.\n\n       AppArmor DBus rules are accumulated so that the granted DBus permissions are the union of all the listed DBus rule permissions.\n\n       AppArmor DBus rules are broad and general and become more restrictive as further information is specified. Policy may be specified down to the interface member level (method or signal\n       name), however the contents of messages are not examined.\n\n       Some  AppArmor DBus permissions are not compatible with all AppArmor DBus rules.  The 'bind' permission cannot be used in message rules. The 'send' and 'receive' permissions cannot be\n       used in service rules. The 'eavesdrop' permission cannot be used in rules containing any conditionals outside of the 'bus' conditional.\n\n       'r' and 'read' are synonyms for 'receive'. 'w' and 'write' are synonyms for 'send'. 'rw' is a synonym for both 'send' and 'receive'.\n\n       AppArmor DBus permissions are implied when a rule does not explicitly state an access list. By default, all DBus permissions are implied. Only  message  permissions  are  implied  for\n       message rules and only service permissions are implied for service rules.\n\n       Example AppArmor DBus rules:\n\n           # Allow all DBus access\n           dbus,\n\n           # Explicitly allow all DBus access,\n           dbus (send, receive, bind),\n\n           # Deny send/receive/bind access to the session bus\n           deny dbus bus=session,\n\n           # Allow bind access for a particular name on any bus\n           dbus bind name=com.example.ExampleName,\n\n           # Allow receive access for a particular path and interface\n           dbus receive path=/com/example/path interface=com.example.Interface,\n\n           # Deny send/receive access to the system bus for a particular interface\n           deny dbus bus=system interface=com.example.ExampleInterface,\n\n           # Allow send access for a particular path, interface, member, and pair of\n           # peer names:\n           dbus send\n                bus=session\n                path=/com/example/path\n                interface=com.example.Interface\n                member=ExampleMethod\n                peer=(name=(com.example.ExampleName1|com.example.ExampleName2)),\n\n           # Allow receive access for all unconfined peers\n           dbus receive peer=(label=unconfined),\n\n           # Allow eavesdropping on the system bus\n           dbus eavesdrop bus=system,\n\n           # Allow and audit all eavesdropping\n           audit dbus eavesdrop,\n\n   Unix socket rules\n       AppArmor supports fine grained mediation of unix domain abstract and anonymous sockets. Unix domain sockets with file system paths are mediated via file access rules.\n\n       Abstract unix domain sockets is a nonportable Linux extension of unix domain sockets, see unix(7) for more information.\n\n       Unix socket address paths\n\n       The sun_path component (aka the socket address) of a unix domain socket is specified by the\n\n         addr=\n\n       conditional. If an address conditional is not specified as part of a rule then the rule matches both abstract and anonymous sockets.\n\n       In  apparmor  the  address  of  an abstract unix domain socket begins with the @ character, similar to how they are reported (as paths) by netstat -x. The address then follows and may\n       contain pattern matching and any characters including the null character. In apparmor null characters must be specified by using an escape sequence \\000 or \\x00. The pattern  matching\n       is the same as is used by file path matching so * will not match / even though it has no special meaning with in an abstract socket name. Eg.\n\n         unix addr=@*,\n\n       Autobound  unix  domain  sockets  have  a  unix  sun_path assigned to them by the kernel, as such specifying a policy based address is not possible.  The autobinding of sockets can be\n       controlled by specifying the special auto keyword. Eg.\n\n         unix addr=auto,\n\n       To indicate that the rule only applies to auto binding of unix domain sockets. It is important to note this only applies to the bind permission as once  the  socket  is  bound  to  an\n       address  it is indistinguishable from a socket that have an addr bound with a specified name. When the auto keyword is used with other permissions or as part of a peer addr it will be\n       replaced with a pattern that can match an autobound socket. Eg. For some kernels\n\n         unix rw addr=auto,\n\n       is transformed to\n\n         unix rw addr=@[a-f0-9][a-f0-9][a-f0-9][a-f0-9][a-f0-9],\n\n       It is important to note, this pattern may match abstract sockets that were not autobound but have an addr that fits what is generated by the kernel when autobinding a socket.\n\n       Anonymous unix domain sockets have no sun_path associated with the socket address, however it can be specified with the special none keyword to  indicate  the  rule  only  applies  to\n       anonymous unix domain sockets. Eg.\n\n         unix addr=none,\n\n       If the address component of a rule is not specified then the rule applies to autobind, abstract and anonymous sockets.\n\n       Unix socket permissions\n\n       Unix domain socket rules are accumulated so that the granted unix socket permissions are the union of all the listed unix rule permissions.\n\n       Unix  domain  socket rules are broad and general and become more restrictive as further information is specified. Policy may be specified down to the socket address (aka sun_path) and\n       label level. The content of the communication is not examined.\n\n       Unix socket rule permissions are implied when a rule does not explicitly state an access list. By default if a rule does not have an access list all permissions  that  are  compatible\n       with the specified set of local and peer conditionals are implied.\n\n       The  create, bind, listen, shutdown, getattr, setattr, getopt, and setopt permissions are local socket permissions. They are only applied to the local socket and can't be specified in\n       rules that have a peer component. The accept permission applies to the combination of a local and peer socket. The connect, send, and receive permissions are peer socket permissions.\n\n       Only the peer socket permissions will be applied to rules that don't specify permissions and contain a peer component.\n\n       Example Unix domain socket rules:\n\n         # Allow all permissions to unix sockets\n         unix,\n\n         # Explicitly allow all unix permissions\n         unix (create, listen, accept, connect, send, receive, getattr, setattr, setopt, getopt),\n\n         # Explicitly deny unix socket access\n         deny unix,\n\n         # Allow create and use of abstract and anonymous sockets for profile_name\n         unix peer=(label=@{profile_name}),\n\n         # Allow receiving via unix sockets from unconfined\n         unix (receive) peer=(label=unconfined),\n\n         # Allow getattr and shutdown on anonymous sockets\n         unix (getattr, shutdown) addr=none,\n\n         # Allow SOCK_STREAM connect, receive and send on an abstract socket @bar\n         # with peer running under profile '/foo'\n         unix (connect, receive, send) type=stream peer=(label=/foo,addr=\"@bar\"),\n\n         # Allow accepting connections from and receiving from peer running under\n         # profile '/bar' on abstract socket '@foo'\n         unix (accept, receive) addr=@foo peer=(label=/bar),\n\n       Abstract unix domain sockets autobind\n\n       Abstract unix domain sockets can autobind to an address. The autobind address is a unique 5 digit string of decimal numbers, eg. @00001. There is nothing that  prevents  a  task  from\n       manually binding to addresses with a similar pattern so it is impossible to reliably identify autobind addresses from a regular address.\n\n       Interaction of network rules and fine grained unix domain socket rules\n\n       The  coarse grained networking rules can be used to control unix domain sockets as well. When fine grained unix domain socket mediation is available the coarse grained network rule is\n       mapped into the equivalent unix socket rule.\n\n       E.G.\n\n           network unix,  =>  unix,\n\n           network unix stream,   =>  unix stream,\n\n       Fine grained mediation rules however can not be losslessly converted back to the coarse grained network rule; e.g.\n\n          unix bind addr=@example,\n\n       Has no exact match under coarse grained network rules, the closest match is the much wider permission rule of\n\n          network unix,\n\n   change_profile rules\n       AppArmor supports self directed profile transitions via the change_profile api. Change_profile rules control which permissions for which profiles a confined task  can  transition  to.\n       The profile name can contain apparmor pattern matching to specify different profiles.\n\n         change_profile -> **,\n\n       The  change_profile  api  allows  the  transition  to  be  delayed  until when a task executes another application. If an exec rule transition is specified for the application and the\n       change_profile api is used to make a transition at exec time, the transition specified by the change_profile api takes precedence.\n\n       The Change_profile permission can restrict which profiles can be transitioned to based off of the executable name by specifying the exec condition.\n\n         change_profile /bin/bash -> new_profile,\n\n       The restricting of the transition profile to a given executable at exec time is only useful when then current task is allowed to make dynamic decisions about what  confinement  should\n       be, but the decision set needs to be controlled. A list of profiles or multiple rules can be used to specify the profiles in the set. Eg.\n\n         change_profile /bin/bash -> {new_profile1,new_profile2,new_profile3},\n\n       An  exec  rule  can be used to specify a transition for the executable, if the transition should be allowed even if the change_profile api has not been used to select a transition for\n       those available in the change_profile rule set.  Eg.\n\n         /bin/bash Px -> new_profile1,\n         change_profile /bin/bash -> {new_profile1,new_profile2,new_profile3},\n\n       The exec mode dictates whether or not the Linux Kernel's unsafe_exec routines should be used to scrub the environment, similar to setuid programs.  (See ld.so(8) for some  information\n       on  setuid/setgid environment scrubbing.) The safe mode sets up environment scrubbing to occur when the new application is executed and unsafe mode disables AppArmor's requirement for\n       environment scrubbing (the kernel and/or libc may still require environment scrubbing). An exec mode can only be specified when an exec condition is present.\n\n         change_profile safe /bin/bash -> new_profile,\n\n       Not all kernels support safe mode and the parser will downgrade rules to unsafe mode in that situation. If no exec mode is specified, the default is safe mode in kernels that  support\n       it.\n\n   all rule\n       The  all rule is used to add a generic rule for all supported rule types.  This is useful when policy wants to define a black list instead of white list, but can also be useful to add\n       an access qualifier to all rules.\n\n       Eg. Black list\n\n         allow all,\n         # begin blacklist\n         deny file,\n         deny unix,\n\n       Eg. Adding audit qualifier\n\n         audit access all,\n\n   rlimit rules\n       AppArmor can set and control the resource limits associated with a profile as described in the setrlimit(2) man page.\n\n       The AppArmor rlimit controls allow setting of limits and restricting changes of them and these actions can be audited. Enforcement of the set limits is handled by the standard  kernel\n       enforcement mechanism for rlimits and will not result in an audited apparmor message if the limit is enforced.\n\n       If  a  profile  does  not have an rlimit rule associated with a given rlimit then the rlimit is left alone and regular access, including changing the limit, is allowed. However if the\n       profile sets an rlimit then the current limit is checked and if greater than the limit specified in the rule it will be changed to the specified limit.\n\n       AppArmor rlimit rules control the hard limit of an application and ensure that if the hard limit is lowered that the soft limit does not exceed the hard limit value.\n\n       Eg.\n\n         set rlimit data <= 100M,\n         set rlimit nproc <= 10,\n         set rlimit nice <= 5,\n\n   Variables\n       AppArmor's policy language allows embedding variables into file rules to enable easier configuration for some common (and  pervasive)  setups.   Variables  may  have  multiple  values\n       assigned, but any variable assignments must be made before the start of the profile.\n\n       The  parser  will automatically expand variables to include all values that they have been assigned; it is an error to reference a variable without setting at least one value. You can\n       use empty quotes (\"\") to explicitly add an empty value.\n\n       At the time of this writing, the following variables are defined in the provided AppArmor policy:\n\n         @{HOME}\n         @{HOMEDIRS}\n         @{multiarch}\n         @{pid}\n         @{pids}\n         @{PROC}\n         @{securityfs}\n         @{apparmorfs}\n         @{sys}\n         @{tid}\n         @{run}\n         @{XDG_DESKTOP_DIR}\n         @{XDG_DOWNLOAD_DIR}\n         @{XDG_TEMPLATES_DIR}\n         @{XDG_PUBLICSHARE_DIR}\n         @{XDG_DOCUMENTS_DIR}\n         @{XDG_MUSIC_DIR}\n         @{XDG_PICTURES_DIR}\n         @{XDG_VIDEOS_DIR}\n\n       These are defined in files in /etc/apparmor.d/tunables and are used in many of the abstractions described later.\n\n       You  may  also  add  files  in  /etc/apparmor.d/tunables/home.d  for  site-specific  customization  of   @{HOMEDIRS},   /etc/apparmor.d/tunables/multiarch.d   for   @{multiarch}   and\n       /etc/apparmor.d/tunables/xdg-user-dirs.d for @{XDG_*}.\n\n       The special @{profile_name} variable is set to the profile name and may be used in all policy.\n\n       Notes on variable expansion and the / character\n\n       It  is  important  to  note  that  how AppArmor performs variable expansion depends on the context where a variable is used. When a variable is expanded it can result in a string with\n       multiple path characters next to each other, in a way that is not evident when looking at policy.\n\n       Eg.\n\n           Given the following variable definition and rule\n\n           @{HOME}=/home/*/ file rw @{HOME}/*,\n\n           The variable expansion results in a rule of\n\n           file rw /home/*//*.\n\n       When this occurs in a context where a path is expected, AppArmor will canonicalize the path by collapsing consecutive / characters into a single character. For the above example, this\n       would be\n\n         file rw /home/*/*,\n\n       There is one exception to this rule, when the consecutive / characters are at the beginning of a path, this indicates a posix namespace and the characters will not be collapsed.\n\n       Eg.\n\n           @{HOME}=/home/*/ file rw /@{HOME}/*,\n\n           will result in an expansion of\n\n           file rw //home/*//*,\n\n           which is collapsed to\n\n           file rw //home/*/*,\n\n           Note: that the leading // in the above example is not collapsed to a single /. However the second // (that was also seen in the first example) is collapsed.\n\n   Alias rules\n       AppArmor also provides alias rules for remapping paths for site-specific layouts. They are an alternative form of path rewriting to  using  variables,  and  are  done  after  variable\n       resolution.   Alias   rules   must   occur   within   the   preamble  of  the  profile.  System-wide  aliases  are  found  in  /etc/apparmor.d/tunables/alias,  which  is  included  by\n       /etc/apparmor.d/tunables/global. /etc/apparmor.d/tunables/global is typically included at the beginning of an AppArmor profile.\n\n   Globbing (AARE)\n       File resources and other parameters accepting an AARE may be specified with a globbing syntax similar to that used by popular shells, such as csh(1), bash(1), zsh(1).\n\n       *   can substitute for any number of characters, excepting '/'\n\n       **  can substitute for any number of characters, including '/'\n\n       ?   can substitute for any single character excepting '/'\n\n       [abc]\n           will substitute for the single character a, b, or c\n\n       [a-c]\n           will substitute for the single character a, b, or c\n\n       [^a-c]\n           will substitute for any single character not matching a, b or c\n\n       {ab,cd}\n           will expand to one rule to match ab, one rule to match cd\n\n           Can also include variables.\n\n       @{variable}\n           will expand to all values assigned to the given variable.\n\n       When AppArmor looks up a directory the pathname being looked up will end with a slash (e.g., /var/tmp/); otherwise it will not end with a slash. Only rules that match a trailing slash\n       will match directories. Some examples, none matching the /tmp/ directory itself, are:\n\n       /tmp/*\n           Files directly in /tmp.\n\n       /tmp/*/\n           Directories directly in /tmp.\n\n       /tmp/**\n           Files and directories anywhere underneath /tmp.\n\n       /tmp/**/\n           Directories anywhere underneath /tmp.\n\n   Rule Qualifiers\n       There are several rule qualifiers that can be applied to permission rules.  Rule qualifiers can modify the rule and/or permissions within the rule.\n\n       priority\n           Specifies the priority of the rule. Currently the allowed range is -1000 to 1000 with the default priority of rule is 0.  Rules with higher priority are given preferences and will\n           completely override permissions of lower priority rules where they overlap. When rules partially overlap the permissions of the higher priority rule will completely override lower\n           priority rules within in overlap. Within a given priority level rules that overlap will accumulate permissions in the standard apparmor fashion.\n\n       allow\n           Specifies that permissions requests that match the rule are allowed. This is the default value for rules and does not need to be specified. Conflicts with the deny qualifier.\n\n       audit\n           Specifies that permissions requests that match the rule should be recorded to the audit log.\n\n       deny\n           Specifies that permissions requests that match the rule should be denied without logging. Can be combined with 'audit' to enable logging. Conflicts with the allow qualifier.\n\n       owner\n           Specifies that the task must have the same euid/fsuid as the object being referenced by the permission check.\n\n       Qualifier Blocks\n\n       Rule Qualifiers can be applied to multiple rules at a time by grouping the rules into a rule block.\n\n         audit {\n            /foo r,\n            network,\n         }\n\n   #include mechanism\n       AppArmor provides an easy abstraction mechanism to group common access requirements; this abstraction is an extremely flexible way to grant site-specific rights and makes writing  new\n       AppArmor profiles very simple by assembling the needed building blocks for any given program.\n\n       The  use  of  '#include'  is  modelled  directly  after cpp(1); its use will replace the '#include' statement with the specified file's contents.  The leading '#' is optional, and the\n       '#include' keyword can be followed by an option conditional 'if exists' that specifies profile compilation should continue if the specified file or directory is not found.\n\n       #include \"/absolute/path\" specifies that /absolute/path should be used.  #include \"relative/path\" specifies that relative/path should be used,  where  the  path  is  relative  to  the\n       current  working  directory.  #include   is the most common usage; it will load magic/path relative to a directory specified to apparmor_parser(8).  /etc/apparmor.d/ is the\n       AppArmor default.\n\n       The supplied AppArmor profiles follow several conventions; the abstractions stored in /etc/apparmor.d/abstractions/ are some large clusters  that  are  used  in  most  profiles.  What\n       follows are short descriptions of how some of the abstractions are used.\n\n       abstractions/audio\n           Includes accesses to device files used for audio applications.\n\n       abstractions/authentication\n           Includes access to files and services typically necessary for services that perform user authentication.\n\n       abstractions/base\n           Includes files that should be readable and writable in all profiles.\n\n       abstractions/bash\n           Includes many files used by bash; useful for interactive shells and programs that call system(3).\n\n       abstractions/consoles\n           Includes read and write access to the device files controlling the virtual console, sshd(8), xterm(1), etc. This abstraction is needed for many programs that interact with users.\n\n       abstractions/fonts\n           Includes access to fonts and the font libraries.\n\n       abstractions/gnome\n           Includes read and write access to GNOME configuration files, as well as read access to GNOME libraries.\n\n       abstractions/kde\n           Includes read and write access to KDE configuration files, as well as read access to KDE libraries.\n\n       abstractions/kerberosclient\n           Includes file access rules needed for common kerberos clients.\n\n       abstractions/nameservice\n           Includes file rules to allow DNS, LDAP, NIS, SMB, user and group password databases, services, and protocols lookups.\n\n       abstractions/perl\n           Includes read access to perl modules.\n\n       abstractions/user-download\n       abstractions/user-mail\n       abstractions/user-manpages\n       abstractions/user-tmp\n       abstractions/user-write\n           Some profiles for typical \"user\" programs will use these include files to describe rights that users have in the system.\n\n       abstractions/wutmp\n           Includes write access to files used to maintain wtmp(5) and utmp(5) databases, used with the w(1) and associated commands.\n\n       abstractions/X\n           Includes read access to libraries, configuration files, X authentication files, and the X socket.\n\n       Some of the abstractions rely on variables that are set in files in the /etc/apparmor.d/tunables/ directory. These variables are currently @{HOME} and @{HOMEDIRS}. Variables cannot be\n       set  in profile scope; they can only be set before the profile. Therefore, any profiles that use abstractions should either #include   or otherwise ensure that @{HOME}\n       and @{HOMEDIRS} are set before starting the profile definition. The aa-autodep(8) and aa-genprof(8) utilities will automatically emit #include   in generated profiles.\n\n   Feature ABI\n       The feature abi tells AppArmor which feature set the policy was developed under. This is important to ensure that kernels with a different feature set don't enforce features that  the\n       policy doesn't support, which can result in unexpected application failures.\n\n       When policy is compiled both the kernel feature abi and policy feature abi are consulted to build a policy that will work for the system's kernel.\n\n       If the kernel supports a feature not supported by the policy then policy will be built so that the kernel does NOT enforce that feature.\n\n       If  the  policy  supports a feature not supported by the kernel the compile may downgrade the rule with the feature to something the kernel supports, drop the rule completely, or fail\n       the compile.\n\n       If the policy abi is specified as kernel then the running kernel's abi will be used. This should never be used in shipped policy as it can cause system breakage when a new  kernel  is\n       installed.\n\n       ABI compatibility with AppArmor 2.x\n\n       AppArmor 3 remains compatible with AppArmor 2.x by detecting when a profile does not have a feature ABI specified. In this case the policy compile will either apply the pinned feature\n       ABI as specified by the config file or the command line, or if neither of those are applied by using a default feature ABI.\n\n       It is important to note that the default feature ABI does not support new features added in AppArmor 3 or later.\n\nEXAMPLE\n       An example AppArmor profile:\n\n               # which feature abi the policy was developed with\n               abi  ,\n\n               # a variable definition in the preamble\n               @{HOME} = /home/*/ /root/\n\n               # a comment about foo.\n               /usr/bin/foo {\n                 /bin/mount          ux,\n                 /dev/{,u}random     r,\n                 /etc/ld.so.cache    r,\n                 /etc/foo.conf       r,\n                 /etc/foo/*          r,\n                 /lib/ld-*.so*       rmix,\n                 /lib/lib*.so*       r,\n                 /proc/[0-9]**       r,\n                 /usr/lib/**         r,\n                 /tmp/foo.pid        wr,\n                 /tmp/foo.*          lrw,\n                 @{HOME}/.foo_file  rw,\n                 /usr/bin/baz        Cx -> baz,\n\n                 # a comment about foo's hat (subprofile), bar.\n                 ^bar {\n                   /lib/ld-*.so*       rmix,\n                   /usr/bin/bar        rmix,\n                   /var/spool/*        rwl,\n                 }\n\n                 # a comment about foo's subprofile, baz.\n                 profile baz {\n                   #include  \n                   owner /proc/[0-9]*/stat r,\n                   /bin/bash ixr,\n                   /var/lib/baz/ r,\n                   owner /var/lib/baz/* rw,\n                 }\n               }\n\nFILES\n       /etc/apparmor.d/\n\nKNOWN BUGS\n       •   Mount  options  support  the  use  of  pattern  matching  but mount flags are not correctly intersected against specified patterns. Eg, 'mount options=**,' should be equivalent to\n           'mount,', but it is not. (LP: #965690)\n\n       •   The fstype may not be matched against when certain mount command flags are used. Specifically fstype matching currently only works when creating a new mount and not remount, bind,\n           etc.\n\n       •   Mount rules with multiple 'options' conditionals are not applied as documented but instead merged such that 'options in (ro,nodev) options in (atime)' is equivalent to 'options in\n           (ro,nodev,atime)'.\n\n       •   When specifying mount options with the 'in' conditional, both the positive and negative values match when specifying one or the other. Eg, 'rw' matches when 'ro' is specified  and\n           'dev' matches when 'nodev' is specified such that 'options in (ro,nodev)' is equivalent to 'options in (rw,dev)'.\n\nSEE ALSO\n       apparmor(7), apparmor_parser(8), apparmor_xattrs(7), aa-complain(1), aa-enforce(1), aa_change_hat(2), mod_apparmor(5), and  .\n\nAppArmor 4.1.0                                                                            2025-04-10                                                                             APPARMOR.D(5)","ref":"apparmor-d.html"},{"type":"extras","title":"apparmor.vim","doc":"APPARMOR.VIM(5)                                                                            AppArmor                                                                            APPARMOR.VIM(5)\n\nNAME\n       apparmor.vim - vim syntax highlighting file for AppArmor profiles\n\nSYNOPSIS\n       Your system may be configured to automatically use syntax highlighting for installed AppArmor policies. If not, you can enable syntax highlighting in a specific vim session by\n       performing:\n\n        :set syntax=apparmor\n\nDESCRIPTION\n       apparmor.vim provides syntax highlighting rules for the vim(1) text editor; the rules provide an easy visual method to inspect AppArmor profiles for syntax correctness and semantics.\n\n       The colors indicate the relative severity of granting a specific set of privileges. Ranking access with colors is necessarily generic and vague, but it may help you understand your\n       profiles better.\n\nBUGS\n       apparmor.vim does not properly detect dark versus light backgrounds.  Patches accepted. If you find any bugs, please report them at  .\n\nSEE ALSO\n       vim(1), apparmor(7), apparmor.d(5), aa_change_hat(2), and  .\n\nAppArmor 4.1.0                                                                            2025-04-10                                                                           APPARMOR.VIM(5)","ref":"apparmor-vim.html"},{"type":"extras","title":"apt_auth.conf","doc":"APT_AUTH.CONF(5)                                                                              APT                                                                             APT_AUTH.CONF(5)\n\nNAME\n       apt_auth.conf - Login configuration file for APT sources and proxies\n\nDESCRIPTION\n       APT configuration files like sources.list(5) or apt.conf(5) need to be accessible for everyone using apt tools on the system to have access to all package-related information like the\n       available packages in a repository. Login information needed to connect to a proxy or to download data from a repository on the other hand shouldn't always be accessible by everyone\n       and can hence not be placed in a file with world-readable file permissions.\n\n       The APT auth.conf file /etc/apt/auth.conf, and .conf files inside /etc/apt/auth.conf.d can be used to store login information in a netrc-like format with restrictive file permissions.\n\nNETRC-LIKE FORMAT\n       The format defined here is similar to the format of the ~/.netrc file used by ftp(1) and similar programs interacting with servers. It is a simple token-based format with the\n       following tokens being recognized; Unknown tokens will be ignored. Tokens may be separated by spaces, tabs or newlines.\n\n       machine [protocol://]hostname[:port][/path]\n           Entries are looked up by searching for the machine token matching the hostname of the URI apt needs login information for. Extending the netrc-format a portnumber can be\n           specified. If no port is given the token matches for all ports. Similar the path is optional and only needed and useful if multiple repositories with different login information\n           reside on the same server. A machine token with a path matches if the path in the URI starts with the path given in the token. Once a match is made, the subsequent tokens are\n           processed, stopping when the end of file is reached or another machine token is encountered.\n\n           If protocol is not specified, the entry only matches https and tor+https.\n\n       login name\n           The username to be used.\n\n       password string\n           The password to be used.\n\nEXAMPLE\n       Supplying login information for a user named apt with the password debian for the sources.list(5) entry\n\n           deb https://example.org/debian trixie main\n\n       could be done in the entry directly:\n\n           deb https://apt:debian@example.org/debian trixie main\n\n       Alternatively an entry like the following in the auth.conf file could be used:\n\n           machine example.org\n           login apt\n           password debian\n\n       Or alternatively within a single line:\n\n           machine example.org login apt password debian\n\n       If you need to be more specific all of these lines will also apply to the example entry:\n\n           machine example.org/deb login apt password debian\n           machine example.org/debian login apt password debian\n           machine example.org/debian/ login apt password debian\n\n       On the other hand neither of the following lines apply:\n\n           machine example.org:443 login apt password debian\n           machine example.org/deb/ login apt password debian\n           machine example.org/ubuntu login apt password debian\n           machine example.orga login apt password debian\n           machine example.net login apt password debian\n\nNOTES\n       Basic support for this feature is present since version 0.7.25, but was undocumented for years. The documentation was added in version 1.5 changing also the implementation slightly.\n       For maximum backward compatibility you should avoid multiple machine tokens with the same hostname, but if you need multiple they should all have a path specified in the machine\n       token.\n\n       Login information in auth.conf are more flexible than those in sources.list. For example, login information can be specified for parts of a repository only, or if the sources.list\n       entry redirects elsewhere, login information for the redirect destination can be supplied.\n\nFILES\n       /etc/apt/auth.conf\n           Login information for APT sources and proxies in a netrc-like format. Configuration Item: Dir::Etc::netrc.\n\n       /etc/apt/auth.conf.d/*.conf\n           Login information for APT sources and proxies in a netrc-like format. Configuration Item: Dir::Etc::netrcparts.\n\nSEE ALSO\n       apt.conf(5) sources.list(5)\n\nBUGS\n       APT bug page[1]. If you wish to report a bug in APT, please see /usr/share/doc/debian/bug-reporting.txt or the reportbug(1) command.\n\nAUTHOR\n       APT team\n\nNOTES\n        1. APT bug page\n           https://bugs.debian.org/src:apt\n\nAPT 3.0.3                                                                              02 December 2019                                                                       APT_AUTH.CONF(5)","ref":"apt_auth-conf.html"},{"type":"extras","title":"apt.conf","doc":"APT.CONF(5)                                                                                   APT                                                                                  APT.CONF(5)\n\nNAME\n       apt.conf - Configuration file for APT\n\nDESCRIPTION\n       /etc/apt/apt.conf is the main configuration file shared by all the tools in the APT suite of tools, though it is by no means the only place options can be set. The suite also shares a\n       common command line parser to provide a uniform environment.\n\n       When an APT tool starts up it will read the configuration files in the following order:\n\n        1. the file specified by the APT_CONFIG environment variable (if any)\n\n        2. all files in Dir::Etc::Parts in alphanumeric ascending order which have either no or \"conf\" as filename extension and which only contain alphanumeric, hyphen (-), underscore (_)\n           and period (.) characters. Otherwise APT will print a notice that it has ignored a file, unless that file matches a pattern in the Dir::Ignore-Files-Silently configuration list -\n           in which case it will be silently ignored.\n\n        3. the main configuration file specified by Dir::Etc::main\n\n        4. all options set in the binary specific configuration subtree are moved into the root of the tree.\n\n        5. the command line options are applied to override the configuration directives or to load even more configuration files.\n\nSYNTAX\n       The configuration file is organized in a tree with options organized into functional groups. Option specification is given with a double colon notation; for instance\n       APT::Get::Assume-Yes is an option within the APT tool group, for the Get tool. Options do not inherit from their parent groups.\n\n       Syntactically the configuration language is modeled after what the ISC tools such as bind and dhcp use. Lines starting with // are treated as comments (ignored), as well as all text\n       between /* and */, just like C/C++ comments. Lines starting with # are also treated as comments. Each line is of the form APT::Get::Assume-Yes \"true\";. The quotation marks and\n       trailing semicolon are required. The value must be on one line, and there is no kind of string concatenation. Values must not include backslashes or extra quotation marks. Option\n       names are made up of alphanumeric characters and the characters \"/-:._+\". A new scope can be opened with curly braces, like this:\n\n           APT {\n             Get {\n               Assume-Yes \"true\";\n               Fix-Broken \"true\";\n             };\n           };\n\n       with newlines placed to make it more readable. Lists can be created by opening a scope and including a single string enclosed in quotes followed by a semicolon. Multiple entries can\n       be included, separated by a semicolon.\n\n           DPkg::Pre-Install-Pkgs {\"/usr/sbin/dpkg-preconfigure --apt\";};\n\n       In general the sample configuration file /usr/share/doc/apt/examples/configure-index is a good guide for how it should look.\n\n       Case is not significant in names of configuration items, so in the previous example you could use dpkg::pre-install-pkgs.\n\n       Names for the configuration items are optional if a list is defined as can be seen in the DPkg::Pre-Install-Pkgs example above. If you don't specify a name a new entry will simply add\n       a new option to the list. If you specify a name you can override the option in the same way as any other option by reassigning a new value to the option.\n\n       Two special commands are defined: #include (which is deprecated and not supported by alternative implementations) and #clear.  #include will include the given file, unless the\n       filename ends in a slash, in which case the whole directory is included.  #clear is used to erase a part of the configuration tree. The specified element and all its descendants are\n       erased. (Note that these lines also need to end with a semicolon.)\n\n       The #clear command is the only way to delete a list or a complete scope. Reopening a scope (or using the syntax described below with an appended ::) will not override previously\n       written entries. Options can only be overridden by addressing a new value to them - lists and scopes can't be overridden, only cleared.\n\n       All of the APT tools take an -o option which allows an arbitrary configuration directive to be specified on the command line. The syntax is a full option name (APT::Get::Assume-Yes\n       for instance) followed by an equals sign then the new value of the option. To append a new element to a list, add a trailing :: to the name of the list. (As you might suspect, the\n       scope syntax can't be used on the command line.)\n\n       Note that appending items to a list using :: only works for one item per line, and that you should not use it in combination with the scope syntax (which adds :: implicitly). Using\n       both syntaxes together will trigger a bug which some users unfortunately depend on: an option with the unusual name \"::\" which acts like every other option with a name. This\n       introduces many problems; for one thing, users who write multiple lines in this wrong syntax in the hope of appending to a list will achieve the opposite, as only the last assignment\n       for this option \"::\" will be used. Future versions of APT will raise errors and stop working if they encounter this misuse, so please correct such statements now while APT doesn't\n       explicitly complain about them.\n\nTHE APT GROUP\n       This group of options controls general APT behavior as well as holding the options for all of the tools.\n\n       Architecture\n           System Architecture; sets the architecture to use when fetching files and parsing package lists. The internal default is the architecture apt was compiled for.\n\n       Architectures\n           All Architectures the system supports. For instance, CPUs implementing the amd64 (also called x86-64) instruction set are also able to execute binaries compiled for the i386 (x86)\n           instruction set. This list is used when fetching files and parsing package lists. The initial default is always the system's native architecture (APT::Architecture), and foreign\n           architectures are added to the default list when they are registered via dpkg --add-architecture.\n\n       Color\n           This scope defines colors and styles. The basic colors supported are red, green, yellow, blue, magenta, cyan, and white.\n\n           The subscope action defines the colors for package lists in install and similar commands. The following options may be set: APT::Color::Action::Upgrade,\n           APT::Color::Action::Install, APT::Color::Action::Install-Dependencies, APT::Color::Action::Downgrade, APT::Color::Action::Remove; corresponding to their lists in the apt(8)\n           output.\n\n           Each color may reference one or more other color options by name, relative to APT::Color. Their escape sequences will be combined.\n\n               APT::Color::Bold \"\\x1B[1m\";\n               APT::Color::Action::Install \"cyan\";\n               APT::Color::Action::Upgrade \"bold action::install\";\n\n           Colors may be turned on or off completely by setting APT::Color to yes or no, by utilizing NO_COLOR or APT_NO_COLOR environment variables, or using the --color, --no-color\n           command-line options.\n\n       Compressor\n           This scope defines which compression formats are supported, how compression and decompression can be performed if support for this format isn't built into apt directly and a\n           cost-value indicating how costly it is to compress something in this format. As an example the following configuration stanza would allow apt to download and uncompress as well as\n           create and store files with the low-cost .reversed file extension which it will pass to the command rev without additional commandline parameters for compression and\n           uncompression:\n\n               APT::Compressor::rev {\n                    Name \"rev\";\n                    Extension \".reversed\";\n                    Binary \"rev\";\n                    CompressArg {};\n                    UncompressArg {};\n                    Cost \"10\";\n               };\n\n       Build-Profiles\n           List of all build profiles enabled for build-dependency resolution, without the \"profile.\" namespace prefix. By default this list is empty. The DEB_BUILD_PROFILES as used by dpkg-\n           buildpackage(1) overrides the list notation.\n\n       Default-Release\n           Default release to install packages from if more than one version is available. Contains release name, codename or release version. Examples: 'stable', 'testing', 'unstable',\n           'trixie', 'forky', '4.0', '5.0*'. See also apt_preferences(5).\n\n       Snapshot\n           Snapshot to use for all repositories configured with Snapshot: yes. See also sources.list(5), the --snapshot option that sets this value, and Acquire::Snapshots::URI below.\n\n       Ignore-Hold\n           Ignore held packages; this global option causes the problem resolver to ignore held packages in its decision making.\n\n       Clean-Installed\n           Defaults to on. When turned on the autoclean feature will remove any packages which can no longer be downloaded from the cache. If turned off then packages that are locally\n           installed are also excluded from cleaning - but note that APT provides no direct means to reinstall them.\n\n       Immediate-Configure\n           Defaults to on, which will cause APT to install essential and important packages as soon as possible in an install/upgrade operation, in order to limit the effect of a failing\n           dpkg(1) call. If this option is disabled, APT treats an important package in the same way as an extra package: between the unpacking of the package A and its configuration there\n           can be many other unpack or configuration calls for other unrelated packages B, C etc. If these cause the dpkg(1) call to fail (e.g. because package B's maintainer scripts\n           generate an error), this results in a system state in which package A is unpacked but unconfigured - so any package depending on A is now no longer guaranteed to work, as its\n           dependency on A is no longer satisfied.\n\n           The immediate configuration marker is also applied in the potentially problematic case of circular dependencies, since a dependency with the immediate flag is equivalent to a\n           Pre-Dependency. In theory this allows APT to recognise a situation in which it is unable to perform immediate configuration, abort, and suggest to the user that the option should\n           be temporarily deactivated in order to allow the operation to proceed. Note the use of the word \"theory\" here; in the real world this problem has rarely been encountered, in\n           non-stable distribution versions, and was caused by wrong dependencies of the package in question or by a system in an already broken state; so you should not blindly disable this\n           option, as the scenario mentioned above is not the only problem it can help to prevent in the first place.\n\n           Before a big operation like dist-upgrade is run with this option disabled you should try to explicitly install the package APT is unable to configure immediately; but please make\n           sure you also report your problem to your distribution and to the APT team with the bug link below, so they can work on improving or correcting the upgrade process.\n\n       Force-LoopBreak\n           Never enable this option unless you really know what you are doing. It permits APT to temporarily remove an essential package to break a Conflicts/Conflicts or\n           Conflicts/Pre-Depends loop between two essential packages.  Such a loop should never exist and is a grave bug. This option will work if the essential packages are not tar, gzip,\n           libc, dpkg, dash or anything that those packages depend on.\n\n       Cache-Start, Cache-Grow, Cache-Limit\n           APT uses since version 0.7.26 a resizable memory mapped cache file to store the available information.  Cache-Start acts as a hint of the size the cache will grow to, and is\n           therefore the amount of memory APT will request at startup. The default value is 20971520 bytes (~20 MB). Note that this amount of space needs to be available for APT; otherwise\n           it will likely fail ungracefully, so for memory restricted devices this value should be lowered while on systems with a lot of configured sources it should be increased.\n           Cache-Grow defines in bytes with the default of 1048576 (~1 MB) how much the cache size will be increased in the event the space defined by Cache-Start is not enough. This value\n           will be applied again and again until either the cache is big enough to store all information or the size of the cache reaches the Cache-Limit. The default of Cache-Limit is 0\n           which stands for no limit. If Cache-Grow is set to 0 the automatic growth of the cache is disabled.\n\n       Build-Essential\n           Defines which packages are considered essential build dependencies.\n\n       Get\n           The Get subsection controls the apt-get(8) tool; please see its documentation for more information about the options here.\n\n       Cache\n           The Cache subsection controls the apt-cache(8) tool; please see its documentation for more information about the options here.\n\n       CDROM\n           The CDROM subsection controls the apt-cdrom(8) tool; please see its documentation for more information about the options here.\n\n       NeverAutoRemove\n           Never autoremove packages that match the regular expression(s).\n\n       Protect-Kernels\n           This option tells apt autoremove that kernels are protected and defaults to true. In case kernels are not protected they are treated as any other package.\n\n       VersionedKernelPackages\n           Define the regular expression(s) for versioned kernel packages. Based on these expressions a rule set is injected into apt similar to APT::NeverAutoRemove regular expressions.\n\n       NeverAutoRemove::KernelCount\n           Keep a custom amount of kernels when autoremoving and defaults to 2, meaning two kernels are kept. Apt will always keep the running kernel and the latest one. If the latest kernel\n           is the same as the running kernel, the second latest kernel is kept. Because of this, any value lower than 2 will be ignored. If you want only the latest kernel, you should set\n           APT::Protect-Kernels to false.\n\nTHE ACQUIRE GROUP\n       The Acquire group of options controls the download of packages as well as the various \"acquire methods\" responsible for the download itself (see also sources.list(5)).\n\n       Check-Date\n           Security related option defaulting to true, enabling time-related checks. Disabling it means that the machine's time cannot be trusted, and APT will hence disable all time-related\n           checks, such as Check-Valid-Until and verifying that the Date field of a release file is not in the future.\n\n       Max-FutureTime\n           Maximum time (in seconds) before its creation (as indicated by the Date header) that the Release file should be considered valid. The default value is 10. Archive specific\n           settings can be made by appending the label of the archive to the option name. Preferably, the same can be achieved for specific sources.list(5) entries by using the\n           Date-Max-Future option there.\n\n       Check-Valid-Until\n           Security related option defaulting to true, as giving a Release file's validation an expiration date prevents replay attacks over a long timescale, and can also for example help\n           users to identify mirrors that are no longer updated - but the feature depends on the correctness of the clock on the user system. Archive maintainers are encouraged to create\n           Release files with the Valid-Until header, but if they don't or a stricter value is desired the Max-ValidTime option below can be used. The Check-Valid-Until option of\n           sources.list(5) entries should be preferred to disable the check selectively instead of using this global override.\n\n       Max-ValidTime\n           Maximum time (in seconds) after its creation (as indicated by the Date header) that the Release file should be considered valid. If the Release file itself includes a Valid-Until\n           header the earlier date of the two is used as the expiration date. The default value is 0 which stands for \"valid forever\". Archive specific settings can be made by appending the\n           label of the archive to the option name. Preferably, the same can be achieved for specific sources.list(5) entries by using the Valid-Until-Max option there.\n\n       Min-ValidTime\n           Minimum time (in seconds) after its creation (as indicated by the Date header) that the Release file should be considered valid. Use this if you need to use a seldom updated\n           (local) mirror of a more frequently updated archive with a Valid-Until header instead of completely disabling the expiration date checking. Archive specific settings can and\n           should be used by appending the label of the archive to the option name. Preferably, the same can be achieved for specific sources.list(5) entries by using the Valid-Until-Min\n           option there.\n\n       AllowTLS\n           Allow use of the internal TLS support in the http method. If set to false, this completely disables support for TLS in apt's own methods (excluding the curl-based https method).\n           No TLS-related functions will be called anymore.\n\n       PDiffs\n           Try to download deltas called PDiffs for indexes (like Packages files) instead of downloading whole ones. True by default. Preferably, this can be set for specific sources.list(5)\n           entries or index files by using the PDiffs option there.\n\n           Two sub-options to limit the use of PDiffs are also available: FileLimit can be used to specify a maximum number of PDiff files should be downloaded to update a file.  SizeLimit\n           on the other hand is the maximum percentage of the size of all patches compared to the size of the targeted file. If one of these limits is exceeded the complete file is\n           downloaded instead of the patches.\n\n       By-Hash\n           Try to download indexes via an URI constructed from a hashsum of the expected file rather than downloaded via a well-known stable filename. True by default, but automatically\n           disabled if the source indicates no support for it. Usage can be forced with the special value \"force\". Preferably, this can be set for specific sources.list(5) entries or index\n           files by using the By-Hash option there.\n\n       Queue-Mode\n           Queuing mode; Queue-Mode can be one of host or access which determines how APT parallelizes outgoing connections.  host means that one connection per target host will be opened,\n           access means that one connection per URI type will be opened.\n\n       Retries\n           Number of retries to perform. If this is non-zero APT will retry failed files the given number of times.\n\n       Source-Symlinks\n           Use symlinks for source archives. If set to true then source archives will be symlinked when possible instead of copying. True is the default.\n\n       http https\n           The options in these scopes configure APT's acquire transports for the protocols HTTP and HTTPS and are documented in the apt-transport-http(1) and apt-transport-https(1) manpages\n           respectively.\n\n       cdrom\n           For URIs using the cdrom method, the only configurable option is the mount point, cdrom::Mount, which must be the mount point for the CD-ROM (or DVD, or whatever) drive as\n           specified in /etc/fstab. It is possible to provide alternate mount and unmount commands if your mount point cannot be listed in the fstab. The syntax is to put\n\n               /cdrom/::Mount \"foo\";\n\n           within the cdrom block. It is important to have the trailing slash. Unmount commands can be specified using UMount.\n\n       gpgv\n           For GPGV URIs the only configurable option is gpgv::Options, which passes additional parameters to gpgv.\n\n       CompressionTypes\n           List of compression types which are understood by the acquire methods. Files like Packages can be available in various compression formats. By default the acquire methods can\n           decompress and recompress many common formats like xz and gzip; with this scope the supported formats can be queried, modified as well as support for more formats added (see also\n           APT::Compressor). The syntax for this is:\n\n               Acquire::CompressionTypes::FileExtension \"Methodname\";\n\n           Also, the Order subgroup can be used to define in which order the acquire system will try to download the compressed files. The acquire system will try the first and proceed with\n           the next compression type in this list on error, so to prefer one over the other type simply add the preferred type first - types not already added will be implicitly appended to\n           the end of the list, so e.g.\n\n               Acquire::CompressionTypes::Order:: \"gz\";\n\n           can be used to prefer gzip compressed files over all other compression formats. If xz should be preferred over gzip and bzip2 the configure setting should look like this:\n\n               Acquire::CompressionTypes::Order { \"xz\"; \"gz\"; };\n\n           It is not needed to add bz2 to the list explicitly as it will be added automatically.\n\n           Note that the Dir::Bin::Methodname will be checked at run time. If this option has been set and support for this format isn't directly built into apt, the method will only be used\n           if this file exists; e.g. for the bzip2 method (the inbuilt) setting is:\n\n               Dir::Bin::bzip2 \"/bin/bzip2\";\n\n           Note also that list entries specified on the command line will be added at the end of the list specified in the configuration files, but before the default entries. To prefer a\n           type in this case over the ones specified in the configuration files you can set the option direct - not in list style. This will not override the defined list; it will only\n           prefix the list with this type.\n\n           The special type uncompressed can be used to give uncompressed files a preference, but note that most archives don't provide uncompressed files so this is mostly only usable for\n           local mirrors.\n\n       GzipIndexes\n           When downloading gzip compressed indexes (Packages, Sources, or Translations), keep them gzip compressed locally instead of unpacking them. This saves quite a lot of disk space at\n           the expense of more CPU requirements when building the local package caches. False by default.\n\n       Languages\n           The Languages subsection controls which Translation files are downloaded and in which order APT tries to display the description-translations. APT will try to display the first\n           available description in the language which is listed first. Languages can be defined with their short or long language codes. Note that not all archives provide Translation files\n           for every language - the long language codes are especially rare.\n\n           The default list includes \"environment\" and \"en\". \"environment\" has a special meaning here: it will be replaced at runtime with the language codes extracted from the LC_MESSAGES\n           environment variable. It will also ensure that these codes are not included twice in the list. If LC_MESSAGES is set to \"C\" only the Translation-en file (if available) will be\n           used. To force APT to use no Translation file use the setting Acquire::Languages=none. \"none\" is another special meaning code which will stop the search for a suitable Translation\n           file. This tells APT to download these translations too, without actually using them unless the environment specifies the languages. So the following example configuration will\n           result in the order \"en, de\" in an English locale or \"de, en\" in a German one. Note that \"fr\" is downloaded, but not used unless APT is used in a French locale (where the order\n           would be \"fr, de, en\").\n\n               Acquire::Languages { \"environment\"; \"de\"; \"en\"; \"none\"; \"fr\"; };\n\n           Note: To prevent problems resulting from APT being executed in different environments (e.g. by different users or by other programs) all Translation files which are found in\n           /var/lib/apt/lists/ will be added to the end of the list (after an implicit \"none\").\n\n       ForceIPv4\n           When downloading, force to use only the IPv4 protocol.\n\n       ForceIPv6\n           When downloading, force to use only the IPv6 protocol.\n\n       MaxReleaseFileSize\n           The maximum file size of Release/Release.gpg/InRelease files. The default is 10MB.\n\n       EnableSrvRecords\n           This option controls if apt will use the DNS SRV server record as specified in RFC 2782 to select an alternative server to connect to. The default is \"true\".\n\n       AllowInsecureRepositories\n           Allow update operations to load data files from repositories without sufficient security information. The default value is \"false\". Concept, implications as well as alternatives\n           are detailed in apt-secure(8).\n\n       AllowWeakRepositories\n           Allow update operations to load data files from repositories which provide security information, but these are deemed no longer cryptographically strong enough. The default value\n           is \"false\". Concept, implications as well as alternatives are detailed in apt-secure(8).\n\n       AllowDowngradeToInsecureRepositories\n           Allow that a repository that was previously gpg signed to become unsigned during an update operation. When there is no valid signature for a previously trusted repository apt will\n           refuse the update. This option can be used to override this protection. You almost certainly never want to enable this. The default is false. Concept, implications as well as\n           alternatives are detailed in apt-secure(8).\n\n       Changelogs::URI scope\n           Acquiring changelogs can only be done if an URI is known from where to get them. Preferable the Release file indicates this in a 'Changelogs' field. If this isn't available the\n           Label/Origin field of the Release file is used to check if a Acquire::Changelogs::URI::Label::LABEL or Acquire::Changelogs::URI::Origin::ORIGIN option exists and if so this value\n           is taken. The value in the Release file can be overridden with Acquire::Changelogs::URI::Override::Label::LABEL or Acquire::Changelogs::URI::Override::Origin::ORIGIN. The value\n           should be a normal URI to a text file, except that package specific data is replaced with the placeholder @CHANGEPATH@. The value for it is: 1. if the package is from a component\n           (e.g.  main) this is the first part otherwise it is omitted, 2. the first letter of source package name, except if the source package name starts with 'lib' in which case it will\n           be the first four letters. 3. The complete source package name. 4. the complete name again and 5. the source version. The first (if present), second, third and fourth part are\n           separated by a slash ('/') and between the fourth and fifth part is an underscore ('_'). The special value 'no' is available for this option indicating that this source can't be\n           used to acquire changelog files from. Another source will be tried if available in this case.\n\n       Snapshots::URI scope\n           Like changelogs, snapshots can only be acquired if an URI is known from where to get them. Preferable the Release file indicates this in a 'Snapshots' field. If this isn't\n           available the Label/Origin field of the Release file is used to check if a Acquire::Snapshots::URI::Label::LABEL or Acquire::Snapshots::URI::Origin::ORIGIN option exists and if so\n           this value is taken. The value in the Release file can be overridden with Acquire::Snapshots::URI::Override::Label::LABEL or Acquire::Snapshots::URI::Override::Origin::ORIGIN. The\n           value should be a normal URI to a directory, except that the snapshot ID replaced with the placeholder @SNAPSHOTID@. The special value 'no' is available for this option indicating\n           that this source cannot be used to acquire snapshots from. Another source will be tried if available in this case.\n\nBINARY SPECIFIC CONFIGURATION\n       Especially with the introduction of the apt binary it can be useful to set certain options only for a specific binary as even options which look like they would effect only a certain\n       binary like APT::Get::Show-Versions effect apt-get as well as apt.\n\n       Setting an option for a specific binary only can be achieved by setting the option inside the Binary::specific-binary scope. Setting the option APT::Get::Show-Versions for the apt\n       only can e.g. by done by setting Binary::apt::APT::Get::Show-Versions instead.\n\n       Note that as seen in the DESCRIPTION section further above you can't set binary-specific options on the commandline itself nor in configuration files loaded via the commandline.\n\nDIRECTORIES\n       The Dir::State section has directories that pertain to local state information.  lists is the directory to place downloaded package lists in and status is the name of the dpkg(1)\n       status file.  preferences is the name of the APT preferences file.  Dir::State contains the default directory to prefix on all sub-items if they do not start with / or ./.\n\n       Dir::Cache contains locations pertaining to local cache information, such as the two package caches srcpkgcache and pkgcache as well as the location to place downloaded archives,\n       Dir::Cache::archives. Generation of caches can be turned off by setting pkgcache or srcpkgcache to \"\". This will slow down startup but save disk space. It is probably preferable to\n       turn off the pkgcache rather than the srcpkgcache. Like Dir::State the default directory is contained in Dir::Cache\n\n       Dir::Etc contains the location of configuration files, sourcelist gives the location of the sourcelist and main is the default configuration file (setting has no effect, unless it is\n       done from the config file specified by APT_CONFIG).\n\n       The Dir::Parts setting reads in all the config fragments in lexical order from the directory specified. After this is done then the main config file is loaded.\n\n       Binary programs are pointed to by Dir::Bin.  Dir::Bin::Methods specifies the location of the method handlers and gzip, bzip2, lzma, dpkg, apt-get dpkg-source dpkg-buildpackage and\n       apt-cache specify the location of the respective programs.\n\n       The configuration item RootDir has a special meaning. If set, all paths will be relative to RootDir, even paths that are specified absolutely. So, for instance, if RootDir is set to\n       /tmp/staging and Dir::State::status is set to /var/lib/dpkg/status, then the status file will be looked up in /tmp/staging/var/lib/dpkg/status. If you want to prefix only relative\n       paths, set Dir instead.\n\n       The Ignore-Files-Silently list can be used to specify which files APT should silently ignore while parsing the files in the fragment directories. Per default a file which ends with\n       .disabled, ~, .bak or .dpkg-[a-z]+ is silently ignored. As seen in the last default value these patterns can use regular expression syntax.\n\nAPT IN DSELECT\n       When APT is used as a dselect(1) method several configuration directives control the default behavior. These are in the DSelect section.\n\n       Clean\n           Cache Clean mode; this value may be one of always, prompt, auto, pre-auto and never.  always and prompt will remove all packages from the cache after upgrading, prompt (the\n           default) does so conditionally.  auto removes only those packages which are no longer downloadable (replaced with a new version for instance).  pre-auto performs this action\n           before downloading new packages.\n\n       options\n           The contents of this variable are passed to apt-get(8) as command line options when it is run for the install phase.\n\n       Updateoptions\n           The contents of this variable are passed to apt-get(8) as command line options when it is run for the update phase.\n\n       PromptAfterUpdate\n           If true the [U]pdate operation in dselect(1) will always prompt to continue. The default is to prompt only on error.\n\nHOW APT CALLS DPKG(1)\n       Several configuration directives control how APT invokes dpkg(1). These are in the DPkg section.\n\n       options\n           This is a list of options to pass to dpkg(1). The options must be specified using the list notation and each list item is passed as a single argument to dpkg(1).\n\n       Path\n           This is a string that defines the PATH environment variable used when running dpkg. It may be set to any valid value of that environment variable; or the empty string, in which\n           case the variable is not changed.\n\n       Pre-Invoke, Post-Invoke\n           This is a list of shell commands to run before/after invoking dpkg(1). Like options this must be specified in list notation. The commands are invoked in order using /bin/sh;\n           should any fail APT will abort.\n\n       Pre-Install-Pkgs\n           This is a list of shell commands to run before invoking dpkg(1). Like options this must be specified in list notation. The commands are invoked in order using /bin/sh; should any\n           fail APT will abort. APT will pass the filenames of all .deb files it is going to install to the commands, one per line on the requested file descriptor, defaulting to standard\n           input.\n\n           Version 2 of this protocol sends more information through the requested file descriptor: a line with the text VERSION 2, the APT configuration space, and a list of package actions\n           with filename and version information.\n\n           Each configuration directive line has the form key=value. Special characters (equal signs, newlines, nonprintable characters, quotation marks, and percent signs in key and\n           newlines, nonprintable characters, and percent signs in value) are %-encoded. Lists are represented by multiple key::=value lines with the same key. The configuration section ends\n           with a blank line.\n\n           Package action lines consist of five fields in Version 2: package name (without architecture qualification even if foreign), old version, direction of version change (  for downgrades, = for no change), new version, action. The version fields are \"-\" for no version at all (for example when installing a package for the first time; no\n           version is treated as earlier than any real version, so that is an upgrade, indicated as - < 1.23.4). The action field is \"**CONFIGURE**\" if the package is being configured,\n           \"**REMOVE**\" if it is being removed, or the filename of a .deb file if it is being unpacked.\n\n           In Version 3 after each version field follows the architecture of this version, which is \"-\" if there is no version, and a field showing the MultiArch type \"same\", \"foreign\",\n           \"allowed\" or \"none\". Note that \"none\" is an incorrect typename which is just kept to remain compatible, it should be read as \"no\" and users are encouraged to support both.\n\n           The version of the protocol to be used for the command cmd can be chosen by setting DPkg::Tools::options::cmd::Version accordingly, the default being version 1. If APT isn't\n           supporting the requested version it will send the information in the highest version it has support for instead.\n\n           The file descriptor to be used to send the information can be requested with DPkg::Tools::options::cmd::InfoFD which defaults to 0 for standard input and is available since\n           version 0.9.11. Support for the option can be detected by looking for the environment variable APT_HOOK_INFO_FD which contains the number of the used file descriptor as a\n           confirmation.\n\n       Run-Directory\n           APT chdirs to this directory before invoking dpkg(1), the default is /.\n\n       Build-options\n           These options are passed to dpkg-buildpackage(1) when compiling packages; the default is to disable signing and produce all binaries.\n\n       DPkg::ConfigurePending\n           If this option is set APT will call dpkg --configure --pending to let dpkg(1) handle all required configurations and triggers. This option is activated by default, but\n           deactivating it could be useful if you want to run APT multiple times in a row - e.g. in an installer. In this scenario you could deactivate this option in all but the last run.\n\nPERIODIC AND ARCHIVES OPTIONS\n       APT::Periodic and APT::Archives groups of options configure behavior of apt periodic updates, which is done by the /usr/lib/apt/apt.systemd.daily script. See the top of this script\n       for the brief documentation of these options.\n\nDEBUG OPTIONS\n       Enabling options in the Debug:: section will cause debugging information to be sent to the standard error stream of the program utilizing the apt libraries, or enable special program\n       modes that are primarily useful for debugging the behavior of apt. Most of these options are not interesting to a normal user, but a few may be:\n\n       •   Debug::pkgProblemResolver enables output about the decisions made by dist-upgrade, upgrade, install, remove, purge.\n\n       •   Debug::NoLocking disables all file locking. This can be used to run some operations (for instance, apt-get -s install) as a non-root user.\n\n       •   Debug::pkgDPkgPM prints out the actual command line each time that apt invokes dpkg(1).\n\n       •   Debug::IdentCdrom disables the inclusion of statfs data in CD-ROM IDs.\n\n       A full list of debugging options to apt follows.\n\n       Debug::Acquire::cdrom\n           Print information related to accessing cdrom:// sources.\n\n       Debug::Acquire::http\n           Print information related to downloading packages using HTTP.\n\n       Debug::Acquire::https\n           Print information related to downloading packages using HTTPS.\n\n       Debug::Acquire::gpgv\n           Print information related to verifying cryptographic signatures using gpg.\n\n       Debug::aptcdrom\n           Output information about the process of accessing collections of packages stored on CD-ROMs.\n\n       Debug::Hashes\n           Output each cryptographic hash that is generated by the apt libraries.\n\n       Debug::IdentCDROM\n           Do not include information from statfs, namely the number of used and free blocks on the CD-ROM filesystem, when generating an ID for a CD-ROM.\n\n       Debug::NoLocking\n           Disable all file locking. For instance, this will allow two instances of “apt-get update” to run at the same time.\n\n       Debug::pkgAcquire\n           Log when items are added to or removed from the global download queue.\n\n       Debug::pkgAcquire::Auth\n           Output status messages and errors related to verifying checksums and cryptographic signatures of downloaded files.\n\n       Debug::pkgAcquire::Diffs\n           Output information about downloading and applying package index list diffs, and errors relating to package index list diffs.\n\n       Debug::pkgAcquire::RRed\n           Output information related to patching apt package lists when downloading index diffs instead of full indices.\n\n       Debug::pkgAcquire::Worker\n           Log all interactions with the sub-processes that actually perform downloads.\n\n       Debug::pkgAutoRemove\n           Log events related to the automatically-installed status of packages and to the removal of unused packages.\n\n       Debug::pkgDepCache::AutoInstall\n           Generate debug messages describing which packages are being automatically installed to resolve dependencies. This corresponds to the initial auto-install pass performed in, e.g.,\n           apt-get install, and not to the full apt dependency resolver; see Debug::pkgProblemResolver for that.\n\n       Debug::pkgDepCache::Marker\n           Generate debug messages describing which packages are marked as keep/install/remove while the ProblemResolver does his work. Each addition or deletion may trigger additional\n           actions; they are shown indented two additional spaces under the original entry. The format for each line is MarkKeep, MarkDelete or MarkInstall followed by package-name  \n           d.e.f | x.y.z> (section) where a.b.c is the current version of the package, d.e.f is the version considered for installation and x.y.z is a newer version, but not considered for\n           installation (because of a low pin score). The later two can be omitted if there is none or if it is the same as the installed version.  section is the name of the section the\n           package appears in.\n\n       Debug::pkgDPkgPM\n           When invoking dpkg(1), output the precise command line with which it is being invoked, with arguments separated by a single space character.\n\n       Debug::pkgDPkgProgressReporting\n           Output all the data received from dpkg(1) on the status file descriptor and any errors encountered while parsing it.\n\n       Debug::pkgOrderList\n           Generate a trace of the algorithm that decides the order in which apt should pass packages to dpkg(1).\n\n       Debug::pkgPackageManager\n           Output status messages tracing the steps performed when invoking dpkg(1).\n\n       Debug::pkgPolicy\n           Output the priority of each package list on startup.\n\n       Debug::pkgProblemResolver\n           Trace the execution of the dependency resolver (this applies only to what happens when a complex dependency problem is encountered).\n\n       Debug::pkgProblemResolver::ShowScores\n           Display a list of all installed packages with their calculated score used by the pkgProblemResolver. The description of the package is the same as described in\n           Debug::pkgDepCache::Marker\n\n       Debug::sourceList\n           Print information about the vendors read from /etc/apt/vendors.list.\n\n       Debug::RunScripts\n           Display the external commands that are called by apt hooks. This includes e.g. the config options DPkg::{Pre,Post}-Invoke or APT::Update::{Pre,Post}-Invoke.\n\nEXAMPLES\n       /usr/share/doc/apt/examples/configure-index is a configuration file showing example values for all possible options.\n\nFILES\n       /etc/apt/apt.conf\n           APT configuration file. Configuration Item: Dir::Etc::Main.\n\n       /etc/apt/apt.conf.d/\n           APT configuration file fragments. Configuration Item: Dir::Etc::Parts.\n\nSEE ALSO\n       apt-cache(8), apt-config(8), apt_preferences(5).\n\nBUGS\n       APT bug page[1]. If you wish to report a bug in APT, please see /usr/share/doc/debian/bug-reporting.txt or the reportbug(1) command.\n\nAUTHORS\n       Jason Gunthorpe\n\n       APT team\n\n       Daniel Burrows  \n           Initial documentation of Debug::*.\n\nNOTES\n        1. APT bug page\n           https://bugs.debian.org/src:apt\n\nAPT 3.0.3                                                                               05 January 2025                                                                            APT.CONF(5)","ref":"apt-conf.html"},{"type":"extras","title":"apt_preferences","doc":"APT_PREFERENCES(5)                                                                            APT                                                                           APT_PREFERENCES(5)\n\nNAME\n       apt_preferences - Preference control file for APT\n\nDESCRIPTION\n       The APT preferences file /etc/apt/preferences and the fragment files in the /etc/apt/preferences.d/ folder can be used to control which versions of packages will be selected for\n       installation.\n\n       Several versions of a package may be available for installation when the sources.list(5) file contains references to more than one distribution (for example, stable and testing). APT\n       assigns a priority to each version that is available. Subject to dependency constraints, apt-get selects the version with the highest priority for installation. The APT preferences\n       override the priorities that APT assigns to package versions by default, thus giving the user control over which one is selected for installation.\n\n       Several instances of the same version of a package may be available when the sources.list(5) file contains references to more than one source. In this case apt-get downloads the\n       instance listed earliest in the sources.list(5) file. The APT preferences do not affect the choice of instance, only the choice of version.\n\n       Preferences are a strong power in the hands of a system administrator but they can become also their biggest nightmare if used without care! APT will not question the preferences, so\n       wrong settings can lead to uninstallable packages or wrong decisions while upgrading packages. Even more problems will arise if multiple distribution releases are mixed without a good\n       understanding of the following paragraphs. Packages included in a specific release aren't tested in (and therefore don't always work as expected in) older or newer releases, or\n       together with other packages from different releases. You have been warned.\n\n       Note that the files in the /etc/apt/preferences.d directory are parsed in alphanumeric ascending order and need to obey the following naming convention: The files have either no or\n       \"pref\" as filename extension and only contain alphanumeric, hyphen (-), underscore (_) and period (.) characters. Otherwise APT will print a notice that it has ignored a file, unless\n       that file matches a pattern in the Dir::Ignore-Files-Silently configuration list - in which case it will be silently ignored.\n\n   APT's Default Priority Assignments\n       If there is no preferences file or if there is no entry in the file that applies to a particular version then the priority assigned to that version is the priority of the distribution\n       to which that version belongs. It is possible to single out a distribution, \"the target release\", which receives a higher priority than other distributions do by default. The target\n       release can be set on the apt-get command line or in the APT configuration file /etc/apt/apt.conf. Note that this has precedence over any general priority you set in the\n       /etc/apt/preferences file described later, but not over specifically pinned packages. For example,\n\n           apt-get install -t testing some-package\n\n           APT::Default-Release \"stable\";\n\n       If the target release has been specified then APT uses the following algorithm to set the priorities of the versions of a package. Assign:\n\n       priority 1\n           to the versions coming from archives which in their Release files are marked as \"NotAutomatic: yes\" but not as \"ButAutomaticUpgrades: yes\" like the Debian experimental archive, as\n           well as versions that are not phased on this systems.\n\n       priority 100\n           to the version that is already installed (if any) and to the versions coming from archives which in their Release files are marked as \"NotAutomatic: yes\" and\n           \"ButAutomaticUpgrades: yes\" like the Debian backports archive since squeeze-backports.\n\n       priority 500\n           to the versions that do not belong to the target release.\n\n       priority 990\n           to the versions that belong to the target release.\n       The highest of those priorities whose description matches the version is assigned to the version.\n\n       If the target release has not been specified then APT simply assigns priority 100 to all installed package versions and priority 500 to all uninstalled package versions, except\n       versions coming from archives which in their Release files are marked as \"NotAutomatic: yes\" - these versions get the priority 1 or priority 100 if it is additionally marked as\n       \"ButAutomaticUpgrades: yes\".\n\n       APT then applies the following rules, listed in order of precedence, to determine which version of a package to install.\n\n       •   Never downgrade unless the priority of an available version exceeds 1000. (\"Downgrading\" is installing a less recent version of a package in place of a more recent version. Note\n           that none of APT's default priorities exceeds 1000; such high priorities can only be set in the preferences file. Note also that downgrading a package can be risky.)\n\n       •   Install the highest priority version.\n\n       •   If two or more versions have the same priority, install the most recent one (that is, the one with the higher version number).\n\n       •   If two or more versions have the same priority and version number but either the packages differ in some of their metadata or the --reinstall option is given, install the\n           uninstalled one.\n\n       In a typical situation, the installed version of a package (priority 100) is not as recent as one of the versions available from the sources listed in the sources.list(5) file\n       (priority 500 or 990). Then the package will be upgraded when apt-get install some-package or apt-get upgrade is executed.\n\n       More rarely, the installed version of a package is more recent than any of the other available versions. The package will not be downgraded when apt-get install some-package or\n       apt-get upgrade is executed.\n\n       Sometimes the installed version of a package is more recent than the version belonging to the target release, but not as recent as a version belonging to some other distribution. Such\n       a package will indeed be upgraded when apt-get install some-package or apt-get upgrade is executed, because at least one of the available versions has a higher priority than the\n       installed version.\n\n   Phased Updates\n       APT understands a field called Phased-Update-Percentage which can be used to control the rollout of a new version. It is an integer between 0 and 100.\n\n       A system's eligibility to a phased update is determined by seeding random number generator with the package source name, the version number, and /etc/machine-id, and then calculating\n       an integer in the range [0, 100]. If this integer is larger than the Phased-Update-Percentage, the version is pinned to 1, and thus held back. Otherwise, normal policy rules apply.\n\n       In case you have multiple systems that you want to receive the same set of updates, you can set APT::Machine-ID to a UUID such that they all phase the same, or set\n       APT::Get::Never-Include-Phased-Updates or APT::Get::Always-Include-Phased-Updates to true such that APT will never/always consider phased updates.\n\n   The Effect of APT Preferences\n       The APT preferences file allows the system administrator to control the assignment of priorities. The file consists of one or more multi-line records separated by blank lines. Records\n       can have one of two forms, a specific form and a general form.\n\n       •   The specific form assigns a priority (a \"Pin-Priority\") to one or more specified packages with a specified version or version range. For example, the following record assigns a\n           high priority to all versions of the perl package whose version number begins with \"5.32\". Multiple packages can be separated by spaces.\n\n               Package: perl\n               Pin: version 5.32*\n               Pin-Priority: 1001\n\n           Since 2.9.9, you can also pin by a source version:\n\n               Package: perl\n               Pin: source-version 5.32*\n               Pin-Priority: 1001\n\n       •   The general form assigns a priority to all of the package versions in a given distribution (that is, to all the versions of packages that are listed in a certain Release file) or\n           to all of the package versions coming from a particular Internet site, as identified by the site's fully qualified domain name.\n\n           This general-form entry in the APT preferences file applies only to groups of packages. For example, the following record assigns a high priority to all package versions available\n           from the local site.\n\n               Package: *\n               Pin: origin \"\"\n               Pin-Priority: 999\n\n           A note of caution: the keyword used here is \"origin\" which can be used to match a hostname. The following record will assign a high priority to all versions available from the\n           server identified by the hostname \"ftp.de.debian.org\"\n\n               Package: *\n               Pin: origin \"ftp.de.debian.org\"\n               Pin-Priority: 999\n\n           This should not be confused with the Origin of a distribution as specified in a Release file. What follows the \"Origin:\" tag in a Release file is not an Internet address but an\n           author or vendor name, such as \"Debian\" or \"Ximian\".\n\n           The following record assigns a low priority to all package versions belonging to any distribution whose Archive name is \"unstable\".\n\n               Package: *\n               Pin: release a=unstable\n               Pin-Priority: 50\n\n           The following record assigns a high priority to all package versions belonging to any distribution whose Codename is \"forky\".\n\n               Package: *\n               Pin: release n=forky\n               Pin-Priority: 900\n\n           The following record assigns a high priority to all package versions belonging to any release whose Archive name is \"stable\" and whose release Version number is \"13\".\n\n               Package: *\n               Pin: release a=stable, v=13\n               Pin-Priority: 500\n\n       The effect of the comma operator is similar to an \"and\" in logic: All conditions must be satisfied for the pin to match. There is one exception: For any type of condition (such as two\n       \"a\" conditions), only the last such condition is checked.\n\n   Matching packages in the Package field\n       The Package field specifies the package that a pinning priority is applied to. The field can either contain a binary package name, a source package name (prefixed with \"src:\"), a\n       glob(7) expression or a regular expression (surrounded by slashes). Multiple package names, glob(7) expressions and regular expressions can be listed separated by whitespace in which\n       case the record will match any of the matched packages.\n\n       By default, only packages of the native architecture are matched. To match binary packages of any architecture, add the :any suffix to the package name. You can also limit matching to\n       a specific architecture by appending the architecture name to the package name, separated by a colon character.\n\n       For example, the following example uses a glob expression and a regular expression to assign the priority 500 to all packages from experimental where the name starts with gnome (as a\n       glob(7)-like expression) or contains the word kde (as a POSIX extended regular expression surrounded by slashes).\n\n           Package: gnome* /kde/\n           Pin: release a=experimental\n           Pin-Priority: 500\n\n       The rule for those expressions is that they can occur anywhere where a string can occur. Thus, the following pin assigns the priority 990 to all packages from a release starting with\n       plucky.\n\n           Package: *\n           Pin: release n=plucky*\n           Pin-Priority: 990\n\n       If a regular expression occurs in a Package field, the behavior is the same as if this regular expression were replaced with a list of all package names it matches. It is undecided\n       whether this will change in the future; thus you should always list wild-card pins first, so later specific pins override it. The pattern \"*\" in a Package field is not considered a\n       glob(7) expression in itself.\n\n       To pin all binaries produced by the apt source package of this APT's version to 990, you can do:\n\n           Package: src:apt\n           Pin: version 3.0.3\n           Pin-Priority: 990\n\n       Source package pinning can be combined with regular expressions and glob patterns, and can also take a binary architecture.\n\n       For example, let's pin all binaries for all architectures produced by any source package containing apt in its name to 990:\n\n           Package: src:*apt*:any\n           Pin: version *\n           Pin-Priority: 990\n\n       The :any suffix makes sure to select binary packages from any architecture. Without that suffix, apt implicitly assumes the :native suffix which would only select packages from the\n       native architecture.\n\n   How APT Interprets Priorities\n       Priorities (P) assigned in the APT preferences file must be positive or negative integers. They are interpreted as follows (roughly speaking):\n\n       P >= 1000\n           causes a version to be installed even if this constitutes a downgrade of the package\n\n       990 <= P < 1000\n           causes a version to be installed even if it does not come from the target release, unless the installed version is more recent\n\n       500 <= P < 990\n           causes a version to be installed unless there is a version available belonging to the target release or the installed version is more recent\n\n       100 <= P < 500\n           causes a version to be installed unless there is a version available belonging to some other distribution or the installed version is more recent\n\n       0 < P < 100\n           causes a version to be installed only if there is no installed version of the package\n\n       P < 0\n           prevents the version from being installed\n\n       P = 0\n           has undefined behaviour, do not use it.\n\n       The first specific-form record matching an available package version determines the priority of the package version. Failing that, the priority of the package is defined as the\n       maximum of all priorities defined by generic-form records matching the version. Records defined using patterns in the Pin field other than \"*\" are treated like specific-form records.\n\n       For example, suppose the APT preferences file contains the three records presented earlier:\n\n           Package: perl\n           Pin: version 5.32*\n           Pin-Priority: 1001\n\n           Package: *\n           Pin: origin \"\"\n           Pin-Priority: 999\n\n           Package: *\n           Pin: release unstable\n           Pin-Priority: 50\n\n       Then:\n\n       •   The most recent available version of the perl package will be installed, so long as that version's version number begins with \"5.32\". If any 5.32* version of perl is available and\n           the installed version is 5.36*, then perl will be downgraded.\n\n       •   A version of any package other than perl that is available from the local system has priority over other versions, even versions belonging to the target release.\n\n       •   A version of a package whose origin is not the local system but some other site listed in sources.list(5) and which belongs to an unstable distribution is only installed if it is\n           selected for installation and no version of the package is already installed.\n\n   Determination of Package Version and Distribution Properties\n       The locations listed in the sources.list(5) file should provide Packages and Release files to describe the packages available at that location.\n\n       The Packages file is normally found in the directory .../dists/dist-name/component/arch: for example, .../dists/stable/main/binary-i386/Packages. It consists of a series of multi-line\n       records, one for each package available in that directory. Only two lines in each record are relevant for setting APT priorities:\n\n       the Package: line\n           gives the package name\n\n       the Version: line\n           gives the version number for the named package\n\n       The Release file is normally found in the directory .../dists/dist-name: for example, .../dists/stable/Release, or .../dists/trixie/Release. It consists of a single multi-line record\n       which applies to all of the packages in the directory tree below its parent. Unlike the Packages file, nearly all of the lines in a Release file are relevant for setting APT\n       priorities:\n\n       the Archive: or Suite: line\n           names the archive to which all the packages in the directory tree belong. For example, the line \"Archive: stable\" or \"Suite: stable\" specifies that all of the packages in the\n           directory tree below the parent of the Release file are in a stable archive. Specifying this value in the APT preferences file would require the line:\n\n               Pin: release a=stable\n\n       the Codename: line\n           names the codename to which all the packages in the directory tree belong. For example, the line \"Codename: forky\" specifies that all of the packages in the directory tree below\n           the parent of the Release file belong to a version named forky. Specifying this value in the APT preferences file would require the line:\n\n               Pin: release n=forky\n\n       the Version: line\n           names the release version. For example, the packages in the tree might belong to Debian release version 13. Note that there is normally no version number for the testing and\n           unstable distributions because they have not been released yet. Specifying this in the APT preferences file would require one of the following lines.\n\n               Pin: release v=13\n               Pin: release a=stable, v=13\n               Pin: release 13\n\n       the Component: line\n           names the licensing component associated with the packages in the directory tree of the Release file. For example, the line \"Component: main\" specifies that all the packages in\n           the directory tree are from the main component, which entails that they are licensed under terms listed in the Debian Free Software Guidelines. Specifying this component in the\n           APT preferences file would require the line:\n\n               Pin: release c=main\n\n       the Origin: line\n           names the originator of the packages in the directory tree of the Release file. Most commonly, this is Debian. Specifying this origin in the APT preferences file would require the\n           line:\n\n               Pin: release o=Debian\n\n       the Label: line\n           names the label of the packages in the directory tree of the Release file. Most commonly, this is Debian. Specifying this label in the APT preferences file would require the line:\n\n               Pin: release l=Debian\n\n       All of the Packages and Release files retrieved from locations listed in the sources.list(5) file are stored in the directory /var/lib/apt/lists, or in the file named by the variable\n       Dir::State::Lists in the apt.conf file. For example, the file debian.lcs.mit.edu_debian_dists_unstable_contrib_binary-i386_Release contains the Release file retrieved from the site\n       debian.lcs.mit.edu for binary-i386 architecture files from the contrib component of the unstable distribution.\n\n   Optional Lines in an APT Preferences Record\n       Each record in the APT preferences file can optionally begin with one or more lines beginning with the word Explanation:. This provides a place for comments.\n\nEXAMPLES\n   Tracking Stable\n       The following APT preferences file will cause APT to assign a priority higher than the default (500) to all package versions belonging to a stable distribution and a prohibitively low\n       priority to package versions belonging to other Debian distributions.\n\n           Explanation: Uninstall or do not install any Debian-originated\n           Explanation: package versions other than those in the stable distro\n           Package: *\n           Pin: release a=stable\n           Pin-Priority: 900\n\n           Package: *\n           Pin: release o=Debian\n           Pin-Priority: -10\n\n       With a suitable sources.list(5) file and the above preferences file, any of the following commands will cause APT to upgrade to the latest stable version(s).\n\n           apt-get install package-name\n           apt-get upgrade\n           apt-get dist-upgrade\n\n       The following command will cause APT to upgrade the specified package to the latest version from the testing distribution; the package will not be upgraded again unless this command\n       is given again.\n\n           apt-get install package/testing\n\n   Tracking Testing or Unstable\n       The following APT preferences file will cause APT to assign a high priority to package versions from the testing distribution, a lower priority to package versions from the unstable\n       distribution, and a prohibitively low priority to package versions from other Debian distributions.\n\n           Package: *\n           Pin: release a=testing\n           Pin-Priority: 900\n\n           Package: *\n           Pin: release a=unstable\n           Pin-Priority: 800\n\n           Package: *\n           Pin: release o=Debian\n           Pin-Priority: -10\n\n       With a suitable sources.list(5) file and the above preferences file, any of the following commands will cause APT to upgrade to the latest testing version(s).\n\n           apt-get install package-name\n           apt-get upgrade\n           apt-get dist-upgrade\n\n       The following command will cause APT to upgrade the specified package to the latest version from the unstable distribution. Thereafter, apt-get upgrade will upgrade the package to the\n       most recent testing version if that is more recent than the installed version, otherwise, to the most recent unstable version if that is more recent than the installed version.\n\n           apt-get install package/unstable\n\n   Tracking the evolution of a codename release\n       The following APT preferences file will cause APT to assign a priority higher than the default (500) to all package versions belonging to a specified codename of a distribution and a\n       prohibitively low priority to package versions belonging to other Debian distributions, codenames and archives. Note that with this APT preference APT will follow the migration of a\n       release from the archive testing to stable and later oldstable. If you want to follow for example the progress in testing notwithstanding the codename changes you should use the\n       example configurations above.\n\n           Explanation: Uninstall or do not install any Debian-originated package versions\n           Explanation: other than those in the distribution codenamed with forky or sid\n           Package: *\n           Pin: release n=forky\n           Pin-Priority: 900\n\n           Explanation: Debian unstable is always codenamed with sid\n           Package: *\n           Pin: release n=sid\n           Pin-Priority: 800\n\n           Package: *\n           Pin: release o=Debian\n           Pin-Priority: -10\n\n       With a suitable sources.list(5) file and the above preferences file, any of the following commands will cause APT to upgrade to the latest version(s) in the release codenamed with\n       forky.\n\n           apt-get install package-name\n           apt-get upgrade\n           apt-get dist-upgrade\n\n       The following command will cause APT to upgrade the specified package to the latest version from the sid distribution. Thereafter, apt-get upgrade will upgrade the package to the most\n       recent forky version if that is more recent than the installed version, otherwise, to the most recent sid version if that is more recent than the installed version.\n\n           apt-get install package/sid\n\nFILES\n       /etc/apt/preferences\n           Version preferences file. This is where you would specify \"pinning\", i.e. a preference to get certain packages from a separate source or from a different version of a\n           distribution. Configuration Item: Dir::Etc::Preferences.\n\n       /etc/apt/preferences.d/\n           File fragments for the version preferences. Configuration Item: Dir::Etc::PreferencesParts.\n\nSEE ALSO\n       apt-get(8) apt-cache(8) apt.conf(5) sources.list(5)\n\nBUGS\n       APT bug page[1]. If you wish to report a bug in APT, please see /usr/share/doc/debian/bug-reporting.txt or the reportbug(1) command.\n\nAUTHOR\n       APT team\n\nNOTES\n        1. APT bug page\n           https://bugs.debian.org/src:apt\n\nAPT 3.0.3                                                                               22 August 2024                                                                      APT_PREFERENCES(5)","ref":"apt_preferences.html"},{"type":"extras","title":"authorized_keys","doc":"SSHD(8)                                                                             System Manager's Manual                                                                            SSHD(8)\n\nNAME\n       sshd — OpenSSH daemon\n\nSYNOPSIS\n       sshd [-46DdeGiqTtV] [-C connection_spec] [-c host_certificate_file] [-E log_file] [-f config_file] [-g login_grace_time] [-h host_key_file] [-o option] [-p port] [-u len]\n\nDESCRIPTION\n       sshd (OpenSSH Daemon) is the daemon program for ssh(1).  It provides secure encrypted communications between two untrusted hosts over an insecure network.\n\n       sshd  listens  for  connections from clients.  It is normally started at boot from /etc/init.d/ssh.  It forks a new daemon for each incoming connection.  The forked daemons handle key\n       exchange, encryption, authentication, command execution, and data exchange.\n\n       sshd can be configured using command-line options or a configuration file (by default sshd_config(5)); command-line options override values specified in the configuration file.   sshd\n       rereads its configuration file when it receives a hangup signal, SIGHUP, by executing itself with the name and options it was started with, e.g. /usr/sbin/sshd.\n\n       The options are as follows:\n\n       -4      Forces sshd to use IPv4 addresses only.\n\n       -6      Forces sshd to use IPv6 addresses only.\n\n       -C connection_spec\n               Specify  the  connection  parameters to use for the -T extended test mode.  If provided, any Match directives in the configuration file that would apply are applied before the\n               configuration is written to standard output.  The connection parameters are supplied as keyword=value pairs and may be supplied in any order, either with multiple  -C  options\n               or  as a comma-separated list.  The keywords are “addr”, “user”, “host”, “laddr”, “lport”, and “rdomain” and correspond to source address, user, resolved source host name, lo‐\n               cal address, local port number and routing domain respectively.  Additionally the “invalid-user” flag (which does not take a value argument) may be  specified  to  simulate  a\n               connection from an unrecognised username.\n\n       -c host_certificate_file\n               Specifies a path to a certificate file to identify sshd during key exchange.  The certificate file must match a host key file specified using the -h option or the HostKey con‐\n               figuration directive.\n\n       -D      When this option is specified, sshd will not detach and does not become a daemon.  This allows easy monitoring of sshd.\n\n       -d      Debug  mode.   The  server sends verbose debug output to standard error, and does not put itself in the background.  The server also will not fork(2) and will only process one\n               connection.  This option is only intended for debugging for the server.  Multiple -d options increase the debugging level.  Maximum is 3.\n\n       -E log_file\n               Append debug logs to log_file instead of the system log.\n\n       -e      Write debug logs to standard error instead of the system log.\n\n       -f config_file\n               Specifies the name of the configuration file.  The default is /etc/ssh/sshd_config.  sshd refuses to start if there is no configuration file.\n\n       -G      Parse and print configuration file.  Check the validity of the configuration file, output the effective configuration to stdout and then exit.  Optionally, Match rules may  be\n               applied by specifying the connection parameters using one or more -C options.\n\n       -g login_grace_time\n               Gives  the  grace time for clients to authenticate themselves (default 120 seconds).  If the client fails to authenticate the user within this many seconds, the server discon‐\n               nects and exits.  A value of zero indicates no limit.\n\n       -h host_key_file\n               Specifies a file from which a host key is read.  This option must be given if sshd is not run as root (as the normal host key files are normally not  readable  by  anyone  but\n               root).   The  default is /etc/ssh/ssh_host_ecdsa_key, /etc/ssh/ssh_host_ed25519_key and /etc/ssh/ssh_host_rsa_key.  It is possible to have multiple host key files for the dif‐\n               ferent host key algorithms.\n\n       -i      Specifies that sshd is being run from inetd(8).\n\n       -o option\n               Can be used to give options in the format used in the configuration file.  This is useful for specifying options for which there is no separate command-line  flag.   For  full\n               details of the options, and their values, see sshd_config(5).\n\n       -p port\n               Specifies the port on which the server listens for connections (default 22).  Multiple port options are permitted.  Ports specified in the configuration file with the Port op‐\n               tion are ignored when a command-line port is specified.  Ports specified using the ListenAddress option override command-line ports.\n\n       -q      Quiet mode.  Nothing is sent to the system log.  Normally the beginning, authentication, and termination of each connection is logged.\n\n       -T      Extended test mode.  Check the validity of the configuration file, output the effective configuration to stdout and then exit.  Optionally, Match rules may be applied by spec‐\n               ifying the connection parameters using one or more -C options.  This is similar to the -G flag, but it includes the additional testing performed by the -t flag.\n\n       -t      Test mode.  Only check the validity of the configuration file and sanity of the keys.  This is useful for updating sshd reliably as configuration options may change.\n\n       -u len  This  option  is used to specify the size of the field in the utmp structure that holds the remote host name.  If the resolved host name is longer than len, the dotted decimal\n               value will be used instead.  This allows hosts with very long host names that overflow this field to still be uniquely identified.  Specifying -u0 indicates that  only  dotted\n               decimal  addresses  should  be  put into the utmp file.  -u0 may also be used to prevent sshd from making DNS requests unless the authentication mechanism or configuration re‐\n               quires it.  Authentication mechanisms that may require DNS include HostbasedAuthentication and using a from=\"pattern-list\" option in a key file.   Configuration  options  that\n               require DNS include using a USER@HOST pattern in AllowUsers or DenyUsers.\n\n       -V      Display the version number and exit.\n\nAUTHENTICATION\n       The  OpenSSH  SSH  daemon supports SSH protocol 2 only.  Each host has a host-specific key, used to identify the host.  Whenever a client connects, the daemon responds with its public\n       host key.  The client compares the host key against its own database to verify that it has not changed.  Forward secrecy is provided through a Diffie-Hellman key agreement.  This  key\n       agreement  results  in  a shared session key.  The rest of the session is encrypted using a symmetric cipher.  The client selects the encryption algorithm to use from those offered by\n       the server.  Additionally, session integrity is provided through a cryptographic message authentication code (MAC).\n\n       Finally, the server and the client enter an authentication dialog.  The client tries to authenticate itself using host-based authentication, public key  authentication,  challenge-re‐\n       sponse authentication, or password authentication.\n\n       Regardless  of  the  authentication  type,  the  account is checked to ensure that it is accessible.  An account is not accessible if it is locked, listed in DenyUsers or its group is\n       listed in DenyGroups .  The definition of a locked account is system dependent. Some platforms have their own account database (eg AIX) and some modify the passwd field  (  ‘*LK*’  on\n       Solaris  and  UnixWare, ‘*’ on HP-UX, containing ‘Nologin’ on Tru64, a leading ‘*LOCKED*’ on FreeBSD and a leading ‘!’ on most Linuxes).  If there is a requirement to disable password\n       authentication for the account while allowing still public-key, then the passwd field should be set to something other than these values (eg ‘NP’ or ‘*NP*’ ).\n\n       If the client successfully authenticates itself, a dialog for preparing the session is entered.  At this time the client may request things like allocating  a  pseudo-tty,  forwarding\n       X11 connections, forwarding TCP connections, or forwarding the authentication agent connection over the secure channel.\n\n       After  this,  the  client  either requests an interactive shell or execution of a non-interactive command, which sshd will execute via the user's shell using its -c option.  The sides\n       then enter session mode.  In this mode, either side may send data at any time, and such data is forwarded to/from the shell or command on the server side, and the user terminal in the\n       client side.\n\n       When the user program terminates and all forwarded X11 and other connections have been closed, the server sends command exit status to the client, and both sides exit.\n\nLOGIN PROCESS\n       When a user successfully logs in, sshd does the following:\n\n             1.   If the login is on a tty, and no command has been specified, prints last login time and /etc/motd (unless prevented in the configuration file or by  ~/.hushlogin;  see  the\n                  “FILES” section).\n\n             2.   If the login is on a tty, records login time.\n\n             3.   Checks /etc/nologin; if it exists, prints contents and quits (unless root).\n\n             4.   Changes to run with normal user privileges.\n\n             5.   Sets up basic environment.\n\n             6.   Reads the file ~/.ssh/environment, if it exists, and users are allowed to change their environment.  See the PermitUserEnvironment option in sshd_config(5).\n\n             7.   Changes to user's home directory.\n\n             8.   If  ~/.ssh/rc  exists and the sshd_config(5) PermitUserRC option is set, runs it; else if /etc/ssh/sshrc exists, runs it; otherwise runs xauth(1).  The “rc” files are given\n                  the X11 authentication protocol and cookie in standard input.  See “SSHRC”, below.\n\n             9.   Runs user's shell or command.  All commands are run under the user's login shell as specified in the system password database.\n\nSSHRC\n       If the file ~/.ssh/rc exists, sh(1) runs it after reading the environment files but before starting the user's shell or command.  It must not produce any output on stdout; stderr must\n       be used instead.  If X11 forwarding is in use, it will receive the \"proto cookie\" pair in its standard input (and DISPLAY in its environment).  The script must call  xauth(1)  because\n       sshd will not run xauth automatically to add X11 cookies.\n\n       The  primary purpose of this file is to run any initialization routines which may be needed before the user's home directory becomes accessible; AFS is a particular example of such an\n       environment.\n\n       This file will probably contain some initialization code followed by something similar to:\n\n          if read proto cookie && [ -n \"$DISPLAY\" ]; then\n                  if [ `echo $DISPLAY | cut -c1-10` = 'localhost:' ]; then\n                          # X11UseLocalhost=yes\n                          echo add unix:`echo $DISPLAY |\n                              cut -c11-` $proto $cookie\n                  else\n                          # X11UseLocalhost=no\n                          echo add $DISPLAY $proto $cookie\n                  fi | xauth -q -\n          fi\n\n       If this file does not exist, /etc/ssh/sshrc is run, and if that does not exist either, xauth is used to add the cookie.\n\nAUTHORIZED_KEYS FILE FORMAT\n       AuthorizedKeysFile specifies the files containing public  keys  for  public  key  authentication;  if  this  option  is  not  specified,  the  default  is  ~/.ssh/authorized_keys  and\n       ~/.ssh/authorized_keys2.  Each line of the file contains one key (empty lines and lines starting with a ‘#’ are ignored as comments).  Public keys consist of the following space-sepa‐\n       rated fields: options, keytype, base64-encoded key, comment.  The options field is optional.  The supported key types are:\n\n             sk-ecdsa-sha2-nistp256@openssh.com\n             ecdsa-sha2-nistp256\n             ecdsa-sha2-nistp384\n             ecdsa-sha2-nistp521\n             sk-ssh-ed25519@openssh.com\n             ssh-ed25519\n             ssh-rsa\n\n       The comment field is not used for anything (but may be convenient for the user to identify the key).\n\n       Note that lines in this file can be several hundred bytes long (because of the size of the public key encoding) up to a limit of 8 kilobytes, which permits RSA keys up to 16 kilobits.\n       You don't want to type them in; instead, copy the id_ecdsa.pub, id_ecdsa_sk.pub, id_ed25519.pub, id_ed25519_sk.pub, or the id_rsa.pub file and edit it.\n\n       sshd enforces a minimum RSA key modulus size of 1024 bits.\n\n       The  options  (if  present) consist of comma-separated option specifications.  No spaces are permitted, except within double quotes.  The following option specifications are supported\n       (note that option keywords are case-insensitive):\n\n       agent-forwarding\n               Enable authentication agent forwarding previously disabled by the restrict option.\n\n       cert-authority\n               Specifies that the listed key is a certification authority (CA) that is trusted to validate signed certificates for user authentication.\n\n               Certificates may encode access restrictions similar to these key options.  If both certificate restrictions and key options are present, the most restrictive union of the  two\n               is applied.\n\n       command=\"command\"\n               Specifies that the command is executed whenever this key is used for authentication.  The command supplied by the user (if any) is ignored.  The command is run on a pty if the\n               client requests a pty; otherwise it is run without a tty.  If an 8-bit clean channel is required, one must not request a pty or should specify no-pty.  A quote may be included\n               in the command by quoting it with a backslash.\n\n               This  option  might  be  useful  to restrict certain public keys to perform just a specific operation.  An example might be a key that permits remote backups but nothing else.\n               Note that the client may specify TCP and/or X11 forwarding unless they are explicitly prohibited, e.g. using the restrict key option.\n\n               The command originally supplied by the client is available in the SSH_ORIGINAL_COMMAND environment variable.  Note that this option applies to shell, command or subsystem exe‐\n               cution.  Also note that this command may be superseded by a sshd_config(5) ForceCommand directive.\n\n               If a command is specified and a forced-command is embedded in a certificate used for authentication, then the certificate will be accepted only if the two commands are identi‐\n               cal.\n\n       environment=\"NAME=value\"\n               Specifies that the string is to be added to the environment when logging in using this key.  Environment variables set this way  override  other  default  environment  values.\n               Multiple options of this type are permitted.  Environment processing is disabled by default and is controlled via the PermitUserEnvironment option.\n\n       expiry-time=\"timespec\"\n               Specifies a time after which the key will not be accepted.  The time may be specified as a YYYYMMDD[Z] date or a YYYYMMDDHHMM[SS][Z] time.  Dates and times will be interpreted\n               in the system time zone unless suffixed by a Z character, in which case they will be interpreted in the UTC time zone.\n\n       from=\"pattern-list\"\n               Specifies  that  in  addition  to public key authentication, either the canonical name of the remote host or its IP address must be present in the comma-separated list of pat‐\n               terns.  See PATTERNS in ssh_config(5) for more information on patterns.\n\n               In addition to the wildcard matching that may be applied to hostnames or addresses, a from stanza may match IP addresses using CIDR address/masklen notation.\n\n               The purpose of this option is to optionally increase security: public key authentication by itself does not trust the network or name servers or anything (but the  key);  how‐\n               ever,  if  somebody  somehow  steals the key, the key permits an intruder to log in from anywhere in the world.  This additional option makes using a stolen key more difficult\n               (name servers and/or routers would have to be compromised in addition to just the key).\n\n       no-agent-forwarding\n               Forbids authentication agent forwarding when this key is used for authentication.\n\n       no-port-forwarding\n               Forbids TCP forwarding when this key is used for authentication.  Any port forward requests by the client will return an error.  This might be used, e.g.  in  connection  with\n               the command option.\n\n       no-pty  Prevents tty allocation (a request to allocate a pty will fail).\n\n       no-user-rc\n               Disables execution of ~/.ssh/rc.\n\n       no-X11-forwarding\n               Forbids X11 forwarding when this key is used for authentication.  Any X11 forward requests by the client will return an error.\n\n       permitlisten=\"[host:]port\"\n               Limit  remote  port  forwarding with the ssh(1) -R option such that it may only listen on the specified host (optional) and port.  IPv6 addresses can be specified by enclosing\n               the address in square brackets.  Multiple permitlisten options may be applied separated by commas.  Hostnames may include wildcards as described in  the  PATTERNS  section  in\n               ssh_config(5).   A  port specification of * matches any port.  Note that the setting of GatewayPorts may further restrict listen addresses.  Note that ssh(1) will send a host‐\n               name of “localhost” if a listen host was not specified when the forwarding was requested, and that this name  is  treated  differently  to  the  explicit  localhost  addresses\n               “127.0.0.1” and “::1”.\n\n       permitopen=\"host:port\"\n               Limit  local  port forwarding with the ssh(1) -L option such that it may only connect to the specified host and port.  IPv6 addresses can be specified by enclosing the address\n               in square brackets.  Multiple permitopen options may be applied separated by commas.  No pattern matching or name lookup is performed on the specified hostnames, they must  be\n               literal host names and/or addresses.  A port specification of * matches any port.\n\n       port-forwarding\n               Enable port forwarding previously disabled by the restrict option.\n\n       principals=\"principals\"\n               On  a  cert-authority line, specifies allowed principals for certificate authentication as a comma-separated list.  At least one name from the list must appear in the certifi‐\n               cate's list of principals for the certificate to be accepted.  This option is ignored for keys that are not marked as trusted certificate signers using the cert-authority  op‐\n               tion.\n\n       pty     Permits tty allocation previously disabled by the restrict option.\n\n       no-touch-required\n               Do not require demonstration of user presence for signatures made using this key.  This option only makes sense for the FIDO authenticator algorithms ecdsa-sk and ed25519-sk.\n\n       verify-required\n               Require  that  signatures  made using this key attest that they verified the user, e.g. via a PIN.  This option only makes sense for the FIDO authenticator algorithms ecdsa-sk\n               and ed25519-sk.\n\n       restrict\n               Enable all restrictions, i.e. disable port, agent and X11 forwarding, as well as disabling PTY allocation and execution of ~/.ssh/rc.  If any future  restriction  capabilities\n               are added to authorized_keys files, they will be included in this set.\n\n       tunnel=\"n\"\n               Force a tun(4) device on the server.  Without this option, the next available device will be used if the client requests a tunnel.\n\n       user-rc\n               Enables execution of ~/.ssh/rc previously disabled by the restrict option.\n\n       X11-forwarding\n               Permits X11 forwarding previously disabled by the restrict option.\n\n       An example authorized_keys file:\n\n          # Comments are allowed at start of line. Blank lines are allowed.\n          # Plain key, no restrictions\n          ssh-rsa ...\n          # Forced command, disable PTY and all forwarding\n          restrict,command=\"dump /home\" ssh-rsa ...\n          # Restriction of ssh -L forwarding destinations\n          permitopen=\"192.0.2.1:80\",permitopen=\"192.0.2.2:25\" ssh-rsa ...\n          # Restriction of ssh -R forwarding listeners\n          permitlisten=\"localhost:8080\",permitlisten=\"[::1]:22000\" ssh-rsa ...\n          # Configuration for tunnel forwarding\n          tunnel=\"0\",command=\"sh /etc/netstart tun0\" ssh-rsa ...\n          # Override of restriction to allow PTY allocation\n          restrict,pty,command=\"nethack\" ssh-rsa ...\n          # Allow FIDO key without requiring touch\n          no-touch-required sk-ecdsa-sha2-nistp256@openssh.com ...\n          # Require user-verification (e.g. PIN or biometric) for FIDO key\n          verify-required sk-ecdsa-sha2-nistp256@openssh.com ...\n          # Trust CA key, allow touch-less FIDO if requested in certificate\n          cert-authority,no-touch-required,principals=\"user_a\" ssh-rsa ...\n\nSSH_KNOWN_HOSTS FILE FORMAT\n       The  /etc/ssh/ssh_known_hosts  and  ~/.ssh/known_hosts files contain host public keys for all known hosts.  The global file should be prepared by the administrator (optional), and the\n       per-user file is maintained automatically: whenever the user connects to an unknown host, its key is added to the per-user file.\n\n       Each line in these files contains the following fields: marker (optional), hostnames, keytype, base64-encoded key, comment.  The fields are separated by spaces.\n\n       The marker is optional, but if it is present then it must be one of “@cert-authority”, to indicate that the line contains a certification authority (CA) key, or “@revoked”,  to  indi‐\n       cate that the key contained on the line is revoked and must not ever be accepted.  Only one marker should be used on a key line.\n\n       Hostnames  is  a comma-separated list of patterns (‘*’ and ‘?’ act as wildcards); each pattern in turn is matched against the host name.  When sshd is authenticating a client, such as\n       when using HostbasedAuthentication, this will be the canonical client host name.  When ssh(1) is authenticating a server, this will be the host name given by the user,  the  value  of\n       the ssh(1) HostkeyAlias if it was specified, or the canonical server hostname if the ssh(1) CanonicalizeHostname option was used.\n\n       A  pattern  may  also  be preceded by ‘!’ to indicate negation: if the host name matches a negated pattern, it is not accepted (by that line) even if it matched another pattern on the\n       line.  A hostname or address may optionally be enclosed within ‘[’ and ‘]’ brackets then followed by ‘:’ and a non-standard port number.\n\n       Alternately, hostnames may be stored in a hashed form which hides host names and addresses should the file's contents be disclosed.  Hashed hostnames start with a ‘|’ character.  Only\n       one hashed hostname may appear on a single line and none of the above negation or wildcard operators may be applied.\n\n       The keytype and base64-encoded key are taken directly from the host key; they can be obtained, for example, from /etc/ssh/ssh_host_rsa_key.pub.  The optional comment  field  continues\n       to the end of the line, and is not used.\n\n       Lines starting with ‘#’ and empty lines are ignored as comments.\n\n       When  performing host authentication, authentication is accepted if any matching line has the proper key; either one that matches exactly or, if the server has presented a certificate\n       for authentication, the key of the certification authority that signed the certificate.  For a key to be trusted as a certification authority, it must use the “@cert-authority” marker\n       described above.\n\n       The known hosts file also provides a facility to mark keys as revoked, for example when it is known that the associated private key has been stolen.  Revoked keys are specified by in‐\n       cluding the “@revoked” marker at the beginning of the key line, and are never accepted for authentication or as certification authorities, but instead  will  produce  a  warning  from\n       ssh(1) when they are encountered.\n\n       It is permissible (but not recommended) to have several lines or different host keys for the same names.  This will inevitably happen when short forms of host names from different do‐\n       mains are put in the file.  It is possible that the files contain conflicting information; authentication is accepted if valid information can be found from either file.\n\n       Note  that  the  lines  in  these  files are typically hundreds of characters long, and you definitely don't want to type in the host keys by hand.  Rather, generate them by a script,\n       ssh-keyscan(1) or by taking, for example, /etc/ssh/ssh_host_rsa_key.pub and adding the host  names  at  the  front.   ssh-keygen(1)  also  offers  some  basic  automated  editing  for\n       ~/.ssh/known_hosts including removing hosts matching a host name and converting all host names to their hashed representations.\n\n       An example ssh_known_hosts file:\n\n          # Comments allowed at start of line\n          cvs.example.net,192.0.2.10 ssh-rsa AAAA1234.....=\n          # A hashed hostname\n          |1|JfKTdBh7rNbXkVAQCRp4OQoPfmI=|USECr3SWf1JUPsms5AqfD5QfxkM= ssh-rsa\n          AAAA1234.....=\n          # A revoked key\n          @revoked * ssh-rsa AAAAB5W...\n          # A CA key, accepted for any host in *.mydomain.com or *.mydomain.org\n          @cert-authority *.mydomain.org,*.mydomain.com ssh-rsa AAAAB5W...\n\nFILES\n       ~/.hushlogin\n               This  file is used to suppress printing the last login time and /etc/motd, if PrintLastLog and PrintMotd, respectively, are enabled.  It does not suppress printing of the ban‐\n               ner specified by Banner.\n\n       ~/.rhosts\n               This file is used for host-based authentication (see ssh(1) for more information).  On some machines this file may need to be world-readable if the user's home directory is on\n               an NFS partition, because sshd reads it as root.  Additionally, this file must be owned by the user, and must not have write permissions for anyone else.  The recommended per‐\n               mission for most machines is read/write for the user, and not accessible by others.\n\n       ~/.shosts\n               This file is used in exactly the same way as .rhosts, but allows host-based authentication without permitting login with rlogin/rsh.\n\n       ~/.ssh/\n               This directory is the default location for all user-specific configuration and authentication information.  There is no general requirement to keep the entire contents of this\n               directory secret, but the recommended permissions are read/write/execute for the user, and not accessible by others.\n\n       ~/.ssh/authorized_keys\n               Lists the public keys (ECDSA, Ed25519, RSA) that can be used for logging in as this user.  The format of this file is described above.  The content of the file is  not  highly\n               sensitive, but the recommended permissions are read/write for the user, and not accessible by others.\n\n               If this file, the ~/.ssh directory, or the user's home directory are writable by other users, then the file could be modified or replaced by unauthorized users.  In this case,\n               sshd will not allow it to be used unless the StrictModes option has been set to “no”.\n\n       ~/.ssh/environment\n               This  file  is  read  into  the  environment  at  login (if it exists).  It can only contain empty lines, comment lines (that start with ‘#’), and assignment lines of the form\n               name=value.  The file should be writable only by the user; it need not be readable by anyone else.  Environment processing is disabled by default and  is  controlled  via  the\n               PermitUserEnvironment option.\n\n       ~/.ssh/known_hosts\n               Contains  a  list  of  host  keys  for all hosts the user has logged into that are not already in the systemwide list of known host keys.  The format of this file is described\n               above.  This file should be writable only by root/the owner and can, but need not be, world-readable.\n\n       ~/.ssh/rc\n               Contains initialization routines to be run before the user's home directory becomes accessible.  This file should be writable only by the user, and need  not  be  readable  by\n               anyone else.\n\n       /etc/hosts.allow\n       /etc/hosts.deny\n               Access controls that should be enforced by tcp-wrappers are defined here.  Further details are described in hosts_access(5).\n\n       /etc/hosts.equiv\n               This file is for host-based authentication (see ssh(1)).  It should only be writable by root.\n\n       /etc/ssh/moduli\n               Contains  Diffie-Hellman groups used for the \"Diffie-Hellman Group Exchange\" key exchange method.  The file format is described in moduli(5).  If no usable groups are found in\n               this file then fixed internal groups will be used.\n\n       /etc/motd\n               See motd(5).\n\n       /etc/nologin\n               If this file exists, sshd refuses to let anyone except root log in.  The contents of the file are displayed to anyone trying to log in, and non-root connections  are  refused.\n               The file should be world-readable.\n\n       /etc/ssh/shosts.equiv\n               This file is used in exactly the same way as hosts.equiv, but allows host-based authentication without permitting login with rlogin/rsh.\n\n       /etc/ssh/ssh_host_ecdsa_key\n       /etc/ssh/ssh_host_ed25519_key\n       /etc/ssh/ssh_host_rsa_key\n               These  files  contain  the private parts of the host keys.  These files should only be owned by root, readable only by root, and not accessible to others.  Note that sshd does\n               not start if these files are group/world-accessible.\n\n       /etc/ssh/ssh_host_ecdsa_key.pub\n       /etc/ssh/ssh_host_ed25519_key.pub\n       /etc/ssh/ssh_host_rsa_key.pub\n               These files contain the public parts of the host keys.  These files should be world-readable but writable only by root.  Their contents should  match  the  respective  private\n               parts.   These files are not really used for anything; they are provided for the convenience of the user so their contents can be copied to known hosts files.  These files are\n               created using ssh-keygen(1).\n\n       /etc/ssh/ssh_known_hosts\n               Systemwide list of known host keys.  This file should be prepared by the system administrator to contain the public host keys of all machines in the organization.  The  format\n               of this file is described above.  This file should be writable only by root/the owner and should be world-readable.\n\n       /etc/ssh/sshd_config\n               Contains configuration data for sshd.  The file format and configuration options are described in sshd_config(5).\n\n       /etc/ssh/sshrc\n               Similar to ~/.ssh/rc, it can be used to specify machine-specific login-time initializations globally.  This file should be writable only by root, and should be world-readable.\n\n       /run/sshd\n               chroot(2)  directory  used  by  sshd during privilege separation in the pre-authentication phase.  The directory should not contain any files and must be owned by root and not\n               group or world-writable.\n\n       /run/sshd.pid\n               Contains the process ID of the sshd listening for connections (if there are several daemons running concurrently for different ports, this contains the process ID of  the  one\n               started last).  The content of this file is not sensitive; it can be world-readable.\n\nSEE ALSO\n       scp(1), sftp(1), ssh(1), ssh-add(1), ssh-agent(1), ssh-keygen(1), ssh-keyscan(1), chroot(2), hosts_access(5), moduli(5), sshd_config(5), inetd(8), sftp-server(8)\n\nAUTHORS\n       OpenSSH  is  a  derivative  of the original and free ssh 1.2.12 release by Tatu Ylonen.  Aaron Campbell, Bob Beck, Markus Friedl, Niels Provos, Theo de Raadt and Dug Song removed many\n       bugs, re-added newer features and created OpenSSH.  Markus Friedl contributed the support for SSH protocol versions 1.5 and 2.0.  Niels Provos and Markus  Friedl  contributed  support\n       for privilege separation.\n\nDebian                                                                                September 15, 2024                                                                               SSHD(8)","ref":"authorized_keys.html"},{"type":"extras","title":"avahi-daemon.conf","doc":"avahi-daemon.conf(5)                                                                  File Formats Manual                                                                 avahi-daemon.conf(5)\n\nNAME\n       avahi-daemon.conf - avahi-daemon configuration file\n\nSYNOPSIS\n       /etc/avahi/avahi-daemon.conf\n\nDESCRIPTION\n       avahi-daemon.conf is the configuration file for avahi-daemon.\n\nSECTION [SERVER]\n       host-name= Set the host name avahi-daemon tries to register on the LAN. If omited defaults to the system host name as set with the sethostname() system call.\n\n       host-name-from-machine-id= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" avahi-daemon will use the machine-id as name on the LAN.\n\n       domain-name= Set the default domain name avahi-daemon tries to register its host name and services on the LAN in. If omitted defaults to \".local\".\n\n       browse-domains= Set a comma separated list of browsing domains (in addition to the default one and those announced inside the default browsing domain). Please note that the user may\n       specify additional browsing domains on the client side, either by setting $AVAHI_BROWSE_DOMAINS to a list of colon separated domains or by adding them to the XDG config file ~/.con‐\n       fig/avahi/browse-domains (separated by newlines).\n\n       use-ipv4= Takes a boolean value (\"yes\" or \"no\"). If set to \"no\" avahi-daemon will not use IPv4 sockets. Default is \"yes\".\n\n       use-ipv6= Takes a boolean value (\"yes\" or \"no\"). If set to \"no\" avahi-daemon will not use IPv6 sockets. Default is \"yes\".\n\n       allow-interfaces= Set a comma separated list of allowed network interfaces that should be used by the avahi-daemon. Traffic on other interfaces will be ignored. If set to an empty\n       list all local interfaces except loopback and point-to-point will be used.\n\n       deny-interfaces= Set a comma separated list of network interfaces that should be ignored by avahi-daemon. Other not specified interfaces will be used, unless allow-interfaces= is set.\n       This option takes precedence over allow-interfaces=.\n\n       check-response-ttl= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\", an additional security check is activated: incoming IP packets will be ignored unless the IP TTL is 255.\n       Earlier mDNS specifications required this check. Since this feature may be incompatible with newer implementations of mDNS it defaults to \"no\". On the other hand it provides extra se‐\n       curity.\n\n       use-iff-running= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" avahi-daemon monitors the IFF_RUNNING flag bit which is used by some (modern) network drivers to tell user\n       space if a network cable is plugged in (in case of copper ethernet), or the network card is associated with some kind of network (in case of WLAN). If IFF_RUNNING is set avahi-daemon\n       will automatically announce its services on that network. Unfortunately far too many network drivers do not support this flag or support it in a broken way. Therefore this option de‐\n       faults to \"no\".\n\n       enable-dbus= Takes either \"yes\", \"no\" or \"warn\". If set to \"yes\" avahi-daemon connects to D-Bus, offering an object oriented client API. It is only available if Avahi has been com‐\n       piled with --enable-dbus in which case it defaults to \"yes\". \"warn\" behaves like \"yes\", but the daemon starts up even when it fails to connect to a D-Bus daemon. In addition, if the\n       connection to the D-Bus daemon is terminated we try to reconnect. (Unless we are in a chroot() environment where this definitely will fail.)\n\n       disallow-other-stacks= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" no other process is allowed to bind to UDP port 5353. This effectively impedes other mDNS stacks from\n       running on the host. Use this as a security measure to make sure that only Avahi is responsible for mDNS traffic. Please note that we do not recommend running multiple mDNS stacks on\n       the same host simultaneously. This hampers reliability and is a waste of resources. However, to not annoy people this option defaults to \"no\".\n\n       allow-point-to-point= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" avahi-daemon will make use of interfaces with the POINTOPOINT flag set. This option defaults to \"no\" as it\n       might make mDNS unreliable due to usually large latencies with such links and opens a potential security hole by allowing mDNS access from Internet connections. Use with care and\n       YMMV!\n\n       cache-entries-max= Takes an unsigned integer specifying how many resource records are cached per interface. Bigger values allow mDNS work correctly in large LANs but also increase\n       memory consumption.\n\n       clients-max= Takes an unsigned integer. The maximum number of concurrent D-Bus clients allowed. If the maximum number is reached further clients will be refused until at least one ex‐\n       isting client disconnects.\n\n       objects-per-client-max= Takes an unsigned integer. The maximum number of objects (entry groups, browsers, resolvers) that may be registered per D-Bus client at a time. If the maximum\n       number is reached further object creation will be refused until at least one object is freed.\n\n       entries-per-entry-group-max= Takes an unsigned integer. The maximum number of entries (resource records) per entry group registered by a D-Bus client at a time. If the maximum number\n       is reached further resource records may not be added to an entry group.\n\n       ratelimit-interval-usec= Takes an unsigned integer. Sets the per-interface packet rate-limiting interval parameter. Together with ratelimit-burst= this may be used to control the max‐\n       imum number of packets Avahi will generated in a specific period of time on an interface.\n\n       ratelimit-burst= Takes an unsigned integer. Sets the per-interface packet rate-limiting burst parameter. Together with ratelimit-interval-usec= this may be used to control the maximum\n       number of packets Avahi will generated in a specific period of time on an interface.\n\nSECTION [WIDE-AREA]\n       enable-wide-area= Takes a boolean value (\"yes\" or \"no\"). Enable wide-area DNS-SD, aka DNS-SD over unicast DNS. If this is enabled only domains ending in .local will be resolved on\n       mDNS, all other domains are resolved via unicast DNS. If you want to maintain multiple different multicast DNS domains even with this option enabled we encourage you to use subdomains\n       of .local, such as \"kitchen.local\". This option defaults to \"yes\".\n\nSECTION [PUBLISH]\n       disable-publishing= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\", no record will be published by Avahi, not even address records for the local host. Avahi will be started in\n       a querying-only mode. Use this is a security measure. This option defaults to \"no\"\n\n       disable-user-service-publishing= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\", Avahi will still publish address records and suchlike but will not allow user applications to\n       publish services. Use this is a security measure. This option defaults to \"no\"\n\n       add-service-cookie= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" an implicit TXT entry will be added to all locally registered services, containing a cookie value which is\n       chosen randomly on daemon startup. This can be used to detect if two services on two different interfaces/protocols are actually identical. Defaults to \"no\".\n\n       publish-addresses= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" avahi-daemon will register mDNS address records for all local IP addresses. Unless you want to use avahi-dae‐\n       mon exclusively for browsing it's recommended to enable this. If you plan to register local services you need to enable this option. Defaults to \"yes\".\n\n       publish-hinfo= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" avahi-daemon will register an mDNS HINFO record on all interfaces which contains information about the local op‐\n       erating system and CPU, which might be useful for administrative purposes. This is recommended by the mDNS specification but not required. For the sake of privacy you might choose to\n       disable this feature. Defaults to \"no\".\n\n       publish-workstation= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" avahi-daemon will register a service of type \"_workstation._tcp\" on the local LAN. This might be useful for\n       administrative purposes (i.e. browse for all PCs on the LAN), but is not required or recommended by any specification. Newer MacOS X releases register a service of this type. Defaults\n       to \"no\".\n\n       publish-domain= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" avahi-daemon will announce the locally used domain name (see above) for browsing by other hosts. Defaults to\n       \"yes\".\n\n       publish-dns-servers= Takes a comma separated list of IP addresses for unicast DNS servers. You can use this to announce unicast DNS servers via mDNS. When used in conjunction with\n       avahi-dnsconfd on the client side this allows DHCP-like configuration of unicast DNS servers.\n\n       publish-resolv-conf-dns-servers= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" avahi-daemon will publish the unicast DNS servers specified in /etc/resolv.conf in addition to\n       those specified with publish-dns-servers. Send avahi-daemon a SIGHUP to have it reload this file. Defaults to \"no\".\n\n       publish-aaaa-on-ipv4= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" avahi-daemon will publish an IPv6 AAAA record via IPv4, i.e. the local IPv6 addresses can be resolved us‐\n       ing an IPv4 transport. Only useful when IPv4 is enabled with use-ipv4=true. Defaults to \"yes\".\n\n       publish-a-on-ipv6= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" avahi-daemon will publish an IPv4 A record via IPv6, i.e. the local IPv4 addresses can be resolved using an\n       IPv6 transport. Only useful when IPv6 is enabled with use-ipv6=true. Defaults to \"no\".\n\nSECTION [REFLECTOR]\n       enable-reflector= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" avahi-daemon will reflect incoming mDNS requests to all local network interfaces, effectively allowing clients\n       to browse mDNS/DNS-SD services on all networks connected to the gateway. The gateway is somewhat intelligent and should work with all kinds of mDNS traffic, though some functionality\n       is lost (specifically the unicast reply bit, which is used rarely anyway). Make sure to not run multiple reflectors between the same networks, this might cause them to play Ping Pong\n       with mDNS packets. Defaults to \"no\".\n\n       reflect-ipv= Takes a boolean value (\"yes\" or \"no\"). If set to \"yes\" and enable-reflector is enabled, avahi-daemon will forward mDNS traffic between IPv4 and IPv6, which is usually not\n       recommended. Defaults to \"no\".\n\n       reflect-filters= Set a comma separated list of allowed service names to be reflected. Each service that is seen must match an entry in this list to be reflected to other networks.\n       This list can match the type of service or the name of the machine providing the service. Defaults to allowing all services.\n\nSECTION [RLIMITS]\n       This  section  is used to define system resource limits for the daemon. See setrlimit(2) for more information. If any of the options is not specified in the configuration file, avahi-\n       daemon does not change it from the system defaults.\n\n       rlimit-as= Value in bytes for RLIMIT_AS (maximum size of the process's virtual memory). Sensible values are heavily system dependent.\n\n       rlimit-core= Value in bytes for RLIMIT_CORE (maximum core file size). Unless you want to debug avahi-daemon, it is safe to set this to 0.\n\n       rlimit-data= Value in bytes for RLIMIT_DATA (maximum size of the process's data segment). Sensible values are heavily system dependent.\n\n       rlimit-fsize= Value for RLIMIT_FSIZE (maximum size of files the process may create). Since avahi-daemon shouldn't write any files to disk, it is safe to set this to 0.\n\n       rlimit-nofile= Value for RLIMIT_NOFILE (open file descriptors). avahi-daemon shouldn't need more than 15 to 20 open file descriptors concurrently.\n\n       rlimit-stack= Value in bytes for RLIMIT_STACK (maximum size of the process stack). Sensible values are heavily system dependent.\n\n       rlimit-nproc= Value for RLIMIT_NPROC (max number of processes a user can launch). avahi-daemon forks of a helper process on systems where chroot(2) is available therefore this value\n       should not be set below 2. Note that while the process limit only applies to this process, the total count of processes to reach that limit includes all processes on the system with\n       the same UID, including any containers without UID remapping (such as lxd containers with security.privileged=true). The default configuration of 3 was removed to prevent problems in\n       this scenario.\n\nAUTHORS\n       The Avahi Developers  ; Avahi is available from http://avahi.org/\n\nSEE ALSO\n       avahi-daemon(8), avahi-dnsconfd(8)\n\nCOMMENTS\n       This man page was written using xml2man(1) by Oliver Kurth.\n\nManuals                                                                                      User                                                                         avahi-daemon.conf(5)","ref":"avahi-daemon-conf.html"},{"type":"extras","title":"avahi.hosts","doc":"avahi.hosts(5)                                                                        File Formats Manual                                                                       avahi.hosts(5)\n\nNAME\n       avahi.hosts - avahi-daemon static host name file\n\nSYNOPSIS\n       /etc/avahi/hosts\n\nDESCRIPTION\n       /etc/avahi/hosts  is  a file which may be used to define static host name to IP address mappings for multicast DNS. This is especially useful when publishing DNS-SD services on behalf\n       of other hosts. See avahi.service(5) for more information.\n\n       The file format is similar to the one of /etc/hosts: on each line an IP address and the corresponding host name. The host names should be in FQDN form, i.e. with appended .local  suf‐\n       fix.\n\nAUTHORS\n       The Avahi Developers  ; Avahi is available from http://avahi.org/\n\nSEE ALSO\n       avahi-daemon(8), avahi.service(5)\n\nCOMMENTS\n       This man page was written using xml2man(1) by Oliver Kurth.\n\nManuals                                                                                      User                                                                               avahi.hosts(5)","ref":"avahi-hosts.html"},{"type":"extras","title":"avahi.service","doc":"avahi.service(5)                                                                      File Formats Manual                                                                     avahi.service(5)\n\nNAME\n       avahi.service - avahi-daemon static service file\n\nSYNOPSIS\n       /etc/avahi/services/*.service\n\nDESCRIPTION\n       /etc/avahi/services/*.service  are  XML fragments containing static DNS-SD service data. Every service file can contain multiple service definitions which share the same name. This is\n       useful for publishing service data for services which implement multiple protocols. (i.e. a printer implementing _ipp._tcp and _printer._tcp)\n\nXML TAGS\n         The document tag of avahi service files. Should contain one   and one or more   elements.\n\n         The service name. If replace-wildcards is \"yes\", any occurence of the string \"%h\" will be replaced by the local host name. This can be used for ser‐\n       vice names like \"Remote Terminal on %h\". If replace-wildcards is not specified, defaults to \"no\".\n\n         Contains the service information for exactly one service type. Should contain one   and one   element. Optionally it may contain one  , one  , any number of   and any number of   elements. The attribute protocol specifies the protocol to advertise the service on. If any is used\n       (which is the default), the service will be advertised on both IPv4 and IPv6.\n\n         Contains the DNS-SD service type for this service. e.g. \"_http._tcp\".\n\n         Contains an additional DNS-SD service subtype for this service. e.g. \"_anon._sub._ftp._tcp\".\n\n         The domain name this service should be registered. If omited defaults to the default domain of the avahi daemon. (probably .local)\n\n         The host name of the host that provides this service. This should be a host that is resolvable by multicast or unicast DNS. Please note that you need to specify a fully-\n       qualified domain name (FQDN) here, i.e. .local is not appended implicitly! The host name doesn't need to be part of the domain specified in  . See avahi.hosts(5) for more\n       information how to publish additional host name mappings.\n\n         The IP port number the service listens on.\n\n         DNS-SD TXT record data. If value-format is \"text\", the value of the TXT record is taken verbatim. If value-format is \"binary-\n       hex\" then the value of TXT record is decoded by taking pairs of characters after the \"=\" char and interpreting them as the textual representation of the two-digit hexadecimal number.\n       Both uppercase and lowercase hexadecimal digits are allowed. The 0x or 0X prefix is not allowed. This requires the length of the value to be even. If value-format is \"binary-base64\"\n       then the value of TXT record is decoded with a base64 decoder. The character set used is A-Za-z0-9+/. This requires the length of the value to be a multiple of 4, with \"=\" as padding\n       at the end. If value-format is not specified, defaults to \"text\". Examples (all the values are decoded to the string \"value\" without quotes):\n\n               key=value \n\n               key=value \n\n               key=76616c7565 \n\n               key=dmFsdWU= \n\nAUTHORS\n       The Avahi Developers  ; Avahi is available from http://avahi.org/\n\nSEE ALSO\n       avahi-daemon(8), avahi.hosts(5)\n\nCOMMENTS\n       This man page was written using xml2man(1) by Oliver Kurth.\n\nManuals                                                                                      User                                                                             avahi.service(5)","ref":"avahi-service.html"},{"type":"extras","title":"binfmt.d","doc":"BINFMT.D(5)                                                                                binfmt.d                                                                                BINFMT.D(5)\n\nNAME\n       binfmt.d - Configure additional binary formats for executables at boot\n\nSYNOPSIS\n           /etc/binfmt.d/*.conf\n           /run/binfmt.d/*.conf\n           /usr/local/lib/binfmt.d/*.conf\n           /usr/lib/binfmt.d/*.conf\n\nDESCRIPTION\n       At boot, systemd-binfmt.service(8) reads configuration files from the above directories to register in the kernel additional binary formats for executables.\n\nCONFIGURATION FORMAT\n       Each file contains a list of binfmt_misc kernel binary format rules. Consult the kernel's Kernel Support for miscellaneous Binary Formats (binfmt_misc)[1] documentation file for more\n       information on registration of additional binary formats and how to write rules.\n\n       Empty lines and lines beginning with \";\" and \"#\" are ignored. Note that this means you may not use those symbols as the delimiter in binary format rules.\n\nCONFIGURATION DIRECTORIES AND PRECEDENCE\n       Configuration files are read from directories in /etc/, /run/, /usr/local/lib/, and /usr/lib/, in order of precedence, as listed in the SYNOPSIS section above. Files must have the\n       \".conf\" extension. Files in /etc/ override files with the same name in /run/, /usr/local/lib/, and /usr/lib/. Files in /run/ override files with the same name under /usr/.\n\n       All configuration files are sorted by their filename in lexicographic order, regardless of which of the directories they reside in. If multiple files specify the same option, the\n       entry in the file with the lexicographically latest name will take precedence. Thus, the configuration in a certain file may either be replaced completely (by placing a file with the\n       same name in a directory with higher priority), or individual settings might be changed (by specifying additional settings in a file with a different name that is ordered later).\n\n       Packages should install their configuration files in /usr/lib/ (distribution packages) or /usr/local/lib/ (local installs) [2]. Files in /etc/ are reserved for the local\n       administrator, who may use this logic to override the configuration files installed by vendor packages.\n\n       It is recommended to prefix all filenames with a two-digit number and a dash to simplify the ordering. It is recommended to use the range 10-40 for configuration files in /usr/ and\n       the range 60-90 for configuration files in /etc/ and /run/, to make sure that local and transient configuration files will always take priority over configuration files shipped by the\n       OS vendor.\n\n       If the administrator wants to disable a configuration file supplied by the vendor, the recommended way is to place a symlink to /dev/null in the configuration directory in /etc/, with\n       the same filename as the vendor configuration file. If the vendor configuration file is included in the initrd image, the image has to be regenerated.\n\nEXAMPLE\n       Example 1. /etc/binfmt.d/wine.conf example:\n\n           # Start WINE on Windows executables\n           :DOSWin:M::MZ::/usr/bin/wine:\n\nSEE ALSO\n       systemd(1), systemd-binfmt.service(8), systemd-delta(1), wine(8)\n\nNOTES\n        1. Kernel Support for miscellaneous Binary Formats (binfmt_misc)\n           https://docs.kernel.org/admin-guide/binfmt-misc.html\n\n        2. 💣💥🧨💥💥💣 Please note that those configuration files must be available at all times. If /usr/local/ is a separate partition, it may not be available during early boot, and must\n           not be used for configuration.\n\nsystemd 257.7                                                                                                                                                                      BINFMT.D(5)","ref":"binfmt-d.html"},{"type":"extras","title":"bridge-utils-interfaces","doc":"BRIDGE-UTILS-INTERFACES(5)                                                               File formats                                                               BRIDGE-UTILS-INTERFACES(5)\n\nNAME\n       bridge-utils-interfaces - bridge-utils extensions for the interfaces(5) file format\n\nDESCRIPTION\n       /etc/network/interfaces  contains network interface configuration information for the ifup(8) and ifdown(8) commands.  This manpage describes the bridge extensions to the standard in‐\n       terfaces(5) file format.\n\n       The main extension is the bridge_ports option, with it you describe that the interface is a bridge and what ports does it have. These ports are the interfaces that  are  part  of  the\n       bridge, and they shouldn't have any stanzas defining them on the interfaces file. Other extensions allow you to tune the bridge options or change a bridge behaviour.\n\n       We'll see this with an example:\n       auto br0\n       iface br0 inet static\n           address 192.168.1.2\n           network 192.168.1.0\n           netmask 255.255.255.0\n           broadcast 192.168.1.255\n           gateway 192.168.1.1\n           bridge_ports all\n       Well,  after  setting  this, an ifup br0, or the next reboot, should let you have a bridge up and running, after waiting for the ports to get to the forwarding status, of course. This\n       bridge will be using all your ethX interfaces, as we have stated on the bridge_ports line.\n\n       The Debian bridge setup scripts will wait for it to get ready to work. They do this by trying to guess the maximum time that the bridge will need to get to the forwarding status,  and\n       by  default,  they  will wait for the bridge to get there, or for the estimated maximum time to go by.  This is done so that the services that are loaded after the bridge setup have a\n       working network interface and don't fail because the bridge is still not working. See bridge_maxwait if you want to change this behaviour.\n\n       An example of how to setup a so called anonymous bridge (a bridge without an assigned IP) would look like this:\n       iface br1 inet manual\n            bridge_ports eth1 eth2\n            bridge_maxwait 0\n       Here we select the interfaces eth1 and eth2 to be added to the bridge interface br1, which will be an anonymous bridge, we also tell the scripts not to wait, as we won't be having any\n       service running on that interface (it doesn't even have an IP).\n\n       An example of a little more complex bridge setup could be:\n       auto br0\n       iface br0 inet static\n           address 192.168.1.2\n           network 192.168.1.0\n           netmask 255.255.255.0\n           broadcast 192.168.1.255\n           bridge_ports all weird0\n           bridge_bridgeprio 32767\n           bridge_portprio eth0 129\n           bridge_fd 5\n           pre-up ip addr flush dev eth0\n       In this example we select all the eth* devices plus a weird device to be added to the bridge, also we change the bridge default priority to a higher one so that  this  bridge  becomes\n       the  root (if there are no bridges with higher priority on the net, that is) and also we lower priority of port eth0 so that it is not used if there are other ports with higher prior‐\n       ity to reach the same destination, at the end we lower the default forward delay and we add a pre-up command to remove all addresses on eth0 as this interface had an  address  set  up\n       before (needed only on weird/broken setups).\n\n       If  there is a need to set up any of the interfaces participating on the bridge and not the bridge itself, then we must add the commands to set up those settings in a \"pre-up\" or \"up\"\n       statement. This means that if we have a wireless card that we want to add to a bridge and we want to set it to master, and select the essid, instead of using  the  typical  wireless_*\n       commands we could add to the bridge definition something like this:\n       pre-up iwconfig wlan0 mode master essid myESSID\n       Be aware, however, that using wireless cards as part of a bridge is not a good idea if the card belonging to the bridge is in managed mode.  Trying to bridge packets coming out of our\n       LAN  through  a  wireless  card that is set in managed mode (the card is a client of an AP) is bound to give problems, as the AP will probably refuse packets with source MAC addresses\n       which are not associated (this will be the case of other machines going through the wireless card of the bridge into the AP).\n\n       Multiple stanzas of a bridge definition are currently not supported, so if you want to add a ipv6 and a ipv4 to a bridge do it all in one definition by using the \"up\" option. If  how‐\n       ever you still want to use multiple stanzas or would like to read more on this bug you can see it at http://bugs.debian.org/319832\n\nIFACE OPTIONS\n       A little explanation on the new options that can be used on /etc/network/interfaces to setup the bridge, so you don't have to go and look at the scripts...\n\n       bridge_ports interface specification\n              this  option  must exist for the scripts to setup the bridge, with it you specify the ports you want to add to your bridge, either using \"none\" if you want a bridge without any\n              interfaces or you want to add them later using brctl, or a list of the interfaces you want to add separated by spaces, for example:\n              bridge_ports eth0 eth4\n              You should not put any lines to configure the interfaces that will be used by the bridge, as this will be setup automatically by the scripts when bringing the bridge up.\n\n              If you need to specify the interfaces more flexibly, you can use the following syntax (most useful on a Xen dom0):\n              bridge_ports regex (eth|vif).*\n              This means to evaluate (as in egrep(1)) the expressions that follow after \"regex\" until either the end or a \"noregex\" statement is reached.  The regular expressions are  evalu‐\n              ated against all local interfaces and those that match are added.\n\n              Specifying \"all\" is short for \"regex eth.* em.* p[0-9].* noregex\" and will get all the ethX and biosdevname-format (emX and pX) interfaces added to the bridge.\n\n              Carrying this to the extremes, the following is valid syntax:\n              bridge_ports all regex if.0 noregex ext0 regex vif.*\n              This will add all ethX interfaces, the ifX0 interfaces, the ext0 interface and all vifX interfaces.\n\n       bridge_ageing time\n              set ageing time, default is 300, can have a fractional part.\n\n       bridge_bridgeprio priority\n              set bridge priority, priority is between 0 and 65535, default is 32768, affects bridge id, lowest priority bridge will be the root.\n\n       bridge_fd time\n              set bridge forward delay to time seconds, default is 15, can have a fractional part.\n\n       bridge_gcint time\n              set garbage collection interval to time seconds, default is 4, can have a fractional part.\n\n       bridge_hello time\n              set hello time to time seconds, default is 2, can have a fractional part.\n\n       bridge_hw MAC_address|interface\n              set  the Ethernet MAC address of the bridge to the specified one or to the address of the specified interface.  There were some concerns of how this was done in the past but we\n              are doing it on a new way now, it is currently not only considered safe but also necessary or recommended in a lot of scenarios like IPv6, DHCP reservations, ... the ussage  of\n              bridge_hw setting if the recommended way of doing this.\n\n       bridge_maxage time\n              set max message age to time seconds, default is 20, can have a fractional part.\n\n       bridge_maxwait time\n              forces to time seconds the maximum time that the Debian bridge setup scripts will wait for the bridge ports to get to the forwarding status, doesn't allow factional part. If it\n              is equal to 0 then no waiting is done.\n\n       bridge_pathcost port cost\n              set path cost for a port, from 1 to 65535, default is 100, port is the name of the interface to which this setting applies.\n\n       bridge_portprio port priority\n              set port priority, from 0 (max) to 63 (min), default is 32, affects port id, port is the name of the interface to which this setting applies.\n\n       bridge_stp state\n              turn  spanning tree protocol on/off, state values are on or yes to turn stp on and any other thing to set it off, default has changed to off for security reasons in latest ker‐\n              nels, so you should specify if you want stp on or off with this option, and not rely on your kernel's default behaviour.\n\n       bridge_token token\n              set IPv6 tokenized interface identifier for the bridge to token, see ip-token(8) for more info on this.\n\n       bridge_vlan_aware yes/no\n              specify if the bridge is vlan aware an thus needs vlan filtering to be activated or not.\n\n       bridge_waitport time [ports]\n              wait for a max of time seconds for the specified ports to become available, if no ports are specified then those specified on bridge_ports will  be  used  here.  Specifying  no\n              ports here should not be used if we are using regex or \"all\" on bridge_ports, as it wouldn't work.\n\nFILES\n       /etc/network/interfaces\n              definitions of network interfaces See interfaces(5) for more information.\n\n       KNOWN BUGS/LIMITATIONS\n              The default values shown here are current values as of this writing, but as they are not related to this package but to the bridge code itself, can change anytime.\n\nAUTHOR\n       This manpage was written by Santiago Garcia Mantinan   based on interfaces(5).\n\nSEE ALSO\n       brctl(8), interfaces(5), ifup(8), ip-token(8), iwconfig(8), run-parts(8).\n\nbridge-utils                                                                            January 13 2008                                                             BRIDGE-UTILS-INTERFACES(5)","ref":"bridge-utils-interfaces.html"},{"type":"extras","title":"btrfs","doc":"BTRFS(8)                                                                                     BTRFS                                                                                    BTRFS(8)\n\nNAME\n       btrfs - a toolbox to manage btrfs filesystems\n\nSYNOPSIS\n       btrfs [global options]   [ ...]   [options] [ ]\n\nDESCRIPTION\n       The  btrfs utility is a toolbox for managing btrfs filesystems.  There are command groups to work with subvolumes, devices, for whole filesystem or other specific actions. See section\n       COMMANDS.\n\n       There are also standalone tools for some tasks like btrfs-convert(8) or btrfstune(8) that were separate historically and/or haven't been  merged  to  the  main  utility.  See  section\n       STANDALONE TOOLS for more details.\n\n       For other topics (mount options, etc) please refer to the separate manual page btrfs(5).\n\nCOMMAND SYNTAX\n       Any  command name can be shortened so long as the shortened form is unambiguous, however, it is recommended to use full command names in scripts.  All command groups have their manual\n       page named btrfs- .\n\n       For example: it is possible to run btrfs sub snaps instead of btrfs subvolume snapshot.  But btrfs file s is not allowed, because file s may be interpreted both as filesystem show and\n       as filesystem sync.\n\n       If the command name is ambiguous, the list of conflicting options is printed.\n\n       Sizes, both upon input and output, can be expressed in either SI or IEC-I units (see numfmt(1)) with the suffix B appended.  All numbers will be formatted according to  the  rules  of\n       the C locale (ignoring the shell locale, see locale(7)).\n\n       For an overview of a given command use btrfs command --help or btrfs [command...] help --full to print all available options for all commands.\n\n       There are global options that are passed between btrfs and the group name and affect behaviour not specific to the command, e.g. verbosity or the type of the output:\n\n          btrfs -q subvolume create ...\n          btrfs --dry-run subvolume create ...\n\n       --format  \n              if supported by the command, print subcommand output in that format (text, json)\n\n       -v|--verbose\n              increase verbosity of the subcommand\n\n       -q|--quiet\n              print only errors\n\n       --log  \n              set log level (default, info, verbose, debug, quiet)\n\n       The remaining options are relevant only for the main tool:\n\n       --help print condensed help for all subcommands\n\n       --version\n              print version string\n\nCOMMANDS\n       balance\n              Balance btrfs filesystem chunks across single or several devices.  See btrfs-balance(8) for details.\n\n       check  Do off-line check on a btrfs filesystem.  See btrfs-check(8) for details.\n\n       device Manage devices managed by btrfs, including add/delete/scan and so on.  See btrfs-device(8) for details.\n\n       filesystem\n              Manage a btrfs filesystem, including label setting/sync and so on.  See btrfs-filesystem(8) for details.\n\n       inspect-internal\n              Debug tools for developers/hackers.  See btrfs-inspect-internal(8) for details.\n\n       property\n              Get/set a property from/to a btrfs object.  See btrfs-property(8) for details.\n\n       qgroup Manage quota group(qgroup) for btrfs filesystem.  See btrfs-qgroup(8) for details.\n\n       quota  Manage quota on btrfs filesystem like enabling/rescan and etc.  See btrfs-quota(8) and btrfs-qgroup(8) for details.\n\n       receive\n              Receive subvolume data from stdin/file for restore and etc.  See btrfs-receive(8) for details.\n\n       replace\n              Replace btrfs devices.  See btrfs-replace(8) for details.\n\n       rescue Try to rescue damaged btrfs filesystem.  See btrfs-rescue(8) for details.\n\n       restore\n              Try to restore files from a damaged btrfs filesystem.  See btrfs-restore(8) for details.\n\n       scrub  Scrub a btrfs filesystem.  See btrfs-scrub(8) for details.\n\n       send   Send subvolume data to stdout/file for backup and etc.  See btrfs-send(8) for details.\n\n       subvolume\n              Create/delete/list/manage btrfs subvolume.  See btrfs-subvolume(8) for details.\n\nSTANDALONE TOOLS\n       New functionality could be provided using a standalone tool. If the functionality proves to be useful, then the standalone tool is declared obsolete and its functionality is copied to\n       the main tool. Obsolete tools are removed after a long (years) depreciation period.\n\n       Tools that are still in active use without an equivalent in btrfs:\n\n       btrfs-convert\n              in-place conversion from ext2/3/4 filesystems to btrfs\n\n       btrfstune\n              tweak some filesystem properties on a unmounted filesystem\n\n       btrfs-select-super\n              rescue tool to overwrite primary superblock from a spare copy\n\n       btrfs-find-root\n              rescue helper to find tree roots in a filesystem\n\n       For space-constrained environments, it's possible to build a single binary with functionality of several standalone tools. This is following the concept of busybox where the file name\n       selects the functionality. This works for symlinks or hardlinks. The full list can be obtained by btrfs help --box.\n\nEXIT STATUS\n       btrfs returns a zero exit status if it succeeds. Non zero is returned in case of failure.\n\nAVAILABILITY\n       btrfs is part of btrfs-progs.  Please refer to the documentation at https://btrfs.readthedocs.io.\n\nSEE ALSO\n       btrfs(5),  btrfs-balance(8),  btrfs-check(8),  btrfs-convert(8),  btrfs-device(8),  btrfs-filesystem(8), btrfs-inspect-internal(8), btrfs-property(8), btrfs-qgroup(8), btrfs-quota(8),\n       btrfs-receive(8), btrfs-replace(8), btrfs-rescue(8), btrfs-restore(8), btrfs-scrub(8), btrfs-send(8), btrfs-subvolume(8), btrfstune(8), mkfs.btrfs(8)\n\n6.14                                                                                     Apr 17, 2025                                                                                 BTRFS(8)","ref":"btrfs.html"},{"type":"extras","title":"build.xml","doc":"build.xml(5)                                                                          File Formats Manual                                                                         build.xml(5)\n\nNAME\n       build.xml - configuration file used by Apache Ant to build projects\n\nDESCRIPTION\n       The file build.xml is the default configuration file used by ant to determine target to build for a specific project. It can be considered the ant equivalent of Makefile.\n\n       The format of ant is XML and for each project a separate file is constructed.  The buildfile consists of one or more tasks. An example is given below.\n\n        \n\n          \n            \n          \n\n        \n\n       This example has one target and it is defaulted. The target itself consists of one task javac which compiles the files in the src directory.\n\nTARGETS\n       Targets can depend on other targets. These dependencies are given by the depends attribute of the   element.\n\nTASKS\n       A task is a piece of code that is executed.  Ant recognizes built-in task, optional tasks, but one can also write new tasks.\n\n       Built-in tasks\n\n       The  built-in  tasks are: Ant, AntCall, AntStructure, AntVersion, Apply, Apt, Available, Basename, BuildNumber, BUnzip2, BZip2, Checksum, Chmod, Concat, Condition, Copy, Componentdef,\n       Cvs, CvsChangeLog, CvsVersion, CVSPass, CvsTagDiff, Defaultexcludes, Delete, Deltree, Dependset, Diagnostics, Dirname, Ear, Echo, EchoXML, Exec, Fail, Filter,  FixCRLF,  GenKey,  Get,\n       HostInfo, GUnzip, GZip, Import, Include, Input, Jar, Java, Javac, Javadoc, Length, LoadFile, LoadProperties, LoadResource, Local, MakeURL, Mail, MacroDef, Manifest, ManifestClassPath,\n       Mkdir,  Move, Nice, Parallel, Patch, PathConvert, PreSetDef, Property, PropertyHelper, Record, Replace, ResourceCount, Retry, Rmic, Sequential, SignJar, Sleep, Sql, SubAnt, Sync, Tar,\n       Taskdef, Tempfile, Touch, Truncate, TStamp, Typedef, Unjar, Untar, Unwar, Unzip, Uptodate, Waitfor, WhichResource, War, XmlProperty, XSLT, Zip\n\n       Java   Executes a Java class within the running (Ant) VM or forks another VM if specified. Below are some of the attributes to the   element:\n\n              classname (required) the Java class to execute\n\n              fork if enabled triggers the class execution in another VM (disabled by default)\n\n              jvm the command used to invoke the Java Virtual Machine, default is java. The command is resolved by java.lang.Runtime.exec().  Ignored if fork is disabled.\n\n              Other arguments are classpath, classpathref, maxmemory, failonerror, dir and output.\n\n       Javac  Compiles a source tree within the running (Ant) VM.\n\n              srcdir (required) location of the java files\n\n              destdir location to store the class files\n\n              debug indicates whether source should be compiled with debug information; defaults to off\n\n              target generate class files for specific VM version (e.g., 1.4, 1.5, etc).\n\n              includes comma-separated list of patterns of files that must be included; all files are included when omitted\n\n              excludes comma-separated list of patterns of files that must be excluded; no files (except default excludes) are excluded when omitted.\n\n              defaultexcludes indicates whether default excludes should be used (yes | no); default excludes are used when omitted.\n\n              Other arguments are includesfile, excludesfile, classpath, bootclasspath, classpathref, bootclasspathref, extdirs, encoding, deprecation, verbose,  includeAntRuntime,  include‐\n              JavaRuntime and failonerror.\n\nProperties\n       A project can have a set of properties, which consist of a name value combination. Within tasks they can be used by placing them between \"${\" and \"}\", as in \"${builddir}/classes\".\n\n       Built-in Properties\n\n       Ant provides access to all system properties as if they had been defined using a   task. For example, ${os.name} expands to the name of the operating system.\n\n       basedir\n              the absolute path of the project's basedir (as set with the basedir attribute of  ).\n\n       ant.file\n              the absolute path of the buildfile.\n\n       ant.version\n              the version of Ant.\n\n       ant.project.name\n              the name of the project that is currently executing; it is set in the name attribute of  .\n\n       ant.java.version\n              the JVM version Ant detected.\n\nClasspath\n       The classpath can be set by using the   element:\n\n        \n          \n          \n          \n            \n            \n\nSEE ALSO\n       ant(1)\n\nAUTHOR\n       This manpage is made by Egon Willighagen   and based on the Ant Manual  .\n\nDebian Linux                                                                             February 2010                                                                            build.xml(5)","ref":"build-xml.html"},{"type":"extras","title":"bup-config","doc":"bup-config(5)                                                                                                                                                                    bup-config(5)\n\nNAME\n       bup-config - bup configuration options\n\nDESCRIPTION\n       The following options may be set in the relevant git config (git-config(1)).\n\nOPTIONS\n       pack.packSizeLimit\n              Respected  when  writing pack files (e.g. via bup save ...).  Currently read from the repository to which the pack files are being written, excepting bup on REMOTE... which in‐\n              correctly reads the value from the REMOTE repository.\n\nSEE ALSO\n       git-config(1)\n\nBUP\n       Part of the bup(1) suite.\n\nAUTHORS\n       Rob Browning rlb@defaultvalue.org\n\nBup 0.33.7                                                                                2025-01-11                                                                             bup-config(5)","ref":"bup-config.html"},{"type":"extras","title":"capsule@.service","doc":"CAPSULE@.SERVICE(5)                                                                    capsule@.service                                                                    CAPSULE@.SERVICE(5)\n\nNAME\n       capsule@.service - System unit for the capsule service manager\n\nSYNOPSIS\n       capsule@NAME.service\n\nDESCRIPTION\n       Service managers for capsules run in capsule@NAME.service system units, with the capsule name as the instance identifier. Capsules are way to run additional instances of the service\n       manager, under dynamic user IDs, i.e. UIDs that are allocated when the capsule service manager is started, and released when it is stopped.\n\n       In many ways capsule@.service is similar to the per-user user@.service service manager, but there are a few important distinctions:\n\n       •   The capsule service manager utilizes DynamicUser= (see systemd.exec(5)) to allocate a new UID dynamically on invocation. The user name is automatically generated from the capsule\n           name, by prefixing \"c-\". The UID is released when the service is terminated. The user service manager on the other hand operates under a statically allocated user ID that must be\n           pre-existing, before the user service manager is invoked.\n\n       •   User service managers register themselves with pam(8), capsule service managers do not.\n\n       •   User service managers typically read their configuration from a $HOME directory below /home/, capsule service managers from a $HOME directory below /var/lib/capsules/.\n\n       •   User service managers are collectively contained in the user.slice unit, capsule service managers in capsule.slice. Also see systemd.special(7).\n\n       •   User service managers start the user unit default.target initially. Capsule service managers invoke the user unit capsule@.target instead.\n\n       The capsule service manager and the capsule's bus broker can be reached via the --capsule= switch to systemctl(1), systemd-run(1) and busctl(1).\n\n       New capsules can be started via a simple systemctl start capsule@NAME.service command, and stopped via systemctl stop capsule@NAME.service. Starting a capsule will implicitly create a\n       home directory /var/lib/capsules/NAME/, if missing. A runtime directory is created as /run/capsules/NAME/. To remove these resources use systemctl clean capsule@NAME.service, for\n       example with the --what=all switch.\n\n       The capsule@.service unit invokes a systemd --user service manager process. This means unit files are looked for according to the sames rules as for regular user service managers, for\n       example in /var/lib/capsules/NAME/.config/systemd/user/.\n\n       Capsule names may be chosen freely by the user, however, they must be suitable as UNIX filenames (i.e. 255 characters max, and contain no \"/\"), and when prefixed with \"p-\" be suitable\n       as a user name matching strict POSIX rules, see User/Group Name Syntax[1] for details.\n\n       Added in version 256.\n\nEXAMPLES\n       Example 1. Create a new capsule, invoke two programs in it (one interactively), terminate it, and clean everything up\n\n           # systemctl start capsule@tatze.service\n           # systemd-run --capsule=tatze --unit=sleeptest.service sleep 999\n           # systemctl --capsule=tatze status sleeptest.service\n           # systemd-run -t --capsule=tatze bash\n           # systemctl --capsule=tatze stop sleeptest.service\n           # systemctl stop capsule@tatze.service\n           # systemctl clean --all capsule@tatze.service\n\nSEE ALSO\n       systemd(1), user@.service(5), systemd.service(5), systemd.slice(5), systemd.exec(5), systemd.special(7), systemctl(1), systemd-run(1), busctl(1), pam(8)\n\nNOTES\n        1. User/Group Name Syntax\n           https://systemd.io/USER_NAMES\n\nsystemd 257.7                                                                                                                                                              CAPSULE@.SERVICE(5)","ref":"capsule-service.html"},{"type":"extras","title":"charmap","doc":"charmap(5)                                                                            File Formats Manual                                                                           charmap(5)\n\nNAME\n       charmap - character set description file\n\nDESCRIPTION\n       A  character  set description (charmap) defines all available characters and their encodings in a character set.  localedef(1) can use charmaps to create locale variants for different\n       character sets.\n\n   Syntax\n       The charmap file starts with a header that may consist of the following keywords:\n\n        \n              is followed by the name of the character map.\n\n        \n              is followed by a character that will be used as the comment character for the rest of the file.  It defaults to the number sign (#).\n\n        \n              is followed by a character that should be used as the escape character for the rest of the file to mark characters that should be interpreted in a special way.  It defaults  to\n              the backslash (\\).\n\n        \n              is followed by the maximum number of bytes for a character.  The default value is 1.\n\n        \n              is followed by the minimum number of bytes for a character.  This value must be less than or equal than  .  If not specified, it defaults to  .\n\n       The character set definition section starts with the keyword CHARMAP in the first column.\n\n       The following lines may have one of the two following forms to define the character set:\n\n         byte-sequence comment\n              This form defines exactly one character and its byte sequence, comment being optional.\n\n        ..  byte-sequence comment\n              This form defines a character range and its byte sequence, comment being optional.\n\n       The character set definition section ends with the string END CHARMAP.\n\n       The character set definition section may optionally be followed by a section to define widths of characters.\n\n       The WIDTH_DEFAULT keyword can be used to define the default width for all characters not explicitly listed.  The default character width is 1.\n\n       The width section for individual characters starts with the keyword WIDTH in the first column.\n\n       The following lines may have one of the two following forms to define the widths of the characters:\n\n         width\n              This form defines the width of exactly one character.\n\n        ...  width\n              This form defines the width for all the characters in the range.\n\n       The width definition section ends with the string END WIDTH.\n\nFILES\n       /usr/share/i18n/charmaps\n              Usual default character map path.\n\nSTANDARDS\n       POSIX.2.\n\nEXAMPLES\n       The Euro sign is defined as follows in the UTF-8 charmap:\n\n             /xe2/x82/xac EURO SIGN\n\nSEE ALSO\n       iconv(1), locale(1), localedef(1), locale(5), charsets(7)\n\nLinux man-pages 6.9.1                                                                     2024-06-15                                                                                charmap(5)","ref":"charmap.html"},{"type":"extras","title":"chrony.conf","doc":"CHRONY.CONF(5)                                                                        Configuration Files                                                                       CHRONY.CONF(5)\n\nNAME\n       chrony.conf - chronyd configuration file\n\nSYNOPSIS\n       chrony.conf\n\nDESCRIPTION\n       This file configures the chronyd daemon. The compiled-in location is /etc/chrony/chrony.conf. Other locations can be specified on the chronyd command line with the -f option.\n\n       Each directive in the configuration file is placed on a separate line. The following sections describe each of the directives in turn. The directives are not case-sensitive.\n       Generally, the directives can occur in any order in the file and if a directive is specified multiple times, only the last one will be effective. Exceptions are noted in the\n       descriptions.\n\n       The configuration directives can also be specified directly on the chronyd command line. In this case each argument is parsed as a new line and the configuration file is ignored.\n\n       While the number of supported directives is large, only a few of them are typically needed. See the EXAMPLES section for configuration in typical operating scenarios.\n\n       The configuration file might contain comment lines. A comment line is any line that starts with zero or more spaces followed by any one of the following characters: !, ;, #, %. Any\n       line with this format will be ignored.\n\nDIRECTIVES\n   Time sources\n       server hostname [option]...\n           The server directive specifies an NTP server which can be used as a time source. The client-server relationship is strictly hierarchical: a client might synchronise its system\n           time to that of the server, but the server’s system time will never be influenced by that of a client.\n\n           The server can be specified by its hostname or IP address. If the hostname cannot be resolved on start, chronyd will try it again in increasing intervals, and also when the online\n           command is issued in chronyc.\n\n           The DNS record can change over time. The used address will be replaced with a newly resolved address when the server becomes unreachable (i.e. no valid response to last 8\n           requests), unsynchronised, a falseticker (i.e. does not agree with a majority of other sources), or the root distance is too large (the limit can be configured by the maxdistance\n           directive). The automatic replacement happens at most once per 30 minutes.\n\n           This directive can be used multiple times to specify multiple servers.\n\n           The directive supports the following options:\n\n           minpoll poll\n               This option specifies the minimum interval between requests sent to the server as a power of 2 in seconds. For example, minpoll 5 would mean that the polling interval should\n               not drop below 32 seconds. The default is 6 (64 seconds), the minimum is -7 (1/128th of a second), and the maximum is 24 (6 months). Note that intervals shorter than 6 (64\n               seconds) should generally not be used with public servers on the Internet, because it might be considered abuse. A sub-second interval will be enabled only when the server is\n               reachable and the round-trip delay is shorter than 10 milliseconds, i.e. the server should be in a local network.\n\n           maxpoll poll\n               This option specifies the maximum interval between requests sent to the server as a power of 2 in seconds. For example, maxpoll 9 indicates that the polling interval should\n               stay at or below 9 (512 seconds). The default is 10 (1024 seconds), the minimum is -7 (1/128th of a second), and the maximum is 24 (6 months).\n\n           iburst\n               With this option, chronyd will start with a burst of 4-8 requests in order to make the first update of the clock sooner. It will also repeat the burst every time the source is\n               switched from the offline state to online with the online command in chronyc.\n\n           burst\n               With this option, chronyd will send a burst of up to 4 requests when it cannot get a good measurement from the server. The number of requests in the burst is limited by the\n               current polling interval to keep the average interval at or above the minimum interval, i.e. the current interval needs to be at least two times longer than the minimum\n               interval in order to allow a burst with two requests.\n\n           key ID\n               The NTP protocol supports a message authentication code (MAC) to prevent computers having their system time upset by rogue packets being sent to them. The MAC is generated as\n               a function of a key specified in the key file, which is specified by the keyfile directive.\n\n               The key option specifies which key (with an ID in the range 1 through 2^32-1) should chronyd use to authenticate requests sent to the server and verify its responses. The\n               server must have the same key for this number configured, otherwise no relationship between the computers will be possible.\n\n               If the server is running ntpd and the output size of the hash function used by the key is longer than 160 bits (e.g. SHA256), the version option needs to be set to 4 for\n               compatibility.\n\n           nts\n               This option enables authentication using the Network Time Security (NTS) mechanism. Unlike with the key option, the server and client do not need to share a key in a key file.\n               NTS has a Key Establishment (NTS-KE) protocol using the Transport Layer Security (TLS) protocol to get the keys and cookies required by NTS for authentication of NTP packets.\n\n               With this option, the hostname specified in the server or pool directive is the NTS-KE server or pool of NTS-KE servers respectively. The NTP server usually runs on the same\n               host, but it can be separated from the NTS-KE server (the hostname or address of the NTP server is provided to the client by the NTS-KE server).\n\n               The NTS-KE server can be specified by IP address if it is included in the server’s certificate as a Subject Alternative Name (SAN).\n\n           certset ID\n               This option specifies which set of trusted certificates should be used to verify the server’s certificate when the nts option is enabled. Sets of certificates can be specified\n               with the ntstrustedcerts directive. The default set is 0, which by default contains certificates of the system’s default trusted certificate authorities.\n\n           maxdelay delay\n               chronyd uses the network round-trip delay to the server to determine how accurate a particular measurement is likely to be. Long round-trip delays indicate that the request,\n               or the response, or both were delayed. If only one of the messages was delayed the measurement error is likely to be substantial.\n\n               For small variations in the round-trip delay, chronyd uses a weighting scheme when processing the measurements. However, beyond a certain level of delay the measurements are\n               likely to be so corrupted as to be useless. (This is particularly so on wireless networks and other slow links, where a long delay probably indicates a highly asymmetric delay\n               caused by the response waiting behind a lot of packets related to a download of some sort).\n\n               If the user knows that round trip delays above a certain level should cause the measurement to be ignored, this level can be defined with the maxdelay option. For example,\n               maxdelay 0.3 would indicate that measurements with a round-trip delay greater than 0.3 seconds should be ignored. The default value is 3 seconds and the maximum value is 1000\n               seconds.\n\n           maxdelayratio ratio\n               This option is similar to the maxdelay option above. chronyd keeps a record of the minimum round-trip delay amongst the previous measurements that it has buffered. If a\n               measurement has a round-trip delay that is greater than the specified ratio times the minimum delay, it will be rejected. By default, this test is disabled.\n\n           maxdelaydevratio ratio\n               If a measurement has a ratio of the increase in the round-trip delay from the minimum delay amongst the previous measurements to the standard deviation of the previous\n               measurements that is greater than the specified ratio, it will be rejected. The default is 10.0.\n\n           maxdelayquant p\n               This option disables the maxdelaydevratio test and specifies the maximum acceptable delay as a quantile of the round-trip delay instead of a function of the minimum delay\n               amongst the buffered measurements. If a measurement has a round-trip delay that is greater than a long-term estimate of the p-quantile, it will be rejected.\n\n               The specified p value should be between 0.05 and 0.95. For example, maxdelayquant 0.2 would indicate that only measurements with the lowest 20 percent of round-trip delays\n               should be accepted. Note that it can take many measurements for the estimated quantile to reach the expected value. This option is intended for synchronisation in mostly\n               static local networks with very short polling intervals and possibly combined with the filter option. By default, this test is disabled in favour of the maxdelaydevratio test.\n\n           mindelay delay\n               This option specifies a fixed minimum round-trip delay to be used instead of the minimum amongst the previous measurements. This can be useful in networks with static\n               configuration to improve the stability of corrections for asymmetric jitter, weighting of the measurements, and the maxdelayratio and maxdelaydevratio tests. The value should\n               be set accurately in order to have a positive effect on the synchronisation.\n\n           asymmetry ratio\n               This option specifies the asymmetry of the network jitter on the path to the source, which is used to correct the measured offset according to the delay. The asymmetry can be\n               between -0.5 and +0.5. A negative value means the delay of packets sent to the source is more variable than the delay of packets sent from the source back. By default, chronyd\n               estimates the asymmetry automatically.\n\n           offset offset\n               This option specifies a correction (in seconds) which will be applied to offsets measured with this source. It’s particularly useful to compensate for a known asymmetry in\n               network delay or timestamping errors. For example, if packets sent to the source were on average delayed by 100 microseconds more than packets sent from the source back, the\n               correction would be -0.00005 (-50 microseconds). The default is 0.0.\n\n           minsamples samples\n               Set the minimum number of samples kept for this source. This overrides the minsamples directive.\n\n           maxsamples samples\n               Set the maximum number of samples kept for this source. This overrides the maxsamples directive.\n\n           filter polls\n               This option enables a median filter to reduce noise in NTP measurements. The filter will process samples collected in the specified number of polls into a single sample. It is\n               intended to be used with very short polling intervals in local networks where it is acceptable to generate a lot of NTP traffic.\n\n           offline\n               If the server will not be reachable when chronyd is started, the offline option can be specified. chronyd will not try to poll the server until it is enabled to do so (by\n               using the online command in chronyc).\n\n           auto_offline\n               With this option, the server will be assumed to have gone offline when sending a request fails, e.g. due to a missing route to the network. This option avoids the need to run\n               the offline command from chronyc when disconnecting the network link. (It will still be necessary to use the online command when the link has been established, to enable\n               measurements to start.)\n\n           prefer\n               Prefer this source over other selectable sources without the prefer option.\n\n           noselect\n               Never select this source. This is particularly useful for monitoring.\n\n           trust\n               Assume time from this source is always true. It can be rejected as a falseticker in the source selection only if another source with this option does not agree with it.\n\n           require\n               Require that at least one of the sources specified with this option is selectable (i.e. recently reachable and not a falseticker) before updating the clock. Together with the\n               trust option this might be useful to allow a trusted authenticated source to be safely combined with unauthenticated sources in order to improve the accuracy of the clock.\n               They can be selected and used for synchronisation only if they agree with the trusted and required source.\n\n           xleave\n               This option enables the interleaved mode of NTP. It enables the server to respond with more accurate transmit timestamps (e.g. kernel or hardware timestamps), which cannot be\n               contained in the transmitted packet itself and need to refer to a previous packet instead. This can significantly improve the accuracy and stability of the measurements.\n\n               The interleaved mode is compatible with servers that support only the basic mode. Note that even servers that support the interleaved mode might respond in the basic mode as\n               the interleaved mode requires the servers to keep some state for each client and the state might be dropped when there are too many clients (e.g. clientloglimit is too small),\n               or it might be overwritten by other clients that have the same IP address (e.g. computers behind NAT or someone sending requests with a spoofed source address).\n\n               The xleave option can be combined with the presend option in order to shorten the interval in which the server has to keep the state to be able to respond in the interleaved\n               mode.\n\n           polltarget target\n               Target number of measurements to use for the regression algorithm which chronyd will try to maintain by adjusting the polling interval between minpoll and maxpoll. A higher\n               target makes chronyd prefer shorter polling intervals. The default is 8 and a useful range is from 6 to 60.\n\n           port port\n               This option allows the UDP port on which the server understands NTP requests to be specified. For normal servers this option should not be required (the default is 123, the\n               standard NTP port).\n\n           ntsport port\n               This option specifies the TCP port on which the server is listening for NTS-KE connections when the nts option is enabled. The default is 4460.\n\n           presend poll\n               If the timing measurements being made by chronyd are the only network data passing between two computers, you might find that some measurements are badly skewed due to either\n               the client or the server having to do an ARP lookup on the other party prior to transmitting a packet. This is more of a problem with long sampling intervals, which might be\n               similar in duration to the lifetime of entries in the ARP caches of the machines.\n\n               In order to avoid this problem, the presend option can be used. It takes a single integer argument, which is the smallest polling interval for which an extra pair of NTP\n               packets will be exchanged between the client and the server prior to the actual measurement. For example, with the following option included in a server directive:\n\n                   presend 9\n\n               when the polling interval is 512 seconds or more, an extra NTP client packet will be sent to the server a short time (2 seconds) before making the actual measurement.\n\n               If the presend option is used together with the xleave option, chronyd will send two extra packets instead of one.\n\n           minstratum stratum\n               When the synchronisation source is selected from available sources, sources with lower stratum are normally slightly preferred. This option can be used to increase stratum of\n               the source to the specified minimum, so chronyd will avoid selecting that source. This is useful with low-stratum sources that are known to be unreliable or inaccurate and\n               which should be used only when other sources are unreachable.\n\n           version version\n               This option sets the NTP version of packets sent to the server. This can be useful when the server runs an old NTP implementation that does not respond to requests using a\n               newer version. The default version depends on other options. If the extfield or xleave option is used, the default version is 4. If those options are not used and the key\n               option specifies a key using a hash function with output size longer than 160 bits (e.g. SHA256), the default version is 3 for compatibility with older chronyd servers. In\n               other cases, the default version is 4.\n\n           copy\n               This option specifies that the server and client are closely related, their configuration does not allow a synchronisation loop to form between them, and the client is allowed\n               to assume the reference ID and stratum of the server. This is useful when multiple instances of chronyd are running on one computer (e.g. for security or performance reasons),\n               one primarily operating as a client to synchronise the system clock and other instances started with the -x option to operate as NTP servers for other computers with their NTP\n               clocks synchronised to the first instance.\n\n           extfield type\n               This option enables an NTPv4 extension field specified by its type as a hexadecimal number. It will be included in requests sent to the server and processed in received\n               responses if the server supports it. Note that some server implementations do not respond to requests containing an unknown extension field (chronyd as a server responded to\n               such requests since version 2.0).\n\n               This option can be used multiple times to enable multiple extension fields.\n\n               The following extension fields are supported:\n\n               F323\n                   An experimental extension field to enable several improvements that were proposed for the next version of the NTP protocol (NTPv5). The field contains root delay and\n                   dispersion in higher resolution and a monotonic receive timestamp, which enables a frequency transfer between the server and client to significantly improve stability of\n                   the synchronisation. This field should be enabled only for servers known to be running chronyd version 4.2 or later.\n\n               F324\n                   An experimental extension field to enable the use of the Precision Time Protocol (PTP) correction field in NTP-over-PTP messages updated by one-step end-to-end transparent\n                   clocks in network switches and routers to significantly improve accuracy and stability of the synchronisation. NTP-over-PTP can be enabled by the ptpport directive and\n                   setting the port option to the PTP port. The corrections are applied only to NTP measurements with HW timestamps (enabled by the hwtimestamp directive). This field should\n                   be enabled only for servers known to be running chronyd version 4.5 or later.\n\n           ipv4, ipv6\n               These options force chronyd to use only IPv4 or IPv6 addresses respectively for this source. They do not override the -4 or -6 option on the chronyd command line.\n\n       pool name [option]...\n           The syntax of this directive is similar to that for the server directive, except that it is used to specify a pool of NTP servers rather than a single NTP server. The pool name is\n           expected to resolve to multiple addresses which might change over time.\n\n           This directive can be used multiple times to specify multiple pools.\n\n           All options valid in the server directive can be used in this directive too. There is one option specific to the pool directive:\n\n           maxsources sources\n               This option sets the desired number of sources to be used from the pool. chronyd will repeatedly try to resolve the name until it gets this number of sources responding to\n               requests. The default value is 4 and the maximum value is 16.\n\n               An example of the pool directive is\n\n                   pool pool.ntp.org iburst maxsources 3\n\n       peer hostname [option]...\n           The syntax of this directive is identical to that for the server directive, except that it specifies a symmetric association with an NTP peer instead of a client/server\n           association with an NTP server. A single symmetric association allows the peers to be both servers and clients to each other. This is mainly useful when the NTP implementation of\n           the peer (e.g. ntpd) supports ephemeral symmetric associations and does not need to be configured with an address of this host. chronyd does not support ephemeral associations.\n\n           This directive can be used multiple times to specify multiple peers.\n\n           The following options of the server directive do not work in the peer directive: iburst, burst, nts, presend, copy.\n\n           When using the xleave option, both peers must support and have enabled the interleaved mode, otherwise the synchronisation will work in one direction only. When a key is specified\n           by the key option to enable authentication, both peers must use the same key and the same key number.\n\n           Note that the symmetric mode is less secure than the client/server mode. A denial-of-service attack is possible on unauthenticated symmetric associations, i.e. when the peer was\n           specified without the key option. An attacker who does not see network traffic between two hosts, but knows that they are peering with each other, can periodically send them\n           unauthenticated packets with spoofed source addresses in order to disrupt their NTP state and prevent them from synchronising to each other. When the association is authenticated,\n           an attacker who does see the network traffic, but cannot prevent the packets from reaching the other host, can still disrupt the state by replaying old packets. The attacker has\n           effectively the same power as a man-in-the-middle attacker. A partial protection against this attack is implemented in chronyd, which can protect the peers if they are using the\n           same polling interval and they never sent an authenticated packet with a timestamp from future, but it should not be relied on as it is difficult to ensure the conditions are met.\n           If two hosts should be able to synchronise to each other in both directions, it is recommended to use two separate client/server associations (specified by the server directive on\n           both hosts) instead.\n\n       initstepslew step-threshold [hostname]...\n           (This directive is deprecated in favour of the makestep directive.)\n\n           The purpose of the initstepslew directive is to allow chronyd to make a rapid measurement of the system clock error at boot time, and to correct the system clock by stepping\n           before normal operation begins. Since this would normally be performed only at an appropriate point in the system boot sequence, no other software should be adversely affected by\n           the step.\n\n           If the correction required is less than a specified threshold, a slew is used instead. This makes it safer to restart chronyd whilst the system is in normal operation.\n\n           The initstepslew directive takes a threshold and a list of NTP servers as arguments. Each of the servers is rapidly polled several times, and a majority voting mechanism used to\n           find the most likely range of system clock error that is present. A step or slew is applied to the system clock to correct this error. chronyd then enters its normal operating\n           mode.\n\n           An example of the use of the directive is:\n\n               initstepslew 30 ntp1.example.net ntp2.example.net ntp3.example.net\n\n           where 3 NTP servers are used to make the measurement. The 30 indicates that if the system’s error is found to be 30 seconds or less, a slew will be used to correct it; if the\n           error is above 30 seconds, a step will be used.\n\n           The initstepslew directive can also be used in an isolated LAN environment, where the clocks are set manually. The most stable computer is chosen as the primary server and the\n           other computers are its clients. If each of the clients is configured with the local directive, the server can be set up with an initstepslew directive which references some or\n           all of the clients. Then, if the server machine has to be rebooted, the clients can be relied on to act analogously to a flywheel and preserve the time for a short period while\n           the server completes its reboot.\n\n           The initstepslew directive is functionally similar to a combination of the makestep and server directives with the iburst option. The main difference is that the initstepslew\n           servers are used only before normal operation begins and that the foreground chronyd process waits for initstepslew to finish before exiting. This prevent programs started in the\n           boot sequence after chronyd from reading the clock before it has been stepped. With the makestep directive, the waitsync command of chronyc can be used instead.\n\n       refclock driver parameter[:option]... [option]...\n           The refclock directive specifies a hardware reference clock to be used as a time source. It has two mandatory parameters, a driver name and a driver-specific parameter. The two\n           parameters are followed by zero or more refclock options. Some drivers have special options, which can be appended to the driver-specific parameter using the : character.\n\n           This directive can be used multiple times to specify multiple reference clocks.\n\n           There are four drivers included in chronyd:\n\n           PPS\n               Driver for the kernel PPS (pulse per second) API. The parameter is the path to the PPS device (typically /dev/pps?). As PPS refclocks do not supply full time, another time\n               source (e.g. NTP server or non-PPS refclock) is needed to complete samples from the PPS refclock. An alternative is to enable the local directive to allow synchronisation with\n               some unknown but constant offset. The driver supports the following option:\n\n               clear\n                   By default, the PPS refclock uses assert events (rising edge) for synchronisation. With this option, it will use clear events (falling edge) instead.\n\n               Examples:\n\n                   refclock PPS /dev/pps0 lock NMEA refid GPS1\n                   refclock SOCK /var/run/chrony.clk.ttyS0.sock offset 0.5 delay 0.2 refid NMEA noselect\n                   refclock PPS /dev/pps1:clear refid GPS2\n\n           SOCK\n               Unix domain socket driver. This driver uses a datagram socket to receive samples from another application running on the system. The parameter is the path to the socket, which\n               chronyd will create on start. The format of the messages is described in the refclock_sock.c file in the chrony source code.\n\n               An application which supports the SOCK protocol is the gpsd daemon. It can provide accurate measurements using the receiver’s PPS signal, and since version 3.25 also (much\n               less accurate) measurements based on the timing of serial data (e.g. NMEA), which can be useful when the receiver does not provide a PPS signal, or it cannot be connected to\n               the computer. The paths where gpsd expects the sockets to be created by chronyd are described in the gpsd(8) man page. Note that gpsd needs to be started after chronyd in\n               order to connect to the socket.\n\n               Examples:\n\n                   refclock SOCK /var/run/chrony.ttyS0.sock refid GPS1 poll 2 filter 4\n                   refclock SOCK /var/run/chrony.clk.ttyUSB0.sock refid GPS2 offset 0.2 delay 0.1\n\n           SHM\n               NTP shared memory driver. This driver implements the protocol of the ntpd driver type 28. It is functionally similar to the SOCK driver, but uses a shared memory segment\n               instead of a socket. The parameter is the unit number, typically a small number like 0, 1, 2, or 3, from which is derived the key of the memory segment as 0x4e545030 + unit.\n\n               The driver supports the following option:\n\n               perm=mode\n                   This option specifies the permissions of the shared memory segment created by chronyd. They are specified as a numeric mode. The default value is 0600 (read-write access\n                   for owner only).\n\n               Unlike with the SOCK driver, there is no prescribed order of starting chronyd and the program providing measurements. Both are expected to create the memory segment if it does\n               not exist. chronyd will attach to an existing segment even if it has a different owner than root or different permissions than the permissions specified by the perm option.\n               The segment needs to be created before untrusted applications or users can execute code to prevent an attacker from feeding chronyd with false measurements. The owner and\n               permissions of the segment can be verified with the ipcs -m command. For this reason, the SHM driver is deprecated in favor of SOCK.\n\n               Examples:\n\n                   refclock SHM 0 poll 3 refid GPS1\n                   refclock SHM 1:perm=0644 refid GPS2\n\n           PHC\n               PTP hardware clock (PHC) driver. The parameter is the path to the device of the PTP clock which should be used as a time source. If the clock is kept in TAI instead of UTC\n               (e.g. it is synchronised by a PTP daemon), the current UTC-TAI offset needs to be specified by the offset option. Alternatively, the pps refclock option can be enabled to\n               treat the PHC as a PPS refclock, using only the sub-second offset for synchronisation. The driver supports the following options:\n\n               nocrossts\n                   This option disables use of precise cross timestamping.\n\n               extpps\n                   This option enables a PPS mode in which the PTP clock is timestamping pulses of an external PPS signal connected to the clock. The clock does not need to be synchronised,\n                   but another time source is needed to complete the PPS samples. Note that some PTP clocks cannot be configured to timestamp only assert or clear events, and it is necessary\n                   to use the width option to filter wrong PPS samples.\n\n               pin=index\n                   This option specifies the index of the pin which should be enabled for the PPS timestamping. If the PHC does not have configurable pins (i.e. the channel function is\n                   fixed), the index needs to be set to -1 to disable the pin configuration. The default value is 0.\n\n               channel=index\n                   This option specifies the index of the channel for the PPS mode. The default value is 0.\n\n               clear\n                   This option enables timestamping of clear events (falling edge) instead of assert events (rising edge) in the PPS mode. This may not work with some clocks.\n\n               Examples:\n\n                   refclock PHC /dev/ptp0 poll 0 dpoll -2 offset -37\n                   refclock PHC /dev/ptp1:nocrossts poll 3 pps\n                   refclock PHC /dev/ptp2:extpps:pin=1 width 0.2 poll 2\n\n           The refclock directive supports the following options:\n\n           poll poll\n               Timestamps produced by refclock drivers are not used immediately, but they are stored and processed by a median filter in the polling interval specified by this option. This\n               is defined as a power of 2 and can be negative to specify a sub-second interval. The default is 4 (16 seconds). A shorter interval allows chronyd to react faster to changes in\n               the frequency of the system clock, but it might have a negative effect on its accuracy if the samples have a lot of jitter.\n\n           dpoll dpoll\n               Some drivers do not listen for external events and try to produce samples in their own polling interval. This is defined as a power of 2 and can be negative to specify a\n               sub-second interval. The default is 0 (1 second).\n\n           refid refid\n               This option is used to specify the reference ID of the refclock, as up to four ASCII characters. The default reference ID is composed from the first three characters of the\n               driver name and the number of the refclock. Each refclock must have a unique reference ID.\n\n           lock refid\n               This option can be used to lock a PPS refclock to another refclock, which is specified by its reference ID. In this mode received PPS samples are paired directly with raw\n               samples from the specified refclock.\n\n           rate rate\n               This option sets the rate of the pulses in the PPS signal (in Hz). This option controls how the pulses will be completed with real time. To actually receive more than one\n               pulse per second, a negative dpoll has to be specified (-3 for a 5Hz signal). The default is 1.\n\n           maxlockage pulses\n               This option specifies in number of pulses how old can be samples from the refclock specified by the lock option to be paired with the pulses. Increasing this value is useful\n               when the samples are produced at a lower rate than the pulses. The default is 2.\n\n           width width\n               This option specifies the width of the pulses (in seconds). It is used to filter PPS samples when the driver provides samples for both rising and falling edges. Note that it\n               reduces the maximum allowed error of the time source which completes the PPS samples. If the duty cycle is configurable, 50% should be preferred in order to maximise the\n               allowed error.\n\n           pps\n               This options forces chronyd to treat any refclock (e.g. SHM or PHC) as a PPS refclock. This can be useful when the refclock provides time with a variable offset of a whole\n               number of seconds (e.g. it uses TAI instead of UTC). Another time source is needed to complete samples from the refclock.\n\n           offset offset\n               This option can be used to compensate for a constant error. The specified offset (in seconds) is applied to all samples produced by the reference clock. The default is 0.0.\n\n           delay delay\n               This option sets the NTP delay of the source (in seconds). Half of this value is included in the maximum assumed error which is used in the source selection algorithm.\n               Increasing the delay is useful to avoid having no majority in the source selection or to make it prefer other sources. The default is 1e-9 (1 nanosecond).\n\n           stratum stratum\n               This option sets the NTP stratum of the refclock. This can be useful when the refclock provides time with a stratum other than 0. The default is 0.\n\n           precision precision\n               This option sets the precision of the reference clock (in seconds). The default value is the estimated precision of the system clock.\n\n           maxdispersion dispersion\n               Maximum allowed dispersion for filtered samples (in seconds). Samples with larger estimated dispersion are ignored. By default, this limit is disabled.\n\n           filter samples\n               This option sets the length of the median filter which is used to reduce the noise in the measurements. With each poll about 40 percent of the stored samples are discarded and\n               one final sample is calculated as an average of the remaining samples. If the length is 4 or more, at least 4 samples have to be collected between polls. For lengths below 4,\n               the filter has to be full. The default is 64. With drivers that perform their own polling (PPS, PHC, SHM), the maximum value is adjusted to the number of driver polls per\n               source poll, i.e. 2^(poll - dpoll).\n\n           prefer\n               Prefer this source over other selectable sources without the prefer option.\n\n           noselect\n               Never select this source. This is useful for monitoring or with sources which are not very accurate, but are locked with a PPS refclock.\n\n           trust\n               Assume time from this source is always true. It can be rejected as a falseticker in the source selection only if another source with this option does not agree with it.\n\n           require\n               Require that at least one of the sources specified with this option is selectable (i.e. recently reachable and not a falseticker) before updating the clock. Together with the\n               trust option this can be useful to allow a trusted, but not very precise, reference clock to be safely combined with unauthenticated NTP sources in order to improve the\n               accuracy of the clock. They can be selected and used for synchronisation only if they agree with the trusted and required source.\n\n           tai\n               This option indicates that the reference clock keeps time in TAI instead of UTC and that chronyd should correct its offset by the current TAI-UTC offset. The leapsectz or\n               leapseclist directive must be used with this option and the database must be kept up to date in order for this correction to work as expected. This option does not make sense\n               with PPS refclocks.\n\n           local\n               This option specifies that the reference clock is an unsynchronised clock which is more stable than the system clock (e.g. TCXO, OCXO, or atomic clock) and it should be used\n               as a local standard to stabilise the system clock. The refclock will bypass the source selection. There should be at most one refclock specified with this option and it should\n               have the shortest polling interval among all configured sources.\n\n           minsamples samples\n               Set the minimum number of samples kept for this source. This overrides the minsamples directive.\n\n           maxsamples samples\n               Set the maximum number of samples kept for this source. This overrides the maxsamples directive.\n\n       manual\n           The manual directive enables support at run-time for the settime command in chronyc. If no manual directive is included, any attempt to use the settime command in chronyc will be\n           met with an error message.\n\n           Note that the settime command can be enabled at run-time using the manual command in chronyc. (The idea of the two commands is that the manual command controls the manual clock\n           driver’s behaviour, whereas the settime command allows samples of manually entered time to be provided.)\n\n       acquisitionport port\n           By default, chronyd as an NTP client opens a new socket for each request with the source port chosen randomly by the operating system. The acquisitionport directive can be used to\n           specify the source port and use only one socket (per IPv4 or IPv6 address family) for all configured servers. This can be useful for getting through some firewalls. It should not\n           be used if not necessary as there is a small impact on security of the client. If set to 0, the source port of the permanent socket will be chosen randomly by the operating\n           system.\n\n           It can be set to the same port as is used by the NTP server (which can be configured with the port directive) to use only one socket for all NTP packets.\n\n           An example of the acquisitionport directive is:\n\n               acquisitionport 1123\n\n           This would change the source port used for client requests to UDP port 1123. You could then persuade the firewall administrator to open that port.\n\n       bindacqaddress address\n           The bindacqaddress directive specifies a local IP address to which chronyd will bind its NTP and NTS-KE client sockets. The syntax is similar to the bindaddress and bindcmdaddress\n           directives.\n\n           For each of the IPv4 and IPv6 protocols, only one bindacqaddress directive can be specified.\n\n       bindacqdevice interface\n           The bindacqdevice directive binds the client sockets to a network device specified by the interface name. This can be useful when the local address is dynamic, or to enable an NTP\n           source specified with a link-local IPv6 address. This directive can specify only one interface and it is supported on Linux only.\n\n           An example of the directive is:\n\n               bindacqdevice eth0\n\n       dscp point\n           The dscp directive sets the Differentiated Services Code Point (DSCP) in transmitted NTP packets to the specified value. It can improve stability of NTP measurements in local\n           networks where switches or routers are configured to prioritise forwarding of packets with specific DSCP values. The default value is 0 and the maximum value is 63.\n\n           An example of the directive (setting the Expedited Forwarding class) is:\n\n               dscp 46\n\n       dumpdir directory\n           To compute the rate of gain or loss of time, chronyd has to store a measurement history for each of the time sources it uses.\n\n           All supported systems, with the exception of macOS 10.12 and earlier, have operating system support for setting the rate of gain or loss to compensate for known errors. (On macOS\n           10.12 and earlier, chronyd must simulate such a capability by periodically slewing the system clock forwards or backwards by a suitable amount to compensate for the error built up\n           since the previous slew.)\n\n           For such systems, it is possible to save the measurement history across restarts of chronyd (assuming no changes are made to the system clock behaviour whilst it is not running).\n           The dumpdir directive defines the directory where the measurement histories are saved when chronyd exits, or the dump command in chronyc is issued.\n\n           If the directory does not exist, it will be created automatically.\n\n           The -r option of chronyd enables loading of the dump files on start. All dump files found in the directory will be removed after start, even if the -r option is not present.\n\n           An example of the directive is:\n\n               dumpdir /run/chrony\n\n           A source whose IP address is 1.2.3.4 would have its measurement history saved in the file /run/chrony/1.2.3.4.dat. History of reference clocks is saved to files named by their\n           reference ID in form of refid:XXXXXXXX.dat.\n\n       maxsamples samples\n           The maxsamples directive sets the default maximum number of samples that chronyd should keep for each source. This setting can be overridden for individual sources in the server\n           and refclock directives. The default value is 0, which disables the configurable limit. The useful range is 4 to 64.\n\n           As a special case, setting maxsamples to 1 disables frequency tracking in order to make the sources immediately selectable with only one sample. This can be useful when chronyd is\n           started with the -q or -Q option.\n\n       minsamples samples\n           The minsamples directive sets the default minimum number of samples that chronyd should keep for each source. This setting can be overridden for individual sources in the server\n           and refclock directives. The default value is 6. The useful range is 4 to 64.\n\n           Forcing chronyd to keep more samples than it would normally keep reduces noise in the estimated frequency and offset, but slows down the response to changes in the frequency and\n           offset of the clock. The offsets in the tracking and sourcestats reports (and the tracking.log and statistics.log files) may be smaller than the actual offsets.\n\n       ntsaeads ID...\n           This directive specifies a list of IDs of Authenticated Encryption with Associated Data (AEAD) algorithms enabled for NTS authentication of NTP messages. The algorithms are\n           specified in decreasing order of priority. Algorithms that are not supported by the installed version of the crypto library (Nettle, GnuTLS) are ignored.\n\n           The following IDs are supported:\n\n           •   15: AES-SIV-CMAC-256\n\n           •   30: AES-128-GCM-SIV\n\n           The default list of IDs is 30 15. AES-128-GCM-SIV is prefered over AES-SIV-CMAC-256 for shorter keys, which makes NTS cookies shorter and improves reliability of NTS in networks\n           that block or limit rate of longer NTP messages.\n\n           The ID of the used algorithm is reported for each server by the authdata command.\n\n           An example of the directive is:\n\n               ntsaeads 15\n\n           This list is used also by the NTS server.\n\n       ntsdumpdir directory\n           This directive specifies a directory for the client to save NTS cookies it received from the server in order to avoid making an NTS-KE request when chronyd is started again. The\n           cookies are saved separately for each NTP source in files named by the IP address of the NTS-KE server (e.g. 1.2.3.4.nts). By default, the client does not save the cookies.\n\n           If the directory does not exist, it will be created automatically.\n\n           An example of the directive is:\n\n               ntsdumpdir /var/lib/chrony\n\n           This directory is used also by the NTS server to save keys.\n\n       ntsrefresh interval\n           This directive specifies the maximum interval between NTS-KE handshakes (in seconds) in order to refresh the keys authenticating NTP packets. The default value is 2419200 (4\n           weeks) and the maximum value is 2^31-1 (68 years).\n\n           The interval must be longer than polling intervals of all configured NTP sources using NTS, otherwise the source with a longer polling interval will refresh the keys on each poll\n           and no NTP packets will be exchanged.\n\n       ntstrustedcerts [set-ID] file|directory\n           This directive specifies a file or directory containing trusted certificates (in the PEM format) which are needed to verify certificates of NTS-KE servers, e.g. certificates of\n           trusted certificate authorities (CA) or self-signed certificates of the servers.\n\n           The optional set-ID argument is a number in the range 0 through 2^32-1, which selects the set of certificates where certificates from the specified file or directory are added.\n           The default ID is 0, which is a set containing the system’s default trusted CAs (unless the nosystemcert directive is present). All other sets are empty by default. A set of\n           certificates can be selected for verification of an NTS server by the certset option in the server or pool directive.\n\n           This directive can be used multiple times to specify one or more sets of trusted certificates, each containing certificates from one or more files and/or directories.\n\n           It is not necessary to restart chronyd in order to reload the certificates if they change (e.g. after a renewal).\n\n           An example is:\n\n               ntstrustedcerts /etc/pki/nts/ca1.example.net.crt\n               ntstrustedcerts 1 /etc/pki/nts/ca2.example.net.crt\n               ntstrustedcerts 1 /etc/pki/nts/ca3.example.net.crt\n               ntstrustedcerts 2 /etc/pki/nts/ntp2.example.net.crt\n\n       nosystemcert\n           This directive disables the system’s default trusted CAs. Only certificates specified by the ntstrustedcerts directive will be trusted.\n\n       nocerttimecheck limit\n           This directive disables the checks of the activation and expiration times of certificates for the specified number of clock updates. It allows the NTS authentication mechanism to\n           be used on computers which start with wrong time (e.g. due to not having an RTC or backup battery). Disabling the time checks has important security implications and should be\n           used only as a last resort, preferably with a minimal number of trusted certificates. The default value is 0, which means the time checks are always enabled.\n\n           An example of the directive is:\n\n               nocerttimecheck 1\n\n           This would disable the time checks until the clock is updated for the first time, assuming the first update corrects the clock and later checks can work with correct time.\n\n       refresh interval\n           This directive specifies the interval (in seconds) between refreshing IP addresses of NTP sources specified by hostname. If the hostname no longer resolves to the currently used\n           address, it will be replaced with one of the new addresses to avoid using a server which is no longer intended for service, even if it is still responding correctly and would not\n           be replaced as unreachable. Only one source is refreshed at a time. The default value is 1209600 (2 weeks) and the maximum value is 2^31-1 (68 years). A value of 0 disables the\n           periodic refreshment.\n\n           The refresh command can be used to refresh all sources immediately.\n\n   Source selection\n       authselectmode mode\n           NTP sources can be specified with the key or nts option to enable authentication to limit the impact of man-in-the-middle attacks. The attackers can drop or delay NTP packets (up\n           to the maxdelay and maxdistance limits), but they cannot modify the timestamps contained in the packets. The attack can cause only a limited slew or step, and also cause the clock\n           to run faster or slower than real time (up to double of the maxdrift limit).\n\n           When authentication is enabled for an NTP source, it is important to disable unauthenticated NTP sources which could be exploited in the attack, e.g. if they are not reachable\n           only over a trusted network. Alternatively, the source selection can be configured with the require and trust options to synchronise to the unauthenticated sources only if they\n           agree with the authenticated sources and might have a positive impact on the accuracy of the clock. Note that in this case the impact of the attack is higher. The attackers cannot\n           cause an arbitrarily large step or slew, but they have more control over the frequency of the clock and can cause chronyd to report false information, e.g. a significantly smaller\n           root delay and dispersion.\n\n           This directive determines the default selection options for authenticated and unauthenticated sources in order to simplify the configuration with the configuration file and\n           chronyc commands. It sets a policy for authentication.\n\n           Sources specified with the noselect option are ignored (not counted as either authenticated or unauthenticated), and they always have only the selection options specified in the\n           configuration.\n\n           There are four modes:\n\n           require\n               Authentication is strictly required for NTP sources in this mode. If any unauthenticated NTP sources are specified, they will automatically get the noselect option to prevent\n               them from being selected for synchronisation.\n\n           prefer\n               In this mode, authentication is optional and preferred. If it is enabled for at least one NTP source, all unauthenticated NTP sources will get the noselect option.\n\n           mix\n               In this mode, authentication is optional and synchronisation to a mix of authenticated and unauthenticated NTP sources is allowed. If both authenticated and unauthenticated\n               NTP sources are specified, all authenticated NTP sources and reference clocks will get the require and trust options to prevent synchronisation to unauthenticated NTP sources\n               if they do not agree with a majority of the authenticated sources and reference clocks. This is the default mode.\n\n           ignore\n               In this mode, authentication is ignored in the source selection. All sources will have only the selection options that were specified in the configuration file, or chronyc\n               command. This was the behaviour of chronyd in versions before 4.0.\n\n           As an example, the following configuration using the default mix mode:\n\n               server ntp1.example.net nts\n               server ntp2.example.net nts\n               server ntp3.example.net\n               refclock SOCK /var/run/chrony.ttyS0.sock\n\n           is equivalent to the following configuration using the ignore mode:\n\n               authselectmode ignore\n               server ntp1.example.net nts require trust\n               server ntp2.example.net nts require trust\n               server ntp3.example.net\n               refclock /var/run/chrony.ttyS0.sock require trust\n\n       combinelimit limit\n           When chronyd has multiple sources available for synchronisation, it has to select one source as the synchronisation source. The measured offsets and frequencies of the system\n           clock relative to the other sources, however, can be combined with the selected source to improve the accuracy of the system clock.\n\n           The combinelimit directive limits which sources are included in the combining algorithm. Their synchronisation distance has to be shorter than the distance of the selected source\n           multiplied by the value of the limit. Also, their measured frequencies have to be close to the frequency of the selected source. If the selected source was specified with the\n           prefer option, it can be combined only with other sources specified with this option.\n\n           By default, the limit is 3. Setting the limit to 0 effectively disables the source combining algorithm and only the selected source will be used to control the system clock.\n\n       maxdistance distance\n           The maxdistance directive sets the maximum root distance of a source to be acceptable for synchronisation of the clock. Sources that have a distance larger than the specified\n           distance will be rejected. The distance estimates the maximum error of the source. It includes the root dispersion and half of the root delay (round-trip time) accumulated on the\n           path to the primary source.\n\n           By default, the maximum root distance is 3 seconds.\n\n           Setting maxdistance to a larger value can be useful to allow synchronisation with a server that only has a very infrequent connection to its sources and can accumulate a large\n           dispersion between updates of its clock.\n\n       maxjitter jitter\n           The maxjitter directive sets the maximum allowed jitter of the sources to not be rejected by the source selection algorithm. This prevents synchronisation with sources that have a\n           small root distance, but their time is too variable.\n\n           By default, the maximum jitter is 1 second.\n\n       minsources sources\n           The minsources directive sets the minimum number of sources that need to be considered as selectable in the source selection algorithm before the local clock is updated. The\n           default value is 1.\n\n           Setting this option to a larger number can be used to improve the reliability. More sources will have to agree with each other and the clock will not be updated when only one\n           source (which could be serving incorrect time) is reachable.\n\n       reselectdist distance\n           When chronyd selects a synchronisation source from available sources, it will prefer the one with the shortest synchronisation distance. However, to avoid frequent reselecting\n           when there are sources with similar distance, a fixed distance is added to the distance for sources that are currently not selected. This can be set with the reselectdist\n           directive. By default, the distance is 100 microseconds.\n\n       stratumweight distance\n           The stratumweight directive sets how much distance should be added per stratum to the synchronisation distance when chronyd selects the synchronisation source from available\n           sources.\n\n           By default, the weight is 0.001 seconds. This means that the stratum of the sources in the selection process matters only when the differences between the distances are in\n           milliseconds.\n\n   System clock\n       clockprecision precision\n           The clockprecision directive specifies the precision of the system clock (in seconds). It is used by chronyd to estimate the minimum noise in NTP measurements and randomise\n           low-order bits of timestamps in NTP responses. By default, the precision is measured on start as the minimum time to read the clock.\n\n           The measured value works well in most cases. However, it generally overestimates the precision and it can be sensitive to the CPU speed, which can change over time to save power.\n           In some cases with a high-precision clocksource (e.g. the Time Stamp Counter of the CPU) and hardware timestamping, setting the precision on the server to a smaller value can\n           improve stability of clients' NTP measurements. The server’s precision is reported on clients by the ntpdata command.\n\n           An example setting the precision to 8 nanoseconds is:\n\n               clockprecision 8e-9\n\n       corrtimeratio ratio\n           When chronyd is slewing the system clock to correct an offset, the rate at which it is slewing adds to the frequency error of the clock. On all supported systems, with the\n           exception of macOS 12 and earlier, this rate can be controlled.\n\n           The corrtimeratio directive sets the ratio between the duration in which the clock is slewed for an average correction according to the source history and the interval in which\n           the corrections are done (usually the NTP polling interval). Corrections larger than the average take less time and smaller corrections take more time, the amount of the\n           correction and the correction time are inversely proportional.\n\n           Increasing corrtimeratio improves the overall frequency error of the system clock, but increases the overall time error as the corrections take longer.\n\n           By default, the ratio is set to 3, the time accuracy of the clock is preferred over its frequency accuracy.\n\n           The maximum allowed slew rate can be set by the maxslewrate directive. The current remaining correction is shown in the tracking report as the System time value.\n\n       driftfile file\n           One of the main activities of the chronyd program is to work out the rate at which the system clock gains or loses time relative to real time.\n\n           Whenever chronyd computes a new value of the gain or loss rate, it is desirable to record it somewhere. This allows chronyd to begin compensating the system clock at that rate\n           whenever it is restarted, even before it has had a chance to obtain an equally good estimate of the rate during the new run. (This process can take many minutes, at least.)\n\n           The driftfile directive allows a file to be specified into which chronyd can store the rate information. Two parameters are recorded in the file. The first is the rate at which\n           the system clock gains or loses time, expressed in parts per million, with gains positive. Therefore, a value of 100.0 indicates that when the system clock has advanced by a\n           second, it has gained 100 microseconds in reality (so the true time has only advanced by 999900 microseconds). The second is an estimate of the error bound around the first value\n           in which the true rate actually lies.\n\n           An example of the driftfile directive is:\n\n               driftfile /var/lib/chrony/drift\n\n       fallbackdrift min-interval max-interval\n           Fallback drifts are long-term averages of the system clock drift calculated over exponentially increasing intervals. They are used to avoid quickly drifting away from true time\n           when the clock was not updated for a longer period of time and there was a short-term deviation in the drift before the updates stopped.\n\n           The directive specifies the minimum and maximum interval since the last clock update to switch between fallback drifts. They are defined as a power of 2 (in seconds). The syntax\n           is as follows:\n\n               fallbackdrift 16 19\n\n           In this example, the minimum interval is 16 (18 hours) and the maximum interval is 19 (6 days). The system clock frequency will be set to the first fallback 18 hours after last\n           clock update, to the second after 36 hours, and so on. This might be a good setting to cover frequency changes due to daily and weekly temperature fluctuations. When the frequency\n           is set to a fallback, the state of the clock will change to ‘Not synchronised’.\n\n           By default (or if the specified maximum or minimum is 0), no fallbacks are used and the clock frequency changes only with new measurements from NTP sources, reference clocks, or\n           manual input.\n\n       leapsecmode mode\n           A leap second is an adjustment that is occasionally applied to UTC to keep it close to the mean solar time. When a leap second is inserted, the last day of June or December has an\n           extra second 23:59:60.\n\n           For computer clocks that is a problem. The Unix time is defined as number of seconds since 00:00:00 UTC on 1 January 1970 without leap seconds. The system clock cannot have time\n           23:59:60, every minute has 60 seconds and every day has 86400 seconds by definition. The inserted leap second is skipped and the clock is suddenly ahead of UTC by one second. The\n           leapsecmode directive selects how that error is corrected. There are four options:\n\n           system\n               When inserting a leap second, the kernel steps the system clock backwards by one second when the clock gets to 00:00:00 UTC. When deleting a leap second, it steps forward by\n               one second when the clock gets to 23:59:59 UTC. This is the default mode when the system driver supports leap seconds (i.e. all supported systems with the exception of macOS\n               12 and earlier).\n\n           step\n               This is similar to the system mode, except the clock is stepped by chronyd instead of the kernel. It can be useful to avoid bugs in the kernel code that would be executed in\n               the system mode. This is the default mode when the system driver does not support leap seconds.\n\n           slew\n               The clock is corrected by slewing started at 00:00:00 UTC when a leap second is inserted or 23:59:59 UTC when a leap second is deleted. This might be preferred over the system\n               and step modes when applications running on the system are sensitive to jumps in the system time and it is acceptable that the clock will be off for a longer time. On Linux\n               with the default maxslewrate value the correction takes 12 seconds.\n\n           ignore\n               No correction is applied to the clock for the leap second. The clock will be corrected later in normal operation when new measurements are made and the estimated offset\n               includes the one second error. This option is particularly useful when multiple chronyd instances are running on the system, one controlling the system clock and others\n               started with the -x option, which should rely on the first instance to correct the system clock and ignore it for the correction of their own NTP clock running on top of the\n               system clock.\n\n           When serving time to NTP clients that cannot be configured to correct their clocks for a leap second by slewing, or to clients that would correct at slightly different rates when\n           it is necessary to keep them close together, the slew mode can be combined with the smoothtime directive to enable a server leap smear.\n\n           When smearing a leap second, the leap status is suppressed on the server and the served time is corrected slowly by slewing instead of stepping. The clients do not need any\n           special configuration as they do not know there is any leap second and they follow the server time which eventually brings them back to UTC. Care must be taken to ensure they use\n           only NTP servers which smear the leap second in exactly the same way for synchronisation.\n\n           This feature must be used carefully, because the server is intentionally not serving its best estimate of the true time.\n\n           A recommended configuration to enable a server leap smear is:\n\n               leapsecmode slew\n               maxslewrate 1000\n               smoothtime 400 0.001024 leaponly\n\n           The first directive is necessary to disable the clock step which would reset the smoothing process. The second directive limits the slewing rate of the local clock to 1000 ppm,\n           which improves the stability of the smoothing process when the local correction starts and ends. The third directive enables the server time smoothing process. It will start when\n           the clock gets to 00:00:00 UTC and it will take 62500 seconds (about 17.36 hours) to finish. The frequency offset will be changing by 0.001024 ppm per second and will reach a\n           maximum of 32 ppm in 31250 seconds. The leaponly option makes the duration of the leap smear constant and allows the clients to safely synchronise with multiple identically\n           configured leap smearing servers.\n\n           The duration of the leap smear can be calculated from the specified wander as\n\n               duration = sqrt(4 / wander)\n\n       leapsectz timezone\n           This directive specifies a timezone in the system timezone database which chronyd can use to determine when will the next leap second occur and what is the current offset between\n           TAI and UTC. It will periodically check if 23:59:59 and 23:59:60 are valid times in the timezone. This normally works with the right/UTC timezone.\n\n           When a leap second is announced, the timezone needs to be updated at least 12 hours before the leap second. It is not necessary to restart chronyd.\n\n           This directive is useful with reference clocks and other time sources which do not announce leap seconds, or announce them too late for an NTP server to forward them to its own\n           clients. Clients of leap smearing servers must not use this directive.\n\n           It is also useful when the system clock is required to have correct TAI-UTC offset. Note that the offset is set only when leap seconds are handled by the kernel, i.e. leapsecmode\n           is set to system.\n\n           The specified timezone is not used as an exclusive source of information about leap seconds. If a majority of time sources announce on the last day of June or December that a leap\n           second should be inserted or deleted, it will be accepted even if it is not included in the timezone.\n\n           An example of the directive is:\n\n               leapsectz right/UTC\n\n           The following shell command verifies that the timezone contains leap seconds and can be used with this directive:\n\n               $ TZ=right/UTC date -d 'Dec 31 2008 23:59:60'\n               Wed Dec 31 23:59:60 UTC 2008\n\n       leapseclist file\n           This directive specifies the path to a file containing a list of leap seconds and TAI-UTC offsets in NIST/IERS format. It is recommended to use the file leap-seconds.list usually\n           included with the system timezone database. The behaviour of this directive is otherwise equivalent to leapsectz.\n\n           An example of this directive is:\n\n               leapseclist /usr/share/zoneinfo/leap-seconds.list\n\n       makestep threshold limit\n           Normally chronyd will cause the system to gradually correct any time offset, by slowing down or speeding up the clock as required. In certain situations, e.g. when chronyd is\n           initially started, the system clock might be so far adrift that this slewing process would take a very long time to correct the system clock.\n\n           This directive forces chronyd to step the system clock if the adjustment is larger than a threshold value, but only if there were no more clock updates since chronyd was started\n           than the specified limit. A negative value disables the limit.\n\n           On most systems it is desirable to step the system clock only on boot, before starting programs that rely on time advancing monotonically forwards.\n\n           An example of the use of this directive is:\n\n               makestep 0.1 3\n\n           This would step the system clock if the adjustment is larger than 0.1 seconds, but only in the first three clock updates.\n\n       maxchange offset start ignore\n           This directive sets the maximum offset to be accepted on a clock update. The offset is measured relative to the current estimate of the true time, which is different from the\n           system time if a previous slew did not finish.\n\n           The check is enabled after the specified number of clock updates to allow a large initial offset to be corrected on start. Offsets larger than the specified maximum will be\n           ignored for the specified number of times. Another large offset will cause chronyd to give up and exit. A negative value can be used to disable the limit to ignore all large\n           offsets. A syslog message will be generated when an offset is ignored or it causes the exit.\n\n           An example of the use of this directive is:\n\n               maxchange 1000 1 2\n\n           After the first clock update, chronyd will check the offset on every clock update, it will ignore two adjustments larger than 1000 seconds and exit on another one.\n\n       maxclockerror error-in-ppm\n           The maxclockerror directive sets the maximum assumed frequency error that the system clock can gain on its own between clock updates. It describes the stability of the clock.\n\n           By default, the maximum error is 1 ppm.\n\n           Typical values for error-in-ppm might be 10 for a low quality clock and 0.1 for a high quality clock using a temperature compensated crystal oscillator.\n\n       maxdrift drift-in-ppm\n           This directive specifies the maximum assumed drift (frequency error) of the system clock. It limits the frequency adjustment that chronyd is allowed to use to correct the measured\n           drift. It is an additional limit to the maximum adjustment that can be set by the system driver (100000 ppm on Linux, 500 ppm on FreeBSD, NetBSD, and macOS 10.13+, 32500 ppm on\n           illumos).\n\n           By default, the maximum assumed drift is 500000 ppm, i.e. the adjustment is limited by the system driver rather than this directive.\n\n       maxupdateskew skew-in-ppm\n           One of chronyd's tasks is to work out how fast or slow the computer’s clock runs relative to its reference sources. In addition, it computes an estimate of the error bounds around\n           the estimated value.\n\n           If the range of error is too large, it probably indicates that the measurements have not settled down yet, and that the estimated gain or loss rate is not very reliable.\n\n           The maxupdateskew directive sets the threshold for determining whether an estimate might be so unreliable that it should not be used. By default, the threshold is 1000 ppm.\n\n           Typical values for skew-in-ppm might be 100 for NTP sources polled over a wireless network, and 10 or smaller for sources on a local wired network.\n\n           It should be noted that this is not the only means of protection against using unreliable estimates. At all times, chronyd keeps track of both the estimated gain or loss rate, and\n           the error bound on the estimate. When a new estimate is generated following another measurement from one of the sources, a weighted combination algorithm is used to update the\n           existing estimate. If it has significantly smaller error bounds than the new estimate, the existing estimate will dominate in the new combined value.\n\n       maxslewrate rate-in-ppm\n           The maxslewrate directive sets the maximum rate at which chronyd is allowed to slew the time. It limits the slew rate controlled by the correction time ratio (which can be set by\n           the corrtimeratio directive) and is effective only on systems where chronyd is able to control the rate (i.e. all supported systems with the exception of macOS 12 or earlier).\n\n           For each system there is a maximum frequency offset of the clock that can be set by the driver. On Linux it is 100000 ppm, on FreeBSD, NetBSD and macOS 10.13+ it is 5000 ppm, and\n           on illumos it is 32500 ppm. Also, due to a kernel limitation, setting maxslewrate on FreeBSD, NetBSD, macOS 10.13+ to a value between 500 ppm and 5000 ppm will effectively set it\n           to 500 ppm.\n\n           By default, the maximum slew rate is set to 83333.333 ppm (one twelfth).\n\n       tempcomp file interval T0 k0 k1 k2, tempcomp file interval points-file\n           Normally, changes in the rate of drift of the system clock are caused mainly by changes in the temperature of the crystal oscillator on the motherboard.\n\n           If there are temperature measurements available from a sensor close to the oscillator, the tempcomp directive can be used to compensate for the changes in the temperature and\n           improve the stability and accuracy of the clock.\n\n           The result depends on many factors, including the resolution of the sensor, the amount of noise in the measurements, the polling interval of the time source, the compensation\n           update interval, how well the compensation is specified, and how close the sensor is to the oscillator. When it is working well, the frequency reported in the tracking.log file is\n           more stable and the maximum reached offset is smaller.\n\n           There are two forms of the directive. The first one has six parameters: a path to the file containing the current temperature from the sensor (in text format), the compensation\n           update interval (in seconds), and temperature coefficients T0, k0, k1, k2.\n\n           The frequency compensation is calculated (in ppm) as\n\n               comp = k0 + (T - T0) * k1 + (T - T0)^2 * k2\n\n           The result has to be between -10 ppm and 10 ppm, otherwise the measurement is considered invalid and will be ignored. The k0 coefficient can be adjusted to keep the compensation\n           in that range.\n\n           An example of the use is:\n\n               tempcomp /sys/class/hwmon/hwmon0/temp2_input 30 26000 0.0 0.000183 0.0\n\n           The measured temperature will be read from the file in the Linux sysfs filesystem every 30 seconds. When the temperature is 26000 (26 degrees Celsius), the frequency correction\n           will be zero. When it is 27000 (27 degrees Celsius), the clock will be set to run faster by 0.183 ppm, etc.\n\n           The second form has three parameters: the path to the sensor file, the update interval, and a path to a file containing a list of (temperature, compensation) points, from which\n           the compensation is linearly interpolated or extrapolated.\n\n           An example is:\n\n               tempcomp /sys/class/hwmon/hwmon0/temp2_input 30 /etc/chrony.tempcomp\n\n           where the /etc/chrony.tempcomp file could have\n\n               20000 1.0\n               21000 0.64\n               22000 0.36\n               23000 0.16\n               24000 0.04\n               25000 0.0\n               26000 0.04\n               27000 0.16\n               28000 0.36\n               29000 0.64\n               30000 1.0\n\n           Valid measurements with corresponding compensations are logged to the tempcomp.log file if enabled by the log tempcomp directive.\n\n   NTP server\n       allow [all] [subnet]\n           The allow directive is used to designate a particular subnet from which NTP clients are allowed to access the computer as an NTP server. It also controls access of NTS-KE clients\n           when NTS is enabled on the server.\n\n           The default is that no clients are allowed access, i.e. chronyd operates purely as an NTP client. If the allow directive is used, chronyd will be both a client of its servers, and\n           a server to other clients.\n\n           This directive can be used multiple times.\n\n           Examples of the use of the directive are as follows:\n\n               allow 1.2.3.4\n               allow 3.4.5.0/24\n               allow 3.4.5\n               allow 2001:db8::/32\n               allow 0/0\n               allow ::/0\n               allow\n\n           The first directive allows access from an IPv4 address. The second directive allows access from all computers in an IPv4 subnet specified in the CIDR notation. The third directive\n           specifies the same subnet using a simpler notation where the prefix length is determined by the number of dots. The fourth directive specifies an IPv6 subnet. The fifth and sixth\n           directives allow access from all IPv4 and IPv6 addresses respectively. The seventh directive allows access from all addresses (both IPv4 or IPv6).\n\n           A second form of the directive, allow all, has a greater effect, depending on the ordering of directives in the configuration file. To illustrate the effect, consider the two\n           examples:\n\n               allow 1.2.3.4\n               deny 1.2.3.0/24\n               allow 1.2.0.0/16\n\n           and\n\n               allow 1.2.3.4\n               deny 1.2.3.0/24\n               allow all 1.2.0.0/16\n\n           In the first example, the effect is the same regardless of what order the three directives are given in. So the 1.2.0.0/16 subnet is allowed access, except for the 1.2.3.0/24\n           subnet, which is denied access, however the host 1.2.3.4 is allowed access.\n\n           In the second example, the allow all 1.2.0.0/16 directive overrides the effect of any previous directive relating to a subnet within the specified subnet. Within a configuration\n           file this capability is probably rather moot; however, it is of greater use for reconfiguration at run-time via chronyc with the allow all command.\n\n           The rules are internally represented as a tree of tables with one level per four bits of the IPv4 or IPv6 address. The order of the allow and deny directives matters if they\n           modify the same records of one table, i.e. if one subnet is included in the other subnet and their prefix lengths are at the same level. For example, 1.2.3.0/28 and 1.2.3.0/29 are\n           in different tables, but 1.2.3.0/25 and 1.2.3.0/28 are in the same table. The configuration can be verified for individual addresses with the accheck command in chronyc.\n\n           A hostname can be specified in the directives instead of the IP address, but the name must be resolvable when chronyd is started, i.e. the network is already up and DNS is\n           working. If the hostname resolves to multiple addresses, only the first address (in the order returned by the system resolver) will be allowed or denied.\n\n           Note, if the initstepslew directive is used in the configuration file, each of the computers listed in that directive must allow client access by this computer for it to work.\n\n       deny [all] [subnet]\n           This is similar to the allow directive, except that it denies NTP and NTS-KE client access to a particular subnet or host, rather than allowing it.\n\n           The syntax is identical and the directive can be used multiple times too.\n\n           There is also a deny all directive with similar behaviour to the allow all directive.\n\n       bindaddress address\n           The bindaddress directive binds the sockets on which chronyd listens for NTP and NTS-KE requests to a local address of the computer. On systems other than Linux, the address of\n           the computer needs to be already configured when chronyd is started.\n\n           An example of the use of the directive is:\n\n               bindaddress 192.168.1.1\n\n           Currently, for each of the IPv4 and IPv6 protocols, only one bindaddress directive can be specified. Therefore, it is not useful on computers which should serve NTP on multiple\n           network interfaces.\n\n       binddevice interface\n           The binddevice directive binds the NTP and NTS-KE server sockets to a network device specified by the interface name. This directive can specify only one interface and it is\n           supported on Linux only.\n\n           An example of the directive is:\n\n               binddevice eth0\n\n       broadcast interval address [port]\n           The broadcast directive is used to declare a broadcast address to which chronyd should send packets in the NTP broadcast mode (i.e. make chronyd act as a broadcast server).\n           Broadcast clients on that subnet will be able to synchronise.\n\n           This directive can be used multiple times to specify multiple addresses.\n\n           The syntax is as follows:\n\n               broadcast 32 192.168.1.255\n               broadcast 64 192.168.2.255 12123\n               broadcast 64 ff02::101\n\n           In the first example, the destination port defaults to UDP port 123 (the normal NTP port). In the second example, the destination port is specified as 12123. The first parameter\n           in each case (32 or 64 respectively) is the interval in seconds between broadcast packets being sent. The second parameter in each case is the broadcast address to send the packet\n           to. This should correspond to the broadcast address of one of the network interfaces on the computer where chronyd is running.\n\n           You can have more than 1 broadcast directive if you have more than 1 network interface onto which you want to send NTP broadcast packets.\n\n           chronyd itself cannot act as a broadcast client; it must always be configured as a point-to-point client by defining specific NTP servers and peers. This broadcast server feature\n           is intended for providing a time source to other NTP implementations.\n\n           If ntpd is used as the broadcast client, it will try to measure the round-trip delay between the server and client with normal client mode packets. Thus, the broadcast subnet\n           should also be the subject of an allow directive.\n\n       clientloglimit limit\n           This directive specifies the maximum amount of memory that chronyd is allowed to allocate for logging of client accesses and the state that chronyd as an NTP server needs to\n           support the interleaved mode for its clients. The default limit is 524288 bytes, which enables monitoring of up to 4096 IP addresses at the same time and holding NTP timestamps\n           for up to 4096 clients using the interleaved mode (depending on uniformity of their polling interval). The number of addresses and timestamps is always a power of 2. The maximum\n           effective value is 2147483648 (2 GB), which corresponds to 16777216 addresses and timestamps.\n\n           An example of the use of this directive is:\n\n               clientloglimit 1048576\n\n       noclientlog\n           This directive, which takes no arguments, specifies that client accesses are not to be logged. Normally they are logged, allowing statistics to be reported using the clients\n           command in chronyc. This option also effectively disables server support for the NTP interleaved mode.\n\n       local [option]...\n           The local directive enables a local reference mode, which allows chronyd operating as an NTP server to appear synchronised to real time (from the viewpoint of clients polling it),\n           even when it was never synchronised or the last update of the clock happened a long time ago.\n\n           This directive is normally used in an isolated network, where computers are required to be synchronised to one another, but not necessarily to real time. The server can be kept\n           vaguely in line with real time by manual input.\n\n           The local directive has the following options:\n\n           stratum stratum\n               This option sets the stratum of the server which will be reported to clients when the local reference is active. The specified value is in the range 1 through 15, and the\n               default value is 10. It should be larger than the maximum expected stratum in the network when external NTP servers are accessible.\n\n               Stratum 1 indicates a computer that has a true real-time reference directly connected to it (e.g. GPS, atomic clock, etc.), such computers are expected to be very close to\n               real time. Stratum 2 computers are those which have a stratum 1 server; stratum 3 computers have a stratum 2 server and so on. A value of 10 indicates that the clock is so\n               many hops away from a reference clock that its time is fairly unreliable.\n\n           distance distance\n               This option sets the threshold for the root distance which will activate the local reference. If chronyd was synchronised to some source, the local reference will not be\n               activated until its root distance reaches the specified value (the rate at which the distance is increasing depends on how well the clock was tracking the source). The default\n               value is 1 second.\n\n               The current root distance can be calculated from root delay and root dispersion (reported by the tracking command in chronyc) as:\n\n                   distance = delay / 2 + dispersion\n\n           activate distance\n               This option sets an activating root distance for the local reference. The local reference will not be used until the root distance drops below the configured value for the\n               first time. This can be used to prevent the local reference from being activated on a server which has never been synchronised with an upstream server. The default value of\n               0.0 causes no activating distance to be used, such that the local reference is always eligible for activation.\n\n           orphan\n               This option enables a special ‘orphan’ mode, where sources with stratum equal to the local stratum are assumed to not serve real time. They are ignored unless no other source\n               is selectable and their reference IDs are smaller than the local reference ID.\n\n               This allows multiple servers in the network to use the same local configuration and to be synchronised to one another, without confusing clients that poll more than one\n               server. Each server needs to be configured to poll all other servers with the local directive. This ensures only the server with the smallest reference ID has the local\n               reference active and others are synchronised to it. If that server stops responding, the server with the second smallest reference ID will take over when its local reference\n               mode activates (root distance reaches the threshold configured by the distance option).\n\n               The orphan mode is compatible with the ntpd's orphan mode (enabled by the tos orphan command).\n\n           An example of the directive is:\n\n               local stratum 10 orphan distance 0.1 activate 0.5\n\n       ntpsigndsocket directory\n           This directive specifies the location of the Samba ntp_signd socket when it is running as a Domain Controller (DC). If chronyd is compiled with this feature, responses to MS-SNTP\n           clients will be signed by the smbd daemon.\n\n           Note that MS-SNTP requests are not authenticated and any client that is allowed to access the server by the allow directive, or the allow command in chronyc, can get an MS-SNTP\n           response signed with a trust account’s password and try to crack the password in a brute-force attack. Access to the server should be carefully controlled.\n\n           An example of the directive is:\n\n               ntpsigndsocket /var/lib/samba/ntp_signd\n\n       ntsport port\n           This directive specifies the TCP port on which chronyd will provide the NTS Key Establishment (NTS-KE) service. The default port is 4460.\n\n           The port will be open only when a certificate and key is specified by the ntsservercert and ntsserverkey directives.\n\n       ntsservercert file\n           This directive specifies a file containing a certificate in the PEM format for chronyd to operate as an NTS server. The file should also include any intermediate certificates that\n           the clients will need to validate the server’s certificate. The file needs to be readable by the user under which chronyd is running after dropping root privileges.\n\n           This directive can be used multiple times to specify multiple certificates for different names of the server.\n\n           The files are loaded only once. chronyd needs to be restarted in order to load a renewed certificate. The ntsdumpdir and dumpdir directives with the -r option of chronyd are\n           recommended for a near-seamless server operation.\n\n       ntsserverkey file\n           This directive specifies a file containing a private key in the PEM format for chronyd to operate as an NTS server. The file needs to be readable by the user under which chronyd\n           is running after dropping root privileges. For security reasons, it should not be readable by other users.\n\n           This directive can be used multiple times to specify multiple keys. The number of keys must be the same as the number of certificates and the corresponding files must be specified\n           in the same order.\n\n       ntsprocesses processes\n           This directive specifies how many helper processes will chronyd operating as an NTS server start for handling client NTS-KE requests in order to improve performance with\n           multi-core CPUs and multithreading. If set to 0, no helper process will be started and all NTS-KE requests will be handled by the main chronyd process. The default value is 1.\n\n       maxntsconnections connections\n           This directive specifies the maximum number of concurrent NTS-KE connections per process that the NTS server will accept. The default value is 100. The maximum practical value is\n           half of the system FD_SETSIZE constant (usually 1024).\n\n       ntsaeads ID...\n           This directive specifies a list of IDs of Authenticated Encryption with Associated Data (AEAD) algorithms enabled for NTS authentication of NTP messages. chronyd as a server uses\n           the first enabled algorithm from the list provided by the client. Algorithms that are not supported by the installed version of the crypto library (Nettle, GnuTLS) are ignored.\n\n           The following IDs are supported:\n\n           •   15: AES-SIV-CMAC-256\n\n           •   30: AES-128-GCM-SIV\n\n           The default list of IDs is 30 15. AES-128-GCM-SIV is prefered over AES-SIV-CMAC-256 for shorter keys, which makes NTS cookies shorter and improves reliability of NTS in networks\n           that block or limit rate of longer NTP messages.\n\n           An example of the directive is:\n\n               ntsaeads 15\n\n           This list is used also by the NTS client.\n\n           Note the the NTS specification (RFC 8915) requires servers to support AES-SIV-CMAC-256, i.e. 15 should be always included in the specified list.\n\n           The AES-128-GCM-SIV keys used by chronyd do not comply to RFC 8915 for compatibility with older chrony clients unless the use of compliant keys is negotiated with an NTS-KE record\n            . Support for this record was added in version 4.6.1. As a client, chronyd can interoperate with a server that uses\n           compliant keys, but does not support the negotiation, if it responds to incorrectly authenticated requests with an NTS NAK.\n\n       ntsdumpdir directory\n           This directive specifies a directory where chronyd operating as an NTS server can save the keys which encrypt NTS cookies provided to clients. The keys are saved to a single file\n           named ntskeys. When chronyd is restarted, reloading the keys allows the clients to continue using old cookies and avoids a storm of NTS-KE requests. By default, the server does\n           not save the keys.\n\n           An example of the directive is:\n\n               ntsdumpdir /var/lib/chrony\n\n           This directory is used also by the NTS client to save NTS cookies.\n\n       ntsntpserver hostname\n           This directive specifies the hostname (as a fully qualified domain name) or address of the NTP server(s) which is provided in the NTS-KE response to the clients. It allows the\n           NTS-KE server to be separated from the NTP server. However, the servers need to share the keys, i.e. external key management needs to be enabled by setting ntsrotate to 0. By\n           default, no hostname or address is provided to the clients, which means they should use the same server for NTS-KE and NTP.\n\n       ntsrotate interval\n           This directive specifies the rotation interval (in seconds) of the server key which encrypts the NTS cookies. New keys are generated automatically from the /dev/urandom device.\n           The server keeps two previous keys to give the clients time to get new cookies encrypted by the latest key. The interval is measured as the server’s operating time, i.e. the\n           actual interval can be longer if chronyd is not running continuously. The default interval is 604800 seconds (1 week). The maximum value is 2^31-1 (68 years).\n\n           The automatic rotation of the keys can be disabled by setting ntsrotate to 0. In this case the keys are assumed to be managed externally. chronyd will not save the keys to the\n           ntskeys file and will reload the keys from the file when the rekey command is issued in chronyc. The file can be periodically copied from another server running chronyd (which\n           does not have ntsrotate set to 0) in order to have one or more servers dedicated to NTS-KE. The file includes the subsequent key to which the NTS-KE server will switch on the next\n           rotation, i.e. the process copying and reloading the file does not need to be timed precisely (it can be delayed by up to one rotation interval). The NTS-KE servers need to be\n           configured with the ntsntpserver directive to point the clients to the right NTP server.\n\n           An example of the directive is:\n\n               ntsrotate 2592000\n\n       port port\n           This option allows you to configure the port on which chronyd will listen for NTP requests. The port will be open only when an address is allowed by the allow directive or the\n           allow command in chronyc, an NTP peer is configured, or the broadcast server mode is enabled.\n\n           The default value is 123, the standard NTP port. If set to 0, chronyd will never open the server port and will operate strictly in a client-only mode. The source port used in NTP\n           client requests can be set by the acquisitionport directive.\n\n       ratelimit [option]...\n           This directive enables response rate limiting for NTP packets. Its purpose is to reduce network traffic with misconfigured or broken NTP clients that are polling the server too\n           frequently. The limits are applied to individual IP addresses. If multiple clients share one IP address (e.g. multiple hosts behind NAT), the sum of their traffic will be limited.\n           If a client that increases its polling rate when it does not receive a reply is detected, its rate limiting will be temporarily suspended to avoid increasing the overall amount of\n           traffic. The maximum number of IP addresses which can be monitored at the same time depends on the memory limit set by the clientloglimit directive.\n\n           The ratelimit directive supports a number of options (which can be defined in any order):\n\n           interval interval\n               This option sets the minimum interval between responses. It is defined as a power of 2 in seconds. The default value is 3 (8 seconds). The minimum value is -19 (524288 packets\n               per second) and the maximum value is 12 (one packet per 4096 seconds). Note that with values below -4 the rate limiting is coarse (responses are allowed in bursts, even if the\n               interval between them is shorter than the specified interval).\n\n           burst responses\n               This option sets the maximum number of responses that can be sent in a burst, temporarily exceeding the limit specified by the interval option. This is useful for clients that\n               make rapid measurements on start (e.g. chronyd with the iburst option). The default value is 8. The minimum value is 1 and the maximum value is 255.\n\n           leak rate\n               This option sets the rate at which responses are randomly allowed even if the limits specified by the interval and burst options are exceeded. This is necessary to prevent an\n               attacker who is sending requests with a spoofed source address from completely blocking responses to that address. The leak rate is defined as a power of 1/2 and it is 2 by\n               default, i.e. on average at least every fourth request has a response. The minimum value is 1 and the maximum value is 4.\n\n           kod rate\n               This option sets the rate at which Kiss-o'-Death (KoD) RATE responses are randomly sent when the limits specified by the interval and burst options are exceeded. It is an\n               additional stream of responses to the leak option. A KoD RATE response is a request for the client to reduce its polling rate. Few implementations actually support it. The\n               rate is defined as a power of 1/2. The default value is 0, which means disabled. The minimum value is 0 and the maximum value is 4.\n\n           An example use of the directive is:\n\n               ratelimit interval 1 burst 16\n\n           This would reduce the response rate for IP addresses sending packets on average more than once per 2 seconds, or sending packets in bursts of more than 16 packets, by up to 75%\n           (with default leak of 2).\n\n       ntsratelimit [option]...\n           This directive enables rate limiting of NTS-KE requests. It is similar to the ratelimit directive, except the default interval is 6 (1 connection per 64 seconds) and the kod\n           option is not supported.\n\n           An example of the use of the directive is:\n\n               ntsratelimit interval 3 burst 1\n\n       smoothtime max-freq max-wander [leaponly]\n           The smoothtime directive can be used to enable smoothing of the time that chronyd serves to its clients to make it easier for them to track it and keep their clocks close together\n           even when large offset or frequency corrections are applied to the server’s clock, for example after being offline for a longer time.\n\n           BE WARNED: The server is intentionally not serving its best estimate of the true time. If a large offset has been accumulated, it can take a very long time to smooth it out. This\n           directive should be used only when the clients are not configured to also poll another NTP server, because they could reject this server as a falseticker or fail to select a\n           source completely.\n\n           The smoothing process is implemented with a quadratic spline function with two or three pieces. It is independent from any slewing applied to the local system clock, but the\n           accumulated offset and frequency will be reset when the clock is corrected by stepping, e.g. by the makestep directive or the makestep command in chronyc. The process can be reset\n           without stepping the clock by the smoothtime reset command.\n\n           The first two arguments of the directive are the maximum frequency offset of the smoothed time to the tracked NTP time (in ppm) and the maximum rate at which the frequency offset\n           is allowed to change (in ppm per second). leaponly is an optional third argument which enables a mode where only leap seconds are smoothed out and normal offset and frequency\n           changes are ignored. The leaponly option is useful in a combination with the leapsecmode slew directive to allow the clients to use multiple time smoothing servers safely.\n\n           The smoothing process is activated automatically when 1/10000 of the estimated skew of the local clock falls below the maximum rate of frequency change. It can be also activated\n           manually by the smoothtime activate command, which is particularly useful when the clock is synchronised only with manual input and the skew is always larger than the threshold.\n           The smoothing command can be used to monitor the process.\n\n           An example suitable for clients using ntpd and 1024 second polling interval could be:\n\n               smoothtime 400 0.001\n\n           An example suitable for clients using chronyd on Linux could be:\n\n               smoothtime 50000 0.01\n\n   Command and monitoring access\n       bindcmdaddress address\n           The bindcmdaddress directive specifies a local IP address to which chronyd will bind the UDP socket listening for monitoring command packets (issued by chronyc). On systems other\n           than Linux, the address of the interface needs to be already configured when chronyd is started.\n\n           This directive can also change the path of the Unix domain command socket, which is used by chronyc to send configuration commands. The socket must be in a directory that is\n           accessible only by the root or chrony user. The directory will be created on start if it does not exist. The compiled-in default path of the socket is /run/chrony/chronyd.sock.\n           The socket can be disabled by setting the path to /.\n\n           By default, chronyd binds the UDP sockets to the addresses 127.0.0.1 and ::1 (i.e. the loopback interface). This blocks all access except from localhost. To listen for command\n           packets on all interfaces, you can add the lines:\n\n               bindcmdaddress 0.0.0.0\n               bindcmdaddress ::\n\n           to the configuration file.\n\n           For each of the IPv4, IPv6, and Unix domain protocols, only one bindcmdaddress directive can be specified.\n\n           An example that sets the path of the Unix domain command socket is:\n\n               bindcmdaddress /var/run/chrony/chronyd.sock\n\n       bindcmddevice interface\n           The bindcmddevice directive binds the UDP command sockets to a network device specified by the interface name. This directive can specify only one interface and it is supported on\n           Linux only.\n\n           An example of the directive is:\n\n               bindcmddevice eth0\n\n       cmdallow [all] [subnet]\n           This is similar to the allow directive, except that it allows monitoring access (rather than NTP client access) to a particular subnet or host. (By ‘monitoring access’ is meant\n           that chronyc can be run on those hosts and retrieve monitoring data from chronyd on this computer.)\n\n           The syntax is identical to the allow directive.\n\n           There is also a cmdallow all directive with similar behaviour to the allow all directive (but applying to monitoring access in this case, of course).\n\n           Note that chronyd has to be configured with the bindcmdaddress directive to not listen only on the loopback interface to actually allow remote access.\n\n       cmddeny [all] [subnet]\n           This is similar to the cmdallow directive, except that it denies monitoring access to a particular subnet or host, rather than allowing it.\n\n           The syntax is identical.\n\n           There is also a cmddeny all directive with similar behaviour to the cmdallow all directive.\n\n       cmdport port\n           The cmdport directive allows the port that is used for run-time monitoring (via the chronyc program) to be altered from its default (323). If set to 0, chronyd will not open the\n           port, which disables remote chronyc access (with a non-default bindcmdaddress) and local access for unprivileged users. It does not disable the Unix domain command socket.\n\n           An example shows the syntax:\n\n               cmdport 257\n\n           This would make chronyd use UDP 257 as its command port. (chronyc would need to be run with the -p 257 option to inter-operate correctly.)\n\n       cmdratelimit [option]...\n           This directive enables response rate limiting for command packets. It is similar to the ratelimit directive, except responses to localhost are never limited, the default interval\n           is -4 (16 packets per second), and the kod option is not supported.\n\n           An example of the use of the directive is:\n\n               cmdratelimit interval 2\n\n   Real-time clock (RTC)\n       hwclockfile file\n           The hwclockfile directive sets the location of the adjtime file which is used by the hwclock program on Linux. chronyd parses the file to find out if the RTC keeps local time or\n           UTC. It overrides the rtconutc directive.\n\n           The compiled-in default value is '/etc/adjtime'.\n\n           An example of the directive is:\n\n               hwclockfile /etc/adjtime\n\n       rtcautotrim threshold\n           The rtcautotrim directive is used to keep the RTC close to the system clock automatically. When the system clock is synchronised and the estimated error between the two clocks is\n           larger than the specified threshold, chronyd will trim the RTC as if the trimrtc command in chronyc was issued. The trimming operation is accurate to only about 1 second, which is\n           the minimum effective threshold.\n\n           This directive is effective only with the rtcfile directive.\n\n           An example of the use of this directive is:\n\n               rtcautotrim 30\n\n           This would set the threshold error to 30 seconds.\n\n       rtcdevice device\n           The rtcdevice directive sets the path to the device file for accessing the RTC. The default path is /dev/rtc.\n\n       rtcfile file\n           The rtcfile directive defines the name of the file in which chronyd can save parameters associated with tracking the accuracy of the RTC.\n\n           An example of the directive is:\n\n               rtcfile /var/lib/chrony/rtc\n\n           chronyd saves information in this file when it exits and when the writertc command is issued in chronyc. The information saved is the RTC’s error at some epoch, that epoch (in\n           seconds since January 1 1970), and the rate at which the RTC gains or loses time.\n\n           So far, the support for real-time clocks is limited; their code is even more system-specific than the rest of the software. You can only use the RTC facilities (the rtcfile\n           directive and the -s command-line option to chronyd) if the following three conditions apply:\n\n            1. You are running Linux.\n\n            2. The kernel is compiled with extended real-time clock support (i.e. the /dev/rtc device is capable of doing useful things).\n\n            3. You do not have other applications that need to make use of /dev/rtc at all.\n\n       rtconutc\n           chronyd assumes by default that the RTC keeps local time (including any daylight saving changes). This is convenient on PCs running Linux which are dual-booted with Windows.\n\n           If you keep the RTC on local time and your computer is off when daylight saving (summer time) starts or ends, the computer’s system time will be one hour in error when you next\n           boot and start chronyd.\n\n           An alternative is for the RTC to keep Universal Coordinated Time (UTC). This does not suffer from the 1 hour problem when daylight saving starts or ends.\n\n           If the rtconutc directive appears, it means the RTC is required to keep UTC. The directive takes no arguments. It is equivalent to specifying the -u switch to the Linux hwclock\n           program.\n\n           Note that this setting is overridden by the hwclockfile file and is not relevant for the rtcsync directive.\n\n       rtcsync\n           The rtcsync directive enables a mode where the system time is periodically copied to the RTC and chronyd does not try to track its drift. This directive cannot be used with the\n           rtcfile directive.\n\n           On Linux, the RTC copy is performed by the kernel every 11 minutes.\n\n           On macOS, chronyd will perform the RTC copy every 60 minutes when the system clock is in a synchronised state.\n\n           On other systems this directive does nothing.\n\n   Logging\n       log [option]...\n           The log directive indicates that certain information is to be logged. The log files are written to the directory specified by the logdir directive. A banner is periodically\n           written to the files to indicate the meanings of the columns.\n\n           rawmeasurements\n               This option logs the raw NTP measurements and related information to a file called measurements.log. An entry is made for each packet received from the source. This can be\n               useful when debugging a problem. An example line (which actually appears as a single line in the file) from the log file is shown below.\n\n                   2016-11-09 05:40:50 203.0.113.15    N  2 111 111 1111  10 10 1.0 \\\n                      -4.966e-03  2.296e-01  1.577e-05  1.615e-01  7.446e-03 CB00717B 4B D K\n\n               The columns are as follows (the quantities in square brackets are the values from the example line above):\n\n                1. Date [2015-10-13]\n\n                2. Hour:Minute:Second. Note that the date-time pair is expressed in UTC, not the local time zone. [05:40:50]\n\n                3. IP address of server or peer from which measurement came [203.0.113.15]\n\n                4. Leap status (N means normal, + means that the last minute of the current month has 61 seconds, - means that the last minute of the month has 59 seconds, ? means the remote\n                   computer is not currently synchronised.) [N]\n\n                5. Stratum of remote computer. [2]\n\n                6. RFC 5905 tests 1 through 3 (1=pass, 0=fail) [111]\n\n                7. RFC 5905 tests 5 through 7 (1=pass, 0=fail) [111]\n\n                8. Results of the maxdelay, maxdelayratio, and maxdelaydevratio (or maxdelayquant) tests, and a test for synchronisation loop (1=pass, 0=fail). The first test from these four\n                   also checks the server precision, response time, validity of the measured offset, and whether an interleaved response is acceptable for synchronisation. [1111]\n\n                9. Local poll [10]\n\n                10. Remote poll [10]\n\n                11. ‘Score’ (an internal score within each polling level used to decide when to increase or decrease the polling level. This is adjusted based on number of measurements\n                   currently being used for the regression algorithm). [1.0]\n\n                12. The estimated local clock error (theta in RFC 5905). Positive indicates that the local clock is slow of the remote source. [-4.966e-03]\n\n                13. The peer delay (delta in RFC 5905). [2.296e-01]\n\n                14. The peer dispersion (epsilon in RFC 5905). [1.577e-05]\n\n                15. The root delay (DELTA in RFC 5905). [1.615e-01]\n\n                16. The root dispersion (EPSILON in RFC 5905). [7.446e-03]\n\n                17. Reference ID of the server’s source as a hexadecimal number. [CB00717B]\n\n                18. NTP mode of the received packet (1=active peer, 2=passive peer, 4=server, B=basic, I=interleaved). [4B]\n\n                19. Source of the local transmit timestamp (D=daemon, K=kernel, H=hardware). [D]\n\n                20. Source of the local receive timestamp (D=daemon, K=kernel, H=hardware). [K]\n\n           measurements\n               This option is identical to the rawmeasurements option, except it logs only valid measurements from synchronised sources, i.e. measurements which passed the RFC 5905 tests 1\n               through 7. This can be useful for producing graphs of the source’s performance.\n\n           statistics\n               This option logs information about the regression processing to a file called statistics.log. An example line (which actually appears as a single line in the file) from the\n               log file is shown below.\n\n                   2016-08-10 05:40:50 203.0.113.15     6.261e-03 -3.247e-03 \\\n                        2.220e-03  1.874e-06  1.080e-06 7.8e-02  16   0   8  0.00\n\n               The columns are as follows (the quantities in square brackets are the values from the example line above):\n\n                1. Date [2015-07-22]\n\n                2. Hour:Minute:Second. Note that the date-time pair is expressed in UTC, not the local time zone. [05:40:50]\n\n                3. IP address of server or peer from which measurement comes [203.0.113.15]\n\n                4. The estimated standard deviation of the measurements from the source (in seconds). [6.261e-03]\n\n                5. The estimated offset of the source (in seconds, positive means the local clock is estimated to be fast, in this case). [-3.247e-03]\n\n                6. The estimated standard deviation of the offset estimate (in seconds). [2.220e-03]\n\n                7. The estimated rate at which the local clock is gaining or losing time relative to the source (in seconds per second, positive means the local clock is gaining). This is\n                   relative to the compensation currently being applied to the local clock, not to the local clock without any compensation. [1.874e-06]\n\n                8. The estimated error in the rate value (in seconds per second). [1.080e-06].\n\n                9. The ratio of |old_rate - new_rate| / old_rate_error. Large values indicate the statistics are not modelling the source very well. [7.8e-02]\n\n                10. The number of measurements currently being used for the regression algorithm. [16]\n\n                11. The new starting index (the oldest sample has index 0; this is the method used to prune old samples when it no longer looks like the measurements fit a linear model). [0,\n                   i.e. no samples discarded this time]\n\n                12. The number of runs. The number of runs of regression residuals with the same sign is computed. If this is too small it indicates that the measurements are no longer\n                   represented well by a linear model and that some older samples need to be discarded. The number of runs for the data that is being retained is tabulated. Values of\n                   approximately half the number of samples are expected. [8]\n\n                13. The estimated or configured asymmetry of network jitter on the path to the source which was used to correct the measured offsets. The asymmetry can be between -0.5 and\n                   +0.5. A negative value means the delay of packets sent to the source is more variable than the delay of packets sent from the source back. [0.00, i.e. no correction for\n                   asymmetry]\n\n           selection\n               This option logs information about selection of sources for synchronisation to a file called selection.log. Note that the rate of entries written to this file grows\n               quadratically with the number of specified sources (each measurement triggers the selection for all sources). An example line (which actually appears as a single line in the\n               file) from the log file is shown below.\n\n                   2022-05-01 02:01:20 203.0.113.15    * -----  377  1.00  \\\n                        4.228e+01 -1.575e-04  1.239e-04\n\n               The columns are as follows (the quantities in square brackets are the values from the example line above):\n\n                1. Date [2022-05-01]\n\n                2. Hour:Minute:Second. Note that the date-time pair is expressed in UTC, not the local time zone. [02:01:20]\n\n                3. IP address or reference ID of the source. [203.0.113.15]\n\n                4. State of the source indicated with one of the following symbols. [*]\n\n                       Not considered selectable for synchronisation:\n\n                       •   N - has the noselect option.\n\n                       •   s - is not synchronised.\n\n                       •   M - does not have enough measurements.\n\n                       •   d - has a root distance larger than the maximum distance (configured by the maxdistance directive).\n\n                       •   ~ - has a jitter larger than the maximum jitter (configured by the maxjitter directive).\n\n                       •   w - waits for other sources to get out of the M state.\n\n                       •   S - has older measurements than other sources.\n\n                       •   O - has a stratum equal or larger than the orphan stratum (configured by the local directive).\n\n                       •   T - does not fully agree with sources that have the trust option.\n\n                       •   x - does not agree with other sources (falseticker).\n\n                       Considered selectable for synchronisation, but not currently used:\n\n                       •   W - waits for other sources to be selectable (required by the minsources directive, or the require option of another source).\n\n                       •   P - another selectable source is preferred due to the prefer option.\n\n                       •   U - waits for a new measurement (after selecting a different best source).\n\n                       •   D - has, or recently had, a root distance which is too large to be combined with other sources (configured by the combinelimit directive).\n\n                       Used for synchronisation of the local clock:\n\n                       •   + - combined with the best source.\n\n                       •   * - selected as the best source to update the reference data (e.g. root delay, root dispersion).\n\n                5. Current effective selection options of the source. which can be different from the configured options due to the authentication selection mode (configured by the\n                   authselectmode directive). [-----]\n\n                   •   N indicates the noselect option.\n\n                   •   P indicates the prefer option.\n\n                   •   T indicates the trust option.\n\n                   •   R indicates the require option.\n\n                6. Reachability register printed as an octal number. The register has 8 bits and is updated on every received or missed packet from the source. A value of 377 indicates that\n                   a valid reply was received for all from the last eight transmissions. [377]\n\n                7. Current score against the source in the * state. The scoring system avoids frequent reselection when multiple sources have a similar root distance. A value larger than 1\n                   indicates this source was better than the * source in recent selections. If the score reaches 10, the best source will be reselected and the scores will be reset to 1.\n                   [1.00]\n\n                8. Interval since the last measurement of the source in seconds. [4.228e+01]\n\n                9. Lower endpoint of the interval which was expected to contain the true offset of the local clock determined by the root distance of the source. [-1.575e-04]\n\n                10. Upper endpoint of the interval which was expected to contain the true offset of the local clock determined by the root distance of the source. [1.239e-04]\n\n           tracking\n               This option logs changes to the estimate of the system’s gain or loss rate, and any slews made, to a file called tracking.log. An example line (which actually appears as a\n               single line in the file) from the log file is shown below.\n\n                   2017-08-22 13:22:36 203.0.113.15     2     -3.541      0.075 -8.621e-06 N \\\n                               2  2.940e-03 -2.084e-04  1.534e-02  3.472e-04  8.304e-03\n\n               The columns are as follows (the quantities in square brackets are the values from the example line above) :\n\n                1. Date [2017-08-22]\n\n                2. Hour:Minute:Second. Note that the date-time pair is expressed in UTC, not the local time zone. [13:22:36]\n\n                3. The IP address of the server or peer to which the local system is synchronised. [203.0.113.15]\n\n                4. The stratum of the local system. [2]\n\n                5. The local system frequency (in ppm, positive means the local system runs fast of UTC). [-3.541]\n\n                6. The error bounds on the frequency (in ppm). [0.075]\n\n                7. The estimated local offset at the epoch, which is normally corrected by slewing the local clock (in seconds, positive indicates the clock is fast of UTC). [-8.621e-06]\n\n                8. Leap status (N means normal, + means that the last minute of this month has 61 seconds, - means that the last minute of the month has 59 seconds, ? means the clock is not\n                   currently synchronised.) [N]\n\n                9. The number of combined sources. [2]\n\n                10. The estimated standard deviation of the combined offset (in seconds). [2.940e-03]\n\n                11. The remaining offset correction from the previous update (in seconds, positive means the system clock is slow of UTC). [-2.084e-04]\n\n                12. The total of the network path delays to the reference clock to which the local clock is ultimately synchronised (in seconds). [1.534e-02]\n\n                13. The total dispersion accumulated through all the servers back to the reference clock to which the local clock is ultimately synchronised (in seconds). [3.472e-04]\n\n                14. The maximum estimated error of the system clock in the interval since the previous update (in seconds). It includes the offset, remaining offset correction, root delay,\n                   and dispersion from the previous update with the dispersion which accumulated in the interval. [8.304e-03]\n\n           rtc\n               This option logs information about the system’s real-time clock. An example line (which actually appears as a single line in the file) from the rtc.log file is shown below.\n\n                   2015-07-22 05:40:50     -0.037360 1       -0.037434\\\n                             -37.948  12   5  120\n\n               The columns are as follows (the quantities in square brackets are the values from the example line above):\n\n                1. Date [2015-07-22]\n\n                2. Hour:Minute:Second. Note that the date-time pair is expressed in UTC, not the local time zone. [05:40:50]\n\n                3. The measured offset between the RTC and the system clock in seconds. Positive indicates that the RTC is fast of the system time [-0.037360].\n\n                4. Flag indicating whether the regression has produced valid coefficients. (1 for yes, 0 for no). [1]\n\n                5. Offset at the current time predicted by the regression process. A large difference between this value and the measured offset tends to indicate that the measurement is an\n                   outlier with a serious measurement error. [-0.037434]\n\n                6. The rate at which the RTC is losing or gaining time relative to the system clock. In ppm, with positive indicating that the RTC is gaining time. [-37.948]\n\n                7. The number of measurements used in the regression. [12]\n\n                8. The number of runs of regression residuals of the same sign. Low values indicate that a straight line is no longer a good model of the measured data and that older\n                   measurements should be discarded. [5]\n\n                9. The measurement interval used prior to the measurement being made (in seconds). [120]\n\n           refclocks\n               This option logs the raw and filtered reference clock measurements to a file called refclocks.log. An example line (which actually appears as a single line in the file) from\n               the log file is shown below.\n\n                   2009-11-30 14:33:27.000000 PPS2    7 N 1  4.900000e-07 -6.741777e-07  1.000e-06\n\n               The columns are as follows (the quantities in square brackets are the values from the example line above):\n\n                1. Date [2009-11-30]\n\n                2. Hour:Minute:Second.Microsecond. Note that the date-time pair is expressed in UTC, not the local time zone. [14:33:27.000000]\n\n                3. Reference ID of the reference clock from which the measurement came. [PPS2]\n\n                4. Sequence number of driver poll within one polling interval for raw samples, or - for filtered samples. [7]\n\n                5. Leap status (N means normal, + means that the last minute of the current month has 61 seconds, - means that the last minute of the month has 59 seconds). [N]\n\n                6. Flag indicating whether the sample comes from PPS source. (1 for yes, 0 for no, or - for filtered sample). [1]\n\n                7. Local clock error measured by reference clock driver, or - for filtered sample. [4.900000e-07]\n\n                8. Local clock error with applied corrections. Positive indicates that the local clock is slow. [-6.741777e-07]\n\n                9. Assumed dispersion of the sample. [1.000e-06]\n\n           tempcomp\n               This option logs the temperature measurements and system rate compensations to a file called tempcomp.log. An example line (which actually appears as a single line in the\n               file) from the log file is shown below.\n\n                   2015-04-19 10:39:48  2.8000e+04  3.6600e-01\n\n               The columns are as follows (the quantities in square brackets are the values from the example line above):\n\n                1. Date [2015-04-19]\n\n                2. Hour:Minute:Second. Note that the date-time pair is expressed in UTC, not the local time zone. [10:39:48]\n\n                3. Temperature read from the sensor. [2.8000e+04]\n\n                4. Applied compensation in ppm, positive means the system clock is running faster than it would be without the compensation. [3.6600e-01]\n\n           An example of the directive is:\n\n               log measurements statistics tracking\n\n       logbanner entries\n           A banner is periodically written to the log files enabled by the log directive to indicate the meanings of the columns.\n\n           The logbanner directive specifies after how many entries in the log file should be the banner written. The default is 32, and 0 can be used to disable it entirely.\n\n       logchange threshold\n           This directive sets the threshold for the adjustment of the system clock that will generate a syslog message. Clock errors detected via NTP packets, reference clocks, or\n           timestamps entered via the settime command of chronyc are logged.\n\n           By default, the threshold is 1 second.\n\n           An example of the use is:\n\n               logchange 0.1\n\n           which would cause a syslog message to be generated if a system clock error of over 0.1 seconds starts to be compensated.\n\n       logdir directory\n           This directive specifies the directory for writing log files enabled by the log directive. If the directory does not exist, it will be created automatically.\n\n           An example of the use of this directive is:\n\n               logdir /var/log/chrony\n\n       mailonchange email threshold\n           This directive defines an email address to which mail should be sent if chronyd applies a correction exceeding a particular threshold to the system clock.\n\n           An example of the use of this directive is:\n\n               mailonchange root@localhost 0.5\n\n           This would send a mail message to root if a change of more than 0.5 seconds were applied to the system clock.\n\n           This directive cannot be used when a system call filter is enabled by the -F option as the chronyd process will not be allowed to fork and execute the sendmail binary.\n\n   Miscellaneous\n       confdir directory...\n           The confdir directive includes configuration files with the .conf suffix from a directory. The files are included in the lexicographical order of the file names.\n\n           Multiple directories (up to 10) can be specified with a single confdir directive. In this case, if multiple directories contain a file with the same name, only the first file in\n           the order of the specified directories will be included. This enables a fragmented configuration where existing fragments can be replaced by adding files to a different directory.\n\n           This directive can be used multiple times.\n\n           An example of the directive is:\n\n               confdir /etc/chrony/chrony.d\n\n       sourcedir directory...\n           The sourcedir directive is identical to the confdir directive, except the configuration files have the .sources suffix, they can only specify NTP sources (i.e. the server, pool,\n           and peer directives), they are expected to have all lines terminated by the newline character, and they can be reloaded by the reload sources command in chronyc. It is\n           particularly useful with dynamic sources like NTP servers received from a DHCP server, which can be written to a file specific to the network interface by a networking script.\n\n           This directive can be used multiple times.\n\n           An example of the directive is:\n\n               sourcedir /var/run/chrony-dhcp\n\n       include pattern\n           The include directive includes a configuration file, or multiple configuration files if a wildcard pattern is specified. Unlike with the confdir directive, the full name of the\n           files needs to be specified and at least one file is required to exist.\n\n           This directive can be used multiple times.\n\n           An example of the directive is:\n\n               include /etc/chrony/chrony.d/*.conf\n\n       hwtimestamp interface [option]...\n           This directive enables hardware timestamping of NTP packets sent to and received from the specified network interface. The network interface controller (NIC) uses its own clock to\n           accurately timestamp the actual transmissions and receptions, avoiding processing and queueing delays in the kernel, network driver, and hardware. This can significantly improve\n           the accuracy of the timestamps and the measured offset, which is used for synchronisation of the system clock. In order to get the best results, both sides receiving and sending\n           NTP packets (i.e. server and client, or two peers) need to use HW timestamping. If the server or peer supports the interleaved mode, it needs to be enabled by the xleave option in\n           the server or the peer directive.\n\n           This directive is supported on Linux 3.19 and newer. The NIC must support HW timestamping, which can be verified with the ethtool -T command. The list of capabilities should\n           include hardware-raw-clock, hardware-transmit, and hardware-receive. The receive filter all, or ntp, is necessary for timestamping of received NTP packets. Timestamping of packets\n           received on bridged and bonded interfaces is supported on Linux 4.13 and newer. If HW timestamping does not work for received packets, chronyd will use kernel receive timestamps\n           instead. Transmit-only HW timestamping can still be useful to improve stability of the synchronisation.\n\n           chronyd does not synchronise the NIC clock. It assumes the clock is running free. Multiple instances of chronyd can use the same interface with enabled HW timestamping.\n           Applications which need HW timestamping with a synchronised clock (e.g. a PTP daemon) should use a virtual clock running on top of the physical clock created by writing to\n           /sys/class/ptp/ptpX/n_vclocks. This feature is available on Linux 5.14 and newer.\n\n           If the kernel supports software timestamping, it will be enabled for all interfaces automatically.\n\n           The source of timestamps (i.e. hardware, kernel, or daemon) is indicated on the client side in the measurements.log file (if enabled by the log directive) and the ntpdata report.\n           On the server side, the number of served timestamps from each source is provided in the serverstats report.\n\n           This directive can be used multiple times to enable HW timestamping on multiple interfaces. If the specified interface is *, chronyd will try to enable HW timestamping on all\n           available interfaces.\n\n           The hwtimestamp directive has the following options:\n\n           minpoll poll\n               This option specifies the minimum interval between readings of the NIC clock. It’s defined as a power of 2. It should correspond to the minimum polling interval of all NTP\n               sources and the minimum expected polling interval of NTP clients. The default value is 0 (1 second), the minimum value is -6 (1/64th of a second), and the maximum value is 20\n               (about 12 days).\n\n           maxpoll poll\n               This option specifies the maximum interval between readings of the NIC clock, as a power of 2. The default value is minpoll + 1, i.e. 1 (2 seconds) with the default minpoll of\n               0. The minimum and maximum values are the same as with the minpoll option.\n\n           minsamples samples\n               This option specifies the minimum number of readings kept for tracking of the NIC clock. The default value is 2.\n\n           maxsamples samples\n               This option specifies the maximum number of readings kept for tracking of the NIC clock. The default value is 16.\n\n           precision precision\n               This option specifies the assumed precision of reading of the NIC clock. The default value is 100e-9 (100 nanoseconds).\n\n           txcomp compensation\n               This option specifies the difference in seconds between the actual transmission time at the physical layer and the reported transmit timestamp. This value will be added to\n               transmit timestamps obtained from the NIC. The default value is 0.\n\n           rxcomp compensation\n               This option specifies the difference in seconds between the reported receive timestamp and the actual reception time at the physical layer. This value will be subtracted from\n               receive timestamps obtained from the NIC. The default value is 0.\n\n           nocrossts\n               Some hardware can precisely cross timestamp the NIC clock with the system clock. This option disables the use of the cross timestamping.\n\n           rxfilter filter\n               This option selects the receive timestamping filter. The filter can be one of the following:\n\n               all\n                   Enables timestamping of all received packets.\n\n               ntp\n                   Enables timestamping of received NTP packets.\n\n               ptp\n                   Enables timestamping of received PTP packets.\n\n               none\n                   Disables timestamping of received packets.\n\n               The most specific filter for timestamping of NTP packets supported by the NIC is selected by default. Some NICs can timestamp PTP packets only. By default, they will be\n               configured with the none filter and expected to provide hardware timestamps for transmitted packets only. Timestamping of PTP packets is useful with NTP-over-PTP enabled by\n               the ptpport directive, or when another application is receiving PTP packets on the interface. Forcing timestamping of all packets with the all filter could be useful if the\n               NIC supported both the all and ntp filters, and it should timestamp both NTP and PTP packets, or NTP packets on a different UDP port.\n\n           Examples of the directive are:\n\n               hwtimestamp eth0\n               hwtimestamp eth1 txcomp 300e-9 rxcomp 645e-9\n               hwtimestamp *\n\n       hwtstimeout timeout\n           If hardware timestamping is used with a close NTP server, or the NIC or its driver is slow in providing the transmit timestamp of NTP requests, a response from the server can be\n           received before the transmit timestamp of the request. To avoid calculating the offset with a less accurate transmit timestamp, chronyd can save the response for later processing\n           and wait for the hardware transmit timestamp. There is no guarantee that the timestamp will be provided (NICs typically have a limited rate of transmit timestamping). This\n           directive configures how long should chronyd wait for the timestamp after receiving a valid response from the server. If a second valid response is received from the server while\n           waiting for the timestamp, they will be both processed immediately.\n\n           The default value is 0.001 seconds, which should be sufficient with most hardware. If you frequently see kernel transmit timestamps in the measurements.log file or ntpdata report,\n           and it is not a server handling a high rate of requests in the interleaved mode on the same interface (which would compete with timestamping of the server’s own requests),\n           increasing the timeout to 0.01 or possibly even longer might help. Note that the maximum timeout is limited by the NTP polling interval.\n\n       keyfile file\n           This directive is used to specify the location of the file containing symmetric keys which are shared between NTP servers and clients, or peers, in order to authenticate NTP\n           packets with a message authentication code (MAC) using a cryptographic hash function or cipher.\n\n           The format of the directive is shown in the example below:\n\n               keyfile /etc/chrony/chrony.keys\n\n           The argument is simply the name of the file containing the ID-key pairs. The format of the file is shown below:\n\n               10 tulip\n               11 hyacinth\n               20 MD5 ASCII:crocus\n               25 SHA1 HEX:933F62BE1D604E68A81B557F18CFA200483F5B70\n               30 AES128 HEX:7EA62AE64D190114D46D5A082F948EC1\n               31 AES256 HEX:37DDCBC67BB902BCB8E995977FAB4D2B5642F5B32EBCEEE421921D97E5CBFE39\n                ...\n\n           Each line consists of an ID, optional type, and key.\n\n           The ID can be any positive integer in the range 1 through 2^32-1.\n\n           The type is a name of a cryptographic hash function or cipher which is used to generate and verify the MAC. The default type is MD5, which is always supported. If chronyd was\n           built with enabled support for hashing using a crypto library (Nettle, GnuTLS, NSS, or LibTomCrypt), the following functions are available: MD5, SHA1, SHA256, SHA384, SHA512.\n           Depending on which library and version is chronyd using, some of the following hash functions and ciphers may also be available: SHA3-224, SHA3-256, SHA3-384, SHA3-512, TIGER,\n           WHIRLPOOL, AES128, AES256.\n\n           The key can be specified as a string of ASCII characters not containing white space with an optional ASCII: prefix, or as a hexadecimal number with the HEX: prefix. The maximum\n           length of the line is 2047 characters. If the type is a cipher, the length of the key must match the cipher (i.e. 128 bits for AES128 and 256 bits for AES256).\n\n           It is recommended to use randomly generated keys, specified in the hexadecimal format, which are at least 128 bits long (i.e. they have at least 32 characters after the HEX:\n           prefix). chronyd will log a warning to syslog on start if a source is specified in the configuration file with a key shorter than 80 bits.\n\n           The recommended key types are AES ciphers and SHA3 hash functions. MD5 should be avoided unless no other type is supported on the server and client, or peers. A major weakness of\n           MD5 for the NTP MAC is a length extension attack, where a man-in-the-middle attacker can add arbitrary extension fields to the NTP message and update the MAC to pass the\n           verification of the extended message. The extfield option (enabling processing of the specified extension field) should not be used for NTP sources authenticated with an MD5 key.\n\n           The keygen command of chronyc can be used to generate random keys for the key file. By default, it generates 160-bit MD5 or SHA1 keys.\n\n           For security reasons, the file should be readable only by root and the user under which chronyd is normally running (to allow chronyd to re-read the file when the rekey command is\n           issued by chronyc).\n\n       lock_all\n           The lock_all directive will lock the chronyd process into RAM so that it will never be paged out. This can result in lower and more consistent latency. The directive is supported\n           on Linux, FreeBSD, NetBSD, and illumos.\n\n       pidfile file\n           Unless chronyd is started with the -Q option, it writes its process ID (PID) to a file, and checks this file on startup to see if another chronyd might already be running on the\n           system. By default, the file used is /run/chrony/chronyd.pid. The pidfile directive allows the name to be changed, e.g.:\n\n               pidfile /run/chronyd.pid\n\n           Setting this directive to / disables writing and checking of the PID file.\n\n       ptpport port\n           The ptpport directive enables chronyd to send and receive NTP messages contained in PTP event messages (NTP-over-PTP) to enable hardware timestamping on NICs which cannot\n           timestamp NTP packets, but can timestamp unicast PTP packets, and also use corrections provided by PTP one-step end-to-end transparent clocks in network switches and routers. The\n           port recognized by the NICs and PTP transparent clocks is 319 (PTP event port). The default value is 0 (disabled).\n\n           The NTP-over-PTP support is experimental. The protocol and configuration can change in future. It should be used only in local networks.\n\n           The PTP port will be open even if chronyd is not configured to operate as a server or client. The directive does not change the default protocol of specified NTP sources. Each NTP\n           source that should use NTP-over-PTP needs to be specified with the port option set to the PTP port. To actually enable hardware timestamping on NICs which can timestamp PTP\n           packets only, the rxfilter option of the hwtimestamp directive needs to be set to ptp. The extension field F324 needs to be enabled to use the corrections provided by the PTP\n           transparent clocks.\n\n           An example of client configuration is:\n\n               server ntp1.example.net minpoll 0 maxpoll 0 xleave port 319 extfield F324\n               hwtimestamp * rxfilter ptp\n               ptpport 319\n\n       ptpdomain domain\n           The ptpdomain directive sets the PTP domain number of transmitted and accepted NTP-over-PTP messages. Messages from other domains are ignored. The default is 123, the minimum is\n           0, and the maximum is 255.\n\n       sched_priority priority\n           On Linux, FreeBSD, NetBSD, and illumos, the sched_priority directive will select the SCHED_FIFO real-time scheduler at the specified priority (which must be between 0 and 100). On\n           macOS, this option must have either a value of 0 (the default) to disable the thread time constraint policy or 1 for the policy to be enabled.\n\n           On systems other than macOS, this directive uses the pthread_setschedparam() system call to instruct the kernel to use the SCHED_FIFO first-in, first-out real-time scheduling\n           policy for chronyd with the specified priority. This means that whenever chronyd is ready to run it will run, interrupting whatever else is running unless it is a higher priority\n           real-time process. This should not impact performance as chronyd resource requirements are modest, but it should result in lower and more consistent latency since chronyd will not\n           need to wait for the scheduler to get around to running it. You should not use this unless you really need it. The pthread_setschedparam(3) man page has more details.\n\n           On macOS, this directive uses the thread_policy_set() kernel call to specify real-time scheduling. As noted above, you should not use this directive unless you really need it.\n\n       user user\n           The user directive sets the name of the system user to which chronyd will switch after start in order to drop root privileges.\n\n           On Linux, chronyd needs to be compiled with support for the libcap library. On macOS, FreeBSD, NetBSD and illumos chronyd forks into two processes. The child process retains root\n           privileges, but can only perform a very limited range of privileged system calls on behalf of the parent.\n\n           The compiled-in default value is _chrony.\n\nEXAMPLES\n   NTP client with permanent connection to NTP servers\n       This section shows how to configure chronyd for computers that are connected to the Internet (or to any network containing true NTP servers which ultimately derive their time from a\n       reference clock) permanently or most of the time.\n\n       To operate in this mode, you will need to know the names of the NTP servers you want to use. You might be able to find names of suitable servers by one of the following methods:\n\n       •   Your institution might already operate servers on its network. Contact your system administrator to find out.\n\n       •   Your ISP probably has one or more NTP servers available for its customers.\n\n       •   Somewhere under the NTP homepage there is a list of public stratum 1 and stratum 2 servers. You should find one or more servers that are near to you. Check that their access\n           policy allows you to use their facilities.\n\n       •   Use public servers from the pool.ntp.org   project.\n\n       Assuming that your NTP servers are called ntp1.example.net, ntp2.example.net and ntp3.example.net, your chrony.conf file could contain as a minimum:\n\n           server ntp1.example.net\n           server ntp2.example.net\n           server ntp3.example.net\n\n       However, you will probably want to include some of the other directives. The driftfile, makestep and rtcsync might be particularly useful. Also, the iburst option of the server\n       directive is useful to speed up the initial synchronisation. The smallest useful configuration file would look something like:\n\n           server ntp1.example.net iburst\n           server ntp2.example.net iburst\n           server ntp3.example.net iburst\n           driftfile /var/lib/chrony/drift\n           makestep 1.0 3\n           rtcsync\n\n       When using a pool of NTP servers (one name is used for multiple servers which might change over time), it is better to specify them with the pool directive instead of multiple server\n       directives. The configuration file could in this case look like:\n\n           pool pool.ntp.org iburst\n           driftfile /var/lib/chrony/drift\n           makestep 1.0 3\n           rtcsync\n\n       If the servers (or pool) support the Network Time Security (NTS) authentication mechanism and chronyd is compiled with NTS support, the nts option will enable a secure synchronisation\n       to the servers. The configuration file could look like:\n\n           server ntp1.example.net iburst nts\n           server ntp2.example.net iburst nts\n           server ntp3.example.net iburst nts\n           driftfile /var/lib/chrony/drift\n           makestep 1.0 3\n           rtcsync\n\n   NTP client with infrequent connection to NTP servers\n       This section shows how to configure chronyd for computers that have occasional connections to NTP servers. In this case, you will need some additional configuration to tell chronyd\n       when the connection goes up and down. This saves the program from continuously trying to poll the servers when they are inaccessible.\n\n       Again, assuming that your NTP servers are called ntp1.example.net, ntp2.example.net and ntp3.example.net, your chrony.conf file would now contain:\n\n           server ntp1.example.net offline\n           server ntp2.example.net offline\n           server ntp3.example.net offline\n           driftfile /var/lib/chrony/drift\n           makestep 1.0 3\n           rtcsync\n\n       The offline keyword indicates that the servers start in an offline state, and that they should not be contacted until chronyd receives notification from chronyc that the link to the\n       Internet is present. To tell chronyd when to start and finish sampling the servers, the online and offline commands of chronyc need to be used.\n\n       To give an example of their use, assuming that pppd is the program being used to connect to the Internet and that chronyc has been installed at /usr/bin/chronyc, the script\n       /etc/ppp/ip-up would include:\n\n           /usr/bin/chronyc online\n\n       and the script /etc/ppp/ip-down would include:\n\n           /usr/bin/chronyc offline\n\n       chronyd's polling of the servers would now only occur whilst the machine is actually connected to the Internet.\n\n   Isolated networks\n       This section shows how to configure chronyd for computers that never have network connectivity to any computer which ultimately derives its time from a reference clock.\n\n       In this situation, one computer is selected to be the primary timeserver. The other computers are either direct clients of the server, or clients of clients.\n\n       The local directive enables a local reference mode, which allows chronyd to appear synchronised even when it is not.\n\n       The rate value in the server’s drift file needs to be set to the average rate at which the server gains or loses time. chronyd includes support for this, in the form of the manual\n       directive and the settime command in the chronyc program.\n\n       If the server is rebooted, chronyd can re-read the drift rate from the drift file. However, the server has no accurate estimate of the current time. To get around this, the system can\n       be configured so that the server can initially set itself to a ‘majority-vote’ of selected clients' times; this allows the clients to ‘flywheel’ the server while it is rebooting.\n\n       The smoothtime directive is useful when the clocks of the clients need to stay close together when the local time is adjusted by the settime command. The smoothing process needs to be\n       activated by the smoothtime activate command when the local time is ready to be served. After that point, any adjustments will be smoothed out.\n\n       A typical configuration file for the server (called ntp.local) might be (assuming the clients and the server are in the 192.168.165.x subnet):\n\n           initstepslew 1 client1 client3 client6\n           driftfile /var/lib/chrony/drift\n           local stratum 8\n           manual\n           allow 192.168.165.0/24\n           smoothtime 400 0.01\n           rtcsync\n\n       For the clients that have to resynchronise the server when it restarts, the configuration file might be:\n\n           server ntp.local iburst\n           driftfile /var/lib/chrony/drift\n           allow 192.168.165.0/24\n           makestep 1.0 3\n           rtcsync\n\n       The rest of the clients would be the same, except that the allow directive is not required.\n\n       If there is no suitable computer to be designated as the primary server, or there is a requirement to keep the clients synchronised even when it fails, the orphan option of the local\n       directive enables a special mode where the server is selected from multiple computers automatically. They all need to use the same local configuration and poll one another. The server\n       with the smallest reference ID (which is based on its IP address) will take the role of the primary server and others will be synchronised to it. When it fails, the server with the\n       second smallest reference ID will take over and so on.\n\n       A configuration file for the first server might be (assuming there are three servers called ntp1.local, ntp2.local, and ntp3.local):\n\n           initstepslew 1 ntp2.local ntp3.local\n           server ntp2.local\n           server ntp3.local\n           driftfile /var/lib/chrony/drift\n           local stratum 8 orphan\n           manual\n           allow 192.168.165.0/24\n           rtcsync\n\n       The other servers would be the same, except the hostnames in the initstepslew and server directives would be modified to specify the other servers. Their clients might be configured\n       to poll all three servers.\n\n   RTC tracking\n       This section considers a computer which has occasional connections to the Internet and is turned off between ‘sessions’. In this case, chronyd relies on the computer’s RTC to maintain\n       the time between the periods when it is powered up. It assumes that Linux is run exclusively on the computer. Dual-boot systems might work; it depends what (if anything) the other\n       system does to the RTC. On 2.6 and later kernels, if your motherboard has a HPET, you will need to enable the HPET_EMULATE_RTC option in your kernel configuration. Otherwise, chronyd\n       will not be able to interact with the RTC device and will give up using it.\n\n       When the computer is connected to the Internet, chronyd has access to external NTP servers which it makes measurements from. These measurements are saved, and straight-line fits are\n       performed on them to provide an estimate of the computer’s time error and rate of gaining or losing time.\n\n       When the computer is taken offline from the Internet, the best estimate of the gain or loss rate is used to free-run the computer until it next goes online.\n\n       Whilst the computer is running, chronyd makes measurements of the RTC (via the /dev/rtc interface, which must be compiled into the kernel). An estimate is made of the RTC error at a\n       particular RTC second, and the rate at which the RTC gains or loses time relative to true time.\n\n       When the computer is powered down, the measurement histories for all the NTP servers are saved to files, and the RTC tracking information is also saved to a file (if the rtcfile\n       directive has been specified). These pieces of information are also saved if the dump and writertc commands respectively are issued through chronyc.\n\n       When the computer is rebooted, chronyd reads the current RTC time and the RTC information saved at the last shutdown. This information is used to set the system clock to the best\n       estimate of what its time would have been now, had it been left running continuously. The measurement histories for the servers are then reloaded.\n\n       The next time the computer goes online, the previous sessions' measurements can contribute to the line-fitting process, which gives a much better estimate of the computer’s gain or\n       loss rate.\n\n       One problem with saving the measurements and RTC data when the machine is shut down is what happens if there is a power failure; the most recent data will not be saved. Although\n       chronyd is robust enough to cope with this, some performance might be lost. (The main danger arises if the RTC has been changed during the session, with the trimrtc command in\n       chronyc. Because of this, trimrtc will make sure that a meaningful RTC file is saved after the change is completed).\n\n       The easiest protection against power failure is to put the dump and writertc commands in the same place as the offline command is issued to take chronyd offline; because chronyd\n       free-runs between online sessions, no parameters will change significantly between going offline from the Internet and any power failure.\n\n       A final point regards computers which are left running for extended periods and where it is desired to spin down the hard disc when it is not in use (e.g. when not accessed for 15\n       minutes). chronyd has been planned so it supports such operation; this is the reason why the RTC tracking parameters are not saved to disc after every update, but only when the user\n       requests such a write, or during the shutdown sequence. The only other facility that will generate periodic writes to the disc is the log rtc facility in the configuration file; this\n       option should not be used if you want your disc to spin down.\n\n       To illustrate how a computer might be configured for this case, example configuration files are shown.\n\n       For the chrony.conf file, the following can be used as an example.\n\n           server ntp1.example.net maxdelay 0.4 offline\n           server ntp2.example.net maxdelay 0.4 offline\n           server ntp3.example.net maxdelay 0.4 offline\n           logdir /var/log/chrony\n           log statistics measurements tracking\n           driftfile /var/lib/chrony/drift\n           makestep 1.0 3\n           maxupdateskew 100.0\n           dumpdir /var/lib/chrony\n           rtcfile /var/lib/chrony/rtc\n\n       pppd is used for connecting to the Internet. This runs two scripts /etc/ppp/ip-up and /etc/ppp/ip-down when the link goes online and offline respectively.\n\n       The relevant part of the /etc/ppp/ip-up file is:\n\n           /usr/bin/chronyc online\n\n       and the relevant part of the /etc/ppp/ip-down script is:\n\n           /usr/bin/chronyc -m offline dump writertc\n\n       chronyd is started during the boot sequence with the -r and -s options. It might need to be started before any software that depends on the system clock not jumping or moving\n       backwards, depending on the directives in chronyd's configuration file.\n\n       For the system shutdown, chronyd should receive a SIGTERM several seconds before the final SIGKILL; the SIGTERM causes the measurement histories and RTC information to be saved.\n\n   Public NTP server\n       chronyd can be configured to operate as a public NTP server, e.g. to join the pool.ntp.org   project. The configuration is similar to the NTP\n       client with permanent connection, except it needs to allow client access from all addresses. It is recommended to find at least four good servers (e.g. from the pool, or on the NTP\n       homepage). If the server has a hardware reference clock (e.g. a GPS receiver), it can be specified by the refclock directive.\n\n       The amount of memory used for logging client accesses can be increased in order to enable clients to use the interleaved mode even when the server has a large number of clients, and\n       better support rate limiting if it is enabled by the ratelimit directive. The system timezone database, if it is kept up to date and includes the right/UTC timezone, can be used as a\n       reliable source to determine when a leap second will be applied to UTC. The -r option with the dumpdir directive shortens the time in which chronyd will not be able to serve time to\n       its clients when it needs to be restarted (e.g. after upgrading to a newer version, or a change in the configuration).\n\n       The configuration file could look like:\n\n           server ntp1.example.net iburst\n           server ntp2.example.net iburst\n           server ntp3.example.net iburst\n           server ntp4.example.net iburst\n           makestep 1.0 3\n           rtcsync\n           allow\n           clientloglimit 100000000\n           leapsectz right/UTC\n           driftfile /var/lib/chrony/drift\n           dumpdir /run/chrony\n\nSEE ALSO\n       chronyc(1), chronyd(8)\n\nBUGS\n       For instructions on how to report bugs, please visit https://chrony-project.org/.\n\nAUTHORS\n       chrony was written by Richard Curnow, Miroslav Lichvar, and others.\n\nchrony 4.6.1                                                                              2024-10-08                                                                            CHRONY.CONF(5)","ref":"chrony-conf.html"},{"type":"extras","title":"clamav-milter.conf","doc":"clamav-milter.conf(5)                                                                   Clam AntiVirus                                                                   clamav-milter.conf(5)\n\nNAME\n       clamav-milter.conf - Configuration file for clamav-milter\n\nDESCRIPTION\n       clamav-milter.conf contains the configuration options for clamav-milter(8).\n\nFILE FORMAT\n       The  file  consists of comments and options with arguments. Each line which starts with a hash (#) symbol is ignored by the parser. Options and arguments are case sensitive and of the\n       form Option Argument. The arguments are of the following types:\n\n       BOOL   Boolean value (yes/no or true/false or 1/0).\n\n       STRING String without blank characters.\n\n       SIZE   Size in bytes. You can use 'M' or 'm' modifiers for megabytes and 'K' or 'k' for kilobytes.\n\n       NUMBER Unsigned integer.\n\nMAIN OPTIONS\n       Example\n              If this option is set clamav-milter will not run.\n\n       MilterSocket STRING\n              Define the interface through which we communicate with sendmail. This option is mandatory!\n              Possible formats are:\n              [[unix|local]:]/path/to/file - to specify a unix domain socket\n              inet:port@[hostname|ip-address] - to specify an ipv4 socket\n              inet6:port@[hostname|ip-address] - to specify an ipv6 socket\n              Default: unset\n\n       MilterSocketGroup STRING\n              Define the group ownership for the (unix) milter socket.\n              Default: disabled (the primary group of the user running clamd)\n\n       MilterSocketMode STRING\n              Sets the permissions on the (unix) milter socket to the specified mode.\n              Default: disabled (obey umask)\n\n       FixStaleSocket BOOL\n              Remove stale socket after unclean shutdown.\n              Default: yes\n\n       User STRING\n              Run as another user (clamav-milter must be started by root for this option to work)\n              Default: unset (don´t drop privileges)\n\n       ReadTimeout NUMBER\n              Waiting for data from clamd will timeout after this time (seconds).\n              Default: 120\n\n       Foreground BOOL\n              Don´t fork into background.\n              Default: no\n\n       Chroot STRING\n              Chroot to the specified directory. Chrooting is performed just after reading the config file and before dropping privileges.\n              Default: unset (don´t chroot)\n\n       PidFile STRING\n              Write the daemon's pid to the specified file.\n              Default: disabled\n\n       TemporaryDirectory STRING\n              Optional path to the global temporary directory.\n              Default: system specific (usually /tmp or /var/tmp).\n\nCLAMD OPTIONS\n       ClamdSocket STRING\n              Define the clamd socket to connect to for scanning. This option is mandatory! Syntax:\n              ClamdSocket unix:path\n              ClamdSocket tcp:host:port\n              The first syntax specifies a local unix socket (needs an absolute path) e.g.:\n              ClamdSocket unix:/run/clamav/clamd.sock\n              The second syntax specifies a tcp local or remote tcp socket: the host can be a hostname or an ip address; the \":port\" field is only required for IPv6 addresses,  otherwise  it\n              defaults to 3310 e.g.:\n              ClamdSocket tcp:192.168.0.1\n              This option can be repeated several times with different sockets or even with the same socket: clamd servers will be selected in a round-robin fashion.\n              Default: no default\n\nEXCLUSIONS\n       LocalNet STRING\n              Messages  originating  from these hosts/networks will not be scanned. This option takes a host(name)/mask pair in CIRD notation and can be repeated several times. If \"/mask\" is\n              omitted, a host is assumed. To specify a locally originated, non-smtp, email use the keyword \"local\"\n              Default: unset (scan everything regardless of the origin)\n\n       AllowList STRING\n              This option specifies a file which contains a list of basic POSIX regular expressions. Addresses (sent to or from - see below) matching these regexes  will not be scanned.  Op‐\n              tionally each line can start with the string \"From:\" or \"To:\" (note: no whitespace after the colon) indicating if it is,  respectively, the sender or recipient that  is  to  be\n              allowed. If the field is missing, \"To:\" is assumed.  Lines starting with #, : or ! are ignored.\n              Default: unset (no exclusion applied)\n\n       SkipAuthenticated STRING\n              Messages  from  authenticated  SMTP  users  matching this extended POSIX regular expression (egrep-like) will not be scanned.  As an alternative, a file containing a plain (not\n              regex) list of names (one per line) can be specified using the prefix \"file:\".  e.g. SkipAuthenticated file:/etc/good_guys. Note: this is the AUTH login name!\n              Default: unset (no allowing based on SMTP auth)\n\n       MaxFileSize SIZE\n              Messages larger than this value won´t be scanned. Make sure this value is lower or equal than StreamMaxLength in clamd.conf\n              Default: 100M\n\nACTIONS\n       The following group of options controls the delivery process under  different circumstances. The following actions are available:\n       - Accept: The message is accepted for delivery\n       - Reject: Immediately refuse delivery (a 5xx error is returned to the peer)\n       - Defer: Return a temporary failure message (4xx) to the peer\n       - Blackhole (not available for OnFail): Like Accept but the message is sent to oblivion\n       - Quarantine (not available for OnFail): Like Accept but message is quarantined instead of being delivered. NOTE: In Sendmail the quarantine queue can be examined via mailq  -qQ.  For\n       Postfix this causes the message to be placed on hold.\n\n       OnClean STRING\n              Action to be performed on clean messages (mostly useful for testing)\n              Default: Accept\n\n       OnInfected STRING\n              Action to be performed on infected messages\n              Default: Quarantine\n\n       OnFail STRING\n              Action to be performed on error conditions (this includes failure to allocate data structures, no scanners available, network timeouts, unknown scanner replies and the like)\n              Default: Defer\n\n       RejectMsg STRING\n              This  option  allows you to set a specific rejection reason for infected messages and it´s therefore only useful together with \"OnInfected Reject\". The string \"%v\", if present,\n              will be replaced with the virus name.\n              Default: MTA specific\n\n       AddHeader STRING\n              If this option is set to \"Replace\" (or \"Yes\"), an \"X-Virus-Scanned\" and an \"X-Virus-Status\" headers will be attached to each  processed  message,  possibly  replacing  existing\n              headers.   If  it  is set to Add, the X-Virus headers are added possibly on top of the existing ones. Note that while \"Replace\" can potentially break DKIM signatures, \"Add\" may\n              confuse procmail and similar filters.\n              Default: no\n\n       ReportHostname STRING\n              When AddHeader is in use, this option allows you to set the reported hostname. This may be desirable in order to avoid leaking internal names. If unset the real machine name is\n              used.\n              Default: disabled\n\n       VirusAction STRING\n              Execute a command (possibly searching PATH) when an infected message is found. The following parameters are passed to the invoked program in this order: virus name,  queue  id,\n              sender,  destination, subject, message id, message date. Note #1: this requires MTA macroes to be available (see LogInfected below). Note #2: the process is invoked in the con‐\n              text of clamav-milter. Note #3: clamav-milter will wait for the process to exit. Be quick or fork to avoid unnecessary delays in email delivery.\n              Default: disabled\n\nLOGGING OPTIONS\n       LogFile STRING\n              Enable logging to selected file.\n              Default: no\n\n       LogFileUnlock BOOL\n              Disable a system lock that protects against running clamd with the same configuration file multiple times.\n              Default: no\n\n       LogFileMaxSize SIZE\n              Limit the size of the log file. The logger will be automatically disabled if the file is greater than SIZE. Value of 0 disables the limit.\n              Default: 1M\n\n       LogTime BOOL\n              Log time for each message.\n              Default: no\n\n       LogSyslog BOOL\n              Use system logger (can work together with LogFile).\n              Default: no\n\n       LogFacility STRING\n              Specify the type of syslog messages - please refer to 'man syslog' for facility names.\n              Default: LOG_LOCAL6\n\n       LogVerbose BOOL\n              Enable verbose logging.\n              Default: no\n\n       LogInfected STRING\n              This option allows you to tune what is logged when a message is infected. Possible values are Off (the default - nothing is logged), Basic (minimal info logged), Full  (verbose\n              info logged)\n              Note:  For  this  to  work  properly  in  sendmail,  make  sure  the  msg_id,  mail_addr,  rcpt_addr  and  i  macroes are available in eom. In other words add a line like: Mil‐\n              ter.macros.eom={msg_id}, {mail_addr}, {rcpt_addr}, i to your .cf file. Alternatively use the macro: define(`confMILTER_MACROS_EOM', `{msg_id}, {mail_addr}, {rcpt_addr}, i')\n              Postfix should be working fine with the default settings.\n              Default: disabled\n\n       LogClean STRING\n              This option allows you to tune what is logged when no threat is found in a scanned message.\n              See LogInfected for possible values and caveats.\n              Useful in debugging but drastically increases the log size.\n              Default: disabled\n\n       SupportMultipleRecipients BOOL\n              This option affects the behaviour of LogInfected, LogClean and VirusAction  when a message with multiple recipients is scanned:\n              If SupportMultipleRecipients is off (the default) then one single log entry is generated for the message and, in case the message is determined to be malicious, the command in‐\n              dicated by VirusAction is executed just once. In both cases only the last recipient is reported.\n              If SupportMultipleRecipients is on then one line is logged for each recipient and the command indicated by VirusAction is also executed once for each recipient.\n              Note: although it's probably a good idea to enable this option, the default value is currently set to off for legacy reasons.\n              Default: no\n\nNOTES\n       All options expressing a size are limited to max 4GB. Values in excess will be reset to the maximum.\n\nFILES\n       /etc/clamav/clamav-milter.conf\n\nAUTHOR\n       aCaB  \n\nSEE ALSO\n       clamav-milter(8), clamd(8), clamd.conf(5)\n\nClamAV 1.4.3                                                                             Feb 25, 2009                                                                    clamav-milter.conf(5)","ref":"clamav-milter-conf.html"},{"type":"extras","title":"clamd.conf","doc":"clamd.conf(5)                                                                           Clam AntiVirus                                                                           clamd.conf(5)\n\nNAME\n       clamd.conf - Configuration file for Clam AntiVirus Daemon\n\nDESCRIPTION\n       clamd.conf configures the Clam AntiVirus daemon, clamd(8).\n\nFILE FORMAT\n       The  file  consists of comments and options with arguments. Each line which starts with a hash (#) symbol is ignored by the parser. Options and arguments are case sensitive and of the\n       form Option Argument. The arguments are of the following types:\n\n       BOOL   Boolean value (yes/no or true/false or 1/0).\n\n       STRING String without blank characters.\n\n       SIZE   Size in bytes. You can use 'M' or 'm' modifiers for megabytes and 'K' or 'k' for kilobytes. To specify the size in bytes just don't use modifiers.\n\n       NUMBER Unsigned integer.\n\nDIRECTIVES\n       When some option is not used (commented out or not included in the configuration file at all) clamd takes a default action.\n\n       Example\n              If this option is set clamd will not run.\n\n       LogFile STRING\n              Save all reports to a log file.\n              Default: disabled\n\n       LogFileUnlock BOOL\n              By default the log file is locked for writing and only a single daemon process can write to it. This option disables the lock.\n              Default: no\n\n       LogFileMaxSize SIZE\n              Maximum size of the log file.\n              Value of 0 disables the limit.\n              Default: 1048576\n\n       LogTime BOOL\n              Log time for each message.\n              Default: no\n\n       LogClean BOOL\n              Log all clean files.\n              Useful in debugging but drastically increases the log size.\n              Default: no\n\n       LogSyslog BOOL\n              Use the system logger (can work together with LogFile).\n              Default: no\n\n       LogFacility STRING\n              Type of syslog messages\n              Please refer to 'man syslog' for facility names.\n              Default: LOG_LOCAL6\n\n       LogVerbose BOOL\n              Enable verbose logging.\n              Default: no\n\n       LogRotate BOOL\n              Rotate log file. Requires LogFileMaxSize option set prior to this option.\n              Default: no\n\n       ExtendedDetectionInfo BOOL\n              Log additional information about the infected file, such as its size and hash, together with the virus name.\n              Default: no\n\n       PidFile STRING\n              Write the daemon's pid to the specified file.\n              Default: disabled\n\n       TemporaryDirectory STRING\n              This option allows you to change the default temporary directory.\n              Default: system specific (usually /tmp or /var/tmp).\n\n       DatabaseDirectory STRING\n              This option allows you to change the default database directory. If you enable it, please make sure it points to the same directory in both clamd and freshclam.\n              Default: defined at configuration (/usr/local/share/clamav)\n\n       OfficialDatabaseOnly BOOL\n              Only load the official signatures published by the ClamAV project.\n              Default: no\n\n       FailIfCvdOlderThan NUMBER\n              Return with a nonzero error code if the virus database is older than the specified number of days.\n              Default: -1\n\n       LocalSocket STRING\n              Path to a local (Unix) socket the daemon will listen on.\n              Default: disabled\n\n       LocalSocketGroup STRING\n              Sets the group ownership on the unix socket.\n              Default: the primary group of the user running clamd\n\n       LocalSocketMode STRING\n              Sets the permissions on the unix socket to the specified mode.\n              Default: socket is world readable and writable\n\n       FixStaleSocket BOOL\n              Remove stale socket after unclean shutdown.\n              Default: yes\n\n       TCPSocket NUMBER\n              TCP port number the daemon will listen on.\n              Default: disabled\n\n       TCPAddr STRING\n              By default clamd binds to INADDR_ANY.\n              This option allows you to restrict the TCP address and provide some degree of protection from the outside world. This option can be specified multiple times in order to  listen\n              on multiple IPs. IPv6 is now supported.\n              Default: disabled\n\n       MaxConnectionQueueLength NUMBER\n              Maximum length the queue of pending connections may grow to.\n              Default: 200\n\n       StreamMaxLength SIZE\n              Close the STREAM session when the data size limit is exceeded.\n              The value should match your MTA's limit for the maximum attachment size.\n              Default: 100M\n\n       StreamMinPort NUMBER\n              The STREAM command uses an FTP-like protocol.\n              This option sets the lower boundary for the port range.\n              Default: 1024\n\n       StreamMaxPort NUMBER\n              This option sets the upper boundary for the port range.\n              Default: 2048\n\n       MaxThreads NUMBER\n              Maximum number of threads running at the same time.\n              Default: 10\n\n       ReadTimeout NUMBER\n              This option specifies the time (in seconds) after which clamd should timeout if a client doesn't provide any data.\n              Default: 120\n\n       CommandReadTimeout NUMBER\n              This  option  specifies  the  time  (in seconds) after which clamd should timeout if a client doesn't provide any initial command after connecting.  The default is set to 30 to\n              avoid timeouts with TCP sockets when processing large messages.  If using a Unix socket, the value can be changed to 5.  Note: the timeout for subsequents commands, and/or data\n              chunks is specified by ReadTimeout.\n              Default: 30\n\n       SendBufTimeout NUMBER\n              This option specifies how long to wait (in milliseconds) if the send buffer is full.  Keep this value low to prevent clamd hanging.\n              Default: 500\n\n       MaxQueue NUMBER\n              Maximum number of queued items (including those being processed by MaxThreads threads).  It is recommended to have this value at least twice MaxThreads if possible.\n              WARNING: you shouldn't increase this too much to avoid running out of file descriptors, the following condition should hold: MaxThreads*MaxRecursion + MaxQueue - MaxThreads + 6\n                PCREMatchLimit are superfluous.\n              WARNING: setting this limit too high may severely impact performance.\n              Default: 2000\n\n       PCREMaxFileSize SIZE\n              This option sets the maximum filesize for which PCRE subsigs will be executed.\n              Files exceeding this limit will not have PCRE subsigs executed unless a subsig is encompassed to a smaller buffer.\n              Negative values are not allowed.\n              Setting this value to zero disables the limit.\n              WARNING: setting this limit too high or disabling it may severely impact performance.\n              Default: 100M\n\n       OnAccessIncludePath STRING\n              This option specifies a directory (including all files and directories inside it), which should be scanned on access. This option can be used multiple times.\n              Default: disabled\n\n       OnAccessExcludePath STRING\n              This option allows excluding directories from on-access scanning. It can be used multiple times.\n              Default: disabled\n\n       OnAccessExcludeRootUID BOOL\n              With this option you can exclude the root UID (0). Processes run under root will be able to access all files without triggering scans or permission denied events.\n              Note that if clamd cannot check the uid of the process that generated an on-access scan event (e.g., because OnAccessPrevention was not enabled, and  the  process  already  ex‐\n              ited),  clamd  will perform a scan.  Thus, setting OnAccessExcludeRootUID is not guaranteed to prevent every access by the root user from triggering a scan (unless OnAccessPre‐\n              vention is enabled).\n              Default: no\n\n       OnAccessExcludeUID NUMBER\n              With this option you can exclude specific UIDs. Processes with these UIDs will be able to access all files without triggering scans or permission denied events.\n              This option can be used multiple times (one per line).\n              Note: using a value of 0 on any line will disable this option entirely. To exclude the root UID (0) please enable the OnAccessExcludeRootUID option.\n              Also note that if clamd cannot check the uid of the process that generated an on-access scan event (e.g., because OnAccessPrevention was not enabled, and  the  process  already\n              exited), clamd will perform a scan.  Thus, setting OnAccessExcludeUID is not guaranteed to prevent every access by the specified uid from triggering a scan (unless OnAccessPre‐\n              vention is enabled).\n              Default: disabled\n\n       OnAccessExcludeUname STRING\n              This  option  allows exclusions via user names when using the on-access scanning client. It can be used multiple times, and has the same potential race condition limitations of\n              the OnAccessExcludeUID option.\n              Default: disabled\n\n       OnAccessMaxFileSize SIZE\n              Files larger than this value will not be scanned in on access.\n              Default: 5M\n\n       OnAccessMaxThreads NUMBER\n              Max number of scanning threads to allocate to the OnAccess thread pool at startup. These threads are the ones responsible for creating a connection with the daemon and  kicking\n              off scanning after an event has been processed. To prevent clamonacc from consuming all clamd's resources keep this lower than clamd's max threads.\n              Default: 5\n\n       OnAccessCurlTimeout NUMBER\n              Max amount of time (in milliseconds) that the OnAccess client should spend for every connect, send, and receive attempt when communicating with clamd via curl.\n              Default: 5000 (5 seconds)\n\n       OnAccessMountPath STRING\n              Specifies a mount point (including all files and directories under it), which should be scanned on access. This option can be used multiple times.\n              Default: disabled\n\n       OnAccessDisableDDD BOOL\n              Disables the dynamic directory determination system which allows for recursively watching include paths.\n              Default: no\n\n       OnAccessPrevention BOOL\n              Enables fanotify blocking when malicious files are found.\n              Default: disabled\n\n       OnAccessRetryAttempts NUMBER\n              Number of times the OnAccess client will retry a failed scan due to connection problems (or other issues).\n              Default: 0\n\n       OnAccessDenyOnError BOOL\n              When  using  prevention,  if  this option is turned on, any errors that occur during  scanning will result in the event attempt being denied. This could potentially lead to un‐\n              wanted system behaviour with certain configurations, so the client defaults this to off and prefers allowing access events in case of scan or connection error.\n              Default: no\n\n       OnAccessExtraScanning BOOL\n              Toggles extra scanning and notifications when a file or directory is created or moved.\n              Requires the  DDD system to kick-off extra scans.\n              Default: no\n\n       DisableCertCheck BOOL\n              Disable authenticode certificate chain verification in PE files.\n              Default: no\n\nNOTES\n       All options expressing a size are limited to max 4GB. Values in excess will be reset to the maximum.\n\nFILES\n       /etc/clamav/clamd.conf\n\nAUTHORS\n       Tomasz Kojm  , Kevin Lin  \n\nSEE ALSO\n       clamd(8), clamdscan(1), clamav-milter(8), freshclam(1), freshclam.conf(5)\n\nClamAV 1.4.3                                                                           December 4, 2013                                                                          clamd.conf(5)","ref":"clamd-conf.html"},{"type":"extras","title":"classes.conf","doc":"classes.conf(5)                                                                          OpenPrinting                                                                          classes.conf(5)\n\nNAME\n       classes.conf - class configuration file for cups\n\nDESCRIPTION\n       The classes.conf file defines the local printer classes that are available.  It is normally located in the /etc/cups directory and is maintained by the cupsd(8) program.  This file is\n       not intended to be edited or managed manually.\n\nNOTES\n       The name, location, and format of this file are an implementation detail that will change in future releases of CUPS.\n\nSEE ALSO\n       cupsd(8), cupsd.conf(5), mime.convs(5), mime.types(5), printers.conf(5), subscriptions.conf(5), CUPS Online Help (http://localhost:631/help)\n\nCOPYRIGHT\n       Copyright © 2020-2024 by OpenPrinting.\n\n2021-02-28                                                                                   CUPS                                                                              classes.conf(5)","ref":"classes-conf.html"},{"type":"extras","title":"client.conf","doc":"client.conf(5)                                                                           OpenPrinting                                                                           client.conf(5)\n\nNAME\n       client.conf - client configuration file for cups (deprecated on macos)\n\nDESCRIPTION\n       The  client.conf  file configures the CUPS client and is normally located in the /etc/cups and/or ~/.cups directories.  Each line in the file can be a configuration directive, a blank\n       line, or a comment. Comment lines start with the # character.\n\n       Note: Starting with macOS 10.7, this file is only used by command-line and X11 applications plus the IPP backend.  The ServerName directive is not supported on macOS at all.  Starting\n       with macOS 10.12, all applications can access these settings in the /Library/Preferences/org.cups.PrintingPrefs.plist file instead.  See the NOTES section below for more information.\n\n   DIRECTIVES\n       The following directives are understood by the client. Consult the online help for detailed descriptions:\n\n       AllowAnyRoot Yes\n\n       AllowAnyRoot No\n            Specifies whether to allow TLS with certificates that have not been signed by a trusted Certificate Authority.  The default is \"Yes\".\n\n       AllowExpiredCerts Yes\n\n       AllowExpiredCerts No\n            Specifies whether to allow TLS with expired certificates.  The default is \"No\".\n\n       DigestOptions DenyMD5\n\n       DigestOptions None\n            Specifies HTTP Digest authentication options.  DenyMD5 disables support for the original MD5 hash algorithm.\n\n       Encryption IfRequested\n\n       Encryption Never\n\n       Encryption Required\n            Specifies the level of encryption that should be used.\n\n       GSSServiceName name\n            Specifies the Kerberos service name that is used for authentication, typically \"host\", \"http\", or \"ipp\".  CUPS adds the remote hostname (\"name@server.example.com\") for  you.  The\n            default name is \"http\".\n\n       ServerName hostname-or-ip-address[:port]\n\n       ServerName /domain/socket\n            Specifies the address and optionally the port to use when connecting to the server.  Note: This directive is not supported on macOS 10.7 or later.\n\n       ServerName hostname-or-ip-address[:port]/version=1.1\n            Specifies the address and optionally the port to use when connecting to a server running CUPS 1.3.12 and earlier.\n\n       SSLOptions [AllowDH] [AllowRC4] [AllowSSL3] [DenyCBC] [DenyTLS1.0] [MaxTLS1.0] [MaxTLS1.1] [MaxTLS1.2] [MaxTLS1.3] [MinTLS1.0] [MinTLS1.1] [MinTLS1.2] [MinTLS1.3]\n\n       SSLOptions None\n            Sets  encryption  options  (only in /etc/cups/client.conf).  By default, CUPS only supports encryption using TLS v1.0 or higher using known secure cipher suites.  Security is re‐\n            duced when Allow options are used.  Security is enhanced when Deny options are used.  The AllowDH option enables cipher suites using plain  Diffie-Hellman  key  negotiation  (not\n            supported  on  systems  using  GNU  TLS).  The AllowRC4 option enables the 128-bit RC4 cipher suites, which are required for some older clients.  The AllowSSL3 option enables SSL\n            v3.0, which is required for some older clients that do not support TLS v1.0.  The DenyCBC option disables all CBC cipher suites.  The DenyTLS1.0 option disables TLS v1.0  support\n            - this sets the minimum protocol version to TLS v1.1.  The MinTLS options set the minimum TLS version to support.  The MaxTLS options set the maximum TLS version to support.  Not\n            all operating systems support TLS 1.3 at this time.\n\n       TrustOnFirstUse Yes\n\n       TrustOnFirstUse No\n            Specifies whether to trust new TLS certificates by default.  The default is \"Yes\".\n\n       User name\n            Specifies the default user name to use for requests.\n\n       UserAgentTokens None\n\n       UserAgentTokens ProductOnly\n\n       UserAgentTokens Major\n\n       UserAgentTokens Minor\n\n       UserAgentTokens Minimal\n\n       UserAgentTokens OS\n\n       UserAgentTokens Full\n            Specifies  what  information  is  included  in  the  User-Agent  header  of HTTP requests.  \"None\" disables the User-Agent header.  \"ProductOnly\" reports \"CUPS\".  \"Major\" reports\n            \"CUPS/major IPP/2\".  \"Minor\" reports \"CUPS/major.minor IPP/2.1\".  \"Minimal\" reports \"CUPS/major.minor.patch IPP/2.1\".   \"OS\"  reports  \"CUPS/major.minor.path  (osname  osversion)\n            IPP/2.1\".  \"Full\" reports \"CUPS/major.minor.path (osname osversion; architecture) IPP/2.1\".  The default is \"Minimal\".\n\n       ValidateCerts Yes\n\n       ValidateCerts No\n            Specifies whether to only allow TLS with certificates whose common name matches the hostname.  The default is \"No\".\n\nNOTES\n       The client.conf file is deprecated on macOS and will no longer be supported in a future version of CUPS.  Configuration settings can instead be viewed or changed using the defaults(1)\n       command:\n       defaults write /Library/Preferences/org.cups.PrintingPrefs.plist Encryption Required\n       defaults write /Library/Preferences/org.cups.PrintingPrefs.plist TrustOnFirstUse -bool NO\n\n       defaults read /Library/Preferences/org.cups.PrintingPrefs.plist Encryption\n       On Linux and other systems using GNU TLS, the /etc/cups/ssl/site.crl file, if present, provides a list of revoked X.509 certificates and is used when validating certificates.\n\nSEE ALSO\n       cups(1), default(1), CUPS Online Help (http://localhost:631/help)\n\nCOPYRIGHT\n       Copyright © 2020-2024 by OpenPrinting.\n\n2021-02-28                                                                                   CUPS                                                                               client.conf(5)","ref":"client-conf.html"},{"type":"extras","title":"Compose","doc":"Compose(5)                                                                            File Formats Manual                                                                           Compose(5)\n\nNAME\n       Compose - X client mappings for multi-key input sequences\n\nDESCRIPTION\n       The  X  library, libX11, provides a simple input method for characters beyond those represented on typical keyboards using sequences of key strokes that are combined to enter a single\n       character.\n\n       The compose file is searched for in  the following order:\n\n       -      If the environment variable $XCOMPOSEFILE is set, its value is used as the name of the Compose file.\n\n       -      If the user's home directory has a file named .XCompose, it is used as the Compose file.\n\n       -      The system provided compose file is used by mapping the locale to a compose file from the list in /usr/share/X11/locale/compose.dir.\n\n       Compose files can use an \"include\" instruction.  This allows local modifications to be made to existing compose files without including all of the content directly.  For example,  the\n       system's iso8859-1 compose file can be included with a line like this:\n           include \"%S/iso8859-1/Compose\"\n\n       There are several substitutions that can be made in the file name of the include instruction:\n\n       %H  expands to the user's home directory (the $HOME environment variable)\n\n       %L  expands to the name of the locale specific Compose file (i.e., \"/usr/share/X11/locale/ /Compose\")\n\n       %S  expands to the name of the system directory for Compose files (i.e., \"/usr/share/X11/locale\")\n\n       For example, you can include in your compose file the default Compose file by using:\n              include \"%L\"\n       and then rewrite only the few rules that you need to change.  New compose rules can be added, and previous ones replaced.\n\nFILE FORMAT\n       Compose  files  are  plain text files, with a separate line for each compose sequence.  Comments begin with # characters.  Each compose sequence specifies one or more events and a re‐\n       sulting input sequence, with an optional comment at the end of the line:\n              EVENT [EVENT...] : RESULT [# COMMENT]\n\n       Each event consists of a specified input keysym, and optional modifier states:\n              [([!] ([~] MODIFIER)...) | None]  \n\n       If the modifier list is preceded by \"!\" it must match exactly.  MODIFIER may be one of Ctrl, Lock, Caps, Shift, Alt or Meta.  Each modifier may be preceded by a \"~\" character to indi‐\n       cate that the modifier must not be present.  If \"None\" is specified, no modifier may be present.\n\n       The result specifies a string, keysym, or both, that the X client receives as input when the sequence of events is input:\n              \"STRING\" | keysym | \"STRING\" keysym\n\n       Keysyms are specified without the XK_ prefix.\n\n       Strings may be direct text encoded in the locale for which the compose file is to be used, or an escaped octal or hexadecimal character code.  Octal codes are specified as \"\\123\"  and\n       hexadecimal  codes  as \"\\x3a\".  It is not necessary to specify in the right part of a rule a locale encoded string in addition to the keysym name.  If the string is omitted, Xlib fig‐\n       ures it out from the keysym according to the current locale.  I.e., if a rule looks like:\n                  : \"\\300\" Agrave\n       the result of the composition is always the letter with the \"\\300\" code.  But if the rule is:\n                  : Agrave\n       the result depends on how Agrave is mapped in the current locale.\n\nENVIRONMENT\n       XCOMPOSEFILE\n              File to use for compose sequences.\n\n       XCOMPOSECACHE\n              Directory to use for caching compiled compose files.\n\nFILES\n       $HOME/.XCompose\n              User default compose file if XCOMPOSEFILE is not set.\n\n       /usr/share/X11/locale/compose.dir\n              File listing the compose file path to use for each locale.\n\n       /usr/share/X11/locale/ /Compose\n              System default compose file for the locale, mapped via compose.dir.\n\n       /var/cache/libx11/compose/\n              System-wide cache directory for compiled compose files.\n\n       $HOME/.compose-cache/\n              Per-user cache directory for compiled compose files.\n\nSEE ALSO\n       XLookupString(3), XmbLookupString(3), XwcLookupString(3), Xutf8LookupString(3), mkcomposecache(1), locale(7).\n       Xlib - C Language X Interface\n\nX Version 11                                                                             libX11 1.8.12                                                                              Compose(5)","ref":"compose.html"},{"type":"extras","title":"config","doc":"CONFIG(5SSL)                                                                                OpenSSL                                                                               CONFIG(5SSL)\n\nNAME\n       config - OpenSSL CONF library configuration files\n\nDESCRIPTION\n       This page documents the syntax of OpenSSL configuration files, as parsed by NCONF_load(3) and related functions.  This format is used by many of the OpenSSL commands, and to\n       initialize the libraries when used by any application.\n\n       The first part describes the general syntax of the configuration files, and subsequent sections describe the semantics of individual modules. Other modules are described in\n       fips_config(5) and x509v3_config(5).  The syntax for defining ASN.1 values is described in ASN1_generate_nconf(3).\n\nSYNTAX\n       A configuration file is a series of lines.  Blank lines, and whitespace between the elements of a line, have no significance. A comment starts with a # character; the rest of the line\n       is ignored. If the # is the first non-space character in a line, the entire line is ignored.\n\n   Directives\n       Two directives can be used to control the parsing of configuration files: .include and .pragma.\n\n       For compatibility with older versions of OpenSSL, an equal sign after the directive will be ignored.  Older versions will treat it as an assignment, so care should be taken if the\n       difference in semantics is important.\n\n       A file can include other files using the include syntax:\n\n         .include [=] pathname\n\n       If pathname is a simple filename, that file is included directly at that point.  Included files can have .include statements that specify other files.  If pathname is a directory, all\n       files within that directory that have a \".cnf\" or \".conf\" extension will be included.  (This is only available on systems with POSIX IO support.)  Any sub-directories found inside the\n       pathname are ignored.  Similarly, if a file is opened while scanning a directory, and that file has an .include directive that specifies a directory, that is also ignored.\n\n       As a general rule, the pathname should be an absolute path; this can be enforced with the abspath and includedir pragmas, described below.  The environment variable\n       OPENSSL_CONF_INCLUDE, if it exists, is prepended to all relative pathnames.  If the pathname is still relative, it is interpreted based on the current working directory.\n\n       To require all file inclusions to name absolute paths, use the following directive:\n\n        .pragma [=] abspath:value\n\n       The default behavior, where the value is false or off, is to allow relative paths. To require all .include pathnames to be absolute paths, use a value of true or on.\n\n       In these files, the dollar sign, $, is used to reference a variable, as described below.  On some platforms, however, it is common to treat $ as a regular character in symbol names.\n       Supporting this behavior can be done with the following directive:\n\n        .pragma [=] dollarid:value\n\n       The default behavior, where the value is false or off, is to treat the dollarsign as indicating a variable name; \"foo$bar\" is interpreted as \"foo\" followed by the expansion of the\n       variable \"bar\". If value is true or on, then \"foo$bar\" is a single seven-character name and variable expansions must be specified using braces or parentheses.\n\n        .pragma [=] includedir:value\n\n       If a relative pathname is specified in the .include directive, and the OPENSSL_CONF_INCLUDE environment variable doesn't exist, then the value of the includedir pragma, if it exists,\n       is prepended to the pathname.\n\n   Settings\n       A configuration file is divided into a number of sections.  A section begins with the section name in square brackets, and ends when a new section starts, or at the end of the file.\n       The section name can consist of alphanumeric characters and underscores.  Whitespace between the name and the brackets is removed.\n\n       The first section of a configuration file is special and is referred to as the default section. This section is usually unnamed and spans from the start of file until the first named\n       section. When a name is being looked up, it is first looked up in the current or named section, and then the default section if necessary.\n\n       The environment is mapped onto a section called ENV.\n\n       Within a section are a series of name/value assignments, described in more detail below.  As a reminder, the square brackets shown in this example are required, not optional:\n\n        [ section ]\n        name1 = This is value1\n        name2 = Another value\n        ...\n        [ newsection ]\n        name1 = New value1\n        name3 = Value 3\n\n       The name can contain any alphanumeric characters as well as a few punctuation symbols such as . , ; and _.  Whitespace after the name and before the equal sign is ignored.\n\n       If a name is repeated in the same section, then all but the last value are ignored. In certain circumstances, such as with Certificate DNs, the same field may occur multiple times.\n       In order to support this, commands like openssl-req(1) ignore any leading text that is preceded with a period. For example:\n\n        1.OU = First OU\n        2.OU = Second OU\n\n       The value consists of the string following the = character until end of line with any leading and trailing whitespace removed.\n\n       The value string undergoes variable expansion. The text $var or \"${var}\" inserts the value of the named variable from the current section.  To use a value from another section use\n       $section::name or \"${section::name}\".  By using $ENV::name, the value of the specified environment variable will be substituted.\n\n       Variables must be defined before their value is referenced, otherwise an error is flagged and the file will not load.  This can be worked around by specifying a default value in the\n       default section before the variable is used.\n\n       Any name/value settings in an ENV section are available to the configuration file, but are not propagated to the environment.\n\n       It is an error if the value ends up longer than 64k.\n\n       It is possible to escape certain characters by using a single ' or double \" quote around the value, or using a backslash \\ before the character, By making the last character of a line\n       a \\ a value string can be spread across multiple lines. In addition the sequences \\n, \\r, \\b and \\t are recognized.\n\n       The expansion and escape rules as described above that apply to value also apply to the pathname of the .include directive.\n\nOPENSSL LIBRARY CONFIGURATION\n       The sections below use the informal term module to refer to a part of the OpenSSL functionality. This is not the same as the formal term FIPS module, for example.\n\n       The OpenSSL configuration looks up the value of openssl_conf in the default section and takes that as the name of a section that specifies how to configure any modules in the library.\n       It is not an error to leave any module in its default configuration. An application can specify a different name by calling CONF_modules_load_file(), for example, directly.\n\n       OpenSSL also looks up the value of config_diagnostics.  If this exists and has a nonzero numeric value, any error suppressing flags passed to CONF_modules_load() will be ignored.\n       This is useful for diagnosing misconfigurations but its use in production requires additional consideration.  With this option enabled, a configuration error will completely prevent\n       access to a service.  Without this option and in the presence of a configuration error, access will be allowed but the desired configuration will not be used.\n\n        # These must be in the default section\n        config_diagnostics = 1\n        openssl_conf = openssl_init\n\n        [openssl_init]\n        oid_section = oids\n        providers = providers\n        alg_section = evp_properties\n        ssl_conf = ssl_configuration\n        engines = engines\n        random = random\n\n        [oids]\n        ... new oids here ...\n\n        [providers]\n        ... provider stuff here ...\n\n        [evp_properties]\n        ... EVP properties here ...\n\n        [ssl_configuration]\n        ... SSL/TLS configuration properties here ...\n\n        [engines]\n        ... engine properties here ...\n\n        [random]\n        ... random properties here ...\n\n       The semantics of each module are described below. The phrase \"in the initialization section\" refers to the section identified by the openssl_conf or other name (given as openssl_init\n       in the example above).  The examples below assume the configuration above is used to specify the individual sections.\n\n   ASN.1 Object Identifier Configuration\n       The name oid_section in the initialization section names the section containing name/value pairs of OID's.  The name is the short name; the value is an optional long name followed by\n       a comma, and the numeric value.  While some OpenSSL commands have their own section for specifying OID's, this section makes them available to all commands and applications.\n\n        [oids]\n        shortName = a very long OID name, 1.2.3.4\n        newoid1 = 1.2.3.4.1\n        some_other_oid = 1.2.3.5\n\n       If a full configuration with the above fragment is in the file example.cnf, then the following command line:\n\n        OPENSSL_CONF=example.cnf openssl asn1parse -genstr OID:1.2.3.4.1\n\n       will output:\n\n        0:d=0  hl=2 l=   4 prim: OBJECT            :newoid1\n\n       showing that the OID \"newoid1\" has been added as \"1.2.3.4.1\".\n\n   Provider Configuration\n       The name providers in the initialization section names the section containing cryptographic provider configuration. The name/value assignments in this section each name a provider,\n       and point to the configuration section for that provider. The provider-specific section is used to specify how to load the module, activate it, and set other parameters.\n\n       Within a provider section, the following names have meaning:\n\n       identity\n           This is used to specify an alternate name, overriding the default name specified in the list of providers.  For example:\n\n            [providers]\n            foo = foo_provider\n\n            [foo_provider]\n            identity = my_fips_module\n\n       module\n           Specifies the pathname of the module (typically a shared library) to load.\n\n       activate\n           If present and set to one of the values yes, on, true or 1, then the associated provider will be activated. Conversely, setting this value to no, off, false, or 0 will prevent the\n           provider from being activated. Settings can be given in lower or uppercase. Setting activate to any other setting, or omitting a setting value will result in an error.\n\n           = item soft_load\n\n           If  enabled,  informs  the  library  to  clear the error stack on failure to activate requested provider.  A value of 1, yes, true or on (in lower or uppercase) will activate this\n           setting, while a value of 0, no, false, or off (again in lower or uppercase) will disable this setting.  Any other value will produce an error.  Note this setting defaults to  off\n           if not provided\n\n       All parameters in the section as well as sub-sections are made available to the provider.\n\n       Default provider and its activation\n\n       If no providers are activated explicitly, the default one is activated implicitly.  See OSSL_PROVIDER-default(7) for more details.\n\n       If  you  add a section explicitly activating any other provider(s), you most probably need to explicitly activate the default provider, otherwise it becomes unavailable in openssl. It\n       may make the system remotely unavailable.\n\n   EVP Configuration\n       The name alg_section in the initialization section names the section containing algorithmic properties when using the EVP API.\n\n       Within the algorithm properties section, the following names have meaning:\n\n       default_properties\n           The value may be anything that is acceptable as a property query string for EVP_set_default_properties().\n\n       fips_mode (deprecated)\n           The value is a boolean that can be yes or no.  If the value is yes, this is exactly equivalent to:\n\n            default_properties = fips=yes\n\n           If the value is no, nothing happens. Using this name is deprecated, and if used, it must be the only name in the section.\n\n   SSL Configuration\n       The name ssl_conf in the initialization section names the section containing the list of SSL/TLS configurations.  As with the providers, each name in this section identifies a section\n       with the configuration for that name. For example:\n\n        [ssl_configuration]\n        server = server_tls_config\n        client = client_tls_config\n        system_default = tls_system_default\n\n        [server_tls_config]\n        ... configuration for SSL/TLS servers ...\n\n        [client_tls_config]\n        ... configuration for SSL/TLS clients ...\n\n       The configuration name system_default has a special meaning.  If it exists, it is applied whenever an SSL_CTX object is created.  For example, to impose system-wide  minimum  TLS  and\n       DTLS protocol versions:\n\n        [tls_system_default]\n        MinProtocol = TLSv1.2\n        MinProtocol = DTLSv1.2\n\n       The  minimum  TLS protocol is applied to SSL_CTX objects that are TLS-based, and the minimum DTLS protocol to those are DTLS-based.  The same applies also to maximum versions set with\n       MaxProtocol.\n\n       Each configuration section consists of name/value pairs that are parsed by SSL_CONF_cmd(3), which will be called by SSL_CTX_config() or SSL_config(),  appropriately.   Note  that  any\n       characters  before an initial dot in the configuration section are ignored, so that the same command can be used multiple times. This probably is most useful for loading different key\n       types, as shown here:\n\n        [server_tls_config]\n        RSA.Certificate = server-rsa.pem\n        ECDSA.Certificate = server-ecdsa.pem\n\n   Engine Configuration\n       The name engines in the initialization section names the section containing the list of ENGINE configurations.  As with the providers, each name in this section identifies  an  engine\n       with the configuration for that engine.  The engine-specific section is used to specify how to load the engine, activate it, and set other parameters.\n\n       Within an engine section, the following names have meaning:\n\n       engine_id\n           This is used to specify an alternate name, overriding the default name specified in the list of engines. If present, it must be first.  For example:\n\n            [engines]\n            foo = foo_engine\n\n            [foo_engine]\n            engine_id = myfoo\n\n       dynamic_path\n           This  loads  and adds an ENGINE from the given path. It is equivalent to sending the ctrls SO_PATH with the path argument followed by LIST_ADD with value 2 and LOAD to the dynamic\n           ENGINE.  If this is not the required behaviour then alternative ctrls can be sent directly to the dynamic ENGINE using ctrl commands.\n\n       init\n           This specifies whether to initialize the ENGINE. If the value is 0 the ENGINE will not be initialized, if the value is 1 an attempt is made to initialize the  ENGINE  immediately.\n           If the init command is not present then an attempt will be made to initialize the ENGINE after all commands in its section have been processed.\n\n       default_algorithms\n           This sets the default algorithms an ENGINE will supply using the function ENGINE_set_default_string().\n\n       All  other  names are taken to be the name of a ctrl command that is sent to the ENGINE, and the value is the argument passed with the command.  The special value EMPTY means no value\n       is sent with the command.  For example:\n\n        [engines]\n        foo = foo_engine\n\n        [foo_engine]\n        dynamic_path = /some/path/fooengine.so\n        some_ctrl = some_value\n        default_algorithms = ALL\n        other_ctrl = EMPTY\n\n   Random Configuration\n       The name random in the initialization section names the section containing the random number generator settings.\n\n       Within the random section, the following names have meaning:\n\n       random\n           This is used to specify the random bit generator.  For example:\n\n            [random]\n            random = CTR-DRBG\n\n           The available random bit generators are:\n\n           CTR-DRBG\n           HASH-DRBG\n           HMAC-DRBG\n       cipher\n           This specifies what cipher a CTR-DRBG random bit generator will use.  Other random bit generators ignore this name.  The default value is AES-256-CTR.\n\n       digest\n           This specifies what digest the HASH-DRBG or HMAC-DRBG random bit generators will use.  Other random bit generators ignore this name.\n\n       properties\n           This sets the property query used when fetching the random bit generator and any underlying algorithms.\n\n       seed\n           This sets the randomness source that should be used.  By default SEED-SRC will be used outside of the FIPS provider.  The  FIPS  provider  uses  call  backs  to  access  the  same\n           randomness sources from outside the validated boundary.\n\n       seed_properties\n           This sets the property query used when fetching the randomness source.\n\n       random_provider\n           This  sets  the  provider  to  use  for the RAND_bytes(3) calls instead of the built-in entropy sources.  It defaults to \"fips\".  If the named provider is not loaded, the built-in\n           entropy sources will be used.\n\nEXAMPLES\n       This example shows how to use quoting and escaping.\n\n        # This is the default section.\n        HOME = /temp\n        configdir = $ENV::HOME/config\n\n        [ section_one ]\n        # Quotes permit leading and trailing whitespace\n        any = \" any variable name \"\n        other = A string that can \\\n        cover several lines \\\n        by including \\\\ characters\n        message = Hello World\\n\n\n        [ section_two ]\n        greeting = $section_one::message\n\n       This example shows how to expand environment variables safely.  In this example, the variable tempfile is intended to refer to a temporary file, and the environment variable  TEMP  or\n       TMP,  if present, specify the directory where the file should be put.  Since the default section is checked if a variable does not exist, it is possible to set TMP to default to /tmp,\n       and TEMP to default to TMP.\n\n        # These two lines must be in the default section.\n        TMP = /tmp\n        TEMP = $ENV::TMP\n\n        # This can be used anywhere\n        tmpfile = ${ENV::TEMP}/tmp.filename\n\n       This example shows how to enforce FIPS mode for the application sample.\n\n        sample = fips_config\n\n        [fips_config]\n        alg_section = evp_properties\n\n        [evp_properties]\n        default_properties = \"fips=yes\"\n\nENVIRONMENT\n       OPENSSL_CONF\n           The path to the config file, or the empty string for none.  Ignored in set-user-ID and set-group-ID programs.\n\n       OPENSSL_ENGINES\n           The path to the engines directory.  Ignored in set-user-ID and set-group-ID programs.\n\n       OPENSSL_MODULES\n           The path to the directory with OpenSSL modules, such as providers.  Ignored in set-user-ID and set-group-ID programs.\n\n       OPENSSL_CONF_INCLUDE\n           The optional path to prepend to all .include paths.\n\nBUGS\n       There is no way to include characters using the octal \\nnn form. Strings are all null terminated so nulls cannot form part of the value.\n\n       The escaping isn't quite right: if you want to use sequences like \\n you can't use any quote escaping on the same line.\n\n       The limit that only one directory can be opened and read at a time can be considered a bug and should be fixed.\n\nHISTORY\n       An undocumented API, NCONF_WIN32(), used a slightly different set of parsing rules there were intended to be tailored to the Microsoft Windows platform.  Specifically,  the  backslash\n       character  was  not  an  escape  character  and  could  be  used in pathnames, only the double-quote character was recognized, and comments began with a semi-colon.  This function was\n       deprecated in OpenSSL 3.0; applications with configuration files using that syntax will have to be modified.\n\nSEE ALSO\n       openssl-x509(1),  openssl-req(1),  openssl-ca(1),  openssl-fipsinstall(1),  ASN1_generate_nconf(3),  EVP_set_default_properties(3),  CONF_modules_load(3),   CONF_modules_load_file(3),\n       RAND_bytes(3), fips_config(5), and x509v3_config(5).\n\nCOPYRIGHT\n       Copyright 2000-2025 The OpenSSL Project Authors. All Rights Reserved.\n\n       Licensed  under  the  Apache  License  2.0  (the \"License\").  You may not use this file except in compliance with the License.  You can obtain a copy in the file LICENSE in the source\n       distribution or at  .\n\n3.5.1                                                                                     2025-07-12                                                                              CONFIG(5SSL)","ref":"config.html"},{"type":"extras","title":"console-setup","doc":"CONSOLE-SETUP(5)                                                                  Console-setup User's Manual                                                                 CONSOLE-SETUP(5)\n\nNAME\n       console-setup - configuration file for setupcon\n\nDESCRIPTION\n       The  file  console-setup specifies the encoding and the font to be used by setupcon(1) in order to setup the console.  It can be used also to specify the keyboard layout but it is not\n       recommended to do so, use keyboard(5) instead.\n\n       The font specification consists of three parameters - codeset, font face and font size.  The codeset specifies what characters will be supported by the font.  There  isn't  one-to-one\n       correspondence  between  codeset and encoding, for example the codeset Lat15 is suitable for ISO 8859-1, ISO 8859-9 and ISO 8859-15.  The codesets are two kinds - small and big.  Only\n       small codesets are supported on FreeBSD.\n\n       The font face determines the general look of the font.  Each font face is available in certain possible sizes.  On FreeBSD only 8x16, 8x14 and 8x8 are valid sizes.  On Linux if frame‐\n       buffer is not used or consolechars(1) is installed instead of setfont(1), then the permitted sizes have the form 8xNUMBER.\n\n       The console driver of FreeBSD permits fonts in different sizes to be simultaneously loaded.  Which one of them will be actually used depends on the current video mode.  Therefore,  on\n       this platform the font size specification will be ignored and setupcon(1) will load the selected font face in all available sizes.\n\n       The file console-setup consists of variable settings in POSIX format:\n\n              VARIABLE='VALUE'\n\n       Only one assignment is allowed per line.  Comments (starting with '#') are also allowed.\n\nOPTIONS\n       The following variables can be set.\n\n       ACTIVE_CONSOLES\n              Specifies the device files in /dev of the virtual terminals to be configured.  File name wild-cards (*, ?)  are allowed.  On Linux usually you can set this to /dev/tty[1-6] and\n              on  FreeBSD a sensible value is /dev/ttyv[0-8].  You can assign to this variable also the special value guess.  It will cause setupcon(1) to attempt to guess the active virtual\n              consoles by looking in configuration files such as /etc/inittab and /etc/ttys.  This guessing is not always reliable.\n\n       CHARMAP\n              Specifies the desired encoding on the console.  Valid values are: UTF-8, ARMSCII-8, CP1251, CP1255, CP1256,  GEORGIAN-ACADEMY,  GEORGIAN-PS,  IBM1133,  ISIRI-3342,  ISO-8859-1,\n              ISO-8859-2,  ISO-8859-3,  ISO-8859-4,  ISO-8859-5, ISO-8859-6, ISO-8859-7, ISO-8859-8, ISO-8859-9, ISO-8859-10, ISO-8859-11, ISO-8859-13, ISO-8859-14, ISO-8859-15, ISO-8859-16,\n              KOI8-R, KOI8-U, TIS-620 and VISCII.  The special value guess is also recognized in which case the system command locale(1) will be used to guess the desired encoding (currently\n              this works reliably only with GNU libc).\n\n       CODESET\n              In most cases the special value guess can be used here in which case a suitable codeset will be guessed.  The codeset determines which symbols are supported by the font.  Valid\n              small codesets are: Armenian, CyrAsia, CyrKoi, CyrSlav, Georgian, Greek, Hebrew, Lao, Lat15, Lat2, Lat38, Lat7 and Thai.  Valid big codesets are: Arabic, Ethiopian, Uni1, Uni2,\n              Uni3 and Vietnamese.  Only small codesets can be used on FreeBSD.  See below the section entitled “CODESETS” for detailed description of each of these codesets.\n\n       FONTFACE and FONTSIZE\n              Valid font faces are: VGA (sizes 8x8, 8x14, 8x16, 16x28 and 16x32), Terminus (sizes 6x12, 8x14, 8x16, 10x20, 12x24, 14x28 and 16x32), TerminusBold  (sizes  8x14,  8x16,  10x20,\n              12x24,  14x28 and 16x32), TerminusBoldVGA (sizes 8x14 and 8x16), and Fixed (sizes 8x13, 8x14, 8x15, 8x16 and 8x18).  If however CODESET=Ethiopian, then the available font faces\n              are Goha and GohaClassic, each in sizes 8x12, 8x14 and 8x16.  DejaVu and DejaVuBold (sizes 30x16, 36x20, 43x24, 51x28, 59x32, 74x40, 89x48 and 118x64).\n\n              Set FONTFACE and FONTSIZE to empty strings if you want to configure only the keyboard and to leave the console font unchanged.\n\n       VIDEOMODE\n              Set VIDEOMODE to an empty string to avoid setting up the video mode.  On FreeBSD you can run\n\n                  vidcontrol -i mode\n\n              in order to see all possible video modes.  On Linux fbset(1) is used to configure the video mode but very often  this  doesn't  work  because  the  default  framebuffer  driver\n              (VesaFB) is rather limited and doesn't allow changes of the video mode.\n\n       FONT, FONT_MAP and CONSOLE_MAP\n              If  set,  specify  that  a  non  standard  font is to be used.  The value of the variable FONT consists of one or more space separated font file names.  On Linux, when the font\n              doesn't contain embedded Unicode map, an external map can be specified with the variable FONT_MAP.  The value of CONSOLE_MAP is a file that specifies a translation map from the\n              user's 8-bit encoding to Unicode (Linux only) or directly to font positions.\n\n       SCREEN_WIDTH and SCREEN_HEIGHT\n              If set, these variables specify a screen size that setupcon(1) will enforce with stty(1).  This can be useful with some braille devices that are only 40 cells wide.  The screen\n              size can not exceed what the current screen resolution can display according to the size of the loaded font.\n\n       BEEP   This variable controls the style of the system beep on the console.  When unset or when BEEP=default no changes to the system beep will be made.  Other possible values of  BEEP\n              are:  standard - set a standard beep; short - like the standard beep but somewhat shorter; shortest - even more short, suitable when your work generates lots of beeps; polite -\n              a very short beep with low frequency, suitable when there are other people in the room; attention - a very long beep, suitable when you want to warn yourself about an occurring\n              event; annoying - also a long beep, suitable when you want to warn somebody else about an occurring event; and off - disable the system beep on the console.\n\nCODESETS\n       There are two kinds of codesets - small (up to 256 symbols) and big (up to 512 symbols).  Only small codesets can be used on FreeBSD.  When the screen is in  text  mode  (i.e.  frame‐\n       buffer is not used) then fonts covering big codesets will reduce the number of available foreground colors.\n\n   Arabic (a big codeset)\n       Supported languages: Arabic, Kurdish in Iran, Pashto, Persian and Urdu.\n\n       Completely covered by the following font faces: Fixed (size 8x16) and VGA (sizes 8x16 and 16x32).\n\n   Armenian\n       Supported language: Armenian.\n\n       Completely covered by the following font faces: Fixed (all sizes).\n\n   CyrAsia\n       This  codeset supports some of the non-Slavic Cyrillic languages - Abkhazia, Avaric, Azerbaijani, Bashkir, Buryat, Chechen, Chuvash, Inupiaq (Eskimo), Kara-Kalpak, Kazakh, Kirgiz, Ko‐\n       mi, Kumyk, Kurdish, Lezghian, Mari (Cheremis), Mongolian, Ossetic, Selkup (Ostyak-Samoyed), Tajik, Tatar, Turkmen, Tuvinian, Uzbek and Yakut.\n\n       Completely supported by the following font faces: Fixed (all sizes).\n\n   CyrKoi\n       Supports entirely the 8-bit encodings KOI8-R and KOI8-U.  Suitable for Russian and Ukrainian when one of these two encodings is used.\n\n       Completely covered by the following font faces (in all sizes): Fixed, Terminus, TerminusBold, TerminusBoldVGA and VGA.\n\n   CyrSlav\n       Supports entirely the 8-bit encodings ISO-8859-5 and CP1251.  Suitable the Slavic Cyrillic languages - Belarusian, Bulgarian, Macedonian, Russian, Serbian and Ukrainian.  For  Serbian\n       both the Cyrillic and the Latin alphabets are supported.\n\n       Completely covered by the following font faces: Fixed (all sizes), Terminus (all sizes), TerminusBold (all sizes), TerminusBoldVGA (all sizes), VGA (sizes 8x16 and 16x32).\n\n   Ethiopian (a big codeset)\n       Supports Amharic, Ethiopic (Geez), Tigre and Tigrinya.\n\n       This codeset is partially covered by the following font faces: Fixed (sizes 8x15 and 8x18), Goha (all sizes) and GohaClassic (all sizes).\n\n   Georgian\n       Supported language: Georgian.\n\n       Completely covered by the following font faces: Fixed (all sizes).\n\n   Greek\n       Supported language: Greek.\n\n       Completely covered by the following font faces: Fixed (all sizes) and VGA (sizes 8x16 and 16x32).\n\n   Hebrew\n       Supported languages: Hebrew and Yiddish.\n\n       Completely covered by the following font faces: Fixed (sizes 8x13, 8x15, 8x16 and 8x18) and VGA (sizes 8x16 and 16x32).\n\n   Lao\n       Supported languages: Lao.\n\n       Completely covered by the following font faces: Fixed (sizes 8x15 and 8x16).\n\n   Lat15\n       Covers  entirely ISO-8859-1, ISO-8859-9 and ISO-8859-15.  Suitable for the so called Latin1 and Latin5 languages - Afar, Afrikaans, Albanian, Aragonese, Asturian, Aymara, Basque, Bis‐\n       lama, Breton, Catalan, Chamorro, Danish, Dutch, English, Estonian, Faroese, Fijian, Finnish, French, Frisian, Friulian, Galician, German, Hiri Motu, Icelandic, Ido, Indonesian, Inter‐\n       lingua, Interlingue, Italian, Low Saxon, Lule Sami, Luxembourgish, Malagasy, Manx Gaelic, Norwegian Bokmal, Norwegian Nynorsk, Occitan, Oromo or Galla, Portuguese, Rhaeto-Romance (Ro‐\n       mansch), Scots Gaelic, Somali, South Sami, Spanish, Swahili, Swedish, Tswana, Turkish, Volapuk, Votic, Walloon, Xhosa, Yapese and Zulu.\n\n       Completely covered by the following font faces: Fixed (all sizes), Terminus (all sizes), TerminusBold (all sizes), TerminusBoldVGA (all sizes), VGA (sizes 8x16 and 16x32).\n\n   Lat2\n       Covers entirely ISO-8859-2.  The Euro sign and the Romanian letters with comma below are also supported.  Suitable for the so called Latin2 languages - Bosnian, Croatian, Czech,  Hun‐\n       garian, Polish, Romanian, Slovak, Slovenian and Sorbian (lower and upper).\n\n       Completely covered by the following font faces: Fixed (all sizes), Terminus (all sizes), TerminusBold (all sizes), TerminusBoldVGA (all sizes), VGA (sizes 8x16 and 16x32).\n\n   Lat38\n       Covers entirely ISO-8859-3 and ISO-8859-14.  Suitable for Chichewa Esperanto, Irish, Maltese and Welsh.\n\n       Completely covered by the following font faces: Fixed (all sizes) and VGA (sizes 8x16 and 16x32).\n\n   Lat7\n       Covers entirely ISO-8859-13.  Suitable for Lithuanian, Latvian, Maori and Marshallese.\n\n       Completely covered by the following font faces: Fixed (all sizes), Terminus (all sizes), TerminusBold (all sizes), TerminusBoldVGA (all sizes), VGA (sizes 8x16 and 16x32).\n\n   Thai\n       Supported language: Thai.\n\n       Completely covered by the following font faces: Fixed (all sizes).\n\n   Uni1 (a big codeset)\n       Supports most of the Latin languages, the Slavic Cyrillic languages, Hebrew and barely Arabic.\n\n       Completely covered by the following font faces: Fixed (sizes 8x15 and 8x16) and VGA (all sizes).\n\n   Uni2 (a big codeset)\n       Supports most of the Latin languages, the Slavic Cyrillic languages and Greek.\n\n       Completely covered by the following font faces: Fixed (all sizes) and VGA (sizes 8x16 and 16x32).\n\n   Uni3 (a big codeset)\n       Supports most of the Latin and Cyrillic languages.\n\n       Completely covered by the following font faces: Fixed (all sizes).\n\n   Vietnamese (a big codeset)\n       Supported language: Vietnamese.\n\n       Completely covered by the following font faces: Fixed (sizes 8x13, 8x15, 8x16 and 8x18).\n\nFILES\n       The  standard location of the console-setup configuration file is /etc/default/console-setup.  The keyboard configuration is in /etc/default/keyboard.  Fonts that can be used with the\n       variable FONT are usually installed in /usr/share/consolefonts/ or /usr/share/syscons/fonts/.  Translation maps that can be used with the variable CONSOLE_MAP are usually installed in\n       /usr/share/consoletrans/ or /usr/share/syscons/scrnmaps/.\n\nNOTES\n       The aim of the Terminus font is to reduce the eyes-fatigue when one has to read a lot.  Currently this font supports only the Latin, the Cyrillic and the  Greek  scripts  (the  Lat15,\n       Lat2, Lat7, CyrAsia, CyrKoi, CyrSlav, Greek, Uni2 and Uni3 codesets).\n\n       The  fonts  with font face TerminusBoldVGA are optimized for use with regular text video modes.  They should not be used with framebuffer video modes.  The fonts with font face Termi‐\n       nusBold are optimized for use with the framebuffer video modes.  The fonts with font face Terminus can be used in all video modes.\n\nSEE ALSO\n       setupcon(1), keyboard(5), setfont(8), vidcontrol(1)\n\nconsole-setup                                                                             2011-03-17                                                                          CONSOLE-SETUP(5)","ref":"console-setup.html"},{"type":"extras","title":"containerd-config.toml","doc":"/etc/containerd/config.toml(5)                                                        File Formats Manual                                                       /etc/containerd/config.toml(5)\n\nNAME\n       containerd-config.toml - configuration file for containerd\n\nSYNOPSIS\n       The  config.toml  file is a configuration file for the containerd daemon. The file must be placed at /etc/containerd/config.toml or specified with the --config option of containerd to\n       be used by the daemon. If the file does not exist at the appropriate location or is not provided via the --config option containerd uses its default configuration settings, which  can\n       be displayed with the containerd config(1) command.\n\nDESCRIPTION\n       The  TOML  file used to configure the containerd daemon settings has a short list of global settings followed by a series of sections for specific areas of daemon configuration. There\n       is also a section for plugins that allows each containerd plugin to have an area for plugin-specific configuration and settings.\n\nFORMAT\n       version\n              The version field in the config file specifies the config’s version. If no version number is specified inside the config file then it is assumed to be a version  1  config  and\n              parsed as such. Please use version = 2 to enable version 2 config as version 1 has been deprecated.\n\n       root   The root directory for containerd metadata. (Default: \"/var/lib/containerd\")\n\n       state  The state directory for containerd (Default: \"/run/containerd\")\n\n       plugin_dir\n              The directory for dynamic plugins to be stored\n\n       [grpc] Section for gRPC socket listener settings. Contains the following properties:\n\n              • address (Default: \"/run/containerd/containerd.sock\")\n\n              • tcp_address\n\n              • tcp_tls_cert\n\n              • tcp_tls_key\n\n              • uid (Default: 0)\n\n              • gid (Default: 0)\n\n              • max_recv_message_size\n\n              • max_send_message_size\n\n       [ttrpc]\n              Section for TTRPC settings. Contains properties:\n\n              • address (Default: \"\")\n\n              • uid (Default: 0)\n\n              • gid (Default: 0)\n\n       [debug]\n              Section to enable and configure a debug socket listener. Contains four properties:\n\n              • address (Default: \"/run/containerd/debug.sock\")\n\n              • uid (Default: 0)\n\n              • gid (Default: 0)\n\n              • level (Default: \"info\") sets the debug log level. Supported levels are: \"trace\", \"debug\", \"info\", \"warn\", \"error\", \"fatal\", \"panic\"\n\n              • format (Default: \"text\") sets log format. Supported formats are \"text\" and \"json\"\n\n       [metrics]\n              Section to enable and configure a metrics listener. Contains two properties:\n\n              • address (Default: \"\") Metrics endpoint does not listen by default\n\n              • grpc_histogram (Default: false) Turn on or off gRPC histogram metrics\n\n       disabled_plugins\n              Disabled plugins are IDs of plugins to disable. Disabled plugins won't be initialized and started.\n\n       required_plugins\n              Required plugins are IDs of required plugins. Containerd exits if any required plugin doesn't exist or fails to be initialized or started.\n\n       [plugins]\n              The  plugins  section  contains configuration options exposed from installed plugins.  The following plugins are enabled by default and their settings are shown below.  Plugins\n              that are not enabled by default will provide their own configuration values documentation.\n\n              • [plugins.\"io.containerd.monitor.v1.cgroups\"] has one option no_prometheus (Default: false)\n\n              • [plugins.\"io.containerd.service.v1.diff-service\"] has one option default, a list by default set to [\"walking\"]\n\n              • [plugins.\"io.containerd.gc.v1.scheduler\"] has several options that perform advanced tuning for the scheduler:\n\n                • pause_threshold is the maximum amount of time GC should be scheduled (Default: 0.02),\n\n                • deletion_threshold guarantees GC is scheduled after n number of deletions (Default: 0 [not triggered]),\n\n                • mutation_threshold guarantees GC is scheduled after n number of database mutations (Default: 100),\n\n                • schedule_delay defines the delay after trigger event before scheduling a GC (Default \"0ms\" [immediate]),\n\n                • startup_delay defines the delay after startup before scheduling a GC (Default \"100ms\")\n\n              • [plugins.\"io.containerd.runtime.v2.task\"] specifies options for configuring the runtime shim:\n\n                • platforms specifies the list of supported platforms\n\n                • sched_core Core scheduling is a feature that allows only trusted tasks to run concurrently on cpus sharing compute resources (eg: hyperthreads on a core). (Default: false)\n\n              • [plugins.\"io.containerd.service.v1.tasks-service\"] has performance options:\n\n                • blockio_config_file (Linux only) specifies path to blockio class definitions (Default: \"\"). Controls I/O scheduler priority and bandwidth throttling.  See blockio  configu‐\n                  ration ⟨https://github.com/intel/goresctrl/blob/main/doc/blockio.md#configuration⟩ for details of the file format.\n\n                • rdt_config_file  (Linux  only)  specifies  path  to a configuration used for configuring RDT (Default: \"\"). Enables support for Intel RDT, a technology for cache and memory\n                  bandwidth management.  See RDT configuration ⟨https://github.com/intel/goresctrl/blob/main/doc/rdt.md#configuration⟩ for details of the file format.\n\n       oom_score\n              The out of memory (OOM) score applied to the containerd daemon process (Default: 0)\n\n       [cgroup]\n              Section for Linux cgroup specific settings\n\n              • path (Default: \"\") Specify a custom cgroup path for created containers\n\n       [proxy_plugins]\n              Proxy plugins configures plugins which are communicated to over gRPC\n\n              • type (Default: \"\")\n\n              • address (Default: \"\")\n\n       timeouts\n              Timeouts specified as a duration\n\n       imports\n              Imports is a list of additional configuration files to include.  This allows to split the main configuration file and keep some sections separately  (for  example  vendors  may\n              keep  a  custom runtime configuration in a separate file without modifying the main config.toml).  Imported files will overwrite simple fields like int or string (if not empty)\n              and will append array and map fields.  Imported files are also versioned, and the version can't be higher than the main config.\n\n       stream_processors\n\n              • accepts (Default: \"[]\") Accepts specific media-types\n\n              • returns (Default: \"\") Returns the media-type\n\n              • path (Default: \"\") Path or name of the binary\n\n              • args (Default: \"[]\") Args to the binary\n\nEXAMPLE\n       The following is a complete config.toml default configuration example:\n\n       version = 2\n\n       root = \"/var/lib/containerd\"\n       state = \"/run/containerd\"\n       oom_score = 0\n       imports = [\"/etc/containerd/runtime_*.toml\", \"./debug.toml\"]\n\n       [grpc]\n         address = \"/run/containerd/containerd.sock\"\n         uid = 0\n         gid = 0\n\n       [debug]\n         address = \"/run/containerd/debug.sock\"\n         uid = 0\n         gid = 0\n         level = \"info\"\n\n       [metrics]\n         address = \"\"\n         grpc_histogram = false\n\n       [cgroup]\n         path = \"\"\n\n       [plugins]\n         [plugins.\"io.containerd.monitor.v1.cgroups\"]\n           no_prometheus = false\n         [plugins.\"io.containerd.service.v1.diff-service\"]\n           default = [\"walking\"]\n         [plugins.\"io.containerd.gc.v1.scheduler\"]\n           pause_threshold = 0.02\n           deletion_threshold = 0\n           mutation_threshold = 100\n           schedule_delay = 0\n           startup_delay = \"100ms\"\n         [plugins.\"io.containerd.runtime.v2.task\"]\n           platforms = [\"linux/amd64\"]\n           sched_core = true\n         [plugins.\"io.containerd.service.v1.tasks-service\"]\n           blockio_config_file = \"\"\n           rdt_config_file = \"\"\n\nBUGS\n       Please file any specific issues that you encounter at https://github.com/containerd/containerd.\n\nAUTHOR\n       Phil Estes estesp@gmail.com ⟨mailto:estesp@gmail.com⟩\n\nSEE ALSO\n       ctr(8), containerd-config(8), containerd(8)\n\n                                                                                          04/05/2022                                                            /etc/containerd/config.toml(5)","ref":"containerd-config-toml.html"},{"type":"extras","title":"Containerfile","doc":"CONTAINERFILE(5)                                                                    Container User Manuals                                                                    CONTAINERFILE(5)\n\nNAME\n       Containerfile(Dockerfile) - automate the steps of creating a container image\n\nINTRODUCTION\n       The  Containerfile  is  a  configuration file that automates the steps of creating a container image. It is similar to a Makefile. Container engines (Podman, Buildah, Docker) read in‐\n       structions from the Containerfile to automate the steps otherwise performed manually to create an image. To build an image, create a file called Containerfile.\n\n       The Containerfile describes the steps taken to assemble the image. When the Containerfile has been created, call the buildah build, podman build, docker build command, using the  path\n       of  context directory that contains Containerfile as the argument. Podman and Buildah default to Containerfile and will fall back to Dockerfile. Docker only will search for Dockerfile\n       in the context directory.\n\n       Dockerfile is an alternate name for the same object.  Containerfile and Dockerfile support the same syntax.\n\nSYNOPSIS\n       INSTRUCTION arguments\n\n       For example:\n\n       FROM image\n\nDESCRIPTION\n       A Containerfile is a file that automates the steps of creating a container image.  A Containerfile is similar to a Makefile.\n\nUSAGE\n         buildah build .\n         podman build .\n\n       -- Runs the steps and commits them, building a final image.\n         The path to the source repository defines where to find the context of the\n         build.\n\n         buildah build -t repository/tag .\n         podman build -t repository/tag .\n\n       -- specifies a repository and tag at which to save the new image if the build\n         succeeds. The container engine runs the steps one-by-one, committing the result\n         to a new image if necessary, before finally outputting the ID of the new\n         image.\n\n       Container engines reuse intermediate images whenever possible. This significantly\n         accelerates the build process.\n\nFORMAT\n       FROM image [AS  ]\n\n       FROM image:tag [AS  ]\n\n       FROM image@digest [AS  ]\n\n       -- The FROM instruction sets the base image for subsequent instructions. A\n         valid Containerfile must have either ARG or FROM as its first instruction.\n         If FROM is not the first instruction in the file, it may only be preceded by\n         one or more ARG instructions, which declare arguments that are used in the next FROM line in the Containerfile.\n         The image can be any valid image. It is easy to start by pulling an image from the public\n         repositories.\n\n       -- FROM must appear at least once in the Containerfile.\n\n       -- FROM The first FROM command must come before all other instructions in\n         the Containerfile except ARG\n\n       -- FROM may appear multiple times within a single Containerfile in order to create\n         multiple images. Make a note of the last image ID output by the commit before\n         each new FROM command.\n\n       -- If no tag is given to the FROM instruction, container engines apply the\n         latest tag. If the used tag does not exist, an error is returned.\n\n       -- If no digest is given to the FROM instruction, container engines apply the\n         latest tag. If the used tag does not exist, an error is returned.\n\n       -- A name can be assigned to a build stage by adding AS name to the instruction.\n         The name can be referenced later in the Containerfile using the FROM or COPY --from= instructions.\n\n       MAINTAINER\n         -- MAINTAINER sets the Author field for the generated images.\n         Useful for providing users with an email or url for support.\n\n       RUN\n         -- RUN has two forms:\n\n         # the command is run in a shell - /bin/sh -c\n         RUN  \n\n         # Executable form\n         RUN [\"executable\", \"param1\", \"param2\"]\n\n       RUN mounts\n\n       --mount=type=TYPE,TYPE-SPECIFIC-OPTION[,...]\n\n       Attach a filesystem mount to the container\n\n       Current supported mount TYPES are bind, cache, secret and tmpfs.\n\n          e.g.\n\n          mount=type=bind,source=/path/on/host,destination=/path/in/container,relabel=shared\n\n          mount=type=tmpfs,tmpfs-size=512M,destination=/path/in/container\n\n          mount=type=secret,id=mysecret cat /run/secrets/mysecret\n\n          Common Options:\n\n             · src, source: mount source spec for bind and volume. Mandatory for bind. If `from` is specified, `src` is the subpath in the `from` field.\n\n             · dst, destination, target: mount destination spec.\n\n             · ro, read-only: true (default) or false.\n\n          Options specific to bind:\n\n             · bind-propagation: shared, slave, private, rshared, rslave, or rprivate(default). See also mount(2).\n\n             . bind-nonrecursive: do not setup a recursive bind mount.  By default it is recursive.\n\n             · from: stage or image name for the root of the source. Defaults to the build context.\n\n             · relabel=shared, z: Relabels src content with a shared label.\n\n             . relabel=private, Z: Relabels src content with a private label.\n\n             Labeling systems like SELinux require proper labels on the bind mounted content mounted into a container. Without a label, the security system might prevent the processes running in side the container from using the content. By default, container engines do not change the labels set by the OS. The relabel flag tells the engine to relabel file objects on the shared mountz.\n\n             The relabel=shared and z options tell the engine that two or more containers will share the mount content. The engine labels the content with a shared content label.\n\n             The relabel=private and Z options tell the engine to label the content with a private unshared label. Only the current container can use a private mount.\n\n             Relabeling walks the file system under the mount and changes the label on each file, if the mount has thousands of inodes, this process takes a long time, delaying the start of the container.\n\n             · rw, read-write: allows writes on the mount.\n\n          Options specific to tmpfs:\n\n             · tmpfs-size: Size of the tmpfs mount in bytes. Unlimited by default in Linux.\n\n             · tmpfs-mode: File mode of the tmpfs in octal. (e.g. 700 or 0700.) Defaults to 1777 in Linux.\n\n             · tmpcopyup: Path that is shadowed by the tmpfs mount is recursively copied up to the tmpfs itself.\n\n       Options specific to cache:\n\n             · id: Create a separate cache directory for a particular id.\n\n             · mode: File mode for new cache directory in octal. Default 0755.\n\n             · ro, readonly: read only cache if set.\n\n             · uid: uid for cache directory.\n\n             · gid: gid for cache directory.\n\n             · from: stage name for the root of the source. Defaults to host cache directory.\n\n             · rw, read-write: allows writes on the mount.\n\n       RUN --network\n\n       RUN --network allows control over which networking environment the command is run in.\n\n       Syntax: --network= \n\n       Network types\n\n       ┌───────────────────────────────────┬────────────────────────────────────────┐\n       │ Type                              │ Description                            │\n       ├───────────────────────────────────┼────────────────────────────────────────┤\n       │                                   │                                        │\n       ├───────────────────────────────────┼────────────────────────────────────────┤\n       │ ⟨#run---networkdefault⟩ (default) │ Run in the default network.            │\n       ├───────────────────────────────────┼────────────────────────────────────────┤\n       │                                   │                                        │\n       ├───────────────────────────────────┼────────────────────────────────────────┤\n       │ ⟨#run---networknone⟩              │ Run with no network access.            │\n       ├───────────────────────────────────┼────────────────────────────────────────┤\n       │                                   │                                        │\n       ├───────────────────────────────────┼────────────────────────────────────────┤\n       │ ⟨#run---networkhost⟩              │ Run in the host's network environment. │\n       └───────────────────────────────────┴────────────────────────────────────────┘\n\n   RUN --network=default\n       Equivalent to not supplying a flag at all, the command is run in the default network for the build.\n\n   RUN --network=none\n       The command is run with no network access (lo is still available, but is isolated to this process).\n\n   Example: isolating external effects\n       FROM python:3.6\n       ADD mypackage.tgz wheels/\n       RUN --network=none pip install --find-links wheels mypackage\n\n       pip will only be able to install the packages provided in the tarfile, which can be controlled by an earlier build stage.\n\n   RUN --network=host\n       The command is run in the host's network environment (similar to buildah build --network=host, but on a per-instruction basis)\n\n       RUN Secrets\n\n       The RUN command has a feature to allow the passing of secret information into the image build. These secrets files can be used during the RUN command but are not committed to the  fi‐\n       nal image. The RUN command supports the --mount option to identify the secret file. A secret file from the host is mounted into the container while the image is being built.\n\n       Container engines pass secret the secret file into the build using the --secret flag.\n\n       --mount=type=secret,TYPE-SPECIFIC-OPTION[,...]\n\n              • id  is  the identifier for the secret passed into the buildah build --secret or podman build --secret. This identifier is associated with the RUN --mount identifier to use in\n                the Containerfile.\n\n              • dst|target|destination rename the secret file to a specific file in the Containerfile RUN command to use.\n\n              • type=secret tells the --mount command that it is mounting in a secret file\n                # shows secret from default secret location:\n                RUN --mount=type=secret,id=mysecret cat /run/secrets/mysecret\n\n                # shows secret from custom secret location:\n                RUN --mount=type=secret,id=mysecret,dst=/foobar cat /foobar\n\n       The secret needs to be passed to the build using the --secret flag. The final image built does not container the secret file:\n\n        buildah build --no-cache --secret id=mysecret,src=mysecret.txt .\n\n       -- The RUN instruction executes any commands in a new layer on top of the current\n         image and commits the results. The committed image is used for the next step in\n         Containerfile.\n\n       -- Layering RUN instructions and generating commits conforms to the core\n         concepts of container engines where commits are cheap and containers can be created from\n         any point in the history of an image. This is similar to source control.  The\n         exec form makes it possible to avoid shell string munging. The exec form makes\n         it possible to RUN commands using a base image that does not contain /bin/sh.\n\n       Note that the exec form is parsed as a JSON array, which means that you must\n         use double-quotes (\") around words, not single-quotes (').\n\n       CMD\n         -- CMD has three forms:\n\n         # Executable form\n         CMD [\"executable\", \"param1\", \"param2\"]`\n\n         # Provide default arguments to ENTRYPOINT\n         CMD [\"param1\", \"param2\"]`\n\n         # the command is run in a shell - /bin/sh -c\n         CMD command param1 param2\n\n       -- There should be only one CMD in a Containerfile. If more than one CMD is listed, only\n         the last CMD takes effect.\n         The main purpose of a CMD is to provide defaults for an executing container.\n         These defaults may include an executable, or they can omit the executable. If\n         they omit the executable, an ENTRYPOINT must be specified.\n         When used in the shell or exec formats, the CMD instruction sets the command to\n         be executed when running the image.\n         If you use the shell form of the CMD, the   executes in /bin/sh -c:\n\n       Note that the exec form is parsed as a JSON array, which means that you must\n         use double-quotes (\") around words, not single-quotes (').\n\n         FROM ubuntu\n         CMD echo \"This is a test.\" | wc -\n\n       -- If you run command without a shell, then you must express the command as a\n         JSON array and give the full path to the executable. This array form is the\n         preferred form of CMD. All additional parameters must be individually expressed\n         as strings in the array:\n\n         FROM ubuntu\n         CMD [\"/usr/bin/wc\",\"--help\"]\n\n       -- To make the container run the same executable every time, use ENTRYPOINT in\n         combination with CMD.\n         If the user specifies arguments to podman run or docker run, the specified commands\n         override the default in CMD.\n         Do not confuse RUN with CMD. RUN runs a command and commits the result.\n         CMD executes nothing at build time, but specifies the intended command for\n         the image.\n\n       LABEL\n         -- LABEL  =  [ =  ...]or\n\n         LABEL  [  ]\n         LABEL  [  ]\n         ...\n\n       The LABEL instruction adds metadata to an image. A LABEL is a\n         key-value pair. To specify a LABEL without a value, simply use an empty\n         string. To include spaces within a LABEL value, use quotes and\n         backslashes as you would in command-line parsing.\n\n         LABEL com.example.vendor=\"ACME Incorporated\"\n         LABEL com.example.vendor \"ACME Incorporated\"\n         LABEL com.example.vendor.is-beta \"\"\n         LABEL com.example.vendor.is-beta=\n         LABEL com.example.vendor.is-beta=\"\"\n\n       An image can have more than one label. To specify multiple labels, separate\n         each key-value pair by a space.\n\n       Labels are additive including LABELs in FROM images. As the system\n         encounters and then applies a new label, new keys override any previous\n         labels with identical keys.\n\n       To display an image's labels, use the buildah inspect command.\n\n       EXPOSE\n         -- EXPOSE   [ ...]\n         The EXPOSE instruction informs the container engine that the container listens on the\n         specified network ports at runtime. The container engine uses this information to\n         interconnect containers using links and to set up port redirection on the host\n         system.\n\n       ENV\n         -- ENV    \n         The ENV instruction sets the environment variable  to\n         the value  . This value is passed to all future\n         RUN, ENTRYPOINT, and CMD instructions. This is\n         functionally equivalent to prefixing the command with  = .  The\n         environment variables that are set with ENV persist when a container is run\n         from the resulting image. Use podman inspect to inspect these values, and\n         change them using podman run --env  = .\n\n       Note that setting \"ENV DEBIAN_FRONTEND=noninteractive\" may cause\n         unintended consequences, because it will persist when the container is run\n         interactively, as with the following command: podman run -t -i image bash\n\n       ADD\n         -- ADD has two forms:\n\n         ADD    \n\n         # Required for paths with whitespace\n         ADD [\" \",... \" \"]\n\n       The ADD instruction copies new files, directories\n         or remote file URLs to the filesystem of the container at path  .\n         Multiple   resources may be specified but if they are files or directories\n         then they must be relative to the source directory that is being built\n         (the context of the build). The   is the absolute path, or path relative\n         to WORKDIR, into which the source is copied inside the target container.\n         If the   argument is a local file in a recognized compression format\n         (tar, gzip, bzip2, etc) then it is unpacked at the specified   in the\n         container's filesystem.  Note that only local compressed files will be unpacked,\n         i.e., the URL download and archive unpacking features cannot be used together.\n         All new directories are created with mode 0755 and with the uid and gid of 0.\n\n       COPY\n         -- COPY has two forms:\n\n         COPY [--chown= : ] [--chmod= ]    \n\n         # Required for paths with whitespace\n         COPY [--chown= : ] [--chmod= ] [\" \",... \" \"]\n\n       The COPY instruction copies new files from   and\n         adds them to the filesystem of the container at path . The   must be\n         the path to a file or directory relative to the source directory that is\n         being built (the context of the build) or a remote file URL. The   is an\n         absolute path, or a path relative to WORKDIR, into which the source will\n         be copied inside the target container. If you COPY an archive file it will\n         land in the container exactly as it appears in the build context without any\n         attempt to unpack it.  All new files and directories are created with mode 0755\n         and with the uid and gid of 0.\n\n       --chown= :  changes the ownership of new files and directories.\n         Supports names, if defined in the containers /etc/passwd and /etc/groups files, or using\n         uid and gid integers. The build will fail if a user or group name can't be mapped in the container.\n         Numeric id's are set without looking them up in the container.\n\n       --chmod=  changes the mode of new files and directories.\n\n       The optional flag --from=name can be used to copy files from a named previous build stage. It\n         changes the context of   from the build context to the named build stage.\n\n       ENTRYPOINT\n         -- ENTRYPOINT has two forms:\n\n         # executable form\n         ENTRYPOINT [\"executable\", \"param1\", \"param2\"]`\n\n         # run command in a shell - /bin/sh -c\n         ENTRYPOINT command param1 param2\n\n       -- An ENTRYPOINT helps you configure a\n         container that can be run as an executable. When you specify an ENTRYPOINT,\n         the whole container runs as if it was only that executable.  The ENTRYPOINT\n         instruction adds an entry command that is not overwritten when arguments are\n         passed to podman run. This is different from the behavior of CMD. This allows\n         arguments to be passed to the entrypoint, for instance podman run   -d\n         passes the -d argument to the ENTRYPOINT.  Specify parameters either in the\n         ENTRYPOINT JSON array (as in the preferred exec form above), or by using a CMD\n         statement.  Parameters in the ENTRYPOINT are not overwritten by the podman run arguments.  Parameters specified via CMD are overwritten by podman run  arguments.   Specify  a  plain\n       string for the ENTRYPOINT, and it will execute in\n         /bin/sh -c, like a CMD instruction:\n\n         FROM ubuntu\n         ENTRYPOINT wc -l -\n\n       This means that the Containerfile's image always takes stdin as input (that's\n         what \"-\" means), and prints the number of lines (that's what \"-l\" means). To\n         make this optional but default, use a CMD:\n\n         FROM ubuntu\n         CMD [\"-l\", \"-\"]\n         ENTRYPOINT [\"/usr/bin/wc\"]\n\n       VOLUME\n         -- VOLUME [\"/data\"]\n         The VOLUME instruction creates a mount point with the specified name and marks\n         it as holding externally-mounted volumes from the native host or from other\n         containers.\n\n       USER\n         -- USER daemon\n         Sets the username or UID used for running subsequent commands.\n\n       The USER instruction can optionally be used to set the group or GID. The\n         following examples are all valid:\n         USER [user | user:group | uid | uid:gid | user:gid | uid:group ]\n\n       Until the USER instruction is set, instructions will be run as root. The USER\n         instruction can be used any number of times in a Containerfile, and will only affect\n         subsequent commands.\n\n       WORKDIR\n         -- WORKDIR /path/to/workdir\n         The WORKDIR instruction sets the working directory for the RUN, CMD,\n         ENTRYPOINT, COPY and ADD Containerfile commands that follow it. It can\n         be used multiple times in a single Containerfile. Relative paths are defined\n         relative to the path of the previous WORKDIR instruction. For example:\n\n         WORKDIR /a\n         WORKDIR b\n         WORKDIR c\n         RUN pwd\n\n       In the above example, the output of the pwd command is a/b/c.\n\n       ARG\n          -- ARG  [= ]\n\n       The ARG instruction defines a variable that users can pass at build-time to\n         the builder with the podman build and buildah build commands using the\n         --build-arg  =  flag. If a user specifies a build argument that\n         was not defined in the Containerfile, the build outputs a warning.\n\n       Note that a second FROM in a Containerfile sets the values associated with an\n         Arg variable to nil and they must be reset if they are to be used later in\n         the Containerfile\n\n         [Warning] One or more build-args [foo] were not consumed\n\n       The Containerfile author can define a single variable by specifying ARG once or many\n         variables by specifying ARG more than once. For example, a valid Containerfile:\n\n         FROM busybox\n         ARG user1\n         ARG buildno\n         ...\n\n       A Containerfile author may optionally specify a default value for an ARG instruction:\n\n         FROM busybox\n         ARG user1=someuser\n         ARG buildno=1\n         ...\n\n       If an ARG value has a default and if there is no value passed at build-time, the\n         builder uses the default.\n\n       An ARG variable definition comes into effect from the line on which it is\n         defined in the Containerfile not from the argument's use on the command-line or\n         elsewhere.  For example, consider this Containerfile:\n\n         1 FROM busybox\n         2 USER ${user:-some_user}\n         3 ARG user\n         4 USER $user\n         ...\n\n       A user builds this file by calling:\n\n         $ podman build --build-arg user=what_user Containerfile\n\n       The USER at line 2 evaluates to some_user as the user variable is defined on the\n         subsequent line 3. The USER at line 4 evaluates to what_user as user is\n         defined and the what_user value was passed on the command line. Prior to its definition by an\n         ARG instruction, any use of a variable results in an empty string.\n\n              Warning: It is not recommended to use build-time variables for\n               passing secrets like github keys, user credentials etc. Build-time variable\n               values are visible to any user of the image with the podman history command.\n\n       You can use an ARG or an ENV instruction to specify variables that are\n         available to the RUN instruction. Environment variables defined using the\n         ENV instruction always override an ARG instruction of the same name. Consider\n         this Containerfile with an ENV and ARG instruction.\n\n         1 FROM ubuntu\n         2 ARG CONT_IMG_VER\n         3 ENV CONT_IMG_VER=v1.0.0\n         4 RUN echo $CONT_IMG_VER\n\n       Then, assume this image is built with this command:\n\n         $ podman build --build-arg CONT_IMG_VER=v2.0.1 Containerfile\n\n       In this case, the RUN instruction uses v1.0.0 instead of the ARG setting\n         passed by the user:v2.0.1 This behavior is similar to a shell\n         script where a locally scoped variable overrides the variables passed as\n         arguments or inherited from environment, from its point of definition.\n\n       Using the example above but a different ENV specification you can create more\n         useful interactions between ARG and ENV instructions:\n\n         1 FROM ubuntu\n         2 ARG CONT_IMG_VER\n         3 ENV CONT_IMG_VER=${CONT_IMG_VER:-v1.0.0}\n         4 RUN echo $CONT_IMG_VER\n\n       Unlike an ARG instruction, ENV values are always persisted in the built\n         image. Consider a podman build without the --build-arg flag:\n\n         $ podman build Containerfile\n\n       Using this Containerfile example, CONT_IMG_VER is still persisted in the image but\n         its value would be v1.0.0 as it is the default set in line 3 by the ENV instruction.\n\n       The variable expansion technique in this example allows you to pass arguments\n         from the command line and persist them in the final image by leveraging the\n         ENV instruction. Variable expansion is only supported for a limited set of\n         Containerfile instructions.  ⟨#environment-replacement⟩\n\n       Container engines have a set of predefined ARG variables that you can use without a\n         corresponding ARG instruction in the Containerfile.\n\n              • HTTP_PROXY\n\n              • http_proxy\n\n              • HTTPS_PROXY\n\n              • https_proxy\n\n              • FTP_PROXY\n\n              • ftp_proxy\n\n              • NO_PROXY\n\n              • no_proxy\n\n              • ALL_PROXY\n\n              • all_proxy\n\n       To use these, pass them on the command line using --build-arg flag, for\n         example:\n\n         $ podman build --build-arg HTTPS_PROXY=https://my-proxy.example.com .\n\n       Platform/OS/Arch ARG\n          -- ARG  \n\n       When building multi-arch manifest-lists or images for a foreign-architecture,\n         it's often helpful to have access to platform details within the Containerfile.\n         For example, when using a RUN curl ... command to install OS/Arch specific\n         binary into the image.  Or, if certain RUN operations are known incompatible\n         or non-performant when emulating a specific architecture.\n\n       There are several named ARG variables available. The purpose of each should be\n         self-evident by its name.  However, in all cases these ARG values are not\n         automatically populated.  You must always declare them within each FROM section\n         of the Containerfile.\n\n       The available ARG   variables are available with two prefixes:\n\n              • TARGET... variable names represent details about the currently running build context (i.e. \"inside\" the container).  These are often the most useful:\n\n                • TARGETOS: For example linux\n\n                • TARGETARCH: For example amd64\n\n                • TARGETPLATFORM: For example linux/amd64\n\n                • TARGETVARIANT: Uncommonly used, specific to TARGETARCH\n\n              • BUILD... variable names signify details about the host performing the build (i.e. \"outside\" the container):\n\n                • BUILDOS: OS of host performing the build\n\n                • BUILDARCH: Arch of host performing the build\n\n                • BUILDPLATFORM: Combined OS/Arch of host performing the build\n\n                • BUILDVARIANT: Uncommonly used, specific to BUILDARCH\n\n       An example Containerfile that uses TARGETARCH to fetch an arch-specific binary could be:\n\n         FROM busybox\n         ARG TARGETARCH\n         RUN curl -sSf -O https://example.com/downloads/bin-${TARGETARCH}.zip\n\n       Assuming the host platform is linux/amd64 and foreign-architecture emulation\n         enabled (e.g. qemu-user-static), then running the command:\n\n         $ podman build --platform linux/s390x .\n\n       Would end up running curl on https://example.com/downloads/bin-s390x.zip and producing\n         a container image suited for the the linux/s390x platform.  Note: Emulation isn't\n         strictly required, these special build-args will also function when building using\n         podman farm build.\n\n       ONBUILD\n         -- ONBUILD [INSTRUCTION]\n         The ONBUILD instruction adds a trigger instruction to an image. The\n         trigger is executed at a later time, when the image is used as the base for\n         another build. Container engines execute the trigger in the context of the downstream\n         build, as if the trigger existed immediately after the FROM instruction in\n         the downstream Containerfile.\n\n       You can register any build instruction as a trigger. A trigger is useful if\n         you are defining an image to use as a base for building other images. For\n         example, if you are defining an application build environment or a daemon that\n         is customized with a user-specific configuration.\n\n       Consider an image intended as a reusable python application builder. It must\n         add application source code to a particular directory, and might need a build\n         script called after that. You can't just call ADD and RUN now, because\n         you don't yet have access to the application source code, and it is different\n         for each application build.\n\n       -- Providing application developers with a boilerplate Containerfile to copy-paste\n         into their application is inefficient, error-prone, and\n         difficult to update because it mixes with application-specific code.\n         The solution is to use ONBUILD to register instructions in advance, to\n         run later, during the next build stage.\n\nSEE ALSO\n       buildah(1), podman(1), docker(1)\n\nHISTORY\n       May 2014, Compiled by Zac Dover (zdover at redhat dot com) based on docker.com Dockerfile documentation.\n       Feb 2015, updated by Brian Goff (cpuguy83@gmail.com) for readability\n       Sept 2015, updated by Sally O'Malley (somalley@redhat.com)\n       Oct 2016, updated by Addam Hardy (addam.hardy@gmail.com)\n       Aug 2021, converted Dockerfile man page to Containerfile by Dan Walsh (dwalsh@redhat.com)\n\n                                                                                           Aug 2021                                                                           CONTAINERFILE(5)","ref":"containerfile.html"},{"type":"extras","title":"containerignore","doc":".containerignore(28)                                                                Container User Manuals                                                                .containerignore(28)\n\nNAME\n       .containerignore(.dockerignore) - files to ignore buildah or podman build context directory\n\nINTRODUCTION\n       Before  container engines build an image, they look for a file named .containerignore or .dockerignore in the root context directory. If one of these file exists, the CLI modifies the\n       context to exclude files and directories that match patterns specified in the file. This avoids adding them to images using the ADD or COPY instruction.\n\n       The CLI interprets the .containerignore or .dockerignore file as a newline-separated list of patterns similar to the file globs of Unix shells. For the purposes of matching, the  root\n       of the context is considered to be both the working and the root directory. For example, the patterns /foo/bar and foo/bar both exclude a file or directory named bar in the foo subdi‐\n       rectory of PATH or in the root of the git repository located at URL. Neither excludes anything else.\n\n       If a line in .containerignore or .dockerignore file starts with # in column 1, then this line is considered as a comment and is ignored before interpreted by the CLI.\n\nEXAMPLES\n       Here is an example .containerignore file:\n\n       # comment\n       */temp*\n       */*/temp*\n       temp?\n\n       This file causes the following build behavior: Rule      Behavior\n\n       # comment      Ignored.\n       */temp*   Exclude files and directories whose names start with temp in any immediate subdirectory of the root.\n       For example, the plain file /somedir/temporary.txt is excluded, as is the directory /somedir/temp.\n       */*/temp*      Exclude files and directories starting with temp from any subdirectory that is two levels below the\n       root. For example, /somedir/subdir/temporary.txt is excluded.\n       temp?     Exclude files and directories in the root directory whose names are a one-character extension of temp. For example, /tempa and /tempb are excluded.\n\n       Matching  is  done using Go’s filepath.Match rules. A preprocessing step removes leading and trailing whitespace and eliminates . and .. elements using Go’s filepath.Clean. Lines that\n       are blank after preprocessing are ignored.\n\n       Beyond Go’s filepath.Match rules, Docker also supports a special wildcard string ** that matches any number of directories (including zero). For example, */.go will exclude all  files\n       that end with .go that are found in all directories, including the root of the build context.\n\n       Lines starting with ! (exclamation mark) can be used to make exceptions to exclusions. The following is an example .containerignore file that uses this mechanism:\n\n       *.md\n       !README.md\n\n       All markdown files except README.md are excluded from the context.\n\n       The  placement  of  ! exception rules influences the behavior: the last line of the .containerignore that matches a particular file determines whether it is included or excluded. Con‐\n       sider the following example:\n\n       *.md\n       !README*.md\n       README-secret.md\n\n       No markdown files are included in the context except README files other than README-secret.md.\n\n       Now consider this example:\n\n       *.md\n       README-secret.md\n       !README*.md\n\n       All of the README files are included. The middle line has no effect because !README*.md matches README-secret.md and comes last.\n\n       You can even use the .containerignore file to exclude the Containerfile or Dockerfile and .containerignore files.  These files are still sent to the daemon because it needs them to do\n       its job. But the ADD and COPY instructions do not copy them to the image.\n\n       Finally, you may want to specify which files to include in the context, rather than which to exclude. To achieve this, specify * as the first pattern, followed by one or more ! excep‐\n       tion patterns.\n\nSEE ALSO\n       buildah-build(1), podman-build(1), docker-build(1)\n\nHISTORY\n       *Sep 2021, Compiled by Dan Walsh (dwalsh at redhat dot com) based on docker.com .dockerignore documentation.\n\n                                                                                           Sep 2021                                                                       .containerignore(28)","ref":"containerignore.html"},{"type":"extras","title":"containers-auth.json","doc":"containers-auth.json(5)                                                               File Formats Manual                                                              containers-auth.json(5)\n\nNAME\n       containers-auth.json - syntax for the registry authentication file\n\nDESCRIPTION\n       A  file  in JSON format controlling authentication against container image registries.  The primary (read/write) file is stored at ${XDG_RUNTIME_DIR}/containers/auth.json on Linux; on\n       Windows and macOS, at $HOME/.config/containers/auth.json.\n\n       When searching for the credential for a registry, the following files will be read in sequence until the valid credential is found: first reading the primary (read/write) file, or the\n       explicit override using an option of the calling application.  If credentials are not present there, the search continues in ${XDG_CONFIG_HOME}/containers/auth.json  (usually  ~/.con‐\n       fig/containers/auth.json), $HOME/.docker/config.json, $HOME/.dockercfg.\n\n       Except for the primary (read/write) file, other files are read-only unless the user, using an option of the calling application, explicitly points at it as an override.\n\nFORMAT\n       The  auth.json  file stores, or references, credentials that allow the user to authenticate to container image registries.  It is primarily managed by a login command from a container\n       tool such as podman login, buildah login, or skopeo login.\n\n       Each entry contains a single hostname (e.g., docker.io) or a namespace (e.g., quay.io/user/image) as a key, and credentials in the form of a base64-encoded string as  value  of  auth.\n       The base64-encoded string contains a concatenation of the username, a colon, and the password.\n\n       When checking for available credentials, the relevant repository is matched against available keys in its hierarchical order, going from most-specific to least-specific.  For example,\n       an image pull for my-registry.local/namespace/user/image:latest will result in a lookup in auth.json in the following order:\n\n              • my-registry.local/namespace/user/image\n\n              • my-registry.local/namespace/user\n\n              • my-registry.local/namespace\n\n              • my-registry.local\n\n       This way it is possible to setup multiple credentials for a single registry which can be distinguished by their path.\n\n       The following example shows the values found in auth.json after the user logged in to their accounts on quay.io and docker.io:\n\n       {\n            \"auths\": {\n                 \"docker.io\": {\n                      \"auth\": \"erfi7sYi89234xJUqaqxgmzcnQ2rRFWM5aJX0EC=\"\n                 },\n                 \"quay.io\": {\n                      \"auth\": \"juQAqGmz5eR1ipzx8Evn6KGdw8fEa1w5MWczmgY=\"\n                 }\n            }\n       }\n\n       This example demonstrates how to use multiple paths for a single registry, while preserving a fallback for my-registry.local:\n\n       {\n            \"auths\": {\n                 \"my-registry.local/foo/bar/image\": {\n                      \"auth\": \"…\"\n                 },\n                 \"my-registry.local/foo\": {\n                      \"auth\": \"…\"\n                 },\n                 \"my-registry.local\": {\n                      \"auth\": \"…\"\n                 },\n            }\n       }\n\n       An entry can be removed by using a logout command from a container tool such as podman logout or buildah logout.\n\n       In  addition,  credential  helpers can be configured for specific registries, and the credentials-helper software can be used to manage the credentials more securely than storing only\n       base64-encoded credentials in auth.json.\n\n       When the credential helper is in use on a Linux platform, the auth.json file would contain keys that specify the registry domain, and values that specify the suffix of the program  to\n       use (i.e. everything after docker-credential-).  For example:\n\n       {\n           \"auths\": {\n               \"localhost:5001\": {}\n           },\n           \"credHelpers\": {\n                 \"registry.example.com\": \"secretservice\"\n            }\n       }\n\n       For more information on credential helpers, please reference the GitHub docker-credential-helpers project ⟨https://github.com/docker/docker-credential-helpers/releases⟩.\n\nSEE ALSO\n       buildah-login(1), buildah-logout(1), podman-login(1), podman-logout(1), skopeo-login(1), skopeo-logout(1)\n\nHISTORY\n       Feb 2020, Originally compiled by Tom Sweeney tsweeney@redhat.com ⟨mailto:tsweeney@redhat.com⟩\n\n                                                                                                                                                                       containers-auth.json(5)","ref":"containers-auth-json.html"},{"type":"extras","title":"containers-certs.d","doc":"containers-certs.d(5)                                                                       storing                                                                      containers-certs.d(5)\n\nNAME\n       containers-certs.d - Directory for storing custom container-registry TLS configurations\n\nDESCRIPTION\n       A  custom  TLS configuration for a container registry can be configured by creating a directory under $HOME/.config/containers/certs.d or /etc/containers/certs.d.  The name of the di‐\n       rectory must correspond to the host:port of the registry (e.g., my-registry.com:5000).\n\nDirectory Structure\n       A certs directory can contain one or more files with the following extensions:\n\n              • *.crt  files with this extensions will be interpreted as CA certificates\n\n              • *.cert files with this extensions will be interpreted as client certificates\n\n              • *.key  files with this extensions will be interpreted as client keys\n\n       Note that the client certificate-key pair will be selected by the file name (e.g., client.{cert,key}).  An exemplary setup for a registry running at my-registry.com:5000 may  look  as\n       follows:\n\n       /etc/containers/certs.d/    <- Certificate directory\n       └── my-registry.com:5000    <- Hostname:port\n          ├── client.cert          <- Client certificate\n          ├── client.key           <- Client key\n          └── ca.crt               <- Certificate authority that signed the registry certificate\n\nHISTORY\n       Feb 2019, Originally compiled by Valentin Rothberg rothberg@redhat.com ⟨mailto:rothberg@redhat.com⟩\n\nfor                                                                                        Directory                                                                     containers-certs.d(5)","ref":"containers-certs-d.html"},{"type":"extras","title":"containers.conf","doc":"containers.conf(5)                                                                       configuration                                                                      containers.conf(5)\n\nNAME\n       containers.conf - The container engine configuration file specifies default configuration options and command-line flags for container engines.\n\nDESCRIPTION\n       Container engines like Podman & Buildah read containers.conf file, if it exists and modify the defaults for running containers on the host. containers.conf uses a TOML format that can\n       be easily modified and versioned.\n\n       Container  engines  read the /usr/share/containers/containers.conf, /etc/containers/containers.conf, and /etc/containers/containers.conf.d/*.conf for global configuration that effects\n       all users.  For user specific configuration it reads  \\$XDG_CONFIG_HOME/containers/containers.conf  and  \\$XDG_CONFIG_HOME/containers/containers.conf.d/*.conf  files.  When  $XDG_CON‐\n       FIG_HOME is not set it falls back to using $HOME/.config instead.\n\n       Fields specified in containers conf override the default options, as well as options in previously read containers.conf files.\n\n       Config files in the .d directories, are added in alpha numeric sorted order and must end in .conf.\n\n       Not all options are supported in all container engines.\n\n       Note, container engines also use other configuration files for configuring the environment.\n\n              • storage.conf for configuration of container and images storage.\n\n              • registries.conf for definition of container registries to search while pulling.  container images.\n\n              • policy.conf for controlling which images can be pulled to the system.\n\nENVIRONMENT VARIABLES\n       If the CONTAINERS_CONF environment variable is set, all system and user config files are ignored and only the specified config file will be loaded.\n\n       If the CONTAINERS_CONF_OVERRIDE path environment variable is set, the config file will be loaded last even when CONTAINERS_CONF is set.\n\n       The values of both environment variables may be absolute or relative paths, for instance, CONTAINERS_CONF=/tmp/my_containers.conf.\n\nMODULES\n       A module is a containers.conf file located directly in or a sub-directory of the following three directories:\n        - \\$XDG_CONFIG_HOME/containers/containers.conf.modules or  \\$HOME/.config/containers/containers.conf.modules if $XDG_CONFIG_HOME is not set.\n        - /etc/containers/containers.conf.modules\n        - /usr/share/containers/containers.conf.modules\n\n       Files  in those locations are not loaded by default but only on-demand.  They are loaded after all system and user configuration files but before CONTAINERS_CONF_OVERRIDE hence allow‐\n       ing for overriding system and user configs.\n\n       Modules are currently supported by podman(1).  The podman --module flag allows for loading a module and can be specified multiple times.  If the specified value is an  absolute  path,\n       the  config  file  will  be  loaded  directly.   Relative  paths  are resolved relative to the three module directories mentioned above and in the specified order such that modules in\n       $XDG_CONFIG_HOME/$HOME allow for overriding those in /etc and /usr/share.\n\nAPPENDING TO STRING ARRAYS\n       The default behavior during the loading sequence of multiple containers.conf files is to override previous data.  To change the behavior from overriding to appending, you can set  the\n       append  attribute  as follows: array=[\"item-1\", \"item=2\", ..., {append=true}].  Setting the append attribute instructs to append to this specific string array for the current and also\n       subsequent loading steps.  To change back to overriding, set {append=false}.\n\n       Consider the following example:\n\n       modules1.conf: env=[\"1=true\"]\n       modules2.conf: env=[\"2=true\"]\n       modules3.conf: env=[\"3=true\", {append=true}]\n       modules4.conf: env=[\"4=true\"]\n\n       After loading the files in the given order, the final contents are env=[\"2=true\", \"3=true\", \"4=true\"].  If  modules4.conf  would  set  {append=false},  the  final  contents  would  be\n       env=[\"4=true\"].\n\nFORMAT\n       The TOML format ⟨https://github.com/toml-lang/toml⟩ is used as the encoding of the configuration file.  Every option is nested under its table. No bare options are used. The format of\n       TOML can be simplified to:\n\n       [table1]\n       option = value\n\n       [table2]\n       option = value\n\n       [table3]\n       option = value\n\n       [table3.subtable1]\n       option = value\n\nCONTAINERS TABLE\n       The containers table contains settings to configure and manage the OCI runtime.\n\n       annotations = []\n\n       List of annotations. Specified as \"key=value\" pairs to be added to all containers.\n\n       Example: \"run.oci.keep_original_groups=1\"\n\n       apparmor_profile=\"container-default\"\n\n       Used to change the name of the default AppArmor profile of container engines.  The default profile name is \"container-default\".\n\n       base_hosts_file=\"\"\n\n       Base file to create the /etc/hosts file inside the container. This must either be an absolute path to a file on the host system, or one of the following special flags:\n         \"\"      Use the host's /etc/hosts file (the default)\n         none  Do not use a base file (i.e. start with an empty file)\n         image Use the container image's /etc/hosts file as base file\n\n       cgroup_conf=[]\n\n       List of cgroup_conf entries specifying a list of cgroup files to write to and their values. For example memory.high=1073741824 sets the memory.high limit to 1GB.\n\n       cgroups=\"enabled\"\n\n       Determines  whether  the  container will create CGroups.  Options are:\n         enabled   Enable cgroup support within container\n         disabled  Disable cgroup support, will inherit cgroups from parent\n         no-conmon Do not create a cgroup dedicated to conmon.\n\n       cgroupns=\"private\"\n\n       Default way to create a cgroup namespace for the container.  Options are: private Create private Cgroup Namespace for the container.  host    Share host Cgroup Namespace with the con‐\n       tainer.\n\n       container_name_as_hostname=true|false\n\n       When  no  hostname  is  set for a container, use the container's name, with characters not valid for a hostname removed, as the hostname instead of the first 12 characters of the con‐\n       tainer's ID. Containers not running in a private UTS namespace will have their hostname set to the host's hostname regardless of this setting.\n\n       Default is false.\n\n       default_capabilities=[]\n\n       List of default capabilities for containers.\n\n       The default list is:\n\n       default_capabilities = [\n             \"CHOWN\",\n             \"DAC_OVERRIDE\",\n             \"FOWNER\",\n             \"FSETID\",\n             \"KILL\",\n             \"NET_BIND_SERVICE\",\n             \"SETFCAP\",\n             \"SETGID\",\n             \"SETPCAP\",\n             \"SETUID\",\n             \"SYS_CHROOT\",\n       ]\n\n       Note, by default container engines using containers.conf, run with less capabilities than Docker. Docker runs additionally with \"AUDIT_WRITE\", \"MKNOD\" and \"NET_RAW\". If  you  need  to\n       add one of these capabilities for a particular container, you can use the --cap-add option or edit your system's containers.conf.\n\n       default_sysctls=[]\n\n       A list of sysctls to be set in containers by default, specified as \"name=value\".\n\n       Example:\"net.ipv4.ping_group_range=0 1000\".\n\n       default_ulimits=[]\n\n       A list of ulimits to be set in containers by default, specified as \"name=soft-limit:hard-limit\".\n\n       Example: \"nofile=1024:2048\".\n\n       devices=[]\n\n       List of devices.  Specified as 'device-on-host:device-on-container:permissions'.\n\n       Example: \"/dev/sdc:/dev/xvdc:rwm\".\n\n       dns_options=[]\n\n       List of default DNS options to be added to /etc/resolv.conf inside of the container.\n\n       dns_searches=[]\n\n       List of default DNS search domains to be added to /etc/resolv.conf inside of the container.\n\n       dns_servers=[]\n\n       A list of dns servers to override the DNS configuration passed to the container. The special value “none” can be specified to disable creation of /etc/resolv.conf in the container.\n\n       env=[\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\"]\n\n       Environment variable list for the container process, used for passing environment variables to the container.\n\n       env_host=false\n\n       Pass all host environment variables into the container.\n\n       host_containers_internal_ip=\"\"\n\n       Set  the  IP  address  the  container should expect to connect to the host. The IP address is used by Podman to automatically add the host.containers.internal and host.docker.internal\n       hostnames to the container's /etc/hosts file. It is also used for the host-gateway flag of Podman's --add-host CLI option.  If no IP address is configured (the default),  Podman  will\n       try  to  determine  it  automatically, but might fail to do so depending on the container's network setup. Adding these internal hostnames to /etc/hosts is silently skipped then.  Set\n       this config to none to never add the internal hostnames to /etc/hosts.\n\n       Note: If Podman is running in a virtual machine using podman machine (this includes Mac and Windows hosts), Podman will silently skip adding the internal hostnames to /etc/hosts,  un‐\n       less  an  IP  address was configured manually. The internal hostnames are resolved by the gvproxy DNS resolver instead. This config has no effect on gvproxy. However, since /etc/hosts\n       bypasses the DNS resolver, a manually configured IP address still takes precedence.\n\n       Note: This config doesn't affect the actual network setup, it just tells Podman the IP address it should expect. Configuring an IP address here doesn't ensure that the  container  can\n       actually reach the host using this IP address.\n\n       http_proxy=true\n\n       Default  proxy  environment variables will be passed into the container.  The environment variables passed in include: http_proxy, https_proxy, ftp_proxy, no_proxy, and the upper case\n       versions of these. The no_proxy option is needed when host system uses a proxy but container should not use proxy. Proxy environment variables specified for the container in any other\n       way will override the values passed from the host.\n\n       init=false\n\n       Run an init inside the container that forwards signals and reaps processes.\n\n       init_path=\"/usr/libexec/podman/catatonit\"\n\n       If this option is not set catatonit is searched in the directories listed under the helper_binaries_dir option. It is recommended to just install catatonit there instead of  configur‐\n       ing this option here.\n\n       Path  to the container-init binary, which forwards signals and reaps processes within containers. Note that the container-init binary will only be used when the --init for podman-cre‐\n       ate and podman-run is set.\n\n       interface_name=\"\"\n\n       Default way to set interface names inside containers. Defaults to legacy pattern of ethX, where X is an integer, when left undefined.  Options are:\n         device   Uses the network_interface name from the network config as interface name. Falls back to the ethX pattern if the network_interface is not set.\n\n       ipcns=\"shareable\"\n\n       Default way to create a IPC namespace for the container.  Options are:\n         host     Share host IPC Namespace with the container.\n         none     Create shareable IPC Namespace for the container without a private /dev/shm.\n         private  Create private IPC Namespace for the container, other containers are not allowed to share it.\n         shareable Create shareable IPC Namespace for the container.\n\n       keyring=true\n\n       Indicates whether the container engines create a kernel keyring for use within the container.\n\n       label=true\n\n       Indicates whether the container engine uses MAC(SELinux) container separation via labeling. This option is ignored on disabled systems.\n\n       label_users=false\n\n       label_users indicates whether to enforce confined users in containers on SELinux systems. This option causes containers to maintain the current user and  role  field  of  the  calling\n       process. By default SELinux containers run with the user system_u, and the role system_r.\n\n       log_driver=\"\"\n\n       Logging  driver for the container. Currently available options are k8s-file, journald, none and passthrough, with json-file aliased to k8s-file for scripting compatibility.  The jour‐\n       nald driver is used by default if the systemd journal is readable and writable.  Otherwise, the k8s-file driver is used.\n\n       log_size_max=-1\n\n       Maximum size allowed for the container's log file. Negative numbers indicate that no size limit is imposed. If it is positive, it must be >= 8192 to match/exceed conmon's read buffer.\n       The file is truncated and re-opened so the limit is never exceeded.\n\n       log_tag=\"\"\n\n       Default format tag for container log messages. This is useful for creating a specific tag for container log messages. Container log messages default to using the  truncated  container\n       ID as a tag.\n\n       mounts=[]\n\n       List of mounts.  Specified as \"type=TYPE,source=,destination=,\"\n\n       Example:  [ \"type=bind,source=/var/lib/foobar,destination=/var/lib/foobar,ro\", ]\n\n       netns=\"private\"\n\n       Default way to create a NET namespace for the container.  Options are:\n         private Create private NET Namespace for the container.\n         host    Share host NET Namespace with the container.\n         none    Containers do not use the network.\n\n       no_hosts=false\n\n       Do  not modify the /etc/hosts file in the container. Podman assumes control over the container's /etc/hosts file by default; refer to the --add-host CLI option for details. To disable\n       this, either set this config to true, or use the functionally identical --no-hosts CLI option.\n\n       oom_score_adj=0\n\n       Tune the host's OOM preferences for containers (accepts values from -1000 to 1000).\n\n       pidns=\"private\"\n\n       Default way to create a PID namespace for the container.  Options are:\n         private Create private PID Namespace for the container.\n         host    Share host PID Namespace with the container.\n\n       pids_limit=1024\n\n       Maximum number of processes allowed in a container. 0 indicates that no limit is imposed.\n\n       prepare_volume_on_create=false\n\n       Copy the content from the underlying image into the newly created volume when the container is created instead of when it is started. If false, the container engine will not copy  the\n       content until the container is started. Setting it to true may have negative performance implications.\n\n       privileged=false\n\n       Give  extended  privileges  to  all containers. A privileged container turns off the security features that isolate the container from the host. Dropped Capabilities, limited devices,\n       read-only mount points, Apparmor/SELinux separation, and Seccomp filters are all disabled. Due to the disabled security features, the privileged field should almost never  be  set  as\n       containers can easily break out of confinment.\n\n       Containers running in a user namespace (e.g., rootless containers) cannot have more privileges than the user that launched them.\n\n       read_only=true|false\n\n       Run all containers with root file system mounted read-only. Set to false by default.\n\n       seccomp_profile=\"/usr/share/containers/seccomp.json\"\n\n       Path to the seccomp.json profile which is used as the default seccomp profile for the runtime.\n\n       shm_size=\"65536k\"\n\n       Size of /dev/shm. The format is   . number must be greater than 0.  Unit is optional and can be: b (bytes), k (kilobytes), m(megabytes), or g (gigabytes).  If you omit the\n       unit, the system uses bytes. If you omit the size entirely, the system uses 65536k.\n\n       tz=\"\"\n\n       Set  timezone  in  container. Takes IANA timezones as well as local, which sets the timezone in the container to match the host machine.  If not set, then containers will run with the\n       time zone specified in the image.\n\n       Examples:\n         tz=\"local\"\n         tz=\"America/New_York\"\n\n       umask=\"0022\"\n\n       Sets umask inside the container.\n\n       userns=\"host\"\n\n       Default way to create a USER namespace for the container.  Options are:\n         private Create private USER Namespace for the container.\n         host    Share host USER Namespace with the container.\n\n       utsns=\"private\"\n\n       Default way to create a UTS namespace for the container.  Options are:\n         private Create private UTS Namespace for the container.\n         host    Share host UTS Namespace with the container.\n\n       volumes=[]\n\n       List of volumes.  Specified as \"directory-on-host:directory-in-container:options\".\n\n       Example:  \"/db:/var/lib/db:ro\".\n\nNETWORK TABLE\n       The network table contains settings pertaining to the management of CNI plugins.\n\n       network_backend=\"\"\n\n       Network backend determines what network driver will be used to set up and tear down container networks.  Valid values are \"cni\" and \"netavark\".  The default value is empty which means\n       that it will automatically choose CNI or netavark. If there are already containers/images or CNI networks preset it will choose CNI.\n\n       Before changing this value all containers must be stopped otherwise it is likely that iptables rules and network interfaces might leak on the host. A reboot will fix this.\n\n       cni_plugin_dirs=[]\n\n       List of paths to directories where CNI plugin binaries are located.\n\n       The default list is:\n\n       cni_plugin_dirs = [\n         \"/usr/local/libexec/cni\",\n         \"/usr/libexec/cni\",\n         \"/usr/local/lib/cni\",\n         \"/usr/lib/cni\",\n         \"/opt/cni/bin\",\n       ]\n\n       netavark_plugin_dirs=[]\n\n       List of directories that will be searched for netavark plugins.\n\n       The default list is:\n\n       netavark_plugin_dirs = [\n         \"/usr/local/libexec/netavark\",\n         \"/usr/libexec/netavark\",\n         \"/usr/local/lib/netavark\",\n         \"/usr/lib/netavark\",\n       ]\n\n       default_network=\"podman\"\n\n       The network name of the default network to attach pods to.\n\n       default_subnet=\"10.88.0.0/16\"\n\n       The subnet to use for the default network (named above in default_network).  If the default network does not exist, it will be automatically created the first time a tool is run using\n       this subnet.\n\n       default_subnet_pools=[]\n\n       DefaultSubnetPools is a list of subnets and size which are used to allocate subnets automatically for podman network create.  It will iterate through the list and will pick the  first\n       free subnet with the given size. This is only used for ipv4 subnets, ipv6 subnets are always assigned randomly.\n\n       The default list is (10.89.0.0-10.255.255.0/24):\n\n       default_subnet_pools = [\n         {\"base\" = \"10.89.0.0/16\", \"size\" = 24},\n         {\"base\" = \"10.90.0.0/15\", \"size\" = 24},\n         {\"base\" = \"10.92.0.0/14\", \"size\" = 24},\n         {\"base\" = \"10.96.0.0/11\", \"size\" = 24},\n         {\"base\" = \"10.128.0.0/9\", \"size\" = 24},\n       ]\n\n       default_rootless_network_cmd=\"pasta\"\n\n       Configure which rootless network program to use by default. Valid options are slirp4netns and pasta (default).\n\n       network_config_dir=\"/etc/cni/net.d/\"\n\n       Path  to  the directory where network configuration files are located.  For the CNI backend the default is /etc/cni/net.d as root and $HOME/.config/cni/net.d as rootless.  For the ne‐\n       tavark backend \"/etc/containers/networks\" is used as root and \"$graphroot/networks\" as rootless.\n\n       firewall_driver=\"\"\n\n       The firewall driver to be used by netavark.  The default is empty which means netavark will pick one accordingly. Current supported drivers  are  \"iptables\",  \"nftables\",  \"none\"  (no\n       firewall rules will be created) and \"firewalld\" (firewalld is experimental at the moment and not recommend outside of testing).\n\n       dns_bind_port=53\n\n       Port to use for dns forwarding daemon with netavark in rootful bridge mode and dns enabled.  Using an alternate port might be useful if other dns services should run on the machine.\n\n       pasta_options = []\n\n       A list of default pasta options that should be used running pasta.  It accepts the pasta cli options, see pasta(1) for the full list of options.\n\nENGINE TABLE\n       The engine table contains configuration options used to set up container engines such as Podman and Buildah.\n\n       active_service=\"\"\n\n       Name of destination for accessing the Podman service. See SERVICE DESTINATION TABLE below.\n\n       add_compression=[]\n\n       List of compression algorithms. If set makes sure that requested compression variant for each platform is added to the manifest list keeping original instance intact in the same mani‐\n       fest  list on every manifest push. Supported values are (gzip, zstd and zstd:chunked).  zstd:chunked is incompatible with encrypting images, and will be treated as zstd with a warning\n       in that case.\n\n       Note: This is different from compression_format which allows users to select a default compression format for push and manifest push, while add_compression is limited to manifest push\n       and allows users to append new instances to manifest list with specified compression algorithms in add_compression for each platform.\n\n       cgroup_manager=\"systemd\"\n\n       The cgroup management implementation used for the runtime. Supports cgroupfs and systemd.\n\n       compat_api_enforce_docker_hub=true\n\n       Enforce using docker.io for completing short names in Podman's compatibility REST API. Note that this will ignore unqualified-search-registries and short-name aliases defined in  con‐\n       tainers-registries.conf(5).\n\n       compose_providers=[]\n\n       Specify one or more external providers for the compose command.  The first found provider is used for execution.  Can be an absolute and relative path or a (file) name.\n\n       compose_warning_logs=true\n\n       Emit logs on each invocation of the compose command indicating that an external compose provider is being executed.\n\n       conmon_env_vars=[]\n\n       Environment variables to pass into Conmon.\n\n       conmon_path=[]\n\n       Paths to search for the conmon container manager binary. If the paths are empty or no valid path was found, then the $PATH environment variable will be used as the fallback.\n\n       The default list is:\n\n       conmon_path=[\n           \"/usr/libexec/podman/conmon\",\n           \"/usr/local/libexec/podman/conmon\",\n           \"/usr/local/lib/podman/conmon\",\n           \"/usr/bin/conmon\",\n           \"/usr/sbin/conmon\",\n           \"/usr/local/bin/conmon\",\n           \"/usr/local/sbin/conmon\",\n           \"/run/current-system/sw/bin/conmon\",\n       ]\n\n       database_backend=\"\"\n\n       The database backend of Podman.  Supported values are \"\" (default), \"boltdb\" and \"sqlite\". An empty value means it will check whenever a boltdb already exists and use it when it does,\n       otherwise  it  will use sqlite as default (e.g. new installs). This allows for backwards compatibility with older versions.  Please run podman-system-reset prior to changing the data‐\n       base backend of an existing deployment, to make sure Podman can operate correctly.\n\n       detach_keys=\"ctrl-p,ctrl-q\"\n\n       Keys sequence used for detaching a container.  Specify the keys sequence used to detach a container.  Format is a single character [a-Z] or a comma separated sequence of ctrl- ,\n       where   is one of: a-z, @, ^, [, \\, ], ^ or _ Specifying \"\" disables this feature.\n\n       enable_port_reservation=true\n\n       Determines whether the engine will reserve ports on the host when they are forwarded to containers. When enabled, when ports are forwarded to containers, they are held open by  conmon\n       as  long as the container is running, ensuring that they cannot be reused by other programs on the host. However, this can cause significant memory usage if a container has many ports\n       forwarded to it.  Disabling this can save memory.\n\n       env=[]\n\n       Environment variables to be used when running the container engine (e.g., Podman, Buildah). For example \"http_proxy=internal.proxy.company.com\".  Note these environment variables will\n       not be used within the container. Set the env section under [containers] table, if you want to set environment variables for the container.\n\n       events_logfile_path=\"\"\n\n       Define where event logs will be stored, when events_logger is \"file\".\n\n       events_logfile_max_size=\"1m\"\n\n       Sets the maximum size for events_logfile_path.  The unit can be b (bytes), k (kilobytes), m (megabytes) or g (gigabytes).  The format for the size is   , e.g., 1b  or  3g.\n       If no unit is included then the size will be in bytes.  When the limit is exceeded, the logfile will be rotated and the old one will be deleted.  If the maximum size is set to 0, then\n       no limit will be applied, and the logfile will not be rotated.\n\n       events_logger=\"journald\"\n\n       The default method to use when logging events.\n\n       The default method is different based on the platform that Podman is being run upon.  To determine the current value, use this command:\n\n       podman info --format {{.Host.EventLogger}}\n\n       Valid values are: file, journald, and none.\n\n       events_container_create_inspect_data=true|false\n\n       Creates a more verbose container-create event which includes a JSON payload with detailed information about the container.  Set to false by default.\n\n       healthcheck_events=true|false\n\n       Whenever  Podman  should  log  healthcheck  events.   With  many  running  healthcheck  on  short interval Podman will spam the event log a lot as it generates a event for each single\n       healthcheck run. Because this event is optional and only useful to external consumers that may want to know when a healthcheck is run or failed allow users to turn it off  by  setting\n       it to false.\n\n       Default is true.\n\n       helper_binaries_dir=[\"/usr/libexec/podman\", ...]\n\n       A is a list of directories which are used to search for helper binaries.  The following binaries are searched in these directories:\n        - aardvark-dns\n        - catatonit\n        - netavark\n        - pasta\n        - slirp4netns\n\n       Podman machine uses it for these binaries:\n        - gvproxy\n        - qemu\n        - vfkit\n\n       The default paths on Linux are:\n\n              • /usr/local/libexec/podman\n\n              • /usr/local/lib/podman\n\n              • /usr/libexec/podman\n\n              • /usr/lib/podman\n\n       The default paths on macOS are:\n\n              • /usr/local/opt/podman/libexec\n\n              • /opt/homebrew/bin\n\n              • /opt/homebrew/opt/podman/libexec\n\n              • /usr/local/bin\n\n              • /usr/local/libexec/podman\n\n              • /usr/local/lib/podman\n\n              • /usr/libexec/podman\n\n              • /usr/lib/podman\n\n       The default path on Windows is:\n\n              • C:\\Program Files\\RedHat\\Podman\n\n       hooks_dir=[\"/etc/containers/oci/hooks.d\", ...]\n\n       Path to the OCI hooks directories for automatically executed hooks.\n\n       cdi_spec_dirs=[\"/etc/cdi\", ...]\n\n       Directories to scan for CDI Spec files.\n\n       image_default_format=\"oci\"|\"v2s2\"|\"v2s1\"\n\n       Manifest  Type (oci, v2s2, or v2s1) to use when pulling, pushing, building container images. By default images pulled and pushed match the format of the source image. Building/commit‐\n       ting defaults to OCI.  Note: image_build_format is deprecated.\n\n       image_default_transport=\"docker://\"\n\n       Default transport method for pulling and pushing images.\n\n       image_parallel_copies=0\n\n       Maximum number of image layers to be copied (pulled/pushed) simultaneously.  Not setting this field will fall back to containers/image defaults. (6)\n\n       image_volume_mode=\"bind\"\n\n       Tells container engines how to handle the built-in image volumes.\n\n              • bind: An anonymous named volume will be  created  and  mounted into the container.\n\n              • tmpfs: The volume is mounted onto the container as a tmpfs, which allows the users to create content that disappears when the container is stopped.\n\n              • ignore: All volumes are just ignored and no action is taken.\n\n       infra_command=\"/pause\"\n\n       Infra (pause) container image command for pod infra containers. When running a pod, we start a /pause process in a container to hold open the namespaces associated with the pod.  This\n       container does nothing other than sleep, reserving the pod's resources for the lifetime of the pod.\n\n       infra_image=\"\"\n\n       Infra (pause) container image for pod infra containers. When running a pod, we start a pause process in a container to hold open the namespaces associated with the pod. This container\n       does nothing other than sleep, reserving the pod's resources for the lifetime of the pod. By default container engines run a built-in container using the pause executable. If you want\n       override specify an image to pull.\n\n       kube_generate_type=\"pod\"\n\n       Default Kubernetes kind/specification of the kubernetes yaml generated with the podman kube generate command. The possible options are pod and deployment.\n\n       lock_type=\"shm\"\n\n       Specify  the locking mechanism to use; valid values are \"shm\" and \"file\".  Change the default only if you are sure of what you are doing, in general \"file\" is useful only on platforms\n       where cgo is not available for using the faster \"shm\" lock type. You may need to run \"podman system renumber\" after you change the lock type.\n\n       multi_image_archive=false\n\n       Allows for creating archives (e.g., tarballs) with more than one image. Some container engines, such as Podman, interpret additional arguments as tags for one image and hence  do  not\n       store more than one image. The default behavior can be altered with this option.\n\n       namespace=\"\"\n\n       Default engine namespace. If the engine is joined to a namespace, it will see only containers and pods that were created in the same namespace, and will create new containers and pods\n       in that namespace. The default namespace is \"\", which corresponds to no namespace. When no namespace is set, all containers and pods are visible.\n\n       network_cmd_path=\"\"\n\n       Path to the slirp4netns binary.\n\n       network_cmd_options=[]\n\n       Default options to pass to the slirp4netns binary.\n\n       Valid options values are:\n\n              • allow_host_loopback=true|false: Allow the slirp4netns to reach the host loopback IP (10.0.2.2). Default is false.\n\n              • mtu=MTU: Specify the MTU to use for this network. (Default is 65520).\n\n              • cidr=CIDR: Specify ip range to use for this network. (Default is 10.0.2.0/24).\n\n              • enable_ipv6=true|false: Enable IPv6. Default is true. (Required for outbound_addr6).\n\n              • outbound_addr=INTERFACE: Specify the outbound interface slirp should bind to (ipv4 traffic only).\n\n              • outbound_addr=IPv4: Specify the outbound ipv4 address slirp should bind to.\n\n              • outbound_addr6=INTERFACE: Specify the outbound interface slirp should bind to (ipv6 traffic only).\n\n              • outbound_addr6=IPv6: Specify the outbound ipv6 address slirp should bind to.\n\n              • port_handler=rootlesskit:  Use rootlesskit for port forwarding. Default.  Note: Rootlesskit changes the source IP address of incoming packets to a IP address in the container\n                network namespace, usually 10.0.2.100. If your application requires the real source IP address, e.g. web server logs, use the slirp4netns port handler. The  rootlesskit  port\n                handler is also used for rootless containers when connected to user-defined networks.\n\n              • port_handler=slirp4netns: Use the slirp4netns port forwarding, it is slower than rootlesskit but preserves the correct source IP address. This port handler cannot be used for\n                user-defined networks.\n\n       no_pivot_root=false\n\n       Whether to use chroot instead of pivot_root in the runtime.\n\n       num_locks=2048\n\n       Number of locks available for containers, pods, and volumes.  Each created container, pod, or volume consumes one lock.  Locks are recycled and can be reused after the associated con‐\n       tainer, pod, or volume is removed.  The default number available is 2048.  If this is changed, a lock renumbering must be performed, using the podman system renumber command.\n\n       pod_exit_policy=\"continue\"\n\n       Set the exit policy of the pod when the last container exits.  Supported policies are:\n\n       ┌─────────────┬─────────────────────────────────────────────────────────────────┐\n       │ Exit Policy │ Description                                                     │\n       ├─────────────┼─────────────────────────────────────────────────────────────────┤\n       │ continue    │ The  pod  continues running when the last container exits. Used │\n       │             │ by default.                                                     │\n       ├─────────────┼─────────────────────────────────────────────────────────────────┤\n       │ stop        │ The pod is stopped when the last container exits. Used in  play │\n       │             │ kube.                                                           │\n       └─────────────┴─────────────────────────────────────────────────────────────────┘\n\n       pull_policy=\"always\"|\"missing\"|\"never\"\n\n       Pull image before running or creating a container. The default is missing.\n\n              • missing: attempt to pull the latest image from the registries listed in registries.conf if a local image does not exist. Raise an error if the image is not in any listed reg‐\n                istry and is not present locally.\n\n              • always:  pull  the  image from the first registry it is found in as listed in registries.conf. Raise an error if not found in the registries, even if the image is present lo‐\n                cally.\n\n              • never: do not pull the image from the registry, use only the local version. Raise an error if the image is not present locally.\n\n       remote = false\n\n       Indicates whether the application should be running in remote mode. This flag modifies the --remote option on container engines. Setting the flag to true  will  default  podman  --re‐\n       mote=true for access to the remote Podman service.\n\n       retry = 3\n\n       Number of times to retry pulling/pushing images in case of failure.\n\n       retry_delay = \"\"\n\n       Delay between retries in case pulling/pushing image fails. If set, container engines will retry at the set interval, otherwise they delay 2 seconds and then exponentially back off.\n\n       runtime=\"\"\n\n       Default  OCI specific runtime in runtimes that will be used by default. Must refer to a member of the runtimes table. Default runtime will be searched for on the system using the pri‐\n       ority: \"crun\", \"runc\", \"runj\", \"kata\", \"runsc\", \"ocijail\"\n\n       runtime_supports_json=[\"crun\", \"crun-vm\", \"runc\", \"kata\", \"runsc\", \"youki\", \"krun\"]\n\n       The list of the OCI runtimes that support --format=json.\n\n       runtime_supports_kvm=[\"kata\", \"krun\"]\n\n       The list of OCI runtimes that support running containers with KVM separation.\n\n       runtime_supports_nocgroups=[\"crun\", \"crun-vm\", \"krun\"]\n\n       The list of OCI runtimes that support running containers without CGroups.\n\n       image_copy_tmp_dir=\"/var/tmp\"\n\n       Default location for storing temporary container image content. Can be overridden with the TMPDIR environment variable. If you  specify  \"storage\",  then  the  location  of  the  con‐\n       tainer/storage tmp directory will be used. If set then it is the users responsibility to cleanup storage. Configure tmpfiles.d(5) to cleanup storage.\n\n       service_timeout=5\n\n       Number of seconds to wait without a connection  before the podman system service times out and exits\n\n       static_dir=\"/var/lib/containers/storage/libpod\"\n\n       Directory for persistent libpod files (database, etc).  By default this will be configured relative to where containers/storage stores containers.\n\n       stop_timeout=10\n\n       Number of seconds to wait for container to exit before sending kill signal.\n\n       exit_command_delay=300\n\n       Number of seconds to wait for the API process for the exec call before sending exit command mimicking the Docker behavior of 5 minutes (in seconds).\n\n       tmp_dir=\"/run/libpod\"\n\n       The path to a temporary directory to store per-boot container.  Must be a tmpfs (wiped after reboot).\n\n       volume_path=\"/var/lib/containers/storage/volumes\"\n\n       Directory  where named volumes will be created in using the default volume driver.  By default this will be configured relative to where containers/storage store containers. This con‐\n       vention is followed by the default volume driver, but may not be by other drivers.\n\n       chown_copied_files=true\n\n       Determines whether file copied into a container will have changed ownership to the primary uid/gid of the container.\n\n       compression_format=\"gzip\"\n\n       Specifies the compression format to use when pushing an image. Supported values are: gzip, zstd and zstd:chunked. This field is ignored when pushing images to  the  docker-daemon  and\n       docker-archive formats. It is also ignored when the manifest format is set to v2s2.  zstd:chunked is incompatible with encrypting images, and will be treated as zstd with a warning in\n       that case.\n\n       compression_level=\"5\"\n\n       The  compression level to use when pushing an image. Valid options depend on the compression format used. For gzip, valid options are 1-9, with a default of 5. For zstd, valid options\n       are 1-20, with a default of 3.\n\nSERVICE DESTINATION TABLE\n       The engine.service_destinations table contains configuration options used to set up remote connections to the podman service for the podman API.\n\n       [engine.service_destinations.{name}] URI to access the Podman service uri=\"ssh://user@production.example.com/run/user/1001/podman/podman.sock\"\n\n       Example URIs:\n\n              • rootless local  - unix:///run/user/1000/podman/podman.sock\n\n              • rootless remote - ssh://user@engineering.lab.company.com/run/user/1000/podman/podman.sock\n\n              • rootful local  - unix:///run/podman/podman.sock\n\n              • rootful remote - ssh://root@10.10.1.136:22/run/podman/podman.sock\n\n       identity=\"~/.ssh/id_rsa\n\n       Path to file containing ssh identity key\n\n       [engine.volume_plugins]\n\n       A table of all the enabled volume plugins on the system. Volume plugins can be used as the backend for Podman named volumes. Individual plugins are specified below, as a  map  of  the\n       plugin name (what the plugin will be called) to its path (filepath of the plugin's unix socket).\n\n       [engine.platform_to_oci_runtime]\n\n       Allows end users to switch the OCI runtime on the bases of container image's platform string.  Following config field contains a map of platform/string = oci_runtime.\n\nSECRET TABLE\n       The secret table contains settings for the configuration of the secret subsystem.\n\n       driver=file\n\n       Name of the secret driver to be used.  Currently valid values are:\n         * file\n         * pass\n\n       [secrets.opts]\n\n       The driver specific options object.\n\nMACHINE TABLE\n       The machine table contains configurations for podman machine VMs\n\n       cpus=1 Number of CPU's a machine is created with.\n\n       disk_size=10\n\n       The size of the disk in GB created when init-ing a podman-machine VM\n\n       image=\"\"\n\n       Image  used  when creating a new VM using podman machine init.  Can be specified as a registry with a bootable OCI artifact, download URL, or a local path.  Registry target must be in\n       the form of docker://registry/repo/image:version.  Container engines translate URIs $OS and $ARCH to the native OS and ARCH.  URI \"https://example.com/$OS/$ARCH/foobar.ami\" would  be‐\n       come \"https://example.com/linux/amd64/foobar.ami\" on a Linux AMD machine.  If unspecified, the default Podman machine image will be used.\n\n       memory=2048\n\n       Memory in MB a machine is created with.\n\n       user=\"\"\n\n       Username to use and create on the podman machine OS for rootless container access. The default value is user. On Linux/Mac the default iscore.\n\n       volumes=[\"$HOME:$HOME\"]\n\n       Host directories to be mounted as volumes into the VM by default.  Environment variables like $HOME as well as complete paths are supported for the source and destination. An optional\n       third field :ro can be used to tell the container engines to mount the volume readonly.\n\n       On Mac, the default volumes are:\n\n       [ \"/Users:/Users\", \"/private:/private\", \"/var/folders:/var/folders\" ]\n\n       provider=\"\"\n\n       Virtualization provider to be used for running a podman-machine VM. Empty value is interpreted as the default provider for the current host OS.\n\n       ┌──────────┬─────────────────────────────────────────────────┬──────────┐\n       │ Platform │ Default Virtualization provider                 │ Optional │\n       ├──────────┼─────────────────────────────────────────────────┼──────────┤\n       │ Linux    │ \"\" (qemu)                                       │ None     │\n       ├──────────┼─────────────────────────────────────────────────┼──────────┤\n       │ Windows  │ \"\" (\"wsl\": Windows Subsystem for Linux)         │          │\n       ├──────────┼─────────────────────────────────────────────────┼──────────┤\n       │          │ \"hyperv\" (Windows Server Virtualization)        │          │\n       ├──────────┼─────────────────────────────────────────────────┼──────────┤\n       │ Mac      │ \"\" (\"applehv\": Apple Hypervisor)                │          │\n       ├──────────┼─────────────────────────────────────────────────┼──────────┤\n       │          │ \"libkrun\" (Launch machine via libkrun platform, │          │\n       │          │ optimized for sharing GPU with the machine)     │          │\n       └──────────┴─────────────────────────────────────────────────┴──────────┘\n\n       rosetta=\"true\"\n\n       Rosetta supports running x86_64 Linux binaries on a Podman machine on Apple silicon.  The default value is true. Supported on AppleHV(arm64) machines only.\n\nFARMS TABLE\n       The  farms  table  contains  configuration  options used to group up remote connections into farms that will be used when sending out builds to different machines in a farm via podman\n       buildfarm.\n\n       default=\"\"\n\n       The default farm to use when farming out builds.\n\n       [farms.list]\n\n       Map of farms created where the key is the farm name and the value is the list of system connections.\n\nPODMANSH TABLE\n       The podmansh table contains configuration options used by podmansh.\n\n       shell=\"/bin/sh\"\n\n       The shell to spawn in the container.  The default value is /bin/sh.\n\n       container=\"podmansh\"\n\n       Name of the container that podmansh joins.  The default value is podmansh.\n\n       timeout=0\n\n       Number of seconds to wait for podmansh logins. This value if favoured over the deprecated field engine.podmansh_timeout if set.  The default value is 30.\n\nFILES\n       containers.conf\n\n       Distributions often provide a /usr/share/containers/containers.conf file to provide a default configuration. Administrators can override fields in this file by creating  /etc/contain‐\n       ers/containers.conf  to specify their own configuration. They may also drop .conf files in /etc/containers/containers.conf.d which will be loaded in alphanumeric order.  For user spe‐\n       cific configuration it reads \\$XDG_CONFIG_HOME/containers/containers.conf and \\$XDG_CONFIG_HOME/containers/containers.conf.d/*.conf files. When $XDG_CONFIG_HOME is not  set  it  falls\n       back to using $HOME/.config instead.\n\n       Fields specified in a containers.conf file override the default options, as well as options in previously loaded containers.conf files.\n\n       storage.conf\n\n       The  /etc/containers/storage.conf  file is the default storage configuration file.  Rootless users can override fields in the storage config by creating $HOME/.config/containers/stor‐\n       age.conf.\n\n       If the CONTAINERS_STORAGE_CONF path environment variable is set, this path is used for the storage.conf file rather than the default.  This is primarily used for testing.\n\nSEE ALSO\n       containers-storage.conf(5), containers-policy.json(5), containers-registries.conf(5), tmpfiles.d(5)\n\nengine                                                                                     Container                                                                        containers.conf(5)","ref":"containers-conf.html"},{"type":"extras","title":"containers-mounts.conf","doc":"containers-mounts.conf(5)()                                                                                                                                        containers-mounts.conf(5)()\n\nNAME\n       containers-mounts.conf - configuration file for default mounts in containers\n\nDESCRIPTION\n       The  mounts.conf file specifies volume mount directories that are automatically mounted inside containers. Container processes can then use this content. Usually these directories are\n       used for passing secrets or credentials required by the package software to access remote package repositories. Note that for security reasons, tools adhering to the  mounts.conf  are\n       expected to copy the contents instead of bind mounting the paths from the host.\n\nFORMAT\n       The format of the mounts.conf is the volume format /SRC:/DEST, one mount per line. For example, a mounts.conf with the line /usr/share/secrets:/run/secrets would cause the contents of\n       the  /usr/share/secrets directory on the host to be mounted on the /run/secrets directory inside the container. Setting mountpoints allows containers to use the files of the host, for\n       instance, to use the host's subscription to some enterprise Linux distribution.\n\nFILES\n       Some distributions may provide a /usr/share/containers/mounts.conf file to provide default mounts, but users can create a /etc/containers/mounts.conf, to  specify  their  own  special\n       volumes to mount in the container. When Podman runs in rootless mode, the file $HOME/.config/containers/mounts.conf will override the default if it exists.\n\nHISTORY\n       Aug 2018, Originally compiled by Valentin Rothberg vrothberg@suse.com ⟨mailto:vrothberg@suse.com⟩\n\n                                                                                                                                                                   containers-mounts.conf(5)()","ref":"containers-mounts-conf.html"},{"type":"extras","title":"containers-policy.json","doc":"CONTAINERS-POLICY.JSON(5)                                                                    Page                                                                    CONTAINERS-POLICY.JSON(5)\n\nMiloslav Trmač September 2016\n\nNAME\n       containers-policy.json - syntax for the signature verification policy file\n\nDESCRIPTION\n       Signature  verification  policy  files  are  used to specify policy, e.g. trusted keys, applicable when deciding whether to accept an image, or individual signatures of that image, as\n       valid.\n\n       By default, the policy is read from $HOME/.config/containers/policy.json, if it exists, otherwise from /etc/containers/policy.json;  applications performing verification may allow us‐\n       ing a different policy instead.\n\nFORMAT\n       The signature verification policy file, usually called policy.json, uses a JSON format.  Unlike some other JSON files, its parsing is fairly strict: unrecognized, duplicated or other‐\n       wise invalid fields cause the entire file, and usually the entire operation, to be rejected.\n\n       The purpose of the policy file is to define a set of policy requirements for a container image, usually depending on its location (where it is being pulled from) or otherwise  defined\n       identity.\n\n       Policy requirements can be defined for:\n\n              • An individual scope in a transport.  The transport values are the same as the transport prefixes when pushing/pulling images (e.g. docker:, atomic:), and scope values are de‐\n                fined by each transport; see below for more details.\n\n       Usually, a scope can be defined to match a single image, and various prefixes of\n         such a most specific scope define namespaces of matching images.\n\n              • A default policy for a single transport, expressed using an empty string as a scope\n\n              • A global default policy.\n\n       If multiple policy requirements match a given image, only the requirements from the most specific match apply, the more general policy requirements definitions are ignored.\n\n       This is expressed in JSON using the top-level syntax\n\n       {\n           \"default\": [/* policy requirements: global default */]\n           \"transports\": {\n               transport_name: {\n                   \"\": [/* policy requirements: default for transport $transport_name */],\n                   scope_1: [/* policy requirements: default for $scope_1 in $transport_name */],\n                   scope_2: [/*…*/]\n                   /*…*/\n               },\n               transport_name_2: {/*…*/}\n               /*…*/\n           }\n       }\n\n       The global default set of policy requirements is mandatory; all of the other fields (transports itself, any specific transport, the transport-specific default, etc.) are optional.\n\nSupported transports and their scopes\n       See containers-transports(5) for general documentation about the transports and their reference syntax.\n\n   atomic:\n       The deprecated atomic: transport refers to images in an Atomic Registry.\n\n       Supported  scopes  use  the  form hostname[:port][/namespace[/imagestream [:tag]]], i.e. either specifying a complete name of a tagged image, or prefix denoting a host/namespace/image\n       stream, or a wildcarded expression starting with *. for matching all subdomains. For wildcarded subdomain matching, *.example.com is a valid case, but example*.*.com is not.\n\n       Note: The hostname and port refer to the container registry host and port (the one used e.g. for docker pull), not to the OpenShift API host and port.\n\n   containers-storage:\n       Supported scopes have the form [storage-specifier]image-scope.\n\n       [storage-specifier] is usually [graph-driver-name@graph-root], e.g. [overlay@/var/lib/containers/storage].\n\n       image-scope matching the individual image is - a named Docker reference in the fully expanded form, either using a tag or digest. For  example,  docker.io/library/busybox:latest  (not\n       busybox:latest) - and/or (depending on which one the user’s input provides) @image-id\n\n       More general scopes are prefixes of individual-image scopes, and specify a less-precisely-specified image, or a repository (by omitting first the image ID, if any; then the digest, if\n       any; and finally a tag, if any), a repository namespace, or a registry host (by only specifying the host name and possibly a port number).\n\n       Finally, two full-store specifiers matching all images in the store are valid scopes: - [graph-driver-name@graph-root] and - [graph-root]\n\n       Note  that  some tools like Podman and Buildah hard-code overrides of the signature verification policy for “push” operations, allowing these operations regardless of configuration in\n       policy.json.\n\n   dir:\n       The dir: transport refers to images stored in local directories.\n\n       Supported scopes are paths of directories (either containing a single image or subdirectories possibly containing images).\n\n       Note: - The paths must be absolute and contain no symlinks. Paths violating these requirements may be silently ignored.  - The top-level scope \"/\" is forbidden; use the transport  de‐\n       fault scope \"\",\n         for consistency with other transports.\n\n   docker:\n       The docker: transport refers to images in a registry implementing the \"Docker Registry HTTP API V2\".\n\n       Scopes matching individual images are named Docker references in the fully expanded form, either using a tag or digest. For example, docker.io/library/busybox:latest (not busybox:lat‐\n       est).\n\n       More  general  scopes are prefixes of individual-image scopes, and specify a repository (by omitting the tag or digest), a repository namespace, or a registry host (by only specifying\n       the host name and possibly a port number) or a wildcarded expression starting with *., for matching all subdomains (not including a port number). For  wildcarded  subdomain  matching,\n       *.example.com is a valid case, but example*.*.com is not.\n\n   docker-archive:\n       Only the default \"\" scope is supported.\n\n   docker-daemon:\n       For references using the algo:digest format (referring to an image ID), only the default \"\" scope is used.\n\n       For  images using a named reference, scopes matching individual images are in the fully expanded form, either using a tag or digest. For example, docker.io/library/busybox:latest (not\n       busybox:latest).\n\n       More general named scopes are prefixes of individual-image scopes, and specify a repository (by omitting the tag or digest), a repository namespace, or a registry host (by only speci‐\n       fying the host name and possibly a port number) or a wildcarded expression starting with *., for matching all subdomains (not including a port number). For wildcarded subdomain match‐\n       ing, *.example.com is a valid case, but example*.*.com is not.\n\n   oci:\n       The oci: transport refers to images in directories compliant with \"Open Container Image Layout Specification\".\n\n       Supported scopes are paths to directories (either containing an OCI layout, or subdirectories possibly containing OCI layout directories).  The reference annotation value, if any,  is\n       not used.\n\n       Note:  - The paths must be absolute and contain no symlinks. Paths violating these requirements may be silently ignored.  - The top-level scope \"/\" is forbidden; use the transport de‐\n       fault scope \"\",\n         for consistency with other transports.\n\n   oci-archive:\n       Supported scopes are paths to OCI archives, and their parent directories (either containing a single archive, or subdirectories possibly containing archives).  The  reference  annota‐\n       tion value, if any, is not used.\n\n       Note:  - The paths must be absolute and contain no symlinks. Paths violating these requirements may be silently ignored.  - The top-level scope \"/\" is forbidden; use the transport de‐\n       fault scope \"\",\n         for consistency with other transports.\n\n   ostree:\n       Supported scopes have the form repo-path:image-scope; _repopath is the path to the OSTree repository.\n\n       image-scope is the _dockerreference part of the reference, with with a :latest tag implied if no tag is present, and parent namespaces of the _dockerreference value (by  omitting  the\n       tag, or a prefix specifying a higher-level namespace).\n\n       Note: - The _repopath must be absolute and contain no symlinks. Paths violating these requirements may be silently ignored.\n\n   sif:\n       Supported scopes are paths to Singularity images, and their parent directories (either containing images, or subdirectories possibly containing images).\n\n       Note:  - The paths must be absolute and contain no symlinks. Paths violating these requirements may be silently ignored.  - The top-level scope \"/\" is forbidden; use the transport de‐\n       fault scope \"\",\n         for consistency with other transports.\n\n   tarball:\n       The tarball: transport is an implementation detail of some import workflows. Only the default \"\" scope is supported.\n\nPolicy Requirements\n       Using the mechanisms above, a set of policy requirements is looked up.  The policy requirements are represented as a JSON array of individual requirement objects.  For an image to  be\n       accepted, all of the requirements must be satisfied simultaneously.\n\n       The  policy requirements can also be used to decide whether an individual signature is accepted (= is signed by a recognized key of a known author); in that case some requirements may\n       apply only to some signatures, but each signature must be accepted by at least one requirement object.\n\n       The following requirement objects are supported:\n\n   insecureAcceptAnything\n       A simple requirement with the following syntax\n\n       {\"type\":\"insecureAcceptAnything\"}\n\n       This requirement accepts any image (but note that other requirements in the array still apply).\n\n       When deciding to accept an individual signature, this requirement does not have any effect; it does not cause the signature to be accepted, though.\n\n       This is useful primarily for policy scopes where no signature verification is required; because the array of policy requirements must not be empty, this requirement is used to  repre‐\n       sent the lack of requirements explicitly.\n\n   reject\n       A simple requirement with the following syntax:\n\n       {\"type\":\"reject\"}\n\n       This requirement rejects every image, and every signature.\n\n   signedBy\n       This requirement requires an image to be signed using “simple signing” with an expected identity, or accepts a signature if it is using an expected identity and key.\n\n       {\n           \"type\":    \"signedBy\",\n           \"keyType\": \"GPGKeys\", /* The only currently supported value */\n           \"keyPath\": \"/path/to/local/keyring/file\",\n           \"keyPaths\": [\"/path/to/local/keyring/file1\",\"/path/to/local/keyring/file2\"…],\n           \"keyData\": \"base64-encoded-keyring-data\",\n           \"signedIdentity\": identity_requirement\n       }\n\n       Exactly one of keyPath, keyPaths and keyData must be present, containing a GPG keyring of one or more public keys.  Only signatures made by these keys are accepted.\n\n       The signedIdentity field, a JSON object, specifies what image identity the signature claims about the image.  One of the following alternatives are supported:\n\n              • The  identity  in  the signature must exactly match the image identity.  Note that with this, referencing an image by digest (with a signature claiming a repository:tag iden‐\n                tity) will fail.\n\n         {\"type\":\"matchExact\"}\n\n              • If the image identity carries a tag, the identity in the signature must exactly match; if the image identity uses a digest reference, the identity in the signature must be in\n                the same repository as the image identity (using any tag).\n\n       (Note that with images identified using digest references, the digest from the reference is validated even before signature verification starts.)\n\n         {\"type\":\"matchRepoDigestOrExact\"}\n\n              • The identity in the signature must be in the same repository as the image identity.  This is useful e.g. to pull an image using the :latest tag when the image is signed  with\n                a tag specifying an exact image version.\n\n         {\"type\":\"matchRepository\"}\n\n              • The identity in the signature must exactly match a specified identity.  This is useful e.g. when locally mirroring images signed using their public identity.\n\n         {\n             \"type\": \"exactReference\",\n             \"dockerReference\": docker_reference_value\n         }\n\n              • The identity in the signature must be in the same repository as a specified identity.  This combines the properties of matchRepository and exactReference.\n\n         {\n             \"type\": \"exactRepository\",\n             \"dockerRepository\": docker_repository_value\n         }\n\n              • Prefix remapping:\n\n       If the image identity matches the specified prefix, that prefix is replaced by the specified “signed prefix”\n         (otherwise it is used as unchanged and no remapping takes place);\n         matching then follows the matchRepoDigestOrExact semantics documented above\n         (i.e. if the image identity carries a tag, the identity in the signature must exactly match,\n         if it uses a digest reference, the repository must match).\n\n       The prefix and signedPrefix values can be either host[:port] values\n         (matching exactly the same host[:port], string),\n         repository namespaces, or repositories (i.e. they must not contain tags/digests),\n         and match as prefixes of the fully expanded form.\n         For example, docker.io/library/busybox (not busybox) to specify that single repository,\n         or docker.io/library (not an empty string) to specify the parent namespace of docker.io/library/busybox==busybox).\n\n       The prefix value is usually the same as the scope containing the parent signedBy requirement.\n\n         {\n             \"type\": \"remapIdentity\",\n             \"prefix\": prefix,\n             \"signedPrefix\": prefix,\n         }\n\n       If the signedIdentity field is missing, it is treated as matchRepoDigestOrExact.\n\n       Note:  matchExact,  matchRepoDigestOrExact  and matchRepository can be only used if a Docker-like image identity is provided by the transport.  In particular, the dir: and oci: trans‐\n       ports can be only used with exactReference or exactRepository.\n\n   sigstoreSigned\n       This requirement requires an image to be signed using a sigstore signature with an expected identity and key.\n\n       {\n           \"type\":    \"sigstoreSigned\",\n           \"keyPath\": \"/path/to/local/public/key/file\",\n           \"keyPaths\": [\"/path/to/first/public/key/one\", \"/path/to/first/public/key/two\"],\n           \"keyData\": \"base64-encoded-public-key-data\",\n           \"keyDatas\": [\"base64-encoded-public-key-one-data\", \"base64-encoded-public-key-two-data\"]\n           \"fulcio\": {\n               \"caPath\": \"/path/to/local/CA/file\",\n               \"caData\": \"base64-encoded-CA-data\",\n               \"oidcIssuer\": \"https://expected.OIDC.issuer/\",\n               \"subjectEmail\", \"expected-signing-user@example.com\",\n           },\n           \"pki\": {\n               \"caRootsPath\": \"/path/to/local/CARoots/file\",\n               \"caRootsData\": \"base64-encoded-CARoots-data\",\n               \"caIntermediatesPath\": \"/path/to/local/CAIntermediates/file\",\n               \"caIntermediatesData\": \"base64-encoded-CAIntermediates-data\",\n               \"subjectHostname\": \"expected-signing-hostname.example.com\",\n               \"subjectEmail\": \"expected-signing-user@example.com\"\n           },\n           \"rekorPublicKeyPath\": \"/path/to/local/public/key/file\",\n           \"rekorPublicKeyPaths\": [\"/path/to/local/public/key/one\",\"/path/to/local/public/key/two\"],\n           \"rekorPublicKeyData\": \"base64-encoded-public-key-data\",\n           \"rekorPublicKeyDatas\": [\"base64-encoded-public-key-one-data\",\"base64-encoded-public-key-two-data\"],\n           \"signedIdentity\": identity_requirement\n       }\n\n       Exactly one of keyPath, keyPaths, keyData, keyDatas, fulcio and pki must be present.\n\n       If keyPath or keyData is present, it contains a sigstore public key.  Only signatures made by this key are accepted.\n\n       If keyPaths or keyDatas is present, it contains sigstore public keys.  Only signatures made by any key in the list are accepted.\n\n       If fulcio is present, the signature must be based on a Fulcio-issued certificate.  One of caPath and caData must be specified, containing the public key of the Fulcio instance.   Both\n       oidcIssuer and subjectEmail are mandatory, exactly specifying the expected identity provider, and the identity of the user obtaining the Fulcio certificate.\n\n       If  pki is present, the signature must be based on a non-Fulcio X.509 certificate.  One of caRootsPath and caRootsData must be specified, containing certificates of the CAs.  Only one\n       of caIntermediatesPath and caIntermediatesData can be present, containing certificates of the intermediate CAs.  One of subjectEmail and subjectHostname  must  be  specified,  exactly\n       specifying the expected identity to which the certificate was issued.\n\n       At  most  one  of rekorPublicKeyPath, rekorPublicKeyPaths, rekorPublicKeyData and rekorPublicKeyDatas can be present; it is mandatory if fulcio is specified.  If a Rekor public key is\n       specified, the signature must have been uploaded to a Rekor server and the signature must contain an (offline-verifiable) “signed entry timestamp” proving the existence of  the  Rekor\n       log record, signed by one of the provided public keys.\n\n       The signedIdentity field has the same semantics as in the signedBy requirement described above.  Note that cosign-created signatures only contain a repository, so only matchRepository\n       and exactRepository can be used to accept them (and that does not protect against substitution of a signed image with an unexpected tag).\n\n       To  use  this  with  images hosted on image registries, the use-sigstore-attachments option needs to be enabled for the relevant registry or repository in the client's containers-reg‐\n       istries.d(5).\n\nExamples\n       It is strongly recommended to set the default policy to reject, and then selectively allow individual transports and scopes as desired.\n\n   A reasonably locked-down system\n       (Note that the /*…*/ comments are not valid in JSON, and must not be used in real policies.)\n\n       {\n           \"default\": [{\"type\": \"reject\"}], /* Reject anything not explicitly allowed */\n           \"transports\": {\n               \"docker\": {\n                   /* Allow installing images from a specific repository namespace, without cryptographic verification.\n                      This namespace includes images like openshift/hello-openshift and openshift/origin. */\n                   \"docker.io/openshift\": [{\"type\": \"insecureAcceptAnything\"}],\n                   /* Similarly, allow installing the “official” busybox images.  Note how the fully expanded\n                      form, with the explicit /library/, must be used. */\n                   \"docker.io/library/busybox\": [{\"type\": \"insecureAcceptAnything\"}],\n                   /* Allow installing images from all subdomains */\n                   \"*.temporary-project.example.com\": [{\"type\": \"insecureAcceptAnything\"}],\n                   /* A sigstore-signed repository */\n                   \"hostname:5000/myns/sigstore-signed-with-full-references\": [\n                       {\n                           \"type\": \"sigstoreSigned\",\n                           \"keyPath\": \"/path/to/sigstore-pubkey.pub\"\n                       }\n                   ],\n                   /* A sigstore-signed repository using the community Fulcio+Rekor servers.\n\n                      The community servers’ public keys can be obtained from\n                      https://github.com/sigstore/sigstore/tree/main/pkg/tuf/repository/targets .  */\n                   \"hostname:5000/myns/sigstore-signed-fulcio-rekor\": [\n                       {\n                           \"type\": \"sigstoreSigned\",\n                           \"fulcio\": {\n                               \"caPath\": \"/path/to/fulcio_v1.crt.pem\",\n                               \"oidcIssuer\": \"https://github.com/login/oauth\",\n                               \"subjectEmail\": \"test-user@example.com\"\n                           },\n                           \"rekorPublicKeyPath\": \"/path/to/rekor.pub\",\n                       }\n                   ],\n                   /* A Sigstore-signed repository using a certificate generated by a custom public-key infrastructure.*/\n                   \"hostname:5000/myns/sigstore-signed-byopki\": [\n                       {\n                           \"type\": \"sigstoreSigned\",\n                           \"pki\": {\n                               \"caRootsPath\": \"/path/to/pki_root_crts.pem\",\n                               \"caIntermediatesPath\": \"/path/to/pki_intermediate_crts.pem\",\n                               \"subjectHostname\": \"test-user.example.com\"\n                               \"subjectEmail\": \"test-user@example.com\"\n                           }\n                       }\n                   ],\n                   /* A sigstore-signed repository, accepts signatures by /usr/bin/cosign */\n                   \"hostname:5000/myns/sigstore-signed-allows-malicious-tag-substitution\": [\n                       {\n                           \"type\": \"sigstoreSigned\",\n                           \"keyPath\": \"/path/to/sigstore-pubkey.pub\",\n                           \"signedIdentity\": {\"type\": \"matchRepository\"}\n                       }\n                   ],\n                   /* A sigstore-signed repository using the community Fulcio+Rekor servers,\n                      accepts signatures by /usr/bin/cosign.\n\n                      The community servers’ public keys can be obtained from\n                      https://github.com/sigstore/sigstore/tree/main/pkg/tuf/repository/targets .  */\n                   \"hostname:5000/myns/sigstore-signed-fulcio-rekor- allows-malicious-tag-substitution\": [\n                       {\n                           \"type\": \"sigstoreSigned\",\n                           \"fulcio\": {\n                               \"caPath\": \"/path/to/fulcio_v1.crt.pem\",\n                               \"oidcIssuer\": \"https://github.com/login/oauth\",\n                               \"subjectEmail\": \"test-user@example.com\"\n                           },\n                           \"rekorPublicKeyPath\": \"/path/to/rekor.pub\",\n                           \"signedIdentity\": { \"type\": \"matchRepository\" }\n                       }\n                   ]\n                     /* Other docker: images use the global default policy and are rejected */\n               },\n               \"dir\": {\n                   \"\": [{\"type\": \"insecureAcceptAnything\"}] /* Allow any images originating in local directories */\n               },\n               \"atomic\": {\n                   /* The common case: using a known key for a repository or set of repositories */\n                   \"hostname:5000/myns/official\": [\n                       {\n                           \"type\": \"signedBy\",\n                           \"keyType\": \"GPGKeys\",\n                           \"keyPath\": \"/path/to/official-pubkey.gpg\"\n                       }\n                   ],\n                   /* A more complex example, for a repository which contains a mirror of a third-party product,\n                      which must be signed-off by local IT */\n                   \"hostname:5000/vendor/product\": [\n                       { /* Require the image to be signed by the original vendor, using the vendor's repository location. */\n                           \"type\": \"signedBy\",\n                           \"keyType\": \"GPGKeys\",\n                           \"keyPath\": \"/path/to/vendor-pubkey.gpg\",\n                           \"signedIdentity\": {\n                               \"type\": \"exactRepository\",\n                               \"dockerRepository\": \"vendor-hostname/product/repository\"\n                           }\n                       },\n                       { /* Require the image to _also_ be signed by a local reviewer. */\n                           \"type\": \"signedBy\",\n                           \"keyType\": \"GPGKeys\",\n                           \"keyPath\": \"/path/to/reviewer-pubkey.gpg\"\n                       }\n                   ],\n                   /* A way to mirror many repositories from a single vendor */\n                   \"private-mirror:5000/vendor-mirror\": [\n                       { /* Require the image to be signed by the original vendor, using the vendor's repository location.\n                            For example, private-mirror:5000/vendor-mirror/productA/image1:latest needs to be signed as\n                            vendor.example/productA/image1:latest . */\n                           \"type\": \"signedBy\",\n                           \"keyType\": \"GPGKeys\",\n                           \"keyPath\": \"/path/to/vendor-pubkey.gpg\",\n                           \"signedIdentity\": {\n                               \"type\": \"remapIdentity\",\n                               \"prefix\": \"private-mirror:5000/vendor-mirror\",\n                               \"signedPrefix\": \"vendor.example.com\"\n                           }\n                       }\n                   ]\n               }\n           }\n       }\n\n   Completely disable security, allow all images, do not trust any signatures\n       {\n           \"default\": [{\"type\": \"insecureAcceptAnything\"}]\n       }\n\nSEE ALSO\n       atomic(1)\n\nHISTORY\n       August 2018, Rename to containers-policy.json(5) by Valentin Rothberg vrothberg@suse.com ⟨mailto:vrothberg@suse.com⟩\n\n       September 2016, Originally compiled by Miloslav Trmač mitr@redhat.com ⟨mailto:mitr@redhat.com⟩\n\nMan                                                                                       policy.json                                                                CONTAINERS-POLICY.JSON(5)","ref":"containers-policy-json.html"},{"type":"extras","title":"containers-registries.conf.d","doc":"CONTAINERS-REGISTRIES.CONF.D(5)                                                       File Formats Manual                                                      CONTAINERS-REGISTRIES.CONF.D(5)\n\nValentin Rothberg Mar 2020\n\nNAME\n       containers-registries.conf.d - directory for drop-in registries.conf files\n\nDESCRIPTION\n       CONTAINERS-REGISTRIES.CONF.D is a system-wide directory for drop-in configuration files in the containers-registries.conf(5) format.\n\n       By default, the directory is located at /etc/containers/registries.conf.d.\n\nCONFIGURATION PRECEDENCE\n       Once  the  main  configuration at /etc/containers/registries.conf is loaded, the files in /etc/containers/registries.conf.d are loaded in alpha-numerical order. Then the conf files in\n       $HOME/.config/containers/registries.conf.d are loaded in alpha-numerical order, if they exist. If the $HOME/.config/containers/registries.conf is loaded, only  the  conf  files  under\n       $HOME/.config/containers/registries.conf.d  are  loaded  in alpha-numerical order.  Specified fields in a conf file will overwrite any previous setting.  Note that only files with the\n       .conf suffix are loaded, other files and sub-directories are ignored.\n\n       For instance, setting the unqualified-search-registries in /etc/containers/registries.conf.d/myregistries.conf will overwrite  previous  settings  in  /etc/containers/registries.conf.\n       The [[registry]] tables merged by overwriting existing items if the prefixes are identical while new ones are added.\n\n       All drop-in configuration files must be specified in the version 2 of the containers-registries.conf(5) format.\n\nSEE ALSO\n       containers-registries.conf(5)\n\nHISTORY\n       Mar 2020, Originally compiled by Valentin Rothberg rothberg@redhat.com ⟨mailto:rothberg@redhat.com⟩\n\n                                                                                                                                                               CONTAINERS-REGISTRIES.CONF.D(5)","ref":"containers-registries-conf-d.html"},{"type":"extras","title":"containers-registries.conf","doc":"CONTAINERS-REGISTRIES.CONF(5)                                                            configuration                                                           CONTAINERS-REGISTRIES.CONF(5)\n\nBrent Baude Aug 2017\n\nNAME\n       containers-registries.conf - Syntax of System Registry Configuration File\n\nDESCRIPTION\n       The CONTAINERS-REGISTRIES configuration file is a system-wide configuration file for container image registries. The file format is TOML.\n\n       Container engines will use the $HOME/.config/containers/registries.conf if it exists, otherwise they will use /etc/containers/registries.conf\n\n   GLOBAL SETTINGS\n       unqualified-search-registries\n              An array of host[:port] registries to try when pulling an unqualified image, in order.\n\n       credential-helpers\n              An  array  of default credential helpers used as external credential stores.  Note that \"containers-auth.json\" is a reserved value to use auth files as specified in containers-\n              auth.json(5).  The credential helpers are set to [\"containers-auth.json\"] if none are specified.\n\n       additional-layer-store-auth-helper\n              A string containing the helper binary name. This enables passing registry credentials to an Additional Layer Store every time an image is read using the docker:// transport  so\n              that it can access private registries. See the 'Enabling Additional Layer Store to access to private registries' section below for more details.\n\n   NAMESPACED [[registry]] SETTINGS\n       The  bulk  of  the  configuration is represented as an array of [[registry]] TOML tables; the settings may therefore differ among different registries as well as among different name‐\n       spaces/repositories within a registry.\n\n   Choosing a [[registry]] TOML table\n       Given an image name, a single [[registry]] TOML table is chosen based on its prefix field.\n\n       prefix: A prefix of the user-specified image name, i.e. using one of the following formats:\n         - host[:port]\n         - host[:port]/namespace[/_namespace_…]\n         - host[:port]/namespace[/_namespace_…]/repo\n         - host[:port]/namespace[/_namespace_…]/repo(:_tag|@digest)\n         - [*.]host\n\n       The user-specified image name must start with the specified prefix (and continue with the appropriate separator) for a particular [[registry]] TOML table to be considered; (only)  the\n       TOML table with the longest match is used. It can also include wildcarded subdomains in the format *.example.com.  The wildcard should only be present at the beginning as shown in the\n       formats  above. Other cases will not work. For example, *.example.com is valid but example.*.com, *.example.com/foo and *.example.com:5000/foo/bar:baz are not.  Note that * matches an\n       arbitrary number of subdomains. *.example.com will hence match bar.example.com, foo.bar.example.com and so on.\n\n       As a special case, the prefix field can be missing; if so, it defaults to the value of the location field (described below).\n\n   Per-namespace settings\n       insecure\n              true or false.  By default, container runtimes require TLS when retrieving images from a registry.  If insecure is set to true, unencrypted HTTP as well as TLS connections with\n              untrusted certificates are allowed.\n\n       blocked\n              true or false.  If true, pulling images with matching names is forbidden.\n\n   Remapping and mirroring registries\n       The user-specified image reference is, primarily, a \"logical\" image name, always used for naming the image.  By default, the image reference also directly specifies the  registry  and\n       repository  to use, but the following options can be used to redirect the underlying accesses to different registry servers or locations (e.g. to support configurations with no access\n       to the internet without having to change Dockerfiles, or to add redundancy).\n\n       location\n              Accepts the same format as the prefix field, and specifies the physical location of the prefix-rooted namespace.\n\n       By default, this is equal to prefix (in which case prefix can be omitted and the [[registry]] TOML table can only specify location).\n\n       Example: Given\n\n       prefix = \"example.com/foo\"\n       location = \"internal-registry-for-example.com/bar\"\n\n       requests for the image example.com/foo/myimage:latest will actually work with the internal-registry-for-example.com/bar/myimage:latest image.\n\n       With a prefix containing a wildcard in the format: \"*.example.com\" for subdomain matching, the location can be empty. In such a case, prefix matching  will  occur,  but  no  reference\n       rewrite will occur. The original requested image string will be used as-is. But other settings like insecure / blocked / mirrors will be applied to matching images.\n\n       Example: Given\n\n       prefix = \"*.example.com\"\n\n       requests for the image blah.example.com/foo/myimage:latest will be used as-is. But other settings like insecure/blocked/mirrors will be applied to matching images\n\n       mirror An array of TOML tables specifying (possibly-partial) mirrors for the prefix-rooted namespace (i.e., the current [[registry]] TOML table).\n\n       The  mirrors  are attempted in the specified order; the first one that can be contacted and contains the image will be used (and if none of the mirrors contains the image, the primary\n       location specified by the registry.location field, or using the unmodified user-specified reference, is tried last).\n\n       Each TOML table in the mirror array can contain the following fields: - location： same semantics as specified in the [[registry]] TOML table - insecure： same semantics as  specified\n       in  the [[registry]] TOML table - pull-from-mirror: all, digest-only or tag-only.  If \"digest-only\"， mirrors will only be used for digest pulls. Pulling images by tag can potentially\n       yield different images, depending on which endpoint we pull from.  Restricting mirrors to pulls by digest avoids that issue.  If \"tag-only\", mirrors will only be used for  tag  pulls.\n       For a more up-to-date and expensive mirror that it is less likely to be out of sync if tags move, it should not be unnecessarily used for digest references.  Default is \"all\" (or left\n       empty),  mirrors  will be used for both digest pulls and tag pulls unless the mirror-by-digest-only is set for the primary registry.  Note that this per-mirror setting is allowed only\n       when mirror-by-digest-only is not configured for the primary registry.\n\n       mirror-by-digest-only\n              true or false.  If true, mirrors will only be used during pulling if the image reference includes a digest.  Note that if all mirrors are configured to be  digest-only,  images\n              referenced by a tag will only use the primary registry.  If all mirrors are configured to be tag-only, images referenced by a digest will only use the primary registry.\n\n       Referencing an image by digest ensures that the same is always used (whereas referencing an image by a tag may cause different registries to return different images if the tag mapping\n       is out of sync).\n\n       Note:  Redirection  and  mirrors are currently processed only when reading a single image, not when pushing to a registry nor when doing any other kind of lookup/search on a on a reg‐\n       istry.  This may change in the future.\n\n   Short-Name Aliasing\n       The use of unqualified-search registries entails an ambiguity as it is unclear from which registry a given image, referenced by a short name, may be pulled from.\n\n       As mentioned in the note at the end of this man page, using short names is subject to the risk of hitting squatted registry namespaces.  If the unqualified-search registries  are  set\n       to  [\"registry1.com\",  \"registry2.com\"]  an attacker may take over a namespace of registry1.com such that an image may be pulled from registry1.com instead of the intended source reg‐\n       istry2.com.\n\n       While it is highly recommended to always use fully-qualified image references, existing deployments using short names may not be easily changed.  To circumvent the aforementioned  am‐\n       biguity, so called short-name aliases can be configured that point to a fully-qualified image reference.\n\n       Short-name  aliases  can be configured in the [aliases] table in the form of \"name\"=\"value\" with the left-hand name being the short name (e.g., \"image\") and the right-hand value being\n       the fully-qualified image reference (e.g., \"registry.com/namespace/image\").  Note that neither \"name\" nor \"value\" can include a tag or digest.  Moreover, \"name\" must be a  short  name\n       and hence cannot include a registry domain or refer to localhost.\n\n       When  pulling  a  short name, the configured aliases table will be used for resolving the short name.  If a matching alias is found, it will be used without further consulting the un‐\n       qualified-search registries list.  If no matching alias is found, the behavior can be controlled via the short-name-mode option as described below.\n\n       Note that tags and digests are stripped off a user-specified short name for alias resolution.  Hence, \"image\", \"image:tag\" and \"image@digest\" all resolve to the same alias (i.e., \"im‐\n       age\").  Stripped off tags and digests are later appended to the resolved alias.\n\n       Further note that drop-in configuration files (see containers-registries.conf.d(5)) can override aliases in the specific loading order of the files.  If the \"value\"  of  an  alias  is\n       empty (i.e., \"\"), the alias will be erased.  However, a given \"name\" may only be specified once in a single config file.\n\n   Short-Name Aliasing: Modes\n       The short-name-mode option supports three modes to control the behaviour of short-name resolution.\n\n              • enforcing:  If only one unqualified-search registry is set, use it as there is no ambiguity.  If there is more than one registry and the user program is running in a terminal\n                (i.e., stdout & stdin are a TTY), prompt the user to select one of the specified search registries.  If the program is not running in a terminal, the ambiguity cannot be  re‐\n                solved which will lead to an error.\n\n              • permissive: Behaves as enforcing but does not lead to an error if the program is not running in a terminal.  Instead, fallback to using all unqualified-search registries.\n\n              • disabled: Use all unqualified-search registries without prompting.\n\n       If  short-name-mode is not specified at all or left empty, default to the permissive mode.  If the user-specified short name was not aliased already, the enforcing and permissive mode\n       if prompted, will record a new alias after a successful pull.  Note that the recorded alias will be written to /var/cache/containers/short-name-aliases.conf for root to have  a  clear\n       separation  between  possibly human-edited registries.conf files and the machine-generated short-name-aliases-conf.  Note that $HOME/.cache is used for rootless users.  If an alias is\n       specified in a registries.conf file and also the machine-generated short-name-aliases.conf, the short-name-aliases.conf file has precedence.\n\n   Normalization of docker.io references\n       The Docker Hub docker.io is handled in a special way: every push and pull operation gets internally normalized with /library if no other specific namespace is defined (for example  on\n       docker.io/namespace/image).\n\n       (Note that the above-described normalization happens to match the behavior of Docker.)\n\n       This means that a pull of docker.io/alpine will be internally translated to docker.io/library/alpine. A pull of docker.io/user/alpine will not be rewritten because this is already the\n       correct remote path.\n\n       Therefore,  to  remap  or mirror the docker.io images in the (implied) /library namespace (or that whole namespace), the prefix and location fields in this configuration file must ex‐\n       plicitly include that /library namespace. For example prefix = \"docker.io/library/alpine\" and not prefix = \"docker.io/alpine\". The latter would match the docker.io/alpine/*  reposito‐\n       ries but not the docker.io/[library/]alpine image).\n\n   EXAMPLE\n       unqualified-search-registries = [\"example.com\"]\n\n       [[registry]]\n       prefix = \"example.com/foo\"\n       insecure = false\n       blocked = false\n       location = \"internal-registry-for-example.com/bar\"\n\n       [[registry.mirror]]\n       location = \"example-mirror-0.local/mirror-for-foo\"\n\n       [[registry.mirror]]\n       location = \"example-mirror-1.local/mirrors/foo\"\n       insecure = true\n\n       [[registry]]\n       location = \"registry.com\"\n\n       [[registry.mirror]]\n       location = \"mirror.registry.com\"\n\n       Given the above, a pull of example.com/foo/image:latest will try:\n\n                1. example-mirror-0.local/mirror-for-foo/image:latest\n\n                2. example-mirror-1.local/mirrors/foo/image:latest\n\n                3. internal-registry-for-example.com/bar/image:latest\n\n       in order, and use the first one that exists.\n\n       Note  that  a  mirror is associated only with the current [[registry]] TOML table. If using the example above, pulling the image registry.com/image:latest will hence only reach out to\n       mirror.registry.com, and the mirrors associated with example.com/foo will not be considered.\n\n   Enabling Additional Layer Store to access to private registries\n       The additional-layer-store-auth-helper option enables passing registry credentials to an Additional Layer Store so that it can access private registries.\n\n       When accessing a private registry via an Additional Layer Store, a helper binary needs to be provided. This helper binary is registered via the additional-layer-store-auth-helper  op‐\n       tion. Every time an image is read using the docker:// transport, the specified helper binary is executed and receives registry credentials from stdin in the following format.\n\n       {\n         \"$image_reference\": {\n           \"username\": \"$username\",\n           \"password\": \"$password\",\n           \"identityToken\": \"$identityToken\"\n         }\n       }\n\n       The format of $image_reference is $repo{:$tag|@$digest}.\n\n       Additional Layer Stores can use this helper binary to access the private registry.\n\nVERSION 1 FORMAT - DEPRECATED\n       VERSION 1 format is still supported but it does not support using registry mirrors, longest-prefix matches, or location rewriting.\n\n       The  TOML  format  is used to build a simple list of registries under three categories: registries.search, registries.insecure, and registries.block.  You can list multiple registries\n       using a comma separated list.\n\n       Search registries are used when the caller of a container runtime does not fully specify the container image that they want to execute.  These registries are prepended onto the  front\n       of the specified container image until the named image is found at a registry.\n\n       Note that insecure registries can be used for any registry, not just the registries listed under search.\n\n       The registries.insecure and registries.block lists have the same meaning as the insecure and blocked fields in the current version.\n\n   EXAMPLE\n       The following example configuration defines two searchable registries, one insecure registry, and two blocked registries.\n\n       [registries.search]\n       registries = ['registry1.com', 'registry2.com']\n\n       [registries.insecure]\n       registries = ['registry3.com']\n\n       [registries.block]\n       registries = ['registry.untrusted.com', 'registry.unsafe.com']\n\nNOTE: RISK OF USING UNQUALIFIED IMAGE NAMES\n       We  recommend  always  using fully qualified image names including the registry server (full dns name), namespace, image name, and tag (e.g., registry.redhat.io/ubi8/ubi:latest). When\n       using short names, there is always an inherent risk that the image being pulled could be spoofed. For example, a user wants to pull an image named foobar from a registry  and  expects\n       it  to come from myregistry.com. If myregistry.com is not first in the search list, an attacker could place a different foobar image at a registry earlier in the search list. The user\n       would accidentally pull and run the attacker's image and code rather than the intended content. We recommend only adding registries which are completely trusted, i.e. registries which\n       don't allow unknown or anonymous users to create accounts with arbitrary names. This will prevent an image from being spoofed, squatted or otherwise made insecure.  If it is necessary\n       to use one of these registries, it should be added at the end of the list.\n\n       It is recommended to use fully-qualified images for pulling as the destination registry is unambiguous. Pulling by digest (i.e., quay.io/repository/name@digest) further eliminates the\n       ambiguity of tags.\n\nSEE ALSO\n       containers-auth.json(5) containers-certs.d(5)\n\nHISTORY\n       Dec 2019, Warning added for unqualified image names by Tom Sweeney tsweeney@redhat.com ⟨mailto:tsweeney@redhat.com⟩\n\n       Mar 2019, Added additional configuration format by Sascha Grunert sgrunert@suse.com ⟨mailto:sgrunert@suse.com⟩\n\n       Aug 2018, Renamed to containers-registries.conf(5) by Valentin Rothberg vrothberg@suse.com ⟨mailto:vrothberg@suse.com⟩\n\n       Jun 2018, Updated by Tom Sweeney tsweeney@redhat.com ⟨mailto:tsweeney@redhat.com⟩\n\n       Aug 2017, Originally compiled by Brent Baude bbaude@redhat.com ⟨mailto:bbaude@redhat.com⟩\n\nregistry                                                                                  System-wide                                                            CONTAINERS-REGISTRIES.CONF(5)","ref":"containers-registries-conf.html"},{"type":"extras","title":"containers-registries.d","doc":"containers-registries.d(5)                                                                   Page                                                                   containers-registries.d(5)\n\nMiloslav Trmač August 2016\n\nNAME\n       containers-registries.d - Directory for various registries configurations\n\nDESCRIPTION\n       The  registries configuration directory contains configuration for various registries (servers storing remote container images), and for content stored in them, so that the configura‐\n       tion does not have to be provided in command-line options over and over for every command, and so that it can be shared by all users of containers/image.\n\n       By default, the registries configuration directory is $HOME/.config/containers/registries.d if it exists, otherwise /etc/containers/registries.d (unless overridden  at  compile-time);\n       applications may allow using a different directory instead.\n\nDirectory Structure\n       The directory may contain any number of files with the extension .yaml, each using the YAML format.  Other than the mandatory extension, names of the files don’t matter.\n\n       The  contents  of  these  files  are merged together; to have a well-defined and easy to understand behavior, there can be only one configuration section describing a single namespace\n       within a registry (in particular there can be at most one one default-docker section across all files, and there can be at most one instance of any key under the docker section; these\n       sections are documented later).\n\n       Thus, it is forbidden to have two conflicting configurations for a single registry or scope, and it is also forbidden to split a configuration for a single registry  or  scope  across\n       more than one file (even if they are not semantically in conflict).\n\nRegistries, Scopes and Search Order\n       Each YAML file must contain a “YAML mapping” (key-value pairs).  Two top-level keys are defined:\n\n              • default-docker is the configuration section (as documented below) for registries implementing \"Docker Registry HTTP API V2\".\n\n       This key is optional.\n\n              • docker  is  a mapping, using individual registries implementing \"Docker Registry HTTP API V2\", or namespaces and individual images within these registries, as keys; the value\n                assigned to any such key is a configuration section.\n\n       This key is optional.\n\n       Scopes matching individual images are named Docker references in the fully expanded form, either\n          using a tag or digest. For example, docker.io/library/busybox:latest (not busybox:latest).\n\n       More general scopes are prefixes of individual-image scopes, and specify a repository (by omitting the tag or digest),\n          a repository namespace, or a registry host (and a port if it differs from the default).\n\n       Note that if a registry is accessed using a hostname+port configuration, the port-less hostname\n          is not used as parent scope.\n\n       When searching for a configuration to apply for an individual container image, only the configuration for the most-precisely matching scope is used; configuration using  more  general\n       scopes  is  ignored.   For example, if any configuration exists for docker.io/library/busybox, the configuration for docker.io is ignored (even if some element of the configuration is\n       defined for docker.io and not for docker.io/library/busybox).\n\n   Built-in Defaults\n       If no docker section can be found for the container image, and no default-docker section is configured:\n\n              • The default directory, /var/lib/containers/sigstore for root and $HOME/.local/share/containers/sigstore for unprivileged user,  will be used for reading  and  writing  signa‐\n                tures.\n\n              • Sigstore attachments will not be read/written.\n\nIndividual Configuration Sections\n       A single configuration section is selected for a container image using the process described above.  The configuration section is a YAML mapping, with the following keys:\n\n              • lookaside-staging defines an URL of of the signature storage, used for editing it (adding or deleting signatures).\n\n       This key is optional; if it is missing, lookaside below is used.\n\n              • lookaside  defines  an  URL  of the signature storage.  This URL is used for reading existing signatures, and if lookaside-staging does not exist, also for adding or removing\n                them.\n\n       This key is optional; if it is missing, no signature storage is defined (no signatures\n          are download along with images, adding new signatures is possible only if lookaside-staging is defined).\n\n              • use-sigstore-attachments specifies whether sigstore image attachments (signatures, attestations and the like) are going to be read/written along with the image.  If disabled,\n                the images are treated as if no attachments exist; attempts to write attachments fail.\n\nExamples\n   Using Containers from Various Origins\n       The following demonstrates how to to consume and run images from various registries and namespaces:\n\n       docker:\n           registry.database-supplier.com:\n               lookaside: https://lookaside.database-supplier.com\n           distribution.great-middleware.org:\n               lookaside: https://security-team.great-middleware.org/lookaside\n           docker.io/web-framework:\n               lookaside: https://lookaside.web-framework.io:8080\n\n   Developing and Signing Containers, Staging Signatures\n       For developers in example.com:\n\n              • Consume most container images using the public servers also used by clients.\n\n              • Use a separate signature storage for an container images in a namespace corresponding to the developers' department, with a staging storage used before publishing signatures.\n\n              • Craft an individual exception for a single branch a specific developer is working on locally.\n\n       docker:\n           registry.example.com:\n               lookaside: https://registry-lookaside.example.com\n           registry.example.com/mydepartment:\n               lookaside: https://lookaside.mydepartment.example.com\n               lookaside-staging: file:///mnt/mydepartment/lookaside-staging\n           registry.example.com/mydepartment/myproject:mybranch:\n               lookaside: http://localhost:4242/lookaside\n               lookaside-staging: file:///home/useraccount/webroot/lookaside\n\n   A Global Default\n       If a company publishes its products using a different domain, and different registry hostname for each of them, it is still possible to use a single signature storage  server  without\n       listing each domain individually. This is expected to rarely happen, usually only for staging new signatures.\n\n       default-docker:\n           lookaside-staging: file:///mnt/company/common-lookaside-staging\n\nAUTHORS\n       Miloslav Trmač mitr@redhat.com ⟨mailto:mitr@redhat.com⟩\n\nMan                                                                                      Registries.d                                                               containers-registries.d(5)","ref":"containers-registries-d.html"},{"type":"extras","title":"containers-signature","doc":"container-signature(5)                                                                      format                                                                      container-signature(5)\n\nMiloslav Trmač March 2017\n\nNAME\n       container-signature - Container signature format\n\nDESCRIPTION\n       This document describes the format of container signatures, as implemented by the github.com/containers/image/signature package.\n\n       Most  users  should  be able to consume these signatures by using the github.com/containers/image/signature package (preferably through the higher-level signature.PolicyContext inter‐\n       face) without having to care about the details of the format described below.  This documentation exists primarily for maintainers of the package and to allow independent  reimplemen‐\n       tations.\n\nHigh-level overview\n       The  signature provides an end-to-end authenticated claim that a container image has been approved by a specific party (e.g. the creator of the image as their work, an automated build\n       system as a result of an automated build, a company IT department approving the image for production) under a specified identity (e.g. an OS base image / specific application, with  a\n       specific version).\n\n       A  container  signature consists of a cryptographic signature which identifies and authenticates who signed the image, and carries as a signed payload a JSON document.  The JSON docu‐\n       ment identifies the image being signed, claims a specific identity of the image and if applicable, contains other information about the image.\n\n       The signatures do not modify the container image (the layers, configuration, manifest, …); e.g. their presence does not change the manifest  digest  used  to  identify  the  image  in\n       docker/distribution  servers;  rather, the signatures are associated with an immutable image.  An image can have any number of signatures so signature distribution systems SHOULD sup‐\n       port associating more than one signature with an image.\n\nThe cryptographic signature\n       As distributed, the container signature is a blob which contains a cryptographic signature in an industry-standard format, carrying a signed JSON payload (i.e. the blob contains  both\n       the JSON document and a signature of the JSON document; it is not a “detached signature” with independent blobs containing the JSON document and a cryptographic signature).\n\n       Currently  the  only defined cryptographic signature format is an OpenPGP signature (RFC 4880), but others may be added in the future.  (The blob does not contain metadata identifying\n       the cryptographic signature format. It is expected that most formats are sufficiently self-describing that this is not necessary and the configured expected public  key  provides  an‐\n       other indication of the expected cryptographic signature format. Such metadata may be added in the future for newly added cryptographic signature formats, if necessary.)\n\n       Consumers  of  container signatures SHOULD verify the cryptographic signature against one or more trusted public keys (e.g. defined in a policy.json signature verification policy file\n       ⟨containers-policy.json.5.md⟩) before parsing or processing the JSON payload in any way, in particular they SHOULD stop processing the container signature if the cryptographic  signa‐\n       ture verification fails, without even starting to process the JSON payload.\n\n       (Consumers  MAY extract identification of the signing key and other metadata from the cryptographic signature, and the JSON payload, without verifying the signature, if the purpose is\n       to allow managing the signature blobs, e.g. to list the authors and image identities of signatures associated with a single container image; if so, they SHOULD design  the  output  of\n       such processing to minimize the risk of users considering the output trusted or in any way usable for making policy decisions about the image.)\n\n   OpenPGP signature verification\n       When  verifying  a cryptographic signature in the OpenPGP format, the consumer MUST verify at least the following aspects of the signature (like the github.com/containers/image/signa‐\n       ture package does):\n\n              • The blob MUST be a “Signed Message” as defined RFC 4880 section 11.3.  (e.g. it MUST NOT be an unsigned “Literal Message”, a “Cleartext Signature” as defined in RFC 4880 sec‐\n                tion 7, or any other non-signature format).\n\n              • The signature MUST have been made by an expected key trusted for the purpose (and the specific container image).\n\n              • The signature MUST be correctly formed and pass the cryptographic validation.\n\n              • The signature MUST correctly authenticate the included JSON payload (in particular, the parsing of the JSON payload MUST NOT start before the complete payload has been  cryp‐\n                tographically authenticated).\n\n              • The signature MUST NOT be expired.\n\n       The consumer SHOULD have tests for its verification code which verify that signatures failing any of the above are rejected.\n\nJSON processing and forward compatibility\n       The  payload  of  the  cryptographic signature is a JSON document (RFC 7159).  Consumers SHOULD parse it very strictly, refusing any signature which violates the expected format (e.g.\n       missing members, incorrect member types) or can be interpreted ambiguously (e.g. a duplicated member in a JSON object).\n\n       Any violations of the JSON format or of other requirements in this document MAY be accepted if the JSON document can be recognized to have been created by a known-incorrect  implemen‐\n       tation (see ⟨#optionalcreator⟩ below) and if the semantics of the invalid document, as created by such an implementation, is clear.\n\n       The top-level value of the JSON document MUST be a JSON object with exactly two members, critical and optional, each a JSON object.\n\n       The  critical  object  MUST  contain  a type member identifying the document as a container signature (as defined below ⟨#criticaltype⟩) and signature consumers MUST reject signatures\n       which do not have this member or in which this member does not have the expected value.\n\n       To ensure forward compatibility (allowing older signature consumers to correctly accept or reject signatures created at a later date, with possible extensions to  this  format),  con‐\n       sumers  MUST  reject  the signature if the critical object, or any of its subobjects, contain any member or data value which is unrecognized, unsupported, invalid, or in any other way\n       unexpected.  At a minimum, this includes unrecognized members in a JSON object, or incorrect types of expected members.\n\n       For the same reason, consumers SHOULD accept any members with unrecognized names in the optional object, and MAY accept signatures where the object member  is  recognized  but  unsup‐\n       ported, or the value of the member is unsupported.  Consumers still SHOULD reject signatures where a member of an optional object is supported but the value is recognized as invalid.\n\nJSON data format\n       An example of the full format follows, with detailed description below.  To reiterate, consumers of the signature SHOULD perform successful cryptographic verification, and MUST reject\n       unexpected data in the critical object, or in the top-level object, as described above.\n\n       {\n           \"critical\": {\n               \"type\": \"atomic container signature\",\n               \"image\": {\n                   \"docker-manifest-digest\": \"sha256:817a12c32a39bbe394944ba49de563e085f1d3c5266eb8e9723256bc4448680e\"\n               },\n               \"identity\": {\n                   \"docker-reference\": \"docker.io/library/busybox:latest\"\n               }\n           },\n           \"optional\": {\n               \"creator\": \"some software package v1.0.1-35\",\n               \"timestamp\": 1483228800,\n           }\n       }\n\n   critical\n       This MUST be a JSON object which contains data critical to correctly evaluating the validity of a signature.\n\n       Consumers MUST reject any signature where the critical object contains any unrecognized, unsupported, invalid or in any other way unexpected member or data.\n\n   critical.type\n       This MUST be a string with a string value exactly equal to atomic container signature (three words, including the spaces).\n\n       Signature consumers MUST reject signatures which do not have this member or this member does not have exactly the expected value.\n\n       (The  consumers  MAY  support  signatures  with a different value of the type member, if any is defined in the future; if so, the rest of the JSON document is interpreted according to\n       rules defining that value of critical.type, not by this document.)\n\n   critical.image\n       This MUST be a JSON object which identifies the container image this signature applies to.\n\n       Consumers MUST reject any signature where the critical.image object contains any unrecognized, unsupported, invalid or in any other way unexpected member or data.\n\n       (Currently only the docker-manifest-digest way of identifying a container image is defined; alternatives to this may be defined in the future, but existing consumers are  required  to\n       reject signatures which use formats they do not support.)\n\n   critical.image.docker-manifest-digest\n       This MUST be a JSON string, in the github.com/opencontainers/go-digest.Digest string format.\n\n       The value of this member MUST match the manifest of the signed container image, as implemented in the docker/distribution manifest addressing system.\n\n       The  consumer of the signature SHOULD verify the manifest digest against a fully verified signature before processing the contents of the image manifest in any other way (e.g. parsing\n       the manifest further or downloading layers of the image).\n\n       Implementation notes: * A single container image manifest may have several valid manifest digest values, using different algorithms.   *  For  “signed”  docker/distribution  schema  1\n       ⟨https://github.com/docker/distribution/blob/master/docs/spec/manifest-v2-1.md⟩  manifests,  the manifest digest applies to the payload of the JSON web signature, not to the raw mani‐\n       fest blob.\n\n   critical.identity\n       This MUST be a JSON object which identifies the claimed identity of the image (usually the purpose of the image, or the application, along with a version information), as asserted  by\n       the author of the signature.\n\n       Consumers MUST reject any signature where the critical.identity object contains any unrecognized, unsupported, invalid or in any other way unexpected member or data.\n\n       (Currently  only  the  docker-reference way of claiming an image identity/purpose is defined; alternatives to this may be defined in the future, but existing consumers are required to\n       reject signatures which use formats they do not support.)\n\n   critical.identity.docker-reference\n       This MUST be a JSON string, in the github.com/docker/distribution/reference string format, and using the same normalization semantics  (where  e.g.  busybox:latest  is  equivalent  to\n       docker.io/library/busybox:latest).   If  the  normalization  semantics  allows  multiple  string  representations  of  the claimed identity with equivalent meaning, the critical.iden‐\n       tity.docker-reference member SHOULD use the fully explicit form (including the full host name and namespaces).\n\n       The value of this member MUST match the image identity/purpose expected by the consumer of the image signature and the image (again, accounting for  the  docker/distribution/reference\n       normalization semantics).\n\n       In  the most common case, this means that the critical.identity.docker-reference value must be equal to the docker/distribution reference used to refer to or download the image.  How‐\n       ever, depending on the specific application, users or system administrators may accept less specific matches (e.g. ignoring the tag value in the signature when pulling the :latest tag\n       or when referencing an image by digest), or they may require critical.identity.docker-reference values with a completely different namespace to the reference used to refer to/download\n       the image (e.g. requiring a critical.identity.docker-reference value which identifies the image as coming from a supplier when fetching it from a company-internal mirror  of  approved\n       images).   The  software  performing  this verification SHOULD allow the users to define such a policy using the policy.json signature verification policy file format ⟨containers-pol‐\n       icy.json.5.md⟩.\n\n       The critical.identity.docker-reference value SHOULD contain either a tag or digest; in most cases, it SHOULD use a tag rather than a digest.  (See also  the  default  ⟨containers-pol‐\n       icy.json.5.md#signedby⟩.)\n\n   optional\n       This MUST be a JSON object.\n\n       Consumers  SHOULD  accept any members with unrecognized names in the optional object, and MAY accept a signature where the object member is recognized but unsupported, or the value of\n       the member is valid but unsupported.  Consumers still SHOULD reject any signature where a member of an optional object is supported but the value is recognized as invalid.\n\n   optional.creator\n       If present, this MUST be a JSON string, identifying the name and version of the software which has created the signature (identifying the low-level software  implementation;  not  the\n       top-level caller).\n\n       The contents of this string is not defined in detail; however each implementation creating container signatures:\n\n              • SHOULD define the contents to unambiguously define the software in practice (e.g. it SHOULD contain the name of the software, not only the version number)\n\n              • SHOULD  use  a  build  and versioning process which ensures that the contents of this string (e.g. an included version number) changes whenever the format or semantics of the\n                generated signature changes in any way; it SHOULD not be possible for two implementations which use a different format or semantics to have the same optional.creator value\n\n              • SHOULD use a format which is reasonably easy to parse in software (perhaps using a regexp), and which makes it easy enough to recognize a range of versions of a specific  im‐\n                plementation  (e.g.  the  version of the implementation SHOULD NOT be only a git hash, because they don’t have an easily defined ordering; the string should contain a version\n                number, or at least a date of the commit).\n\n       Consumers of container signatures MAY recognize specific values or sets of values of optional.creator (perhaps augmented with optional.timestamp), and MAY change their  processing  of\n       the  signature based on these values (usually to accommodate violations of this specification in past versions of the signing software which cannot be fixed retroactively), as long as\n       the semantics of the invalid document, as created by such an implementation, is clear.\n\n       If consumers of signatures do change their behavior based on the optional.creator value, they SHOULD take care that the way they  process  the  signatures  is  not  inconsistent  with\n       strictly  validating  signature  consumers.  (I.e. it is acceptable for a consumer to accept a signature based on a specific optional.creator value if other implementations would com‐\n       pletely reject the signature, but it would be very undesirable for the two kinds of implementations to accept the signature in different and inconsistent situations.)\n\n   optional.timestamp\n       If present, this MUST be a JSON number, which is representable as a 64-bit integer, and identifies the time when the signature was created as the number  of  seconds  since  the  UNIX\n       epoch (Jan 1 1970 00:00 UTC).\n\nsignature                                                                                  Container                                                                    container-signature(5)","ref":"containers-signature.html"},{"type":"extras","title":"containers-sigstore-signing-params.yaml","doc":"CONTAINERS-SIGSTORE-SIGNING-PARAMS.YAML(5)                                                parameters                                                CONTAINERS-SIGSTORE-SIGNING-PARAMS.YAML(5)\n\nMiloslav Trmač January 2023\n\nNAME\n       containers-sigstore-signing-params.yaml - syntax for the sigstore signing parameter file\n\nDESCRIPTION\n       Sigstore  signing  parameter  files are used to store options that may be required to create sigstore signatures.  There is no default location for these files; they are user-managed,\n       and used as inputs to a container image signing operation, e.g. skopeo copy --sign-by-sigstore=param-file.yaml or podman push --sign-by-sigstore=param-file.yaml .\n\nFORMAT\n       Sigstore signing parameter files use YAML.\n\n       Many parameters are optional, but the file must specify enough to create a signature; in particular either a private key, or Fulcio.\n\n   Signing with Private Keys\n              • privateKeyFile: path\n\n       Create a signature using a private key at path.\n          Existence of this field triggers the use of a private key.\n\n              • privateKeyPassphraseFile: passphrasePath\n\n       Read the passphrase required to use privateKeyFile from passphrasePath.\n          Optional: if this is not set, the user must provide the passphrase interactively.\n\n   Signing with Fulcio-generated Certificates\n       Instead of a static private key, the signing process generates a short-lived key pair and requests a Fulcio server to issue a certificate for that key pair, based on the user  authen‐\n       ticating to an OpenID Connect provider.\n\n       To specify Fulcio, include a fulcio sub-object with one or more of the following keys.  In addition, a Rekor server must be specified as well.\n\n              • fulcioURL: URL\n\n       Required. URL of the Fulcio server to use.\n\n              • oidcMode: interactive | deviceGrant | staticToken\n\n       Required. Specifies how to obtain the necessary OpenID Connect credential.\n\n       interactive opens a web browser on the same machine, or if that is not possible,\n         asks the user to open a browser manually and to type in the provided code.\n         It requires the user to be able to directly interact with the signing process.\n\n       deviceGrant uses a device authorization grant flow (RFC 8628).\n         It requires the user to be able to read text printed by the signing process, and to act on it reasonably promptly.\n\n       staticToken provides a pre-existing OpenID Connect “ID token”, which must have been obtained separately.\n\n              • oidcIssuerURL: URL\n\n       Required for oidcMode: interactive or deviceGrant. URL of an OpenID Connect issuer server to authenticate with.\n\n              • oidcClientID: client ID\n\n       Used for oidcMode: interactive or deviceGrant to identify the client when contacting the issuer.\n         Optional but likely to be necessary in those cases.\n\n              • oidcClientSecret: client secret\n\n       Used for oidcMode: interactive or deviceGrant to authenticate the client when contacting the issuer.\n         Optional.\n\n              • oidcIDToken: token\n\n       Required for oidcMode: staticToken.\n         An OpenID Connect ID token that identifies the user (and authorizes certificate issuance).\n\n   Recording the Signature to a Rekor Transparency Server\n       This can be combined with either a private key or Fulcio.  It is, practically speaking, required for Fulcio; it is optional when a static private key is used, but necessary for inter‐\n       operability with the default configuration of cosign.\n\n              • rekorURL: URL\n\n       URL of the Rekor server to use.\n\nEXAMPLES\n   Sign Using a Pre-existing Private Key\n       Uses the ”community infrastructure” Rekor server.\n\n       privateKeyFile: \"/home/user/sigstore/private-key.key\"\n       privateKeyPassphraseFile: \"/mnt/user/sigstore-private-key\"\n       rekorURL: \"https://rekor.sigstore.dev\"\n\n   Sign Using a Fulcio-Issued Certificate\n       Uses the ”community infrastructure” Fulcio and Rekor server, and the Dex OIDC issuer which delegates to other major issuers like Google and GitHub.\n\n       Other configurations will very likely need to also provide an OIDC client secret.\n\n       fulcio:\n         fulcioURL: \"https://fulcio.sigstore.dev\"\n         oidcMode: \"interactive\"\n         oidcIssuerURL: \"https://oauth2.sigstore.dev/auth\"\n         oidcClientID: \"sigstore\"\n       rekorURL: \"https://rekor.sigstore.dev\"\n\nSEE ALSO\n       skopeo(1), podman(1)\n\nsigning                                                                                    sigstore                                                 CONTAINERS-SIGSTORE-SIGNING-PARAMS.YAML(5)","ref":"containers-sigstore-signing-params-yaml.html"},{"type":"extras","title":"containers-storage.conf","doc":"containers-storage.conf(5)(Container)                                                        File                                                        containers-storage.conf(5)(Container)\n\nDan Walsh May 2017\n\nNAME\n       storage.conf - Syntax of Container Storage configuration file\n\nDESCRIPTION\n       The STORAGE configuration file specifies all of the available container storage options for tools using shared container storage, but in a TOML format that can be more easily modified\n       and versioned.\n\nFORMAT\n       The  [TOML format][toml] is used as the encoding of the configuration file.  Every option and subtable listed here is nested under a global \"storage\" table.  No bare options are used.\n       The format of TOML can be simplified to:\n\n       [table]\n       option = value\n\n       [table.subtable1]\n       option = value\n\n       [table.subtable2]\n       option = value\n\nSTORAGE TABLE\n       The storage table supports the following options:\n\n       driver=\"\"\n         Copy On Write (COW) container storage driver. Valid drivers are \"overlay\", \"vfs\", \"aufs\", \"btrfs\", and \"zfs\". Some drivers (for example, \"zfs\", \"btrfs\", and \"aufs\") may not work  if\n       your kernel lacks support for the filesystem.  This field is required to guarantee proper operation.  Valid rootless drivers are \"btrfs\", \"overlay\", and \"vfs\".  Rootless users default\n       to  the driver defined in the system configuration when possible.  When the system configuration uses an unsupported rootless driver, rootless users default to \"overlay\" if available,\n       otherwise \"vfs\".\n\n       graphroot=\"\"\n         container storage graph dir (default: \"/var/lib/containers/storage\") Default directory to store all writable content created by container storage programs.  The  rootless  graphroot\n       path  supports  environment  variable substitutions (ie. $HOME/containers/storage).  When changing the graphroot location on an SELINUX system, ensure the labeling matches the default\n       locations labels with the following commands:\n\n       # semanage fcontext -a -e /var/lib/containers/storage /NEWSTORAGEPATH\n       # restorecon -R -v /NEWSTORAGEPATH\n\n       In rootless mode you would set\n\n       # semanage fcontext -a -e $HOME/.local/share/containers NEWSTORAGEPATH\n       $ restorecon -R -v /NEWSTORAGEPATH\n\n       rootless_storage_path=\"$HOME/.local/share/containers/storage\"\n         Storage path for rootless users. By default the graphroot for rootless users is set to $XDG_DATA_HOME/containers/storage, if XDG_DATA_HOME is set. Otherwise  $HOME/.local/share/con‐\n       tainers/storage  is used. This field can be used if administrators need to change the storage location for all users. The rootless storage path supports environment variable substitu‐\n       tions (ie. $HOME/containers/storage)\n\n       A common use case for this field is to provide a local storage directory when user home directories are NFS-mounted (podman does not support container storage over NFS).\n\n       imagestore=\"\"\n        The image storage path (the default is assumed to be the same as graphroot). Path of the imagestore, which is different from graphroot. By default, images in the storage library  are\n       stored  in the graphroot. If imagestore is provided, newly pulled images will be stored in the imagestore location. All other storage continues to be stored in the graphroot. When us‐\n       ing the overlay driver, images previously stored in the graphroot remain accessible. Internally, the storage library mounts graphroot as an additionalImageStore to allow  this  behav‐\n       ior.\n\n       A  common  use  case for the imagestore field is users who need to split filesystems in different partitions. The imagestore partition stores images and the graphroot partition stores\n       container content created from the images.\n\n       Imagestore, if set, must be different from graphroot.\n\n       runroot=\"\"\n         container storage run dir (default: \"/run/containers/storage\") Default directory to store all temporary writable content created by container storage programs. The rootless  runroot\n       path supports environment variable substitutions (ie. $HOME/containers/storage)\n\n       driver_priority=[]\n         Priority  list  for  the  storage  drivers that will be tested one after the other to pick the storage driver if it is not defined. The first storage driver in this list that can be\n       used, will be picked as the new one and all subsequent ones will not be tried. If all drivers in this list are not viable, then all known drivers will be tried and the  first  working\n       one will be picked.  By default, the storage driver is set via the driver option. If it is not defined, then the best driver will be picked according to the current platform. This op‐\n       tion allows you to override this internal priority list with a custom one to prefer certain drivers.  Setting this option only has an effect if the local storage has not been initial‐\n       ized yet and the driver name is not set.\n\n       transient_store = \"false\"|\"true\"\n\n       Transient  store  mode makes all container metadata be saved in temporary storage (i.e. runroot above). This is faster, but doesn't persist across reboots.  Additional garbage collec‐\n       tion must also be performed at boot-time, so this option should remain disabled in most configurations. (default: false)\n\n   STORAGE OPTIONS TABLE\n       The storage.options table supports the following options:\n\n       additionalimagestores=[]\n         Paths to additional container image stores. Usually these are read/only and stored on remote network shares.\n\n       root-auto-userns-user=\"\"\n         Root-auto-userns-user is a user name which can be used to look up one or more UID/GID ranges in the /etc/subuid and /etc/subgid file.  These ranges will be partitioned to containers\n       configured to create automatically a user namespace.  Containers configured to automatically create a user namespace can still overlap with containers having an explicit mapping  set.\n       This setting is ignored when running as rootless.\n\n       auto-userns-min-size=1024\n         Auto-userns-min-size is the minimum size for a user namespace created automatically.\n\n       auto-userns-max-size=65536\n         Auto-userns-max-size is the maximum size for a user namespace created automatically.\n\n       disable-volatile=true\n         If disable-volatile is set, then the \"volatile\" mount optimization is disabled for all the containers.\n\n   STORAGE PULL OPTIONS TABLE\n       The storage.options.pull_options table supports the following keys:\n\n       enable_partial_images=\"true\"|\"false\"\n         Enable the \"zstd:chunked\" feature, which allows partial pulls, reusing\n         content that already exists on the system. This is disabled by default,\n         and must be explicitly enabled to be used. For more on zstd:chunked, see\n\n       ⟨https://github.com/containers/storage/blob/main/docs/containers-storage-zstd-chunked.md⟩.\n         This is a \"string bool\": \"false\"|\"true\" (cannot be native TOML boolean)\n\n       use_hard_links=\"false\"|\"true\"\n         Tells containers/storage to use hard links rather then create new files in\n         the image, if an identical file already existed in storage.\n         This is a \"string bool\": \"false\"|\"true\" (cannot be native TOML boolean)\n\n       ostree_repos=\"\"\n         Path to an ostree repository that might have\n         previously pulled content which can be used when attempting to avoid\n         pulling content from the container registry.\n\n       convert_images=\"false\"|\"true\"\n         If set to \"true\", containers/storage will convert images that are\n         not already in zstd:chunked format to that format before processing\n         in order to take advantage of local deduplication and hard linking.\n         It is an expensive operation so it is not enabled by default.\n         This is a \"string bool\": \"false\"|\"true\" (cannot be native TOML boolean)\n\n       insecure_allow_unpredictable_image_contents=\"false\"|\"true\"\n         This should almost never be set.\n         It allows partial pulls of images without guaranteeing that \"partial\n         pulls\" and non-partial pulls both result in consistent image contents.\n         This allows pulling estargz images and early versions of zstd:chunked images;\n         otherwise, these layers always use the traditional non-partial pull path.\n\n       This option should be enabled extremely rarely, only if all images that could\n         EVER be conceivably pulled on this system are guaranteed (e.g. using a signature policy)\n         to come from a build system trusted to never attack image integrity.\n\n       If this consistency enforcement were disabled, malicious images could be built\n         in a way designed to evade other audit mechanisms, so presence of most other audit\n         mechanisms is not a replacement for the above-mentioned need for all images to come\n         from a trusted build system.\n\n       As a side effect, enabling this option will also make image IDs unpredictable\n         (usually not equal to the traditional value matching the config digest).\n\n       This is a \"string bool\": \"false\"|\"true\" (cannot be native TOML boolean)\n\n   STORAGE OPTIONS FOR AUFS TABLE\n       The storage.options.aufs table supports the following options:\n\n       mountopt=\"\"\n         Comma separated list of default options to be used to mount container images.  Suggested value \"nodev\". Mount options are documented in the mount(8) man page.\n\n   STORAGE OPTIONS FOR BTRFS TABLE\n       The storage.options.btrfs table supports the following options:\n\n       min_space=\"\"\n         Specifies the min space in a btrfs volume.\n\n       size=\"\"\n         Maximum size of a container image.   This flag can be used to set quota on the size of container images. (format: [], where unit = b (bytes), k (kilobytes), m (megabytes), or g (gi‐\n       gabytes))\n\n   STORAGE OPTIONS FOR OVERLAY TABLE\n       The storage.options.overlay table supports the following options:\n\n       ignore_chown_errors = \"false\"\n         ignore_chown_errors  can  be  set to allow a non privileged user running with a  single UID within a user namespace to run containers. The user can pull and use any image even those\n       with multiple uids.  Note multiple UIDs will be squashed down to the default uid in the container.  These images will have no separation between the users in the container.  (default:\n       \"false\")\n         This is a \"string bool\": \"false\"|\"true\" (cannot be native TOML boolean)\n\n       inodes=\"\"\n         Maximum inodes in a read/write layer.   This flag can be used to set a quota on the inodes allocated for a read/write layer of a container.\n\n       force_mask = \"0000|shared|private\"\n         ForceMask  specifies the permissions mask that is used for new files and directories. The values \"shared\" and \"private\" are accepted.  (default: \"\"). Octal permission masks are also\n       accepted.\n\n              • ``: Not set All files/directories, get set with the permissions identified within the image.\n\n              • private: it is equivalent to 0700.  All files/directories get set with 0700 permissions.  The owner has rwx access to the files. No other users on the system can  access  the\n                files.  This setting could be used with networked based home directories.\n\n              • shared:  it  is  equivalent to 0755.  The owner has rwx access to the files and everyone else can read, access and execute them. This setting is useful for sharing containers\n                storage with other users.  For instance, a storage owned by root could be shared to rootless users as an additional store.  NOTE:  All files within the image are  made  read‐\n                able and executable by any user on the system. Even /etc/shadow within your image is now readable by any user.\n\n       OCTAL: Users can experiment with other OCTAL Permissions.\n\n       Note:  The  force_mask  Flag  is an experimental feature, it could change in the future.  When \"force_mask\" is set the original permission mask is stored in the \"user.containers.over‐\n       ride_stat\" xattr and the \"mount_program\" option must be specified. Mount programs like \"/usr/bin/fuse-overlayfs\" present the extended attribute permissions to  processes  within  con‐\n       tainers rather than the \"force_mask\"  permissions.\n\n       mount_program=\"\"\n         Specifies  the  path  to  a custom program to use instead of using kernel defaults for mounting the file system. In rootless mode, without the CAP_SYS_ADMIN capability, many kernels\n       prevent mounting of overlay file systems, requiring you to specify a mount_program. The mount_program option is also required on systems where the underlying storage is  btrfs,  aufs,\n       zfs, overlay, or ecryptfs based file systems.\n         mount_program = \"/usr/bin/fuse-overlayfs\"\n\n       mountopt=\"\"\n         Comma separated list of default options to be used to mount container images.  Suggested value \"nodev\". Mount options are documented in the mount(8) man page.\n\n       skip_mount_home=\"false\"\n         Tell storage drivers to not create a PRIVATE bind mount on their home directory.\n         This is a \"string bool\": \"false\"|\"true\" (cannot be native TOML boolean)\n\n       size=\"\"\n         Maximum  size  of  a  read/write  layer.   This flag can be used to set quota on the size of a read/write layer of a container. (format: [], where unit = b (bytes), k (kilobytes), m\n       (megabytes), or g (gigabytes))\n\n       use_composefs = \"false\"\n           Use ComposeFS to mount the data layers image.  ComposeFS support is experimental and not recommended for production use.\n           This is a \"string bool\": \"false\"|\"true\" (cannot be native TOML boolean)\n\n   STORAGE OPTIONS FOR VFS TABLE\n       The storage.options.vfs table supports the following options:\n\n       ignore_chown_errors = \"false\"\n         ignore_chown_errors can be set to allow a non privileged user running with a  single UID within a user namespace to run containers. The user can pull and use any  image  even  those\n       with multiple uids.  Note multiple UIDs will be squashed down to the default uid in the container.  These images will have no separation between the users in the container.\n         This is a \"string bool\": \"false\"|\"true\" (cannot be native TOML boolean)\n\n   STORAGE OPTIONS FOR ZFS TABLE\n       The storage.options.zfs table supports the following options:\n\n       fsname=\"\"\n         File System name for the zfs driver\n\n       mountopt=\"\"\n         Comma separated list of default options to be used to mount container images.  Suggested value \"nodev\". Mount options are documented in the mount(8) man page.\n\n       size=\"\"\n         Maximum size of a container image.   This flag can be used to set quota on the size of container images. (format: [], where unit = b (bytes), k (kilobytes), m (megabytes), or g (gi‐\n       gabytes))\n\nSELINUX LABELING\n       When running on an SELinux system, if you move the containers storage graphroot directory, you must make sure the labeling is correct.\n\n       Tell  SELinux about the new containers storage by setting up an equivalence record. This tells SELinux to label content under the new path, as if it was stored under /var/lib/contain‐\n       ers/storage.\n\n       semanage fcontext -a -e /var/lib/containers NEWSTORAGEPATH\n       restorecon -R -v NEWSTORAGEPATH\n\n       In rootless mode, you would set\n\n       semanage fcontext -a -e $HOME/.local/share/containers NEWSTORAGEPATH\n       restorecon -R -v NEWSTORAGEPATH\n\n       The semanage command above tells SELinux to setup the default labeling of NEWSTORAGEPATH to match /var/lib/containers.  The restorecon command tells SELinux to apply the labels to the\n       actual content.\n\n       Now all new content created in these directories will automatically be created with the correct label.\n\nQUOTAS\n       Container storage implements XFS project quota controls for overlay storage containers and volumes. The directory used to store the containers must  be  an  XFS  file  system  and  be\n       mounted with the pquota option.\n\n       Example /etc/fstab entry:\n\n       /dev/podman/podman-var /var xfs defaults,x-systemd.device-timeout=0,pquota 1 2\n\n       Container storage generates project ids for each container and builtin volume, but these project ids need to be unique for the XFS file system.\n\n       The xfs_quota tool can be used to assign a project id to the storage driver directory, e.g.:\n\n       echo 100000:/var/lib/containers/storage/overlay >> /etc/projects\n       echo 200000:/var/lib/containers/storage/volumes >> /etc/projects\n       echo storage:100000 >> /etc/projid\n       echo volumes:200000 >> /etc/projid\n       xfs_quota -x -c 'project -s storage volumes' / \n\n       In  the example above, the storage directory project id will be used as a \"start offset\" and all containers will be assigned larger project ids (e.g. >= 100000).  Then the volumes di‐\n       rectory project id will be used as a \"start offset\" and all volumes will be assigned larger project ids (e.g. >= 200000).  This is a way to prevent xfs_quota management from conflict‐\n       ing with containers/storage.\n\nFILES\n       Distributions often provide a /usr/share/containers/storage.conf file to define default storage configuration. Administrators can override this file by creating  /etc/containers/stor‐\n       age.conf  to specify their own configuration. Likewise rootless users can create a storage.conf file to override the system storage.conf files. Files should be stored in the $XDG_CON‐\n       FIG_HOME/containers/storage.conf file.  If $XDG_CONFIG_HOME is not set then the file $HOME/.config/containers/storage.conf is used.\n\n       Note: The storage.conf file overrides all other storage.conf files. Container engines run by users with a storage.conf file in their home directory do not use options  in  the  system\n       storage.conf files.\n\n       /etc/projects - XFS persistent project root definition /etc/projid -  XFS project name mapping file\n\nSEE ALSO\n       semanage(8), restorecon(8), mount(8), fuse-overlayfs(1), xfs_quota(8), projects(5), projid(5)\n\nHISTORY\n       May  2017,  Originally  compiled  by  Dan  Walsh  dwalsh@redhat.com  ⟨mailto:dwalsh@redhat.com⟩  Format  copied  from  crio.conf  man  page  created  by  Aleksa  Sarai  asarai@suse.de\n       ⟨mailto:asarai@suse.de⟩\n\nConfiguration                                                                               Storage                                                      containers-storage.conf(5)(Container)","ref":"containers-storage-conf.html"},{"type":"extras","title":"containers-transports","doc":"CONTAINERS-TRANSPORTS(5)                                                                      Man                                                                     CONTAINERS-TRANSPORTS(5)\n\nValentin Rothberg April 2019\n\nNAME\n       containers-transports - description of supported transports for copying and storing container images\n\nDESCRIPTION\n       Tools  which  use the containers/image library, including skopeo(1), buildah(1), podman(1), all share a common syntax for referring to container images in various locations.  The gen‐\n       eral form of the syntax is transport:details, where details are dependent on the specified transport, which are documented below.\n\n       The semantics of the image names ultimately depend on the environment where they are evaluated. For example: if evaluated on a remote server, image names might refer to paths on  that\n       server; relative paths are relative to the current directory of the image consumer.\n\n   containers-storage:[[storage-specifier]]{image-id|docker-reference[@image-id]}\n       An image located in a local containers storage.  The format of docker-reference is described in detail in the docker transport.\n\n       The storage-specifier allows for referencing storage locations on the file system and has the format [[driver@]root[+run-root][:options]] where the optional driver refers to the stor‐\n       age  driver (e.g., overlay or btrfs) and where root is an absolute path to the storage's root directory.  The optional run-root can be used to specify the run directory of the storage\n       where all temporary writable content is stored.  The optional options are a comma-separated list of driver-specific options.  Please refer to  containers-storage.conf(5)  for  further\n       information on the drivers and supported options.\n\n   dir:path\n       An  existing local directory path storing the manifest, layer tarballs and signatures as individual files.  This is a non-standardized format, primarily useful for debugging or nonin‐\n       vasive container inspection.\n\n   docker://docker-reference\n       An image in a registry implementing the \"Docker Registry HTTP API V2\".  By default, uses the authorization state in $XDG_RUNTIME_DIR/containers/auth.json, which is set  using  podman-\n       login(1).   If  the authorization state is not found there, $HOME/.docker/config.json is checked, which is set using docker-login(1).  The containers-registries.conf(5) further allows\n       for configuring various settings of a registry.\n\n       Note that a docker-reference has the following format: name[:tag | @digest].  While the docker transport does not support both a tag and a digest at the same time  some  formats  like\n       containers-storage do.  Digests can also be used in an image destination as long as the manifest matches the provided digest.\n\n       The docker transport supports pushing images without a tag or digest to a registry when the image name is suffixed with @@unknown-digest@@. The name@@unknown-digest@@ reference format\n       cannot be used with a reference that has a tag or digest.  The digest of images can be explored with skopeo-inspect(1).\n\n       If name does not contain a slash, it is treated as docker.io/library/name.  Otherwise, the component before the first slash is checked if it is recognized as a hostname ⟨i.e., it con‐\n       tains either a `.` or a `:`, or the component is exactly `localhost`⟩.  If the first component of name is not recognized as a hostname[:port], name is treated as docker.io/name.\n\n   docker-archive:path[:{docker-reference|@source-index}]\n       An image is stored in the docker-save(1) formatted file.\n\n       Unless a tool explicitly documents otherwise, a write to a docker-archive: destination completely overwrites path, replacing it with the single provided image.\n\n       The path can refer to a stream, e.g. docker-archive:/dev/stdin.\n\n       docker-reference  must  not  contain  a  digest.  Alternatively, for reading archives, @source-index is a zero-based index in archive manifest (to access untagged images).  If neither\n       docker-reference nor @_source_index is specified when reading an archive, the archive must contain exactly one image.\n\n   docker-daemon:docker-reference|algo:digest\n       An image stored in the docker daemon's internal storage.  The image must be specified as a docker-reference or in an alternative algo:digest format when being used as an image source.\n       The algo:digest refers to the image ID reported by docker-inspect(1).\n\n   oci:path[:{reference|@source-index}]\n       An image in a directory structure compliant with the \"Open Container Image Layout Specification\" at path.\n\n       The path value terminates at the first : character; any further : characters are not separators, but a part of reference.  The reference is used to set, or match, the org.opencontain‐\n       ers.image.ref.name annotation in the top-level index.  If reference is not specified when reading an image, the directory must contain exactly one image.  For reading images, @source-\n       index is a zero-based index in manifest (to access untagged images).  If neither reference nor @_source_index is specified when reading an image, the path must contain exactly one im‐\n       age.\n\n   oci-archive:path[:reference]\n       An image in a tar(1) archive with contents compliant with the \"Open Container Image Layout Specification\" at path.\n\n       Unless a tool explicitly documents otherwise, a write to an oci-archive: destination completely overwrites path, replacing it with the single provided image.\n\n       The path value terminates at the first : character; any further : characters are not separators, but a part of reference.  The reference is used to set, or match, the org.opencontain‐\n       ers.image.ref.name annotation in the top-level index.  If reference is not specified when reading an archive, the archive must contain exactly one image.\n\n   ostree:docker-reference[@/absolute/repo/path]\n       An image in the local ostree(1) repository.  /absolute/repo/path defaults to /ostree/repo.\n\n   sif:path\n       An image using the Singularity image format at path.\n\n       Only reading images is supported, and not all scripts can be represented in the OCI format.\n\nExamples\n       The following examples demonstrate how some of the containers transports can be used.  The examples use skopeo-copy(1) for copying container images.\n\n       Copying an image from one registry to another:\n\n       $ skopeo copy docker://docker.io/library/alpine:latest docker://localhost:5000/alpine:latest\n\n       Copying an image from a running Docker daemon to a directory in the OCI layout:\n\n       $ mkdir alpine-oci\n       $ skopeo copy docker-daemon:alpine:latest oci:alpine-oci\n       $ tree alpine-oci\n       test-oci/\n       ├── blobs\n       │   └── sha256\n       │       ├── 83ef92b73cf4595aa7fe214ec6747228283d585f373d8f6bc08d66bebab531b7\n       │       ├── 9a6259e911dcd0a53535a25a9760ad8f2eded3528e0ad5604c4488624795cecc\n       │       └── ff8df268d29ccbe81cdf0a173076dcfbbea4bb2b6df1dd26766a73cb7b4ae6f7\n       ├── index.json\n       └── oci-layout\n\n       2 directories, 5 files\n\n       Copying an image from a registry to the local storage:\n\n       $ skopeo copy docker://docker.io/library/alpine:latest containers-storage:alpine:latest\n\nSEE ALSO\n       docker-login(1), docker-save(1), ostree(1), podman-login(1), skopeo-copy(1), skopeo-inspect(1), tar(1), container-registries.conf(5), containers-storage.conf(5)\n\nAUTHORS\n       Miloslav Trmač mitr@redhat.com ⟨mailto:mitr@redhat.com⟩ Valentin Rothberg rothberg@redhat.com ⟨mailto:rothberg@redhat.com⟩\n\nTransports                                                                                Containers                                                                  CONTAINERS-TRANSPORTS(5)","ref":"containers-transports.html"},{"type":"extras","title":"coredump.conf.d","doc":"COREDUMP.CONF(5)                                                                         coredump.conf                                                                        COREDUMP.CONF(5)\n\nNAME\n       coredump.conf, coredump.conf.d - Core dump storage configuration files\n\nSYNOPSIS\n           /etc/systemd/coredump.conf\n           /run/systemd/coredump.conf\n           /usr/local/lib/systemd/coredump.conf\n           /usr/lib/systemd/coredump.conf\n           /etc/systemd/coredump.conf.d/*.conf\n           /run/systemd/coredump.conf.d/*.conf\n           /usr/local/lib/systemd/coredump.conf.d/*.conf\n           /usr/lib/systemd/coredump.conf.d/*.conf\n\nDESCRIPTION\n       These files configure the behavior of systemd-coredump(8), a handler for core dumps invoked by the kernel. Whether systemd-coredump is used is determined by the kernel's\n       kernel.core_pattern sysctl(8) setting. See systemd-coredump(8) and core(5) pages for the details.\n\nCONFIGURATION DIRECTORIES AND PRECEDENCE\n       The default configuration is set during compilation, so configuration is only needed when it is necessary to deviate from those defaults. The main configuration file is loaded from\n       one of the listed directories in order of priority, only the first file found is used: /etc/systemd/, /run/systemd/, /usr/local/lib/systemd/ [1], /usr/lib/systemd/. The vendor version\n       of the file contains commented out entries showing the defaults as a guide to the administrator. Local overrides can also be created by creating drop-ins, as described below. The main\n       configuration file can also be edited for this purpose (or a copy in /etc/ if it is shipped under /usr/), however using drop-ins for local configuration is recommended over\n       modifications to the main configuration file.\n\n       In addition to the main configuration file, drop-in configuration snippets are read from /usr/lib/systemd/*.conf.d/, /usr/local/lib/systemd/*.conf.d/, and /etc/systemd/*.conf.d/.\n       Those drop-ins have higher precedence and override the main configuration file. Files in the *.conf.d/ configuration subdirectories are sorted by their filename in lexicographic\n       order, regardless of in which of the subdirectories they reside. When multiple files specify the same option, for options which accept just a single value, the entry in the file\n       sorted last takes precedence, and for options which accept a list of values, entries are collected as they occur in the sorted files.\n\n       When packages need to customize the configuration, they can install drop-ins under /usr/. Files in /etc/ are reserved for the local administrator, who may use this logic to override\n       the configuration files installed by vendor packages. Drop-ins have to be used to override package drop-ins, since the main configuration file has lower precedence. It is recommended\n       to prefix all filenames in those subdirectories with a two-digit number and a dash, to simplify the ordering. This also defines a concept of drop-in priorities to allow OS vendors to\n       ship drop-ins within a specific range lower than the range used by users. This should lower the risk of package drop-ins overriding accidentally drop-ins defined by users. It is\n       recommended to use the range 10-40 for drop-ins in /usr/ and the range 60-90 for drop-ins in /etc/ and /run/, to make sure that local and transient drop-ins take priority over\n       drop-ins shipped by the OS vendor.\n\n       To disable a configuration file supplied by the vendor, the recommended way is to place a symlink to /dev/null in the configuration directory in /etc/, with the same filename as the\n       vendor configuration file.\n\nOPTIONS\n       All options are configured in the [Coredump] section:\n\n       Storage=\n           Controls where to store cores. One of \"none\", \"external\", and \"journal\". When \"none\", the core dumps may be logged (including the backtrace if possible), but not stored\n           permanently. When \"external\" (the default), cores will be stored in /var/lib/systemd/coredump/. When \"journal\", cores will be stored in the journal and rotated following normal\n           journal rotation patterns.\n\n           When cores are stored in the journal, they might be compressed following journal compression settings, see journald.conf(5). When cores are stored externally, they will be\n           compressed by default, see below.\n\n           Note that in order to process a coredump (i.e. extract a stack trace) the core must be written to disk first. Thus, unless ProcessSizeMax= is set to 0 (see below), the core will\n           be written to /var/lib/systemd/coredump/ either way (under a temporary filename, or even in an unlinked file), Storage= thus only controls whether to leave it there even after it\n           was processed.\n\n           Added in version 215.\n\n       Compress=\n           Controls compression for external storage. Takes a boolean argument, which defaults to \"yes\".\n\n           Added in version 215.\n\n       ProcessSizeMax=\n           The maximum size in bytes of a core which will be processed. Core dumps exceeding this size may be stored, but the stack trace will not be generated. Like other sizes in this same\n           config file, the usual suffixes to the base of 1024 are allowed (B, K, M, G, T, P, and E). Defaults to 1G on 32-bit systems, 32G on 64-bit systems.\n\n           Setting Storage=none and ProcessSizeMax=0 disables all coredump handling except for a log entry.\n\n           Added in version 215.\n\n       EnterNamespace=\n           For processes belonging to a PID namespace, controls whether systemd-coredump(8) shall attempt to process core dumps on the host, using debug information from the file system\n           hierarchy (i.e. the mount namespace) of the process that crashed. Access to the process' file system hierarchy might be necessary to generate a fully symbolized backtrace. If set\n           to \"yes\", systemd-coredump will obtain the tree of mounts from the crashing process' mount namespace and will try to generate the stack trace in host context using the debug\n           information of binaries and libraries contained in the crashing process' hierarchy. Defaults to \"no\", i.e. no attempt is made to acquire external debug information from the\n           process' mount namespace, in order to maximize security. This option has no effect on processes that are part of the host's PID namespace.\n\n           Note that the coredump of the namespaced process is still saved in /var/lib/systemd/coredump/ on the host even if EnterNamespace= is set to \"no\" (subject to Storage=).\n\n           Note that EnterNamespace= only has an effect if a core dump is generated by a container whose unit does not have CoredumpReceive= enabled.\n\n           Note that it's typically preferable to let containers and other namespace-based sandboxes process their own coredumps, if possible, for best security. This may be enabled on the\n           container's unit via the CoredumpReceive= setting, see systemd.resource-control(5) for details.\n\n           Added in version 257.\n\n       ExternalSizeMax=, JournalSizeMax=\n           The maximum (compressed or uncompressed) size in bytes of a coredump to be saved in separate files on disk (default: 1G on 32-bit systems, 32G on 64-bit systems) or in the journal\n           (default: 767M). Note that the journal service enforces a hard limit on journal log records of 767M, and will ignore larger submitted log records. Hence, JournalSizeMax= may be\n           lowered relative to the default, but not increased. Unit suffixes are allowed just as in ProcessSizeMax=.\n\n           ExternalSizeMax=infinity sets the core size to unlimited.\n\n           Added in version 215.\n\n       MaxUse=, KeepFree=\n           Enforce limits on the disk space, specified in bytes, taken up by externally stored core dumps. Unit suffixes are allowed just as in ProcessSizeMax=.  MaxUse= makes sure that old\n           core dumps are removed as soon as the total disk space taken up by core dumps grows beyond this limit (defaults to 10% of the total disk size).  KeepFree= controls how much disk\n           space to keep free at least (defaults to 15% of the total disk size). Note that the disk space used by core dumps might temporarily exceed these limits while core dumps are\n           processed. Note that old core dumps are also removed based on time via systemd-tmpfiles(8). Set either value to 0 to turn off size-based cleanup.\n\n           Added in version 215.\n\n       The defaults for all values are listed as comments in the template /etc/systemd/coredump.conf file that is installed by default.\n\nSEE ALSO\n       systemd-journald.service(8), coredumpctl(1), systemd-tmpfiles(8)\n\nNOTES\n        1. 💣💥🧨💥💥💣 Please note that those configuration files must be available at all times. If /usr/local/ is a separate partition, it may not be available during early boot, and must\n           not be used for configuration.\n\nsystemd 257.7                                                                                                                                                                 COREDUMP.CONF(5)","ref":"coredump-conf-d.html"},{"type":"extras","title":"coredump.conf","doc":"COREDUMP.CONF(5)                                                                         coredump.conf                                                                        COREDUMP.CONF(5)\n\nNAME\n       coredump.conf, coredump.conf.d - Core dump storage configuration files\n\nSYNOPSIS\n           /etc/systemd/coredump.conf\n           /run/systemd/coredump.conf\n           /usr/local/lib/systemd/coredump.conf\n           /usr/lib/systemd/coredump.conf\n           /etc/systemd/coredump.conf.d/*.conf\n           /run/systemd/coredump.conf.d/*.conf\n           /usr/local/lib/systemd/coredump.conf.d/*.conf\n           /usr/lib/systemd/coredump.conf.d/*.conf\n\nDESCRIPTION\n       These files configure the behavior of systemd-coredump(8), a handler for core dumps invoked by the kernel. Whether systemd-coredump is used is determined by the kernel's\n       kernel.core_pattern sysctl(8) setting. See systemd-coredump(8) and core(5) pages for the details.\n\nCONFIGURATION DIRECTORIES AND PRECEDENCE\n       The default configuration is set during compilation, so configuration is only needed when it is necessary to deviate from those defaults. The main configuration file is loaded from\n       one of the listed directories in order of priority, only the first file found is used: /etc/systemd/, /run/systemd/, /usr/local/lib/systemd/ [1], /usr/lib/systemd/. The vendor version\n       of the file contains commented out entries showing the defaults as a guide to the administrator. Local overrides can also be created by creating drop-ins, as described below. The main\n       configuration file can also be edited for this purpose (or a copy in /etc/ if it is shipped under /usr/), however using drop-ins for local configuration is recommended over\n       modifications to the main configuration file.\n\n       In addition to the main configuration file, drop-in configuration snippets are read from /usr/lib/systemd/*.conf.d/, /usr/local/lib/systemd/*.conf.d/, and /etc/systemd/*.conf.d/.\n       Those drop-ins have higher precedence and override the main configuration file. Files in the *.conf.d/ configuration subdirectories are sorted by their filename in lexicographic\n       order, regardless of in which of the subdirectories they reside. When multiple files specify the same option, for options which accept just a single value, the entry in the file\n       sorted last takes precedence, and for options which accept a list of values, entries are collected as they occur in the sorted files.\n\n       When packages need to customize the configuration, they can install drop-ins under /usr/. Files in /etc/ are reserved for the local administrator, who may use this logic to override\n       the configuration files installed by vendor packages. Drop-ins have to be used to override package drop-ins, since the main configuration file has lower precedence. It is recommended\n       to prefix all filenames in those subdirectories with a two-digit number and a dash, to simplify the ordering. This also defines a concept of drop-in priorities to allow OS vendors to\n       ship drop-ins within a specific range lower than the range used by users. This should lower the risk of package drop-ins overriding accidentally drop-ins defined by users. It is\n       recommended to use the range 10-40 for drop-ins in /usr/ and the range 60-90 for drop-ins in /etc/ and /run/, to make sure that local and transient drop-ins take priority over\n       drop-ins shipped by the OS vendor.\n\n       To disable a configuration file supplied by the vendor, the recommended way is to place a symlink to /dev/null in the configuration directory in /etc/, with the same filename as the\n       vendor configuration file.\n\nOPTIONS\n       All options are configured in the [Coredump] section:\n\n       Storage=\n           Controls where to store cores. One of \"none\", \"external\", and \"journal\". When \"none\", the core dumps may be logged (including the backtrace if possible), but not stored\n           permanently. When \"external\" (the default), cores will be stored in /var/lib/systemd/coredump/. When \"journal\", cores will be stored in the journal and rotated following normal\n           journal rotation patterns.\n\n           When cores are stored in the journal, they might be compressed following journal compression settings, see journald.conf(5). When cores are stored externally, they will be\n           compressed by default, see below.\n\n           Note that in order to process a coredump (i.e. extract a stack trace) the core must be written to disk first. Thus, unless ProcessSizeMax= is set to 0 (see below), the core will\n           be written to /var/lib/systemd/coredump/ either way (under a temporary filename, or even in an unlinked file), Storage= thus only controls whether to leave it there even after it\n           was processed.\n\n           Added in version 215.\n\n       Compress=\n           Controls compression for external storage. Takes a boolean argument, which defaults to \"yes\".\n\n           Added in version 215.\n\n       ProcessSizeMax=\n           The maximum size in bytes of a core which will be processed. Core dumps exceeding this size may be stored, but the stack trace will not be generated. Like other sizes in this same\n           config file, the usual suffixes to the base of 1024 are allowed (B, K, M, G, T, P, and E). Defaults to 1G on 32-bit systems, 32G on 64-bit systems.\n\n           Setting Storage=none and ProcessSizeMax=0 disables all coredump handling except for a log entry.\n\n           Added in version 215.\n\n       EnterNamespace=\n           For processes belonging to a PID namespace, controls whether systemd-coredump(8) shall attempt to process core dumps on the host, using debug information from the file system\n           hierarchy (i.e. the mount namespace) of the process that crashed. Access to the process' file system hierarchy might be necessary to generate a fully symbolized backtrace. If set\n           to \"yes\", systemd-coredump will obtain the tree of mounts from the crashing process' mount namespace and will try to generate the stack trace in host context using the debug\n           information of binaries and libraries contained in the crashing process' hierarchy. Defaults to \"no\", i.e. no attempt is made to acquire external debug information from the\n           process' mount namespace, in order to maximize security. This option has no effect on processes that are part of the host's PID namespace.\n\n           Note that the coredump of the namespaced process is still saved in /var/lib/systemd/coredump/ on the host even if EnterNamespace= is set to \"no\" (subject to Storage=).\n\n           Note that EnterNamespace= only has an effect if a core dump is generated by a container whose unit does not have CoredumpReceive= enabled.\n\n           Note that it's typically preferable to let containers and other namespace-based sandboxes process their own coredumps, if possible, for best security. This may be enabled on the\n           container's unit via the CoredumpReceive= setting, see systemd.resource-control(5) for details.\n\n           Added in version 257.\n\n       ExternalSizeMax=, JournalSizeMax=\n           The maximum (compressed or uncompressed) size in bytes of a coredump to be saved in separate files on disk (default: 1G on 32-bit systems, 32G on 64-bit systems) or in the journal\n           (default: 767M). Note that the journal service enforces a hard limit on journal log records of 767M, and will ignore larger submitted log records. Hence, JournalSizeMax= may be\n           lowered relative to the default, but not increased. Unit suffixes are allowed just as in ProcessSizeMax=.\n\n           ExternalSizeMax=infinity sets the core size to unlimited.\n\n           Added in version 215.\n\n       MaxUse=, KeepFree=\n           Enforce limits on the disk space, specified in bytes, taken up by externally stored core dumps. Unit suffixes are allowed just as in ProcessSizeMax=.  MaxUse= makes sure that old\n           core dumps are removed as soon as the total disk space taken up by core dumps grows beyond this limit (defaults to 10% of the total disk size).  KeepFree= controls how much disk\n           space to keep free at least (defaults to 15% of the total disk size). Note that the disk space used by core dumps might temporarily exceed these limits while core dumps are\n           processed. Note that old core dumps are also removed based on time via systemd-tmpfiles(8). Set either value to 0 to turn off size-based cleanup.\n\n           Added in version 215.\n\n       The defaults for all values are listed as comments in the template /etc/systemd/coredump.conf file that is installed by default.\n\nSEE ALSO\n       systemd-journald.service(8), coredumpctl(1), systemd-tmpfiles(8)\n\nNOTES\n        1. 💣💥🧨💥💥💣 Please note that those configuration files must be available at all times. If /usr/local/ is a separate partition, it may not be available during early boot, and must\n           not be used for configuration.\n\nsystemd 257.7                                                                                                                                                                 COREDUMP.CONF(5)","ref":"coredump-conf.html"},{"type":"extras","title":"core","doc":"core(5)                                                                               File Formats Manual                                                                              core(5)\n\nNAME\n       core - core dump file\n\nDESCRIPTION\n       The  default  action of certain signals is to cause a process to terminate and produce a core dump file, a file containing an image of the process's memory at the time of termination.\n       This image can be used in a debugger (e.g., gdb(1)) to inspect the state of the program at the time that it terminated.  A list of the signals which cause a process to dump  core  can\n       be found in signal(7).\n\n       A  process  can  set its soft RLIMIT_CORE resource limit to place an upper limit on the size of the core dump file that will be produced if it receives a \"core dump\" signal; see getr‐\n       limit(2) for details.\n\n       There are various circumstances in which a core dump file is not produced:\n\n       •  The process does not have permission to write the core file.  (By default, the core file is called core or core.pid, where pid is the ID of the process that  dumped  core,  and  is\n          created  in  the  current  working directory.  See below for details on naming.)  Writing the core file fails if the directory in which it is to be created is not writable, or if a\n          file with the same name exists and is not writable or is not a regular file (e.g., it is a directory or a symbolic link).\n\n       •  A (writable, regular) file with the same name as would be used for the core dump already exists, but there is more than one hard link to that file.\n\n       •  The filesystem where the core dump file would be created is full; or has run out of inodes; or is mounted read-only; or the user has reached their quota for the filesystem.\n\n       •  The directory in which the core dump file is to be created does not exist.\n\n       •  The RLIMIT_CORE (core file size) or RLIMIT_FSIZE (file size) resource limits for the process are set to zero; see getrlimit(2) and the documentation of the shell's  ulimit  command\n          (limit in csh(1)).  However, RLIMIT_CORE will be ignored if the system is configured to pipe core dumps to a program.\n\n       •  The  binary  being executed by the process does not have read permission enabled.  (This is a security measure to ensure that an executable whose contents are not readable does not\n          produce a—possibly readable—core dump containing an image of the executable.)\n\n       •  The process is executing a set-user-ID (set-group-ID) program that is owned by a user (group) other than the real user (group) ID of the process, or the process is executing a pro‐\n          gram  that  has  file  capabilities  (see  capabilities(7)).   (However,  see  the  description  of  the  prctl(2)  PR_SET_DUMPABLE  operation,   and   the   description   of   the\n          /proc/sys/fs/suid_dumpable file in proc(5).)\n\n       •  /proc/sys/kernel/core_pattern  is  empty and /proc/sys/kernel/core_uses_pid contains the value 0.  (These files are described below.)  Note that if /proc/sys/kernel/core_pattern is\n          empty and /proc/sys/kernel/core_uses_pid contains the value 1, core dump files will have names of the form .pid, and such files are hidden unless one uses the ls(1) -a option.\n\n       •  (Since Linux 3.7) The kernel was configured without the CONFIG_COREDUMP option.\n\n       In addition, a core dump may exclude part of the address space of the process if the madvise(2) MADV_DONTDUMP flag was employed.\n\n       On systems that employ systemd(1) as the init framework, core dumps may instead be placed in a location determined by systemd(1).  See below for further details.\n\n   Naming of core dump files\n       By default, a core dump file is named core, but the /proc/sys/kernel/core_pattern file (since Linux 2.6 and 2.4.21) can be set to define a template that is  used  to  name  core  dump\n       files.  The template can contain % specifiers which are substituted by the following values when a core file is created:\n\n           %%  A single % character.\n           %c  Core file size soft resource limit of crashing process (since Linux 2.6.24).\n           %d  Dump mode—same as value returned by prctl(2) PR_GET_DUMPABLE (since Linux 3.7).\n           %e  The  process  or  thread's  comm value, which typically is the same as the executable filename (without path prefix, and truncated to a maximum of 15 characters), but may have\n               been modified to be something different; see the discussion of /proc/pid/comm and /proc/pid/task/tid/comm in proc(5).\n           %E  Pathname of executable, with slashes ('/') replaced by exclamation marks ('!') (since Linux 3.0).\n           %g  Numeric real GID of dumped process.\n           %h  Hostname (same as nodename returned by uname(2)).\n           %i  TID of thread that triggered core dump, as seen in the PID namespace in which the thread resides (since Linux 3.18).\n           %I  TID of thread that triggered core dump, as seen in the initial PID namespace (since Linux 3.18).\n           %p  PID of dumped process, as seen in the PID namespace in which the process resides.\n           %P  PID of dumped process, as seen in the initial PID namespace (since Linux 3.12).\n           %s  Number of signal causing dump.\n           %t  Time of dump, expressed as seconds since the Epoch, 1970-01-01 00:00:00 +0000 (UTC).\n           %u  Numeric real UID of dumped process.\n\n       A single % at the end of the template is dropped from the core filename, as is the combination of a % followed by any character other than those listed above.  All other characters in\n       the template become a literal part of the core filename.  The template may include '/' characters, which are interpreted as delimiters for directory names.  The maximum  size  of  the\n       resulting  core filename is 128 bytes (64 bytes before Linux 2.6.19).  The default value in this file is \"core\".  For backward compatibility, if /proc/sys/kernel/core_pattern does not\n       include %p and /proc/sys/kernel/core_uses_pid (see below) is nonzero, then .PID will be appended to the core filename.\n\n       Paths are interpreted according to the settings that are active for the crashing process.  That means the crashing process's mount namespace  (see  mount_namespaces(7)),  its  current\n       working directory (found via getcwd(2)), and its root directory (see chroot(2)).\n\n       Since  Linux 2.4, Linux has also provided a more primitive method of controlling the name of the core dump file.  If the /proc/sys/kernel/core_uses_pid file contains the value 0, then\n       a core dump file is simply named core.  If this file contains a nonzero value, then the core dump file includes the process ID in a name of the form core.PID.\n\n       Since Linux 3.6, if /proc/sys/fs/suid_dumpable is set to 2 (\"suidsafe\"), the pattern must be either an absolute pathname (starting with a leading '/' character) or a pipe, as  defined\n       below.\n\n   Piping core dumps to a program\n       Since Linux 2.6.19, Linux supports an alternate syntax for the /proc/sys/kernel/core_pattern file.  If the first character of this file is a pipe symbol (|), then the remainder of the\n       line is interpreted as the command-line for a user-space program (or script) that is to be executed.\n\n       Since  Linux  5.3.0,  the pipe template is split on spaces into an argument list before the template parameters are expanded.  In earlier kernels, the template parameters are expanded\n       first and the resulting string is split on spaces into an argument list.  This means that in earlier kernels executable names added by the %e and  %E  template  parameters  could  get\n       split into multiple arguments.  So the core dump handler needs to put the executable names as the last argument and ensure it joins all parts of the executable name using spaces.  Ex‐\n       ecutable names with multiple spaces in them are not correctly represented in earlier kernels, meaning that the core dump handler needs to use mechanisms to find the executable name.\n\n       Instead of being written to a file, the core dump is given as standard input to the program.  Note the following points:\n\n       •  The program must be specified using an absolute pathname (or a pathname relative to the root directory, /), and must immediately follow the '|' character.\n\n       •  The command-line arguments can include any of the % specifiers listed above.  For example, to pass the PID of the process that is being dumped, specify %p in an argument.\n\n       •  The process created to run the program runs as user and group root.\n\n       •  Running  as  root  does  not  confer  any exceptional security bypasses.  Namely, LSMs (e.g., SELinux) are still active and may prevent the handler from accessing details about the\n          crashed process via /proc/pid.\n\n       •  The program pathname is interpreted with respect to the initial mount namespace as it is always executed there.  It is not affected by the settings  (e.g.,  root  directory,  mount\n          namespace, current working directory) of the crashing process.\n\n       •  The process runs in the initial namespaces (PID, mount, user, and so on) and not in the namespaces of the crashing process.  One can utilize specifiers such as %P to find the right\n          /proc/pid directory and probe/enter the crashing process's namespaces if needed.\n\n       •  The  process  starts  with  its current working directory as the root directory.  If desired, it is possible change to the working directory of the dumping process by employing the\n          value provided by the %P specifier to change to the location of the dumping process via /proc/pid/cwd.\n\n       •  Command-line arguments can be supplied to the program (since Linux 2.6.24), delimited by white space (up to a total line length of 128 bytes).\n\n       •  The RLIMIT_CORE limit is not enforced for core dumps that are piped to a program via this mechanism.\n\n   /proc/sys/kernel/core_pipe_limit\n       When collecting core dumps via a pipe to a user-space program, it can be useful for the collecting program to gather data about the crashing process from that process's /proc/pid  di‐\n       rectory.   In  order  to do this safely, the kernel must wait for the program collecting the core dump to exit, so as not to remove the crashing process's /proc/pid files prematurely.\n       This in turn creates the possibility that a misbehaving collecting program can block the reaping of a crashed process by simply never exiting.\n\n       Since Linux 2.6.32, the /proc/sys/kernel/core_pipe_limit can be used to defend against this possibility.  The value in this file defines how many concurrent crashing processes may  be\n       piped to user-space programs in parallel.  If this value is exceeded, then those crashing processes above this value are noted in the kernel log and their core dumps are skipped.\n\n       A  value  of  0  in  this file is special.  It indicates that unlimited processes may be captured in parallel, but that no waiting will take place (i.e., the collecting program is not\n       guaranteed access to /proc/ ).  The default value for this file is 0.\n\n   Controlling which mappings are written to the core dump\n       Since Linux 2.6.23, the Linux-specific /proc/pid/coredump_filter file can be used to control which memory segments are written to the core dump file in the event that a core  dump  is\n       performed for the process with the corresponding process ID.\n\n       The  value in the file is a bit mask of memory mapping types (see mmap(2)).  If a bit is set in the mask, then memory mappings of the corresponding type are dumped; otherwise they are\n       not dumped.  The bits in this file have the following meanings:\n\n           bit 0  Dump anonymous private mappings.\n           bit 1  Dump anonymous shared mappings.\n           bit 2  Dump file-backed private mappings.\n           bit 3  Dump file-backed shared mappings.\n           bit 4 (since Linux 2.6.24)\n                  Dump ELF headers.\n           bit 5 (since Linux 2.6.28)\n                  Dump private huge pages.\n           bit 6 (since Linux 2.6.28)\n                  Dump shared huge pages.\n           bit 7 (since Linux 4.4)\n                  Dump private DAX pages.\n           bit 8 (since Linux 4.4)\n                  Dump shared DAX pages.\n\n       By default, the following bits are set: 0, 1, 4 (if the CONFIG_CORE_DUMP_DEFAULT_ELF_HEADERS kernel configuration option is enabled), and 5.  This default can be modified at boot time\n       using the coredump_filter boot option.\n\n       The value of this file is displayed in hexadecimal.  (The default value is thus displayed as 33.)\n\n       Memory-mapped I/O pages such as frame buffer are never dumped, and virtual DSO (vdso(7)) pages are always dumped, regardless of the coredump_filter value.\n\n       A child process created via fork(2) inherits its parent's coredump_filter value; the coredump_filter value is preserved across an execve(2).\n\n       It can be useful to set coredump_filter in the parent shell before running a program, for example:\n\n           $ echo 0x7 > /proc/self/coredump_filter\n           $ ./some_program\n\n       This file is provided only if the kernel was built with the CONFIG_ELF_CORE configuration option.\n\n   Core dumps and systemd\n       On systems using the systemd(1) init framework, core dumps may be placed in a location determined by systemd(1).  To do this, systemd(1) employs the core_pattern feature  that  allows\n       piping core dumps to a program.  One can verify this by checking whether core dumps are being piped to the systemd-coredump(8) program:\n\n           $ cat /proc/sys/kernel/core_pattern\n           |/usr/lib/systemd/systemd-coredump %P %u %g %s %t %c %e\n\n       In  this case, core dumps will be placed in the location configured for systemd-coredump(8), typically as lz4(1) compressed files in the directory /var/lib/systemd/coredump/.  One can\n       list the core dumps that have been recorded by systemd-coredump(8) using coredumpctl(1):\n\n       $ coredumpctl list | tail -5\n       Wed 2017-10-11 22:25:30 CEST  2748 1000 1000 3 present  /usr/bin/sleep\n       Thu 2017-10-12 06:29:10 CEST  2716 1000 1000 3 present  /usr/bin/sleep\n       Thu 2017-10-12 06:30:50 CEST  2767 1000 1000 3 present  /usr/bin/sleep\n       Thu 2017-10-12 06:37:40 CEST  2918 1000 1000 3 present  /usr/bin/cat\n       Thu 2017-10-12 08:13:07 CEST  2955 1000 1000 3 present  /usr/bin/cat\n\n       The information shown for each core dump includes the date and time of the dump, the PID, UID, and GID  of the dumping process, the signal number that caused the core  dump,  and  the\n       pathname  of the executable that was being run by the dumped process.  Various options to coredumpctl(1) allow a specified coredump file to be pulled from the systemd(1) location into\n       a specified file.  For example, to extract the core dump for PID 2955 shown above to a file named core in the current directory, one could use:\n\n           $ coredumpctl dump 2955 -o core\n\n       For more extensive details, see the coredumpctl(1) manual page.\n\n       To (persistently) disable the systemd(1) mechanism that archives core dumps, restoring to something more like traditional Linux behavior, one can set an override  for  the  systemd(1)\n       mechanism, using something like:\n\n           # echo \"kernel.core_pattern=core.%p\" > \\\n                          /etc/sysctl.d/50-coredump.conf\n           # /lib/systemd/systemd-sysctl\n\n       It  is  also  possible to temporarily (i.e., until the next reboot) change the core_pattern setting using a command such as the following (which causes the names of core dump files to\n       include the executable name as well as the number of the signal which triggered the core dump):\n\n           # sysctl -w kernel.core_pattern=\"%e-%s.core\"\n\nNOTES\n       The gdb(1) gcore command can be used to obtain a core dump of a running process.\n\n       In Linux versions up to and including 2.6.27, if a multithreaded process (or, more precisely, a process that shares its memory with another process by being created with the  CLONE_VM\n       flag  of clone(2)) dumps core, then the process ID is always appended to the core filename, unless the process ID was already included elsewhere in the filename via a %p specification\n       in /proc/sys/kernel/core_pattern.  (This is primarily useful when employing the obsolete LinuxThreads implementation, where each thread of a process has a different PID.)\n\nEXAMPLES\n       The program below can be used to demonstrate the use of the pipe syntax in the /proc/sys/kernel/core_pattern file.  The following shell session demonstrates the use  of  this  program\n       (compiled to create an executable named core_pattern_pipe_test):\n\n           $ cc -o core_pattern_pipe_test core_pattern_pipe_test.c\n           $ su\n           Password:\n           # echo \"|$PWD/core_pattern_pipe_test %p UID=%u GID=%g sig=%s\" > \\\n               /proc/sys/kernel/core_pattern\n           # exit\n           $ sleep 100\n           ^\\                     # type control-backslash\n           Quit (core dumped)\n           $ cat core.info\n           argc=5\n           argc[0]= \n           argc[1]=<20575>\n           argc[2]= \n           argc[3]= \n           argc[4]= \n           Total bytes in core dump: 282624\n\n   Program source\n\n       /* core_pattern_pipe_test.c */\n\n       #define _GNU_SOURCE\n       #include  \n       #include  \n       #include  \n       #include  \n       #include  \n       #include  \n\n       #define BUF_SIZE 1024\n\n       int\n       main(int argc, char *argv[])\n       {\n           ssize_t nread, tot;\n           char buf[BUF_SIZE];\n           FILE *fp;\n           char cwd[PATH_MAX];\n\n           /* Change our current working directory to that of the\n              crashing process. */\n\n           snprintf(cwd, PATH_MAX, \"/proc/%s/cwd\", argv[1]);\n           chdir(cwd);\n\n           /* Write output to file \"core.info\" in that directory. */\n\n           fp = fopen(\"core.info\", \"w+\");\n           if (fp == NULL)\n               exit(EXIT_FAILURE);\n\n           /* Display command-line arguments given to core_pattern\n              pipe program. */\n\n           fprintf(fp, \"argc=%d\\n\", argc);\n           for (size_t j = 0; j  \\n\", j, argv[j]);\n\n           /* Count bytes in standard input (the core dump). */\n\n           tot = 0;\n           while ((nread = read(STDIN_FILENO, buf, BUF_SIZE)) > 0)\n               tot += nread;\n           fprintf(fp, \"Total bytes in core dump: %zd\\n\", tot);\n\n           fclose(fp);\n           exit(EXIT_SUCCESS);\n       }\n\nSEE ALSO\n       bash(1), coredumpctl(1), gdb(1), getrlimit(2), mmap(2), prctl(2), sigaction(2), elf(5), proc(5), pthreads(7), signal(7), systemd-coredump(8)\n\nLinux man-pages 6.9.1                                                                     2024-06-15                                                                                   core(5)","ref":"core.html"},{"type":"extras","title":"crontab","doc":"CRONTAB(1)                                                                            crontab User Manual                                                                           CRONTAB(1)\n\nNAME\n       crontab - maintain crontab files for individual users (Vixie Cron)\n\nSYNOPSIS\n\n       crontab [-h]\n\n       crontab [-u user] [-n] file\n\n       crontab [-u user] [-i] {-e | -l | -r}\n\nDESCRIPTION\n       crontab is the program used to install, deinstall or list the tables used to drive the cron(8) daemon in Vixie Cron. Each user can have their own crontab, and though these are files\n       in /var/spool/cron/crontabs, they are not intended to be edited directly.\n\n       If the /etc/cron.allow file exists, then you must be listed (one user per line) therein in order to be allowed to use this command. If the /etc/cron.allow file does not exist but the\n       /etc/cron.deny file does exist, then you must not be listed in the /etc/cron.deny file in order to use this command.\n\n       If neither of these files exists, then depending on site-dependent configuration parameters, only the super user will be allowed to use this command, or all users will be able to use\n       this command.\n\n       If both files exist then /etc/cron.allow takes precedence. Which means that /etc/cron.deny is not considered and your user must be listed in /etc/cron.allow in order to be able to use\n       the crontab.\n\n       Regardless of the existence of any of these files, the root administrative user is always allowed to setup a crontab. For standard Debian systems, all users may use this command.\n\n       If the -h option is given, crontab shows a help message and quits immediately.\n\n       If the -u option is given, it specifies the name of the user whose crontab is to be used (when listing) or modified (when editing). If this option is not given, crontab examines\n       \"your\" crontab file, i.e., the crontab file of the person executing the command. Note that su(8) can confuse crontab and that if you are running inside of su(8) you should always use\n       the -u option for safety's sake.\n\n       The first form of this command is used to install a new crontab from some named file or standard input if the pseudo-filename ``-'' is given.\n\n       If the -n option is given, it means \"dry run\": crontab examines \"your\" crontab for its syntax, and outputs a success message if this syntax is correct, but nothing is written to any\n       crontab.\n\n       The -l option causes the current crontab to be displayed on standard output. See the note under the section called “DEBIAN SPECIFIC” below.\n\n       The -r option causes the current crontab to be removed.\n\n       The -e option is used to edit the current crontab using sensible-editor(1). After you exit from the editor, the modified crontab will be installed automatically.\n\n       The -i option modifies the -r option to prompt the user for a 'y/Y' response before actually removing the crontab.\n\nDEBIAN SPECIFIC\n       The \"out-of-the-box\" behaviour for crontab -l is to display the three line \"DO NOT EDIT THIS FILE\" header that is placed at the beginning of the crontab when it is installed. The\n       problem is that it makes the sequence\n\n       crontab -l | crontab -\n\n       non-idempotent — you keep adding copies of the header. This causes pain to scripts that use sed to edit a crontab. Therefore, the default behaviour of the -l option has been changed\n       to not output such header. You may obtain the original behaviour by setting the environment variable CRONTAB_NOHEADER to 'N', which will cause the crontab -l command to emit the\n       extraneous header.\n\nHIGHLIGHTING THE OUTPUT OF CRONTAB -L\n       The command crontab -l outputs plain text. When a tty can support ANSI sequences to colourise this text, one can highlight the output, by calling: crontab -l | spc -t crontab when the\n       ttybackground is dark, or crontab -l | spc -t crontab-light when this background is light.\n\n       The highlighting scheme can be modified by using customised versions of files /etc/supercat/spcrc-crontab*\n\n       One can also colourise this text with the program batcat(1) provided by the package bat, here is an example:\n\n       crontab -l | batcat --language Crontab\n\nSEE ALSO\n       crontab(5), cron(8), spc(1)\n\nFILES\n       /etc/cron.allow, /etc/cron.deny\n           The files /etc/cron.allow and /etc/cron.deny if they exist, must be either world-readable, or readable by group ``crontab''. If they are not, then cron(8) will deny access to all\n           users until the permissions are fixed.\n\n       /var/spool/cron/crontabs\n           There is one file for each user's crontab under the /var/spool/cron/crontabs directory. Users are not allowed to edit the files under that directory directly to ensure that only\n           users allowed by the system to run periodic tasks can add them, and only syntactically correct crontabs will be written there. This is enforced by having the directory writable\n           only by the ``crontab'' group and configuring crontab command with the setgid bid set for that specific group.\n\nSTANDARDS\n       The crontab command conforms to IEEE Std1003.2-1992 (``POSIX''). This new command syntax differs from previous versions of Vixie Cron, as well as from the classic SVR3 syntax.\n\nDIAGNOSTICS\n       A fairly informative usage message appears if you run it with a bad command line.\n\n       cron(8) requires that each entry in a crontab end in a newline character. If the last entry in a crontab is missing the newline, cron(8) will consider the crontab (at least partially)\n       broken and refuse to install it.\n\n       The files under /var/spool/cron/crontabs are named based on the user's account name. Crontab jobs will not be run for users whose accounts have been renamed either due to changes in\n       the local system or because they are managed through a central user database (external to the system, for example an LDAP directory).\n\nAUTHORS\n       Paul Vixie  \n           Wrote this manpage (1994).\n\n       Steve Greenland  \n           Maintained the package (1996-2005).\n\n       Javier Fernández-Sanguino Peña  \n           Maintained the package (2005-2014).\n\n       Christian Kastner  \n           Maintained the package (2010-2016).\n\n       Georges Khaznadar  \n           Maintained the package (2022-2024).\n\nCOPYRIGHT\n       Copyright © 1994 Paul Vixie\n\n       Distribute freely, except: don't remove my name from the source or documentation (don't take credit for my work), mark your changes (don't get me blamed for your possible bugs), don't\n       alter or remove this notice. May be sold if buildable source is provided to buyer. No warranty of any kind, express or implied, is included with this software; use at your own risk,\n       responsibility for damages (if any) to anyone resulting from the use of this software rests entirely with the user.\n\n       Since year 1994, many modifications were made in this manpage, authored by Debian Developers which maintained cron; above is a short list, more information can be found in the file\n       /usr/share/doc/cron/copyright.\n\ncrontab                                                                                   06/13/2025                                                                                CRONTAB(1)","ref":"crontab.html"},{"type":"extras","title":"crypt","doc":"CRYPT(3)                                                                            Library Functions Manual                                                                          CRYPT(3)\n\nNAME\n       crypt, crypt_r, crypt_rn, crypt_ra — passphrase hashing\n\nLIBRARY\n       Crypt Library (libcrypt, -lcrypt)\n\nSYNOPSIS\n       #include  \n\n       char *\n       crypt(const char *phrase, const char *setting);\n\n       char *\n       crypt_r(const char *phrase, const char *setting, struct crypt_data *data);\n\n       char *\n       crypt_rn(const char *phrase, const char *setting, struct crypt_data *data, int size);\n\n       char *\n       crypt_ra(const char *phrase, const char *setting, void **data, int *size);\n\nDESCRIPTION\n       The crypt, crypt_r, crypt_rn, and crypt_ra functions irreversibly “hash” phrase for storage in the system password database (shadow(5)) using a cryptographic “hashing method.” The re‐\n       sult of this operation is called a “hashed passphrase” or just a “hash.” Hashing methods are described in crypt(5).\n\n       setting  controls  which hashing method to use, and also supplies various parameters to the chosen method, most importantly a random “salt” which ensures that no two stored hashes are\n       the same, even if the phrase strings are the same.\n\n       The data argument to crypt_r is a structure of type struct crypt_data.  It has at least these fields:\n\n             struct crypt_data {\n                 char output[CRYPT_OUTPUT_SIZE];\n                 char setting[CRYPT_OUTPUT_SIZE];\n                 char input[CRYPT_MAX_PASSPHRASE_SIZE];\n                 char initialized;\n             };\n\n       Upon a successful return from crypt_r, the hashed passphrase will be stored in output.  Applications are encouraged, but not required, to use the input and setting fields to store the\n       strings that they will pass as input phrase and setting to crypt_r.  This will make it easier to erase all sensitive data after it is no longer needed.\n\n       The initialized field must be set to zero before the first time a struct crypt_data object is first used in a call to crypt_r().  We recommend zeroing  the  entire  object,  not  just\n       initialized and not just the documented fields, before the first use.  (Of course, do this before storing anything in setting and input.)\n\n       The  data  argument to crypt_rn should also point to a struct crypt_data object, and size should be the size of that object, cast to int.  When used with crypt_rn, the entire data ob‐\n       ject (except for the input and setting fields) must be zeroed before its first use; this is not just a recommendation, as it is for crypt_r.  Otherwise, the fields of the object  have\n       the same uses that they do for crypt_r.\n\n       On  the first call to crypt_ra, data should be the address of a void * variable set to NULL, and size should be the address of an int variable set to zero.  crypt_ra will allocate and\n       initialize a struct crypt_data object, using malloc(3), and write its address and size into the variables pointed to by data and size.  These can be reused in subsequent calls.  After\n       the application is done hashing passphrases, it should deallocate the struct crypt_data object using free(3).\n\nRETURN VALUES\n       Upon successful completion, crypt, crypt_r, crypt_rn, and crypt_ra return a pointer to a string which encodes both the hashed passphrase, and the settings that were used to encode it.\n       This string is directly usable as setting in other calls to crypt, crypt_r, crypt_rn, and crypt_ra, and as prefix in calls to crypt_gensalt,  crypt_gensalt_rn,  and  crypt_gensalt_ra.\n       It will be entirely printable ASCII, and will not contain whitespace or the characters ‘:’, ‘;’, ‘*’, ‘!’, or ‘\\’.  See crypt(5) for more detail on the format of hashed passphrases.\n\n       crypt places its result in a static storage area, which will be overwritten by subsequent calls to crypt.  It is not safe to call crypt from multiple threads simultaneously.\n\n       crypt_r,  crypt_rn,  and  crypt_ra  place their result in the output field of their data argument.  It is safe to call them from multiple threads simultaneously, as long as a separate\n       data object is used for each thread.\n\n       Upon error, crypt_r, crypt_rn, and crypt_ra write an invalid hash to the output field of their data argument, and crypt writes an invalid hash to its static storage area.  This string\n       will be shorter than 13 characters, will begin with a ‘*’, and will not compare equal to setting.\n\n       Upon error, crypt_rn and crypt_ra return a null pointer.  crypt_r and crypt may also return a null pointer, or they may return a pointer to the invalid hash, depending on how libcrypt\n       was configured.  (The option to return the invalid hash is for compatibility with old applications that assume that crypt cannot return a null pointer.  See  “PORTABILITY  NOTES”  be‐\n       low.)\n\n       All four functions set errno when they fail.  When the functions succeed, the value of errno is unspecified and must not be relied upon.\n\nERRORS\n       EINVAL             setting is invalid, or requests a hashing method that is not supported.\n\n       ERANGE             phrase is too long (more than CRYPT_MAX_PASSPHRASE_SIZE characters; some hashing methods may have lower limits).\n                          crypt_rn only: size is too small for the hashing method requested by setting.\n\n       ENOMEM             Failed to allocate internal scratch memory.\n                          crypt_ra only: failed to allocate memory for data.\n\n       ENOSYS or EOPNOTSUPP\n                          Hashing  passphrases  is  not supported at all on this installation, or the hashing method requested by setting is not supported.  These error codes are not used by\n                          this version of libcrypt, but may be encountered on other systems.\n\nPORTABILITY NOTES\n       crypt is included in POSIX, but crypt_r, crypt_rn, and crypt_ra are not part of any standard.\n\n       POSIX does not specify any hashing methods, and does not require hashed passphrases to be portable between systems.  In practice, hashed passphrases are portable as long as both  sys‐\n       tems support the hashing method that was used.  However, the set of supported hashing methods varies considerably from system to system.\n\n       The  behavior  of  crypt  on  errors isn't well standardized.  Some implementations simply can't fail (except by crashing the program), others return a null pointer or a fixed string.\n       Most implementations don't set errno, but some do.  POSIX specifies returning a null pointer and setting errno, but it defines only one possible error, ENOSYS, in the case where crypt\n       is not supported at all.  Some older applications are not prepared to handle null pointers returned by crypt.  The behavior described above for this implementation, setting errno  and\n       returning an invalid hash different from setting, is chosen to make these applications fail closed when an error occurs.\n\n       Due  to historical restrictions on the export of cryptographic software from the USA, crypt is an optional POSIX component.  Applications should therefore be prepared for crypt not to\n       be available, or to always fail (setting errno to ENOSYS) at runtime.\n\n       POSIX specifies that crypt is declared in  , but only if the macro _XOPEN_CRYPT is defined and has a value greater than or equal to zero.  Since  libcrypt  does  not  provide\n        , it declares crypt, crypt_r, crypt_rn, and crypt_ra in   instead.\n\n       On  a  minority  of systems (notably recent versions of Solaris), crypt uses a thread-specific static storage buffer, which makes it safe to call from multiple threads simultaneously,\n       but does not prevent each call within a thread from overwriting the results of the previous one.\n\nBUGS\n       Some implementations of crypt, upon error, return an invalid hash that is stored in a read-only location or only initialized once, which means that it is only safe to erase the buffer\n       pointed to by the crypt return value if an error did not occur.\n\n       struct crypt_data may be quite large (32kB in this implementation of libcrypt; over 128kB in some other implementations).  This is large enough that it may be unwise to allocate it on\n       the stack.\n\n       Some recently designed hashing methods need even more scratch memory, but the crypt_r interface makes it impossible to change the size of struct  crypt_data  without  breaking  binary\n       compatibility.  The crypt_rn interface could accommodate larger allocations for specific hashing methods, but the caller of crypt_rn has no way of knowing how much memory to allocate.\n       crypt_ra does the allocation itself, but can only make a single call to malloc(3).\n\nATTRIBUTES\n       For an explanation of the terms used in this section, see attributes(7).\n       ┌─────────────────────────────┬───────────────┬──────────────────────┐\n       │ Interface                   │ Attribute     │ Value                │\n       ├─────────────────────────────┼───────────────┼──────────────────────┤\n       │ crypt                       │ Thread safety │ MT-Unsafe race:crypt │\n       ├─────────────────────────────┼───────────────┼──────────────────────┤\n       │ crypt_r, crypt_rn, crypt_ra │ Thread safety │ MT-Safe              │\n       └─────────────────────────────┴───────────────┴──────────────────────┘\n\nHISTORY\n       A rotor-based crypt function appeared in Version 6 AT&T UNIX.  The “traditional” DES-based crypt first appeared in Version 7 AT&T UNIX.\n\n       crypt_r originates with the GNU C Library.  There's also a crypt_r function on HP-UX and MKS Toolkit, but the prototypes and semantics differ.\n\n       crypt_rn and crypt_ra originate with the Openwall project.\n\nSEE ALSO\n       crypt_gensalt(3), getpass(3), getpwent(3), shadow(3), login(1), passwd(1), crypt(5), passwd(5), shadow(5), pam(8)\n\nOpenwall Project                                                                       October 11, 2017                                                                               CRYPT(3)","ref":"crypt.html"},{"type":"extras","title":"crypttab","doc":"CRYPTTAB(5)                                                                            cryptsetup manual                                                                           CRYPTTAB(5)\n\nNAME\n       crypttab - static information about encrypted filesystems\n\nDESCRIPTION\n       The file /etc/crypttab contains descriptive information about encrypted devices. crypttab is only read by programs (e.g. cryptdisks_start and cryptdisks_stop), and not written; it is\n       the duty of the system administrator to properly create and maintain this file. crypttab entries are treated sequentially, so their order matters (dependencies need to listed first).\n\n       Each encrypted device is described on a separate line. Fields on each line are separated by tabs or spaces. Lines starting with '#' are comments, and blank lines are ignored. Octal\n       sequences \\0num within a field are decoded, which can be used for values containing spaces or special characters. A backslash which doesn't start an octal sequence yields undefined\n       behavior.\n\n       The first field, target, describes the mapped device name. It must be a plain filename without any directory components. A mapped device which encrypts/decrypts data to/from the\n       source device will be created at /dev/mapper/target by cryptsetup.\n\n       The second field, source device, describes either the block special device or file that contains the encrypted data. Instead of giving the source device explicitly, the UUID (resp.\n       LABEL, PARTUUID and PARTLABEL) is supported as well, using “UUID= ” (resp. “LABEL= ”, “PARTUUID= ” and “PARTLABEL= ”).\n\n       The third field, key file, describes the file to use as a key for decrypting the data of the source device. In case of a keyscript, the value of this field is given as argument to the\n       keyscript. Note that the entire key file will be used as the passphrase; the passphrase must not be followed by a newline character.\n\n       It can also be a device name (e.g. /dev/urandom), note however that LUKS requires a persistent key and therefore does not support random data keys.\n\n       If the key file is the string none, a passphrase will be read interactively from the console. In this case, the options check, checkargs and tries may be useful.\n\n       The fourth field, options, is an optional comma-separated list of options and/or flags describing the device type (luks, tcrypt, bitlk, fvault2, or plain which is also the default)\n       and cryptsetup options associated with the encryption process. The supported options are described below. For plain dm-crypt devices the cipher, hash and size options are required.\n       Some options can be changed on active mappings using cryptsetup refresh [ ]  . Furthermore some options can be permanently written into metadata of LUKS2 headers using\n       cryptsetup's --persistent flag.\n\n       Note that the first three fields are required and that a missing field will lead to unspecified behaviour.\n\nON DIFFERENT CRYPTTAB FORMATS\n       Please note that there are several independent cryptsetup wrappers with their own crypttab format. This manpage covers Debian's implementation for initramfs scripts and SysVinit init\n       scripts. systemd brings its own crypttab implementation. We try to cover the differences between the systemd and our implementation in this manpage, but if in doubt, better check the\n       systemd crypttab(5) manpage, e.g. online at https://www.freedesktop.org/software/systemd/man/crypttab.html.\n\nOPTIONS\n       cipher= \n           Encryption algorithm (ignored for LUKS and TCRYPT devices). See cryptsetup -c.\n\n       size= \n           Encryption key size (ignored for LUKS and TCRYPT devices). See cryptsetup -s.\n\n       sector-size= \n           Sector size. See cryptsetup(8) for possible values and the default value of this option.\n\n       hash= \n           Hash algorithm (ignored for LUKS and TCRYPT devices). See cryptsetup -h.\n\n       offset= \n           Start offset (ignored for LUKS and TCRYPT devices). Uses cryptsetup -o.\n\n       skip= \n           Skip sectors at the beginning (ignored for LUKS and TCRYPT devices). Uses cryptsetup -p.\n\n       keyfile-offset= \n           Specifies the number of bytes to skip at the start of the key file.\n\n       keyfile-size= \n           Specifies the maximum number of bytes to read from the key file. The default is to read the whole file up to the compiled-in maximum, that can be queried with cryptsetup --help.\n           This option is ignored for plain dm-crypt devices, as the key file size is then given by the encryption key size (option size).\n\n       keyslot= , key-slot= \n           Key slot (ignored for non-LUKS devices). See cryptsetup -S.\n\n       header= \n           Detached header file (ignored for plain dm-crypt devices). See cryptsetup --header.\n\n       verify\n           Verify password. Uses cryptsetup -y.\n\n       readonly, read-only\n           Set up a read-only mapping.\n\n       tries= \n           Try to unlock the device   before failing. It's particularly useful when using a passphrase or a keyscript that asks for interactive input. If you want to disable retries,\n           pass “tries=1”. Default is “3”. Setting “tries=0” means infinitive retries.\n\n       discard\n           Allow using of discards (TRIM) requests for device.\n\n           Starting with Debian 10 (Buster), this option is added per default to new dm-crypt devices by the Debian Installer. If you don't care about leaking access patterns (filesystem\n           type, used space) and don't have hidden truecrypt volumes inside this volume, then it should be safe to enable this option. See the following warning for further information.\n\n           WARNING: Assess the specific security risks carefully before enabling this option. For example, allowing discards on encrypted devices may lead to the leak of information about\n           the ciphertext device (filesystem type, used space etc.) if the discarded blocks can be located easily on the device later.\n\n       luks\n           Force LUKS mode. When this mode is used, the following options are ignored since they are provided by the LUKS header on the device: cipher=, hash=, size=\n\n       plain\n           Force plain encryption mode.\n\n       bitlk\n           Force BITLK (Windows BitLocker-compatible) mode. WARNING: crypttab support is currently experimental.\n\n       fvault2\n           Force Apple's FileVault2 mode. Only the (legacy) FileVault2 format based on Core Storage and HFS+ filesystem (introduced in MacOS X 10.7 Lion) is currently supported; the new\n           version of FileVault based on the APFS filesystem used in recent macOS versions is not supported.\n\n       tcrypt\n           Use TrueCrypt encryption mode. When this mode is used, the following options are ignored since they are provided by the TrueCrypt header on the device or do not apply: cipher=,\n           hash=, keyfile-offset=, keyfile-size=, size=\n\n       veracrypt, tcrypt-veracrypt\n           Use VeraCrypt extension to TrueCrypt device. Only useful in conjunction with tcrypt option (ignored for non-TrueCrypt devices).\n\n       tcrypthidden, tcrypt-hidden\n           Use hidden TCRYPT header (ignored for non-TCRYPT devices).\n\n       same-cpu-crypt\n           Perform encryption using the same cpu that IO was submitted on.\n\n       submit-from-crypt-cpus\n           Disable offloading writes to a separate thread after encryption.\n\n       no-read-workqueue, no-write-workqueue\n           Bypass dm-crypt internal workqueue and process read or write requests synchronously.\n\n       swap\n           Run mkswap on the created device.\n\n           This option is ignored for initramfs devices.\n\n       tmp[= ]\n           Run mkfs with filesystem type   (or ext4 if omitted) on the created device.\n\n           This option is ignored for initramfs devices.\n\n       check[= ]\n           Check the content of the target device by a suitable program; if the check fails, the device is closed immediately. The program is being run with decrypted volume (target device)\n           as first positional argument and, if the checkargs option is used, its value as second argument. See the CHECKSCRIPTS section for more information.\n\n           The program is either specified by full path or relative to /lib/cryptsetup/checks/. If omitted, then the value of $CRYPTDISKS_CHECK set in /etc/default/cryptdisks is used (blkid\n           by default).\n\n           This option is specific to the Debian crypttab format. It's not supported by systemd.\n\n       checkargs= \n           Give   as the second argument to the check script. See the CHECKSCRIPTS section for more information.\n\n           This option is specific to the Debian crypttab format. It's not supported by systemd.\n\n       initramfs\n           The initramfs hook processes the root device, any resume devices and any devices with the initramfs option set. These devices are processed within the initramfs stage of boot. As\n           an example, that allows the use of remote unlocking using dropbear.\n\n           This option is specific to the Debian crypttab format. It's not supported by systemd.\n\n       noearly\n           The cryptsetup init scripts are invoked twice during the boot process - once before lvm, raid, etc. are started and once again after that. Sometimes you need to start your\n           encrypted disks in a special order. With this option the device is ignored during the first invocation of the cryptsetup init scripts.\n\n           This option is ignored for initramfs devices and specific to the Debian crypttab format. It's not supported by systemd.\n\n       noauto\n           Entirely ignore the device at the boot process. It's still possible to map the device manually using cryptdisks_start.\n\n           This option is ignored for initramfs devices and specific to the Debian crypttab format.\n\n       loud\n           Be loud. Print warnings if a device does not exist. This option overrides the option quiet.\n\n           This option is ignored for initramfs devices and specific to the Debian crypttab format. It's not supported by systemd.\n\n       quiet\n           Be quiet. Don't print warnings if a device does not exist. This option overrides the option loud.\n\n           This option is ignored for initramfs devices and specific to the Debian crypttab format. It's not supported by systemd.\n\n       keyscript= \n           The executable at the indicated path is executed with the value of the third field as only argument. The keyscript's standard output is passed to cryptsetup as decyption key. Its\n           exit status is currently ignored, but no assumption should be made in that regard. When used in initramfs, the executable either needs to be self-contained (i.e. doesn't rely on\n           any external program which is not present in the initramfs environment) or the dependencies have to added to the initramfs image by other means. The program is either specified by\n           full path or relative to /lib/cryptsetup/scripts/.\n\n           LIMITATIONS: All binaries and files on which the keyscript depends must be available at the time of execution. Special care needs to be taken for encrypted filesystems like /usr\n           or /var. As an example, unlocking encrypted /usr must not depend on binaries from /usr/(s)bin.\n\n           This option is specific to the Debian crypttab format. It's not supported by systemd.\n\n           WARNING: With systemd as init system, this option might be ignored. At the time this is written (December 2016), the systemd cryptsetup helper doesn't support the keyscript option\n           to /etc/crypttab. For the time being, the only option to use keyscripts along with systemd is to force processing of the corresponding crypto devices in the initramfs. See the\n           'initramfs' option for further information.\n\n           All fields of the appropriate crypttab entry are available to the keyscript as exported environment variables:\n\n           CRYPTTAB_NAME, _CRYPTTAB_NAME\n               The target name (after resp. before octal sequence decoding).\n\n           CRYPTTAB_SOURCE, _CRYPTTAB_SOURCE\n               The source device (after resp. before octal sequence decoding and device resolution).\n\n           CRYPTTAB_KEY, _CRYPTTAB_KEY\n               The value of the third field (after resp. before octal sequence decoding).\n\n           CRYPTTAB_OPTIONS, _CRYPTTAB_OPTIONS\n               A list of exported crypttab options (after resp. before octal sequence decoding).\n\n           CRYPTTAB_OPTION_ \n               The value of the appropriate crypttab option, with value set to 'yes' in case the option is merely a flag. For option aliases, such as 'readonly' and 'read-only', the variable\n               name refers to the first alternative listed (thus 'CRYPTTAB_OPTION_readonly' in that case). If the crypttab option name contains '-' characters, then they are replaced with\n               '_' in the exported variable name. For instance, the value of the 'CRYPTTAB_OPTION_keyfile_offset' environment variable is set to the value of the 'keyfile-offset' crypttab\n               option.\n\n           CRYPTTAB_TRIED\n               Number of previous tries since start of cryptdisks (counts until maximum number of tries is reached).\n\nCHECKSCRIPTS\n       blkid\n           Checks for any known filesystem. Supports a filesystem type as argument via  :\n\n           •   no checkargs - succeeds if any valid filesystem is found on the device.\n\n           •   \"none\" - succeeds if no valid filesystem is found on the device.\n\n           •   \"ext4\" [or another filesystem type like xfs, swap, crypto_LUKS, ...] - succeeds if ext4 filesystem is found on the device.\n\n       un_blkid\n           Checks for no known filesystem. Supports a filesystem type as argument via  :\n\n           •   no checkargs - succeeds if no valid filesystem is found on the device.\n\n           •   \"ext4\" [or another filesystem type like xfs, swap, crypto_LUKS, ...] - succeeds if no ext4 filesystem is found on the device.\n\nEXAMPLES\n           # Encrypted swap device\n           cswap /dev/sda6 /dev/urandom plain,cipher=aes-xts-plain64,size=256,hash=sha1,swap\n\n           # Encrypted LUKS disk with interactive password, identified by its UUID, discard enabled\n           cdisk0 UUID=12345678-9abc-def012345-6789abcdef01 none luks,discard\n\n           # Encrypted TCRYPT disk with interactive password, discard enabled\n           tdisk0 /dev/sr0 none tcrypt,discard\n\n           # Encrypted ext4 disk with interactive password, discard enabled\n           # - retry 5 times if the check fails\n           cdisk1 /dev/sda2 none plain,cipher=aes-xts-plain64,size=256,hash=sha1,check,checkargs=ext4,tries=5,discard\n\n           # Encrypted disk with interactive password, discard enabled\n           # - use a nondefault check script\n           # - no retries\n           cdisk2 /dev/sdc1 none plain,cipher=aes-xts-plain64,size=256,hash=sha1,check=customscript,tries=1,discard\n\n           # Encrypted disk with interactive password, discard enabled\n           # - Twofish as the cipher, RIPEMD-160 as the hash\n           cdisk3 /dev/sda3 none plain,cipher=twofish,size=256,hash=ripemd160,discard\n\nENVIRONMENT\n       CRYPTDISKS_ENABLE\n           Set to yes to run cryptdisks initscripts at startup. Set to no to disable cryptdisks initscripts. Default is yes.\n\n       CRYPTDISKS_MOUNT\n           Specifies the mountpoints that are mounted before cryptdisks is invoked. Takes mountpoints configured in /etc/fstab as arguments. Separate mountpoints by space. This is useful for\n           keys on removable devices, such as cdrom, usbstick, flashcard, etc. Default is unset.\n\n       CRYPTDISKS_CHECK\n           Specifies the default checkscript to be run against the target device, after cryptdisks has been invoked. The target device is passed as the first and only argument to the\n           checkscript. Takes effect if the check option is given in crypttab with no value. See documentation for check option above for more information.\n\nKNOWN UPGRADE ISSUES\n       The upstream defaults for encryption cipher, hash and keysize have changed several times in the past, and they're expected to change again in future, for example if security issues\n       arise. On LUKS devices, the used settings are stored in the LUKS header, and thus don't need to be configured in /etc/crypttab. For plain dm-crypt devices, no information about used\n       cipher, hash and keysize are available at all. Therefore we strongly suggest to configure the cipher, hash and keysize in /etc/crypttab for plain dm-crypt devices, even if they match\n       the current default.\n\nSEE ALSO\n       cryptsetup(8), cryptdisks_start(8), cryptdisks_stop(8), /usr/share/doc/cryptsetup-initramfs/README.initramfs.gz\n\nAUTHOR\n       This manual page was originally written by Bastian Kleineidam   for the Debian distribution of cryptsetup. It has been further improved by Michael Gebetsroither\n        , David Härdeman   and Jonas Meurer  .\n\ncryptsetup 2:2.7.5-2                                                                      2025-05-04                                                                               CRYPTTAB(5)","ref":"crypttab.html"},{"type":"extras","title":"cups-browsed.conf","doc":"cups-browsed.conf(5)                                                                                                                                                      cups-browsed.conf(5)\n\nNAME\n       cups-browsed.conf - server configuration file for cups-browsed\n\nDESCRIPTION\n       The cups-browsed.conf file configures the cups-browsed daemon. It is normally located in the /etc/cups directory. Each line in the file can be a configuration directive, a blank line,\n       or a comment. Comment lines start with the # character.\n\nDIRECTIVES\n       The \"CacheDir\" directive determines where cups-browsed should save information about the print queues it had generated when shutting down, like whether one of these queues was the de‐\n       fault printer, or default option settings of the queues.\n\n               CacheDir /var/cache/cups\n\n       With \"LogDir\" can be defined where cups-browsed creates its debug log file (if \"DebugLogging file\" is set).\n\n               LogDir /var/log/cups\n\n       The \"DebugLogging\" directive determines how should debug logging be done.  Into the file /var/log/cups/cups-browsed_log (\"file\"), to stderr (\"stderr\"), or not at all (\"none\").\n\n       Note  that if cups-browsed is running as a system service (for example via systemd) logging to stderr makes the log output going to the journal or syslog. Only if you run cups-browsed\n       from the command line (for development or debugging) it will actually appear on stderr.\n\n               DebugLogging file\n               DebugLogging stderr\n               DebugLogging file stderr\n               DebugLogging none\n\n       Only browse remote printers (via DNS-SD or CUPS browsing) from selected servers using the \"BrowseAllow\", \"BrowseDeny\", and \"BrowseOrder\" directives\n\n       This serves for restricting the choice of printers in print dialogs to trusted servers or to reduce the number of listed printers in the print dialogs to a more  user-friendly  amount\n       in large networks with very many shared printers.\n\n       This only filters the selection of remote printers for which cups-browsed creates local queues. If the print dialog uses other mechanisms to list remote printers as for example direct\n       DNS-SD access, cups-browsed has no influence. cups-browsed also does not prevent the user from manually accessing non-listed printers.\n\n       \"BrowseAllow\":  Accept  printers  from these hosts or networks. If there are only \"BrowseAllow\" lines and no \"BrowseOrder\" and/or \"BrowseDeny\" lines, only servers matching at last one\n       \"BrowseAllow\" line are accepted.\n\n       \"BrowseDeny\": Deny printers from these hosts or networks. If there are only \"BrowseDeny\" lines and no \"BrowseOrder\" and/or \"BrowseAllow\" lines, all servers NOT  matching  any  of  the\n       \"BrowseDeny\" lines are accepted.\n\n       \"BrowseOrder\":  Determine  the  order  in  which  \"BrowseAllow\"  and  \"BrowseDeny\" lines are applied. With \"BrowseOrder Deny,Allow\" in the beginning all servers are accepted, then the\n       \"BrowseDeny\" lines are applied to exclude unwished servers or networks and after that the \"BrowseAllow\" lines to re-include servers or networks. With \"BrowseOrder Allow,Deny\" we start\n       with denying all servers, then applying the \"BrowseAllow\" lines and afterwards the \"BrowseDeny\" lines.\n\n       Default for \"BrowseOrder\" is \"Deny.Allow\" if there are both \"BrowseAllow\" and \"BrowseDeny\" lines.\n\n       If there are no \"Browse...\" lines at all, all servers are accepted.\n\n               BrowseAllow All\n               BrowseAllow 192.168.7.20\n               BrowseAllow 192.168.7.0/24\n               BrowseAllow 192.168.7.0/255.255.255.0\n\n               BrowseDeny All\n               BrowseDeny 192.168.1.13\n               BrowseDeny 192.168.3.0/24\n               BrowseDeny 192.168.3.0/255.255.255.0\n\n               BrowseOrder Deny,Allow\n               BrowseOrder Allow,Deny\n\n       Filtering of remote printers by other properties than IP addresses of their servers\n\n       Often the desired selection of printers cannot be reached by only taking into account the IP addresses of the servers. For these cases there is the BrowseFilter directive to filter by\n       most of the known properties of the printer.\n\n       By default there is no BrowseFilter line meaning that no filtering is applied.\n\n       To do filtering one can supply one or more BrowseFilter directives like this:\n\n               BrowseFilter [NOT] [EXACT]   [ ]\n\n       The BrowseFilter directive always starts with the word \"BrowseFilter\" and it must at least contain the name of the data field ( ) of the printer's properties to which it  should\n       apply.\n\n       Available field names are:\n\n               name:    Name of the local print queue to be created\n               host:    Host name of the remote print server\n               port:    Port through which the printer is accessed on the server\n               service: DNS/SD service name of the remote printer\n               domain:  Domain of the remote print server\n\n       Also  all  field  names  in  the  TXT  records  of DNS-SD-advertised printers are valid, like \"color\", \"duplex\", \"pdl\", ... If the field name of the filter rule does not exist for the\n       printer, the rule is skipped.\n\n       The optional   field is either the exact value (when the option EXACT is supplied) or a regular expression (Run \"man 7 regex\" in a terminal window) to be matched with  the  data\n       field.\n\n       If no   filed is supplied, rules with field names of the TXT record are considered for boolean matching (true/false) of boolean field (like duplex, which can have the values \"T\"\n       for true and \"F\" for false).\n\n       If  the  option  NOT  is  supplied,  the filter rule is fulfilled if the regular expression or the exact value DOES NOT match the content of the data field. In a boolean rule (without\n        ) the rule matches false.\n\n       Regular expressions are always considered case-insensitive and extended POSIX regular expressions. Field names and options (NOT, EXACT) are all evaluated case-insensitive. If there is\n       an error in a regular expression, the BrowseFilter line gets ignored.\n\n       Especially to note is that supplying any simple string consisting of only letters, numbers, spaces, and some basic special characters as a regular expression matches  if  it  is  con‐\n       tained somewhere in the data field.\n\n       If there is more than one BrowseFilter directive, ALL the directives need to be fulfilled for the remote printer to be accepted. If one is not fulfilled, the printer will get ignored.\n\n       Examples:\n\n       Rules for standard data items which are supplied with any remote printer advertised via DNS-SD:\n\n       Print queue name must contain \"hum_res_\", this matches \"hum_res_mono\" or \"hum_res_color\" but also \"old_hum_res_mono\":\n\n               BrowseFilter name hum_res_\n\n       This matches if the remote host name contains \"printserver\", like \"printserver.local\", \"printserver2.example.com\", \"newprintserver\":\n\n               BrowseFilter host printserver\n\n       This matches all ports with 631 int its number, for example 631, 8631, 10631,...:\n\n               BrowseFilter port 631\n\n       This rule matches if the DNS-SD service name contains \"@ printserver\":\n\n               Browsefilter service @ printserver\n\n       Matches all domains with \"local\" in their names, not only \"local\" but also things like \"printlocally.com\":\n\n               BrowseFilter domain local\n\n       Examples for rules applying to items of the TXT record:\n\n       This  rule  selects PostScript printers, as the \"PDL\" field in the TXT record contains \"postscript\" then. This includes also remote CUPS queues which accept PostScript, independent of\n       whether the physical printer behind the CUPS queue accepts PostScript or not.\n\n               BrowseFilter pdl postscript\n\n       Color printers usually contain a \"Color\" entry set to \"T\" (for true) in the TXT record. This rule selects them:\n\n               BrowseFilter color\n\n       This is a similar rule to select only duplex (automatic double-sided printing) printers:\n\n               BrowseFilter duplex\n\n       Rules with the NOT option:\n\n       This rule EXCLUDES printers from all hosts containing \"financial\" in their names, nice to get rid of the 100s of printers of the financial department:\n\n               BrowseFilter NOT host financial\n\n       Get only monochrome printers (\"Color\" set to \"F\", meaning false, in the TXT record):\n\n               BrowseFilter NOT color\n\n       Rules with more advanced use of regular expressions:\n\n       Only queue names which BEGIN WITH \"hum_res_\" are accepted now, so we still get \"hum_res_mono\" or \"hum_res_color\" but not \"old_hum_res_mono\" any more:\n\n               BrowseFilter name ^hum_res_\n\n       Server names is accepted if it contains \"print_server\" OR \"graphics_dep_server\":\n\n               BrowseFilter host print_server|graphics_dep_server\n\n       \"printserver1\", \"printserver2\", and \"printserver3\", nothing else:\n\n               BrowseFilter host ^printserver[1-3]$\n\n       Printers understanding at least one of PostScript, PCL, or PDF:\n\n               BrowseFilter pdl postscript|pcl|pdf\n\n       Examples for the EXACT option:\n\n       Only printers from \"printserver.local\" are accepted:\n\n               BrowseFilter EXACT host printserver.local\n\n       Printers from all servers except \"prinserver2.local\" are accepted:\n\n               BrowseFilter NOT EXACT host prinserver2.local\n\n       The BrowsePoll directive polls a server for available printers once every 60 seconds. Multiple BrowsePoll directives can be specified to poll multiple servers.  The  default  port  to\n       connect to is 631.  BrowsePoll works independently of whether CUPS browsing is activated in BrowseRemoteProtocols.\n\n               BrowsePoll 192.168.7.20\n               BrowsePoll 192.168.7.65:631\n               BrowsePoll host.example.com:631\n\n       The  BrowseLocalProtocols directive specifies the protocols to use when advertising local shared printers on the network. The default is \"none\". Control of advertising of local shared\n       printers using dnssd is done in /etc/cups/cupsd.conf.\n\n               BrowseLocalProtocols none\n               BrowseLocalProtocols CUPS\n\n       The BrowseRemoteProtocols directive specifies the protocols to use when finding remote shared printers on the network. Multiple protocols can be  specified  by  separating  them  with\n       spaces.  The default is \"dnssd cups\".\n\n               BrowseRemoteProtocols none\n               BrowseRemoteProtocols CUPS dnssd\n               BrowseRemoteProtocols CUPS\n               BrowseRemoteProtocols dnssd\n               BrowseRemoteProtocols ldap\n\n       The  BrowseProtocols  directive specifies the protocols to use when finding remote shared printers on the network and advertising local shared printers. \"dnssd\" and \"ldap\" are ignored\n       for BrowseLocalProtocols.  Multiple protocols can be specified by separating them with spaces. The default is \"none\" for BrowseLocalProtocols and \"dnssd cups\"  for  BrowseRemoteProto‐\n       cols.\n\n               BrowseProtocols none\n               BrowseProtocols CUPS dnssd\n               BrowseProtocols CUPS\n               BrowseProtocols dnssd\n               BrowseProtocols ldap\n\n       The  configuration  for the LDAP browsing mode define where the LDAP search should be performed. If built with an LDAP library that supports TLS, the path to the server's certificate,\n       or to a certificates store, can be specified.  The optional filter allows the LDAP search to be more specific, and is used  in  addition  to  the  hardcoded  filter  (objectclass=cup‐\n       sPrinter).\n\n               BrowseLDAPBindDN cn=cups-browsed,dc=domain,dc=tld\n               BrowseLDAPCACertFile /path/to/server/certificate.pem\n               BrowseLDAPDN ou=printers,dc=domain,dc=tld\n               BrowseLDAPFilter (printerLocation=/Office 1/*)\n               BrowseLDAPPassword s3cret\n               BrowseLDAPServer ldaps://ldap.domain.tld\n\n       The DomainSocket directive specifies the domain socket through which the locally running CUPS daemon is accessed. If not specified the standard domain socket of CUPS is used. Use this\n       if  you  have  specified an alternative domain socket for CUPS via a Listen directive in /etc/cups/cupsd.conf. If cups-browsed is not able to access the local CUPS daemon via a domain\n       socket it accesses it via localhost. \"None\" or \"Off\" lets cups-browsed not use CUPS' domain socket.\n\n               DomainSocket /var/run/cups/cups.sock\n               DomainSocket None\n               DomainSocket Off\n\n       Set HTTP timeout (in seconds) for requests sent to local/remote resources Note that too short timeouts can make services getting missed when they are present and operations be  unnec‐\n       essarily repeated and too long timeouts can make operations take too long when the server does not respond.\n\n               HttpLocalTimeout 5\n               HttpRemoteTimeout 10\n\n       Set  how many retries (N) should cups-browsed do for creating print queues for remote printers which receive timeouts during print queue creation.  The printers which are not success‐\n       fully set up even after N retries, are skipped until the next restart of the service.  Note that too many retries can cause high CPU load.\n\n               HttpMaxRetries 5\n\n       The interval between browsing/broadcasting cycles, local and/or remote, can be adjusted with the BrowseInterval directive.\n\n               BrowseInterval 60\n\n       The BrowseTimeout directive determines the amount of time that browsing-related operations are allowed to take in seconds.  Notably, adding or removing one printer queue is considered\n       as one operation. The timeout applies to each one of those operations.  Especially queues discovered by CUPS broadcasts will be removed after this timeout if no further broadcast from\n       the server happens.\n\n               BrowseTimeout 300\n\n       The AllowResharingRemoteCUPSPrinters directive determines whether a print queue pointing to a remote CUPS queue will be re-shared to the local network or not. Since the queues  gener‐\n       ated using the BrowsePoll directive are also pointing to remote queues, they are also shared automatically if the following option is set. Default is not to share remote queues.\n\n               AllowResharingRemoteCUPSPrinters Yes\n\n       The NewBrowsePollQueuesShared directive determines whether a print queue for a newly discovered printer (discovered by the BrowsePoll directive) will be shared to the local network or\n       not. This directive will only work if AllowResharingRemoteCUPSPrinters is set to yes. Default is not to share printers discovered using BrowsePoll.\n\n               NewBrowsePollQueuesShared Yes\n\n       Set  OnlyUnsupportedByCUPS to \"Yes\" will make cups-browsed not create local queues for remote printers for which CUPS creates queues by itself.  These printers are printers advertised\n       via DNS-SD and doing CUPS-supported (currently PWG Raster and Apple Raster) driverless printing, including remote CUPS queues.  Queues  for  other  printers  (like  for  legacy  Post‐\n       Script/PCL printers) are always created (depending on the other configuration settings of cups-browsed).\n\n       With  OnlyUnsupportedByCUPS  set  to  \"No\",  cups-browsed creates queues for all printers which it supports, including printers for which CUPS would create queues by itself. Temporary\n       queues created by CUPS will get overwritten. This way it is assured that any extra functionality of cups-browsed will apply to these queues. As queues created by cups-browsed are per‐\n       manent CUPS queues this setting is also recommended if applications/print dialogs which do not support temporary CUPS queues are installed. This setting is the default.\n\n               OnlyUnsupportedByCUPS Yes\n\n       With UseCUPSGeneratedPPDs set to \"Yes\" cups-browsed creates queues for IPP printers with PPDs generated by the PPD generator of CUPS and not with the one of cups-browsed. So  any  new\n       development  in  CUPS'  PPD  generator  gets  available. As CUPS' PPD generator is not directly accessible, we need to make CUPS generate a temporary print queue with the desired PPD.\n       Therefore we can only use these PPDs when our queue replaces a temporary CUPS queue, meaning that the queue is for a printer on which CUPS supports driverless printing (IPP 2.x, PDLs:\n       PDF, PWG Raster, and/or Apple Raster) and that its name is the same as CUPS uses for the temporary queue (\"LocalQueueNamingIPPPrinter DNS-SD\" must be set). The directive applies  only\n       to IPP printers, not to remote CUPS queues, to not break clustering. Setting this directive to \"No\" lets cups-browsed generate the PPD file. Default setting is \"No\".\n\n               UseCUPSGeneratedPPDs No\n\n       With  the directives LocalQueueNamingRemoteCUPS and LocalQueueNamingIPPPrinter you can determine how the names for local queues generated by cups-browsed are generated, separately for\n       remote CUPS printers and IPP printers.\n\n       \"DNS-SD\" (the default in both cases) bases the naming on the service name of the printer's advertised DNS-SD record. This is exactly the same naming scheme as CUPS uses for its tempo‐\n       rary queues, so the local queue from cups-browsed prevents CUPS from listing and creating an additional queue. As DNS-SD service names have to be unique, queue names of printers  from\n       different servers will also be unique and so there is no automatic clustering for load-balanced printing.\n\n       \"MakeModel\" bases the queue name on the printer's manufacturer and model names. This scheme cups-browsed used formerly for IPP printers.\n\n       \"RemoteName\" is only available for remote CUPS queues and uses the name of the queue on the remote CUPS server as the local queue's name. This makes printers on different CUPS servers\n       with  equal queue names automatically forming a load-balancing cluster as CUPS did formerly (CUPS 1.5.x and older) with CUPS-broadcasted remote printers. This scheme cups-browsed used\n       formerly for remote CUPS printers.\n\n               LocalQueueNamingRemoteCUPS DNS-SD\n               LocalQueueNamingRemoteCUPS MakeModel\n               LocalQueueNamingRemoteCUPS RemoteName\n               LocalQueueNamingIPPPrinter DNS-SD\n               LocalQueueNamingIPPPrinter MakeModel\n\n       Set DNSSDBasedDeviceURIs to \"Yes\" if cups-browsed should use DNS-SD-service-name-based device URIs for its local queues, as CUPS also does. These queues use the DNS-SD service name of\n       the discovered printer. With this the URI is independent of network interfaces and ports, giving reliable connections to always the same physical device. This setting is the default.\n\n       Set DNSSDBasedDeviceURIs to \"No\" if cups-browsed should use the conventional host-name/IP-based URIs.\n\n       Note that this option has only influence on URIs for printers discovered via DNS-SD, not via legacy CUPS broewsing or LDAP.  Those printers get always assigned the conventional URIs.\n\n               DNSSDBasedDeviceURIs Yes\n\n       Set IPBasedDeviceURIs to \"Yes\" if cups-browsed should create its local queues with device URIs with the IP addresses instead of the host names of the  remote  servers.  This  mode  is\n       there for any problems with host name resolution in the network, especially also if avahi-daemon is only run for printer discovery and already stopped while still printing. By default\n       this mode is turned off, meaning that we use URIs with host names.\n\n       Note  that the IP addresses depend on the network interface through which the printer is accessed. So do not use IP-based URIs on systems with many network interfaces and where inter‐\n       faces can appear and disappear frequently.\n\n       This mode could also be useful for development and debugging.\n\n       If you prefer IPv4 or IPv6 IP addresses in the URIs, you can set IPBasedDeviceURIs to \"IPv4\" to only get IPv4 IP addresses or IPBasedDeviceURIs to \"IPv6\"  to  only  get  IPv6  IP  ad‐\n       dresses.\n\n               IPBasedDeviceURIs No\n               IPBasedDeviceURIs Yes\n               IPBasedDeviceURIs IPv4\n               IPBasedDeviceURIs IPv6\n\n       Set  CreateRemoteRawPrinterQueues  to  \"Yes\"  to  let  cups-browsed  also  create local queues pointing to remote raw CUPS queues. Normally, only queues pointing to remote queues with\n       PPD/driver are created as we do not use drivers on the client side, but in some cases accessing a remote raw queue can make sense, for example if the queue forwards the jobs by a spe‐\n       cial backend like Tea4CUPS.\n\n               CreateRemoteRawPrinterQueues Yes\n\n       cups-browsed by default creates local print queues for each shared CUPS print queue which it discovers on remote machines in the local network(s). Set CreateRemoteCUPSPrinterQueues to\n       \"No\" if you do not want cups-browsed to do this. For example you can set cups-browsed to only create queues for IPP network printers setting CreateIPPPrinterQueues  not  to  \"No\"  and\n       CreateRemoteCUPSPrinterQueues to \"No\".\n\n               CreateRemoteCUPSPrinterQueues No\n\n       Set  CreateIPPPrinterQueues to \"All\" to let cups-browsed discover IPP network printers (native printers, not CUPS queues) with known page description languages (PWG Raster, PDF, Post‐\n       Script, PCL XL, PCL 5c/e) in the local network and auto-create print queues for them.\n\n       Set CreateIPPPrinterQueues to \"Everywhere\" to let cups-browsed discover IPP Everywhere printers in the local network (native printers, not CUPS queues) and  auto-create  print  queues\n       for them.\n\n       Set CreateIPPPrinterQueues to \"AppleRaster\" to let cups-browsed discover Apple Raster printers in the local network (native printers, not CUPS queues) and auto-create print queues for\n       them.\n\n       Set  CreateIPPPrinterQueues  to \"Driverless\" to let cups-browsed discover printers designed for driverless use (currently IPP Everywhere and Apple Raster) in the local network (native\n       printers, not CUPS queues) and auto-create print queues for them.\n\n       Set CreateIPPPrinterQueues to \"LocalOnly\" to auto-create print queues only for local printers made available as IPP printers. These are for example IPP-over-USB printers, made  avail‐\n       able via ippusbxd(8). This is the default.\n\n       Set CreateIPPPrinterQueues to \"No\" to not auto-create print queues for IPP network printers.\n\n       If queues with PPD file are created (see IPPPrinterQueueType directive below) the PPDs are auto-generated by cups-browsed based on properties of the printer polled via IPP. In case of\n       missing information, info from the Bonjour record is used asd as last mean default values.\n\n       If  queues  without PPD (see IPPPrinterQueueType directive below) are created clients have to IPP-poll the capabilities of the printer and send option settings as standard IPP attrib‐\n       utes. Then we do not poll the capabilities by ourselves to not wake up the printer from power-saving mode when creating the queues. Jobs have to be sent in one of PDF, PWG Raster,  or\n       JPEG format. Other formats are not accepted.\n\n       This functionality is primarily for mobile devices running CUPS to not need a printer setup tool nor a collection of printer drivers and PPDs.\n\n               CreateIPPPrinterQueues No\n               CreateIPPPrinterQueues LocalOnly\n               CreateIPPPrinterQueues Everywhere\n               CreateIPPPrinterQueues AppleRaster\n               CreateIPPPrinterQueues Everywhere AppleRaster\n               CreateIPPPrinterQueues Driverless\n               CreateIPPPrinterQueues All\n\n       If  cups-browsed  is  automatically  creating print queues for native IPP network printers (\"CreateIPPPrinterQueues Yes\"), the type of queue to be created can be selected by the \"IPP‐\n       PrinterQueueType\" directive. The \"PPD\" (default) setting makes queues with PPD file being created. With \"Interface\" or \"NoPPD\" the queue is created with a System  V  interface  script\n       (Not supported with CUPS 2.2.x or later). \"Auto\" is for backward compatibility and also lets queues with PPD get created.\n\n               IPPPrinterQueueType PPD\n               IPPPrinterQueueType NoPPD\n               IPPPrinterQueueType Interface\n               IPPPrinterQueueType Auto\n\n       The NewIPPPrinterQueuesShared directive determines whether a print queue for a newly discovered IPP network printer (not remote CUPS queue) will be shared to the local network or not.\n       This  is only valid for newly discovered printers. For printers discovered in an earlier cups-browsed session, cups-browsed will remember whether the printer was shared, so changes by\n       the user get conserved. Default is not to share newly discovered IPP printers.\n\n               NewIPPPrinterQueuesShared Yes\n\n       How to handle the print queues cups-browsed creates when cups-browsed is shut down:\n\n       \"KeepGeneratedQueuesOnShutdown No\" makes the queues being removed. This makes sense as these queues only work while cups-browsed is running. cups-browsed has  to  determine  to  which\n       member printer of a cluster to pass on the job.\n\n       \"KeepGeneratedQueuesOnShutdown  Yes\"  (the default) makes the queues not being removed. This is the recommended setting for a system where cups-browsed is permanently running and only\n       stopped for short times (like log rotation) or on shutdown. This avoids the re-creation of the queues when cups-browsed is restarted, which often causes a clutter  of  CUPS  notifica‐\n       tions on the desktop.\n\n               KeepGeneratedQueuesOnShutdown No\n\n       If there is more than one remote CUPS printer whose local queue would get the same name and AutoClustering is set to \"Yes\" (the default) only one local queue is created which makes up\n       a load-balancing cluster of the remote printers which would get this queue name (implicit class). This means that when several jobs are sent to this queue they get distributed between\n       the printers, using the method chosen by the LoadBalancing directive.\n\n       Note  that  the forming of clusters depends on the naming scheme for local queues created by cups-browsed. If you have set LocalQueueNamingRemoteCUPS to \"DNSSD\" you will not get auto‐\n       matic clustering as the DNS-SD service names are always unique. With LocalQueueNamingRemoteCUPS set to \"RemoteName\" local queues are named as the CUPS queues on the remote servers are\n       named and so equally named queues on different servers get clustered (this is how CUPS did it in version 1.5.x or older). LocalQueueNamingRemoteCUPS set to  \"MakeModel\"  makes  remote\n       printers of the same model get clustered. Note that then a cluster can contain more than one queue of the same server.\n\n       With  AutoClustering  set to \"No\", for each remote CUPS printer an individual local queue is created, and to avoid name clashes when using the LocalQueueNamingRemoteCUPS settings \"Re‐\n       moteName\" or \"MakeModel\" \"@ \" is added to the local queue name.\n\n       Only remote CUPS printers get clustered, not IPP network printers or IPP-over-USB printers.\n\n               AutoClustering Yes\n               AutoClustering No\n\n       Load-balancing printer cluster formation can also be manually controlled by defining explicitly which remote CUPS printers should get clustered together.\n\n       This is done by the \"Cluster\" directive:\n\n               Cluster  :     ...\n               Cluster  \n\n       If no expressions are given,   is used as the first and only expression for this cluster.\n\n       Discovered printers are matched against all the expressions of all defined clusters. The first expression which matches the discovered printer determines to which cluster it  belongs.\n       Note that this way a printer can only belong to one cluster. Once matched, further cluster definitions will not checked any more.\n\n       With  the first printer matching a cluster's expression a local queue with the name   is created. If more printers are discovered and match this cluster, they join the clus‐\n       ter. Printing to this queue prints to all these printers in a load-balancing manner, according to to the setting of the LoadBalancing directive.\n\n       Each expression must be a string of characters without spaces. If spaces are needed, replace them by underscores ('_').\n\n       An expression can be matched in three ways:\n\n           1. By the name of the CUPS queue on the remote server\n           2. By make and model name of the remote printer\n           3. By the DNS-SD service name of the remote printer\n\n       Note that the matching is done case-insensitively and any group of non-alphanumerical characters is replaced by a single underscore.\n\n       So if an expression is \"HP_DeskJet_2540\" and the remote server reports \"hp Deskjet-2540\" the printer gets matched to this cluster.\n\n       If \"AutoClustering\" is not set to \"No\" both your manual cluster definitions will be followed and automatic clustering of equally-named remote queues will be performed.  If  a  printer\n       matches  in  both  categories the match to the manually defined cluster has priority. Automatic clustering of equally-named remote printers is not performed if there is a manually de‐\n       fined cluster with this name (at least as the printers do not match this cluster).\n\n       Examples:\n\n       To cluster all remote CUPS queues named \"laserprinter\" in your local network but not cluster any other equally-named remote CUPS printers use  (Local  queue  will  get  named  \"laser‐\n       printer\"):\n\n               AutoClustering No\n               Cluster laserprinter\n\n       To cluster all remote CUPS queues of HP LaserJet 4050 printers in a local queue named \"LJ4050\":\n\n               Cluster LJ4050: HP_LaserJet_4050\n\n       As DNS-SD service names are unique in a network you can create a cluster from exactly specified printers (spaces replaced by underscores):\n\n               Cluster hrdep: oldlaser_@_hr-server1 newlaser_@_hr-server2\n\n       The  LoadBalancing  directive  switches  between  two methods of handling load balancing between equally-named remote queues which are represented by one local print queue making up a\n       cluster of them (implicit class).\n\n       The two methods are:\n\n       Queuing of jobs on the client (LoadBalancing QueueOnClient):\n\n       Here we queue up the jobs on the client and regularly check the clustered remote print queues. If we find an idle queue, we pass on a job to it.\n\n       This is also the method which CUPS uses for classes. Advantage is a more even distribution of the job workload on the servers (especially if the printing speed of the servers is  very\n       different),  and if a server fails, there are not several jobs stuck or lost. Disadvantage is that if one takes the client (laptop, mobile phone, ...) out of the local network, print‐\n       ing stops with the jobs waiting in the local queue.\n\n       Queuing of jobs on the servers (LoadBalancing QueueOnServers):\n\n       Here we check the number of jobs on each of the clustered remote printers and send an incoming job immediately to the remote printer with the lowest amount of jobs in its queue.  This\n       way no jobs queue up locally, all jobs which are waiting are waiting on one of the remote servers.\n\n       Not  having jobs waiting locally has the advantage that we can take the local machine from the network and all jobs get printed.  Disadvantage is that if a server with a full queue of\n       jobs goes away, the jobs go away, too.\n\n       Default is queuing the jobs on the client as this is what CUPS does with classes.\n\n               LoadBalancing QueueOnClient\n               LoadBalancing QueueOnServers\n\n       With the DefaultOptions directive one or more option settings can be defined to be applied to every print queue newly created by cups-browsed. Each option is supplied as one  supplies\n       options  with  the  \"-o\" command line argument to the \"lpadmin\" command (Run \"man lpadmin\" for more details). More than one option can be supplied separating the options by spaces. By\n       default no option settings are pre-defined.\n\n       Note that print queues which cups-browsed already created before remember their previous settings and so these settings do not get applied.\n\n               DefaultOptions Option1=Value1 Option2=Value2 Option3 noOption4\n\n       The AutoShutdown directive specifies whether cups-browsed should automatically terminate when it has no local raw queues set up pointing to any discovered remote printers or  no  jobs\n       on  such  queues  depending  on AutoShutdownOn setting (auto shutdown mode). Setting it to \"On\" activates the auto-shutdown mode, setting it to \"Off\" deactivates it (the default). The\n       special mode \"avahi\" turns auto shutdown off while avahi-daemon is running and on when avahi-daemon stops. This allows running cups-browsed on-demand when avahi-daemon is  run  on-de‐\n       mand.\n\n               AutoShutdown Off\n               AutoShutdown On\n               AutoShutdown avahi\n\n       The  AutoShutdownOn  directive  determines  what  event cups-browsed considers as inactivity in auto shutdown mode. \"NoQueues\" (the default) means that auto shutdown is initiated when\n       there are no queues for discovered remote printers generated by cups-browsed any more. \"NoJobs\" means that all queues generated by cups-browsed are without jobs.\n\n               AutoShutdownOn NoQueues\n               AutoShutdownOn NoJobs\n\n       DebugLogFileSize defines the maximum size possible (in KBytes) of the log files (cups-browsed_log and cups-browsed_previous_logs) that is created using cups-browsed in  the  debugging\n       mode.  Setting its value to 0 would turn off any restriction on the size of the file.\n\n               DebugLogFileSize 300\n\n       The  AutoShutdownTimeout  directive  specifies  after  how many seconds without local raw queues set up pointing to any discovered remote printers or jobs on these queues cups-browsed\n       should actually shut down in auto shutdown mode. Default is 30 seconds, 0 means immediate shutdown.\n\n               AutoShutdownTimeout 20\n\n       NotifLeaseDuration defines how long the D-BUS subscription created by cups-browsed in cupsd will last before cupsd cancels it. The default value is 1 day in seconds - 86400. The  sub‐\n       scription renewal is set to happen after half of NotifLeaseDuration passed. The D-BUS notifications are used for watching over queues and doing specific actions when a D-BUS notifica‐\n       tion comes.\n\n               NotifLeaseDuration 86400\n\nSEE ALSO\n       cups-browsed(8)\n\n       /usr/share/doc/cups-browsed/README.gz\n\nAUTHOR\n       The authors of cups-browsed are listed in /usr/share/doc/cups-browsed/AUTHORS.\n\n       This manual page was written for the Debian Project, but it may be used by others.\n\n                                                                                         29 June 2013                                                                     cups-browsed.conf(5)","ref":"cups-browsed-conf.html"},{"type":"extras","title":"cupsd.conf","doc":"cupsd.conf(5)                                                                            OpenPrinting                                                                            cupsd.conf(5)\n\nNAME\n       cupsd.conf - server configuration file for cups\n\nDESCRIPTION\n       The cupsd.conf file configures the CUPS scheduler, cupsd(8).  It is normally located in the /etc/cups directory.  Each line in the file can be a configuration directive, a blank line,\n       or a comment.  Configuration directives typically consist of a name and zero or more values separated by whitespace.  The configuration directive name and values are case-insensitive.\n       Comment lines start with the # character.\n\n   TOP-LEVEL DIRECTIVES\n       The following top-level directives are understood by cupsd(8):\n\n       AccessLogLevel config\n\n       AccessLogLevel actions\n\n       AccessLogLevel all\n            Specifies  the  logging level for the AccessLog file.  The \"config\" level logs when printers and classes are added, deleted, or modified and when configuration files are accessed\n            or updated.  The \"actions\" level logs when print jobs are submitted, held, released, modified, or canceled, and any of the conditions for \"config\".  The \"all\" level logs all  re‐\n            quests.  The default access log level is \"actions\".\n\n       AutoPurgeJobs Yes\n\n       AutoPurgeJobs No\n            Specifies whether to purge job history data automatically when it is no longer required for quotas.  The default is \"No\".\n\n       BrowseDNSSDSubTypes_subtype[,...]\n            Specifies  a list of Bonjour sub-types to advertise for each shared printer.  For example, \"BrowseDNSSDSubTypes _cups,_print\" will tell network clients that both CUPS sharing and\n            IPP Everywhere are supported.  The default is \"_cups\" which is necessary for printer sharing to work between systems using CUPS.\n\n       BrowseLocalProtocols all\n\n       BrowseLocalProtocols dnssd\n\n       BrowseLocalProtocols none\n            Specifies which protocols to use for local printer sharing.  The default is \"dnssd\" on systems that support Bonjour and \"none\" otherwise.\n\n       BrowseWebIF Yes\n\n       BrowseWebIF No\n            Specifies whether the CUPS web interface is advertised.  The default is \"No\".\n\n       Browsing Yes\n\n       Browsing No\n            Specifies whether shared printers are advertised.  The default is \"No\".\n\n       DefaultAuthType Basic\n            Specifies the default type of authentication to use.  The default is \"Basic\".\n\n       DefaultEncryption Never\n\n       DefaultEncryption IfRequested\n\n       DefaultEncryption Required\n            Specifies whether encryption will be used for authenticated requests.  The default is \"Required\".\n\n       DefaultLanguage locale\n            Specifies the default language to use for text and web content.  The default is \"en\".\n\n       DefaultPaperSize Auto\n\n       DefaultPaperSize None\n\n       DefaultPaperSize sizename\n            Specifies the default paper size for new print queues. \"Auto\" uses a locale-specific default, while \"None\" specifies there is no default paper size.  Specific size names are typ‐\n            ically \"Letter\" or \"A4\".  The default is \"Auto\".  Note: The default paper size must use a size name from the PPD file and not a PWG self-describing media size name.\n\n       DefaultPolicy policy-name\n            Specifies the default access policy to use.  The default access policy is \"default\".\n\n       DefaultShared Yes\n\n       DefaultShared No\n            Specifies whether local printers are shared by default.  The default is \"Yes\".\n\n       DirtyCleanInterval seconds\n            Specifies the delay for updating of configuration and state files.  A value of 0 causes the update to happen as soon as possible, typically within a few  milliseconds.   The  de‐\n            fault value is \"30\".\n\n       DNSSDHostNamehostname.example.com\n            Specifies the fully-qualified domain name for the server that is used for Bonjour sharing.  The default is typically the server's \".local\" hostname.\n\n       ErrorPolicy abort-job\n            Specifies that a failed print job should be aborted (discarded) unless otherwise specified for the printer.\n\n       ErrorPolicy retry-current-job\n            Specifies that a failed print job should be retried immediately unless otherwise specified for the printer.\n\n       ErrorPolicy retry-job\n            Specifies that a failed print job should be retried at a later time unless otherwise specified for the printer.\n\n       ErrorPolicy stop-printer\n            Specifies that a failed print job should stop the printer unless otherwise specified for the printer. The 'stop-printer' error policy is the default.\n\n       FilterLimit limit\n            Specifies  the  maximum  cost of filters that are run concurrently, which can be used to minimize disk, memory, and CPU resource problems.  A limit of 0 disables filter limiting.\n            An average print to a non-PostScript printer needs a filter limit of about 200.  A PostScript printer needs about half that (100).  Setting the limit below these thresholds  will\n            effectively limit the scheduler to printing a single job at any time.  The default limit is \"0\".\n\n       FilterNice nice-value\n            Specifies  the  scheduling priority ( nice(8) value) of filters that are run to print a job.  The nice value ranges from 0, the highest priority, to 19, the lowest priority.  The\n            default is 0.\n\n       HostNameLookups On\n\n       HostNameLookups Off\n\n       HostNameLookups Double\n            Specifies whether to do reverse lookups on connecting clients.  The \"Double\" setting causes cupsd(8) to verify that the hostname resolved from the address matches one of the  ad‐\n            dresses  returned for that hostname.  Double lookups also prevent clients with unregistered addresses from connecting to your server.  The default is \"Off\" to avoid the potential\n            server performance problems with hostname lookups.  Only set this option to \"On\" or \"Double\" if absolutely required.\n\n       IdleExitTimeout seconds\n            Specifies the length of time to wait before shutting down due to inactivity.  The default is \"60\" seconds.  Note: Only applicable when cupsd(8) is run on-demand (e.g., with -l).\n\n       JobKillDelay seconds\n            Specifies the number of seconds to wait before killing the filters and backend associated with a canceled or held job.  The default is \"30\".\n\n       JobRetryInterval seconds\n            Specifies the interval between retries of jobs in seconds.  This is typically used for fax queues but can also be used with normal print queues whose error policy is  \"retry-job\"\n            or \"retry-current-job\".  The default is \"30\".\n\n       JobRetryLimit count\n            Specifies  the number of retries that are done for jobs.  This is typically used for fax queues but can also be used with normal print queues whose error policy is \"retry-job\" or\n            \"retry-current-job\".  The default is \"5\".\n\n       KeepAlive Yes\n\n       KeepAlive No\n            Specifies whether to support HTTP keep-alive connections.  The default is \"Yes\".\n\n         ...  \n            Specifies the IPP operations that are being limited inside a Policy section. IPP operation names are listed below in the section \"IPP OPERATION NAMES\".\n\n         ...  \n\n         ...  \n            Specifies the HTTP methods that are being limited inside a Location section. HTTP method names are listed below in the section \"HTTP METHOD NAMES\".\n\n       LimitRequestBody size\n            Specifies the maximum size of print files, IPP requests, and HTML form data.  The default is \"0\" which disables the limit check.\n\n       Listen ipv4-address:port\n\n       Listen [ipv6-address]:port\n\n       Listen *:port\n\n       Listen /path/to/domain/socket\n            Listens to the specified address and port or domain socket path for connections.  Multiple Listen directives can be provided to listen on multiple addresses.  The  Listen  direc‐\n            tive  is  similar  to the Port directive but allows you to restrict access to specific interfaces or networks.  Note: \"Listen *:port\" and \"Port port\" effectively listen on all IP\n            addresses, so you cannot combine them with Listen directives for explicit IPv4 or IPv6 addresses on the same port.\n\n         ...  \n            Specifies access control for the named location.  Paths are documented below in the section \"LOCATION PATHS\".\n\n       LogDebugHistory number\n            Specifies the number of debugging messages that are retained for logging if an error occurs in a print job. Debug messages are logged regardless of the LogLevel setting.\n\n       LogLevel none\n\n       LogLevel emerg\n\n       LogLevel alert\n\n       LogLevel crit\n\n       LogLevel error\n\n       LogLevel warn\n\n       LogLevel notice\n\n       LogLevel info\n\n       LogLevel debug\n\n       LogLevel debug2\n            Specifies the level of logging for the ErrorLog file.  The value \"none\" stops all logging while \"debug2\" logs everything.  The default is \"warn\".\n\n       LogTimeFormat standard\n\n       LogTimeFormat usecs\n            Specifies the format of the date and time in the log files.  The value \"standard\" is the default and logs whole seconds while \"usecs\" logs microseconds.\n\n       MaxClients number\n            Specifies the maximum number of simultaneous clients that are allowed by the scheduler.  The default is \"100\".\n\n       MaxClientsPerHost number\n            Specifies the maximum number of simultaneous clients that are allowed from a single address.  The default is the MaxClients value.\n\n       MaxCopies number\n            Specifies the maximum number of copies that a user can print of each job.  The default is \"9999\".\n\n       MaxHoldTime seconds\n            Specifies the maximum time a job may remain in the \"indefinite\" hold state before it is canceled.  The default is \"0\" which disables cancellation of held jobs.\n\n       MaxJobs number\n            Specifies the maximum number of simultaneous jobs that are allowed.  Set to \"0\" to allow an unlimited number of jobs.  The default is \"500\".\n\n       MaxJobsPerPrinter number\n            Specifies the maximum number of simultaneous jobs that are allowed per printer.  The default is \"0\" which allows up to MaxJobs jobs per printer.\n\n       MaxJobsPerUser number\n            Specifies the maximum number of simultaneous jobs that are allowed per user.  The default is \"0\" which allows up to MaxJobs jobs per user.\n\n       MaxJobTime seconds\n            Specifies the maximum time a job may take to print before it is canceled.  Set to \"0\" to disable cancellation of \"stuck\" jobs.  The default is \"10800\" (3 hours).\n\n       MaxLogSize size\n            Specifies the maximum size of the log files before they are rotated.  The value \"0\" disables log rotation.  The default is \"1048576\" (1MB).\n\n       MaxSubscriptions number\n            Specifies the maximum number of simultaneous event subscriptions that are allowed.  Set to \"0\" to allow an unlimited number of subscriptions.  The default is \"100\".\n\n       MaxSubscriptionsPerJob number\n            Specifies the maximum number of simultaneous event subscriptions that are allowed per job.  The default is \"0\" which allows up to MaxSubscriptions subscriptions per job.\n\n       MaxSubscriptionsPerPrinter number\n            Specifies the maximum number of simultaneous event subscriptions that are allowed per printer.  The default is \"0\" which allows up to MaxSubscriptions subscriptions per printer.\n\n       MaxSubscriptionsPerUser number\n            Specifies the maximum number of simultaneous event subscriptions that are allowed per user.  The default is \"0\" which allows up to MaxSubscriptions subscriptions per user.\n\n       MultipleOperationTimeout seconds\n            Specifies the maximum amount of time to allow between files in a multiple file print job.  The default is \"900\" (15 minutes).\n\n         ...  \n            Specifies access control for the named policy.\n\n       Port number\n            Listens to the specified port number for connections.\n\n       PreserveJobFiles Yes\n\n       PreserveJobFiles No\n\n       PreserveJobFiles seconds\n            Specifies whether job files (documents) are preserved after a job is printed.  If a numeric value is specified, job files are preserved for the indicated number of seconds  after\n            printing.  The default is \"86400\" (preserve 1 day).\n\n       PreserveJobHistory Yes\n\n       PreserveJobHistory No\n\n       PreserveJobHistory seconds\n            Specifies  whether  the  job history is preserved after a job is printed.  If a numeric value is specified, the job history is preserved for the indicated number of seconds after\n            printing.  If \"Yes\", the job history is preserved until the MaxJobs limit is reached.  The default is \"Yes\".\n\n       ReadyPaperSizes sizename[,...]\n            Specifies a list of potential paper sizes that are reported as \"ready\" (loaded).  The actual list will only contain sizes that each printer supports.  The default is  \"Letter,Le‐\n            gal,Tabloid,4x6,Env10\"  when  the default paper size is \"Letter\" and \"A3,A4,A5,A6,EnvDL\" otherwise.  Note: Paper sizes must use the size names from the PPD file and not PWG self-\n            describing media size names.\n\n       ReloadTimeout seconds\n            Specifies the amount of time to wait for job completion before restarting the scheduler.  The default is \"30\".\n\n       ServerAdmin email-address\n            Specifies the email address of the server administrator.  The default value is \"root@ServerName\".\n\n       ServerAlias hostname [ ... hostname ]\n\n       ServerAlias *\n            The ServerAlias directive is used for HTTP Host header validation when clients connect to the scheduler from external interfaces.  Using the special name \"*\" can expose your sys‐\n            tem to known browser-based DNS rebinding attacks, even when accessing sites through a firewall.  If the auto-discovery of alternate names does not work, we recommend listing each\n            alternate name with a ServerAlias directive instead of using \"*\".\n\n       ServerName hostname\n            Specifies the fully-qualified hostname of the server.  The default is the value reported by the hostname(1) command.\n\n       ServerTokens None\n\n       ServerTokens ProductOnly\n\n       ServerTokens Major\n\n       ServerTokens Minor\n\n       ServerTokens Minimal\n\n       ServerTokens OS\n\n       ServerTokens Full\n            Specifies what information is included in the Server header of HTTP responses.  \"None\" disables the Server header.  \"ProductOnly\" reports  \"CUPS\".   \"Major\"  reports  \"CUPS/major\n            IPP/2\".   \"Minor\"  reports  \"CUPS/major.minor  IPP/2.1\".   \"Minimal\"  reports  \"CUPS/major.minor.patch IPP/2.1\".  \"OS\" reports \"CUPS/major.minor.path (osname osversion) IPP/2.1\".\n            \"Full\" reports \"CUPS/major.minor.path (osname osversion; architecture) IPP/2.1\".  The default is \"Minimal\".\n\n       SSLListen ipv4-address:port\n\n       SSLListen [ipv6-address]:port\n\n       SSLListen *:port\n            Listens on the specified address and port for encrypted connections.\n\n       SSLOptions [AllowDH] [AllowRC4] [AllowSSL3] [DenyCBC] [DenyTLS1.0] [MaxTLS1.0] [MaxTLS1.1] [MaxTLS1.2] [MaxTLS1.3] [MinTLS1.0] [MinTLS1.1] [MinTLS1.2] [MinTLS1.3]\n\n       SSLOptions None\n            Sets encryption options (only in /etc/cups/client.conf).  By default, CUPS only supports encryption using TLS v1.0 or higher using known secure cipher suites.   Security  is  re‐\n            duced  when  Allow  options  are used.  Security is enhanced when Deny options are used.  The AllowDH option enables cipher suites using plain Diffie-Hellman key negotiation (not\n            supported on systems using GNU TLS).  The AllowRC4 option enables the 128-bit RC4 cipher suites, which are required for some older clients.   The  AllowSSL3  option  enables  SSL\n            v3.0,  which is required for some older clients that do not support TLS v1.0.  The DenyCBC option disables all CBC cipher suites.  The DenyTLS1.0 option disables TLS v1.0 support\n            - this sets the minimum protocol version to TLS v1.1.  The MinTLS options set the minimum TLS version to support.  The MaxTLS options set the maximum TLS version to support.  Not\n            all operating systems support TLS 1.3 at this time.\n\n       SSLPort port\n            Listens on the specified port for encrypted connections.\n\n       StrictConformance Yes\n\n       StrictConformance No\n            Specifies whether the scheduler requires clients to strictly adhere to the IPP specifications.  The default is \"No\".\n\n       Timeout seconds\n            Specifies the HTTP request timeout.  The default is \"900\" (15 minutes).\n\n       WebInterface yes\n\n       WebInterface no\n            Specifies whether the web interface is enabled.  The default is \"No\".\n\n   HTTP METHOD NAMES\n       The following HTTP methods are supported by cupsd(8):\n\n       GET  Used by a client to download icons and other printer resources and to access the CUPS web interface.\n\n       HEAD Used by a client to get the type, size, and modification date of resources.\n\n       OPTIONS\n            Used by a client to establish a secure (SSL/TLS) connection.\n\n       POST Used by a client to submit IPP requests and HTML forms from the CUPS web interface.\n\n       PUT  Used by a client to upload configuration files.\n\n   IPP OPERATION NAMES\n       The following IPP operations are supported by cupsd(8):\n\n       CUPS-Accept-Jobs\n            Allows a printer to accept new jobs.\n\n       CUPS-Add-Modify-Class\n            Adds or modifies a printer class.\n\n       CUPS-Add-Modify-Printer\n            Adds or modifies a printer.\n\n       CUPS-Authenticate-Job\n            Releases a job that is held for authentication.\n\n       CUPS-Delete-Class\n            Deletes a printer class.\n\n       CUPS-Delete-Printer\n            Deletes a printer.\n\n       CUPS-Get-Classes\n            Gets a list of printer classes.\n\n       CUPS-Get-Default\n            Gets the server default printer or printer class.\n\n       CUPS-Get-Devices\n            Gets a list of devices that are currently available.\n\n       CUPS-Get-Document\n            Gets a document file for a job.\n\n       CUPS-Get-PPD\n            Gets a PPD file.\n\n       CUPS-Get-PPDs\n            Gets a list of installed PPD files.\n\n       CUPS-Get-Printers\n            Gets a list of printers.\n\n       CUPS-Move-Job\n            Moves a job.\n\n       CUPS-Reject-Jobs\n            Prevents a printer from accepting new jobs.\n\n       CUPS-Set-Default\n            Sets the server default printer or printer class.\n\n       Cancel-Job\n            Cancels a job.\n\n       Cancel-Jobs\n            Cancels one or more jobs.\n\n       Cancel-My-Jobs\n            Cancels one or more jobs creates by a user.\n\n       Cancel-Subscription\n            Cancels a subscription.\n\n       Close-Job\n            Closes a job that is waiting for more documents.\n\n       Create-Job\n            Creates a new job with no documents.\n\n       Create-Job-Subscriptions\n            Creates a subscription for job events.\n\n       Create-Printer-Subscriptions\n            Creates a subscription for printer events.\n\n       Get-Job-Attributes\n            Gets information about a job.\n\n       Get-Jobs\n            Gets a list of jobs.\n\n       Get-Notifications\n            Gets a list of event notifications for a subscription.\n\n       Get-Printer-Attributes\n            Gets information about a printer or printer class.\n\n       Get-Subscription-Attributes\n            Gets information about a subscription.\n\n       Get-Subscriptions\n            Gets a list of subscriptions.\n\n       Hold-Job\n            Holds a job from printing.\n\n       Hold-New-Jobs\n            Holds all new jobs from printing.\n\n       Pause-Printer\n            Stops processing of jobs by a printer or printer class.\n\n       Pause-Printer-After-Current-Job\n            Stops processing of jobs by a printer or printer class after the current job is finished.\n\n       Print-Job\n            Creates a new job with a single document.\n\n       Purge-Jobs\n            Cancels one or more jobs and deletes the job history.\n\n       Release-Held-New-Jobs\n            Allows previously held jobs to print.\n\n       Release-Job\n            Allows a job to print.\n\n       Renew-Subscription\n            Renews a subscription.\n\n       Restart-Job\n            Reprints a job, if possible.\n\n       Send-Document\n            Adds a document to a job.\n\n       Set-Job-Attributes\n            Changes job information.\n\n       Set-Printer-Attributes\n            Changes printer or printer class information.\n\n       Validate-Job\n            Validates options for a new job.\n\n   LOCATION PATHS\n       The following paths are commonly used when configuring cupsd(8):\n\n       /    The path for all get operations (get-printers, get-jobs, etc.)\n\n       /admin\n            The path for all administration operations (add-printer, delete-printer, start-printer, etc.)\n\n       /admin/conf\n            The path for access to the CUPS configuration files (cupsd.conf, client.conf, etc.)\n\n       /admin/log\n            The path for access to the CUPS log files (access_log, error_log, page_log)\n\n       /classes\n            The path for all printer classes\n\n       /classes/name\n            The resource for the named printer class\n\n       /jobs\n            The path for all jobs (hold-job, release-job, etc.)\n\n       /jobs/id\n            The path for the specified job\n\n       /printers\n            The path for all printers\n\n       /printers/name\n            The path for the named printer\n\n       /printers/name.png\n            The icon file path for the named printer\n\n       /printers/name.ppd\n            The PPD file path for the named printer\n\n   DIRECTIVES VALID WITHIN LOCATION AND LIMIT SECTIONS\n       The following directives may be placed inside Location and Limit sections in the cupsd.conf file:\n\n       Allow all\n\n       Allow none\n\n       Allow host.domain.com\n\n       Allow *.domain.com\n\n       Allow ipv4-address\n\n       Allow ipv4-address/netmask\n\n       Allow ipv4-address/mm\n\n       Allow [ipv6-address]\n\n       Allow [ipv6-address]/mm\n\n       Allow @IF(name)\n\n       Allow @LOCAL\n            Allows access from the named hosts, domains, addresses, or interfaces.  The @IF(name) form uses the current subnets configured for the named interface.  The @LOCAL form uses  the\n            current  subnets  configured for all interfaces that are not point-to-point, for example Ethernet and Wi-Fi interfaces are used but DSL and VPN interfaces are not.  The Order di‐\n            rective controls whether Allow lines are evaluated before or after Deny lines.\n\n       AuthType None\n\n       AuthType Basic\n\n       AuthType Default\n            Specifies the type of authentication required.  The value \"Default\" corresponds to the DefaultAuthType value.\n\n       Deny all\n\n       Deny none\n\n       Deny host.domain.com\n\n       Deny *.domain.com\n\n       Deny ipv4-address\n\n       Deny ipv4-address/netmask\n\n       Deny ipv4-address/mm\n\n       Deny [ipv6-address]\n\n       Deny [ipv6-address]/mm\n\n       Deny @IF(name)\n\n       Deny @LOCAL\n            Denies access from the named hosts, domains, addresses, or interfaces.  The @IF(name) form uses the current subnets configured for the named interface.  The @LOCAL form uses  the\n            current  subnets  configured for all interfaces that are not point-to-point, for example Ethernet and Wi-Fi interfaces are used but DSL and VPN interfaces are not.  The Order di‐\n            rective controls whether Deny lines are evaluated before or after Allow lines.\n\n       Encryption IfRequested\n\n       Encryption Never\n\n       Encryption Required\n            Specifies the level of encryption that is required for a particular location.  The default value is \"IfRequested\".\n\n       Order allow,deny\n            Specifies that access is denied by default. Allow lines are then processed followed by Deny lines to determine whether a client may access a particular resource.\n\n       Order deny,allow\n            Specifies that access is allowed by default. Deny lines are then processed followed by Allow lines to determine whether a client may access a particular resource.\n\n       Require group group-name [ group-name ... ]\n            Specifies that an authenticated user must be a member of one of the named groups.\n\n       Require user {user-name|@group-name} ...\n            Specifies that an authenticated user must match one of the named users or be a member of one of the named groups.  The group name \"@SYSTEM\" corresponds to the list of groups  de‐\n            fined  by  the  SystemGroup  directive  in the cups-files.conf(5) file.  The group name \"@OWNER\" corresponds to the owner of the resource, for example the person that submitted a\n            print job.  Note: The 'root' user is not special and must be granted privileges like any other user account.\n\n       Require valid-user\n            Specifies that any authenticated user is acceptable.\n\n       Satisfy all\n            Specifies that all Allow, AuthType, Deny, Order, and Require conditions must be satisfied to allow access.\n\n       Satisfy any\n            Specifies that any a client may access a resource if either the authentication (AuthType/Require) or address (Allow/Deny/Order) conditions are satisfied.  For example,  this  can\n            be used to require authentication only for remote accesses.\n\n   DIRECTIVES VALID WITHIN POLICY SECTIONS\n       The following directives may be placed inside Policy sections in the cupsd.conf file:\n\n       JobPrivateAccess all\n\n       JobPrivateAccess default\n\n       JobPrivateAccess {user|@group|@ACL|@OWNER|@SYSTEM} ...\n            Specifies  an  access  list  for a job's private values.  The \"default\" access list is \"@OWNER @SYSTEM\".  \"@ACL\" maps to the printer's requesting-user-name-allowed or requesting-\n            user-name-denied values.  \"@OWNER\" maps to the job's owner.  \"@SYSTEM\" maps to the groups listed for the SystemGroup directive in the cups-files.conf(5) file.\n\n       JobPrivateValues all\n\n       JobPrivateValues default\n\n       JobPrivateValues none\n\n       JobPrivateValues attribute-name [ ... attribute-name ]\n            Specifies the list of job values to make private.  The \"default\" values are \"job-name\", \"job-originating-host-name\", \"job-originating-user-name\", and \"phone\".\n\n       SubscriptionPrivateAccess all\n\n       SubscriptionPrivateAccess default\n\n       SubscriptionPrivateAccess {user|@group|@ACL|@OWNER|@SYSTEM} ...\n            Specifies an access list for a subscription's private values.  The \"default\" access list is \"@OWNER @SYSTEM\".  \"@ACL\" maps to the printer's  requesting-user-name-allowed  or  re‐\n            questing-user-name-denied values.  \"@OWNER\" maps to the job's owner.  \"@SYSTEM\" maps to the groups listed for the SystemGroup directive in the cups-files.conf(5) file.\n\n       SubscriptionPrivateValues all\n\n       SubscriptionPrivateValues default\n\n       SubscriptionPrivateValues none\n\n       SubscriptionPrivateValues attribute-name [ ... attribute-name ]\n            Specifies the list of subscription values to make private.  The \"default\" values are \"notify-events\", \"notify-pull-method\", \"notify-recipient-uri\", \"notify-subscriber-user-name\",\n            and \"notify-user-data\".\n\n   DEPRECATED DIRECTIVES\n       The following directives are deprecated and will be removed in a future release of CUPS:\n\n       AuthType Negotiate\n            Specifies Kerberos authentication is required.\n\n       Classification banner\n            Specifies the security classification of the server.  Any valid banner name can be used, including \"classified\", \"confidential\", \"secret\", \"topsecret\", and \"unclassified\", or the\n            banner can be omitted to disable secure printing functions.  The default is no classification banner.\n\n       ClassifyOverride Yes\n\n       ClassifyOverride No\n            Specifies whether users may override the classification (cover page) of individual print jobs using the \"job-sheets\" option.  The default is \"No\".\n\n       DefaultAuthType Negotiate\n            Specifies that Kerberos authentication is required by default.\n\n       GSSServiceName name\n            Specifies the service name when using Kerberos authentication.  The default service name is \"http.\"\n\n       PageLogFormat format-string\n            Specifies  the  format  of  PageLog lines.  Sequences beginning with percent (%) characters are replaced with the corresponding information, while all other characters are copied\n            literally.  The following percent sequences are recognized:\n\n                \"%%\" inserts a single percent character.\n                \"%{name}\" inserts the value of the specified IPP attribute.\n                \"%C\" inserts the number of copies for the current page.\n                \"%P\" inserts the current page number.\n                \"%T\" inserts the current date and time in common log format.\n                \"%j\" inserts the job ID.\n                \"%p\" inserts the printer name.\n                \"%u\" inserts the username.\n\n            The default is the empty string, which disables page logging.  The string \"%p %u %j %T %P %C %{job-billing} %{job-originating-host-name} %{job-name} %{media} %{sides}\" creates  a\n            page  log  with  the standard items.  Use \"%{job-impressions-completed}\" to insert the number of pages (sides) that were printed, or \"%{job-media-sheets-completed}\" to insert the\n            number of sheets that were printed.\n\nNOTES\n       File, directory, and user configuration directives that used to be allowed in the cupsd.conf file are now stored in the cups-files.conf(5) file instead in  order  to  prevent  certain\n       types of privilege escalation attacks.\n\n       The  scheduler MUST be restarted manually after making changes to the cupsd.conf file.  On Linux this is typically done using the systemctl(8) command, while on macOS the launchctl(8)\n       command is used instead.\n\n       The @LOCAL macro name can be confusing since the system running cupsd often belongs to a different set of subnets from its clients.\n\nCONFORMING TO\n       The cupsd.conf file format is based on the Apache HTTP Server configuration file format.\n\nEXAMPLES\n       Log everything with a maximum log file size of 32 megabytes:\n\n           AccessLogLevel all\n           LogLevel debug2\n           MaxLogSize 32m\n\n       Require authentication for accesses from outside the 10. network:\n\n            \n           Order allow,deny\n           Allow from 10./8\n           AuthType Basic\n           Require valid-user\n           Satisfy any\n            \n\nSEE ALSO\n       classes.conf(5), cups-files.conf(5), cupsd(8), mime.convs(5), mime.types(5), printers.conf(5), subscriptions.conf(5), CUPS Online Help (http://localhost:631/help)\n\nCOPYRIGHT\n       Copyright © 2020-2024 by OpenPrinting.\n\n2021-10-01                                                                                   CUPS                                                                                cupsd.conf(5)","ref":"cupsd-conf.html"},{"type":"extras","title":"cupsd-logs","doc":"cupsd-logs(5)                                                                            OpenPrinting                                                                            cupsd-logs(5)\n\nNAME\n       cupsd-logs - cupsd log files (access_log, error_log, and page_log)\n\nDESCRIPTION\n       cupsd(8) normally maintains three log files: access_log to track requests that are submitted to the scheduler, error_log to track progress and errors, and page_log to track pages that\n       are printed.  Configuration directives in cupsd.conf(5) and cups-files.conf(5) control what information is logged and where it is stored.\n\n   ACCESS LOG FILE FORMAT\n       The  access_log  file  lists each HTTP resource that is accessed by a web browser or client.  Each line is in an extended version of the so-called \"Common Log Format\" used by many web\n       servers and web reporting tools:\n\n           host group user date-time \"method resource version\" status bytes\n             ipp-operation ipp-status\n\n       For example:\n\n           10.0.1.2 - - [01/Dec/2005:21:50:28 +0000] \"POST / HTTP/1.1\" 200 317\n             CUPS-Get-Printers successful-ok-ignored-or-substituted-attributes\n           localhost - - [01/Dec/2005:21:50:32 +0000] \"GET /admin HTTP/1.1\"\n             200 0 - -\n           localhost - - [01/Dec/2005:21:50:32 +0000] \"POST / HTTP/1.1\"\n             200 157 CUPS-Get-Printers\n             successful-ok-ignored-or-substituted-attributes\n           localhost - - [01/Dec/2005:21:50:32 +0000] \"POST / HTTP/1.1\"\n             200 1411 CUPS-Get-Devices -\n           localhost - - [01/Dec/2005:21:50:32 +0000] \"GET /admin HTTP/1.1\"\n             200 6667 - -\n\n       The host field will normally only be an IP address unless you have enabled the HostNameLookups directive in the cupsd.conf file or if the IP address corresponds to your local machine.\n\n       The group field always contains \"-\".\n\n       The user field is the authenticated username of the requesting user.  If no username and password is supplied for the request then this field contains \"-\".\n\n       The date-time field is the date and time of the request in local time and is in the format \"[DD/MON/YYYY:HH:MM:SS +ZZZZ]\".\n\n       The method field is the HTTP method used: \"GET\", \"HEAD\", \"OPTIONS\", \"POST\", or \"PUT\".  \"GET\" requests are used to get files from the server, both for the web interface and to get con‐\n       figuration and log files.  \"HEAD\" requests are used to get information about a resource prior to a \"GET\".  \"OPTIONS\" requests are  used  to  upgrade  connections  to  TLS  encryption.\n       \"POST\" requests are used for web interface forms and IPP requests.  \"PUT\" requests are used to upload configuration files.\n\n       The resource field is the filename of the requested resource.\n\n       The version field is the HTTP specification version used by the client.  For CUPS clients this will always be \"HTTP/1.1\".\n\n       The status field contains the HTTP result status of the request, as follows:\n\n            200  Successful operation.\n\n            201  File created/modified successfully.\n\n            304  The requested file has not changed.\n\n            400  Bad HTTP request; typically this means that you have a malicious program trying to access your server.\n\n            401  Unauthorized, authentication (username + password) is required.\n\n            403  Access is forbidden; typically this means that a client tried to access a file or resource they do not have permission to access.\n\n            404  The file or resource does not exist.\n\n            405  URL access method is not allowed; typically this means you have a web browser using your server as a proxy.\n\n            413  Request too large; typically this means that a client tried to print a file larger than the MaxRequestSize allows.\n\n            426  Upgrading to TLS-encrypted connection.\n\n            500  Server error; typically this happens when the server is unable to open/create a file - consult the error_log file for details.\n\n            501  The client requested encryption but encryption support is not enabled/compiled in.\n\n            505  HTTP version number not supported; typically this means that you have a malicious program trying to access your server.\n\n       The bytes field contains the number of bytes in the request.  For POST requests the bytes field contains the number of bytes of non-IPP data that is received from the client.\n\n       The ipp-operation field contains either \"-\" for non-IPP requests or the IPP operation name for POST requests containing an IPP request.\n\n       The ipp-status field contains either \"-\" for non-IPP requests or the IPP status code name for POST requests containing an IPP response.\n\n   ERROR LOG FILE FORMAT\n       The error_log file lists messages from the scheduler - errors, warnings, etc. The LogLevel directive in the cupsd.conf(5) file controls which messages are logged:\n\n           level date-time message\n\n       For example:\n\n           I [20/May/1999:19:18:28 +0000] [Job 1] Queued on 'DeskJet' by 'mike'.\n           D [20/May/1999:19:18:28 +0000] [Job 1] argv[0]=\"DeskJet\"\n           D [20/May/1999:19:18:28 +0000] [Job 1] argv[1]=\"1\"\n           D [20/May/1999:19:18:28 +0000] [Job 1] argv[2]=\"mike\"\n           D [20/May/1999:19:18:28 +0000] [Job 1] argv[3]=\"myjob\"\n           D [20/May/1999:19:18:28 +0000] [Job 1] argv[4]=\"1\"\n           D [20/May/1999:19:18:28 +0000] [Job 1] argv[5]=\"media=\n             na_letter_8.5x11in sides=one-sided\"\n           D [20/May/1999:19:18:28 +0000] [Job 1] argv[6]=\"/var/spool/cups/\n             d000001-001\"\n           I [20/May/1999:19:21:02 +0000] [Job 2] Queued on 'DeskJet' by 'mike'.\n           I [20/May/1999:19:22:24 +0000] [Job 2] Canceled by 'mike'.\n\n       The level field contains the type of message:\n\n       A    Alert message (LogLevel alert)\n\n       C    Critical error message (LogLevel crit)\n\n       D    Debugging message (LogLevel debug)\n\n       d    Detailed debugging message (LogLevel debug2)\n\n       E    Normal error message (LogLevel error)\n\n       I    Informational message (LogLevel info)\n\n       N    Notice message (LogLevel notice)\n\n       W    Warning message (LogLevel warn)\n\n       X    Emergency error message (LogLevel emerg)\n\n       The date-time field contains the date and time of when the page started printing. The format of this field is identical to the data-time field in the access_log file.\n\n       The message field contains a free-form textual message.  Messages from job filters are prefixed with \"[Job NNN]\" where \"NNN\" is the job ID.\n\n   PAGE LOG FILE FORMAT\n       The page_log file lists the total number of pages (sheets) that are printed.  By default, each line contains the following information:\n\n           printer user job-id date-time total num-sheets job-billing\n             job-originating-host-name job-name media sides\n\n       For example the entry for a two page job called \"myjob\" might look like:\n\n           DeskJet root 1 [20/May/1999:19:21:06 +0000] total 2 acme-123\n             localhost myjob na_letter_8.5x11in one-sided\n\n       The PageLogFormat directive in the cupsd.conf(5) file can be used to change this information.\n\n       The  printer field contains the name of the printer that printed the page.  If you send a job to a printer class, this field will contain the name of the printer that was assigned the\n       job.\n\n       The user field contains the name of the user (the IPP requesting-user-name attribute) that submitted this file for printing.\n\n       The job-id field contains the job number of the page being printed.\n\n       The date-time field contains the date and time of when the page started printing.  The format of this field is identical to the data-time field in the access_log file.\n\n       The num-sheets field provides the total number of pages (sheets) that have been printed on for the job.\n\n       The job-billing field contains a copy of the job-billing or job-account-id attributes provided with the IPP Create-Job or Print-Job requests or \"-\" if neither was provided.\n\n       The job-originating-host-name field contains the hostname or IP address of the client that printed the job.\n\n       The job-name field contains a copy of the job-name attribute provided with the IPP Create-Job or Print-Job requests or \"-\" if none was provided.\n\n       The media field contains a copy of the media or media-col/media-size attribute provided with the IPP Create-Job or Print-Job requests or \"-\" if none was provided.\n\n       The sides field contains a copy of the sides attribute provided with the IPP Create-Job or Print-Job requests or \"-\" if none was provided.\n\nSEE ALSO\n       cupsd(8), cupsd.conf(5), cups-files.conf(5), CUPS Online Help (http://localhost:631/help)\n\nCOPYRIGHT\n       Copyright © 2020-2024 by OpenPrinting.\n\n2021-02-28                                                                                   CUPS                                                                                cupsd-logs(5)","ref":"cupsd-logs.html"},{"type":"extras","title":"cups-files.conf","doc":"cups-files.conf(5)                                                                       OpenPrinting                                                                       cups-files.conf(5)\n\nNAME\n       cups-files.conf - file and directory configuration file for cups\n\nDESCRIPTION\n       The cups-files.conf file configures the files and directories used by the CUPS scheduler, cupsd(8).  It is normally located in the /etc/cups directory.\n\n       Each  line  in the file can be a configuration directive, a blank line, or a comment.  Configuration directives typically consist of a name and zero or more values separated by white‐\n       space.  The configuration directive name and values are case-insensitive.  Comment lines start with the # character.\n\n   DIRECTIVES\n       The following directives are understood by cupsd(8):\n\n       AccessLog\n\n       AccessLog filename\n\n       AccessLog stderr\n\n       AccessLog syslog\n            Defines the access log filename.  Specifying a blank filename disables access log generation.  The value \"stderr\" causes log entries to be sent to the standard  error  file  when\n            the  scheduler  is  running in the foreground, or to the system log daemon when run in the background.  The value \"syslog\" causes log entries to be sent to the system log daemon.\n            The server name may be included in filenames using the string \"%s\", for example:\n\n                AccessLog /var/log/cups/%s-access_log\n\n            The default is \"/var/log/cups/access_log\".\n\n       CacheDir directory\n            Specifies the directory to use for long-lived temporary (cache) files.  The default is \"/var/spool/cups/cache\" or \"/var/cache/cups\" depending on the platform.\n\n       ConfigFilePerm mode\n            Specifies the permissions for all configuration files that the scheduler writes.  The default is \"0644\" on macOS and \"0640\" on all other operating systems.\n\n       Note: The permissions for the printers.conf file are currently masked to only allow access from the scheduler user (typically root).  This is done because printer  device  URIs  some‐\n       times contain sensitive authentication information that should not be generally known on the system.  There is no way to disable this security feature.\n\n       CreateSelfSignedCerts yes\n\n       CreateSelfSignedCerts no\n            Specifies whether the scheduler automatically creates self-signed certificates for client connections using TLS.  The default is yes.\n\n       DataDir path\n            Specifies the directory where data files can be found.  The default is usually \"/usr/share/cups\".\n\n       DocumentRoot directory\n            Specifies the root directory for the CUPS web interface content.  The default is usually \"/usr/share/doc/cups\".\n\n       ErrorLog\n\n       ErrorLog filename\n\n       ErrorLog stderr\n\n       ErrorLog syslog\n            Defines  the error log filename.  Specifying a blank filename disables error log generation.  The value \"stderr\" causes log entries to be sent to the standard error file when the\n            scheduler is running in the foreground, or to the system log daemon when run in the background.  The value \"syslog\" causes log entries to be sent to the system log  daemon.   The\n            server name may be included in filenames using the string \"%s\", for example:\n\n                ErrorLog /var/log/cups/%s-error_log\n\n            The default is \"/var/log/cups/error_log\".\n\n       FatalErrors none\n\n       FatalErrors all -kind [ ... -kind ]\n\n       FatalErrors kind [ ... kind ]\n            Specifies which errors are fatal, causing the scheduler to exit.  The default is \"config\".  The kind strings are:\n\n            none No errors are fatal.\n\n            all  All of the errors below are fatal.\n\n            browse\n                 Browsing initialization errors are fatal, for example failed connections to the DNS-SD daemon.\n\n            config\n                 Configuration file syntax errors are fatal.\n\n            listen\n                 Listen or Port errors are fatal, except for IPv6 failures on the loopback or \"any\" addresses.\n\n            log  Log file creation or write errors are fatal.\n\n            permissions\n                 Bad startup file permissions are fatal, for example shared TLS certificate and key files with world-read permissions.\n\n       Group group-name-or-number\n            Specifies the group name or ID that will be used when executing external programs.  The default group is operating system specific but is usually \"lp\" or \"nobody\".\n\n       LogFileGroup group-name-or-number\n            Specifies the group name or ID that will be used for log files.  The default group is operating system specific but is usually \"lp\" or \"nobody\".\n\n       LogFilePerm mode\n            Specifies the permissions of all log files that the scheduler writes.  The default is \"0644\".\n\n       PageLog [ filename ]\n\n       PageLog stderr\n\n       PageLog syslog\n            Defines  the page log filename.  The value \"stderr\" causes log entries to be sent to the standard error file when the scheduler is running in the foreground, or to the system log\n            daemon when run in the background.  The value \"syslog\" causes log entries to be sent to the system log daemon.  Specifying a blank filename disables  page  log  generation.   The\n            server name may be included in filenames using the string \"%s\", for example:\n\n                PageLog /var/log/cups/%s-page_log\n\n            The default is \"/var/log/cups/page_log\".\n\n       PassEnv variable [ ... variable ]\n            Passes the specified environment variable(s) to child processes.  Note: the standard CUPS filter and backend environment variables cannot be overridden using this directive.\n\n       RemoteRoot username\n            Specifies the username that is associated with unauthenticated accesses by clients claiming to be the root user.  The default is \"remroot\".\n\n       RequestRoot directory\n            Specifies the directory that contains print jobs and other HTTP request data.  The default is \"/var/spool/cups\".\n\n       Sandboxing relaxed\n\n       Sandboxing strict\n            Specifies  the  level  of security sandboxing that is applied to print filters, backends, and other child processes of the scheduler.  The default is \"strict\".  This directive is\n            currently only used/supported on macOS.\n\n       ServerBin directory\n            Specifies the directory containing the backends, CGI programs, filters, helper programs, notifiers, and port monitors.  The default is \"/usr/lib/cups\" or \"/usr/libexec/cups\"  de‐\n            pending on the platform.\n\n       ServerKeychain path\n            Specifies  the  location  of  TLS certificates and private keys.  The default is \"/Library/Keychains/System.keychain\" on macOS and \"/etc/cups/ssl\" on all other operating systems.\n            macOS uses its keychain database to store certificates and keys while other platforms use separate files in the specified directory, *.crt for PEM-encoded certificates and  *.key\n            for PEM-encoded private keys.\n\n       ServerRoot directory\n            Specifies the directory containing the server configuration files.  The default is \"/etc/cups\".\n\n       SetEnv variable value\n            Set  the  specified environment variable to be passed to child processes.  Note: the standard CUPS filter and backend environment variables cannot be overridden using this direc‐\n            tive.\n\n       StateDir directory\n            Specifies the directory to use for PID and local certificate files.  The default is \"/var/run/cups\" or \"/etc/cups\" depending on the platform.\n\n       SyncOnClose Yes\n\n       SyncOnClose No\n            Specifies whether the scheduler calls fsync(2) after writing configuration or state files.\n\n       SystemGroup group-name [ ... group-name ]\n            Specifies the group(s) to use for @SYSTEM group authentication.  The default contains \"admin\", \"lpadmin\", \"root\", \"sys\", and/or \"system\".\n\n       TempDir directory\n            Specifies the directory where short-term temporary files are stored.  The default is \"/var/spool/cups/tmp\".\n\n       User username\n            Specifies the user name or ID that is used when running external programs.  The default is \"lp\".\n\n   DEPRECATED DIRECTIVES\n       The following directives are deprecated and will be removed from a future version of CUPS:\n\n       FileDevice Yes\n\n       FileDevice No\n            Specifies whether the file pseudo-device can be used for new printer queues.  The URI \"file:///dev/null\" is always allowed.  File devices cannot be used with \"raw\" print queues -\n            a PPD file is required.  The specified file is overwritten for every print job.  Writing to directories is not supported.\n\n       Printcap filename\n            Specifies a file that is filled with a list of local print queues.\n\n       PrintcapFormat bsd\n\n       PrintcapFormat plist\n\n       PrintcapFormat solaris\n            Specifies the format to use for the Printcap file.  \"bsd\" is the historical LPD printcap file format.  \"plist\" is the Apple plist file format.  \"solaris\" is  the  historical  So‐\n            laris LPD printcap file format.\n\nNOTES\n       The  scheduler  MUST  be  restarted  manually  after  making  changes  to the cups-files.conf file.  On Linux this is typically done using the systemctl(8) command, while on macOS the\n       launchctl(8) command is used instead.\n\nSEE ALSO\n       classes.conf(5), cups(1), cupsd(8), cupsd.conf(5), mime.convs(5), mime.types(5), printers.conf(5), subscriptions.conf(5), CUPS Online Help (http://localhost:631/help)\n\nCOPYRIGHT\n       Copyright © 2020-2024 by OpenPrinting.\n\n2021-03-06                                                                                   CUPS                                                                           cups-files.conf(5)","ref":"cups-files-conf.html"},{"type":"extras","title":"cups-snmp.conf","doc":"snmp.conf(5)                                                                             OpenPrinting                                                                             snmp.conf(5)\n\nNAME\n       snmp.conf - snmp configuration file for cups (deprecated)\n\nDESCRIPTION\n       The snmp.conf file configures how the standard CUPS network backends (http, https, ipp, ipps, lpd, snmp, and socket) access printer information using SNMPv1 and is normally located in\n       the /etc/cups directory.  Each line in the file can be a configuration directive, a blank line, or a comment. Comment lines start with the # character.\n\n       The Community and DebugLevel directives are used by all backends. The remainder apply only to the SNMP backend - cups-snmp(8).\n\nDIRECTIVES\n       The following directives are understood by the CUPS network backends:\n\n       Address @IF(name)\n\n       Address @LOCAL\n\n       Address address\n            Sends SNMP broadcast queries (for discovery) to the specified address(es).  There is no default for the broadcast address.\n\n       Community name\n            Specifies  the  community  name  to use.  Only a single community name may be specified.  The default community name is \"public\".  If no name is specified, all SNMP functions are\n            disabled.\n\n       DebugLevel number\n            Specifies the logging level from 0 (none) to 3 (everything).  Typically only used for debugging (thus the name).  The default debug level is 0.\n\n       DeviceURI \"regular expression\" device-uri [... device-uri]\n            Specifies one or more device URIs that should be used for a given make and model string.  The regular expression is used to match the detected make and model, and the device  URI\n            strings must be of the form \"scheme://%s[:port]/[path]\", where \"%s\" represents the detected address or hostname.  There are no default device URI matching rules.\n\n       HostNameLookups on\n\n       HostNameLookups off\n            Specifies whether the addresses of printers should be converted to hostnames or left as numeric IP addresses.  The default is \"off\".\n\n       MaxRunTime seconds\n            Specifies the maximum number of seconds that the SNMP backend will scan the network for printers.  The default is 120 seconds (2 minutes).\n\nNOTES\n       CUPS  backends  are  deprecated  and  will  no  longer  be supported in a future feature release of CUPS.  Printers that do not support IPP can be supported using applications such as\n       ippeveprinter(1).\n\nSEE ALSO\n       cups-snmp(8), CUPS Online Help (http://localhost:631/help)\n\nCOPYRIGHT\n       Copyright © 2020-2024 by OpenPrinting.\n\n2021-02-28                                                                                   CUPS                                                                                 snmp.conf(5)","ref":"cups-snmp-conf.html"},{"type":"extras","title":"deb822","doc":"deb822(5)                                                                                 dpkg suite                                                                                 deb822(5)\n\nNAME\n       deb822 - Debian RFC822 control data format\n\nDESCRIPTION\n       The package management system manipulates data represented in a common format, known as control data, stored in control files.  Control files are used for source packages, binary\n       packages and the .changes files which control the installation of uploaded files (dpkg's internal databases are in a similar format).\n\nSYNTAX\n       A control file consists of one or more stanzas of fields (the stanzas sometimes used to be referred to as paragraphs).  The stanzas are separated by empty lines.  Parsers may accept\n       lines consisting solely of U+0020 SPACE and U+0009 TAB as stanza separators, but control files should use empty lines.  Some control files allow only one stanza; others allow several,\n       in which case each stanza usually refers to a different package.  (For example, in source packages, the first stanza refers to the source package, and later stanzas refer to binary\n       packages generated from the source.)  The ordering of the stanzas in control files is significant.\n\n       Each stanza consists of a series of data fields.  Each field consists of the field name followed by a colon (U+003A ‘:’), and then the data/value associated with that field.  The\n       field name is composed of US-ASCII characters excluding control characters, space, and colon (i.e., characters in the ranges U+0021 ‘!’ through U+0039 ‘9’, and U+003B ‘;’ through\n       U+007E ‘~’, inclusive).  Field names must not begin with the comment character (U+0023 ‘#’), nor with the hyphen character (U+002D ‘-’).\n\n       The field ends at the end of the line or at the end of the last continuation line (see below).  Horizontal whitespace (U+0020 SPACE and U+0009 TAB) may occur immediately before or\n       after the value and is ignored there; it is conventional to put a single space after the colon.  For example, a field might be:\n\n        Package: dpkg\n\n       the field name is Package and the field value dpkg.\n\n       Empty field values are only permitted in source package control files (debian/control).  Such fields are ignored.\n\n       A stanza must not contain more than one instance of a particular field name.\n\n       There are three types of fields:\n\n           simple\n               The  field, including its value, must be a single line.  Folding of the field is not permitted.  This is the default field type if the definition of the field does not specify\n               a different type.\n\n           folded\n               The value of a folded field is a logical line that may span several lines.  The lines after the first are called continuation lines and must start with a  U+0020  SPACE  or  a\n               U+0009 TAB.  Whitespace, including any newlines, is not significant in the field values of folded fields.\n\n               This folding method is similar to RFC5322, allowing control files that contain only one stanza and no multiline fields to be read by parsers written for RFC5322.\n\n           multiline\n               The  value  of  a  multiline  field  may  comprise  multiple  continuation  lines.  The first line of the value, the part on the same line as the field name, often has special\n               significance or may have to be empty.  Other lines are added following the same syntax as the continuation lines of the folded  fields.   Whitespace,  including  newlines,  is\n               significant in the values of multiline fields.\n\n           Whitespace  must  not  appear  inside  names  (of  packages,  architectures,  files  or  anything  else)  or  version numbers, or between the characters of multi-character version\n           relationships.\n\n           The presence and purpose of a field, and the syntax of its value may differ between types of control files.\n\n           Field names are not case-sensitive, but it is usual to capitalize the field names using mixed case as shown below.  Field values are case-sensitive unless the description  of  the\n           field says otherwise.\n\n           Stanza  separators  (empty lines) and lines consisting only of U+0020 SPACE and U+0009 TAB, are not allowed within field values or between fields.  Empty lines in field values are\n           usually escaped by representing them by a U+0020 SPACE followed by a dot (U+002E ‘.’).\n\n           Lines starting with U+0023 ‘#’, without any preceding whitespace are comments lines that are only permitted in source package control files (debian/control) and  in  deb-origin(5)\n           files.  These comment lines are ignored, even between two continuation lines.  They do not end logical lines.\n\n           All control files must be encoded in UTF-8.\n\nSEE ALSO\n       RFC822, RFC5322.\n\n1.22.21                                                                                   2025-06-30                                                                                 deb822(5)","ref":"deb822.html"},{"type":"extras","title":"deb-buildinfo","doc":"deb-buildinfo(5)                                                                          dpkg suite                                                                          deb-buildinfo(5)\n\nNAME\n       deb-buildinfo - Debian build information file format\n\nSYNOPSIS\n       filename.buildinfo\n\nDESCRIPTION\n       Each Debian source package build can record the build information in a .buildinfo control file, which contains a number of fields in deb822(5) format.\n\n       Each field begins with a tag, such as Source or Binary (case insensitive), followed by a colon, and the body of the field (case sensitive unless stated otherwise).  Fields are\n       delimited only by field tags.  In other words, field text may be multiple lines in length, but the installation tools will generally join lines when processing the body of the field\n       (except in case of the multiline fields Binary-Only-Changes, Installed-Build-Depends, Environment, Checksums-Md5, Checksums-Sha1 and Checksums-Sha256, see below).\n\n       The control data might be enclosed in an OpenPGP ASCII Armored signature, as specified in RFC9580.\n\n       The name of the .buildinfo file will depend on the type of build and will be as specific as necessary but not more; the name will be:\n\n       source-name_binary-version_arch.buildinfo\n           for a build that includes any\n\n       source-name_binary-version_all.buildinfo\n           otherwise for a build that includes all\n\n       source-name_source-version_source.buildinfo\n           otherwise for a build that includes source\n\nFIELDS\n       Format: format-version (required)\n           The  value  of  this  field  declares  the  format version of the file.  The syntax of the field value is a version number with a major and minor component.  Backward incompatible\n           changes to the format will bump the major version, and backward compatible changes (such as field additions) will bump the minor version.  The current format version is 1.0.\n\n       Source: source-name [(source-version)] (required)\n           The name of the source package.  If the source version differs from the binary version, then the source-name will be followed by a source-version in parenthesis.  This can  happen\n           when the build is for a binary-only non-maintainer upload.\n\n       Binary: binary-package-list (required in context)\n           This folded field is a space-separated list of binary packages built.  If the build is source-only, then the field is omitted (since dpkg 1.20.0).\n\n       Architecture: arch-list (required)\n           This  space-separated  field  lists  the architectures of the files currently being built.  Common architectures are amd64, armel, i386, etc.  Note that the all value is meant for\n           packages that are architecture independent.  If the source for the package is also being built, the special entry source is also present.  Architecture  wildcards  must  never  be\n           present in the list.\n\n       Version: version-string (required)\n           Typically,  this is the original package's version number in whatever form the program's author uses.  It may also include a Debian revision number (for non-native packages).  The\n           exact format and sorting algorithm are described in deb-version(7).\n\n       Binary-Only-Changes:\n        changelog-entry\n           This multiline field contains the concatenated text of the changelog entry for a binary-only non-maintainer upload (binNMU) if that is the case.  To make this  a  valid  multiline\n           field empty lines are replaced with a single full stop (‘.’) and all lines are indented by one space character.  The exact content depends on the changelog format.\n\n       Checksums-Md5: (required, weak)\n       Checksums-Sha1: (required, weak)\n       Checksums-Sha256: (required, strong)\n        checksum size filename\n           These  multiline  fields  contain a list of files with a checksum and size for each one.  These fields have the same syntax and differ only in the checksum algorithm used: MD5 for\n           Checksums-Md5, SHA-1 for Checksums-Sha1 and SHA-256 for Checksums-Sha256.\n\n           Note: The MD5 and SHA-1 checksums are considered weak, and should never be assumed to be sufficient for secure verification.\n\n           The first line of the field value (the part on the same line as the field name followed by a colon) is always empty.  The content of the field is expressed as continuation  lines,\n           one line per file.  Each line consists of space-separated entries describing the file: the checksum, the file size, and the file name.\n\n           These fields list all files that make up the build.\n\n       Build-Origin: name\n           The name of the distribution this package is originating from.\n\n       Build-Architecture: arch (required)\n           The Debian architecture for the installation the packages is being built in.  Common architectures are amd64, armel, i386, etc.\n\n       Build-Date: build-date\n           The date the package was built.  It must be in the same format as the date in a deb-changelog(5) entry.\n\n       Build-Kernel-Version: build-kernel-version\n           The  release  and version (in an unspecified format) of the kernel running on the build system.  This field is only going to be present if the builder has explicitly requested it,\n           to avoid leaking possibly sensitive information.\n\n       Build-Path: build-path\n           The absolute build path, which correspond to the unpacked source tree.  This field is only going to be present if the vendor has allowed it via some pattern match to avoid leaking\n           possibly sensitive information.\n\n           On Debian and derivatives only build paths starting with /build/ will emit this field.\n\n       Build-Tainted-By:\n        taint-reason-list\n           This folded field contains a space-separated list of non-exhaustive reason tags (formed by alphanumeric and dash characters) which identify why the current build has been  tainted\n           (since dpkg 1.19.5).\n\n           On Debian and derivatives the following reason tags can be emitted:\n\n           usr-local-has-configs\n               The system has configuration files under /usr/local/etc.\n\n           usr-local-has-includes\n               The system has header files under /usr/local/include.\n\n           usr-local-has-programs\n               The system has programs under /usr/local/bin or /usr/local/sbin.\n\n           usr-local-has-libraries\n               The system has libraries, either static or shared under /usr/local/lib.\n\n           can-execute-cross-built-programs\n               The system can execute cross built programs, either directly or via some emulation layer.\n\n               Since dpkg 1.21.10.\n\n       Installed-Build-Depends: (required)\n        package-list\n           The list of installed and configured packages that might affect the package build process.\n\n           The list consists of each package name, optionally arch-qualified for foreign architectures, with an exact version restriction, separated by commas.\n\n           The  list  includes  all  essential  packages,  packages  listed  in  Build-Depends,  Build-Depends-Arch,  Build-Depends-Indep  source  control fields, any vendor specific builtin\n           dependencies, and all their recursive dependencies.  On Debian and derivatives the dependency builtin is build-essential.\n\n           For dependencies coming from the source control fields, all dependency alternatives and all providers of virtual packages depended on will be included.\n\n       Environment:\n        variable-list\n           The list of environment variables that are known to affect the package build process, with each environment variable followed by an equal sign  (‘=’)  and  the  variable's  quoted\n           value, using double quotes (‘\"’), and backslashes escaped (‘\\\\’).\n\nSEE ALSO\n       deb822(5), deb-changes(5), deb-version(7), dpkg-genbuildinfo(1).\n\n1.22.21                                                                                   2025-06-30                                                                          deb-buildinfo(5)","ref":"deb-buildinfo.html"},{"type":"extras","title":"deb-changelog","doc":"deb-changelog(5)                                                                          dpkg suite                                                                          deb-changelog(5)\n\nNAME\n       deb-changelog - dpkg source packages' changelog file format\n\nSYNOPSIS\n       debian/changelog\n\nDESCRIPTION\n       Changes in the packaged version of a project are explained in the changelog file debian/changelog.  This includes modifications made in the source package compared to the upstream one\n       as well as other changes and updates to the package.\n\n       The format of the debian/changelog allows the package building tools to discover which version of the package is being built and find out other release-specific information.\n\n       That format is a series of entries like this:\n\n        package (version) distributions; metadata\n                 [optional blank line(s), stripped]\n         * change-details\n           more-change-details\n                 [blank line(s), included in dpkg-parsechangelog(1) output]\n         * even-more-change-details\n                 [optional blank line(s), stripped]\n         -- maintainer-name    date\n\n       package and version are the source package name and version number.  version is delimited by parenthesis U+00028 ‘(’ and U+0029 ‘)’.\n\n       distributions lists one or more space-separated distributions where this version should be installed when it is uploaded; it is copied to the Distribution field in the .changes file.\n       distributions must be terminated by a semicolon (U+003B ‘;’).\n\n       metadata lists zero or more comma-separated keyword=value items.  Each keyword can contain only minus and case insensitive alphanumeric characters, as they need to be mapped to\n       deb822(5) field names.  The only keywords currently supported by dpkg are:\n\n       urgency\n           Its value is used for the Urgency field in the .changes file for the upload.\n\n       binary-only\n           With  a  yes value, it is used to denote that this changelog entry is for a binary-only non-maintainer upload (an automatic binary rebuild with the only change being the changelog\n           entry).\n\n       The change details may in fact be any series of lines starting with at least two spaces (U+0020 SPACE), but conventionally each change starts with an asterisk and a  separating  space\n       and continuation lines are indented so as to bring them in line with the start of the text above.  Blank lines may be used here to separate groups of changes, if desired.\n\n       If  this  upload  resolves  bugs  recorded  in the distribution bug tracking system, they may be automatically closed on the inclusion of this package into the distribution archive by\n       including the string:\n\n           Closes: #nnnnn\n\n       in the change details, where #nnnnn is the bug number.  The exact Perl regular expression is:\n\n           /closes:\\s*(?:bug)?\\#?\\s?\\d+(?:,\\s*(?:bug)?\\#?\\s?\\d+)*/i\n\n       That is, the string should consist of the word closes: followed by a comma-separated list of bug numbers.  Bug numbers may be preceded by the word bug and/or a # sign, as in  \"Closes:\n       42, bug#43, #44, bug 45\".  The words closes: and bug are not case sensitive.  The list of bug numbers may span multiple lines.\n\n       This  information  is  conveyed  via  the  Closes field in the .changes file.  Where, depending on the archive maintenance software, all the bug numbers listed might get automatically\n       closed.\n\n       The maintainer name and email address used in the changelog should be the details of the person who prepared this release of the package.   They  are  not  necessarily  those  of  the\n       uploader  or  usual  package maintainer.  The information here will be copied to the Changed-By field in the .changes file, and then later might be used to send an acknowledgment when\n       the upload has been installed in the distribution archive.\n\n       The date has the following format (compatible and with the same semantics of RFC2822 and RFC5322, or what «date -R» generates):\n\n           day-of-week, dd month yyyy hh:mm:ss +zzzz\n\n       where:\n\n       day-of-week\n           Is one of: Mon, Tue, Wed, Thu, Fri, Sat, Sun.\n\n       dd  Is a one- or two-digit day of the month (01-31), where the leading zero is optional, but conventionally does not get omitted.\n\n       month\n           Is one of: Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec.\n\n       yyyy\n           Is the four-digit year (e.g. 2010).\n\n       hh  Is the two-digit hour (00-23).\n\n       mm  Is the two-digit minutes (00-59).\n\n       ss  Is the two-digit seconds (00-60).\n\n       [+-]zzzz\n           Is the time zone offset from Coordinated Universal Time (UTC).  ‘+’ indicates that the time is ahead of (i.e., east of) UTC and ‘-’ indicates that the time is behind  (i.e.,  west\n           of)  UTC.   The  first two digits indicate the hour difference from UTC and the last two digits indicate the number of additional minutes difference from UTC.  The last two digits\n           must be in the range 00-59.\n\n       The first “title” line with the package name must start at the left hand margin.  The “trailer” line with the maintainer and date details must be preceded by exactly one space (U+0020\n       SPACE).  The maintainer details and the date must be separated by exactly two spaces (U+0020 SPACE).  Each part of the date can be separated by one  or  more  spaces  (U+0020  SPACE),\n       except after the comma where it can be separated by zero or more spaces (U+0020 SPACE).\n\n       Any line that consists entirely (i.e., no leading whitespace) of # or /* */ style comments or RCS keywords.\n\n       Vim modelines or Emacs local variables, and ancient changelog entries with other formats at the end of the file should be accepted and preserved on output, but their contents might be\n       otherwise ignored and parsing stopped at that point.\n\n       The entire changelog must be encoded in UTF-8.\n\nFILES\n       debian/changelog\n\nEXAMPLES\n        dpkg (1.17.18) unstable; urgency=low\n\n         [ Guillem Jover ]\n         * Handle empty minimum versions when initializing dependency versions,\n           as the code is mapping the minimum version 0 to '' to avoid outputting\n           useless versions. Regression introduced in dpkg 1.17.17. Closes: #764929\n\n         [ Updated programs translations ]\n         * Catalan (Guillem Jover).\n\n         [ Updated dselect translations ]\n         * Catalan (Guillem Jover).\n         * German (Sven Joachim).\n\n         -- Guillem Jover    Sun, 12 Oct 2014 15:47:44 +0200\n\nSEE ALSO\n       deb822(5), deb-changes(5), deb-version(7), dpkg-parsechangelog(1).\n\n1.22.21                                                                                   2025-06-30                                                                          deb-changelog(5)","ref":"deb-changelog.html"},{"type":"extras","title":"deb-changes","doc":"deb-changes(5)                                                                            dpkg suite                                                                            deb-changes(5)\n\nNAME\n       deb-changes - Debian upload changes control file format\n\nSYNOPSIS\n       filename.changes\n\nDESCRIPTION\n       Each Debian upload is composed of a .changes control file, which contains a number of fields in deb822(5) format.\n\n       Each field begins with a tag, such as Source or Binary (case insensitive), followed by a colon, and the body of the field (case sensitive unless stated otherwise).  Fields are\n       delimited only by field tags.  In other words, field text may be multiple lines in length, but the installation tools will generally join lines when processing the body of the field\n       (except in case of the multiline fields Description, Changes, Files, Checksums-Sha1 and Checksums-Sha256, see below).\n\n       The control data might be enclosed in an OpenPGP ASCII Armored signature, as specified in RFC9580.\n\nFIELDS\n       Format: format-version (required)\n           The  value  of  this  field  declares  the  format version of the file.  The syntax of the field value is a version number with a major and minor component.  Backward incompatible\n           changes to the format will bump the major version, and backward compatible changes (such as field additions) will bump the minor version.  The current format version is 1.8.\n\n       Date: release-date (required)\n           The date the package was built or last edited.  It must be in the same format as the date in a deb-changelog(5) entry.\n\n           The value of this field is usually extracted from the debian/changelog file.\n\n       Source: source-name [(source-version)] (required)\n           The name of the source package.  If the source version differs from the binary version, then the source-name will be followed by a source-version in parenthesis.  This can  happen\n           when the upload is a binary-only non-maintainer upload.\n\n       Binary: binary-package-list (required in context)\n           This folded field is a space-separated list of binary packages to upload.  If the upload is source-only, then the field is omitted (since dpkg 1.19.3).\n\n       Architecture: arch-list\n           Lists  the  architectures  of  the  files  currently  being  uploaded.   Common  architectures are amd64, armel, i386, etc.  Note that the all value is meant for packages that are\n           architecture independent.  If the source for the package is also being uploaded, the special entry source is also present.  Architecture wildcards must never  be  present  in  the\n           list.\n\n       Version: version-string (required)\n           Typically,  this is the original package's version number in whatever form the program's author uses.  It may also include a Debian revision number (for non-native packages).  The\n           exact format and sorting algorithm are described in deb-version(7).\n\n       Distribution: distributions (required)\n           Lists one or more space-separated distributions where this version should be installed when it is uploaded to the archive.\n\n       Urgency: urgency (recommended)\n           The urgency of the upload.  The currently known values, in increasing order of urgency, are: low, medium, high, critical and emergency.\n\n       Maintainer: fullname-email (required)\n           Should be in the format “Joe Bloggs  ”, and is typically the person who created the package, as opposed to the author of the software that was packaged.\n\n       Changed-By: fullname-email\n           Should be in the format “Joe Bloggs  ”, and is typically the person who prepared the package changes for this release.\n\n       Description: (recommended)\n        binary-package-name - binary-package-summary\n           This multiline field contains a list of binary package names followed by a space, a dash (‘-’) and their possibly truncated short descriptions.  If the upload is source-only, then\n           the field is omitted (since dpkg 1.19.3).\n\n       Closes: bug-number-list\n           A space-separated list of bug report numbers for bug reports that have been resolved with this upload.  The distribution archive software might use  this  field  to  automatically\n           close the referred bug numbers in the distribution bug tracking system.\n\n       Binary-Only: yes\n           This field denotes that the upload is a binary-only non-maintainer build.  It originates from the binary-only=yes key/value from the changelog metadata entry.\n\n       Built-For-Profiles: profile-list\n           This field specifies a whitespace separated list of build profiles that this upload was built with.\n\n       Changes: (required)\n        changelog-entries\n           This  multiline  field  contains  the concatenated text of all changelog entries that are part of the upload.  To make this a valid multiline field empty lines are replaced with a\n           single full stop (‘.’) and all lines are indented by one space character.  The exact content depends on the changelog format.\n\n       Files: (required)\n        md5sum size section priority filename\n           This multiline field contains a list of files with an md5sum, size, section and priority for each one.\n\n           The first line of the field value (the part on the same line as the field name followed by a colon) is always empty.  The content of the field is expressed as continuation  lines,\n           one line per file.  Each line consists of space-separated entries describing the file: the md5sum, the file size, the file section, the file priority, and the file name.\n\n           If the section or priority are omitted from the package, these default to unknown and optional respectively (since dpkg 1.22.13).\n\n           This field lists all files that make up the upload.  The list of files in this field must match the list of files in the other related Checksums fields.\n\n           Note:  The  MD5  checksum  is  considered  weak, and should never be assumed to be sufficient for secure verification, but this field cannot be omitted as it provides metadata not\n           available anywhere else.\n\n       Checksums-Sha1: (required, weak)\n       Checksums-Sha256: (required, strong)\n        checksum size filename\n           These multiline fields contain a list of files with a checksum and size for each one.  These fields have the same syntax and differ only in the checksum algorithm used: SHA-1  for\n           Checksums-Sha1 and SHA-256 for Checksums-Sha256.\n\n           The  first line of the field value (the part on the same line as the field name followed by a colon) is always empty.  The content of the field is expressed as continuation lines,\n           one line per file.  Each line consists of space-separated entries describing the file: the checksum, the file size, and the file name.\n\n           These fields list all files that make up the upload.  The list of files in these fields must match the list of files in the Files field and the other related Checksums fields.\n\n           Note: The SHA-1 checksum is considered weak, and should never be assumed to be sufficient for secure verification.\n\nBUGS\n       The Files field is inconsistent with the other Checksums fields.  The Changed-By and Maintainer fields have confusing names.  The Distribution field contains information about what is\n       commonly referred to as a suite.\n\nSEE ALSO\n       deb822(5), deb-src-control(5), deb-version(7).\n\n1.22.21                                                                                   2025-06-30                                                                            deb-changes(5)","ref":"deb-changes.html"},{"type":"extras","title":"deb-conffiles","doc":"deb-conffiles(5)                                                                          dpkg suite                                                                          deb-conffiles(5)\n\nNAME\n       deb-conffiles - package conffiles\n\nSYNOPSIS\n       DEBIAN/conffiles\n\nDESCRIPTION\n       A package declares its list of conffiles by including a conffiles file in its control archive (i.e. DEBIAN/conffiles during package creation).\n\n       This file contains a list of files, one per line, with an optional leading flag separated by whitespace.  The conffiles must be listed as absolute pathnames.  Trailing whitespace will\n       be trimmed, but empty or whitespace-only lines are not accepted.\n\n       Files without a flag should exist in the binary package, otherwise dpkg(1) will ignore them.\n\n       There is currently only one flag supported, remove-on-upgrade, to mark that a conffile needs to be removed on the next upgrade (since dpkg 1.20.6).  These files must not exist in the\n       binary package, as both dpkg(1) and dpkg-deb(1) will not accept building nor processing such binary packages.\n\nEXAMPLE\n        /etc/alternatives/README\n        /etc/cron.daily/dpkg\n        /etc/dpkg/dpkg.cfg\n        /etc/logrotate.d/dpkg\n        remove-on-upgrade /etc/some-old-file.conf\n\nSEE ALSO\n       dpkg-deb(1), dpkg(1).\n\n1.22.21                                                                                   2025-06-30                                                                          deb-conffiles(5)","ref":"deb-conffiles.html"},{"type":"extras","title":"deb-control","doc":"deb-control(5)                                                                            dpkg suite                                                                            deb-control(5)\n\nNAME\n       deb-control - Debian binary package control file format\n\nSYNOPSIS\n       DEBIAN/control\n\nDESCRIPTION\n       Each Debian binary package contains a control file in its control member, and its deb822(5) format is a subset of the debian/control template source control file in Debian source\n       packages, see deb-src-control(5).\n\n       This file contains a number of fields.  Each field begins with a tag, such as Package or Version (case insensitive), followed by a colon, and the body of the field (case sensitive\n       unless stated otherwise).  Fields are delimited only by field tags.  In other words, field text may be multiple lines in length, but the installation tools will generally join lines\n       when processing the body of the field (except in the case of the Description field, see below).\n\nFIELDS\n       Package: package-name (required)\n           The value of this field determines the package name, and is used to generate file names by most installation tools.\n\n       Package-Type: deb|udeb|type\n           This  field  defines the type of the package.  udeb is for size-constrained packages used by the debian installer.  deb is the default value, it is assumed if the field is absent.\n           More types might be added in the future.\n\n       Version: version-string (required)\n           Typically, this is the original package's version number in whatever form the program's author uses.  It may also include a Debian revision number (for non-native packages).   The\n           exact format and sorting algorithm are described in deb-version(7).\n\n       Maintainer: fullname-email (recommended)\n           Should be in the format “Joe Bloggs  ”, and is typically the person who created the package, as opposed to the author of the software that was packaged.\n\n       Description: short-description (recommended)\n        long-description\n           The  format  for  the  package description is a short brief summary on the first line (after the Description field).  The following lines should be used as a longer, more detailed\n           description.  Each line of the long description must be preceded by a space, and blank lines in the long description must contain a single ‘.’ following the preceding space.\n\n       Section: section\n           This is a general field that gives the package a category based on the software that it installs.  Some common sections are utils, net, mail, text, x11, etc.\n\n           The accepted values are based on the specific distribution policy.\n\n       Priority: priority\n           Sets the importance of this package in relation to the system as a whole.  The known priorities are required, important, standard, optional, extra, and unknown, but  other  values\n           can be used as well.\n\n           How to apply these values depends on the specific distribution policy.\n\n       Installed-Size: size\n           The approximate total size of the package's installed files, in KiB units.  The algorithm to compute the size is described in deb-substvars(5).\n\n       Protected: yes|no\n           This  field  is  usually  only  needed when the answer is yes.  It denotes a package that is required mostly for proper booting of the system or used for custom system-local meta-\n           packages.  dpkg(1) or any other installation tool will not allow a Protected package to be removed (at least not without using one of the force options).\n\n           Supported since dpkg 1.20.1.\n\n       Essential: yes|no\n           This field is usually only needed when the answer is yes.  It denotes a package that is required for the packaging system, for proper operation of the system in general or  during\n           boot  (although the latter should be converted to Protected field instead).  dpkg(1) or any other installation tool will not allow an Essential package to be removed (at least not\n           without using one of the force options).\n\n       Build-Essential: yes|no\n           This field is usually only needed when the answer is yes, and is commonly injected by the archive software.  It denotes a package that is required when building other packages.\n\n       Architecture: arch|all (required)\n           The architecture specifies which type of hardware this package was compiled for.  Common architectures are amd64, armel, i386, powerpc, etc.  Note that the all value is meant  for\n           packages that are architecture independent.  Some examples of this are shell and Perl scripts, and documentation.\n\n       Origin: name\n           The name of the distribution this package is originating from.\n\n       Bugs: url\n           The url of the bug tracking system for this package.  The current used format is bts-type://bts-address, like debbugs://bugs.debian.org.\n\n       Homepage: url\n           The upstream project home page url.\n\n       Tag: tag-list\n           List of tags describing the qualities of the package.  The description and list of supported tags can be found in the debtags package.\n\n       Multi-Arch: no|same|foreign|allowed\n           This field is used to indicate how this package should behave on a multi-arch installations.\n\n           no  This value is the default when the field is omitted, in which case adding the field with an explicit no value is generally not needed.\n\n           same\n               This package is co-installable with itself, but it must not be used to satisfy the dependency of any package of a different architecture from itself.\n\n           foreign\n               This  package is not co-installable with itself, but should be allowed to satisfy a non-arch-qualified dependency of a package of a different arch from itself (if a dependency\n               has an explicit arch-qualifier then the value foreign is ignored).\n\n           allowed\n               This allows reverse-dependencies to indicate in their Depends field that they accept this package from a foreign architecture by qualifying the package name with :any, but has\n               no effect otherwise.\n\n       Source: source-name [(source-version)]\n           The name of the source package that this binary package came from, if it is different than the name of the package itself.  If the source version differs from the binary  version,\n           then  the  source-name will be followed by a source-version in parenthesis.  This can happen for example on a binary-only non-maintainer upload, or when setting a different binary\n           version via «dpkg-gencontrol -v».\n\n       Subarchitecture: value\n       Kernel-Version: value\n       Installer-Menu-Item: value\n           These     fields     are     used     by     the     debian-installer     and     are     usually     not     needed.      For     more      details      about      them,      see\n            .\n\n       Depends: package-list\n           List of packages that are required for this package to provide a non-trivial amount of functionality.  The package maintenance software will not allow a package to be installed if\n           the  packages  listed in its Depends field aren't installed (at least not without using the force options).  In an installation, the postinst scripts of packages listed in Depends\n           fields are run before those of the packages which depend on them.  On the opposite, in a removal, the prerm script of a package is run before those of the packages listed  in  its\n           Depends field.\n\n       Pre-Depends: package-list\n           List  of packages that must be installed and configured before this one can be installed.  This is usually used in the case where this package requires another package for running\n           its preinst script.\n\n       Recommends: package-list\n           Lists packages that would be found together with this one in all but unusual installations.  The package maintenance software will warn the user if they install a package  without\n           those listed in its Recommends field.\n\n       Suggests: package-list\n           Lists packages that are related to this one and can perhaps enhance its usefulness, but without which installing this package is perfectly reasonable.\n\n       The syntax of Depends, Pre-Depends, Recommends and Suggests fields is a list of groups of alternative packages.  Each group is a list of packages separated by vertical bar (or “pipe”)\n       symbols, ‘|’.  The groups are separated by commas.  Commas are to be read as “AND”, and pipes as “OR”, with pipes binding more tightly.  Each package name is optionally followed by an\n       architecture qualifier appended after a colon ‘:’, optionally followed by a version number specification in parentheses.\n\n       An  architecture  qualifier  name  can  be  a  real  Debian  architecture  name  (since dpkg 1.16.5) or any (since dpkg 1.16.2).  If omitted, the default is the current binary package\n       architecture.  A real Debian architecture name will match exactly that architecture for that package name, any will match any architecture for that package name  if  the  package  has\n       been marked as Multi-Arch: allowed.\n\n       A  version  number  may start with a ‘>>’, in which case any later version will match, and may specify or omit the Debian packaging revision (separated by a hyphen).  Accepted version\n       relationships are ‘>>’ for greater than, ‘<<’ for less than, ‘>=’ for greater than or equal to, ‘<=’ for less than or equal to, and ‘=’ for equal to.\n\n       Breaks: package-list\n           Lists packages that this one breaks, for example by exposing bugs when the named packages rely on this one.  The package maintenance software will not allow broken packages to  be\n           configured; generally the resolution is to upgrade the packages named in a Breaks field.\n\n       Conflicts: package-list\n           Lists  packages  that  conflict  with  this  one,  for example by containing files with the same names.  The package maintenance software will not allow conflicting packages to be\n           installed at the same time.  Two conflicting packages should each include a Conflicts line mentioning the other.\n\n       Replaces: package-list\n           List of packages files from which this one replaces.  This is used for allowing this package to overwrite the files of another package and is usually used with the Conflicts field\n           to force removal of the other package, if this one also has the same files as the conflicted package.\n\n       The syntax of Breaks, Conflicts and Replaces is a list of package names, separated by commas (and optional whitespace).  In the Breaks and Conflicts fields, the comma should  be  read\n       as “OR”.  An optional architecture qualifier can also be appended to the package name with the same syntax as above, but the default is any instead of the binary package architecture.\n       An optional version can also be given with the same syntax as above for the Breaks, Conflicts and Replaces fields.\n\n       Enhances: package-list\n           This is a list of packages that this one enhances.  It is similar to Suggests but in the opposite direction.\n\n       Provides: package-list\n           This  is  a  list of virtual packages that this one provides.  Usually this is used in the case of several packages all providing the same service.  For example, sendmail and exim\n           can serve as a mail server, so they provide a common package (“mail-transport-agent”) on which other packages can depend.  This will allow sendmail or exim to  serve  as  a  valid\n           option  to  satisfy  the  dependency.  This prevents the packages that depend on a mail server from having to know the package names for all of them, and using ‘|’ to separate the\n           list.\n\n       The syntax of Provides is a list of package names, separated by commas (and optional whitespace).  An optional architecture qualifier can also be appended to the package name with the\n       same syntax as above.  If omitted, the default is the current binary package architecture.  An optional exact (equal to) version can also be  given  with  the  same  syntax  as  above\n       (honored since dpkg 1.17.11).\n\n       Built-Using: package-list\n           This  dependency  field  lists extra source packages that were used during the build of this binary package, for license compliance purposes.  This is an indication to the archive\n           maintenance software that these extra source packages must be kept whilst this binary package is maintained.  This field must be a comma-separated list  of  source  package  names\n           with strict ‘=’ version relationships enclosed within parenthesis.  Note that the archive maintenance software is likely to refuse to accept an upload which declares a Built-Using\n           relationship which cannot be satisfied within the archive.\n\n       Static-Built-Using: package-list\n           This  dependency  field  lists  extra  source  packages  that  were  used during the build of this binary package, for static building purposes (for example linking against static\n           libraries, builds for source-centered languages such as Go or Rust, usage of header-only C/C++ libraries, injecting data blobs into code, etc.).  This is useful to  track  whether\n           this package might need to be rebuilt when source packages listed here have been updated, for example due to security updates.  This field must be a comma-separated list of source\n           package names with strict ‘=’ version relationships enclosed within parenthesis.\n\n           Supported since dpkg 1.21.3.\n\n       Built-For-Profiles: profile-list (obsolete)\n           This  field  used  to specify a whitespace separated list of build profiles that this binary packages was built with (since dpkg 1.17.2 until 1.18.18).  The information previously\n           found in this field can now be found in the .buildinfo file, which supersedes it.\n\n       Auto-Built-Package: reason-list\n           This field specifies a whitespace separated list of reasons why this package was auto-generated.  Binary packages marked with this field will  not  appear  in  the  debian/control\n           template source control file.  The only currently used reason is debug-symbols.\n\n       Build-Ids: elf-build-id-list\n           This field specifies a whitespace separated list of ELF build-ids.  These are unique identifiers for semantically identical ELF objects, for each of these within the package.\n\n           The format or the way to compute each build-id is not defined by design.\n\nEXAMPLE\n        Package: grep\n        Essential: yes\n        Priority: required\n        Section: base\n        Maintainer: Wichert Akkerman  \n        Architecture: sparc\n        Version: 2.4-1\n        Pre-Depends: libc6 (>= 2.0.105)\n        Provides: rgrep\n        Conflicts: rgrep\n        Description: GNU grep, egrep and fgrep.\n         The GNU family of grep utilities may be the \"fastest grep in the west\".\n         GNU grep is based on a fast lazy-state deterministic matcher (about\n         twice as fast as stock Unix egrep) hybridized with a Boyer-Moore-Gosper\n         search for a fixed string that eliminates impossible text from being\n         considered by the full regexp matcher without necessarily having to\n         look at every character. The result is typically many times faster\n         than Unix grep or egrep. (Regular expressions containing backreferencing\n         will run more slowly, however).\n\nBUGS\n       The Build-Ids field uses a rather generic name out of its original context within an ELF object, which serves a very specific purpose and executable format.\n\nSEE ALSO\n       deb822(5), deb-src-control(5), deb(5), deb-version(7), debtags(1), dpkg(1), dpkg-deb(1).\n\n1.22.21                                                                                   2025-06-30                                                                            deb-control(5)","ref":"deb-control.html"},{"type":"extras","title":"deb-extra-override","doc":"deb-extra-override(5)                                                                     dpkg suite                                                                     deb-extra-override(5)\n\nNAME\n       deb-extra-override - Debian archive extra override file\n\nSYNOPSIS\n       override\n\nDESCRIPTION\n       While most information about a binary/source package can be found in the control/.dsc file, all of it can be overridden when it's exported to Packages/Sources files.  The extra\n       override file contains those overrides.\n\n       The extra override file has a simple whitespace-delimited format.  Comments are allowed (denoted with a #).\n\n           package field-name value\n\n       package is the name of the binary/source package.\n\n       field-name is the name of the field that is overridden.\n\n       value is the value to put in the field.  It can contain spaces as the line is split in no more than 3 columns when it's parsed.\n\n       The extra override files used to make the official Packages lists may be found in the indices directory on any Debian mirror.\n\nSEE ALSO\n       dpkg-scanpackages(1), dpkg-scansources(1), apt-ftparchive(1).\n\n1.22.21                                                                                   2025-06-30                                                                     deb-extra-override(5)","ref":"deb-extra-override.html"},{"type":"extras","title":"deb","doc":"deb(5)                                                                                    dpkg suite                                                                                    deb(5)\n\nNAME\n       deb - Debian binary package format\n\nSYNOPSIS\n       filename.deb\n\nDESCRIPTION\n       The .deb format is the Debian binary package file format.  It is understood since dpkg 0.93.76, and is generated by default since dpkg 1.2.0 and 1.1.1elf (i386/ELF builds).\n\n       The format described here is used since Debian 0.93; details of the old format are described in deb-old(5).\n\nFORMAT\n       The file is an ar archive with a magic value of ! .  Only the common ar archive format is supported, with no long file name extensions, but with file names containing an optional\n       trailing slash, which limits their length to 15 characters (from the 16 allowed).  File sizes are limited to 10 ASCII decimal digits, allowing for up to approximately 9536.74 MiB\n       member files.\n\n       The tar archives currently allowed are, the old-style (v7) format, the pre-POSIX ustar format, a subset of the GNU format (new style long pathnames and long linknames, supported since\n       dpkg 1.4.1.17; large file metadata since dpkg 1.18.24), and the POSIX ustar format (long names supported since dpkg 1.15.0).  Unrecognized tar typeflags are considered an error.  Each\n       tar entry size inside a tar archive is limited to 11 ASCII octal digits, allowing for up to 8 GiB tar entries.  The GNU large file metadata support permits 95-bit tar entry sizes and\n       negative timestamps, and 63-bit UID, GID and device numbers.\n\n       The first member is named debian-binary and contains a series of lines, separated by newlines.  Currently only one line is present, the format version number, 2.0 at the time this\n       manual page was written.  Programs which read new-format archives should be prepared for the minor number to be increased and new lines to be present, and should ignore these if this\n       is the case.\n\n       If the major number has changed, an incompatible change has been made and the program should stop.  If it has not, then the program should be able to safely continue, unless it\n       encounters an unexpected member in the archive (except at the end), as described below.\n\n       The second required member is named control.tar.  It is a tar archive containing the package control information, either not compressed (supported since dpkg 1.17.6), or compressed\n       with gzip (with .gz extension) or xz (with .xz extension, supported since 1.17.6), zstd (with .zst extension, supported since dpkg 1.21.18), as a series of plain files, of which the\n       file control is mandatory and contains the core control information, the md5sums, conffiles, triggers, shlibs and symbols files contain optional control information, and the preinst,\n       postinst, prerm and postrm files are optional maintainer scripts.  The control tarball may optionally contain an entry for ‘.’, the current directory.\n\n       The third, last required member is named data.tar.  It contains the filesystem as a tar archive, either not compressed (supported since dpkg 1.10.24), or compressed with gzip (with\n       .gz extension), xz (with .xz extension, supported since dpkg 1.15.6), zstd (with .zst extension, supported since dpkg 1.21.18), bzip2 (with .bz2 extension, supported since dpkg\n       1.10.24) or lzma (with .lzma extension, supported since dpkg 1.13.25).\n\n       These members must occur in this exact order.  Current implementations should ignore any additional members after data.tar.  Further members may be defined in the future, and (if\n       possible) will be placed after these three.  Any additional members that may need to be inserted after debian-binary and before control.tar or data.tar and which should be safely\n       ignored by older programs, will have names starting with an underscore, ‘_’.\n\n       Those new members which won't be able to be safely ignored will be inserted before data.tar with names starting with something other than underscores, or will (more likely) cause the\n       major version number to be increased.\n\nMEDIA TYPE\n   Current\n       application/vnd.debian.binary-package\n\n   Deprecated\n       application/x-debian-package\n\n       application/x-deb\n\nSEE ALSO\n       deb-old(5), dpkg-deb(1), deb-control(5), deb-conffiles(5), deb-md5sums(5), deb-triggers(5), deb-shlibs(5), deb-symbols(5), deb-preinst(5), deb-postinst(5), deb-prerm(5),\n       deb-postrm(5).\n\n1.22.21                                                                                   2025-06-30                                                                                    deb(5)","ref":"deb.html"},{"type":"extras","title":"deb-md5sums","doc":"deb-md5sums(5)                                                                            dpkg suite                                                                            deb-md5sums(5)\n\nNAME\n       deb-md5sums - package MD5 file digests\n\nSYNOPSIS\n       DEBIAN/md5sums\n\nDESCRIPTION\n       A package declares the MD5 digests for the package file contents by including an md5sums file in its control archive (i.e. DEBIAN/md5sums during package creation).  This file is used\n       for integrity verification and deduplication purposes, and not for any kind of security purpose.\n\n       This file contains a list of MD5 digests (as 32 case-insensitive hexadecimal characters) followed by two spaces (U+0020 SPACE) and the absolute pathname of a plain file, one per line.\n\n       Trailing slashes (U+002F /) in the pathname will be trimmed.  Neither trailing whitespace nor empty or whitespace-only lines are accepted.\n\n       If the control file does not exist in the binary package, dpkg(1) will generate the matching information at unpack time (since dpkg 1.16.3).\n\nEXAMPLE\n        53c0d4afe4bc4eccb5cb234d2e06ef4d  usr/bin/dpkg\n        f8da2bc74cdcad8b81c48a4f0d7bb0a8  usr/bin/dpkg-deb\n        70b913132de56e95e75de504979309b4  usr/bin/dpkg-divert\n        […]\n\nSEE ALSO\n       md5sum(1), dpkg-deb(1), dpkg(1).\n\n1.22.21                                                                                   2025-06-30                                                                            deb-md5sums(5)","ref":"deb-md5sums.html"},{"type":"extras","title":"deb-old","doc":"deb-old(5)                                                                                dpkg suite                                                                                deb-old(5)\n\nNAME\n       deb-old - old style Debian binary package format\n\nSYNOPSIS\n       filename.deb\n\nDESCRIPTION\n       The .deb format is the Debian binary package file format.  This manual page describes the old format, used before Debian 0.93.  Please see deb(5) for details of the new format.\n\nFORMAT\n       The file is two lines of format information as ASCII text, followed by two concatenated gzipped ustar files.\n\n       The first line is the format version number padded to 8 digits, and is 0.939000 for all old-format archives.\n\n       The second line is a decimal string (without leading zeroes) giving the length of the first gzipped tarfile.\n\n       Each of these lines is terminated with a single newline character.\n\n       The first tarfile contains the control information, as a series of ordinary files.  The file control must be present, as it contains the core control information.\n\n       In some very old archives, the files in the control tarfile may optionally be in a DEBIAN subdirectory.  In that case, the DEBIAN subdirectory will be in the control tarfile too, and\n       the control tarfile will have only files in that directory.  Optionally the control tarfile may contain an entry for ‘.’, that is, the current directory.\n\n       The second gzipped tarfile is the filesystem archive, containing pathnames relative to the root directory of the system to be installed on.  The pathnames do not have leading slashes.\n\nSEE ALSO\n       deb(5), deb-control(5), dpkg-deb(1).\n\n1.22.21                                                                                   2025-06-30                                                                                deb-old(5)","ref":"deb-old.html"},{"type":"extras","title":"deb-origin","doc":"deb-origin(5)                                                                             dpkg suite                                                                             deb-origin(5)\n\nNAME\n       deb-origin - Vendor-specific information files\n\nSYNOPSIS\n       /etc/dpkg/origins/filename\n\nDESCRIPTION\n       The files in /etc/dpkg/origins can provide information about various vendors that are providing Debian packages.  These files are usually used both to determine the behavior of tools\n       and resulting contents during package builds targeting a specific vendor, and to describe the provenance of packages.\n\n       Packages can explicitly declare their vendor by including an Origin field, otherwise the vendor for a package without such field is assumed to be the one pointed to by the default\n       origin symbolic link.\n\n       They contain a number of fields, or comments when the line starts with ‘#’.  Each field begins with a tag, such as Vendor or Parent, followed by a colon and the body of the field.\n       Fields are delimited only by field tags.  In other words, field text may be multiple lines in length, but the tools will join lines when processing the body of the field.\n\n       The file should be named according to the vendor name.  The usual convention is to name the vendor file using the vendor name in all lowercase, but some variation is permitted.\n\n       Namely (since dpkg 1.21.10), first, non-alphanumeric characters (‘[^A-Za-z0-9]’) are mapped to dashes (‘-’), then the resulting name will be tried in sequence by lower-casing it,\n       keeping it as is, lower-casing then capitalizing it (that is upper-casing the first character), and only capitalizing it.\n\nFIELDS\n       Vendor: vendor-name (required)\n           The value of this field determines the vendor name.\n\n       Vendor-URL: vendor-url\n           The value of this field determines the vendor URL.\n\n       Bugs: bug-url\n           The  value  of  this  field  determines  the  type  and  address  of  the  bug  tracking  system  used  by  this  vendor.   It  can  be  a  mailto  URL  or  a  debbugs  URL (e.g.,\n           debbugs://bugs.debian.org/).\n\n       Parent: vendor-name\n           The value of this field determines the vendor name of the vendor that this vendor derives from.\n\nEXAMPLE\n        Vendor: Debian\n        Vendor-URL: https://www.debian.org/\n        Bugs: debbugs://bugs.debian.org\n\nSEE ALSO\n       dpkg-vendor(1).\n\n1.22.21                                                                                   2025-06-30                                                                             deb-origin(5)","ref":"deb-origin.html"},{"type":"extras","title":"deb-override","doc":"deb-override(5)                                                                           dpkg suite                                                                           deb-override(5)\n\nNAME\n       deb-override - Debian archive override file\n\nSYNOPSIS\n       override\n\nDESCRIPTION\n       While most information about a package can be found in the control file, some is managed centrally by the distribution czars rather than by the maintainer in order to offer some\n       global consistency.  This information is found in the override file.\n\n       The override file has a simple whitespace-delimited format.  Comments are allowed (denoted with a #).\n\n           package priority section [maintainer-info]\n\n       package is the name of the package.  Entries in the override file for packages not found in the tree of binary packages are ignored.\n\n       priority and section correspond to the respective control fields available in the .deb.  The allowed values are specific to each distribution archive.\n\n       maintainer-info, if present, can be either the name of a maintainer for an unconditional override, or else old-maintainer => new-maintainer to perform a substitution.\n\n       The override files used to make the official Packages lists may be found in the indices directory on any Debian mirror.\n\nSEE ALSO\n       dpkg-scanpackages(1), dpkg-scansources(1), apt-ftparchive(1).\n\n1.22.21                                                                                   2025-06-30                                                                           deb-override(5)","ref":"deb-override.html"},{"type":"extras","title":"deb-postinst","doc":"deb-postinst(5)                                                                           dpkg suite                                                                           deb-postinst(5)\n\nNAME\n       deb-postinst - package post-installation maintainer script\n\nSYNOPSIS\n       DEBIAN/postinst\n\nDESCRIPTION\n       A package can perform several post-installation actions via maintainer scripts, by including an executable postinst file in its control archive (i.e. DEBIAN/postinst during package\n       creation).\n\n       The script can be called in the following ways:\n\n       postinst configure old-version\n           After the package was installed.\n\n       postinst triggered \"trigger-name...\"\n           After the package was triggered.  The list of space-separated trigger-names is passed as the second argument.\n\n       old-postinst abort-upgrade new-version\n           If prerm fails during upgrade or fails on failed-upgrade.\n\n       old-postinst abort-remove\n           If prerm fails during remove.\n\n       postinst abort-deconfigure in-favour new-package new-version\n              [ removing old-package old-version ]\n           If prerm fails during deconfigure in-favour of a package.\n\n       postinst abort-remove in-favour new-package new-version\n           If prerm fails during remove in-favour for replacement due to conflict.\n\nSEE ALSO\n       dpkg(1).\n\n1.22.21                                                                                   2025-06-30                                                                           deb-postinst(5)","ref":"deb-postinst.html"},{"type":"extras","title":"deb-postrm","doc":"deb-postrm(5)                                                                             dpkg suite                                                                             deb-postrm(5)\n\nNAME\n       deb-postrm - package post-removal maintainer script\n\nSYNOPSIS\n       DEBIAN/postrm\n\nDESCRIPTION\n       A package can perform several post-removal actions via maintainer scripts, by including an executable postrm file in its control archive (i.e. DEBIAN/postrm during package creation).\n\n       The script can be called in the following ways:\n\n       postrm remove\n           After the package was removed.\n\n       postrm purge\n           After the package was purged.\n\n       old-postrm upgrade new-version\n           After the package was upgraded.\n\n       new-postrm failed-upgrade old-version new-version\n           If the above upgrade call fails.\n\n           The new-version is passed only since dpkg 1.18.5.\n\n       postrm disappear overwriter-package overwriter-version\n           After all of the packages files have been replaced.\n\n       new-postrm abort-install\n           If preinst fails during install.\n\n       new-postrm abort-install old-version new-version\n           If preinst fails during install for an upgrade of a removed package.\n\n           The new-version is passed only since dpkg 1.18.5.\n\n       new-postrm abort-upgrade old-version new-version\n           If preinst fails during upgrade.\n\n           The new-version is passed only since dpkg 1.18.5.\n\nSEE ALSO\n       dpkg(1).\n\n1.22.21                                                                                   2025-06-30                                                                             deb-postrm(5)","ref":"deb-postrm.html"},{"type":"extras","title":"deb-preinst","doc":"deb-preinst(5)                                                                            dpkg suite                                                                            deb-preinst(5)\n\nNAME\n       deb-preinst - package pre-installation maintainer script\n\nSYNOPSIS\n       DEBIAN/preinst\n\nDESCRIPTION\n       A package can perform several pre-installation actions via maintainer scripts, by including an executable preinst file in its control archive (i.e. DEBIAN/preinst during package\n       creation).\n\n       The script can be called in the following ways:\n\n       new-preinst install\n           Before the package is installed.\n\n       new-preinst install old-version new-version\n           Before a removed package is upgraded.\n\n           The new-version is passed only since dpkg 1.18.5.\n\n       new-preinst upgrade old-version new-version\n           Before the package is upgraded.\n\n           The new-version is passed only since dpkg 1.18.5.\n\n       old-preinst abort-upgrade new-version\n           If postrm fails during upgrade or fails on failed upgrade.\n\nSEE ALSO\n       dpkg(1).\n\n1.22.21                                                                                   2025-06-30                                                                            deb-preinst(5)","ref":"deb-preinst.html"},{"type":"extras","title":"deb-prerm","doc":"deb-prerm(5)                                                                              dpkg suite                                                                              deb-prerm(5)\n\nNAME\n       deb-prerm - package pre-removal maintainer script\n\nSYNOPSIS\n       DEBIAN/prerm\n\nDESCRIPTION\n       A package can perform several pre-removal actions via maintainer scripts, by including an executable prerm file in its control archive (i.e. DEBIAN/prerm during package creation).\n\n       The script can be called in the following ways:\n\n       prerm remove\n           Before the package is removed.\n\n       old-prerm upgrade new-version\n           Before an upgrade.\n\n       new-prerm failed-upgrade old-version new-version\n           If the above upgrade fails.\n\n           The new-version is passed only since dpkg 1.18.5.\n\n       prerm deconfigure in-favour new-package new-version\n           [ removing old-package old-version ]\n           Before package is deconfigured while dependency is replaced due to conflict.\n\n       prerm remove in-favour new-package new-version\n           Before the package is replaced due to conflict.\n\nSEE ALSO\n       dpkg(1).\n\n1.22.21                                                                                   2025-06-30                                                                              deb-prerm(5)","ref":"deb-prerm.html"},{"type":"extras","title":"deb-shlibs","doc":"deb-shlibs(5)                                                                             dpkg suite                                                                             deb-shlibs(5)\n\nNAME\n       deb-shlibs - Debian shared library information file\n\nSYNOPSIS\n       debian/shlibs, debian/binary-name.shlibs, DEBIAN/shlibs\n\nDESCRIPTION\n       shlibs files map shared library names and versions (SONAMEs) to dependencies suitable for a package control file.  There is one entry per line.  Blank lines are not allowed.  Lines\n       beginning with a # character are considered commentary, and are ignored.  All other lines must have the format:\n\n           [type:] library version dependencies\n\n       The library and version fields are whitespace-delimited, but the dependencies field extends to the end of the line.  The type field is optional and normally not needed.\n\n       The dependencies field has the same syntax as the Depends field in a binary control file, see deb-control(5).\n\nSONAME FORMATS\n       The SONAME formats supported are:\n\n           name.so.version\n\n       and\n\n           name-version.so\n\n       where name is usually prefixed by lib.\n\n       The former tends to be used by shared libraries with stable interfaces.  The latter by shared libraries with unstable interfaces, where the whole version becomes part of the SONAME\n       and needs to be specified in full when linking against those libraries.\n\nEXAMPLES\n       The shlibs file for a typical library package, named libcrunch1, that provides one library whose SONAME is libcrunch.so.1, might read\n\n        libcrunch 1 libcrunch1 (>= 1.2-1)\n\n       The dependencies must mention the most recent version of the package that added new symbols to the library: in the above example, new symbols were added to version 1.2 of libcrunch.\n       This is not the only reason the dependencies might need to be tightened.\n\nSEE ALSO\n       deb-control(5), deb-symbols(5), dpkg-shlibdeps(1).\n\n1.22.21                                                                                   2025-06-30                                                                             deb-shlibs(5)","ref":"deb-shlibs.html"},{"type":"extras","title":"deb-split","doc":"deb-split(5)                                                                              dpkg suite                                                                              deb-split(5)\n\nNAME\n       deb-split - Debian multi-part binary package format\n\nSYNOPSIS\n       filename.deb\n\nDESCRIPTION\n       The multi-part .deb format is used to split big packages into smaller pieces to ease transport in small media.\n\nFORMAT\n       The file is an ar archive with a magic value of ! .  The file names might contain a trailing slash (since dpkg 1.15.6).\n\n       The first member is named debian-split and contains a series of lines, separated by newlines.  Currently eight lines are present:\n\n       •   The format version number, 2.1 at the time this manual page was written.\n\n       •   The package name.\n\n       •   The package version.\n\n       •   The md5sum of the package.\n\n       •   The total size of the package.\n\n       •   The maximum part size.\n\n       •   The current part number, followed by a slash and the total amount of parts (as in ‘1/10’).\n\n       •   The package architecture (since dpkg 1.16.1).\n\n       Programs  which  read multi-part archives should be prepared for the minor format version number to be increased and additional lines to be present, and should ignore these if this is\n       the case.\n\n       If the major format version number has changed, an incompatible change has been made and the program should stop.  If it has not, then the program should be able to  safely  continue,\n       unless it encounters an unexpected member in the archive (except at the end), as described below.\n\n       The second, last required member is named data.N, where N denotes the part number.  It contains the raw part data.\n\n       These  members  must  occur  in  this  exact  order.  Current implementations should ignore any additional members after data.N.  Further members may be defined in the future, and (if\n       possible) will be placed after these two.\n\nSEE ALSO\n       deb(5), dpkg-split(1).\n\n1.22.21                                                                                   2025-06-30                                                                              deb-split(5)","ref":"deb-split.html"},{"type":"extras","title":"deb-src-control","doc":"deb-src-control(5)                                                                        dpkg suite                                                                        deb-src-control(5)\n\nNAME\n       deb-src-control - Debian source package template control file format\n\nSYNOPSIS\n       debian/control\n\nDESCRIPTION\n       Each Debian source package contains the «debian/control» template source control file, and its deb822(5) format is a superset of the control file shipped in Debian binary packages,\n       see deb-control(5).\n\n       This file contains at least 2 stanzas, separated by a blank line.  The first stanza is called the source package stanza and lists all information about the source package in general,\n       while each following stanzas are called the binary package stanzas and describe exactly one binary package per stanza.  Each stanza consists of at least one field.  A field starts\n       with a field name, such as Package or Section (case insensitive), followed by a colon, the body of the field (case sensitive unless stated otherwise) and a newline.  Multi-line fields\n       are also allowed, but each supplementary line, without a field name, must start with at least one space.  The content of the multi-line fields is generally joined to a single line by\n       the tools (except in the case of the Description field, see below).  To insert empty lines into a multi-line field, insert a dot after the space.  Lines starting with a ‘#’ are\n       treated as comments.\n\nSOURCE FIELDS\n       Source: source-package-name (required)\n           The  value  of  this  field  is  the  name  of the source package, and must match the name of the source package in the debian/changelog file.  A package name must consist only of\n           lowercase letters (a-z), digits (0-9), plus (+) and minus (-) signs, and periods (.).  Package names must be at  least  two  characters  long  and  must  start  with  a  lowercase\n           alphanumeric character (a-z0-9).\n\n       Maintainer: fullname-email (recommended)\n           Should  be  in  the  format «Joe Bloggs  », and references the person who currently maintains the package, as opposed to the author of the software or the original\n           packager.\n\n       Uploaders: fullname-email\n           Lists all the names and email addresses of co-maintainers of the package, in the same format as the Maintainer field.  Multiple co-maintainers should be separated by a comma.\n\n       Standards-Version: version-string\n           This documents the most recent version of the distribution policy standards this package complies with.\n\n       Description short-description\n        long-description\n           The format for the source package description is a short brief summary on the first line (after the Description field).  The following lines should  be  used  as  a  longer,  more\n           detailed  description.   Each  line  of the long description must be preceded by a space, and blank lines in the long description must contain a single ‘.’ following the preceding\n           space.\n\n       Homepage: url\n           The upstream project home page URL.\n\n       Bugs: url\n           The url of the bug tracking system for this package.  The current used format is bts-type://bts-address, like debbugs://bugs.debian.org.  This field is usually not needed.\n\n       Build-Driver: driver-name\n           This experimental field specifies the name of the build driver to use to build this package.  When omitted the driver-name defaults to debian-rules.\n\n           This field is supported since dpkg 1.22.7.\n\n       Rules-Requires-Root: no|binary-targets|impl-keywords\n           This field is used to indicate whether the debian/rules file requires (fake)root privileges to run some of its targets, and if so when.\n\n           no  The binary targets will not require (fake)root at all.  This is the default in dpkg-build-api level >= 1, or since dpkg 1.22.13.\n\n           binary-targets\n               The binary targets must always be run under (fake)root.  This value is the default in dpkg-build-api level 0 until dpkg 1.22.13, when the field is omitted;  adding  the  field\n               with an explicit binary-targets, while not strictly needed, marks it as having been analyzed for this requirement.\n\n           impl-keywords\n               This is a space-separated list of keywords which define when (fake)root is required.\n\n               Keywords  consist  of  namespace/cases.   The namespace part cannot contain \"/\" or whitespace.  The cases part cannot contain whitespace.  Furthermore, both parts must consist\n               entirely of printable ASCII characters.\n\n               Each tool/package will define a namespace named after itself and provide a number  of  cases  where  (fake)root  is  required.   (See  \"Implementation  provided  keywords\"  in\n               rootless-builds.txt).\n\n               When  the  field  is  set  to  one  of  the  impl-keywords,  the  builder  will  expose  an  interface that is used to run a command under (fake)root.  (See \"Gain Root API\" in\n               rootless-builds.txt.)\n\n       Testsuite: name-list\n       Testsuite-Triggers: package-list\n           These fields are described in the dsc(5) manual page, as they are generated from information inferred from debian/tests/control or copied literally to the source control file.\n\n       Vcs-Arch: url\n       Vcs-Bzr: url\n       Vcs-Cvs: url\n       Vcs-Darcs: url\n       Vcs-Git: url\n       Vcs-Hg: url\n       Vcs-Mtn: url\n       Vcs-Svn: url\n           The url of the Version Control System repository used to maintain this package.  Currently supported are Arch, Bzr (Bazaar), Cvs, Darcs, Git, Hg (Mercurial),  Mtn  (Monotone)  and\n           Svn (Subversion).  Usually this field points to the latest version of the package, such as the main branch or the trunk.\n\n       Vcs-Browser: url\n           The url of a web interface to browse the Version Control System repository.\n\n       Origin: name\n           The name of the distribution this package is originating from.  This field is usually not needed.\n\n       Section: section\n           This is a general field that gives the package a category based on the software that it installs.  Some common sections are utils, net, mail, text, x11, etc.\n\n           When omitted, the section defaults to unknown (since dpkg 1.22.13).\n\n           The accepted values are based on the specific distribution policy.\n\n       Priority: priority\n           Sets  the  importance of this package in relation to the system as a whole.  The known priorities are required, important, standard, optional, extra, and unknown, but other values\n           can be used as well.\n\n           When omitted, the priority defaults to optional (since dpkg 1.22.13).\n\n           How to apply these values depends on the specific distribution policy.\n\n       Build-Depends: package-list\n           A list of packages that need to be installed and configured to be able to build from source package.  These dependencies need to be satisfied  when  building  binary  architecture\n           dependent  or  independent  packages  and source packages.  Including a dependency in this field does not have the exact same effect as including it in both Build-Depends-Arch and\n           Build-Depends-Indep, because the dependency also needs to be satisfied when building the source package.\n\n       Build-Depends-Arch: package-list\n           Same as Build-Depends, but they are only needed when building the architecture dependent packages.  The Build-Depends are also installed in this case.   This  field  is  supported\n           since dpkg 1.16.4; in order to build with older dpkg versions, Build-Depends should be used instead.\n\n       Build-Depends-Indep: package-list\n           Same as Build-Depends, but they are only needed when building the architecture independent packages.  The Build-Depends are also installed in this case.\n\n       Build-Conflicts: package-list\n           A  list of packages that should not be installed when the package is built, for example because they interfere with the build system used.  Including a dependency in this list has\n           the same effect as including it in both Build-Conflicts-Arch and Build-Conflicts-Indep, with the additional effect of being used for source-only builds.\n\n       Build-Conflicts-Arch: package-list\n           Same as Build-Conflicts, but only when building the architecture dependent packages.  This field is supported since dpkg 1.16.4; in order to build with older dpkg versions, Build-\n           Conflicts should be used instead.\n\n       Build-Conflicts-Indep: package-list\n           Same as Build-Conflicts, but only when building the architecture independent packages.\n\n       The syntax of the Build-Depends, Build-Depends-Arch and Build-Depends-Indep fields is a list of groups of alternative packages.  Each group is a list of packages separated by vertical\n       bar (or “pipe”) symbols, ‘|’.  The groups are separated by commas ‘,’, and can end with a trailing comma that will be eliminated when generating the fields for  deb-control(5)  (since\n       dpkg  1.10.14).   Commas  are  to be read as “AND”, and pipes as “OR”, with pipes binding more tightly.  Each package name is optionally followed by an architecture qualifier appended\n       after a colon ‘:’, optionally followed by a version number specification in parentheses ‘(’ and ‘)’, an architecture specification in square brackets ‘[’ and ‘]’,  and  a  restriction\n       formula consisting of one or more lists of profile names in angle brackets ‘<’ and ‘>’.\n\n       The syntax of the Build-Conflicts, Build-Conflicts-Arch and Build-Conflicts-Indep fields is a list of comma-separated package names, where the comma is read as an “AND”, and where the\n       list  can  end with a trailing comma that will be eliminated when generating the fields for deb-control(5) (since dpkg 1.10.14).  Specifying alternative packages using a “pipe” is not\n       supported.  Each package name is optionally followed by a version number specification in parentheses, an architecture specification in square  brackets,  and  a  restriction  formula\n       consisting of one or more lists of profile names in angle brackets.\n\n       An  architecture  qualifier name can be a real Debian architecture name (since dpkg 1.16.5), any (since dpkg 1.16.2) or native (since dpkg 1.16.5).  If omitted, the default for Build-\n       Depends fields is the current host architecture, the default for Build-Conflicts fields is any.  A real Debian architecture name will match exactly that architecture for that  package\n       name,  any  will match any architecture for that package name if the package is marked with Multi-Arch: allowed, and native will match the current build architecture if the package is\n       not marked with Multi-Arch: foreign.\n\n       A version number may start with a ‘>>’, in which case any later version will match, and may specify or omit the Debian packaging revision (separated by a  hyphen).   Accepted  version\n       relationships are ‘>>’ for greater than, ‘<<’ for less than, ‘>=’ for greater than or equal to, ‘<=’ for less than or equal to, and ‘=’ for equal to.\n\n       An architecture specification consists of one or more architecture names, separated by whitespace.  Exclamation marks may be prepended to each of the names, meaning “NOT”.\n\n       A  restriction  formula  consists  of  one or more restriction lists, separated by whitespace.  Each restriction list is enclosed in angle brackets.  Items in the restriction list are\n       build profile names, separated by whitespace and can be prefixed with an exclamation mark, meaning “NOT”.  A restriction formula represents a disjunctive normal form expression.\n\n       Note that dependencies on packages in the build-essential set can be omitted and that declaring build conflicts against them is impossible.  A list of these packages is in the  build-\n       essential package.\n\nBINARY FIELDS\n       Note that the Priority, Section and Homepage fields can also be in a binary stanza to override the global value from the source package.\n\n       Package: binary-package-name (required)\n           This field is used to name the binary package name.  The same restrictions as to a source package name apply.\n\n       Package-Type: deb|udeb|type\n           This  field  defines the type of the package.  udeb is for size-constrained packages used by the debian installer.  deb is the default value, it is assumed if the field is absent.\n           More types might be added in the future.\n\n       Architecture: arch|all|any (required)\n           The architecture specifies on which type of hardware this package runs.  For packages that run on all architectures, use  the  any  value.   For  packages  that  are  architecture\n           independent,  such  as  shell  and  Perl  scripts or documentation, use the all value.  To restrict the packages to a certain set of architectures, specify the architecture names,\n           separated by a space.  It's also possible to put architecture wildcards in that list (see dpkg-architecture(1) for more information about them).\n\n       Build-Profiles: restriction-formula\n           This field specifies the conditions for which this binary package does or does not build.  To express that condition, the same restriction formula syntax  from  the  Build-Depends\n           field is used (including the angle brackets).\n\n           If a binary package stanza does not contain this field, then it implicitly means that it builds with all build profiles (including none at all).\n\n           In  other words, if a binary package stanza is annotated with a non-empty Build-Profiles field, then this binary package is generated if and only if the condition expressed by the\n           conjunctive normal form expression evaluates to true.\n\n       Protected: yes|no\n       Essential: yes|no\n       Build-Essential: yes|no\n       Multi-Arch: same|foreign|allowed|no\n       Tag: tag-list\n       Description: short-description (recommended)\n           These fields are described in the deb-control(5) manual page, as they are copied literally to the control file of the binary package.\n\n       Depends: package-list\n       Pre-Depends: package-list\n       Recommends: package-list\n       Suggests: package-list\n       Breaks: package-list\n       Enhances: package-list\n       Replaces: package-list\n       Conflicts: package-list\n       Provides: package-list\n       Built-Using: package-list\n       Static-Built-Using: package-list\n           These fields declare relationships between packages.  They are discussed in the deb-control(5) manual page.  When these fields are found in debian/control they can also end with a\n           trailing comma (since dpkg 1.10.14), have architecture specifications and restriction formulas which will all get reduced when generating the fields for deb-control(5).\n\n       Subarchitecture: value\n       Kernel-Version: value\n       Installer-Menu-Item: value\n           These    fields    are    used    by    the    debian-installer    in    udebs    and    are    usually    not    needed.      For     more     details     about     them,     see\n            .\n\nUSER-DEFINED FIELDS\n       It  is  allowed  to add additional user-defined fields to the control file.  The tools will ignore these fields.  If you want the fields to be copied over to the output files, such as\n       the binary packages, you need to use a custom naming scheme: the fields should start with an X, followed by zero or more of the letters SBC and a hyphen.\n\n       S   The field will appear in the source package control file, see dsc(5).\n\n       B   The field will appear in the control file in the binary package, see deb-control(5).\n\n       C   The field will appear in the upload control (.changes) file, see deb-changes(5).\n\n       Note that the X[SBC]- prefixes are stripped when the fields are copied over to the output files.  A field XC-Approved-By will appear as Approved-By in the changes file  and  will  not\n       appear in the binary or source package control files.\n\n       Take  into account that these user-defined fields will be using the global namespace, which might at some point in the future collide with officially recognized fields.  To avoid such\n       potential situation you can prefix those fields with Private-, such as XB-Private-New-Field.\n\nEXAMPLE\n        # Comment\n        Source: dpkg\n        Section: admin\n        Priority: required\n        Maintainer: Dpkg Developers  \n        # This field is copied to the binary and source packages.\n        XBS-Upstream-Release-Status: stable\n        Homepage: https://wiki.debian.org/Teams/Dpkg\n        Vcs-Browser: https://git.dpkg.org/cgit/dpkg/dpkg.git\n        Vcs-Git: https://git.dpkg.org/git/dpkg/dpkg.git\n        Standards-Version: 4.7.0\n        Build-Depends:\n         debhelper-compat (= 13),\n         debhelper (>= 13.10~),\n         pkgconf,\n         libselinux1-dev (>= 1.28-4) [!linux-any],\n\n        Package: dpkg-dev\n        Section: utils\n        Priority: optional\n        Architecture: all\n        # This is a custom field in the binary package.\n        XB-Mentoring-Contact: Raphael Hertzog  \n        Depends:\n         binutils,\n         bzip2,\n         cpio (>= 2.4.2-2),\n        # This is a comment in the middle of a field value.\n         dpkg (>= 1.14.6),\n         libtimedate-perl,\n         lzma,\n         make,\n         patch (>= 2.2-1),\n         perl-modules,\n         perl5,\n        Recommends:\n         gcc | c-compiler,\n         build-essential,\n        Suggests:\n         gnupg,\n         debian-keyring,\n        Conflicts:\n         dpkg-cross (<< 2.0.0),\n         devscripts (<< 2.10.26),\n        Replaces:\n         manpages-pl (<= 20051117-1),\n        Description: Debian package development tools\n         This package provides the development tools (including dpkg-source)\n         required to unpack, build and upload Debian source packages.\n         .\n         Most Debian source packages will require additional tools to build;\n         for example, most packages need make and the C compiler gcc.\n\nSEE ALSO\n       /usr/share/doc/dpkg/spec/rootless-builds.txt, deb822(5), deb-control(5), deb-version(7), dpkg-source(1)\n\n1.22.21                                                                                   2025-06-30                                                                        deb-src-control(5)","ref":"deb-src-control.html"},{"type":"extras","title":"deb-src-files","doc":"deb-src-files(5)                                                                          dpkg suite                                                                          deb-src-files(5)\n\nNAME\n       deb-src-files - Debian distribute files format\n\nSYNOPSIS\n       debian/files\n\nDESCRIPTION\n       This file contains the list of artifacts that are to be distributed via the .changes control file.\n\n       The debian/files file has a simple whitespace-delimited format.\n\n           filename section priority [ keyword=value...  ]\n\n       filename is the name of the artifact to distribute.\n\n       section and priority correspond to the respective control fields available in the .deb.  The allowed values are specific to each distribution archive.\n\n       keyword=value...  corresponds to an optional whitespace-delimited list of attributes for this entry.  The only currently supported keyword is automatic with value yes, to mark\n       automatically generated files.\n\nNOTES\n       This file is not intended to be modified directly, please use one of dpkg-gencontrol or dpkg-distaddfile to add entries to it.\n\nSEE ALSO\n       dpkg-genchanges(1), dpkg-distaddfile(1).\n\n1.22.21                                                                                   2025-06-30                                                                          deb-src-files(5)","ref":"deb-src-files.html"},{"type":"extras","title":"deb-src-rules","doc":"deb-src-rules(5)                                                                          dpkg suite                                                                          deb-src-rules(5)\n\nNAME\n       deb-src-rules - Debian source package rules file\n\nSYNOPSIS\n       debian/rules\n\nDESCRIPTION\n       This file contains the instructions necessary to build the binary packages from the source package.\n\n       The debian/rules file is an executable Makefile, with a shebang that is usually set to \"#!/usr/bin/make -f\".\n\n       It must support the following make targets:\n\n       clean\n           Clean up the source tree, by undoing any change done by any of the build and binary targets.  This target will be called with root privileges.\n\n       build-indep\n           Build  architecture  independent  files  required  to build any architecture independent binary package.  If there are no architecture independent binary packages to generate, the\n           target must still exist but do nothing.  This target must not require root privileges.\n\n       build-arch\n           Build architecture dependent files required to build any architecture dependent binary package.  If there are no architecture dependent binary packages  to  generate,  the  target\n           must still exist but do nothing.  This target must not require root privileges.\n\n       build\n           Build  architecture independent and dependent files, either by depending (at least transitively) on build-indep and/or build-arch or by inlining what those targets would do.  This\n           target must not require root privileges.\n\n       binary-indep\n           Build architecture independent binary packages.  This target must depend (at least transitively) on either build-indep or build.  This target will be called with root privileges.\n\n       binary-arch\n           Build architecture dependent binary packages.  This target must depend (at least transitively) on either build-arch or build.  This target will be called with root privileges.\n\n       binary\n           Build architecture independent and dependent binary packages, either by depending (at least transitively) on binary-indep and/or binary-arch or  by  inlining  what  those  targets\n           would do.  This target will be called with root privileges.\n\nSEE ALSO\n       dpkg-architecture(1), dpkg-vendor(1), dpkg-buildflags(1), dpkg-parsechangelog(1), dpkg-shlibdeps(1), dpkg-gencontrol(1), dpkg-deb(1), dpkg-distaddfile(1).\n\n1.22.21                                                                                   2025-06-30                                                                          deb-src-rules(5)","ref":"deb-src-rules.html"},{"type":"extras","title":"deb-src-symbols","doc":"deb-src-symbols(5)                                                                        dpkg suite                                                                        deb-src-symbols(5)\n\nNAME\n       deb-src-symbols - Debian's extended shared library template file\n\nSYNOPSIS\n       debian/package.symbols.arch, debian/symbols.arch, debian/package.symbols, debian/symbols\n\nDESCRIPTION\n       The symbol file templates are shipped in Debian source packages, and its format is a superset of the symbols files shipped in binary packages, see deb-symbols(5).\n\n   Comments\n       Comments are supported in template symbol files.  Any line with ‘#’ as the first character is a comment except if it starts with ‘#include’ (see section \"Using includes\").  Lines\n       starting with ‘#MISSING:’ are special comments documenting symbols that have disappeared.\n\n   Using #PACKAGE# substitution\n       In some rare cases, the name of the library varies between architectures.  To avoid hardcoding the name of the package in the symbols file, you can use the marker #PACKAGE#.  It will\n       be replaced by the real package name during installation of the symbols files.  Contrary to the #MINVER# marker, #PACKAGE# will never appear in a symbols file inside a binary package.\n\n   Using symbol tags\n       Symbol tagging is useful for marking symbols that are special in some way.  Any symbol can have an arbitrary number of tags associated with it.  While all tags are parsed and stored,\n       only some of them are understood by dpkg-gensymbols and trigger special handling of the symbols.  See subsection \"Standard symbol tags\" for reference of these tags.\n\n       Tag specification comes right before the symbol name (no whitespace is allowed in between).  It always starts with an opening bracket (, ends with a closing bracket ) and must contain\n       at least one tag.  Multiple tags are separated by the | character.  Each tag can optionally have a value which is separated form the tag name by the = character.  Tag names and values\n       can be arbitrary strings except they cannot contain any of the special ) | = characters.  Symbol names following a tag specification can optionally be quoted with either ' or \"\n       characters to allow whitespaces in them.  However, if there are no tags specified for the symbol, quotes are treated as part of the symbol name which continues up until the first\n       space.\n\n         (tag1=i am marked|tag name with space)\"tagged quoted symbol\"@Base 1.0\n         (optional)tagged_unquoted_symbol@Base 1.0 1\n         untagged_symbol@Base 1.0\n\n       The first symbol in the example is named tagged quoted symbol and has two tags: tag1 with value i am marked and tag name with space that has no value.  The second symbol named\n       tagged_unquoted_symbol is only tagged with the tag named optional.  The last symbol is an example of the normal untagged symbol.\n\n       Since symbol tags are an extension of the deb-symbols(5) format, they can only be part of the symbols files used in source packages (those files should then be seen as templates used\n       to build the symbols files that are embedded in binary packages).  When dpkg-gensymbols is called without the -t option, it will output symbols files compatible to the deb-symbols(5)\n       format: it fully processes symbols according to the requirements of their standard tags and strips all tags from the output.  On the contrary, in template mode (-t) all symbols and\n       their tags (both standard and unknown ones) are kept in the output and are written in their original form as they were loaded.\n\n   Standard symbol tags\n       optional\n           A  symbol marked as optional can disappear from the library at any time and that will never cause dpkg-gensymbols to fail.  However, disappeared optional symbols will continuously\n           appear as MISSING in the diff in each new package revision.  This behavior serves as a reminder for the maintainer that such a symbol needs to be removed from the symbol  file  or\n           readded  to  the  library.  When the optional symbol, which was previously declared as MISSING, suddenly reappears in the next revision, it will be upgraded back to the “existing”\n           status with its minimum version unchanged.\n\n           This tag is useful for symbols which are private where their disappearance do not cause ABI breakage.  For example, most of C++ template instantiations fall  into  this  category.\n           Like any other tag, this one may also have an arbitrary value: it could be used to indicate why the symbol is considered optional.\n\n       arch=architecture-list\n       arch-bits=architecture-bits\n       arch-endian=architecture-endianness\n           These  tags  allow  one  to restrict the set of architectures where the symbol is supposed to exist.  The arch-bits and arch-endian tags are supported since dpkg 1.18.0.  When the\n           symbols list is updated with the symbols discovered in the library, all arch-specific symbols which do not concern the current host architecture are treated as  if  they  did  not\n           exist.   If  an  arch-specific  symbol  matching  the  current  host architecture does not exist in the library, normal procedures for missing symbols apply and it may cause dpkg-\n           gensymbols to fail.  On the other hand, if the arch-specific symbol is found when it was not supposed to exist (because the current host architecture is not listed in the  tag  or\n           does  not  match  the  endianness  and bits), it is made arch neutral (i.e. the arch, arch-bits and arch-endian tags are dropped and the symbol will appear in the diff due to this\n           change), but it is not considered as new.\n\n           When operating in the default non-template mode, among arch-specific symbols only those that match the current host architecture are written to the symbols file.  On the contrary,\n           all arch-specific symbols (including those from foreign arches) are always written to the symbol file when operating in template mode.\n\n           The format of architecture-list is the same as the one used in the Build-Depends field of debian/control (except the enclosing square brackets []).  For example, the first  symbol\n           from the list below will be considered only on arm64, any-amd64 and riscv64 architectures, the second only on linux architectures, while the third one anywhere except on armel.\n\n             (arch=arm64 any-amd64 riscv64)arch_specific_symbol@Base 1.0\n             (arch=linux-any)linux_specific_symbol@Base 1.0\n             (arch=!armel)symbol_armel_does_not_have@Base 1.0\n\n           The architecture-bits is either 32 or 64.\n\n             (arch-bits=32)32bit_specific_symbol@Base 1.0\n             (arch-bits=64)64bit_specific_symbol@Base 1.0\n\n           The architecture-endianness is either little or big.\n\n             (arch-endian=little)little_endian_specific_symbol@Base 1.0\n             (arch-endian=big)big_endian_specific_symbol@Base 1.0\n\n           Multiple restrictions can be chained.\n\n             (arch-bits=32|arch-endian=little)32bit_le_symbol@Base 1.0\n\n       allow-internal\n           dpkg-gensymbols has a list of internal symbols that should not appear in symbols files as they are usually only side-effects of implementation details of the toolchain (since dpkg\n           1.20.1).  If for some reason, you really want one of those symbols to be included in the symbols file, you should tag the symbol with allow-internal.  It can be necessary for some\n           low level toolchain libraries like “libgcc”.\n\n       ignore-blacklist\n           A deprecated alias for allow-internal (since dpkg 1.20.1, supported since dpkg 1.15.3).\n\n       c++ Denotes c++ symbol pattern.  See \"Using symbol patterns\" subsection below.\n\n       symver\n           Denotes symver (symbol version) symbol pattern.  See \"Using symbol patterns\" subsection below.\n\n       regex\n           Denotes regex symbol pattern.  See \"Using symbol patterns\" subsection below.\n\n   Using symbol patterns\n       Unlike  a  standard symbol specification, a pattern may cover multiple real symbols from the library.  dpkg-gensymbols will attempt to match each pattern against each real symbol that\n       does not have a specific symbol counterpart defined in the symbol file.  Whenever the first matching pattern  is  found,  all  its  tags  and  properties  will  be  used  as  a  basis\n       specification of the symbol.  If none of the patterns matches, the symbol will be considered as new.\n\n       A  pattern  is  considered  lost  if  it  does not match any symbol in the library.  By default this will trigger a dpkg-gensymbols failure under -c1 or higher level.  However, if the\n       failure is undesired, the pattern may be marked with the optional tag.  Then if the pattern does not match anything, it will only appear in the diff as MISSING.   Moreover,  like  any\n       symbol, the pattern may be limited to the specific architectures with the arch tag.  Please refer to \"Standard symbol tags\" subsection above for more information.\n\n       Patterns  are  an  extension  of  the  deb-symbols(5)  format  hence they are only valid in symbol file templates.  Pattern specification syntax is not any different from the one of a\n       specific symbol.  However, symbol name part of the specification serves as an expression to be matched against name@version  of  the  real  symbol.   In  order  to  distinguish  among\n       different pattern types, a pattern will typically be tagged with a special tag.\n\n       At the moment, dpkg-gensymbols supports three basic pattern types:\n\n       c++ This  pattern  is  denoted by the c++ tag.  It matches only C++ symbols by their demangled symbol name (as emitted by c++filt(1) utility).  This pattern is very handy for matching\n           symbols which mangled names might vary across different architectures while their demangled names remain the same.  One group of such symbols  is  non-virtual  thunks  which  have\n           architecture  specific  offsets  embedded in their mangled names.  A common instance of this case is a virtual destructor which under diamond inheritance needs a non-virtual thunk\n           symbol.  For example, even if _ZThn8_N3NSB6ClassDD1Ev@Base on 32-bit architectures will probably be _ZThn16_N3NSB6ClassDD1Ev@Base on 64-bit ones, it can be matched with  a  single\n           c++ pattern:\n\n            libdummy.so.1 libdummy1 #MINVER#\n             [...]\n             (c++)\"non-virtual thunk to NSB::ClassD::~ClassD()@Base\" 1.0\n             [...]\n\n           The demangled name above can be obtained by executing the following command:\n\n             $ echo '_ZThn8_N3NSB6ClassDD1Ev@Base' | c++filt\n\n           Please  note that while mangled name is unique in the library by definition, this is not necessarily true for demangled names.  A couple of distinct real symbols may have the same\n           demangled name.  For example, that's the case with non-virtual thunk symbols in complex inheritance configurations or with most constructors and destructors (since  g++  typically\n           generates two real symbols for them).  However, as these collisions happen on the ABI level, they should not degrade quality of the symbol file.\n\n       symver\n           This pattern is denoted by the symver tag.  Well maintained libraries have versioned symbols where each version corresponds to the upstream version where the symbol got added.  If\n           that's the case, you can use a symver pattern to match any symbol associated to the specific version.  For example:\n\n            libc.so.6 libc6 #MINVER#\n             (symver)GLIBC_2.0 2.0\n             [...]\n             (symver)GLIBC_2.7 2.7\n             access@GLIBC_2.0 2.2\