searchData={"items":[{"type":"extras","title":"Kaisen Linux | Documentation","doc":"# Kaisen Linux | Documentation\n> Kaisen Linux is a distribution for IT professional based on the Debian GNU/Linux distribution.   \n\nIt is a complete operating system whose originality is to provide a set of tools dedicated to system administration and covering all the needs for diagnosing and dealing with faults or failures of an installed system and its components. The most important system tools are available.   \n\nSince release 1.0 named, Kaisen Linux is a rolling release (continuous update) based on debian testing.","ref":"documentation.html"},{"type":"extras","title":"Quick start - Kaisen Linux | Documentation","doc":"1. Choose and download an iso :\n    - [Kaisen Linux KDE (default GUI)](https://iso.kaisenlinux.org/rolling/kaisenlinuxrolling3.0-amd64-KDE.iso)\n    - [Kaisen Linux MATE](https://iso.kaisenlinux.org/rolling/kaisenlinuxrolling3.0-amd64-MATE.iso)\n    - [Kaisen Linux XFCE](https://iso.kaisenlinux.org/rolling/kaisenlinuxrolling3.0-amd64-XFCE.iso)\n    - [Kaisen Linux LXQT](https://iso.kaisenlinux.org/rolling/kaisenlinuxrolling3.0-amd64-LXQT.iso)\n    - [Kaisen Linux System Rescue (no installer)](https://iso.kaisenlinux.org/rolling/kaisenlinuxrolling3.0-amd64-SR.iso)\n    - [Kaisen Linux NETINST (network required)](https://iso.kaisenlinux.org/rolling/kaisenlinuxrolling3.0-amd64-NETINST.iso)\n2. Launch it in a VM\n3. Boot on the live mode or install Kaisen Linux\n4. Explore and test sysadmin and technicians tools\n5. Read Kaisen Linux documentation or [Kaisen Linux manpages](https://kaisenlinux.org/manpages/) for help\n6. Join our [community forum](https://forum.kaisenlinux.org)\n7. Join our [Telegram group](https://t.me/kaisenlinux)\n8. Join our [Discord server](https://discord.gg/rCg6jjzPwj)","ref":"documentation.html#quick-start"},{"type":"extras","title":"Documentation guides - Kaisen Linux | Documentation","doc":"The documentation is splitted in 6 GUIDES on the left menu bar:\n- START\n- TOOLS & PACKAGES\n- INFOS\n- TUTORIALS\n- GOODIES\n- TIPS AND TRICKS","ref":"documentation.html#documentation-guides"},{"type":"extras","title":"Help Summary - Kaisen Linux | Documentation","doc":"- Start\n    - [Official Kaisen Linux links](links.html)\n    - [Why use Kaisen Linux?](why.html)\n    - [ISO informations](variant.html)\n    - [USB creation](usb.html)\n    - [Hardware requirements](hardware.html)\n    - [Live informations](live.html)\n    - [NETINST informations](netinst.html)\n    - [Install OS](install.html)\n    - [Using Virtualisation](virtualisation.html)\n    - [Menu and Tools overview](menu.html)\n- Tools and Packages\n    - [Tools](tools.html)\n    - [Packages](packages.html)\n    - [Metapackages](metapackages.html)\n- Infos\n    - [Kaisen Linux licence](licence.html)\n    - [Kaisen Linux downloads](download.html)\n    - [Kaisen Linux repositories](repo.html)\n    - [Kaisen Linux updates](update.html)\n- Tutorials\n    - [GNS3 Utilization](gns3-utilization.html)\n    - [Windows bootable USB key](windows-bootable-usb-key.html)\n    - [Bad sectors analyses](bad-sectors-analyses.html)\n    - [Repair GRUB](grub-repair.html)\n    - [Kaisen Terminal shortcuts](terminal-shortcuts.html)\n    - [Advanced BTRFS utilization](advanced-btrfs-utilization.html)\n    - [Create chroot](create-chroot.html)\n    - [Configure cryptsetup-nuke-password](configure-cryptsetup-nuke.html)\n    - [Virtualbox utilization](virtualbox-utilization.html)\n- Goodies\n    - [Conky theme](kaisen-conky.html)\n    - [LUKS hardening](cryptsetup-nuke-password.html)\n    - [ZSH](zsh.html)\n- TIPS AND TRICKS        \n    - [Where can I find more documentation?](where-can-i-find-more-documentation.html)\n    - [What are the revisions of the rolling version?](what-are-the-revisions-of-the-rolling-version.html)\n    - [Why are all additional services disabled by default?](why-are-all-additional-services-disabled-by-default.html)\n    - [How to build a custom ISO?](how-to-build-custom-iso.html)\n    - [Why no sources on some packages?](why-no-source-on-some-packages.html)\n    - [How to reapply the GUI default profile?](how-to-reapply-the-gui-default-profile.html)\n    - [Informations on the rolling version](informations-on-rolling-version.html)\n    - [Why root account is disabled by default?](why-root-account-is-disabled.html)\n    - [How to switch to root directly with the ZSH terminal?](how-to-switch-to-root-directly-with-zsh.html)\n    - [How to change the graphical interface?](how-to-change-graphical-interface.html)\n    - [How to update Kaisen Linux Rolling?](update-kaisen-linux-rolling.html)\n    - [How to change the login wallpaper?](how-to-change-login-wallpaper.html)\n    - [Why create user accounts only on /home?](why-create-user-accounts-only-on-home.html)\n    - [Why KDE installed with lightdm by default?](why-kde-installed-with-lightdm-by-default.html)\n    - [Where can I find documentation on the built-in tools or how certain settings work?](where-can-i-find-documentation-on-the-built-in-tools-or-how-certain-settings-work.html)","ref":"documentation.html#help-summary"},{"type":"extras","title":"Official Kaisen Linux links","doc":"# Official Kaisen Linux links\n\nThis section lists all existing official links for the project.    \n**If other links exist but are not referenced here, consider that they are not official.**","ref":"links.html"},{"type":"extras","title":"Official domains - Official Kaisen Linux links","doc":"- Website: https://kaisenlinux.org  \n- Blog: https://kaisenlinux.org/blog/  \n- Documentation: https://kaisenlinux.org/documentation/  \n- Manpages: https://kaisenlinux.org/manpages/","ref":"links.html#official-domains"},{"type":"extras","title":"Officials ISO downloads mirrors - Official Kaisen Linux links","doc":"- Official mirror: https://iso.kaisenlinux.org\n- Torrent mirror: https://torrent.kaisenlinux.org","ref":"links.html#officials-iso-downloads-mirrors"},{"type":"extras","title":"APT repositories - Official Kaisen Linux links","doc":"```bash\ndeb https://deb.kaisenlinux.org kaisen-rolling main contrib non-free non-free-firmware\ndeb https://deb.kaisenlinux.org kaisen-devel main contrib non-free non-free-firmware\ndeb https://deb.kaisenlinux.org kaisen-packages main contrib non-free non-free-firmware\ndeb https://deb.kaisenlinux.org kaisen-testing main contrib non-free non-free-firmware\ndeb-src https://deb.kaisenlinux.org kaisen-rolling main contrib non-free non-free-firmware\ndeb-src https://deb/kaisenlinux.org kaisen-devel main contrib non-free non-free-firmware\ndeb-src https://deb.kaisenlinux.org kaisen-packages main contrib non-free non-free-firmware\ndeb-src https://deb.kaisenlinux.org kaisen-testing main contrib non-free non-free-firmware\n```","ref":"links.html#apt-repositories"},{"type":"extras","title":"Social medias - Official Kaisen Linux links","doc":"- Twitter: https://twitter.com/kaisenlinux\n- LinkedIn: https://linkedin.com/company/kaisenlinux\n- Mastodon: https://mastodon.social/@kaisenlinux\n- Distrowatch: https://distrowatch.com/kaisen\n- Ko-Fi: https://ko-fi.com/kaisenlinux","ref":"links.html#social-medias"},{"type":"extras","title":"Distribution sources - Official Kaisen Linux links","doc":"- GitHub (alpha and beta versions): https://github.com/kevinchevreuil/kaisenlinux\n- GitLab (rolling version): https://gitlab.com/kaisenlinux\n- GitLab mirror GitHub (rolling version): https://github.com/kaisenlinux","ref":"links.html#distribution-sources"},{"type":"extras","title":"Feedback and discussions - Official Kaisen Linux links","doc":"- Forum: https://forum.kaisenlinux.org\n- Telegram: https://t.me/kaisenlinux\n- Discord: https://discord.gg/rCg6jjzPwj","ref":"links.html#feedback-and-discussions"},{"type":"extras","title":"Why use Kaisen Linux ?","doc":"# Why use Kaisen Linux ?","ref":"why.html"},{"type":"extras","title":"Kaisen Linux objective - Why use Kaisen Linux ?","doc":"Kaisen Linux aims to provide a comprehensive tool base for systems and network administrators, DevOps engineer, systems/network/security engineers etc, as well as to meet the needs of IT technicians with tools to perform many operations.\nIt was originally designed and built as a rescue system as its primary function, but finding it too \"classic and warmed up\", I decided to develop a wider and more extensive distribution than a \"simple\" rescue system with tools such as containerization, virtualization, diagnostic tools for network configurations and services such as DNS, etc.\nThis is why the slogan of distribution has gradually become \"The distribution for professional IT\". IT is a generic term widely used in France (the country of origin of Kaisen Linux) to designate technicians/administrators/systems and network engineers.\nI therefore combined tools intended for system and network administrators as well as technicians within the same distribution to meet the greatest number of needs. In small businesses, systems administrators are also computer technicians.\nThis allowed to extend the main function of system rescue, while providing diagnostic tools mainly for the network section.\nYou will find on this section, some arguments to distinguish it from other more or less similar projects.","ref":"why.html#kaisen-linux-objective"},{"type":"extras","title":"Base - Why use Kaisen Linux ?","doc":"Kaisen linux is based at Debian GNU/Linux (testing version) distribution. The system uses Debian packages, however custom packages follow the Debian model as much as possible and are tested before production to limit bugs. Kaisen Linux respects the FHS (File Hierarchy System) standard to remain as faithful as possible to this magnificent distribution that is Debian.","ref":"why.html#base"},{"type":"extras","title":"Designed for beginners - Why use Kaisen Linux ?","doc":"Kaisen Linux is designed to be as simple as possible, which is part of why the MATE KDE, LXDE and XFCE GUI were chosen and the menus are also expanded to list all the tools present by category and subcategory. This will surely facilitate access and management of distribution as well as integrated tools.","ref":"why.html#designed-for-beginners"},{"type":"extras","title":"Improved live system - Why use Kaisen Linux ?","doc":"Kaisen Linux offers a live system with several options such as persistence, RAM loading and forensic mode. Examples of usage and their purposes can be found in the Live informations section.","ref":"why.html#improved-live-system"},{"type":"extras","title":"Improved terminal - Why use Kaisen Linux ?","doc":"The terminal of Kaisen Linux is based on bash-completion and zsh and has been modified using many scripts to improve for example the auto-completion such as for example the correction of case errors, allows to navigate in the directories with the tab key, list the packages to install when ordering **apt-get install** and many others!","ref":"why.html#improved-terminal"},{"type":"extras","title":"Installable - Why use Kaisen Linux ?","doc":"Kaisen Linux has the functionality of being installed on a hard drive for daily use or to create machines dedicated to certain tasks that can be performed with Kaisen Linux. The installation is possible even in UEFI and certain tasks during the installation have been automated to facilitate the installation of the distribution, automate it a little, and customize the installation. The textual installation (reduced graphics) of classic Debian as well as the installation in graphical mode are incorporated to meet a maximum of tastes.","ref":"why.html#installable"},{"type":"extras","title":"Number of tools - Why use Kaisen Linux ?","doc":"Kaisen Linux has more than 300 built-in [tools](tools.html) for system administrators and also has full management of many file systems, such as tools for XFS, OCFS, F2FS, EXT, NTFS, Exfat, FAT and others, with maintenance tools of these integrated file systems! Many packages have been designed by ourselves for an integration of more specialized tools for administrators like for example automated snapshots when using APT for easy restoration of the initial state of the system in the event of a problem with a software upgrade or installation.","ref":"why.html#number-of-tools"},{"type":"extras","title":"Kernel custom - Why use Kaisen Linux ?","doc":"The Kaisen Linux kernel has been recompiled and optimized as much as possible to optimize the system, secure it and have the latest patches and hardware support. Today, the kernel integrated into Kaisen Linux allows support for the exfat file system, and thus improves the support of original Windows hardware for technicians such as, for example, external disks. The kernel sources and all the dependencies for recompiling them have been integrated into the system so that you can compile your own kernel, from the base of Kaisen Linux!","ref":"why.html#kernel-custom"},{"type":"extras","title":"Support - Why use Kaisen Linux ?","doc":"Kaisen Linux offers support for anyone and questions, today, this supports is present by mail and soon by a forum.","ref":"why.html#support"},{"type":"extras","title":"System free - Why use Kaisen Linux ?","doc":"Kaisen Linux is free and will stay!","ref":"why.html#system-free"},{"type":"extras","title":"Rolling updates - Why use Kaisen Linux ?","doc":"Since its release in stable version, Kaisen Linux is updated continuously, possible to our repository created for Kaisen Linux. This allows if you choose to install the system, to be able to update the whole system without having to reinstall it, it is an important stage of the project which will remove big constraints to the users concerning the maintenance of the system.  \nHowever, if you only use Kaisen Linux in live version, you will have to download the most up-to-date ISO if necessary, even if you do the updates on live, they will disappear on the next restart (USB persistence has its limits).  \nThis can quickly become binding, unfortunately there is no solution to this on the live system.  \nAs mentioned above, a [snapshot](advanced-btrfs-utilisation.html#apt-snapshots) system with APT is built in by default (if the system is installed on BTRFS), to make the system even more easily maintainable in the event of a problem with an upgrade.","ref":"why.html#rolling-updates"},{"type":"extras","title":"List of the differents ISO","doc":"# List and Explanation of the differents ISO","ref":"variant.html"},{"type":"extras","title":"MATE - List of the differents ISO","doc":"The name of the ISO ending with MATE (mentioned MATE on the download page), is an ISO with all tools integrated by default.  \nA live bootable system and an installer are integrated. This ISO does not require the Internet to be used live or to install, but updates may be available after installation.\nThis ISO is suitable for a majority of use cases.\n\n## KDE\nThe name of the ISO ending with KDE (mentioned KDE on the download page), is an ISO with all tools built in by default.  \nA live bootable system and an installer are integrated. This ISO does not require the Internet to be used live or to install, but updates may be available after installation.\nThis ISO is suitable for a majority of use cases.","ref":"variant.html#mate"},{"type":"extras","title":"LXQT - List of the differents ISO","doc":"The name of the ISO ending with LXQT (mentioned as LXQT on the download page), is an ISO with all tools built in by default.  \nA live bootable system and an installer are integrated. This ISO does not require the Internet to be used live or to install, but updates may be available after installation.\nThis ISO is suitable for a majority of use cases.","ref":"variant.html#lxqt"},{"type":"extras","title":"XFCE - List of the differents ISO","doc":"The name of the ISO ending with XFCE (mentioned XFCE on the download page), is an ISO with all tools integrated by default.  \nA live bootable system and an installer are integrated. This ISO does not require the Internet to be used live or to install, but updates may be available after installation.\nThis ISO is suitable for a majority of use cases.","ref":"variant.html#xfce"},{"type":"extras","title":"SR - List of the differents ISO","doc":"The name of the ISO ending with SR stands for System Rescue.  \nIt is a lightweight ISO, containing only maintenance tools. These tools are used to diagnose the various components of a computer as well as the operating systems. This configuration makes the system lighter and is recommended for less powerful computers.  \nThis ISO does not include an installer, it is only usable as a live system.  \nThe live system does not need the Internet to run.  \nXFCE is the default GUI used for the SR ISO.  \nBy default it is designed to boot without a GUI, however the GUI can be enabled with the startx command, if you need to use the GUI for some reason.","ref":"variant.html#sr"},{"type":"extras","title":"NETINST - List of the differents ISO","doc":"The name of the ISO ending with NETINST means NETINSTALLER.  \nThis ISO has no live systems and is present only to have an installer.  \nThis ISO requires the Internet in order to use all the features offered by the installer via the network.  \nThe difference between this installer and the one offered by the live ISO is that here you have the choice to install only a GUI a set of tools assembled and maintained to be installed on Kaisen Linux.  \nThis allows you to directly install an updated and much lighter system than what is provided by the various live systems, if you don't want to have the full set of tools provided in the lives.  \nThis ISO is reserved for an informed public and if you want to customize and have even more control over the distribution.  \nDetails on how the NETINST ISO works and what tools can be installed via this ISO can be found [here](netinst.html).","ref":"variant.html#netinst"},{"type":"extras","title":"USB creation","doc":"# How to USB creation","ref":"usb.html"},{"type":"extras","title":"Simple method and supported any system - USB creation","doc":"You can use the [balenaEtcher tool](https://www.balena.io/etcher/).\n\nThis tool is available on Windows, MacOS and GNU/Linux. The tool is graphical and extremely intuitive. It is a simple and efficient method to create a bootable USB stick for GNU/Linux system quickly.","ref":"usb.html#simple-method-and-supported-any-system"},{"type":"extras","title":"Method with CLI - USB creation","doc":"Suppose here that the command `sudo fdisk -l` tells us that our USB key is the device `sdb`.\n\n- So we will type this command:\n\n```bash\nsudo dd if=iso_path/iso_file.iso of=/dev/sdb bs=4M\n```\n\nAt the end of the process, you will have a bootable USB stick.","ref":"usb.html#method-with-cli"},{"type":"extras","title":"Other method or tools - USB creation","doc":"You can use other tools or methods to create your Kaisen Live bootable USB drive, however, note that the two methods mentioned above have been tested and approved by our team. Some problems have been reported to us following the use of Rufus, in particular for installation on certain configurations.","ref":"usb.html#other-method-or-tools"},{"type":"extras","title":"Create live USB key with persistence - USB creation","doc":"### **Prerequisite**  \n\nWARNING: A USB flash drive configured to support live persistent will not work with Apple hardware, probably due to their specific BIOS.\n\nWe recommend that you have at least a 64GB USB drive to take full advantage of this feature. \nCheck with the command `sudo fdisk -l` what your key is called. Here we will assume that our USB stick is `/dev/sdb`.\n\n### USB key with persistence creation\nThis documentation was made with ISO SR but also works with KDE, LXQT, MATE and XFCE.  \nMake sure you are in the same folder as the ISO to do all this!!! The dd command will erase your entire device, make sure you have backed up the important content.  \n\n- Create a bootable Kaisen USB drive with the following command:\n\n```bash\nsudo dd if=kaisenlinuxrolling3.0-amd64-SR.iso of=/dev/sdb bs=4M status=progress\n```\nNormally two partitions were created by dd. You can check this with the sudo fdisk -l command. You need to create a third to add persistence to it.\n\n- To do this, type the following commands (always in the same folder where the ISO is):\n\n```bash\nend=50GiB (if key is 64GiB, for security we will put the key ending at 50GiB plus the size of the ISO so 4GiB)\nread start _ <<< $(du -bcm kaisenlinuxrolling3.0-amd64-SR.iso | tail -1); echo $start\nsudo parted /dev/sdb mkpart primary ${start}MiB $end\n```\n\nYou should now have 3 partitions on your `/dev/sdb` device.\n\n- Then do this for create filesystems and partition label:  \nThe `mkfs.ext4` command below will ask a question (on the size of the blocks). Just press enter to use the default settings (not affected here).\n\n```bash\nsudo mkfs.ext4 -L persistence /dev/sdb3\nsudo e2label /dev/sdb3 persistence\n```\nTo take into account this new persistence partition, we should have a file named persistence.conf at the root of this partition with in this file marked: `/ union`\n\n- We are going to proceed like this:\n\n```bash\nsudo mkdir -p /mnt/persistence\nsudo mount /dev/sdb3 /mnt/persistence\necho \"/ union\" | sudo tee /mnt/persistence/persistence.conf\nsudo umount /mnt/persistence\n```\n\n**Your key is now ready!**\n\nRestart a live Kaisen with the persistence option enabled. To test that the persistence is functional, for example change the theme of the graphical interface then restart your live session by always choosing \"persistence\". If the theme you modified has been kept instead of the default one, the persistence is functional.\n\n## Create live USB key with encrypted persistence\n### **Prerequisite**\nWARNING: A USB flash drive configured to support live persistent will not work with Apple hardware, probably due to their specific BIOS.\n\nWe recommend that you have at least a 64GB USB drive to take full advantage of this feature. \nCheck with the command `sudo fdisk -l` what your key is called. Here we will assume that our USB stick is `/dev/sdb`.\n\n### USB key with encrypted persistence creation\nThis documentation was made with ISO SR but also works with KDE, LXQT, MATE and XFCE.  \nMake sure you are in the same folder as the ISO to do all this!!! The dd command will erase your entire device, make sure you have backed up the important content.  \n\n- Create a bootable Kaisen USB drive with the following command:\n\n```bash\nsudo dd if=kaisenlinuxrolling3.0-amd64-SR.iso of=/dev/sdb bs=4M status=progress\n```\n\nNormally two partitions were created by dd. You can check this with the `sudo fdisk -l` command. You need to create a third to add persistence to it.\n\n- To do this, type the following commands (always in the same folder where the ISO is):\n\n```bash\nend=50GiB (if key is 64GiB, for security we will put the key ending at 50GiB plus the size of the ISO so 4GiB)\nread start _ <<< $(du -bcm kaisenlinuxrolling3.0-amd64-SR.iso | tail -1); echo $start\nsudo parted /dev/sdb mkpart primary ${start}MiB $end\n```\n\nYou should now have 3 partitions on your `/dev/sdb` device.  \nWARNING: do not forget the passphrase to unlock the partition, otherwise you will have to completely redo your key and your data cannot be recovered. You have been warned.\n\n```bash\nsudo cryptsetup --verbose --verify-passphrase luksFormat /dev/sdb3\nsudo cryptsetup luksOpen /dev/sdb3 kaisen-usb-persistent\n```\n\nThen do this for create filesystems and partition label:\nThe `mkfs.ext4` command below will ask a question (on the size of the blocks). Just press enter to use the default settings (not affected here).\n\n```bash\nsudo mkfs.ext4 -L persistence /dev/mapper/kaisen-usb-persistent\nsudo e2label /dev/mapper/kaisen-usb-persistent persistence\n```\nTo take into account this new persistence partition, we should have a file named persistence.conf at the root of this partition with in this file marked: `/ union`\n\n- We are going to proceed like this:\n\n```bash\nsudo mkdir -p /mnt/kaisen-usb-persistent\nsudo mount /dev/mapper/kaisen-usb-persistent /mnt/kaisen-usb-persistent\necho \"/ union\" | sudo tee /mnt/kaisen-usb-persistent/persistence.conf\nsudo umount /dev/mapper/kaisen-usb-persistent\n```\n\n- Let's close the encrypted channel:\n\n```bash\nsudo cryptsetup luksClose /dev/mapper/kaisen-usb-persistent\n```\n**Your key is now ready!**\n\nRestart a live Kaisen with the encrypted persistence option enabled. To test that the persistence is functional, for example change the theme of the graphical interface then restart your live session by always choosing \"encrypted persistence\".  If the theme you modified has been kept instead of the default one, encrypted persistence is functional.  \nCaution, the keyboard will be in QWERTY.","ref":"usb.html#create-live-usb-key-with-persistence"},{"type":"extras","title":"Hardware requirements","doc":"# Hardware requirements\nHardware recommandations for using Kaisen Linux:\n\n**Kaisen Linux is only compatible with 64bit processors.**\n32-bit ISOs have never been produced by computers for over 10 years and support the amd64 architecture. Kaisen Linux being a distribution intended for IT professionals regardless of their activity, the chances of seeing a computer not supporting the amd64 architecture which is almost nil at present (except IT technicians for individuals with old hardware, but chances are slim anyway), that's why only 64-bit was produced.\n\nKaisen Linux uses 800Mb of RAM in live and installed version (on a physical machine, not on a VM) on MATE version, and uses 9GB of disk space in installed version.\n\nOn VM (on VMWare), between 700 and 800MB of RAM are consumed.","ref":"hardware.html"},{"type":"extras","title":"Minimal configuration - Hardware requirements","doc":"To use Kaisen Linux, you need at least the following configuration:\n\n```bash\nHard disk: 20Gb\nRAM: 2Gb\nProcessor:1 core @1.5GHz (AMD or Intel)\n```\n\nWith this configuration, you can start and use the system to do small operations like launching some tools in command line. This is not the recommended configuration, as you will be very limited.","ref":"hardware.html#minimal-configuration"},{"type":"extras","title":"Recommended configuration - Hardware requirements","doc":"To use Kaisen Linux comfortably, use at least this configuration:\n\n```bash\nHard disk: 30Gb\nRAM: 4Gb\nProcessor: 2 core @2GHz (AMD or Intel)\n```\n\nWith this configuration, you can comfortably use Kaisen Linux for your system / network administration tasks, do several internet searches simultaneously, etc.\n\n## Optimal configuration\nTo use Kaisen Linux optimally, at least use this configuration:\n\n```bash\nHard disk: 50Gb\nRAM: 8Gb\nProcessor: 4 core @2,5GHz (AMD or Intel)\n```\n\nWith this configuration, you can comfortably use Kaisen Linux for your system/network administration tasks, do several internet searches simultaneously, etc.\n\n## BIOS and UEFI\nKaisen Linux is 100% compatible with computers with a classic BIOS called LEGACY and a UEFI BIOS. The UEFI BIOS is different and more recent than its predecessor and allows disk support for more than 2TB and 255 primary partitions (unlike the LEGACY BIOS which only supported 4 maximum).  \nIf your computer is less than 10 years old, you have a 99% chance of having a UEFI BIOS.","ref":"hardware.html#recommended-configuration"},{"type":"extras","title":"Live informations","doc":"# Live informations","ref":"live.html"},{"type":"extras","title":"Default credentials - Live informations","doc":"- Login: kaisen\n- Password: kaisen","ref":"live.html#default-credentials"},{"type":"extras","title":"Live languages - Live informations","doc":"- You can using **French** with **azerty** keyboard. This language can be chosen by the entry **Kaisen Linux Rolling Live (Français)** => once you have started on your DVD or bootable USB key.\n- You can using **English** with **qwerty** (US disposition) keyboard. This language can be chosen by the entry **Kaisen Linux Rolling Live (English)** => once you have started on your DVD or bootable USB key.\n- You can using **Spain** with qwerty (Spain disposition) keyboard. This language can be chosen by the entry **Kaisen Linux Rolling Live (Espanol)** => once you have started on your DVD or bootable USB key.\n- You can using **Portugal** with qwerty (Portugal disposition). This language can be chosen by the entry **Kaisen Linux Rolling Live (Portugues)** => once you have started on your DVD or bootable USB key.\n- You can using **Italian** with qwerty (Italian disposition). This language can be chosen by the entry **Kaisen Linux Rolling Live (Italiano)** => once you have started on your DVD or bootable USB key.\n- You can using **Deutsch** with **qwertz** (Deutsch disposition). This language can be chosen by the entry **Kaisen Linux Rolling Live (Deutsche)** => once you have started on your DVD or bootable USB key.  \n\nIf your keyboard is neither azerty, qwerty or qwertz of the variants mentioned above, select the language on which to start the live and once on the live, in the terminal, type the command `setxkbmap your_keyboard`\nFor example, for the russian keyboard, the command will be `setxkbmap ru`","ref":"live.html#live-languages"},{"type":"extras","title":"Live options - Live informations","doc":"Kaisen Linux live has several options:\n\n- Default\n- Failsafe mode\n- Persistence\n- Encrypted persistence\n- Forensic mode\n- Charging in RAM\n- Charging in RAM (failsafe)\n- Charging in RAM (forensic)\n\n```bash\n*Default: Simple start in live mode without special options.\n*Failsafe mode: Repair mode and disables certain features such as multi-threading and direct access to RAM. \nFacilitates the detection of problems.\n*Persistence: Mode allowing to keep this data on different live sessions (by default, the live erases all the data of the session once the computer is shut down or restarted). CAUTION: This mode can only be used with a bootable USB key with a partition dedicated to persistence. More details in the section dedicated to the use of the persistent mode.\n*Encrypted persistence: Exactly the same function as persistence mode, with the only difference, the partition with persistent data will be secured using cryptsetup and luks.\n*Forensic mode: Mode allowing to start the system by bringing certain security there like deactivation of the assembly by default of the equipment connected in USB and the deactivation of graphics cards AMD and Nvidia. The swap \n(partition used by the system to compensate for a possible lack of RAM) is also disabled with this mode.\n*Charging in RAM: Mode allowing to fully load the squashfs in the RAM memory, allowing to use the live system without keeping the USB key connected. Useful for computers with few USB ports. 8Gb of RAM is recommended to use this mode. The system loaded in RAM consumes 3.5GB to 4GB.\n*Charging in RAM (failsafe): Allows like failsafe mode and loaded in RAM, to fully load the system in RAM memory and to deactivate multi-threading support as well as direct access to RAM memory.\n*Charging in RAM (forensic): This mode allows to load the whole system in RAM, but by activating the functionalities provided with the classic forensic mode.\n```\n\nAll these options are available on the six languages ​​provided for the live system.","ref":"live.html#live-options"},{"type":"extras","title":"Default mode - Live informations","doc":"This mode requires nothing more than typing the enter key on its keyboard to be used. Very useful mode for testing the system, as well as for performing some quick tasks such as disk formatting or disk performance analysis.\n\n### Failsafe mode\nThis mode is often used to diagnose problems related to its hardware or to deactivate the support of certain functions which can conflict with certain uses such as multi-threading, management of APM (Advanced Power Management) etc. Do not use this mode if you do not need it. Using it will not cause any problems on your machine or live system, but disables certain functions that may be useful.","ref":"live.html#default-mode"},{"type":"extras","title":"Forensic mode - Live informations","doc":"This mode allows you to start on a live system by deactivating additional graphics cards.\nAutomatic mounting of disks / partitions and swap are disabled. The purpose of this mode is to be able to more easily diagnose problems related to graphics cards (driver or screen problems related to faulty hardware) and to be able to more easily control the mounting of discs on the system. The automatic deactivation of device mounting makes it possible, for example, to limit the extent of damage that can be caused by malware. This feature is useful for performing disk and / or malware analysis on discs whose origin or content is potentially dangerous.","ref":"live.html#forensic-mode"},{"type":"extras","title":"Persistence mode - Live informations","doc":"This mode allows you to keep this data between each live session. However, this mode must be configured beforehand. Persistence mode makes it possible, among other things, to keep the modification of its graphic parameters (wallpaper, theme, policies, etc.), to keep the packages updated, to keep the data entered by the user, etc.","ref":"live.html#persistence-mode"},{"type":"extras","title":"Encrypted persistence - Live informations","doc":"This mode allows you to keep this data between each live session. However, this mode needs to be configured beforehand. The difference with the previous persistent mode, is that persistent data is encrypted, which increases the security, confidentiality and integrity of persistent data. This mode should be used as a priority and is recommended over normal persistent mode, for your safety.","ref":"live.html#encrypted-persistence"},{"type":"extras","title":"Charging in RAM - Live informations","doc":"This mode requires nothing more than typing the enter key on its keyboard to be used. Very useful mode to accelerate the speed of the live system on recent machines, because the system is fully loaded in RAM and therefore faster than a USB port. Useful also to save the USB ports of the machine in case there is not much to see one. Once this mode is used and you have access to the desktop, you can unplug the USB key and fully use the system.","ref":"live.html#charging-in-ram"},{"type":"extras","title":"Charging in RAM with failsafe mode - Live informations","doc":"This mode also allows you to fully load the system into RAM, but by disabling certain functions such as APM and SMP (like classic failsafe mode). Only use this mode if you have the utility and know why to use it. Using it will not cause any problems on your machine or live system, but disables certain functions that may be useful.","ref":"live.html#charging-in-ram-with-failsafe-mode"},{"type":"extras","title":"Charging in RAM with forensic mode - Live informations","doc":"The forensic mode allows you to automatically deactivate Nvidia graphics cards as well as AMD cards. Storage devices are not mounted automatically. This mode allows you to benefit from all the advantages of this mode while keeping a free USB port on your computer.","ref":"live.html#charging-in-ram-with-forensic-mode"},{"type":"extras","title":"Create live USB key with persistence - Live informations","doc":"### **Prerequisite**  \n\nWARNING: A USB flash drive configured to support live persistent will not work with Apple hardware, probably due to their specific BIOS.\n\nWe recommend that you have at least a 64GB USB drive to take full advantage of this feature. \nCheck with the command `sudo fdisk -l` what your key is called. Here we will assume that our USB stick is `/dev/sdb`.\n\n### USB key with persistence creation\nThis documentation was made with ISO SR but also works with KDE, LXQT, MATE and XFCE.  \nMake sure you are in the same folder as the ISO to do all this!!! The dd command will erase your entire device, make sure you have backed up the important content.  \n\n- Create a bootable Kaisen USB drive with the following command:\n\n```bash\nsudo dd if=kaisenlinuxrolling3.0-amd64-SR.iso of=/dev/sdb bs=4M status=progress\n```\nNormally two partitions were created by dd. You can check this with the sudo fdisk -l command. You need to create a third to add persistence to it.\n\n- To do this, type the following commands (always in the same folder where the ISO is):\n\n```bash\nend=50GiB (if key is 64GiB, for security we will put the key ending at 50GiB plus the size of the ISO so 4GiB)\nread start _ <<< $(du -bcm kaisenlinuxrolling3.0-amd64-SR.iso | tail -1); echo $start\nsudo parted /dev/sdb mkpart primary ${start}MiB $end\n```\n\nYou should now have 3 partitions on your `/dev/sdb` device.\n\n- Then do this for create filesystems and partition label:  \nThe `mkfs.ext4` command below will ask a question (on the size of the blocks). Just press enter to use the default settings (not affected here).\n\n```bash\nsudo mkfs.ext4 -L persistence /dev/sdb3\nsudo e2label /dev/sdb3 persistence\n```\nTo take into account this new persistence partition, we should have a file named persistence.conf at the root of this partition with in this file marked: `/ union`\n\n- We are going to proceed like this:\n\n```bash\nsudo mkdir -p /mnt/persistence\nsudo mount /dev/sdb3 /mnt/persistence\necho \"/ union\" | sudo tee /mnt/persistence/persistence.conf\nsudo umount /mnt/persistence\n```\n\n**Your key is now ready!**\n\nRestart a live Kaisen with the persistence option enabled. To test that the persistence is functional, for example change the theme of the graphical interface then restart your live session by always choosing \"persistence\". If the theme you modified has been kept instead of the default one, the persistence is functional.\n\n## Create live USB key with encrypted persistence\n### **Prerequisite**\nWARNING: A USB flash drive configured to support live persistent will not work with Apple hardware, probably due to their specific BIOS.\n\nWe recommend that you have at least a 64GB USB drive to take full advantage of this feature. \nCheck with the command `sudo fdisk -l` what your key is called. Here we will assume that our USB stick is `/dev/sdb`.\n\n### USB key with encrypted persistence creation\nThis documentation was made with ISO SR but also works with KDE, LXQT, MATE and XFCE.  \nMake sure you are in the same folder as the ISO to do all this!!! The dd command will erase your entire device, make sure you have backed up the important content.  \n\n- Create a bootable Kaisen USB drive with the following command:\n\n```bash\nsudo dd if=kaisenlinuxrolling3.0-amd64-SR.iso of=/dev/sdb bs=4M status=progress\n```\n\nNormally two partitions were created by dd. You can check this with the `sudo fdisk -l` command. You need to create a third to add persistence to it.\n\n- To do this, type the following commands (always in the same folder where the ISO is):\n\n```bash\nend=50GiB (if key is 64GiB, for security we will put the key ending at 50GiB plus the size of the ISO so 4GiB)\nread start _ <<< $(du -bcm kaisenlinuxrolling3.0-amd64-SR.iso | tail -1); echo $start\nsudo parted /dev/sdb mkpart primary ${start}MiB $end\n```\n\nYou should now have 3 partitions on your `/dev/sdb` device.  \nWARNING: do not forget the passphrase to unlock the partition, otherwise you will have to completely redo your key and your data cannot be recovered. You have been warned.\n\n```bash\nsudo cryptsetup --verbose --verify-passphrase luksFormat /dev/sdb3\nsudo cryptsetup luksOpen /dev/sdb3 kaisen-usb-persistent\n```\n\nThen do this for create filesystems and partition label:\nThe `mkfs.ext4` command below will ask a question (on the size of the blocks). Just press enter to use the default settings (not affected here).\n\n```bash\nsudo mkfs.ext4 -L persistence /dev/mapper/kaisen-usb-persistent\nsudo e2label /dev/mapper/kaisen-usb-persistent persistence\n```\nTo take into account this new persistence partition, we should have a file named persistence.conf at the root of this partition with in this file marked: `/ union`\n\n- We are going to proceed like this:\n\n```bash\nsudo mkdir -p /mnt/kaisen-usb-persistent\nsudo mount /dev/mapper/kaisen-usb-persistent /mnt/kaisen-usb-persistent\necho \"/ union\" | sudo tee /mnt/kaisen-usb-persistent/persistence.conf\nsudo umount /dev/mapper/kaisen-usb-persistent\n```\n\n- Let's close the encrypted channel:\n\n```bash\nsudo cryptsetup luksClose /dev/mapper/kaisen-usb-persistent\n```\n**Your key is now ready!**\n\nRestart a live Kaisen with the encrypted persistence option enabled. To test that the persistence is functional, for example change the theme of the graphical interface then restart your live session by always choosing \"encrypted persistence\".  If the theme you modified has been kept instead of the default one, encrypted persistence is functional.  \nCaution, the keyboard will be in QWERTY.","ref":"live.html#create-live-usb-key-with-persistence"},{"type":"extras","title":"NETINST informations","doc":"# Installation with NETINST ISO","ref":"netinst.html"},{"type":"extras","title":"Prerequisites - NETINST informations","doc":"Internet is mandatory for the installation via ISO netinst. Even if the system can be installed without internet, you will have a limited and certainly not fully functional installation.\n\n## Modes\nGraphical install: Graphical installer with mouse support.  \nInstall: Semi-graphic installer, comparable to a ncurses interface.    \n\nIn the **advanced options** menu:  \n\nThe **rescue mode** allows you to install the system in recovery mode in the event of a problem with an initial installation or in normal mode, he will suggest the use of a shell.You will usually never have to use it, but if necessary, it can surely help you and solve your problems.  \n\nThe **expert mode** will allow you to install your system and customize it even more than with normal mode. It will allow you for example to precisely choose the keyboard model that suits you, for example if you have a particular layout. It also allows you to select certain modules to load from the installation media. Be careful what you do, however. Forgetting an important module could compromise your installation and/or make it unstable.  \n\nYou will understand, it is a mode made to personalize its installation as well as possible, but can also be difficult to take in hand for a beginner. Use this mode only if you really know what you are doing.  \nNote however that the preseed file and its configurations are taken into account in this mode.  \n\nIn the most classic cases, the normal mode will be more than enough.  \n\nThe **automated install** mode is not officially supported on Kaisen, it is present because it is provided by default by the installer but the automated installation is disabled.","ref":"netinst.html#prerequisites"},{"type":"extras","title":"How the netinst installer works - NETINST informations","doc":"The basic system will be installed after the internet has been configured.  \nThen the tasksel software will be launched. This software will allow you to install a series of software of your choice in the form of a menu. This predefined set of proposed software are the packages and metapackages developed for Kaisen Linux.  \n\nHere is this menu:  \n\n4 graphic interfaces are currently proposed.\n```\n- MATE\n- KDE\n- XFCE\n- LXQT\n```\nYou must choose one of the 4. It is possible, but not recommended to install two or more simultaneously.  \nIf you want to change the GUI, you will have to use the kaisen-interface-switcher script.  \n\nNetwork tools:    \n\nThe entry **Install all network tools** will install this [metapackage](metapackages.html#kaisen-network-tools). Select this option if you want to install all network tools. This will avoid selecting all categories of network metapackages.  \nThe entry **Install only ethernet tools** will install only these [tools](tools.html#ethernet)  \nThe entry **Install only GNS3 tools** will install only these [tools](tools.html#gns3)  \nThe entry **Install only OSI layer 2 tools** will install only these [tools](tools.html#mac)  \nThe entry **Install only OSI layer 3 tools** will install only these [tools](tools.html#ip)  \nThe entry **Install only OSI layer 4 tools** will install only these [tools](tools.html#tcp-udp)  \nThe entry **Install only network monitoring tools** will install only these [tools](tools.html#monitoring)  \nThe entry **Install only network PCAP tools** will install only these [tools](tools.html#pcap)  \nThe entry **Install only console port tools** will install only these [tools](tools.html#console-port)  \nThe entry **Install only network scanners tools** will install only these [tools](tools.html#network-scanners)  \nThe entry **Install only VPN clients** will install only these [tools](tools.html#vpn)  \nThe entry **Install only Wi-Fi tools** will install only these [tools](tools.html#wi-fi)  \nThe entry **Install only network miscellaneous** will install only these [tools](tools.html#various-network-administrators-tools)  \n\nSysadmin tools:    \n\nThe entry **Install all sysadmin tools** will install this [metapackage](metapackages.html#kaisen-sysadmin-tools). Select this option if you want to install all sysadmin tools. This will avoid selecting all categories of sysadmin metapackages.  \nThe entry **Install only backup tools** will install only these [tools](tools.html#backup-tools)   \nThe entry **Install only DHCP tools** will install only these [tools](tools.html#dhcp)  \nThe entry **Install only DNS tools** will install only these [tools](tools.html#dns)  \nThe entry **Install only FTP clients** will install only these [tools](tools.html#ftp)  \nThe entry **Install only Microsoft AD analyze** will install only these [tools](tools.html#microsoft)  \nThe entry **Install only remote administration tools** will install only these [tools](tools.html#remote-administration)  \nThe entry **Install only SSL/TLS tools** will install only these [tools](tools.html#ssl-tls)  \nThe entry **Install only virtualization tools** will install only these [tools](tools.html#virtualization)  \nThe entry **Install only firewalling tools** will install only these [tools](tools.html#firewalling)  \nThe entry **Install only AppArmor profiles and tools** will install only these [tools](tools.html#apparmor-tools-and-profiles)  \nThe entry **Install only databases clients tools** will install only these [tools](tools.html#databases-clients)  \nThe entry **Install only sysadmin miscellaneous tools** will install only these [tools](tools.html#various-system-administrators-tools)  \n\nTechnicians tools:  \n\nThe entry **Install all technicians tools** will install this [metapackage](metapackages.html#kaisen-technicians-tools). Select this option if you want to install all technicians tools. This will avoid selecting all categories of technicians metapackages.  \nThe entry **Install only partitioning and erasing tools** will install only these [tools](tools.html#partitioning-and-delete-tools)  \nThe entry **Install only password tools** will install only these [tools](tools.html#password-tools)  \nThe entry **Install only PST tools** will install only these [tools](tools.html#outlook-pst)  \nThe entry **Install only temperature tools** will install only these [tools](tools.html#temperature-analysis)  \nThe entry **Install only make bootable USB tools** will install only these [tools](tools.html#usb-boot)  \nThe entry **Install only virus analysis tools** will install only these [tools](tools.html#virus-analysis)  \nThe entry **Install only cloning tools** will install only these [tools](tools.html#cloning)  \nThe entry **Install only data protection tools** will install only these [tools](tools.html#data-protection)  \nThe entry **Install only data recovery tools** will install only these [tools](tools.html#data-recovery)  \nThe entry **Install only disks analysis tools** will install only these [tools](tools.html#disks-analysis)  \nThe entry **Install only hardware tools** will install only these [tools](tools.html#hardware)  \n\nThe entry **Install DevOps and Cloud tools** will install only these [tools](tools.html#sysops-tools)  \n\nThe entry **Install miscellaneous tools** will install only these [tools](tools.html#miscellaneous-tools)  \n\nThe entry **Install scripts and the menu services** will install only [this](menu.html#services). You should install this to more easily manage the pre-installed services, via automated scripts, if you don't install it, it won't affect the use of Kaisen.  \n\nThe entry **Install the kaisen-update command** will install only these [tools](packages.html#kaisen-update)  \n\nThe entry **Adding more filesystems support** will install only these [tools](tools.html#filesystems-tools) You should combine this metapackage with tools for technicians, e.g. disk analysis tools, file system mounting. This will give you more software support.  \n\nThe entry **Adding more firmwares support** will install only these [tools](tools.html#integrated-firmwares). You will probably not need to install so many drivers on your installation.  \nThey are installed by default on lives in order to extend hardware support to as many computers as possible. If you don't know which driver to install to get wifi, video driver or anything else, installing this metapackage will solve this problem. Do not install it if you only want to install what is necessary for your computer.  \n\nThe entry **Install offline manpages** will install only this [tool](packages.html#kaisen-manpages)  \n\nThe entry **Install offline documentation** will install only this [tool](packages.html#kaisen-documentation)\n\nThe entry **Install Conky** will install only this [tool](packages.html#kaisen-conky)\n\nThe entry **Install Exegol and its documentation** will install only this [tool](tools.html#exegol)","ref":"netinst.html#how-the-netinst-installer-works"},{"type":"extras","title":"Install OS","doc":"# Install with lives ISO","ref":"install.html"},{"type":"extras","title":"Prerequisites - Install OS","doc":"No need to have internet for installation via ISO lives.","ref":"install.html#prerequisites"},{"type":"extras","title":"Modes - Install OS","doc":"```bash\nKaisen Linux Install (Text mode)\nKaisen Linux Graphical Install (GUI mode)\nKaisen Linux Rescue Install (Text mode)\nKaisen Linux Rescue Install (GUI mode)\nKaisen Linux Expert Install (Text mode)\nKaisen Linux Expert Install (GUI mode)\n```\n\nInstallation in text mode, not on the command line, but in reality semi-graphic.  \nThe GUI mode corresponds to the complete support of the graphic mode, with the support of the mouse and a graphical interface a little more advanced than the text mode.","ref":"install.html#modes"},{"type":"extras","title":"Description - Install OS","doc":"So we have 3 different installation modes:  \n- Normal\n- Rescue\n- Expert\n\nThe **normal mode** simply corresponds to the classic process as it is configured in Kaisen Linux thanks to the preseed file (details in the next section).  \n\nThe **rescue mode** allows you to install the system in recovery mode in the event of a problem with an initial installation or in normal mode, he will suggest the use of a shell.. You will usually never have to use it, but if necessary, it can surely help you and solve your problems.  \n\nThe **expert mode** will allow you to install your system and customize it even more than with normal mode. It will allow you for example to precisely choose the keyboard model that suits you, for example if you have a particular layout. It also allows you to select certain modules to load from the installation media. Be careful what you do, however. Forgetting an important module could compromise your installation and/or make it unstable.  \n\nYou will understand, it is a mode made to personalize its installation as well as possible, but can also be difficult to take in hand for a beginner. Use this mode only if you really know what you are doing.  \nNote however that the preseed file and its configurations are taken into account in this mode.  \n\nIn the most classic cases, the normal mode will be more than enough.","ref":"install.html#description"},{"type":"extras","title":"Recommendations - Install OS","doc":"","ref":"install.html#recommendations"},{"type":"extras","title":"Installation recommendations - Install OS","doc":"To install the system, nothing could be simpler!  \nYou just need to follow the requested steps, and wait for the process to finish.  \nI will not detail here the installation process in rescue or expert mode (these modes are reserved for advanced users), but only what the installer does.  \nHere are the steps you will have to follow:  \n1. Select the language of the installer, the system and the keyboard\n2. Select your hostname\n3. Create your user and user password (you have to put password)\n4. After it will ask you to partition your disk. For less advanced users, select assisted partitioning and put the whole system in a single partition\n5. The system will then install\n6. If you are in UEFI mode, which will surely happen on your current machines, once the installation is complete, the GRUB will automatically install in the right place and the PC will restart with your system ready for use.","ref":"install.html#installation-recommendations"},{"type":"extras","title":"Partitioning recommendations - Install OS","doc":"On disks below 70Gb, if you use assisted partitioning on the installer do not ask to separate the partitions /home, /var and /tmp.  \nThe system will leave little space on the / and can be problematic.  \nHere is the cause of the problem and how to fix it:  \n\nIndeed, the root system, the / must have at least 15GB of space to be able to install the whole system. Below 70Gb, the / will be too small in size and the system unstable or may crash during installation due to lack of space to continue the operation.  \n\nHowever, you will still be able to partition your disks yourself, use LVM, and encryption.  \n\nBut no matter which assisted partitioning mode you use, on small disks do not use partitioning with the 3 partitions mentioned above, you will have problems.  \n\nI advise you to partition yourself by taking into account this constraint on the /.  \n\nI also advise you to manage the partitioning of the disk yourself or to use LVM to facilitate the repartitioning of your disks in the future.","ref":"install.html#partitioning-recommendations"},{"type":"extras","title":"Recommendations on filesystems - Install OS","doc":"Kaisen Linux uses the BTRFS file system by default on automatic partitioning because a [snapshot](advanced-btrfs-utilisation.html) feature has been integrated by default and allows you to take snapshots of your system.  \nIf you are installing Kaisen Linux through manual partitioning, we recommend that you use BTRFS on all your partitions in order to take full advantage of the features offered by Kaisen Linux.  \nYou should also leave the default mountpoints options provided with the BTRFS file system selection, these options are optimized for BTRFS and for Kaisen Linux.","ref":"install.html#recommendations-on-filesystems"},{"type":"extras","title":"Installation in BTRFS - Install OS","doc":"When BTRFS is used for the / partition, the tools in the [kaisen-btrfs-snapshots](tools.html#system-snapshots) metapackage are installed by default when NETINST is used, or retained via installation from a live installer. This allows the user to install these tools only if his system configuration allows system snapshot.  \n\n## Example of preseed file\nThe preseed file is a file used by the Debian installer (the default one is contained in the initrd generated by the installer, modifying it can completely alter the installer and make it absolutely unusable, even if it can be spotted without too many problems , avoid going that far).  \nIt is for this reason, that we integrate during the construction of the ISO a file of preseed personalized to personalize the installer, so that to modify and rework it is much simpler than to regenerate all the package managing the preseed by defect and will avoid many problems and hours of galleys.  \nIf we integrate a preseed file, it will be taken into account instead of the one provided by default.  \nHere are the configurations of the preseed file used to customize the Kaisen Linux installer:\n\n```bash\n#Default repository information (don't include codename data, d-i figures it out from what's available in the ISO)\nd-i mirror/protocol string https\nd-i mirror/https/countries string FR\nd-i mirror/https/hostname string deb.kaisenlinux.org\nd-i mirror/https/mirror string deb.kaisenlinux.org\nd-i mirror/https/directory string /\nd-i mirror/suite string kaisen-rolling\nd-i mirror/udeb/suite string kaisen-rolling\n\n#Force define kaisenlinux as default hostname (priority on DHCP)\nd-i netcfg/hostname string kaisenlinux\nd-i netcfg/get_hostname string kaisenlinux\nd-i netcfg/get_hostname seen false\n\n#Disable missing firmware message during network configuration\nd-i hw-detect/load_firmware boolean false\n\n#Disable security, updates and backports\nd-i apt-setup/services-select multiselect\n\n#Enable contrib, non-free and non-free-firmware\nd-i apt-setup/non-free-firmware boolean true\nd-i apt-setup/non-free boolean true\nd-i apt-setup/contrib boolean true\n\n#Disable CDROM entries after install\nd-i apt-setup/disable-cdrom-entries boolean true\n\n#Include packages in the base system\nd-i base-installer/includes string bash-completion zsh ca-certificates kaisen-archive-keyring\n\n#Upgrade installed packages (debootstrap)\nd-i pkgsel/upgrade select full-upgrade\n\n#Disable question about automatic security updates\nd-i pkgsel/update-policy select none\n\n#Disable popularity-contest\npopularity-contest popularity-contest/participate boolean false\n\n#Disable question about extra media\nd-i apt-setup/cdrom/set-first boolean false\n\n#Install default linux-image-amd64 kernel metapackage\nd-i base-installer/kernel/image string linux-image-amd64\n\n#Do not ask to create a root password to force the creation of a user with reduced privileges\nd-i passwd/root-login boolean false\n\n#Controls whether or not the hardware clock is set to UTC.\nd-i clock-setup/utc boolean false\n\n#Controls whether to use NTP to set the clock during the install\nd-i clock-setup/ntp boolean true\n\n#NTP server to use\nd-i clock-setup/ntp-server string 0.debian.pool.ntp.org\n\n#Automatically enable force UEFI installation\nd-i partman-efi/non_efi_system boolean true\n\n#Define default filesystem\nd-i partman/default_filesystem string btrfs\n\n#Do not activate volume wipe during encryption\nd-i partman-auto-crypto/erase_disks boolean false\n\n#Disable warning when no swap partition was created\nd-i partman-basicfilesystems/no_swap boolean false\n\n#Activate eatmydata to reduce space disk used and download simple-cdd profiles\nd-i preseed/early_command string anna-install eatmydata-udeb simple-cdd-profiles\n\n#Select kaisen profile\nsimple-cdd simple-cdd/profiles multiselect kaisen\n\n#Automatically use APT mirror\nd-i apt-setup/use_mirror boolean true\n\n#Force the ejection of the CDROM after the installation\nd-i cdrom-detect/eject boolean true\n\n#Delete the message at end installation and automatic reboot after finish install\nd-i finish-install/reboot_in_progress note\n\n#Execute at command after system installation\n#d-i preseed/late_command string in-target sh -c ''\n\n#Packages configurations\niptables-persistent iptables-persistent/autosave_v4 boolean false\niptables-persistent iptables-persistent/autosave_v6 boolean false\nwireshark-common wireshark-common/install-setuid boolean false\nkrb5-config krb5-config/default_realm string\nkrb5-config krb5-config/kerberos_servers string\nkrb5-config krb5-config/admin_server string\nmacchanger macchanger/automatically_run boolean false\nvirtualbox-ext-pack virtualbox-ext-pack/license boolean true\niperf3 iperf3/start_daemon boolean false\nencfs encfs/security-information boolean true\nencfs encfs/security-information seen true\nzfs-dkms zfs-dkms/note-incompatible-licenses boolean true\nzfs-dkms zfs-dkms/note-incompatible-licenses seen true\n```  \n\nIt is thanks to this file that the Debian installer is customized and for this reason that certain processes, such as password request for root, network configuration and others do not exist on the ISO. The purpose of this file is to automate certain tasks (we can completely automate the installation using this file), as well as to customize the installer according to our needs.  \nThe choice not to leave to the installer, the choice to create a password for root is because using the default root account is highly discouraged as well as the custom terminal, although available on root by typing zsh in the terminal (bash was left by default to allow chroot), is by default available for users without privileges.","ref":"install.html#installation-in-btrfs"},{"type":"extras","title":"Using Virtualization","doc":"# Virtualisation\n\nIn a nutshell, here's how to virtualize Kaisen Linux.  \nWe assume here that you know what a hypervisor is, as well as creating a virtual machine.  \nWe recommends to use VirtualBox, VMWare Workstation or QEMU/KVM hypervisors.  \nThe VMWare, Virtualbox and QEMU/KVM guests daemons are activated by default when Kaisen Linux is executed in them.","ref":"virtualization.html"},{"type":"extras","title":"VirtualBox - Using Virtualization","doc":"You can virtualize Kaisen Linux with VirtualBox hypervisor.  \nFollowing this step:","ref":"virtualization.html#virtualbox"},{"type":"extras","title":"Minimal Configuration - Using Virtualization","doc":"```bash\n1)  New virtual machine\n2)  Name: Your choice\n3)  Folder: Your choice\n4)  Type: Linux\n5)  System: Debian 10 (64 bits)\n6)  RAM: 1Go\n7)  Create Virtual Disk\n8)  Disk type : VDI (or VMDK)\n9)  Dynamic allocated\n10) Hard Drive: 10Go\n11) Click at : Configuration => Network => Adapter1\n12) Network configuration: NAT, Bridge, Host-only, NAT network, or not (the installer not using network and all tools are included) (optional parameter)\n13) System => Processor => CPU: 1 core\n14) You can use EFI (optional parameter)\n15) Leave the other default settings (except if you have specific needs)\n```","ref":"virtualization.html#minimal-configuration"},{"type":"extras","title":"Recommend configuration - Using Virtualization","doc":"```bash\n1)  New virtual machine\n2)  Name: Your choice\n3)  Folder: Your choice\n4)  Type: Linux\n5)  System: Debian 10 (64 bits)\n6)  RAM: 4Go\n7)  Create Virtual Disk\n8)  Disk type : VDI (or VMDK)\n9)  Dynamic allocated\n10) Hard Drive: 30Go\n11) Click at : Configuration => Network => Adapter1\n12) Network configuration: NAT, Bridge, Host-only, NAT network, or not (the installer not using network and all tools are included) (optional parameter)\n13) System => Processor => CPU: 2 core\n14) You can use EFI (optional parameter)\n15) Leave the other default settings (except if you have specific needs)\n```","ref":"virtualization.html#recommend-configuration"},{"type":"extras","title":"Install guest additions from a host system other than Kaisen Linux - Using Virtualization","doc":"To install the VirtualBox Guest Additions from a host system other than Kaisen Linux, you must use the Guest Additions ISO provided by Oracle which can be downloaded here: https://download.virtualbox.org/virtualbox/6.1.34/VBoxGuestAdditions_6.1.34.iso (Version 6.1.34 is the latest version as of this writing).\nOnce the CD is inserted into the VM, run these commands:\n```bash\nsudo mkdir /tmp/vboxguests\nsudo cp -rf /media/cdrom0/* /tmp/vboxguests\nsudo /tmp/vboxguests/autorun.sh\n```\nLet the process complete and follow the given steps.\nOnce all this is done, you must restart the VM and you will be able to enjoy the full guest additions installed on the VM!","ref":"virtualization.html#install-guest-additions-from-a-host-system-other-than-kaisen-linux"},{"type":"extras","title":"Install guest additions from a Kaisen Linux system host - Using Virtualization","doc":"To install the VirtualBox Guest Additions from a Kaisen Linux system host, you can find the ISO of guest additions here: **/usr/share/virtualbox/VBoxGuestAdditions.iso**\nOnce the CD is inserted into the VM, run these commands:\n```bash\nsudo mkdir /tmp/vboxguests\nsudo cp -rf /media/cdrom0/* /tmp/vboxguests\nsudo /tmp/vboxguests/autorun.sh\n```\nLet the process complete and follow the given steps.\nOnce all this is done, you must restart the VM and you will be able to enjoy the full guest additions installed on the VM!","ref":"virtualization.html#install-guest-additions-from-a-kaisen-linux-system-host"},{"type":"extras","title":"VMWare Workstation - Using Virtualization","doc":"You can virtualize Kaisen Linux with VMWare Workstation hypervisor.\nFollowing this step:","ref":"virtualization.html#vmware-workstation"},{"type":"extras","title":"Minimal configuration - Using Virtualization","doc":"```bash\n1)  New Vitual Machine\n2)  Typical\n3)  Use ISO image (select your ISO with browse button)\n4)  Guest Operating System: Debian 10 64 bits\n5)  Name: Your choice\n6)  Location: Your choice\n7)  Disk Size: 10Go\n8)  Select: \"Store virtual disk as a single file\"\n9)  Select: \"Customize hardware\"\n10) RAM: 1Go\n11) CPU: 1 core and 1 CPU\n12) Network: NAT, Bridge, LAN segment, Host-Only or not (the installer not using network and all tools are included) (optional parameter)\n13) Leave the other default settings (except if you have specific needs)\n14) Click in: Finish\n15) For activate UEFI: Shutdown VM and click at => \"Edit virtual machine settings\" => Options => Advanced => UEFI\n```","ref":"virtualization.html#minimal-configuration-1"},{"type":"extras","title":"Recommend configuration - Using Virtualization","doc":"```bash\n1)  New Vitual Machine\n2)  Typical\n3)  Use ISO image (select your ISO with browse button)\n4)  Guest Operating System: Debian 10 64 bits\n5)  Name: Your choice\n6)  Location: Your choice\n7)  Disk Size: 30Go\n8)  Select: \"Store virtual disk as a single file\"\n9)  Select: \"Customize hardware\"\n10) RAM: 4Go\n11) CPU: 2 core and 1 CPU\n12) Network: NAT, Bridge, LAN segment, Host-Only or not (the installer not using network and all tools are included) (optional parameter)\n13) Leave the other default settings (except if you have specific needs)\n14) Click in: Finish\n15) For activate UEFI: Shutdown VM and click at => \"Edit virtual machine settings\" => Options => Advanced => UEFI\n```","ref":"virtualization.html#recommend-configuration-1"},{"type":"extras","title":"Informations for QEMU/KVM - Using Virtualization","doc":"","ref":"virtualization.html#informations-for-qemu-kvm"},{"type":"extras","title":"Tools and daemons - Using Virtualization","doc":"To facilitate the creation of a virtualized virtual machine with QEMU/KVM, all virtual machines can be created through virt-manager. Full support for different agents like QEMU agent, SPICE, are integrated by default but disabled.  \nSPICE agents allow you to activate the shared clipboard, put the virtual machine in full screen when viewing it via the console. This is the equivalent of the virtualbox and vmware agents.  \nSPICE agents are managed by a systemd service.  \nThe integrated services are named **spice-vdagent** as well as **spice-webdavd**.\nThe **spice-vdagent** daemon allows you to enable copy and paste as well as to adjust the resolution of the virtual machine screen in relation to the resolution of the host. This daemon is useful for guest guests (using a graphical interface).  \nThe **spice-webdavd** daemon is used to support file sharing between the host and the virtual machine.","ref":"virtualization.html#tools-and-daemons"},{"type":"extras","title":"Menu and Tools overview","doc":"# Menu and tools overview","ref":"menu.html"},{"type":"extras","title":"Role of the applications menu - Menu and Tools overview","doc":"The application menu on Kaisen Linux is custom built and categorized and is updated very often. The main reason for this menu so big and consequent is to be able to indicate to the user which tools are at its disposal classified by category.","ref":"menu.html#role-of-the-applications-menu"},{"type":"extras","title":"Launchers - Menu and Tools overview","doc":"","ref":"menu.html#launchers"},{"type":"extras","title":"Graphical applications - Menu and Tools overview","doc":"Some launchers like Gparted or Wireshark are launchers for graphical applications and these tools can be launched directly via the menu, if root rights are required, the session password will be requested (by sudo) and will open the software directly as root as if it were run as root from the terminal.","ref":"menu.html#graphical-applications"},{"type":"extras","title":"CLI applications - Menu and Tools overview","doc":"The CLI (Command Line Interface, therefore launching with the terminal) launchers have for a very large majority a different behavior. Since the overwhelming majority of command line tools have multiple options and user parameters (e.g. ls with ls -a ls -l etc ...), it is too complicated to make a launcher by option offered by the software. The software therefore returns a man page or a help page to indicate how the tool is used.","ref":"menu.html#cli-applications"},{"type":"extras","title":"Icons next to the launchers - Menu and Tools overview","doc":"The icons next to launchers (applications) also have their meaning. Each graphic tool has its icon as its logo. The launchers of applications that can be used on the terminal have a terminal as their icon. This is to indicate to the user that this is a command line tool or a graphical tool.  \n\nIn the context of veracrypt for example, the command line executable as well as the graphical executable are integrated by default. So there is a launcher for the graphical launcher and a launcher for command line use.","ref":"menu.html#icons-next-to-the-launchers"},{"type":"extras","title":"Layout - Menu and Tools overview","doc":"The applications menu consists of two menus:","ref":"menu.html#layout"},{"type":"extras","title":"User applications - Menu and Tools overview","doc":"The user applications menu is the default menu in this category. It is in this menu and all these sub-menus (Internet, Office, Development, etc.) that all the graphical application launchers that you will install via a package will put. Some software integrated by default in Kaisen Linux like VLC, LibreOffice, Qbittorrent, Firefox, and VScodium to name a few, are however stored in this menu, creating a specific category in the Kaisen Linux menu was not useful in my opinion. , and would have overloaded this menu for nothing.","ref":"menu.html#user-applications"},{"type":"extras","title":"Kaisen Linux - Menu and Tools overview","doc":"It is in this menu where all the launchers of the software integrated in Kaisen Linux for the administration of systems and networks and tools for troobleshooting of all kinds are stored. This menu is updated very often to add launchers when there are new tools, improve the services menu etc. You can add as many launchers as you want, but do not modify the menu itself, otherwise you will lose your customizations, or you will not have the updates of this menu (choice to be made at the time of the update of the menu package if the menu configuration files are modified).","ref":"menu.html#kaisen-linux"},{"type":"extras","title":"Kaisen Linux submenus - Menu and Tools overview","doc":"The Kaisen Linux submenus are composed like this:","ref":"menu.html#kaisen-linux-submenus"},{"type":"extras","title":"Tools for administrators - Menu and Tools overview","doc":"This category is divided into three: network, system and DevOps/cloud tools.  \nNetwork tools are divided into several categories such as PCAP (frame capture tools), GNS3, Port Console, VPN and many others. The tools in the network tools section are mainly diagnostic and troubleshooting tools mainly on layers 1 to 4 of the OSI model. Some security tools like Nmap or Wireshark are integrated, even if they are used a lot in offensive security, they can also be major assets to secure an IS.  \nThe system tools are mainly remote administration, backup and virtualization tools (type 2 hypervisors), DNS (DNS diagnostic tools), SSL/TLS (TLS certificate analysis) and many others. This category is therefore purely focused on the administration of Windows and Linux systems. Tools like parallel-ssh, rsync, zsync, ab, xca to name a few are classified in this category and its subcategories.  \nCloud and DevOps tools are a collection of tools for cloud engineers such as trivy, terraform, k6, k9s and others!","ref":"menu.html#tools-for-administrators"},{"type":"extras","title":"Tools for technicians - Menu and Tools overview","doc":"In this menu, are stored all the tools dedicated to the maintenance of computers and their hardware peripherals and operating systems. Several subcategories exist in this menu like disk scan, data recovery, mount tools etc ... Tools like gsmartcontrol, gparted, ddrescue, testdisk, photorec can be found. These tools can also be used by system administrators as part of some of their functions and not just by IT technicians. Data and disk encryption tools are also classified as well.","ref":"menu.html#tools-for-technicians"},{"type":"extras","title":"Various tools - Menu and Tools overview","doc":"In this menu, are stored the launchers that cannot be entered in the menu for system and network administrators or technicians, because they are too generic. Can be found there for example midnight commander, progress, and also some scripts developed for Kaisen Linux like for example, the kaisen-interface-switcher and kaisen-update (automation of updates and cleaning of non-essential packages). The kaisen-interface-switcher as well as kaisen-update can be launched directly via the menu because they do not require specific arguments to run.","ref":"menu.html#various-tools"},{"type":"extras","title":"Filesystems - Menu and Tools overview","doc":"The menu for file systems is a menu that allows to simply reference the tools and commands that can be used to administer, repair, create, diagnose different file systems such as BTRFS, ExFAT, NTFS, XFS, EXT4 etc ... In this category, is contained for example the commands mkfs (create a filesystem on a partition), fsck (repair the filesystem of a partition) etc ...\nThese launchers open a full help or man page.","ref":"menu.html#filesystems"},{"type":"extras","title":"Services - Menu and Tools overview","doc":"This menu has been specially designed to simplify the management of services in a simple way. All the services added by the tools present by default in the distribution are disabled for performance and resource saving reasons. Launchers point to scripts in /opt/services, and are sorted by the name of the service, for example, Avahi, 2ping, etc. Certain categories like containerization as well as virtualization encompass multiple launchers. For example in virtualization, the services for QEMU/KVM, VirtualBox and VMWare are arranged here, this allows to reduce the size of the menu. There are also two additional scripts that allow them to turn everything on or off, to avoid having to manually turn each service on or off in the categories. On these two scripts, logical conditions exist to allow you to run these scripts even if the commands executed by this script return an error because the service does not exist. Scripts can also be started manually with the terminal, but are not intentionally present in /usr/sbin or /sbin because they are intended to be used from the menu (which will only reference the launchers of the installed services).","ref":"menu.html#services"},{"type":"extras","title":"Exegol - Menu and Tools overview","doc":"The Exegol menu is a menu to group together the exegol tool and its documentation.","ref":"menu.html#exegol"},{"type":"extras","title":"Dynamic menu update - Menu and Tools overview","doc":"All launchers of each category are present in the menu only if the package associated with the program executed by the launcher is present on the system. So if you uninstall a package, or use the ISO dedicated to the rescue system, only the launchers associated with installed software will be listed. This behavior is the same as for the services menu, the scripts will still be present in /opt/services but will no longer be listed in the menu.","ref":"menu.html#dynamic-menu-update"},{"type":"extras","title":"Tools","doc":"# Tools\n\n**List of tools integrated into Kaisen Linux**","ref":"tools.html"},{"type":"extras","title":"Maintenance tools - Tools","doc":"","ref":"tools.html#maintenance-tools"},{"type":"extras","title":"Disks analysis - Tools","doc":"```bash\ne2fsprogs, baobab, diskscan, disktype, gpart, gsmartcontrol, hdparm, ioping, testdisk, ncdu, smartmontools, di, util-linux, util-linux-locales, iotop, iozone3, nvme-cli, wxfixboot, whdd, dstat\n```","ref":"tools.html#disks-analysis"},{"type":"extras","title":"Virus analysis - Tools","doc":"```bash\nchkrootkit, clamdscan, clamtk, rkhunter, clamassassin, clamav-base, clamav-daemon, clamav-docs, clamav-freshclam, clamav-milter, clamav-testfiles\n```","ref":"tools.html#virus-analysis"},{"type":"extras","title":"Cloning - Tools","doc":"```bash\nclonezilla, dcfldd, dc3dd, fsarchiver, qt-fsarchiver, guymager, partclone, partimage\n```","ref":"tools.html#cloning"},{"type":"extras","title":"USB boot - Tools","doc":"```bash\nbalena-etcher, dcfldd, dc3dd\n```","ref":"tools.html#usb-boot"},{"type":"extras","title":"Hardware - Tools","doc":"```bash\nkaisen-winkey-recovery, cpulimit, discover, discover-data, dmidecode, fio, hardinfo2, hwinfo, lshw, stress, stress-ng, stressant, lshw-gtk, flashbench, hw-probe, memtester, flashrom, inxi, cpu-x, sysstat, hwdata, gtkstresstesting, stressapptest, dstat\n```","ref":"tools.html#hardware"},{"type":"extras","title":"Outlook PST - Tools","doc":"```bash\npff-tools, pst-utils\n```","ref":"tools.html#outlook-pst"},{"type":"extras","title":"Password tools - Tools","doc":"```bash\nbruteforce-luks, chntpw, cmospwd, fcrackzip, hashcat, hydra, john, ophcrack, ophcrack-cli, pdfcrack, rarcrack, rephrase, samdump2, hydra-gtk, crunch\n```","ref":"tools.html#password-tools"},{"type":"extras","title":"Partitioning and delete tools - Tools","doc":"```bash\ndcfldd, dc3dd, fatresize, fdisk, gdisk, gparted, nwipe, parted, secure-delete, wipe, zerofree, bleachbit, scrub, wipefreespace, util-linux, util-linux-locales\n```","ref":"tools.html#partitioning-and-delete-tools"},{"type":"extras","title":"Data protection - Tools","doc":"```bash\nfscrypt, lockfile-progs, zulucrypt-cli, zulucrypt-gui, zulumount-cli, zulumount-gui, veracrypt, sedutil\n```","ref":"tools.html#data-protection"},{"type":"extras","title":"Data recovery - Tools","doc":"```bash\nddrescue-gui, ddrescueview, ddrutility, ext4magic, extundelete, foremost, ddrescue, gddrescue, testdisk, magicrescue, myrescue, recoverdm, recoverjpeg, safecopy, scalpel, hfsprescue\n```","ref":"tools.html#data-recovery"},{"type":"extras","title":"Temperature analysis - Tools","doc":"```bash\nxsensors, lm-sensors, psensor, psensor-common\n```","ref":"tools.html#temperature-analysis"},{"type":"extras","title":"Duplicates files - Tools","doc":"```bash\nczkawka, dupeguru, fdupes, rdfind\n```","ref":"tools.html#duplicates-files"},{"type":"extras","title":"Administrators tools - Tools","doc":"","ref":"tools.html#administrators-tools"},{"type":"extras","title":"DHCP - Tools","doc":"```bash\nisc-dhcp-client, isc-dhcp-common, dhcpdump, dhcping\n```","ref":"tools.html#dhcp"},{"type":"extras","title":"DNS - Tools","doc":"```bash\ndnsenum, mdns-scan, whois, bind9-dnsutils\n```","ref":"tools.html#dns"},{"type":"extras","title":"Ethernet - Tools","doc":"```bash\nethstatus, ethtool, packeth\n```","ref":"tools.html#ethernet"},{"type":"extras","title":"Firewalling - Tools","doc":"```bash\niptables-persistent, iptstate\n```","ref":"tools.html#firewalling"},{"type":"extras","title":"IP - Tools","doc":"```bash\nnet-tools, ipcalc, sipcalc, iproute2, iptraf-ng, iptraf, ipv6calc, traceroute, iputils-tracepath, ndisc6\n```","ref":"tools.html#ip"},{"type":"extras","title":"GNS3 - Tools","doc":"```bash\ngns3-gui, gns3-server, dynamips, vpcs, ubridge\n```","ref":"tools.html#gns3"},{"type":"extras","title":"MAC - Tools","doc":"```bash\narp-scan, arpalert, iputils-arping, arptables, arpwatch, macchanger\n```","ref":"tools.html#mac"},{"type":"extras","title":"Monitoring - Tools","doc":"```bash\ncbm, etherape, ifstat, iftop, iperf, iperf3, nethogs, netperfmeter, sockstat, tcpstat, dstat\n```","ref":"tools.html#monitoring"},{"type":"extras","title":"PCAP - Tools","doc":"```bash\ndarkstat, hunt, netsed, ngrep, pcapfix, scapy, python3-scapy, python3-pyx, tcpdump, tcpreplay, tcpxtract, tshark, wireshark\n```","ref":"tools.html#pcap"},{"type":"extras","title":"Console port - Tools","doc":"```bash\ncu, minicom, picocom, screen, setserial, statserial, gtkterm\n```","ref":"tools.html#console-port"},{"type":"extras","title":"Network scanners - Tools","doc":"```bash\narp-scan, bettercap, bettercap-caplets, bettercap-ui, driftnet, dsniff, ettercap-graphical, lft, masscan, mitmproxy, mtr-tiny, nast, ndiff, netdiscover, netsniff-ng, net-tools, ncat, nmap, nmapsi4, scapy, python3-scapy, telnet, iputils-tracepath, traceroute\n```","ref":"tools.html#network-scanners"},{"type":"extras","title":"SSL/TLS - Tools","doc":"```bash\nssldump, sslsniff, sslsplit, sslscan, sslyze\n```","ref":"tools.html#ssl-tls"},{"type":"extras","title":"TCP/UDP - Tools","doc":"```bash\nnetcat, netcat-openbsd, tcpreplay, tcpflow, tcptrace, tcptraceroute, packetsender, udpcast, dsniff\n```","ref":"tools.html#tcp-udp"},{"type":"extras","title":"Wi-Fi - Tools","doc":"```bash\naircrack-ng, iw, rfkill, linssid\n```\n\n### VPN\n```bash\nopenvpn, wireguard, openfortivpn, network-manager-openvpn, network-manager-openconnect, network-manager-openvpn-gnome, network-manager-openconnect-gnome\n```\n\n### Various network administrators tools\n```bash\n2ping, cdpr, comgt, socat, ssmping, wakeonlan, ifenslave, bridge-utils, tftp-hpa, tftpd-hpa\n```\n\n### Remote administration\n```bash\nvirt-viewer, rdesktop, grdesktop, freerdp3-x11, ssh, sshfs, pssh, clusterssh, tmux, zssh, remmina, remmina-plugin-exec, remmina-plugin-kwallet, remmina-plugin-www, smbclient, ssh-askpass, sshpass, sshs\n```\n\n### Backup tools\n```bash\ndirvish, automysqlbackup, autopostgresqlbackup, bacula-bscan, bacula-client, bacula-common, bacula-common-sqlite3, bacula-console, bacula-console-qt, bacula-fd, bacula-sd, dump, duplicity, restic, rsbackup, rsync, backup2l, zsync, vbackup, duply, grsync, zbackup, rdiff, rdiff-backup, rdiff-backup-fs, borgbackup, rclone\n```\n\n### FTP\n```bash\nfilezilla, gftp, lftp\n```","ref":"tools.html#wi-fi"},{"type":"extras","title":"Microsoft - Tools","doc":"```bash\npowershell\n```","ref":"tools.html#microsoft"},{"type":"extras","title":"Virtualization - Tools","doc":"```bash\nvirtualbox, virtualbox-qt, virtualbox-dkms, virtualbox-source, virtualbox-guest-additions-iso, virtualbox-ext-pack, virt-manager, qemu-system, qemu-system-x86, qemu-system-gui, qemu-utils, libvirt-clients, libvirt-clients-qemu, libvirt-daemon, libvirt-daemon-system, libvirt-daemon-config-network, libvirt-daemon-config-nwfilter, libvirt-daemon-driver-lxc, libvirt-daemon-driver-qemu, libvirt-daemon-driver-storage-gluster, libvirt-daemon-driver-storage-iscsi-direct, libvirt-daemon-driver-storage-rbd, libvirt-daemon-driver-storage-zfs, libvirt-daemon-driver-vbox, libvirt-daemon-driver-xen, virtinst, virt-viewer\n```","ref":"tools.html#virtualization"},{"type":"extras","title":"Various system administrators tools - Tools","doc":"```bash\nxca, krb5-config, krb5-pkinit, krb5-user, krb5-locales, apache2-utils, chrony, python3-ldapdomaindump, tftp-hpa, tftpd-hpa\n```","ref":"tools.html#various-system-administrators-tools"},{"type":"extras","title":"Apparmor tools and profiles - Tools","doc":"```bash\napparmor, apparmor-profiles, apparmor-profiles-extra, apparmor-notify, apparmor-utils\n```","ref":"tools.html#apparmor-tools-and-profiles"},{"type":"extras","title":"Databases clients - Tools","doc":"```bash\nmariadb-client, etcd-client, postgresql-client\n```","ref":"tools.html#databases-clients"},{"type":"extras","title":"DevOps and Cloud - Tools","doc":"```bash\ndocker-compose, docker.io, ansible, ansible-lint, lxc, lxctl, lxd, lxd-agent, lxd-client, lxd-migrate, lxd-tools, kubernetes-client, vagrant, vagrant-lxc, vagrant-sshfs, jmeter, awscli, azure-cli, packer, puppet-agent, pdk, terraform, s3fs, k6, k9s, helm, podman, buildah, minikube, eksctl, trivy, kustomize, kind, krew, kubectx, kyverno, popeye, tfsec, tflint, vault, velero, terragrunt, openstack-client, lazydocker, kubeshark, vagrant-libvirt, ctop, glab, tekton-cli, argo-cd, openbao, opentofu\n```","ref":"tools.html#devops-and-cloud"},{"type":"extras","title":"System snapshots - Tools","doc":"```bash\nkaisen-timeshift-apt, kaisen-systemd-subvolume-delete, btrbk, snapper, timeshift, grub-btrfs\n```","ref":"tools.html#system-snapshots"},{"type":"extras","title":"Filesystems tools - Tools","doc":"```bash\ncryptsetup, cryptsetup-initramfs, dmsetup, mdadm, lvm2, dosfstools, f2fs-tools, nilfs-tools, ocfs2-tools, btrfs-compsize, btrfs-heatmap, btrfs-progs, btrfsmaintenance, gfs2-utils, hfsplus, hfsprogs, hfsutils, hfsutils-tcltk, jfsutils, vmfs-tools, xfsdump, xfsprogs, zfs-dkms, zfs-test, zfs-zed, zfsutils-linux, exfatprogs, fuse3, udfclient, udftools, vmfs6-tools, xmount, archivemount, tmfs, cifs-utils, apfs-fuse, apfsprogs, libbde-utils, dislocker, libfvde-utils, libvhdi-utils, libvmdk-utils, libfsntfs-utils, gvfs-fuse, gvfs, ntfs-3g, wimtools\n```","ref":"tools.html#filesystems-tools"},{"type":"extras","title":"Miscellaneous tools - Tools","doc":"```bash\nprogress, pv, less, plocate, dirmngr, gpa, gpg, gnupg2, curl, wget, git, lazygit, gpg-agent, hyfetch, img2pdf, mc, strace, yamllint, ltrace, tree, vim, codium, cups, hexedit, file, psmisc, htop, lsof, lzop, p7zip-full, pigz, unp, unar, unrar-free, unzip, zip, bzip2, tar, unrar, zstd, gtkhash, keepassxc-full, apg, pwgen, fred, cabextract, btop, jq, yq, simple-scan\n```","ref":"tools.html#miscellaneous-tools"},{"type":"extras","title":"Integrated firmwares - Tools","doc":"```bash\nlinux-firmware-acenic, linux-firmware-adaptec, linux-firmware-advansys, linux-firmware-alacritech, linux-firmware-amd-graphics, linux-firmware-amd-microcode, linux-firmware-atheros, linux-firmware-atmel, linux-firmware-atusb, linux-firmware-broadcom, linux-firmware-cadence, linux-firmware-cavium, linux-firmware-chelsio, linux-firmware-cirrus, linux-firmware-conexant, linux-firmware-doc, linux-firmware-edgeport, linux-firmware-ene, linux-firmware-inside-secure, linux-firmware-intel-bluetooth, linux-firmware-intel-ethernet, linux-firmware-intel-graphics, linux-firmware-intel-hfi1, linux-firmware-intel-iscsi, linux-firmware-intel-qat, linux-firmware-intel-sound, linux-firmware-iwlwifi, linux-firmware-kaweth, linux-firmware-libertas, linux-firmware-mediatek, linux-firmware-mellanox, linux-firmware-microchip, linux-firmware-multitec-usb, linux-firmware-myricom, linux-firmware-netronome, linux-firmware-nvidia-graphics, linux-firmware-qlogic, linux-firmware-ralink, linux-firmware-realtek, linux-firmware-redpine, linux-firmware-renesas, linux-firmware-rockchip, linux-firmware-rocketport, linux-firmware-tehuti, linux-firmware-vxge, linux-firmware-wfx, firmware-b43-installer, firmware-ast, firmware-sof-signed, firmware-zd1211, bluetooth, blueman, bluez-tools, bluez-firmware, alsa-firmware-loaders, nvidia-driver, nvidia-legacy-390xx-driver, intel-microcode\n```","ref":"tools.html#integrated-firmwares"},{"type":"extras","title":"Exegol - Tools","doc":"```bash\nexegol, exegol-docs\n```","ref":"tools.html#exegol"},{"type":"extras","title":"KDE - Tools","doc":"```bash\nkaisen-interfaces-common, kde-standard, kde-style-breeze, sddm, sddm-theme-breeze, network-manager\n```","ref":"tools.html#kde"},{"type":"extras","title":"LXQT - Tools","doc":"```bash\nkaisen-interfaces-common, lxqt, lxqt-archiver, cmst, lightdm, lightdm-gtk-greeter, gnome-calculator, lightdm-gtk-greeter-settings\n```","ref":"tools.html#lxqt"},{"type":"extras","title":"MATE - Tools","doc":"```bash\nkaisen-interfaces-common, mate-desktop-environment, mate-tweak, mate-media, network-manager-gnome, lightdm, lightdm-gtk-greeter, lightdm-gtk-greeter-settings\n```","ref":"tools.html#mate"},{"type":"extras","title":"XFCE - Tools","doc":"```bash\nkaisen-interfaces-common, xfce4, xfce4-panel, xfce4-power-manager, xfce4-power-manager-data, xfce4-power-manager-plugins, xfce4-pulseaudio-plugin, xfce4-screenshooter, xfce4-session, xfce4-settings, xfce4-terminal, xfce4-whiskermenu-plugin, gedit, network-manager, network-manager-gnome, thunar-archive-plugin, xarchiver, lightdm, lightdm-gtk-greeter, gnome-calculator, xscreensaver, lightdm-gtk-greeter-settings\n```","ref":"tools.html#xfce"},{"type":"extras","title":"Interfaces common - Tools","doc":"```bash\nfirefox, plymouth, plymouth-themes, kaisen-menu, kaisen-skeleton, kaisen-design, breeze-cursor-theme, fonts-cantarell, terminator, xserver-xorg-input-all, fonts-liberation, fonts-noto-color-emoji, thunderbird, libreoffice, qbittorrent, vlc, gimp, power-profiles-daemon, xserver-xorg-input-synaptics\n```","ref":"tools.html#interfaces-common"},{"type":"extras","title":"Packages","doc":"# Packages\n\n**This section presents the different packages modified for Kaisen Linux and their function on the system.**","ref":"packages.html"},{"type":"extras","title":"Forked packages - Packages","doc":"### base-files\nThe base-files package will simply provide the following files on the system:\n\n```bash\n*/etc/kaisen_version\n*/etc/issue\n*/etc/issue.net\n*/etc/os-release\n```\n\nThese files are used to identify the system version in details, such as the system version number, distribution name, code name, etc.\nThese files are used by the live system during the welcome message on the system (here Debian has been replaced by Kaisen Linux).\nThey are also used to customize GRUB thanks to the lsb_release package which, in its default configuration will read the /etc/os-release file to find out the version of the OS.   \n\nBy consequently, personalize the GRUB entries in its default configuration by the command lsb_release -i -s (information present in /etc/default/grub at the line GRUB_DISTRIBUTOR) when executing the update-grub command. The goal here was to replace Debian with Kaisen on the GRUB entries of the installed system. This package surely has many other uses, but I have not encountered them so far.  \n\nThe package has therefore been recompiled to formalize the name of the distribution on the system and customize it a little more.\n\nThe file /etc/debian_version is replaced by the /etc/kaisen_version file in the Kaisen base-files package.","ref":"packages.html#forked-packages"},{"type":"extras","title":"linux - Packages","doc":"The kernel has been recompiled to generate .udeb files (used by the Debian installer) as well as .deb files needed to install it via apt or dpkg.  \nThe Kaisen Linux kernel has its own lean configuration.\nThe kernel is also recompiled to disable signing modules because signing modules breaks GRUB with Kaisen Linux configuration.","ref":"packages.html#linux"},{"type":"extras","title":"debian-installer - Packages","doc":"This package is forked to build the installer with the custom Kaisen Linux kernel as well as our packages used by the installer (rootskel-gtk for example). It is necessary to rebuild the installer to integrate the modified packages for the installer and thus integrate them into the rolling release ISO.","ref":"packages.html#debian-installer"},{"type":"extras","title":"rootskel-gtk - Packages","doc":"This package has been modified because it provides the graphical configuration of the installer (theme, banners). The theme of the Kaisen Linux graphical installer is based on the original Clearlooks theme.","ref":"packages.html#rootskel-gtk"},{"type":"extras","title":"apt-setup - Packages","doc":"This package allows you to configure the /etc/apt/sources.list file after installing the system.  \nSince the Kaisen Linux installer is configured to request no network configuration, this package has been forked to add the Kaisen Linux repository, because by default, without internet connection (therefore no mirror selection), apt-setup will configure the Debian security repositories.","ref":"packages.html#apt-setup"},{"type":"extras","title":"choose-mirror - Packages","doc":"This package configures the mirrors to be used to download packages.","ref":"packages.html#choose-mirror"},{"type":"extras","title":"partman-auto - Packages","doc":"Forked to define BTRFS as default filesystem and reworked default schemes.","ref":"packages.html#partman-auto"},{"type":"extras","title":"debootstrap - Packages","doc":"This package builds and installs the base system (the packages mentioned as required). This package is forked to integrate the specific configurations of Kaisen Linux (build the base system from the distribution repository).","ref":"packages.html#debootstrap"},{"type":"extras","title":"desktop-base - Packages","doc":"This package provides wallpapers for the desktop, login screen, grub etc ...  \nThis package is forked to add the different Kaisen themes on the system to provide wallpapers as well as \"alternatives\" to define by default the theme to use. It is by default configured on kaisen-theme.","ref":"packages.html#desktop-base"},{"type":"extras","title":"grub2 - Packages","doc":"This package was forked to integrate the kaisen-grub-configuration package as a dependency. This allowed the possibility of providing a GRUB image even when the machine is encrypted and activating the plymouth theme.","ref":"packages.html#grub2"},{"type":"extras","title":"live-build - Packages","doc":"It is the official Debian tool for building system images. It was forked to add support for the \"kaisen-rolling\" repository.","ref":"packages.html#live-build"},{"type":"extras","title":"live-config - Packages","doc":"This package contains all live configurations. Forked to add components/0031-kaisen-password script. This script add a password for live system.","ref":"packages.html#live-config"},{"type":"extras","title":"shadow - Packages","doc":"This package was forked to use the /bin/bash shell by default when a user is created.","ref":"packages.html#shadow"},{"type":"extras","title":"live-installer - Packages","doc":"Forked to add 61kaisen script to launch this script after the system installation.","ref":"packages.html#live-installer"},{"type":"extras","title":"plymouth - Packages","doc":"Forked to define kaisen-theme by default for Plymouth.","ref":"packages.html#plymouth"},{"type":"extras","title":"partman-btrfs - Packages","doc":"Forked to automatically create BTRFS subvolumes.","ref":"packages.html#partman-btrfs"},{"type":"extras","title":"simple-cdd - Packages","doc":"Forked to add kaisen profile. The kaisen profile add a custom preseed for NETINST ISO,\nand add a postinst script to exec a few actions after the installation.","ref":"packages.html#simple-cdd"},{"type":"extras","title":"debian-cd - Packages","doc":"Forked to adding kaisen-rolling repository","ref":"packages.html#debian-cd"},{"type":"extras","title":"tasksel - Packages","doc":"Forked to adding Kaisen Linux tasks","ref":"packages.html#tasksel"},{"type":"extras","title":"lightdm-gtk-greeter - Packages","doc":"Forked to add Kaisen Linux lightdm settings","ref":"packages.html#lightdm-gtk-greeter"},{"type":"extras","title":"net-retriever - Packages","doc":"Forked to add kaisen-archive-keyring-udeb package","ref":"packages.html#net-retriever"},{"type":"extras","title":"docker.io - Packages","doc":"Forked to add a conffile to change the default storage driver will be used by Docker","ref":"packages.html#docker-io"},{"type":"extras","title":"virtualbox - Packages","doc":"Forked to add a conffile to load automatically vbox modules at boot","ref":"packages.html#virtualbox"},{"type":"extras","title":"virtualbox-ext-pack - Packages","doc":"Forked to change the default response provided by debconf","ref":"packages.html#virtualbox-ext-pack"},{"type":"extras","title":"virtualbox-guest-additions-iso - Packages","doc":"Forked to adapt the dependencies to the rest of the VirtualBox packages","ref":"packages.html#virtualbox-guest-additions-iso"},{"type":"extras","title":"python-async-timeout - Packages","doc":"Forked to adapt the distributed version to the version required by GNS3","ref":"packages.html#python-async-timeout"},{"type":"extras","title":"netsniff-ng - Packages","doc":"Forked to replace ntpsec by chrony as recommended package","ref":"packages.html#netsniff-ng"},{"type":"extras","title":"timeshift - Packages","doc":"Forked to add few Kaisen specific patches","ref":"packages.html#timeshift"},{"type":"extras","title":"spice-vdagent - Packages","doc":"Forked to fix the desktop launcher","ref":"packages.html#spice-vdagent"},{"type":"extras","title":"python-psutil - Packages","doc":"Cross-platform lib for process and system monitoring in Python","ref":"packages.html#python-psutil"},{"type":"extras","title":"Kaisen Linux packages - Packages","doc":"","ref":"packages.html#kaisen-linux-packages"},{"type":"extras","title":"kaisen-grub-configuration - Packages","doc":"The GRUB package has been recompiled to change the configuration of the /etc/default/grub file to add support for the default splash screen for the user on the installed system (graphical boot) and also allow in case the command lsb_release -i -s cannot be executed because the lsb-release script is not present, you can still display Kaisen and not Debian in the GRUB entries.  \n\nThe kaisen-grub-configuration package is installed automatically during system installation and automates this customization.","ref":"packages.html#kaisen-grub-configuration"},{"type":"extras","title":"kaisen-archive-keyring - Packages","doc":"This package provides the public GPG keys needed to use our secure repository with identity verification via a GPG key (used by official Debian repositories and implemented security by default).","ref":"packages.html#kaisen-archive-keyring"},{"type":"extras","title":"kaisen-menu - Packages","doc":"This package provides the custom menu. This includes the \"skeleton\" of the menu (allows you to organize the location of the different folders), the directories as well as the launchers of the applications. This menu is mainly used to reference the tools present in the distribution.","ref":"packages.html#kaisen-menu"},{"type":"extras","title":"kaisen-services-management - Packages","doc":"This package provides various bash scripts allowing you to easily manage additional services (added by software supplied with the distribution).  \nThe scripts are installed in `/usr/share/kaisen-services-management`. This package coupled with the \"kaisen-menu\" package allows you to reference and execute directly via the menu the scripts classified by service to activate or deactivate additional services. Two activation and deactivation scripts exist for all services.","ref":"packages.html#kaisen-services-management"},{"type":"extras","title":"kaisen-update - Packages","doc":"This package just provides a script to perform an apt update && apt upgrade in one command. The kaisen-update command also allows to remove the most necessary packages (dependencies no longer used).","ref":"packages.html#kaisen-update"},{"type":"extras","title":"kaisen-build - Packages","doc":"This package contains all configurations for build Kaisen Linux ISO.","ref":"packages.html#kaisen-build"},{"type":"extras","title":"kaisen-interfaces - Packages","doc":"All Kaisen Linux MATE Desktop Environment configurations (themes, icons etc). \n\nAll Kaisen Linux KDE Desktop Environment configurations (themes, icons etc). \n\nAll Kaisen Linux LXQT Desktop Environment configurations (themes, icons etc). \n\nAll Kaisen Linux XFCE Desktop Environment configurations (themes, icons etc). \n\nThe package kaisen-interface-common package installs the kaisen-interface-switcher command and commons packages for all interfaces.","ref":"packages.html#kaisen-interfaces"},{"type":"extras","title":"kaisen-skeleton - Packages","doc":"This allows you to have launchers on the desktop, the conky theme...  \nThis package replaces the old kaisen-*-default-profile packages which installed only the default profile of the related interface.\nThis package installs the kaisen-update-skel command.","ref":"packages.html#kaisen-skeleton"},{"type":"extras","title":"kaisen-manpages - Packages","doc":"This package is simply an offline implementation of the entire https://kaisenlinux.org/manpages/ domain in order to access the centralized manpages of the tools built into Kaisen Linux without requiring an internet connection.","ref":"packages.html#kaisen-manpages"},{"type":"extras","title":"kaisen-documentation - Packages","doc":"This package is simply an offline implementation of the entire https://kaisenlinux.org/documentation/ domain in order to access the centralized documentation without requiring an internet connection.","ref":"packages.html#kaisen-documentation"},{"type":"extras","title":"kaisen-design - Packages","doc":"This package contains all themes and icons for Kaisen Linux","ref":"packages.html#kaisen-design"},{"type":"extras","title":"kaisen-conky - Packages","doc":"Conky theme for Kaisen Linux","ref":"packages.html#kaisen-conky"},{"type":"extras","title":"kaisen-winkey-recovery - Packages","doc":"Official Kaisen Linux tool to recover OEM Windows key","ref":"packages.html#kaisen-winkey-recovery"},{"type":"extras","title":"kaisen-lib64 - Packages","doc":"Ensure of /lib64 has been created (required by debootstrap)","ref":"packages.html#kaisen-lib64"},{"type":"extras","title":"kaisen-systemd-subvolume-delete - Packages","doc":"Automatically delete BTRFS subvolumes created by systemd","ref":"packages.html#kaisen-systemd-subvolume-delete"},{"type":"extras","title":"kaisen-webdocs - Packages","doc":"Package for offline web documentation and manpages","ref":"packages.html#kaisen-webdocs"},{"type":"extras","title":"veracrypt - Packages","doc":"Tool to HDD, SSD and system disks encryption.","ref":"packages.html#veracrypt"},{"type":"extras","title":"woeusb - Packages","doc":"Tool to create Windows USB bootable key (written in Bash).","ref":"packages.html#woeusb"},{"type":"extras","title":"woeusb-ng - Packages","doc":"Tool to create Windows USB bootable key (written in Python)","ref":"packages.html#woeusb-ng"},{"type":"extras","title":"gns3-server - Packages","doc":"Tool to network simulator (server package)","ref":"packages.html#gns3-server"},{"type":"extras","title":"gns3-gui - Packages","doc":"Tool to network simulator (client package)","ref":"packages.html#gns3-gui"},{"type":"extras","title":"apfs-fuse - Packages","doc":"FUSE driver for Apple FileSystem","ref":"packages.html#apfs-fuse"},{"type":"extras","title":"ubridge - Packages","doc":"Bridge for UDP tunnels, Ethernet, TAP and VMnet interfaces","ref":"packages.html#ubridge"},{"type":"extras","title":"vpcs - Packages","doc":"Simple Virtual PC Simulator","ref":"packages.html#vpcs"},{"type":"extras","title":"dynamips - Packages","doc":"Router emulator for GNS3","ref":"packages.html#dynamips"},{"type":"extras","title":"neo4j - Packages","doc":"Graph for everyone","ref":"packages.html#neo4j"},{"type":"extras","title":"bettercap - Packages","doc":"Tool to testing the possibility of MITM attacks on Bluetooth, Wi-Fi, Ethernet and more.","ref":"packages.html#bettercap"},{"type":"extras","title":"bettercap-caplets - Packages","doc":"Caplets and proxy modules.","ref":"packages.html#bettercap-caplets"},{"type":"extras","title":"bettercap-ui - Packages","doc":"Bettercap's web UI","ref":"packages.html#bettercap-ui"},{"type":"extras","title":"hfsprescue - Packages","doc":"Tool specialized in recovering data from HFS + partitions.","ref":"packages.html#hfsprescue"},{"type":"extras","title":"conkycolors - Packages","doc":"Tool developed with the aim of simplifying the configuration of the Conky theme. Some contributions have been made on the official GitHub repository of the software to facilitate its integration into Kaisen Linux.","ref":"packages.html#conkycolors"},{"type":"extras","title":"ctop - Packages","doc":"Tool to obtain container metrics (Docker or containerd)","ref":"packages.html#ctop"},{"type":"extras","title":"eksctl - Packages","doc":"The official CLI for Amazon EKS","ref":"packages.html#eksctl"},{"type":"extras","title":"gtkhash - Packages","doc":"A cross-platform desktop utility for computing message digests or checksums","ref":"packages.html#gtkhash"},{"type":"extras","title":"helm - Packages","doc":"The Kubernetes package manager","ref":"packages.html#helm"},{"type":"extras","title":"iptstate - Packages","doc":"IP Tables state","ref":"packages.html#iptstate"},{"type":"extras","title":"k6 - Packages","doc":"A modern load testing tool, using Go and JavaScript","ref":"packages.html#k6"},{"type":"extras","title":"k9s - Packages","doc":"Kubernetes CLI To Manage Your Clusters In Style!","ref":"packages.html#k9s"},{"type":"extras","title":"kubernetes - Packages","doc":"Production-Grade Container Scheduling and Management","ref":"packages.html#kubernetes"},{"type":"extras","title":"minikube - Packages","doc":"Run Kubernetes locally","ref":"packages.html#minikube"},{"type":"extras","title":"psensor - Packages","doc":"Graphical hardware temperature monitor for Linux","ref":"packages.html#psensor"},{"type":"extras","title":"terraform - Packages","doc":"Infrastructure as code tool to provisioning cloud infrastructures.","ref":"packages.html#terraform"},{"type":"extras","title":"trivy - Packages","doc":"Vulnerabilities scanner for containers","ref":"packages.html#trivy"},{"type":"extras","title":"sentry-python - Packages","doc":"Updated tool for integrating GNS3 tools in Kaisen Linux.","ref":"packages.html#sentry-python"},{"type":"extras","title":"python3-cpuinfo - Packages","doc":"Updated tool for integrating GNS3 tools in Kaisen Linux.","ref":"packages.html#python3-cpuinfo"},{"type":"extras","title":"python3-getdevinfo - Packages","doc":"Repackaged to make it compatible with Kaisen Linux, is a dependency on ddrescue-gui.","ref":"packages.html#python3-getdevinfo"},{"type":"extras","title":"btrbk - Packages","doc":"Repackaged to fix bugs with conffiles, fix path binary on systemd service and update btrbk binary","ref":"packages.html#btrbk"},{"type":"extras","title":"sslyze - Packages","doc":"SSL/TLS scanner","ref":"packages.html#sslyze"},{"type":"extras","title":"tls-parser - Packages","doc":"Packaged because is a dependancy of sslyze","ref":"packages.html#tls-parser"},{"type":"extras","title":"nassl - Packages","doc":"Packaged because is a dependancy of sslyze","ref":"packages.html#nassl"},{"type":"extras","title":"ddrescue - Packages","doc":"Data recovery and data protection tool","ref":"packages.html#ddrescue"},{"type":"extras","title":"ddrescue-gui - Packages","doc":"Tool to add a GUI for ddrescue tool","ref":"packages.html#ddrescue-gui"},{"type":"extras","title":"tfsec - Packages","doc":"Security scanner for your Terraform code","ref":"packages.html#tfsec"},{"type":"extras","title":"terragrunt - Packages","doc":"Wrapper for Terraform","ref":"packages.html#terragrunt"},{"type":"extras","title":"kyverno - Packages","doc":"Kubernetes Native Policy Management","ref":"packages.html#kyverno"},{"type":"extras","title":"vault - Packages","doc":"Hashicorp tool to for secrets management, encryption as a service, and privileged access management","ref":"packages.html#vault"},{"type":"extras","title":"packer - Packages","doc":"Tool for creating identical machine images for multiple platforms from a single source configuration","ref":"packages.html#packer"},{"type":"extras","title":"kustomize - Packages","doc":"Customization of Kubernetes YAML configurations","ref":"packages.html#kustomize"},{"type":"extras","title":"kind - Packages","doc":"Kubernetes IN Docker - local clusters for testing Kubernetes","ref":"packages.html#kind"},{"type":"extras","title":"velero - Packages","doc":"Tool to backup and migrate Kubernetes applications and their persistent volumes","ref":"packages.html#velero"},{"type":"extras","title":"rclone - Packages","doc":"Rclone - \"rsync for cloud storage\"","ref":"packages.html#rclone"},{"type":"extras","title":"popeye - Packages","doc":"A Kubernetes cluster resource sanitizer","ref":"packages.html#popeye"},{"type":"extras","title":"gtkstresstest - Packages","doc":"System utility designed to stress and monitor various hardware components","ref":"packages.html#gtkstresstest"},{"type":"extras","title":"gox - Packages","doc":"A dead simple, no frills Go cross compile tool","ref":"packages.html#gox"},{"type":"extras","title":"wipefreespace - Packages","doc":"WipeFreeSpace is a program which will securely wipe (clean, shred, fill, overwrite) the free space","ref":"packages.html#wipefreespace"},{"type":"extras","title":"jmeter - Packages","doc":"Load testing and performance measurement application","ref":"packages.html#jmeter"},{"type":"extras","title":"qt-fsarchiver - Packages","doc":"Program to back up and restore partitions, directories and the MBR/GPT.","ref":"packages.html#qt-fsarchiver"},{"type":"extras","title":"testdisk - Packages","doc":"Partition scanner and disk recovery tool, PhotoRec and qPhotoRec file recovery tools","ref":"packages.html#testdisk"},{"type":"extras","title":"kubectx - Packages","doc":"Faster way to switch between clusters and namespaces in kubectl","ref":"packages.html#kubectx"},{"type":"extras","title":"krew - Packages","doc":"Find and install kubectl plugins","ref":"packages.html#krew"},{"type":"extras","title":"czkawka - Packages","doc":"Multi functional app to find duplicates, empty folders, similar images etc","ref":"packages.html#czkawka"},{"type":"extras","title":"hsaudiotag - Packages","doc":"Pure-python library that reads audio file metadata","ref":"packages.html#hsaudiotag"},{"type":"extras","title":"whdd - Packages","doc":"HDD diagnostic and data recovery tool for Linux","ref":"packages.html#whdd"},{"type":"extras","title":"fred - Packages","doc":"MicrosoFt Registry EDitor","ref":"packages.html#fred"},{"type":"extras","title":"stressapptest - Packages","doc":"Stress test application for simulating high load situations","ref":"packages.html#stressapptest"},{"type":"extras","title":"wxfixboot - Packages","doc":"Utility to assist with fixing the bootloader on a computer quickly","ref":"packages.html#wxfixboot"},{"type":"extras","title":"grub-btrfs - Packages","doc":"BASH scripts and conffiles to add snapshots taken by various BTRFS snapshots tools directly in the GRUB menu","ref":"packages.html#grub-btrfs"},{"type":"extras","title":"linux-firmware - Packages","doc":"Collection of non open-source firmwares provided by Linux maintainers","ref":"packages.html#linux-firmware"},{"type":"extras","title":"tflint - Packages","doc":"A Pluggable Terraform Linter","ref":"packages.html#tflint"},{"type":"extras","title":"lazygit - Packages","doc":"A simple terminal UI for git commands","ref":"packages.html#lazygit"},{"type":"extras","title":"lazydocker - Packages","doc":"The lazier way to manage everything docker","ref":"packages.html#lazydocker"},{"type":"extras","title":"yq - Packages","doc":"Portable command-line YAML, JSON, XML, CSV and properties processor","ref":"packages.html#yq"},{"type":"extras","title":"kaisen-timeshift-apt - Packages","doc":"Automatically create snapshots when APT is used with Timeshift","ref":"packages.html#kaisen-timeshift-apt"},{"type":"extras","title":"kaisen-live-guest-additions - Packages","doc":"Management of guests additions services for Kaisen live systems","ref":"packages.html#kaisen-live-guest-additions"},{"type":"extras","title":"exegol - Packages","doc":"Fully featured and community-driven hacking environment","ref":"packages.html#exegol"},{"type":"extras","title":"exegol-docs - Packages","doc":"Documentation for Exegol","ref":"packages.html#exegol-docs"},{"type":"extras","title":"kubeshark - Packages","doc":"Wireshark for Kubernetes","ref":"packages.html#kubeshark"},{"type":"extras","title":"apfsprogs - Packages","doc":"Experimental APFS tools for Linux","ref":"packages.html#apfsprogs"},{"type":"extras","title":"sedutil - Packages","doc":"DTA sedutil Self encrypting drive software","ref":"packages.html#sedutil"},{"type":"extras","title":"sshs - Packages","doc":"Terminal user interface for SSH","ref":"packages.html#sshs"},{"type":"extras","title":"argo-cd - Packages","doc":"Declarative Continuous Deployment for Kubernetes","ref":"packages.html#argo-cd"},{"type":"extras","title":"docker-buildx - Packages","doc":"Docker CLI plugin for extended build capabilities with BuildKit","ref":"packages.html#docker-buildx"},{"type":"extras","title":"docker-compose - Packages","doc":"Define and run multi-container applications with Docker","ref":"packages.html#docker-compose"},{"type":"extras","title":"glab - Packages","doc":"A GitLab CLI tool bringing GitLab to your command line","ref":"packages.html#glab"},{"type":"extras","title":"enumer - Packages","doc":"A Go tool to auto generate methods for your enums","ref":"packages.html#enumer"},{"type":"extras","title":"hyfetch - Packages","doc":"Shows Linux System Information with Distribution Logo","ref":"packages.html#hyfetch"},{"type":"extras","title":"openbao - Packages","doc":"OpenBao exists to provide a software solution to manage, store, and distribute sensitive data including secrets, certificates, and keys","ref":"packages.html#openbao"},{"type":"extras","title":"opentofu - Packages","doc":"OpenTofu lets you declaratively manage your cloud infrastructure","ref":"packages.html#opentofu"},{"type":"extras","title":"tekton-cli - Packages","doc":"A CLI for interacting with Tekton!","ref":"packages.html#tekton-cli"},{"type":"extras","title":"zulucrypt - Packages","doc":"Tool for encrypting volumes","ref":"packages.html#zulucrypt"},{"type":"extras","title":"Source of packages - Packages","doc":"All the sources of the packages can be found here:\n\nhttps://gitlab.com/kaisenlinux/packages","ref":"packages.html#source-of-packages"},{"type":"extras","title":"Metapackages","doc":"# Metapackages\n\n**This section presents the different metapackages created to install several packages via one.**","ref":"metapackages.html"},{"type":"extras","title":"Kaisen Linux metapackages for tools - Metapackages","doc":"","ref":"metapackages.html#kaisen-linux-metapackages-for-tools"},{"type":"extras","title":"kaisen-technicians-tools - Metapackages","doc":"This metapackage installs the following Kaisen Linux metapackages:\n```bash\n* kaisen-cloning\n* kaisen-data-protection\n* kaisen-data-recovery\n* kaisen-disks-analysis\n* kaisen-duplicates-files\n* kaisen-hardware\n* kaisen-partitioning-erase\n* kaisen-password-tools\n* kaisen-pst-tools\n* kaisen-temperature-analysis\n* kaisen-usb-boot\n* kaisen-various-analysis\n* kaisen-virus-analysis\n```","ref":"metapackages.html#kaisen-technicians-tools"},{"type":"extras","title":"kaisen-network-tools - Metapackages","doc":"This metapackage installs the following Kaisen Linux metapackages:\n```bash\n* kaisen-network-uncategorized\n* kaisen-ethernet-tools\n* kaisen-gns3\n* kaisen-layer4-tools\n* kaisen-layer3-tools\n* kaisen-layer2-tools\n* kaisen-network-monitoring\n* kaisen-pcap-tools\n* kaisen-portconsole-tools\n* kaisen-network-scanners\n* kaisen-vpn-tools\n* kaisen-wifi-tools\n```","ref":"metapackages.html#kaisen-network-tools"},{"type":"extras","title":"kaisen-sysadmin-tools - Metapackages","doc":"This metapackage installs the following Kaisen Linux metapackages:\n```bash\n* kaisen-sysadmin-uncategorized\n* kaisen-remote-administration\n* kaisen-backup-tools\n* kaisen-ftp-clients\n* kaisen-dhcp-tools\n* kaisen-dns-tools\n* kaisen-tls-tools\n* kaisen-apparmor\n* kaisen-databases-tools\n* kaisen-firewalling\n* kaisen-microsoft-tools\n* kaisen-virtualization-tools\n```","ref":"metapackages.html#kaisen-sysadmin-tools"},{"type":"extras","title":"kaisen-disks-analysis - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#disks-analysis).","ref":"metapackages.html#kaisen-disks-analysis"},{"type":"extras","title":"kaisen-virus-analysis - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#virus-analysis).","ref":"metapackages.html#kaisen-virus-analysis"},{"type":"extras","title":"kaisen-cloning - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#cloning).","ref":"metapackages.html#kaisen-cloning"},{"type":"extras","title":"kaisen-usb-boot - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#usb-boot).","ref":"metapackages.html#kaisen-usb-boot"},{"type":"extras","title":"kaisen-hardware - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#hardware).","ref":"metapackages.html#kaisen-hardware"},{"type":"extras","title":"kaisen-pst-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#outlook-pst).","ref":"metapackages.html#kaisen-pst-tools"},{"type":"extras","title":"kaisen-password-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#password-tools).","ref":"metapackages.html#kaisen-password-tools"},{"type":"extras","title":"kaisen-partitioning-erase - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#partitioning-and-delete-tools).","ref":"metapackages.html#kaisen-partitioning-erase"},{"type":"extras","title":"kaisen-data-protection - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#data-protection).","ref":"metapackages.html#kaisen-data-protection"},{"type":"extras","title":"kaisen-data-recovery - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#data-recovery).","ref":"metapackages.html#kaisen-data-recovery"},{"type":"extras","title":"kaisen-temperature-analysis - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#temperature-analysis).","ref":"metapackages.html#kaisen-temperature-analysis"},{"type":"extras","title":"kaisen-network-uncategorized - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#various-network-administrators-tools).","ref":"metapackages.html#kaisen-network-uncategorized"},{"type":"extras","title":"kaisen-duplicates-files - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#duplicates-files).","ref":"metapackages.html#kaisen-duplicates-files"},{"type":"extras","title":"kaisen-dhcp-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#dhcp).","ref":"metapackages.html#kaisen-dhcp-tools"},{"type":"extras","title":"kaisen-dns-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#dns).","ref":"metapackages.html#kaisen-dns-tools"},{"type":"extras","title":"kaisen-ethernet-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#ethernet).","ref":"metapackages.html#kaisen-ethernet-tools"},{"type":"extras","title":"kaisen-gns3 - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#gns3).","ref":"metapackages.html#kaisen-gns3"},{"type":"extras","title":"kaisen-layer4-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#tcp-udp).","ref":"metapackages.html#kaisen-layer4-tools"},{"type":"extras","title":"kaisen-layer3-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#ip).","ref":"metapackages.html#kaisen-layer3-tools"},{"type":"extras","title":"kaisen-layer2-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#mac).","ref":"metapackages.html#kaisen-layer2-tools"},{"type":"extras","title":"kaisen-network-monitoring - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#monitoring).","ref":"metapackages.html#kaisen-network-monitoring"},{"type":"extras","title":"kaisen-pcap-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#pcap).","ref":"metapackages.html#kaisen-pcap-tools"},{"type":"extras","title":"kaisen-portconsole-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#console-port).","ref":"metapackages.html#kaisen-portconsole-tools"},{"type":"extras","title":"kaisen-network-scanners - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#network-scanners).","ref":"metapackages.html#kaisen-network-scanners"},{"type":"extras","title":"kaisen-tls-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#ssl-tls).","ref":"metapackages.html#kaisen-tls-tools"},{"type":"extras","title":"kaisen-vpn-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#vpn).","ref":"metapackages.html#kaisen-vpn-tools"},{"type":"extras","title":"kaisen-wifi-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#wi-fi).","ref":"metapackages.html#kaisen-wifi-tools"},{"type":"extras","title":"kaisen-sysadmin-uncategorized - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#various-system-administrators-tools).","ref":"metapackages.html#kaisen-sysadmin-uncategorized"},{"type":"extras","title":"kaisen-remote-administration - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#remote-administration).","ref":"metapackages.html#kaisen-remote-administration"},{"type":"extras","title":"kaisen-backup-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#backup-tools).","ref":"metapackages.html#kaisen-backup-tools"},{"type":"extras","title":"kaisen-ftp-clients - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#ftp).","ref":"metapackages.html#kaisen-ftp-clients"},{"type":"extras","title":"kaisen-btrfs-snapshots - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#system-snapshots).","ref":"metapackages.html#kaisen-btrfs-snapshots"},{"type":"extras","title":"kaisen-microsoft-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#microsoft).","ref":"metapackages.html#kaisen-microsoft-tools"},{"type":"extras","title":"kaisen-virtualization-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#virtualization).","ref":"metapackages.html#kaisen-virtualization-tools"},{"type":"extras","title":"kaisen-apparmor - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#apparmor-tools-and-profiles).","ref":"metapackages.html#kaisen-apparmor"},{"type":"extras","title":"kaisen-firewalling - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#firewalling).","ref":"metapackages.html#kaisen-firewalling"},{"type":"extras","title":"kaisen-databases-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#databases-clients).","ref":"metapackages.html#kaisen-databases-tools"},{"type":"extras","title":"kaisen-sysops-tools - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#devops-and-cloud).","ref":"metapackages.html#kaisen-sysops-tools"},{"type":"extras","title":"kaisen-firmwares - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#integrated-firmwares).","ref":"metapackages.html#kaisen-firmwares"},{"type":"extras","title":"kaisen-filesystems - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#filesystems-tools).","ref":"metapackages.html#kaisen-filesystems"},{"type":"extras","title":"kaisen-miscellaneous - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#miscellaneous-tools).","ref":"metapackages.html#kaisen-miscellaneous"},{"type":"extras","title":"kaisen-exegol - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#exegol).","ref":"metapackages.html#kaisen-exegol"},{"type":"extras","title":"Kaisen Linux metapackages for graphical interfaces - Metapackages","doc":"","ref":"metapackages.html#kaisen-linux-metapackages-for-graphical-interfaces"},{"type":"extras","title":"kaisen-kde - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#kde).","ref":"metapackages.html#kaisen-kde"},{"type":"extras","title":"kaisen-lxqt - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#lxqt).","ref":"metapackages.html#kaisen-lxqt"},{"type":"extras","title":"kaisen-mate - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#mate).","ref":"metapackages.html#kaisen-mate"},{"type":"extras","title":"kaisen-xfce - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#xfce).","ref":"metapackages.html#kaisen-xfce"},{"type":"extras","title":"kaisen-interfaces-common - Metapackages","doc":"This metapackage install all tools listed [here](tools.html#interfaces-common).","ref":"metapackages.html#kaisen-interfaces-common"},{"type":"extras","title":"Remove packages installed by metapackages - Metapackages","doc":"All the packages installed by the metapackages listed above are configured so as not to be dependent on each other to install and can therefore be uninstalled manually without risk of breaking anything (tightly, the packages dependent on the package that is uninstalled will also be uninstalled).  \nTo easily uninstall a preinstalled package, for example ddrescue package, just type the command:  \n```sudo apt remove --purge ddrescue```","ref":"metapackages.html#remove-packages-installed-by-metapackages"},{"type":"extras","title":"Source of packages - Metapackages","doc":"All the sources of the packages managed by us can be found :\n\nhttps://gitlab.com/kaisenlinux/packages","ref":"metapackages.html#source-of-packages"},{"type":"extras","title":"Kaisen Linux licence","doc":"# Kaisen Linux licence","ref":"licence.html"},{"type":"extras","title":"Forked packages - Kaisen Linux licence","doc":"Forked packages keep the same license as the original packages. Only the maintainer's name is changed because it is out of the original Debian branch.","ref":"licence.html#forked-packages"},{"type":"extras","title":"Kaisen Linux packages - Kaisen Linux licence","doc":"All Kaisen Linux packages are provided under the AGPL license. This license was chosen to reinforce the community spirit of Kaisen Linux, the AGPL license obliges us to transfer to the software developer the modifications made to the source code. This improves Kaisen Linux and thus finds possible contributors to help us.","ref":"licence.html#kaisen-linux-packages"},{"type":"extras","title":"Kaisen Linux downloads","doc":"# Kaisen Linux downloads","ref":"download.html"},{"type":"extras","title":"Advices - Kaisen Linux downloads","doc":"Only download ISO from the official link:\n\n```bash\nhttps://kaisenlinux.org/downloads\n```\n\nThe officials mirrors:\n\n```bash\nhttps://iso.kaisenlinux.org\nhttps://torrent.kaisenlinux.org\n```\n\n**Download a Kaisen Linux ISO only via the links mentioned above.**  \n**We cannot be held responsible for any problem with an unofficial ISO.**","ref":"download.html#advices"},{"type":"extras","title":"Recommendations - Kaisen Linux downloads","doc":"","ref":"download.html#recommendations"},{"type":"extras","title":"Linux - Kaisen Linux downloads","doc":"Even if you have downloaded ISO from an official source, still perform checksum verification.\nAt each release, we publish the checksums in sha256. To check the ISO, proceed as follows, for example for the MATE ISO:\n\nCommand: ```sha256sum /path/of/ISO/kaisenlinuxrolling2.2-amd64-MATE.iso```","ref":"download.html#linux"},{"type":"extras","title":"Windows - Kaisen Linux downloads","doc":"For Windows, use **HackTab** software and check sha256 value.\nRight click on the file to analyze and go to the **hashes** section.","ref":"download.html#windows"},{"type":"extras","title":"MacOS - Kaisen Linux downloads","doc":"For MacOS, use the shasum command => Example:\n\n```bash\nshasum -a 256 /path/your/ISO/kaisenlinuxrolling2.2-amd64-MATE.iso\n6103a435e675b5b13157d6102df1ee4d377c21d46bdee59e3a6615b76a04d2a5 /path/of/ISO/kaisenlinuxrolling2.2-amd64-MATE.iso\n```","ref":"download.html#macos"},{"type":"extras","title":"Kaisen Linux repositories","doc":"# Kaisen Linux repositories\n\n- Default `sources.list` in `/etc/apt/`:\n\n```bash\ndeb https://deb.kaisenlinux.org kaisen-rolling main contrib non-free non-free-firmware\ndeb-src https://deb.kaisenlinux.org kaisen-rolling main contrib non-free non-free-firmware\n```","ref":"repo.html"},{"type":"extras","title":"Referential lists - Kaisen Linux repositories","doc":"","ref":"repo.html#referential-lists"},{"type":"extras","title":"kaisen-rolling - Kaisen Linux repositories","doc":"This repository is the official Kaisen Linux repository. It is updated directly from the Debian testing repository continuously, the mirror is updated every 6 hours.  \nIt is the default repository contained in live images as well as on the installed system.","ref":"repo.html#kaisen-rolling"},{"type":"extras","title":"kaisen-devel - Kaisen Linux repositories","doc":"It is a repository used for the development environment, it references developed/forks packages for distribution as well as integrated packages from another source such as Anydesk and TeamViewer for example.  \nDuring rolling repository updates, all the packages in this repository are \"pull\" on kaisen-rolling to restore them after their removal due to the update of the repository.  \nIt is also used as stock when the updated packages are ready to go into production (kaisen-rolling).","ref":"repo.html#kaisen-devel"},{"type":"extras","title":"kaisen-packages - Kaisen Linux repositories","doc":"This repository simply stores forked/developed packages for Kaisen Linux. It is mainly used as a backup of kaisen-devel. It also serves as an environment for testing new versions of packages before pushing packages to kaisen-devel which will push these new packages to kaisen-rolling itself.  \nCAUTION: Installing packages from this repository can break certain parts of your system or even make it unstable or even unusable. Only use it if you know what you are doing.","ref":"repo.html#kaisen-packages"},{"type":"extras","title":"kaisen-testing - Kaisen Linux repositories","doc":"This repository is used during the development of new packages or experimental testing of some bundles (sometimes not often push to kaisen-rolling).  \nCAUTION: Installing packages from this repository can break certain parts of your system or even make it unstable or even unusable. Only use it if you know what you are doing.","ref":"repo.html#kaisen-testing"},{"type":"extras","title":"kaisen-rolling-snapshot - Kaisen Linux repositories","doc":"This repository is a snapshot of the last official revision of the project. This keeps the packages preinstalled on Kaisen Linux which can be uninstalled on Debian.\n\n## Which repository to use\nYou can use them all. However, if you are new to GNU/Linux, avoid the kaisen-testing repository, repairing your system can be complicated in case of problems.","ref":"repo.html#kaisen-rolling-snapshot"},{"type":"extras","title":"Kaisen Linux updates","doc":"# Kaisen Linux system updates","ref":"update.html"},{"type":"extras","title":"Alpha and beta - Kaisen Linux updates","doc":"The alpha and beta versions (from version 20191214 to 20200413) had a \"fixed\" update system, which means that each new release was a system update. The user had to reinstall the system each time to update the system components not distributed by Debian.  \nThe repositories used were those of Debian, which forced me with each new thing to correct / do / integrate to publish a new ISO and have to reinstall the system (can also be used live, but not able to update via APT is very restrictive).\nThis update system is totally outdated and difficult to manage, what is more, the system gets heavier because each package was added by hand, and a lot of flourishes were added as versions were released. This update system has been released for distributing updates in **rolling** mode.","ref":"update.html#alpha-and-beta"},{"type":"extras","title":"Rolling - Kaisen Linux updates","doc":"This update system distributes continuously via the kaisen-rolling repository all updates from Debian testing. This is the mode of updates closest to a rolling distribution. This is the mode we have chosen unlike LTS. It is the distribution mode that I prefer, and the rest of the team joined this opinion, the stable version of Kaisen Linux (called rolling) is therefore based on this model.","ref":"update.html#rolling"},{"type":"extras","title":"How to update rolling release - Kaisen Linux updates","doc":"All methods are listed here: [Update Kaisen Linux Rolling](https://kaisenlinux.org/documentation/tips-and-tricks#update-kaisen-linux-rolling)","ref":"update.html#how-to-update-rolling-release"},{"type":"extras","title":"Know my version - Kaisen Linux updates","doc":"open terminal:\n\n```bash\ncat /etc/kaisen_version\n```","ref":"update.html#know-my-version"},{"type":"extras","title":"Kaisen Conky","doc":"# Kaisen Conky","ref":"kaisen-conky.html"},{"type":"extras","title":"What is Kaisen Conky? - Kaisen Conky","doc":"Kaisen Conky is a package created for Kaisen Linux installing the Conky software and the theme created for Kaisen Linux. Conky is a desktop widget that displays information about processes in use, battery percentage, network connection status, disk space used, and more!","ref":"kaisen-conky.html#what-is-kaisen-conky"},{"type":"extras","title":"Informations on the conky theme - Kaisen Conky","doc":"","ref":"kaisen-conky.html#informations-on-the-conky-theme"},{"type":"extras","title":"How install Conky? - Kaisen Conky","doc":"Conky can be installed with the kaisen-conky package. This package will install the Conky and conkycolors software and their dependencies. The conky configuration is then copied to `/etc/skel` and this automatically copied to the `/home/$USER` directory of all users on the system.","ref":"kaisen-conky.html#how-install-conky"},{"type":"extras","title":"How to update conky? - Kaisen Conky","doc":"When the kaisen-conky package is updated, the theme will be automatically updated in all user directories having their directory in /home.\n\n### Launch conky with a custom theme\nIt's easy to run your own conky setup. You must modify the conffile `/etc/xdg/autostart/kaisen-conky.desktop` This file contains this by default:\n\n```bash\n[Desktop Entry]\nName=Kaisen Linux Conky\nExec=/usr/bin/conky\nHidden=false\nType=Application\nX-KDE-Autostart-enabled=true\nX-LXQT-Autostart-enabled=true\nX-MATE-Autostart-enabled=true\nX-XFCE-Autostart-enabled=true\n```\n\nIn this example, your conky configuration file will be called: `.myconkyconf`\n\nYou will simply have to replace the file like this:\n\n```bash\n[Desktop Entry]\nName=Kaisen Linux Conky\nExec=/usr/bin/conky --config ~/.conkyconf\nHidden=false\nType=Application\nX-KDE-Autostart-enabled=true\nX-LXQT-Autostart-enabled=true\nX-MATE-Autostart-enabled=true\nX-XFCE-Autostart-enabled=true\n```\n\nThe next time you start conky, your own configuration will be executed. If it does not perform as you expect, it could probably be an error in your configurations.  \nWhen updating the kaisen-kde, kaisen-lxqt, kaisen-mate or kaisen-xfce package, select the option \"N\" or \"O\" to keep your configurations.","ref":"kaisen-conky.html#how-to-update-conky"},{"type":"extras","title":"Disable conky launch - Kaisen Conky","doc":"You cannot therefore remove the conky-all package, otherwise you risk removing your entire GUI.  \nBut do not panic ! You have a very easy way to not start conky even if it is installed.  \nYou must go and modify the file: `/etc/xdg/autostart/conky.desktop`.  \n\nThis file contains this by default:\n\n```bash\n[Desktop Entry]\nName=Kaisen Linux Conky\nExec=/usr/bin/conky\nHidden=false\nType=Application\nX-KDE-Autostart-enabled=true\nX-LXQT-Autostart-enabled=true\nX-MATE-Autostart-enabled=true\nX-XFCE-Autostart-enabled=true\n```\n\nJust replace the line `Hidden=false` with `Hidden=true` to completely disable launching Conky (the process won't even be started, conky, so it won't consume any resources.)  \n\nSo the file will look like:\n\n```bash\n[Desktop Entry]\nName=Kaisen Linux Conky\nExec=/usr/bin/conky\nHidden=true\nType=Application\nX-KDE-Autostart-enabled=true\nX-LXQT-Autostart-enabled=true\nX-MATE-Autostart-enabled=true\nX-XFCE-Autostart-enabled=true\n```\n\nWhen updating the kaisen-kde, kaisen-lxqt, kaisen-mate or kaisen-xfce package, select the option \"N\" or \"O\" to keep your configurations.","ref":"kaisen-conky.html#disable-conky-launch"},{"type":"extras","title":"Problems with KDE desktop - Kaisen Conky","doc":"I have seen some issues with KDE.  \nThe conky is initially configured to be completely transparent and integrated into the wallpaper. KDE is initially configured to start programs that were not closed from the previous session, and Conky is one of them.  \nKaisen Linux's default profile disables this feature by default by opening an empty session each time the computer is started/restarted.  \nTo turn off the restore from the previous session, do this:  \nGo to ```\"System Settings\" => \"Startup and Shutdown\" => \"Desktop Session\" after select \"Start with an empty session\".```","ref":"kaisen-conky.html#problems-with-kde-desktop"},{"type":"extras","title":"Relaunch conky manually - Kaisen Conky","doc":"Sometimes, Conky may not automatically relaunch after a package update. To relaunch it, it is very simple. Open a terminal window, and type this command:  \n\n```bash\nconky&\n```\nNext this command, press `ctrl +D` until closing the terminal. Conky is now relaunched.","ref":"kaisen-conky.html#relaunch-conky-manually"},{"type":"extras","title":"Completely uninstall Conky - Kaisen Conky","doc":"Conky like almost all of the tools pre-integrated in Kaisen Linux can be uninstalled manually via an APT command.  \nFor Conky, do this: ```sudo apt remove --purge kaisen-conky```","ref":"kaisen-conky.html#completely-uninstall-conky"},{"type":"extras","title":"ZSH","doc":"# ZSH","ref":"zsh.html"},{"type":"extras","title":"ZSH on Kaisen Linux - ZSH","doc":"On Kaisen Linux, ZSH is preinstalled by default with the oh-my-zsh framework. This allows for improved completion, many plugins and so much more!","ref":"zsh.html#zsh-on-kaisen-linux"},{"type":"extras","title":"Use ZSH for simple user - ZSH","doc":"Kaisen Linux's default terminal is Bash. Bash is suitable for the majority of users and it is for this reason that it has become the default terminal since Kaisen 2.1.  \nYou are only one user and you only have one account installed, use the following command (as your user and not as root):  \n\n```bash\nchsh -s /bin/zsh\n```\n\nThe next time you reconnect to your session, you will be back in ZSH.","ref":"zsh.html#use-zsh-for-simple-user"},{"type":"extras","title":"Multiple user method - ZSH","doc":"","ref":"zsh.html#multiple-user-method"},{"type":"extras","title":"Useradd command - ZSH","doc":"Type this when adding a user with the useradd command to give them the ZSH shell by default:\n\n```bash\nsudo useradd -s /bin/zsh user\n```","ref":"zsh.html#useradd-command"},{"type":"extras","title":"Modify useradd configuration - ZSH","doc":"In the file `/etc/default/useradd`, change the following line:\n\n```bash\nSHELL=/bin/bash\n```\n\nIn:\n\n```bash\nSHELL=/bin/zsh\n```\n\nAfter that, with the useradd command the bash shell will be set by default, and you will no longer need to specify -s option.  \nWhen updating the shadow package, select the option \"N\" or \"O\" to keep your configurations.","ref":"zsh.html#modify-useradd-configuration"},{"type":"extras","title":"Adduser command - ZSH","doc":"Type this when adding a user with the adduser command to give them the bash shell by default:\n\n```bash\nsudo adduser --shell /bin/zsh user\n```","ref":"zsh.html#adduser-command"},{"type":"extras","title":"Modify adduser configuration - ZSH","doc":"In the file `/etc/adduser.conf`, change the following line:\n\n```bash\nDSHELL=/bin/bash\n```\n\nIn:\n\n```bash\nDSHELL=/bin/zsh\n```\n\nAfter that, with the adduser command the bash shell will be set by default, and you will no longer need to specify --shell option.\nWhen updating the adduser package, select the option \"N\" or \"O\" to keep your configurations.","ref":"zsh.html#modify-adduser-configuration"},{"type":"extras","title":"Cryptsetup nuke password","doc":"# Cryptsetup-nuke-password","ref":"cryptsetup-nuke-password.html"},{"type":"extras","title":"What cryptsetup-nuke-password - Cryptsetup nuke password","doc":"The software cryptsetup-nuke password is a software developed by Offensive Security and publish under GPLv3 licence. This software provides additional security at cryptsetup.  \nIt allows to define an additional password which can also be typed in the cryptsetup password prompt, but allows to destroy the decryption key of the cryptsetup volumes in order to prevent its unlocking.","ref":"cryptsetup-nuke-password.html#what-cryptsetup-nuke-password"},{"type":"extras","title":"How to configure cryptsetup-nuke-password - Cryptsetup nuke password","doc":"In the menu of miscellaneous tools, there is an entry for the command ```sudo dpkg-reconfigure cryptsetup-nuke-password```.  \nThis command will open an ncurses window and allow you to set a password, keep the current one or simply delete it.  \nOnce a password is set, it can be typed at the cryptsetup password prompt when the computer starts up. This typed password will indicate invalid password, but will also indicate on the password defined during the encryption with cryptsetup as invalid because the decryption keys will have been destroyed.  \nUse only with full knowledge of the facts and consequences associated with this functionality. We will not be responsible for damage to your systems in the event of improper handling.  \nTo remove the set password, simply re-run the ```sudo dpkg-reconfigure cryptsetup-nuke-password``` command and select \"delete current password\".","ref":"cryptsetup-nuke-password.html#how-to-configure-cryptsetup-nuke-password"},{"type":"extras","title":"Backing up the encryption key - Cryptsetup nuke password","doc":"If you plan to use this nuke password, you should consider\nsave the luks header. This can be useful for example when you travel with your business computer and even encrypted contains sensitive information about the information system in which you are working.  \nYou can delete and then restore the header without losing access to your data.  \n\n```sudo cryptsetup luksHeaderBackup   --header-backup-file  ```\n\nTo later restore the header, you will have to do:\n\n```sudo cryptsetup luksHeaderRestore   --header-backup-file  ```","ref":"cryptsetup-nuke-password.html#backing-up-the-encryption-key"},{"type":"extras","title":"Prerequisite - Cryptsetup nuke password","doc":"You must install the distribution to take advantage of the functionality offered by nuke, the live system does not support nuke configuration because it cannot regenerate the initrd on our official images.","ref":"cryptsetup-nuke-password.html#prerequisite"},{"type":"extras","title":"GNS3 utilization","doc":"# GNS3 Utilization","ref":"gns3-utilization.html"},{"type":"extras","title":"Enable the server daemon - GNS3 utilization","doc":"By default, the daemon installed by the gns3-server package necessary to enable the GNS3 server is disabled. To enable this daemon, you can run the ```/usr/share/kaisen-services-management/gns3-enable``` if the kaisen-services-management package is installed on your system.  \n\nIt is also possible to enable this service by running the ```sudo systemctl start gns3-server``` command, only to start the service or running the ```sudo systemctl enable --now gns3-server``` to start and activate the daemon at system startup.","ref":"gns3-utilization.html#enable-the-server-daemon"},{"type":"extras","title":"Using the GNS3 client with a remote server - GNS3 utilization","doc":"If you need to use GNS3 with a remotely server connexion, you can create a GNS3 project directly in your home directory.\n\nThe GNS3 daemon must be disabled for this use case.","ref":"gns3-utilization.html#using-the-gns3-client-with-a-remote-server"},{"type":"extras","title":"Using the GNS3 client with the GNS3 server on the localhost - GNS3 utilization","doc":"If you need to use GNS3 with the GNS3 server installed and used directly on the localhost, the GNS3 server only accepts to write in the **/var/lib/gns3** directory, because the gns3-server package was built to automatically add all usable users on the system in the GNS3 group. You can create a GNS3 project in the **/var/lib/gns3** directory.\n\nThe GNS3 daemon must be enabled for this use case.","ref":"gns3-utilization.html#using-the-gns3-client-with-the-gns3-server-on-the-localhost"},{"type":"extras","title":"GNS3 server configuration - GNS3 utilization","doc":"The configuration file for the GNS3 server can be found here: ```/var/lib/gns3/gns3_server.conf```. In this configuration file, you can set many settings like the TCP port or the IP address.","ref":"gns3-utilization.html#gns3-server-configuration"},{"type":"extras","title":"Windows bootable USB key","doc":"# Windows USB key\n\n**How to create a USB bootable key for Windows system**","ref":"windows-bootable-usb-key.html"},{"type":"extras","title":"Why no tool planned for? - Windows bootable USB key","doc":"The first beta versions of Kaisen Linux included the WoeUSB tool which created a bootable Windows USB key. However, as mentioned on the blog, version 20200206 removes WoeUSB because it caused the impossibility of correctly installing GRUB in UEFI because WoeUSB requires as dependency grub-pc and the latter conflicts with grub-efi therefore caused the error when installing GRUB.","ref":"windows-bootable-usb-key.html#why-no-tool-planned-for"},{"type":"extras","title":"This method - Windows bootable USB key","doc":"The method that will be presented here, will be the easiest way to create a bootable Windows USB key.  \nHowever, there are 2 prerequisites.  \n\n```bash\n*A USB key of 8GB minimum formatted as ntfs\n*Windows 10 ISO\n```\n\nTo format your USB key from a GNU/Linux system, I refer you to this tutorial, very simple and clear, on the tool Gparted\nKaisen Linux provides the Engrapa archive manager allowing to extract also .iso files in a folder.  \n\nTo do this, right click on your Windows 10 ISO, and do 'Extract here' and you will have a folder with the same name as the Windows 10 ISO.  \n\nOpen this folder and copy and paste all the content of the latter on your ntfs formatted USB key.  \n\nOnce the process is complete, you should be able to start on your USB drive.","ref":"windows-bootable-usb-key.html#this-method"},{"type":"extras","title":"WoeUSB method - Windows bootable USB key","doc":"The WoeUSB tool integrated by default in the SR version of Kaisen Linux and which can be installed via APT on the installed system, allows to install a Windows bootable USB key with UEFI and classic BIOS support. \nIn this example, the USB stick is /dev/sdb as device file. To use WoeUSB to create a bootable key:\n```woeusb --device Windows10_x64.iso /dev/sdb```","ref":"windows-bootable-usb-key.html#woeusb-method"},{"type":"extras","title":"Bad sectors analyses","doc":"# Bad sectors analyses\n\n**This section is intended to explain how to analyze bad storage space on a storage device.**","ref":"bad-sectors-analyses.html"},{"type":"extras","title":"Softwares - Bad sectors analyses","doc":"### gsmartcontrol\nYou can use gsmartcontrol for analyse general condition of the hard drive or SSD. It uses the smartmontools service to display the health status of the storage device. This software have GUI and a lot informations are given.  \nGsmartcontrol will not display the number of bad sectors, but the SMART of the hard disk will indicate a problem with storage sectors.  He is rarely mistaken, but a false positive is possible. Use badblocks to perform an additional test.  \n\n### badblocks\nYou can use badblocks tools with fdisk to detect bad sectors of a storage device. Follow this guide:\n\n```bash\n* sudo fdisk -l (spot storage device at analyse, for example /dev/sda)\n* sudo badblocks -v /dev/sda\n```\n\nThis command display in stdout bad sectors. If not sector display (for example, 250059, 250059095 etc), is that there is not bad sector.","ref":"bad-sectors-analyses.html#softwares"},{"type":"extras","title":"whdd - Bad sectors analyses","doc":"You can use whdd to detect bad sectors of a storage device. WHDD is a tool with a ncurses interfaces and can support SATA, memory card and NVME disks!\nTo start whdd, you can launch this command : ```sudo whdd``` and select the disk to analyze.","ref":"bad-sectors-analyses.html#whdd"},{"type":"extras","title":"Repair GRUB","doc":"# GRUB repair\n\n**GRUB repair with CLI method**  \nOnce the system is installed but after the impossibility of installing GRUB on a system in UEFI, here is the procedure to follow for the installer according to your partitioning.  \n\nYou can help yourself with Gparted software for this tutorial.  \n\nOnly the CLI method will be presented, because it is the most efficient, relevant, and few tools or none can replace this method.","ref":"grub-repair.html"},{"type":"extras","title":"GRUB EFI - Repair GRUB","doc":"","ref":"grub-repair.html#grub-efi"},{"type":"extras","title":"Classic partition - Repair GRUB","doc":"```bash\nsudo fdisk -l (Locate the EFI Linux partition and /)\nsudo mount /dev/sdX /mnt (X represents the drive letter)\nfor mountpoints in /dev/ /dev/pts/ /proc/ /sys/; do sudo mount --bind $mountpoints /mnt/$mountpoints; done\nsudo mount /dev/sdXY /mnt/boot/efi (X represents the drive letter, and the Y the EFI partition number, it should be the first)\nsudo apt install grub-efi-amd64\nsudo cp -rvf /usr/lib/grub/x86_64-efi /mnt/usr/lib/grub/ or sudo cp -rvf /usr/lib/grub/x86_64-efi-signed /mnt/usr/lib/grub/\nsudo chroot /mnt\ngrub-install --target=x86_64-efi /dev/sdX\nupdate-grub (cancel the operation in progress at the time it makes Warning (impossible to update the GRUB entries via \nos-prober which is normal in chrooted environment) \nmv /boot/grub/grub.cfg.new /boot/grub/grub.cfg\nexit\nsudo reboot\n```\n\nOnce the system has started, reinstall GRUB correctly with:\n\n```bash\nsudo apt install grub-efi\n```\nThe problem should be solved","ref":"grub-repair.html#classic-partition"},{"type":"extras","title":"LVM without LUKS encryption - Repair GRUB","doc":"```bash\nsudo fdisk -l (Locate the EFI Linux partition and /)\nsudo vgscan\nsudo vgchange -ay\nsudo mount /dev/mapper/name--vg-root /mnt (name--vg-root represents the name of the logical volume returned by the vgscan command)\nsudo mount /dev/sdXY /mnt/boot (mount boot partition)\nfor mountpoints in /dev/ /dev/pts/ /proc/ /sys/; do sudo mount --bind $mountpoints /mnt/$mountpoints; done\nsudo mount /dev/sdXY /mnt/boot/efi (mount the EFI partition often, this partition is often the first)\nsudo apt install grub-efi-amd64\nsudo cp -rvf /usr/lib/grub/x86_64-efi /mnt/usr/lib/grub/ or sudo cp -rvf /usr/lib/grub/x86_64-efi-signed /mnt/usr/lib/grub/ \nsudo chroot /mnt\ngrub-install --target=x86_64-efi /dev/sdX\nupdate-grub (close the terminal 20 seconds after the execution of the command, because it will normally run in a vacuum)\nexit\nsudo reboot \n```\n\nCAUTION:  \n\nIf the update-grub is spinning, after running sudo reboot, restart the live, and do the following steps:  \n\n```bash\nsudo vgscan\nsudo vgchange -ay\nsudo mount /dev/mapper/name--vg-root /mnt (name--vg-root represents the name of the logical volume returned by the vgscan command)\nsudo mount /dev/sdX /mnt/boot (mount boot partition)\nfor mountpoints in /dev/ /dev/pts/ /proc/ /sys/; do sudo mount --bind $mountpoints /mnt/$mountpoints; done\nsudo chroot /mnt\nupdate-grub\nexit\nsudo reboot\n```\n\nOnce the system has started, reinstall GRUB correctly with:  \n\n```bash\nsudo apt install grub-efi\n```\n\nThe problem should be solved","ref":"grub-repair.html#lvm-without-luks-encryption"},{"type":"extras","title":"LVM with LUKS encryption - Repair GRUB","doc":"```bash\nsudo fdisk -l (Locate the EFI Linux partition and /)\nsudo cryptsetup luksOpen /dev/sdXY sdxy_crypt (X represents the drive letter, Y the partition / encrypted number)\nsudo vgscan\nsudo vgchange -ay\nsudo mount /dev/mapper/name--vg-root /mnt (name--vg-root represents the name of the logical volume returned by the vgscan command)\nsudo mount /dev/sdXY /mnt/boot (mount boot partition)\nfor mountpoints in /dev/ /dev/pts/ /proc/ /sys/; do sudo mount --bind $mountpoints /mnt/$mountpoints; done\nsudo mount /dev/sdXY /mnt/boot/efi (mount the EFI partition often /dev/sdX1)\nsudo apt install grub-efi-amd64\nsudo cp -rvf /usr/lib/grub/x86_64-efi /mnt/usr/lib/grub/ or sudo cp -rvf /usr/lib/grub/x86_64-efi-signed /mnt/usr/lib/grub/\nsudo chroot /mnt\ngrub-install --target=x86_64-efi /dev/sdX\nupdate-grub (close the terminal 20 seconds after the execution of the command, because it will normally run in a vacuum)\nexit\nsudo reboot \n```\n\nCAUTION:  \n\nIf the update-grub is running in a vacuum, restart the system, and do the following steps:  \n\n```bash\nsudo fdisk -l (Locate the EFI Linux partition and /)\nsudo cryptsetup luksOpen /dev/sdXY sdxy_crypt (X represents the drive letter, Y the partition / encrypted number)\nsudo vgscan\nsudo vgchange -ay\nsudo mount /dev/mapper/name--vg-root /mnt (name--vg-root represents the name of the logical volume returned by the vgscan command)\nsudo mount /dev/sdX /mnt/boot (mount boot partition)\nfor mountpoints in /dev/ /dev/pts/ /proc/ /sys/; do sudo mount --bind $mountpoints /mnt/$mountpoints; done\nsudo chroot /mnt\nupdate-grub\nexit\nsudo reboot\n```\n\nOnce the system has started, reinstall GRUB correctly with:\n\n```bash\nsudo apt install grub-efi\n```\n\nThe problem should be solved","ref":"grub-repair.html#lvm-with-luks-encryption"},{"type":"extras","title":"Kaisen Terminal shortcuts","doc":"# Convenient Kaisen Terminal shortcuts","ref":"terminal-shortcuts.html"},{"type":"extras","title":"Kaisen Terminal? - Kaisen Terminal shortcuts","doc":"The Kaisen Terminal launcher is actually just the **terminator** terminal emulator (written in Python) which is executed, but has been fully customized. This tool is great because it has a lot of features including the main one which is device deduplication.\n\n## Main keyboard shortcuts\nTo open a new tab from the current terminal window, use the command:\n\n```bash\nCTRL + T\n```\nTo quickly open a new terminal window, do:\n\n\n```bash\nCTRL + I\n```\nTo split the terminal into two or more horizontally, use this combination:\n\n\n```bash\nCTRL + O\n```\nTo split the terminal into two or more vertically, use this combination:\n\n```bash\nCTRL +E\n```\n\n## Tips\nOn the default Terminator setup on the distro, the scroll bar is disabled, and you might need it. To activate it, nothing could be simpler do this:\n\n```bash\nRight click + Show scrollbar\n```\n\nThis will activate the scroll bar and can be turned on and off at will.\n\nOn the default configuration, windows open in full screen. You can also change this setting by right-clicking on the terminal window and clicking **Preferences**.  \n\n```bash\nThen on the global tab, replace the value in Windows state.\n```\n\nTo change the background color, transparency or color of the text, you can as before right click on the terminal window, and click on Preferences. In the Profiles tab, you have access to many parameters such as the background, the colors, and also have the possibility of creating as many profiles and therefore parameters as you wish.  \n\nTo make your settings effective on all users on your system, you can copy the following path to /etc/skel_user:  \n\n```bash\ncp -rf ~/.config/terminator /etc/skel_user\n```\n\nThen use the kaisen-update-skel-user command to update this theme for all your users.","ref":"terminal-shortcuts.html#kaisen-terminal"},{"type":"extras","title":"Advanced BTRFS utilization","doc":"# Advanced BTRFS utilisation","ref":"advanced-btrfs-utilization.html"},{"type":"extras","title":"Subvolumes - Advanced BTRFS utilization","doc":"","ref":"advanced-btrfs-utilization.html#subvolumes"},{"type":"extras","title":"Explanations - Advanced BTRFS utilization","doc":"A subvolume is a branch of the file system that behaves like a file subsystem. it appears as a directory.  \nIt is thanks to these sub-volumes that the creation of snapshots of a directory is possible.","ref":"advanced-btrfs-utilization.html#explanations"},{"type":"extras","title":"Manual creation - Advanced BTRFS utilization","doc":"To manually create subvolumes to use the snapshost system, we will proceed like this.  \nHere, the subvolumes that will be created are the same as those created by installing Kaisen Linux with an ISO of revision 1.6.  \n\nSubvolumes can be created using commands installed via the btrfs-progs package. This package is installed by default in Kaisen Linux if the kaisen-filesystems package is installed, or if BTRFS is the file system used when installing the system.  \n\nThis command can be used to create BTRFS subvolume:  \n```sudo btrfs subvolume create subvolume_name```","ref":"advanced-btrfs-utilization.html#manual-creation"},{"type":"extras","title":"Deletion - Advanced BTRFS utilization","doc":"To delete a BTRFS subvolume, can you proceed like this:  \n```sudo btrfs subvolume delete subvolume_name```","ref":"advanced-btrfs-utilization.html#deletion"},{"type":"extras","title":"Snapshots - Advanced BTRFS utilization","doc":"","ref":"advanced-btrfs-utilization.html#snapshots"},{"type":"extras","title":"Explanations - Advanced BTRFS utilization","doc":"A snapshot, or restore point, is an image of the file system or one of its subvolumes that you back up at a specific point in time, so that you can access or restore it later. The main goal is to restore a system that has become unstable.\n\nOnce created, a snapshot behaves like an ordinary folder on your file system: you can copy it, move it to external media, rename it...","ref":"advanced-btrfs-utilization.html#explanations-1"},{"type":"extras","title":"Snapshots with BTRFS commands - Advanced BTRFS utilization","doc":"To take a snapshot of the entire system from the command line:  \n```sudo btrfs subvolume snapshot / /opt/snapshot20210330```  \n\nThis command will take a snaphsot from the test subvolume (directory). This frozen version of your directory will be accessible through the \"/opt/snapshot20210330\" directory. The modifications made in each of the two directories are independent. The filesystem manages the changes so that they are transparent to the user (with ext4, it would have been necessary to create a copy of the directory, which would have occupied double the disk space. A snapshot does not consume any additional disk space).","ref":"advanced-btrfs-utilization.html#snapshots-with-btrfs-commands"},{"type":"extras","title":"Restore snapshot - Advanced BTRFS utilization","doc":"To restore the snapshot taken previously, the following command can be used:  \n```sudo btrfs subvolume get-default /```","ref":"advanced-btrfs-utilization.html#restore-snapshot"},{"type":"extras","title":"APT snapshots - Advanced BTRFS utilization","doc":"Before the 2.2RC2 release, snapshots taken by the apt-btrfs-snapshot software. This tool has been dropped because it causes a lot of bugs with systemd (it modified the /etc/fstab file). Also, restored snapshots couldn't be deleted.  \n\nSince the 2.2RC2 release, APT snapshots are handled by the kaisen-timeshift-apt package to fix problems with the previous package used for that (apt-btrfs-snapshot). This tool is the in-house tool developed by the Kaisen Linux team and it's combined with Timeshift to automatically take APT snapshots. The commands to delete or restore a snapshot taken by kaisen-timeshift-apt are the same as those of Timeshift.  \n\nWhenever APT is used for a package update or installation, a snapshot will be automatically taken.  \n\nIf an upgrade or a package installation goes wrong it is easy to go back with these commands:  \n```sudo timeshift --list```  \n\nThis command will list all snapshots taken by apt-btrfs-snapshot.  \nThe names of the snapshots look like this:  \n```2022-10-23_22-36-46```\n\nWe want to restore the snapshot with the name mentioned above. For that, we will type the command:   \n```sudo timeshift --restore --snapshot 2022-10-23_22-36-46```  \nAt the next restart, all changes made to the packages will be reverted.\n\nTo delete all snapshots taken by apt-btrfs-snapshot, you must type this command as root or via sudo:  \n```sudo timeshift --delete-all```\n\nTo delete a specific snapshots with its name, type this command:  \n```sudo timeshift --delete --snapshot 2022-10-23_22-36-46```\n\nThis functionality can also be completely removed by fully uninstalling the package. In this case, you have to run this command:  \n```sudo apt remove --purge kaisen-timeshift-apt```  \n\nA systemd timer and service are installed by default to remove automatically all snapshots older than 7 days. Manual deletion isn't required, but it's possible to delete them manually.\nSnapshots restored can also be deleted with the timeshift --remove command.","ref":"advanced-btrfs-utilization.html#apt-snapshots"},{"type":"extras","title":"The kaisen-snapshot command - Advanced BTRFS utilization","doc":"In version 3.0, the **kaisen-snapshot** command was created. This command is a wrapper for timeshift, making it easier to use on a daily basis.\n\nExamples of commands to use with the **kaisen-snapshot** command:\n\n- kaisen-snapshot **-c** (or **--create**): Create a snapshot\n- kaisen-snapshot **-m** (or **--message**): Custom message for a snapshot (**Perso** is the default value, if this argument is not used)\n- kaisen-snapshot **-d** (or **--delete**): Delete a snapshot\n- kaisen-snapshot **-a** (or **--delete-all**): Delete all snapshots\n- kaisen-snapshot **-r** (or **--restore**): Restore a snapshot\n- kaisen-snapshot **-l** (or **--list**): List all snapshots taken\n\nExamples:\n\n- Create a snapshot without custom message:\n```sudo kaisen-snapshot -c```\n\n- Create a snapshot with the message **Test**:\n```sudo kaisen-snapshot -m \"Test\" -c``` or ```sudo kaisen-snapshot -c -m \"Test\"```\n\n- Delete all snapshots taken:\n```sudo kaisen-snapshot -a```","ref":"advanced-btrfs-utilization.html#the-kaisen-snapshot-command"},{"type":"extras","title":"The grub-btrfs package - Advanced BTRFS utilization","doc":"Since the 2.2RC2 release, the grub-btrfs package is included by default when Kaisen uses BTRFS as default filesystem. The grub-btrfs package allows to boot on a previously created snapshot directly from the GRUB menu! All taken snapshots will can be restored from the started snapshot!  \n\nTo restore a snapshot, you should use the BTRFS commands or the commands or the commands of the software used to take the snapshots (Timeshift for example, also works with snapshots taken automatically by kaisen-timeshift-apt).  \n\nOn Kaisen Linux, the focus has been on Timeshift to automate the addition to the GRUB menu of BTRFS snapshots taken or deleted with Timeshift (also works with those taken with kaisen-timeshift-apt).  \n\nAll snapshots that are taken or deleted will be automatically added to the GRUB menu via a systemd service within 15 seconds! You don't have to do anything except manage your system as you wish!  \n\nWe therefore advise you to use Timeshift to create and manage your BTRFS snapshots.\n\n### Snapshots with Timeshift\nSnapshots with Timeshift, software available in CLI or GUI, the snapshots can be taken much more easily that with btrfs-progs commands.  \nWe recommend the use of Timeshift to take and restore snapshot of your system.  \n\nRemember to regularly delete your BTRFS snapshots taken with Timeshift, they can take up considerable space on your storage device.  \n\nThe timeshift manpage is available on Kaisen as well as all related documentation.\n\n### Restore snapshots from a chrooted environment\nIn case of a major crash (if your system does not boot), if the grub-btrfs software does not display anything, GRUB is not accessible, or an error has occurred, you can potentially recover your system from a [chrooted environment](create-chroot.html). There are many potential causes. In case of difficulties, the Kaisen Linux discussion groups or the official community forum can help you.\n\n## Recommendations for BTRFS\nThis is not enabled by default for performance reasons as well as to avoid premature wear, automated defragmentation is disabled.  \nIt is advisable to defragment BTRFS volumes at least every 6 months (CoW can create significant fragmentation), even on SSDs.  \nDelete the snapshots first, and then type the command (in case you have BTRFS installed on the root):  \n```sudo btrfs filesystem defragment -rv /```  \n\nYou can also use the btrfs-balance-least-used command to rebalance unbalanced pieces of data. Running this command can potentially allow for the recovery of space on the disk.    \n\nExample for the / partition :  \n```btrfs-balance-least-used /```","ref":"advanced-btrfs-utilization.html#the-grub-btrfs-package"},{"type":"extras","title":"Docker with BTRFS - Advanced BTRFS utilization","doc":"Docker on Kaisen Linux has been packaged to support the use of BTRFS. For this, Docker has been packaged to use the overlay2 driver as default driver, even if BTRFS is the filesystem used. So you can safely use Docker with BTRFS!","ref":"advanced-btrfs-utilization.html#docker-with-btrfs"},{"type":"extras","title":"Create chroot","doc":"# Create chroot","ref":"create-chroot.html"},{"type":"extras","title":"Explanations - Create chroot","doc":"The chroot creation permit to be able to restore a damaged system, while mounting its damaged system on mount points (example /mnt /folder), and to execute the chroot command to \"lock itself\" on the mounted system and thus be able to work on it as if it was started.\nThis is mainly useful for systems that can no longer boot conventionally.\n\n## Classic partition\n```bash\nsudo fdisk -l (Locate the EFI Linux partition and /)\nsudo mount /dev/sdX /mnt (X represents the drive letter)\nfor mountpoints in /dev/ /dev/pts/ /proc/ /sys/; do sudo mount --bind $mountpoints /mnt/$mountpoints; done\nsudo mount /dev/sdXY /mnt/boot/efi (X represents the drive letter, and the Y the EFI partition number, it should be the first)\nsudo chroot /mnt\n```","ref":"create-chroot.html#explanations"},{"type":"extras","title":"LVM without LUKS encryption - Create chroot","doc":"```bash\nsudo fdisk -l (Locate the EFI Linux partition and /)\nsudo vgscan\nsudo vgchange -ay\nsudo mount /dev/mapper/name--vg-root /mnt (name--vg-root represents the name of the logical volume returned by the \nvgscan command)\nsudo mount /dev/sdXY /mnt/boot (mount boot partition)\nfor mountpoints in /dev/ /dev/pts/ /proc/ /sys/; do sudo mount --bind $mountpoints /mnt/$mountpoints; done\nsudo mount /dev/sdXY /mnt/boot/efi (mount the EFI partition often, this partition is often the first)\nsudo chroot /mnt\n```","ref":"create-chroot.html#lvm-without-luks-encryption"},{"type":"extras","title":"LVM with LUKS encryption - Create chroot","doc":"```bash\nsudo fdisk -l (Locate the EFI Linux partition and /)\nsudo cryptsetup luksOpen /dev/sdXY sdxy_crypt (X represents the drive letter, Y the partition / encrypted number)\nsudo vgscan\nsudo vgchange -ay\nsudo mount /dev/mapper/name--vg-root /mnt (name--vg-root represents the name of the logical volume returned by the vgscan command)\nsudo mount /dev/sdXY /mnt/boot (mount boot partition)\nfor mountpoints in /dev/ /dev/pts/ /proc/ /sys/; do sudo mount --bind $mountpoints /mnt/$mountpoints; done\nsudo mount /dev/sdXY /mnt/boot/efi (mount the EFI partition often /dev/sdX1)\nsudo chroot /mnt\n```","ref":"create-chroot.html#lvm-with-luks-encryption"},{"type":"extras","title":"Virtualbox utilization","doc":"# Virtualbox using on Kaisen","ref":"virtualbox-utilization.html"},{"type":"extras","title":"How to disable entirely KVM module? - Virtualbox utilization","doc":"Since Kaisen 3.0, Virtualbox depends on KVM to works, but if the KVM module is enabled, Virtualbox cannot works.\nTo disable entirely the KVM module, you must to do this:\n\n- If you have an Intel CPU:\n```grep -i \"model name\" /proc/cpuinfo|grep -i \"intel\" && echo \"blacklist kvm_intel\" | sudo tee /etc/modprobe.d/blacklist.conf```\n\n- If you have an AMD CPU:\n```grep -i \"model name\" /proc/cpuinfo|grep -i \"amd\" && echo \"blacklist kvm_amd\" | sudo tee /etc/modprobe.d/blacklist.conf```","ref":"virtualbox-utilization.html#how-to-disable-entirely-kvm-module"},{"type":"extras","title":"Advices - Virtualbox utilization","doc":"When you blacklist this module, you cannot use the native KVM hypervisor. To disable KVM during this session, you must to do this:\n\n- If you have an Intel CPU:\n```sudo rmmod kvm_intel && sudo rmmod kvm```\n\n- If you have an AMD CPU:\n```sudo rmmod kvm_amd && sudo rmmod kvm```","ref":"virtualbox-utilization.html#advices"},{"type":"extras","title":"How to build custom ISO?","doc":"# How to build custom ISO?","ref":"how-to-build-custom-iso.html"},{"type":"extras","title":"kaisen-build - How to build custom ISO?","doc":"A package called kaisen-build has been developed to allow you to build your custom ISO based on Kaisen Linux. It is also this package and the tools it installs that we use to build official releases. The main objective of building your own ISO is to create your own live system and have one more up to date while awaiting official publications from the Kaisen Linux team.\nThe second objective of doing this is to integrate into your live system tools which are not integrated by default in Kaisen Linux and which need to use them on a live system.  \nNote that creating a custom ISO also includes the Debian installer (default configuration provided by kaisen-build) customized by us (graphic theme, file systems, partitioning, preseed etc ...). Doing this is not useful for having a newer installable system, just do apt update && apt upgrade to have your system constantly updated and with your software installed.\nWe advise you to use kaisen-build in order to create your own live system.","ref":"how-to-build-custom-iso.html#kaisen-build"},{"type":"extras","title":"The different variants - How to build custom ISO?","doc":"We have the following variants:\n\n```bash\nKDE\nLXQT\nMATE\nXFCE\nSR\nCUSTOM\n```\n\nISO image type:\n\n```bash\nKDE = Live system ISO and included installer with KDE GUI only\nLXQT = Live system ISO and included installer with LXQT GUI only\nMATE = Live system ISO and included installer with MATE GUI only\nXFCE = Live system ISO and included installer with XFCE GUI only\nSR = Live system ISO and not installer included with XFCE GUI only\nNETINST = Create NETINSTALLER ISO\nCUSTOM = Live system ISO and included installer for user ISO settings\n```\n\nThese variants include tools:\n\n```bash\nKDE = All metapackages are included on this variant\nLXQT = All metapackages are included on this variant\nMATE = All metapackages are included on this variant\nXFCE = All metapackages are included on this variant\nNETINST = Base system and metapackages installed by users\nSR = All technicians, filesystems, miscellaneous, firmwares are included on this variant\nCUSTOM = Variant pre-configured, but no integrated tool. Variant reserved for the user, the user parameters will be kept.\n```","ref":"how-to-build-custom-iso.html#the-different-variants"},{"type":"extras","title":"How to proceed? - How to build custom ISO?","doc":"Install kaisen-build with the `sudo apt install kaisen-build` command. The package will install live-build (a set of scripts used by Debian to build their official ISO images, which we also use), live-manual and live-doc which will help you get started with the live-build configuration and customize your ISO, live-boot to start your live.  \nOnce the package is installed, in `/home/*` you will have a folder named **kaisen-build**.  \nIn the `kaisen-build/variant/` folder, there is the folder named **CUSTOM**. This folder is reserved for you so that you can make your ISO live and installable (these options are by default in the live-build configuration file that I do not recommend that you modify), this file is complete and some options are already preconfigured like official Kaisen Linux packages, GUIs, as well as the Debian Installer [preseed](install.html#example-of-preseed-file) file.  \nIn the event of an update, or even in the event of accidental deletion of the package and after a reinstallation, all the modifications made on the custom branch will be kept, thanks to an automated backup and automatic restoration of the CUSTOM branch in the installation process of the package.  \nThis is why I strongly advise you not to create your ISO by customizing another variant than CUSTOM because your modifications will be lost in the event of an update of kaisen-build.  \nOnce your branch is fully configured, you can run a compilation at the root of the kaisen-build folder, with the command:\n\n```bash\nsudo ./kaisen-build -v CUSTOM -r 1.0\n```\n\nVersion 1.0 is an example, but you can put whatever you want, I advise you not to put too many letters and numbers because if the name of the ISO volume exceeds 32 characters, the compilation will crash. The name of the ISO volume is \"Kaisen Linux Rolling $variant $version\" ($variant corresponds here to CUSTOM and $version corresponds here to 1.0), in the example, the name of the ISO volume will be Kaisen Linux Rolling CUSTOM 1.0.","ref":"how-to-build-custom-iso.html#how-to-proceed"},{"type":"extras","title":"Support - How to build custom ISO?","doc":"Please be aware that **we will not provide support to users wishing to create their own ISO**. Not that we don't want to help you, but we are very busy professionally and on the constant development of Kaisen Linux.","ref":"how-to-build-custom-iso.html#support"},{"type":"extras","title":"Warning on personal images - How to build custom ISO?","doc":"One of the strengths of the GNU/Linux world, which we follow to give our users the choice to do what they want with the environment we provide them so that they can adapt it to their needs, is also a problem because the integration of malware, trackers or others can be facilitated.  \nTo avoid this kind of inconvenience, do not download an ISO image outside the following two mirrors: https://iso.kaisenlinux.org and https://iso.kaisenlinux.xyz    \nAlso check the SHA256 checksums indicated on the official website.\nSo keep your images created by yourself for yourself, and do not use ISOS images whose origin thereof is not a certainty (check the checksums on the site to be sure).","ref":"how-to-build-custom-iso.html#warning-on-personal-images"},{"type":"extras","title":"Update CUSTOM branch - How to build custom ISO?","doc":"If you want to start from scratch or update the CUSTOM branch to have our latest pre-configuration (although changes are rare), you must uninstall and completely purge the package then reinstall it.  \nTo do this, you have to run this command:  \n\n```bash\nsudo apt remove --purge kaisen-build\n```\n\nYou will just have to reinstall the package and you will be on the last pre-configuration of the CUSTOM branch.  \nBe careful, this action will delete your settings from the CUSTOM branch (even the automated backups, so that they are not reapplied when the package is reinstalled). Be sure what you are doing, manually save your settings beforehand if you want to keep your settings.","ref":"how-to-build-custom-iso.html#update-custom-branch"},{"type":"extras","title":"How to change graphical interface?","doc":"# How to change graphical interface?","ref":"how-to-change-graphical-interface.html"},{"type":"extras","title":"To do what? - How to change graphical interface?","doc":"The KDE, LXDE and XFCE interfaces arrived some time after the first versions, and migrating to a new graphical interface is not easy.\nYou have to purge the old one (not mandatory, but avoids overloading the system and avoiding potential conflicts), and install the new interface.  \nA package has been created for each GUI officially supported by Kaisen Linux installing all of the predefined configurations.  \nFor this a tool has been created to do it simply and fully automated!  \nThis tool was also created so that the user does not come to reinstall his OS in the event of difficulties.","ref":"how-to-change-graphical-interface.html#to-do-what"},{"type":"extras","title":"kaisen-interface-switcher - How to change graphical interface?","doc":"The script since Kaisen Linux 1.4 revision is designed when the script starts up (after all checks have been made), to update itself if a new, more recent version of the script (installed by the kaisen-kde package, kaisen-lxde, kaisen-mate, kaisen-xfce depending on your current GUI). This is intended if you do not update often, to be able to change your interface and update the list of packages to uninstall. The main purpose of this is to automate the task even more, saving you time.  \nThe kaisen-interface-switcher script allows you to change your graphical interface by installing the one of your choice by removing your current graphical interface. It can be started by the `sudo kaisen-interface-switcher` command.  \nThe first versions of this script reinstalled for each user the default profile of each interface (execution of the kaisen-interface-switcher command during the script) but this lost the personalization of the user if he wishes to reinstall his graphical interface. 'original (e.g. switching from MATE to KDE then from KDE to MATE).  \nThis problem has been corrected by replacing the installation of a default profile per interface with a package installing the default profile for all graphical interfaces (see [kaisen-skeleton](https://kaisenlinux.org/documentation/packages). You can therefore change the graphical interface at will, without losing a single one of your settings!","ref":"how-to-change-graphical-interface.html#kaisen-interface-switcher"},{"type":"extras","title":"Prerequisites - How to change graphical interface?","doc":"Since the 1.4 revision, the `kaisen-interface-switcher` script has been corrected to fix some issues that occurred when using the script (eg when using wifi or with wrong proxy settings).  \nTo be able to use kaisen-interface-switcher, the script will check two things:  \n- Connectivity to APT (if behind a proxy, only the configuration of the APT proxy is sufficient)\n- The network interface through which network packets pass.\nThe script will remove all packages installed by your current GUI, it will also remove network-manager, and without network-manager the wifi cannot work. This therefore prevented the installation of your new graphical interface, and the old one was deleted, the next time you restart your machine, you would find yourself without a graphical interface.  \nSo I added as many checks as possible to limit the risk of losing the graphic interface during the process. I strongly advise against modifying the script yourself to modify checks or the like unless you know exactly what you are doing.","ref":"how-to-change-graphical-interface.html#prerequisites"},{"type":"extras","title":"How to change login wallpaper?","doc":"# How to change login wallpaper?","ref":"how-to-change-login-wallpaper.html"},{"type":"extras","title":"Text edition method - How to change login wallpaper?","doc":"On MATE, LXQT, XFCE and KDE (defined by default by kaisen-kde postinst script), lightdm manages the login wallpaper. \n\nTo change it, place the command:\n\n```bash\nsudo nano /etc/lightdm/lightdm-gtk-greeter.conf\n```\n\nYou should find this:\n\n```bash\n[greeter]\nbackground = /usr/share/backgrounds/kaisen-lightdm-theme.png\ntheme-name = Kaisen-Dark-Material\nicon-theme-name = Kaisen\ndefault-user-image = /usr/share/pixmaps/kaisen-logos/kaisen.png\nuser-background = false\nfont-name = Cantarell 11\nclock-format = %A %d %B %Y : %H:%M:%S\nindicators = ~spacer;~spacer;~host;~spacer;~session;~clock;~power\n```\n\nChange these lines:\n\n```bash\nbackground = /usr/share/backgrounds/kaisen-lightdm-theme.png\n```\n\nFor example in:\n\n```bash\nbackground = /home/user/Pictures/image.png\n```\n\nWhich will give:\n\n```bash\n[greeter]\nbackground = /home/user/Pictures/image.png\ntheme-name = Kaisen-Dark-Material\nicon-theme-name = Kaisen\ndefault-user-image = /usr/share/pixmaps/kaisen-logos/kaisen.png\nuser-background = false\nfont-name = Cantarell 11\nclock-format = %A %d %B %Y : %H:%M:%S\nindicators = ~spacer;~spacer;~host;~spacer;~session;~clock;~power\n```","ref":"how-to-change-login-wallpaper.html#text-edition-method"},{"type":"extras","title":"Graphic method - How to change login wallpaper?","doc":"The **lightdm-gtk-greeter-settings** tool is integrated by default on MATE, LXQT, XFCE and KDE to be able to easily change the lightdm settings. This will produce the same result as editing the `/etc/lightdm/lightdm-gtk-greeter.conf` file as the software will modify it to reflect your settings made.","ref":"how-to-change-login-wallpaper.html#graphic-method"},{"type":"extras","title":"How to reapply the GUI default profile?","doc":"# How to reapply the GUI default profile?","ref":"how-to-reapply-the-gui-default-profile.html"},{"type":"extras","title":"In what cases? - How to reapply the GUI default profile?","doc":"You might need to update the default profile as provided on the live CD if updating the kaisen-skeleton package.  \nHowever, there are a few things you should know before updating the skel and the two methods of doing so.","ref":"how-to-reapply-the-gui-default-profile.html#in-what-cases"},{"type":"extras","title":"Reapply the KDE default profile - How to reapply the GUI default profile?","doc":"To reapply the default profile for KDE, run this command with your current user to delete your KDE settings:  \n```rm -rf .kde .local/share/konsole .config/{gtkrc,gtkrc-2.0,gtk-3.0,gtk-4.0,kactivitymanagerdrc,katerc,katevirc,kdeglobals,konsolerc,kscreenlockerrc,ksmserverrc,kwinrc,kwriterc,plasmarc,kwalletrc,plasma-org.kde.plasma.desktop-appletsrc,plasmashellrc}```  \n\nTo reapply the default Kaisen settings, run this command with your current user:  \n```cp /etc/skel/.config/{kactivitymanagerdrc,kwalletrc,plasma-org.kde.plasma.desktop-appletsrc,plasmashellrc} ~/.config```  \n\nNow you can log out and log back in.\n\n## Reapply the LXQt default profile\nTo reapply the default profile for LXQt, run this command with your current user to delete your LXQt settings:  \n```rm -rf .config/{lxqt,openbox,cmst,pcmanfm-qt,qterminal.org,featherpad}```  \n\nNow you can log out and log back in.\n\n## Reapply the MATE default profile\nTo reapply the default profile for MATE, run this command with your current user to delete your MATE settings:  \n```rm -rf .config/{dconf,mate}```  \n\nTo reapply the default Kaisen settings, run this command with your current user:  \n```cp /etc/skel/.config/mate ~/.config```  \n\nNow you can log out and log back in.\n\n## Reapply the XFCE default profile\nTo reapply the default profile for XFCE, run this command with your current user to delete your XFCE settings:  \n```rm -rf .config/xfce4```  \n\nNow you can log out and log back in.","ref":"how-to-reapply-the-gui-default-profile.html#reapply-the-kde-default-profile"},{"type":"extras","title":"How to switch to root directly with ZSH?","doc":"# How to switch to root directly with the ZSH terminal?","ref":"how-to-switch-to-root-directly-with-zsh.html"},{"type":"extras","title":"Explanation - How to switch to root directly with ZSH?","doc":"By default, the root user defaults to bash because it is not expected in good practice to be used for human operations, except in cases where there is no choice. It also allows us to be able to chroot at a specific location in the system without having any errors.","ref":"how-to-switch-to-root-directly-with-zsh.html#explanation"},{"type":"extras","title":"Solution - How to switch to root directly with ZSH?","doc":"To go directly to a root terminal, type the following command:\n\n```bash\nsudo zsh\n```","ref":"how-to-switch-to-root-directly-with-zsh.html#solution"},{"type":"extras","title":"Informations on rolling version","doc":"# How do I know the number of the rolling version I use?","ref":"informations-on-rolling-version.html"},{"type":"extras","title":"With \"cat\" method - Informations on rolling version","doc":"Just do the command `cat /etc/kaisen_version` and read the number marked after Rolling to know your version number.","ref":"informations-on-rolling-version.html#with-cat-method"},{"type":"extras","title":"With lsb-release - Informations on rolling version","doc":"Just do the command `lsb_release -r` and read the number marked after Release to know your version number. \nThe `lsb-release -a` command give more informations at release.","ref":"informations-on-rolling-version.html#with-lsb-release"},{"type":"extras","title":"Update Kaisen Linux Rolling","doc":"# Update Kaisen Linux Rolling","ref":"update-kaisen-linux-rolling.html"},{"type":"extras","title":"Classic method - Update Kaisen Linux Rolling","doc":"With Kaisen Linux now in rolling mode, the entire system can be updated without having to systematically reinstall it.  \n\nThe classic method is to use the following command:\n\n```bash\nsudo apt update && sudo apt -y full-upgrade\n```\n\nThis method is the update method used on Debian and other derivatives.","ref":"update-kaisen-linux-rolling.html#classic-method"},{"type":"extras","title":"Kaisen Linux method - Update Kaisen Linux Rolling","doc":"On Kaisen Linux, an update automation script has been created. It uses the classic update method but additionally plans to fix any errors if there are during the update process and automatically removes the no longer used package dependencies. \n\nTo use the Kaisen method, you must type this command:\n\n```bash\nsudo kaisen-update\n```","ref":"update-kaisen-linux-rolling.html#kaisen-linux-method"},{"type":"extras","title":"What are the revisions of the rolling version?","doc":"# What are the revisions of the rolling version?","ref":"what-are-the-revisions-of-the-rolling-version.html"},{"type":"extras","title":"Explanation - What are the revisions of the rolling version?","doc":"Revisions (eg 1.1, 1.2 and so on) are simply a \"snapshot\" of the project at one point in time.  \nThe revisions of the rolling version are therefore ISOS updated at a given time when the system has had improvements, additions of tools, bug fixes etc...","ref":"what-are-the-revisions-of-the-rolling-version.html#explanation"},{"type":"extras","title":"APT OS update - What are the revisions of the rolling version?","doc":"Since the rolling version and therefore the arrival of the official Kaisen Linux package repositories, the entire system can be updated via APT.  \nWhen switching to a \"new version\", the base-files package is updated and the /etc/os-release file and the conky will show the current revision.","ref":"what-are-the-revisions-of-the-rolling-version.html#apt-os-update"},{"type":"extras","title":"New ISOS - What are the revisions of the rolling version?","doc":"New ISOS are therefore created with each revision to fix any errors on the live system, improvements on the start-up entries, support for a new language, integration of new tools integrated over time on the live etc...  \nEven if you have downloaded Kaisen Linux 2.1 and installed the system, and ISOS 2.2 has just been released, you don't have to completely reinstall the system, using the kaisen-update command will suffice to change from revision 2.1 to 2.2 by updating the packages.","ref":"what-are-the-revisions-of-the-rolling-version.html#new-isos"},{"type":"extras","title":"Where can I find documentation on the built in tools or how certain settings work?","doc":"# Where can I find documentation on the built-in tools or how certain settings work?\n\n## On the tools\nDocumentation on the built-in tools and how to use them can easily be found on the editor's documentation or via the man pages provided with the default packages. \nFor this purpose, [centralized manpages](https://kaisenlinux.org/manpages/) have been created and managed by us.","ref":"where-can-i-find-documentation-on-the-built-in-tools-or-how-certain-settings-work.html"},{"type":"extras","title":"About the functioning of a Debian or apt distribution for example - Where can I find documentation on the built in tools or how certain settings work?","doc":"There is no lack of documentation from Debian or others on the internet, and it can be a comprehensive source of documentation. \nOverall, the man pages will suffice in most cases. In case this is not enough, even though we try to provide as much documentation as possible, the internet is still your best bet.","ref":"where-can-i-find-documentation-on-the-built-in-tools-or-how-certain-settings-work.html#about-the-functioning-of-a-debian-or-apt-distribution-for-example"},{"type":"extras","title":"Where can I find more documentation?","doc":"# Where can I find more documentation?","ref":"where-can-i-find-more-documentation.html"},{"type":"extras","title":"Objectives of this documentation - Where can I find more documentation?","doc":"In the official Kaisen Linux documentation, you will find mostly information about the specifics of the distribution (e.g. the built-in tools, how the installer works, information about the implementation of BTRFS and APT snapshots...)  \nWe won't do further documentation because maintaining it takes time and the project team and contributors are really too small to maintain such a big documentation.  \nYou can find here information where to look if you want more documentation or requests about Kaisen.","ref":"where-can-i-find-more-documentation.html#objectives-of-this-documentation"},{"type":"extras","title":"Softwares - Where can I find more documentation?","doc":"If you are looking for more documentation about the built-in tools and how they work and their use cases, you can refer to the built-in manpages in the packages delivering the tools or to the centralized manpages we make at https://kaisenlinux.org/manpages/ or via the kaisen-manpages package.","ref":"where-can-i-find-more-documentation.html#softwares"},{"type":"extras","title":"Using Kaisen - Where can I find more documentation?","doc":"Kaisen Linux is based on Debian and is therefore similar in many aspects to Debian (upgrading, installing tools, installing...), although Kaisen is well modified to fit the potential needs of administrators and technicians, most of the features like APT, DPKG, SystemD or others are documented by Debian and on various other forums, or documentation on the project providing the software. You can surely find more information here or by asking on the Kaisen Linux forum: https://forum.kaisenlinux.org.","ref":"where-can-i-find-more-documentation.html#using-kaisen"},{"type":"extras","title":"Why are all additional services disabled by default?","doc":"# Why are all additional services disabled by default?","ref":"why-are-all-additional-services-disabled-by-default.html"},{"type":"extras","title":"Explanation - Why are all additional services disabled by default?","doc":"We call additional services, services installed by software provided in Kaisen Linux. The reason is simple. It is about optimizing the performance and resources used by the system.  \nWhen building the ISO, all services are disabled with systemd hooks, which allows once the ISO is built, to be able to use Kaisen Linux with only 500MB to 550MB of RAM on the live as well as on the installed system , which is suitable for very small configurations.  \nWe also have the vision, despite the wide range of tools provided by default, to let the user choose to use only what they need, so let these services run in the background, is useless and consumes resources unnecessarily. The tool is present (because we provide a complete live), but if not necessary, it therefore does not encumber any resource (except the disk space used by this program).","ref":"why-are-all-additional-services-disabled-by-default.html#explanation"},{"type":"extras","title":"Management of these services - Why are all additional services disabled by default?","doc":"So we have to list these services, as well as to facilitate their management (activation, deactivation) created the **\"kaisen-services-management\"** package which installs scripts which will be referenced on the menu in the **\"Services\"** tab which will allow activate and deactivate the services listed by sub-tabs for example **\"zfs-fuse, avahi, cups etc ...\"** as well as two scripts to activate or deactivate everything.","ref":"why-are-all-additional-services-disabled-by-default.html#management-of-these-services"},{"type":"extras","title":"Problem resolution - Why are all additional services disabled by default?","doc":"If you therefore have an error telling you that the service is not indicated or certain programs (2ping for example) start but are not functional, try to activate the service corresponding to this program (via the menu or simply by typing yourself systemd commands).\nIf that doesn't solve your problem, contact the support.","ref":"why-are-all-additional-services-disabled-by-default.html#problem-resolution"},{"type":"extras","title":"Why create user accounts only on home?","doc":"# Why create user accounts only on /home?\n\n## Explanation\nBy convention (FHS standard), users intended to be accounts for users must have their home directory on /home, as it is intended for that.  \nOn Kaisen Linux, this convention as on all distributions respecting the standards is respected.  \nThe kaisen-update-skel scripts as well as the kaisen-interface-switcher, were developed to read with awk all users who have a home directory in a directory in / home via the /etc/passwd file. If you do not respect this standard and are led to use one of these scripts, they will not work normally if at all.  \nI am aware that I cannot cover all cases, I try to do it as much as possible, however this kind of scripts can only work correctly by respecting the standards, to avoid any additional problems.","ref":"why-create-user-accounts-only-on-home.html"},{"type":"extras","title":"Why KDE installed with lightdm by default?","doc":"# Why KDE installed with lightdm by default?","ref":"why-kde-installed-with-lightdm-by-default.html"},{"type":"extras","title":"Explanation - Why KDE installed with lightdm by default?","doc":"KDE uses SDDM display manager by default.  \nI didn't have a problem with that until it started behaving strangely with the `kaisen-interface-switcher` script, and its configuration and customization was complicated.  \nFor the sake of simplicity and standardization, I decided using the postinst script on kaisen-kde, to change SDDM to LIGHTDM only when installing the package. This will allow you to reset SDDM or other display manager to default, without updating the package or the entire system, modifying your settings.  \n\n## Return to SDDM","ref":"why-kde-installed-with-lightdm-by-default.html#explanation"},{"type":"extras","title":"Universal method - Why KDE installed with lightdm by default?","doc":"The universal and potentially error-prone method is to modify the `/etc/X11/default-display-manager` file by hand and fill in the new display manager (for this example, replace `/usr/sbin/lightdm` by `/usr/bin/sddm`) and the changes will be visible the next time you start the computer.","ref":"why-kde-installed-with-lightdm-by-default.html#universal-method"},{"type":"extras","title":"Debian method - Why KDE installed with lightdm by default?","doc":"You just have to use the `sudo dpkg-reconfigure lightdm` command and select SDDM. This reconfiguration will be visible the next time you restart the computer. I advice this method, because is less error-prone.","ref":"why-kde-installed-with-lightdm-by-default.html#debian-method"},{"type":"extras","title":"Why no source on some packages?","doc":"# Why no sources on some packages?","ref":"why-no-source-on-some-packages.html"},{"type":"extras","title":"Free software - Why no source on some packages?","doc":"Some software such as codium, balena-etcher-electron to name a few, are packages downloaded directly from official GitHub sources in the releases section. Software developers have already tampered with this software, so we don't have to package it ourselves.","ref":"why-no-source-on-some-packages.html#free-software"},{"type":"extras","title":"Check the authenticity of the packages - Why no source on some packages?","doc":"The safest and most efficient way to check the authenticity of the sourceless packages that we provide to you is to check via the official GitHub repository of the software (for example codium or balena-etcher-electron) the checksum in sha256, md5 or sha1 with sha256sum, md5sum or sha1sum the package we provide as well as the one on GitHub. The amounts are normally the same because the file has not been modified.  \nYou can find the .deb files added for Kaisen Linux and the sha256, md5, and sha1 checksums of these packages (this also includes packages developed for distribution as well as packages recompiled for distribution) [here](https://deb.kaisenlinux.org/dists/kaisen-devel/main/binary-amd64/Packages):  \nhttps://deb.kaisenlinux.org/dists/kaisen-devel/main/binary-amd64/Packages","ref":"why-no-source-on-some-packages.html#check-the-authenticity-of-the-packages"},{"type":"extras","title":"Why root account is disabled?","doc":"# Why root account is disabled by default?","ref":"why-root-account-is-disabled.html"},{"type":"extras","title":"The disable explanation - Why root account is disabled?","doc":"Thanks to the preseed file used by the insllator, we deactivate the password request for the root user.  \nThe reason is very simple. As a security measure, on UNIX systems, never use the root account but rather use sudo. This allows the increase of the security of the system (also reduces the risks of malware infections), allows to have better control over the actions of the user as well as the traceability of his actions.  \nWe have also based our entire default profile for normal users, especially with zsh, which is the default shell for normal users, but is not that of root (that of root is bash, to facilitate chroot systems).  \nWe have therefore chosen to deactivate this possibility.\n\n## So how do you get root rights?\nBy default, when installing the system with a user and a password entered (which is not offered when we enter a password for root, because root becomes our current user), the installer puts default this user in the sudo group without any restriction on the machine, the sudo command gives you all access.  \nWe have not, despite our attachment to system security, not disabled the possibility of putting a password on root after installation (sudo passwd root command) nor have we disabled the sudo su or su root.  \nWe believe that as users, you are free to use the system as you see fit, without any particular constraints.  \nHowever, we always advise you to use sudo when you need root is to leave root disabled (without password), this can save you from some errors that can harm your system.\n\n## Advice\nWe do not recommend using the root account from a graphical session.  \nAnd this because increases the risk of making a false manipulation, creating directories with root rights when root is not necessary, and others.  \nSome scripts developed for Kaisen Linux are also developed only for regular user accounts (even without sudo rights), because root should not be used from a graphical session.  \nThis will surely never change, admittedly I remove you by default the possibility to put a password on root, but you can entirely use it in command line via the commands sudo `su -` or `sudo -i`.","ref":"why-root-account-is-disabled.html#the-disable-explanation"},{"type":"extras","title":"Conclusion - Why root account is disabled?","doc":"Use sudo when you need root.  \nLog in as root with the `sudo su -`, `sudo -i`, and su command (su command only works if you have set a root password with the passwd root command).","ref":"why-root-account-is-disabled.html#conclusion"}],"proglang":"elixir","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.38.2"}}