package documentdb

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RestorableGremlinResourcesClient is the client for the RestorableGremlinResources methods of the Documentdb service.
type RestorableGremlinResourcesClient struct {
	BaseClient
}

// NewRestorableGremlinResourcesClient creates an instance of the RestorableGremlinResourcesClient client.
func NewRestorableGremlinResourcesClient(subscriptionID string) RestorableGremlinResourcesClient {
	return NewRestorableGremlinResourcesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRestorableGremlinResourcesClientWithBaseURI creates an instance of the RestorableGremlinResourcesClient client
// using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign
// clouds, Azure stack).
func NewRestorableGremlinResourcesClientWithBaseURI(baseURI string, subscriptionID string) RestorableGremlinResourcesClient {
	return RestorableGremlinResourcesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List return a list of gremlin database and graphs combo that exist on the account at the given timestamp and
// location. This helps in scenarios to validate what resources exist at given timestamp and location. This API
// requires 'Microsoft.DocumentDB/locations/restorableDatabaseAccounts/.../read' permission.
// Parameters:
// location - cosmos DB region, with spaces between words and each word capitalized.
// instanceID - the instanceId GUID of a restorable database account.
// restoreLocation - the location where the restorable resources are located.
// restoreTimestampInUtc - the timestamp when the restorable resources existed.
func (client RestorableGremlinResourcesClient) List(ctx context.Context, location string, instanceID string, restoreLocation string, restoreTimestampInUtc string) (result RestorableGremlinResourcesListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorableGremlinResourcesClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.RestorableGremlinResourcesClient", "List", err.Error())
	}

	req, err := client.ListPreparer(ctx, location, instanceID, restoreLocation, restoreTimestampInUtc)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.RestorableGremlinResourcesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.RestorableGremlinResourcesClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.RestorableGremlinResourcesClient", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client RestorableGremlinResourcesClient) ListPreparer(ctx context.Context, location string, instanceID string, restoreLocation string, restoreTimestampInUtc string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":     autorest.Encode("path", instanceID),
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(restoreLocation) > 0 {
		queryParameters["restoreLocation"] = autorest.Encode("query", restoreLocation)
	}
	if len(restoreTimestampInUtc) > 0 {
		queryParameters["restoreTimestampInUtc"] = autorest.Encode("query", restoreTimestampInUtc)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{instanceId}/restorableGremlinResources", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client RestorableGremlinResourcesClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client RestorableGremlinResourcesClient) ListResponder(resp *http.Response) (result RestorableGremlinResourcesListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
