package documentdb

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// SQLResourcesClient is the client for the SQLResources methods of the Documentdb service.
type SQLResourcesClient struct {
	BaseClient
}

// NewSQLResourcesClient creates an instance of the SQLResourcesClient client.
func NewSQLResourcesClient(subscriptionID string) SQLResourcesClient {
	return NewSQLResourcesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewSQLResourcesClientWithBaseURI creates an instance of the SQLResourcesClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewSQLResourcesClientWithBaseURI(baseURI string, subscriptionID string) SQLResourcesClient {
	return SQLResourcesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateUpdateSQLContainer create or update an Azure Cosmos DB SQL container
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
// createUpdateSQLContainerParameters - the parameters to provide for the current SQL container.
func (client SQLResourcesClient) CreateUpdateSQLContainer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, createUpdateSQLContainerParameters SQLContainerCreateUpdateParameters) (result SQLResourcesCreateUpdateSQLContainerFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.CreateUpdateSQLContainer")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: createUpdateSQLContainerParameters,
			Constraints: []validation.Constraint{{Target: "createUpdateSQLContainerParameters.SQLContainerCreateUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "createUpdateSQLContainerParameters.SQLContainerCreateUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "createUpdateSQLContainerParameters.SQLContainerCreateUpdateProperties.Resource.ID", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "createUpdateSQLContainerParameters.SQLContainerCreateUpdateProperties.Resource.PartitionKey", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "createUpdateSQLContainerParameters.SQLContainerCreateUpdateProperties.Resource.PartitionKey.Version", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "createUpdateSQLContainerParameters.SQLContainerCreateUpdateProperties.Resource.PartitionKey.Version", Name: validation.InclusiveMaximum, Rule: int64(2), Chain: nil},
									{Target: "createUpdateSQLContainerParameters.SQLContainerCreateUpdateProperties.Resource.PartitionKey.Version", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
								}},
							}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "CreateUpdateSQLContainer", err.Error())
	}

	req, err := client.CreateUpdateSQLContainerPreparer(ctx, resourceGroupName, accountName, databaseName, containerName, createUpdateSQLContainerParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLContainer", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateUpdateSQLContainerSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLContainer", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateUpdateSQLContainerPreparer prepares the CreateUpdateSQLContainer request.
func (client SQLResourcesClient) CreateUpdateSQLContainerPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, createUpdateSQLContainerParameters SQLContainerCreateUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}", pathParameters),
		autorest.WithJSON(createUpdateSQLContainerParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUpdateSQLContainerSender sends the CreateUpdateSQLContainer request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) CreateUpdateSQLContainerSender(req *http.Request) (future SQLResourcesCreateUpdateSQLContainerFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateUpdateSQLContainerResponder handles the response to the CreateUpdateSQLContainer request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) CreateUpdateSQLContainerResponder(resp *http.Response) (result SQLContainerGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateUpdateSQLDatabase create or update an Azure Cosmos DB SQL database
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// createUpdateSQLDatabaseParameters - the parameters to provide for the current SQL database.
func (client SQLResourcesClient) CreateUpdateSQLDatabase(ctx context.Context, resourceGroupName string, accountName string, databaseName string, createUpdateSQLDatabaseParameters SQLDatabaseCreateUpdateParameters) (result SQLResourcesCreateUpdateSQLDatabaseFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.CreateUpdateSQLDatabase")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: createUpdateSQLDatabaseParameters,
			Constraints: []validation.Constraint{{Target: "createUpdateSQLDatabaseParameters.SQLDatabaseCreateUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "createUpdateSQLDatabaseParameters.SQLDatabaseCreateUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "createUpdateSQLDatabaseParameters.SQLDatabaseCreateUpdateProperties.Resource.ID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "CreateUpdateSQLDatabase", err.Error())
	}

	req, err := client.CreateUpdateSQLDatabasePreparer(ctx, resourceGroupName, accountName, databaseName, createUpdateSQLDatabaseParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLDatabase", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateUpdateSQLDatabaseSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLDatabase", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateUpdateSQLDatabasePreparer prepares the CreateUpdateSQLDatabase request.
func (client SQLResourcesClient) CreateUpdateSQLDatabasePreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, createUpdateSQLDatabaseParameters SQLDatabaseCreateUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}", pathParameters),
		autorest.WithJSON(createUpdateSQLDatabaseParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUpdateSQLDatabaseSender sends the CreateUpdateSQLDatabase request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) CreateUpdateSQLDatabaseSender(req *http.Request) (future SQLResourcesCreateUpdateSQLDatabaseFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateUpdateSQLDatabaseResponder handles the response to the CreateUpdateSQLDatabase request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) CreateUpdateSQLDatabaseResponder(resp *http.Response) (result SQLDatabaseGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateUpdateSQLRoleAssignment creates or updates an Azure Cosmos DB SQL Role Assignment.
// Parameters:
// roleAssignmentID - the GUID for the Role Assignment.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// createUpdateSQLRoleAssignmentParameters - the properties required to create or update a Role Assignment.
func (client SQLResourcesClient) CreateUpdateSQLRoleAssignment(ctx context.Context, roleAssignmentID string, resourceGroupName string, accountName string, createUpdateSQLRoleAssignmentParameters SQLRoleAssignmentCreateUpdateParameters) (result SQLResourcesCreateUpdateSQLRoleAssignmentFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.CreateUpdateSQLRoleAssignment")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "CreateUpdateSQLRoleAssignment", err.Error())
	}

	req, err := client.CreateUpdateSQLRoleAssignmentPreparer(ctx, roleAssignmentID, resourceGroupName, accountName, createUpdateSQLRoleAssignmentParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLRoleAssignment", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateUpdateSQLRoleAssignmentSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLRoleAssignment", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateUpdateSQLRoleAssignmentPreparer prepares the CreateUpdateSQLRoleAssignment request.
func (client SQLResourcesClient) CreateUpdateSQLRoleAssignmentPreparer(ctx context.Context, roleAssignmentID string, resourceGroupName string, accountName string, createUpdateSQLRoleAssignmentParameters SQLRoleAssignmentCreateUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"roleAssignmentId":  autorest.Encode("path", roleAssignmentID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleAssignments/{roleAssignmentId}", pathParameters),
		autorest.WithJSON(createUpdateSQLRoleAssignmentParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUpdateSQLRoleAssignmentSender sends the CreateUpdateSQLRoleAssignment request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) CreateUpdateSQLRoleAssignmentSender(req *http.Request) (future SQLResourcesCreateUpdateSQLRoleAssignmentFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateUpdateSQLRoleAssignmentResponder handles the response to the CreateUpdateSQLRoleAssignment request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) CreateUpdateSQLRoleAssignmentResponder(resp *http.Response) (result SQLRoleAssignmentGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateUpdateSQLRoleDefinition creates or updates an Azure Cosmos DB SQL Role Definition.
// Parameters:
// roleDefinitionID - the GUID for the Role Definition.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// createUpdateSQLRoleDefinitionParameters - the properties required to create or update a Role Definition.
func (client SQLResourcesClient) CreateUpdateSQLRoleDefinition(ctx context.Context, roleDefinitionID string, resourceGroupName string, accountName string, createUpdateSQLRoleDefinitionParameters SQLRoleDefinitionCreateUpdateParameters) (result SQLResourcesCreateUpdateSQLRoleDefinitionFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.CreateUpdateSQLRoleDefinition")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "CreateUpdateSQLRoleDefinition", err.Error())
	}

	req, err := client.CreateUpdateSQLRoleDefinitionPreparer(ctx, roleDefinitionID, resourceGroupName, accountName, createUpdateSQLRoleDefinitionParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLRoleDefinition", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateUpdateSQLRoleDefinitionSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLRoleDefinition", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateUpdateSQLRoleDefinitionPreparer prepares the CreateUpdateSQLRoleDefinition request.
func (client SQLResourcesClient) CreateUpdateSQLRoleDefinitionPreparer(ctx context.Context, roleDefinitionID string, resourceGroupName string, accountName string, createUpdateSQLRoleDefinitionParameters SQLRoleDefinitionCreateUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"roleDefinitionId":  autorest.Encode("path", roleDefinitionID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleDefinitions/{roleDefinitionId}", pathParameters),
		autorest.WithJSON(createUpdateSQLRoleDefinitionParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUpdateSQLRoleDefinitionSender sends the CreateUpdateSQLRoleDefinition request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) CreateUpdateSQLRoleDefinitionSender(req *http.Request) (future SQLResourcesCreateUpdateSQLRoleDefinitionFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateUpdateSQLRoleDefinitionResponder handles the response to the CreateUpdateSQLRoleDefinition request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) CreateUpdateSQLRoleDefinitionResponder(resp *http.Response) (result SQLRoleDefinitionGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateUpdateSQLStoredProcedure create or update an Azure Cosmos DB SQL storedProcedure
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
// storedProcedureName - cosmos DB storedProcedure name.
// createUpdateSQLStoredProcedureParameters - the parameters to provide for the current SQL storedProcedure.
func (client SQLResourcesClient) CreateUpdateSQLStoredProcedure(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, storedProcedureName string, createUpdateSQLStoredProcedureParameters SQLStoredProcedureCreateUpdateParameters) (result SQLResourcesCreateUpdateSQLStoredProcedureFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.CreateUpdateSQLStoredProcedure")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: createUpdateSQLStoredProcedureParameters,
			Constraints: []validation.Constraint{{Target: "createUpdateSQLStoredProcedureParameters.SQLStoredProcedureCreateUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "createUpdateSQLStoredProcedureParameters.SQLStoredProcedureCreateUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "createUpdateSQLStoredProcedureParameters.SQLStoredProcedureCreateUpdateProperties.Resource.ID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "CreateUpdateSQLStoredProcedure", err.Error())
	}

	req, err := client.CreateUpdateSQLStoredProcedurePreparer(ctx, resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSQLStoredProcedureParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLStoredProcedure", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateUpdateSQLStoredProcedureSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLStoredProcedure", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateUpdateSQLStoredProcedurePreparer prepares the CreateUpdateSQLStoredProcedure request.
func (client SQLResourcesClient) CreateUpdateSQLStoredProcedurePreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, storedProcedureName string, createUpdateSQLStoredProcedureParameters SQLStoredProcedureCreateUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":         autorest.Encode("path", accountName),
		"containerName":       autorest.Encode("path", containerName),
		"databaseName":        autorest.Encode("path", databaseName),
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"storedProcedureName": autorest.Encode("path", storedProcedureName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}", pathParameters),
		autorest.WithJSON(createUpdateSQLStoredProcedureParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUpdateSQLStoredProcedureSender sends the CreateUpdateSQLStoredProcedure request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) CreateUpdateSQLStoredProcedureSender(req *http.Request) (future SQLResourcesCreateUpdateSQLStoredProcedureFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateUpdateSQLStoredProcedureResponder handles the response to the CreateUpdateSQLStoredProcedure request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) CreateUpdateSQLStoredProcedureResponder(resp *http.Response) (result SQLStoredProcedureGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateUpdateSQLTrigger create or update an Azure Cosmos DB SQL trigger
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
// triggerName - cosmos DB trigger name.
// createUpdateSQLTriggerParameters - the parameters to provide for the current SQL trigger.
func (client SQLResourcesClient) CreateUpdateSQLTrigger(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, triggerName string, createUpdateSQLTriggerParameters SQLTriggerCreateUpdateParameters) (result SQLResourcesCreateUpdateSQLTriggerFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.CreateUpdateSQLTrigger")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: createUpdateSQLTriggerParameters,
			Constraints: []validation.Constraint{{Target: "createUpdateSQLTriggerParameters.SQLTriggerCreateUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "createUpdateSQLTriggerParameters.SQLTriggerCreateUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "createUpdateSQLTriggerParameters.SQLTriggerCreateUpdateProperties.Resource.ID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "CreateUpdateSQLTrigger", err.Error())
	}

	req, err := client.CreateUpdateSQLTriggerPreparer(ctx, resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSQLTriggerParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLTrigger", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateUpdateSQLTriggerSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLTrigger", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateUpdateSQLTriggerPreparer prepares the CreateUpdateSQLTrigger request.
func (client SQLResourcesClient) CreateUpdateSQLTriggerPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, triggerName string, createUpdateSQLTriggerParameters SQLTriggerCreateUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"triggerName":       autorest.Encode("path", triggerName),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}", pathParameters),
		autorest.WithJSON(createUpdateSQLTriggerParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUpdateSQLTriggerSender sends the CreateUpdateSQLTrigger request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) CreateUpdateSQLTriggerSender(req *http.Request) (future SQLResourcesCreateUpdateSQLTriggerFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateUpdateSQLTriggerResponder handles the response to the CreateUpdateSQLTrigger request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) CreateUpdateSQLTriggerResponder(resp *http.Response) (result SQLTriggerGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateUpdateSQLUserDefinedFunction create or update an Azure Cosmos DB SQL userDefinedFunction
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
// userDefinedFunctionName - cosmos DB userDefinedFunction name.
// createUpdateSQLUserDefinedFunctionParameters - the parameters to provide for the current SQL
// userDefinedFunction.
func (client SQLResourcesClient) CreateUpdateSQLUserDefinedFunction(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, userDefinedFunctionName string, createUpdateSQLUserDefinedFunctionParameters SQLUserDefinedFunctionCreateUpdateParameters) (result SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.CreateUpdateSQLUserDefinedFunction")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: createUpdateSQLUserDefinedFunctionParameters,
			Constraints: []validation.Constraint{{Target: "createUpdateSQLUserDefinedFunctionParameters.SQLUserDefinedFunctionCreateUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "createUpdateSQLUserDefinedFunctionParameters.SQLUserDefinedFunctionCreateUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "createUpdateSQLUserDefinedFunctionParameters.SQLUserDefinedFunctionCreateUpdateProperties.Resource.ID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "CreateUpdateSQLUserDefinedFunction", err.Error())
	}

	req, err := client.CreateUpdateSQLUserDefinedFunctionPreparer(ctx, resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSQLUserDefinedFunctionParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLUserDefinedFunction", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateUpdateSQLUserDefinedFunctionSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "CreateUpdateSQLUserDefinedFunction", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateUpdateSQLUserDefinedFunctionPreparer prepares the CreateUpdateSQLUserDefinedFunction request.
func (client SQLResourcesClient) CreateUpdateSQLUserDefinedFunctionPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, userDefinedFunctionName string, createUpdateSQLUserDefinedFunctionParameters SQLUserDefinedFunctionCreateUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":             autorest.Encode("path", accountName),
		"containerName":           autorest.Encode("path", containerName),
		"databaseName":            autorest.Encode("path", databaseName),
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
		"userDefinedFunctionName": autorest.Encode("path", userDefinedFunctionName),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}", pathParameters),
		autorest.WithJSON(createUpdateSQLUserDefinedFunctionParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUpdateSQLUserDefinedFunctionSender sends the CreateUpdateSQLUserDefinedFunction request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) CreateUpdateSQLUserDefinedFunctionSender(req *http.Request) (future SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateUpdateSQLUserDefinedFunctionResponder handles the response to the CreateUpdateSQLUserDefinedFunction request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) CreateUpdateSQLUserDefinedFunctionResponder(resp *http.Response) (result SQLUserDefinedFunctionGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSQLContainer deletes an existing Azure Cosmos DB SQL container.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
func (client SQLResourcesClient) DeleteSQLContainer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result SQLResourcesDeleteSQLContainerFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.DeleteSQLContainer")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "DeleteSQLContainer", err.Error())
	}

	req, err := client.DeleteSQLContainerPreparer(ctx, resourceGroupName, accountName, databaseName, containerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLContainer", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSQLContainerSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLContainer", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteSQLContainerPreparer prepares the DeleteSQLContainer request.
func (client SQLResourcesClient) DeleteSQLContainerPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSQLContainerSender sends the DeleteSQLContainer request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) DeleteSQLContainerSender(req *http.Request) (future SQLResourcesDeleteSQLContainerFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteSQLContainerResponder handles the response to the DeleteSQLContainer request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) DeleteSQLContainerResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSQLDatabase deletes an existing Azure Cosmos DB SQL database.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
func (client SQLResourcesClient) DeleteSQLDatabase(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result SQLResourcesDeleteSQLDatabaseFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.DeleteSQLDatabase")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "DeleteSQLDatabase", err.Error())
	}

	req, err := client.DeleteSQLDatabasePreparer(ctx, resourceGroupName, accountName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLDatabase", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSQLDatabaseSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLDatabase", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteSQLDatabasePreparer prepares the DeleteSQLDatabase request.
func (client SQLResourcesClient) DeleteSQLDatabasePreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSQLDatabaseSender sends the DeleteSQLDatabase request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) DeleteSQLDatabaseSender(req *http.Request) (future SQLResourcesDeleteSQLDatabaseFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteSQLDatabaseResponder handles the response to the DeleteSQLDatabase request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) DeleteSQLDatabaseResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSQLRoleAssignment deletes an existing Azure Cosmos DB SQL Role Assignment.
// Parameters:
// roleAssignmentID - the GUID for the Role Assignment.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
func (client SQLResourcesClient) DeleteSQLRoleAssignment(ctx context.Context, roleAssignmentID string, resourceGroupName string, accountName string) (result SQLResourcesDeleteSQLRoleAssignmentFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.DeleteSQLRoleAssignment")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "DeleteSQLRoleAssignment", err.Error())
	}

	req, err := client.DeleteSQLRoleAssignmentPreparer(ctx, roleAssignmentID, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLRoleAssignment", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSQLRoleAssignmentSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLRoleAssignment", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteSQLRoleAssignmentPreparer prepares the DeleteSQLRoleAssignment request.
func (client SQLResourcesClient) DeleteSQLRoleAssignmentPreparer(ctx context.Context, roleAssignmentID string, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"roleAssignmentId":  autorest.Encode("path", roleAssignmentID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleAssignments/{roleAssignmentId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSQLRoleAssignmentSender sends the DeleteSQLRoleAssignment request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) DeleteSQLRoleAssignmentSender(req *http.Request) (future SQLResourcesDeleteSQLRoleAssignmentFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteSQLRoleAssignmentResponder handles the response to the DeleteSQLRoleAssignment request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) DeleteSQLRoleAssignmentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSQLRoleDefinition deletes an existing Azure Cosmos DB SQL Role Definition.
// Parameters:
// roleDefinitionID - the GUID for the Role Definition.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
func (client SQLResourcesClient) DeleteSQLRoleDefinition(ctx context.Context, roleDefinitionID string, resourceGroupName string, accountName string) (result SQLResourcesDeleteSQLRoleDefinitionFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.DeleteSQLRoleDefinition")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "DeleteSQLRoleDefinition", err.Error())
	}

	req, err := client.DeleteSQLRoleDefinitionPreparer(ctx, roleDefinitionID, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLRoleDefinition", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSQLRoleDefinitionSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLRoleDefinition", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteSQLRoleDefinitionPreparer prepares the DeleteSQLRoleDefinition request.
func (client SQLResourcesClient) DeleteSQLRoleDefinitionPreparer(ctx context.Context, roleDefinitionID string, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"roleDefinitionId":  autorest.Encode("path", roleDefinitionID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleDefinitions/{roleDefinitionId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSQLRoleDefinitionSender sends the DeleteSQLRoleDefinition request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) DeleteSQLRoleDefinitionSender(req *http.Request) (future SQLResourcesDeleteSQLRoleDefinitionFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteSQLRoleDefinitionResponder handles the response to the DeleteSQLRoleDefinition request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) DeleteSQLRoleDefinitionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSQLStoredProcedure deletes an existing Azure Cosmos DB SQL storedProcedure.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
// storedProcedureName - cosmos DB storedProcedure name.
func (client SQLResourcesClient) DeleteSQLStoredProcedure(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, storedProcedureName string) (result SQLResourcesDeleteSQLStoredProcedureFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.DeleteSQLStoredProcedure")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "DeleteSQLStoredProcedure", err.Error())
	}

	req, err := client.DeleteSQLStoredProcedurePreparer(ctx, resourceGroupName, accountName, databaseName, containerName, storedProcedureName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLStoredProcedure", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSQLStoredProcedureSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLStoredProcedure", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteSQLStoredProcedurePreparer prepares the DeleteSQLStoredProcedure request.
func (client SQLResourcesClient) DeleteSQLStoredProcedurePreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, storedProcedureName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":         autorest.Encode("path", accountName),
		"containerName":       autorest.Encode("path", containerName),
		"databaseName":        autorest.Encode("path", databaseName),
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"storedProcedureName": autorest.Encode("path", storedProcedureName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSQLStoredProcedureSender sends the DeleteSQLStoredProcedure request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) DeleteSQLStoredProcedureSender(req *http.Request) (future SQLResourcesDeleteSQLStoredProcedureFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteSQLStoredProcedureResponder handles the response to the DeleteSQLStoredProcedure request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) DeleteSQLStoredProcedureResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSQLTrigger deletes an existing Azure Cosmos DB SQL trigger.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
// triggerName - cosmos DB trigger name.
func (client SQLResourcesClient) DeleteSQLTrigger(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, triggerName string) (result SQLResourcesDeleteSQLTriggerFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.DeleteSQLTrigger")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "DeleteSQLTrigger", err.Error())
	}

	req, err := client.DeleteSQLTriggerPreparer(ctx, resourceGroupName, accountName, databaseName, containerName, triggerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLTrigger", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSQLTriggerSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLTrigger", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteSQLTriggerPreparer prepares the DeleteSQLTrigger request.
func (client SQLResourcesClient) DeleteSQLTriggerPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, triggerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"triggerName":       autorest.Encode("path", triggerName),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSQLTriggerSender sends the DeleteSQLTrigger request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) DeleteSQLTriggerSender(req *http.Request) (future SQLResourcesDeleteSQLTriggerFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteSQLTriggerResponder handles the response to the DeleteSQLTrigger request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) DeleteSQLTriggerResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSQLUserDefinedFunction deletes an existing Azure Cosmos DB SQL userDefinedFunction.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
// userDefinedFunctionName - cosmos DB userDefinedFunction name.
func (client SQLResourcesClient) DeleteSQLUserDefinedFunction(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, userDefinedFunctionName string) (result SQLResourcesDeleteSQLUserDefinedFunctionFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.DeleteSQLUserDefinedFunction")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "DeleteSQLUserDefinedFunction", err.Error())
	}

	req, err := client.DeleteSQLUserDefinedFunctionPreparer(ctx, resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLUserDefinedFunction", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSQLUserDefinedFunctionSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "DeleteSQLUserDefinedFunction", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteSQLUserDefinedFunctionPreparer prepares the DeleteSQLUserDefinedFunction request.
func (client SQLResourcesClient) DeleteSQLUserDefinedFunctionPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, userDefinedFunctionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":             autorest.Encode("path", accountName),
		"containerName":           autorest.Encode("path", containerName),
		"databaseName":            autorest.Encode("path", databaseName),
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
		"userDefinedFunctionName": autorest.Encode("path", userDefinedFunctionName),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSQLUserDefinedFunctionSender sends the DeleteSQLUserDefinedFunction request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) DeleteSQLUserDefinedFunctionSender(req *http.Request) (future SQLResourcesDeleteSQLUserDefinedFunctionFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteSQLUserDefinedFunctionResponder handles the response to the DeleteSQLUserDefinedFunction request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) DeleteSQLUserDefinedFunctionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetSQLContainer gets the SQL container under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
func (client SQLResourcesClient) GetSQLContainer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result SQLContainerGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.GetSQLContainer")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "GetSQLContainer", err.Error())
	}

	req, err := client.GetSQLContainerPreparer(ctx, resourceGroupName, accountName, databaseName, containerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLContainer", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSQLContainerSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLContainer", resp, "Failure sending request")
		return
	}

	result, err = client.GetSQLContainerResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLContainer", resp, "Failure responding to request")
		return
	}

	return
}

// GetSQLContainerPreparer prepares the GetSQLContainer request.
func (client SQLResourcesClient) GetSQLContainerPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSQLContainerSender sends the GetSQLContainer request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) GetSQLContainerSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSQLContainerResponder handles the response to the GetSQLContainer request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) GetSQLContainerResponder(resp *http.Response) (result SQLContainerGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSQLContainerThroughput gets the RUs per second of the SQL container under an existing Azure Cosmos DB database
// account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
func (client SQLResourcesClient) GetSQLContainerThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result ThroughputSettingsGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.GetSQLContainerThroughput")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "GetSQLContainerThroughput", err.Error())
	}

	req, err := client.GetSQLContainerThroughputPreparer(ctx, resourceGroupName, accountName, databaseName, containerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLContainerThroughput", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSQLContainerThroughputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLContainerThroughput", resp, "Failure sending request")
		return
	}

	result, err = client.GetSQLContainerThroughputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLContainerThroughput", resp, "Failure responding to request")
		return
	}

	return
}

// GetSQLContainerThroughputPreparer prepares the GetSQLContainerThroughput request.
func (client SQLResourcesClient) GetSQLContainerThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSQLContainerThroughputSender sends the GetSQLContainerThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) GetSQLContainerThroughputSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSQLContainerThroughputResponder handles the response to the GetSQLContainerThroughput request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) GetSQLContainerThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSQLDatabase gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
func (client SQLResourcesClient) GetSQLDatabase(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result SQLDatabaseGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.GetSQLDatabase")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "GetSQLDatabase", err.Error())
	}

	req, err := client.GetSQLDatabasePreparer(ctx, resourceGroupName, accountName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLDatabase", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSQLDatabaseSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLDatabase", resp, "Failure sending request")
		return
	}

	result, err = client.GetSQLDatabaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLDatabase", resp, "Failure responding to request")
		return
	}

	return
}

// GetSQLDatabasePreparer prepares the GetSQLDatabase request.
func (client SQLResourcesClient) GetSQLDatabasePreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSQLDatabaseSender sends the GetSQLDatabase request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) GetSQLDatabaseSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSQLDatabaseResponder handles the response to the GetSQLDatabase request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) GetSQLDatabaseResponder(resp *http.Response) (result SQLDatabaseGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSQLDatabaseThroughput gets the RUs per second of the SQL database under an existing Azure Cosmos DB database
// account with the provided name.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
func (client SQLResourcesClient) GetSQLDatabaseThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result ThroughputSettingsGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.GetSQLDatabaseThroughput")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "GetSQLDatabaseThroughput", err.Error())
	}

	req, err := client.GetSQLDatabaseThroughputPreparer(ctx, resourceGroupName, accountName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLDatabaseThroughput", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSQLDatabaseThroughputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLDatabaseThroughput", resp, "Failure sending request")
		return
	}

	result, err = client.GetSQLDatabaseThroughputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLDatabaseThroughput", resp, "Failure responding to request")
		return
	}

	return
}

// GetSQLDatabaseThroughputPreparer prepares the GetSQLDatabaseThroughput request.
func (client SQLResourcesClient) GetSQLDatabaseThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSQLDatabaseThroughputSender sends the GetSQLDatabaseThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) GetSQLDatabaseThroughputSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSQLDatabaseThroughputResponder handles the response to the GetSQLDatabaseThroughput request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) GetSQLDatabaseThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSQLRoleAssignment retrieves the properties of an existing Azure Cosmos DB SQL Role Assignment with the given Id.
// Parameters:
// roleAssignmentID - the GUID for the Role Assignment.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
func (client SQLResourcesClient) GetSQLRoleAssignment(ctx context.Context, roleAssignmentID string, resourceGroupName string, accountName string) (result SQLRoleAssignmentGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.GetSQLRoleAssignment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "GetSQLRoleAssignment", err.Error())
	}

	req, err := client.GetSQLRoleAssignmentPreparer(ctx, roleAssignmentID, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLRoleAssignment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSQLRoleAssignmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLRoleAssignment", resp, "Failure sending request")
		return
	}

	result, err = client.GetSQLRoleAssignmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLRoleAssignment", resp, "Failure responding to request")
		return
	}

	return
}

// GetSQLRoleAssignmentPreparer prepares the GetSQLRoleAssignment request.
func (client SQLResourcesClient) GetSQLRoleAssignmentPreparer(ctx context.Context, roleAssignmentID string, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"roleAssignmentId":  autorest.Encode("path", roleAssignmentID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleAssignments/{roleAssignmentId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSQLRoleAssignmentSender sends the GetSQLRoleAssignment request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) GetSQLRoleAssignmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSQLRoleAssignmentResponder handles the response to the GetSQLRoleAssignment request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) GetSQLRoleAssignmentResponder(resp *http.Response) (result SQLRoleAssignmentGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSQLRoleDefinition retrieves the properties of an existing Azure Cosmos DB SQL Role Definition with the given Id.
// Parameters:
// roleDefinitionID - the GUID for the Role Definition.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
func (client SQLResourcesClient) GetSQLRoleDefinition(ctx context.Context, roleDefinitionID string, resourceGroupName string, accountName string) (result SQLRoleDefinitionGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.GetSQLRoleDefinition")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "GetSQLRoleDefinition", err.Error())
	}

	req, err := client.GetSQLRoleDefinitionPreparer(ctx, roleDefinitionID, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLRoleDefinition", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSQLRoleDefinitionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLRoleDefinition", resp, "Failure sending request")
		return
	}

	result, err = client.GetSQLRoleDefinitionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLRoleDefinition", resp, "Failure responding to request")
		return
	}

	return
}

// GetSQLRoleDefinitionPreparer prepares the GetSQLRoleDefinition request.
func (client SQLResourcesClient) GetSQLRoleDefinitionPreparer(ctx context.Context, roleDefinitionID string, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"roleDefinitionId":  autorest.Encode("path", roleDefinitionID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleDefinitions/{roleDefinitionId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSQLRoleDefinitionSender sends the GetSQLRoleDefinition request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) GetSQLRoleDefinitionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSQLRoleDefinitionResponder handles the response to the GetSQLRoleDefinition request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) GetSQLRoleDefinitionResponder(resp *http.Response) (result SQLRoleDefinitionGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSQLStoredProcedure gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
// storedProcedureName - cosmos DB storedProcedure name.
func (client SQLResourcesClient) GetSQLStoredProcedure(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, storedProcedureName string) (result SQLStoredProcedureGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.GetSQLStoredProcedure")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "GetSQLStoredProcedure", err.Error())
	}

	req, err := client.GetSQLStoredProcedurePreparer(ctx, resourceGroupName, accountName, databaseName, containerName, storedProcedureName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLStoredProcedure", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSQLStoredProcedureSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLStoredProcedure", resp, "Failure sending request")
		return
	}

	result, err = client.GetSQLStoredProcedureResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLStoredProcedure", resp, "Failure responding to request")
		return
	}

	return
}

// GetSQLStoredProcedurePreparer prepares the GetSQLStoredProcedure request.
func (client SQLResourcesClient) GetSQLStoredProcedurePreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, storedProcedureName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":         autorest.Encode("path", accountName),
		"containerName":       autorest.Encode("path", containerName),
		"databaseName":        autorest.Encode("path", databaseName),
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"storedProcedureName": autorest.Encode("path", storedProcedureName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSQLStoredProcedureSender sends the GetSQLStoredProcedure request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) GetSQLStoredProcedureSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSQLStoredProcedureResponder handles the response to the GetSQLStoredProcedure request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) GetSQLStoredProcedureResponder(resp *http.Response) (result SQLStoredProcedureGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSQLTrigger gets the SQL trigger under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
// triggerName - cosmos DB trigger name.
func (client SQLResourcesClient) GetSQLTrigger(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, triggerName string) (result SQLTriggerGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.GetSQLTrigger")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "GetSQLTrigger", err.Error())
	}

	req, err := client.GetSQLTriggerPreparer(ctx, resourceGroupName, accountName, databaseName, containerName, triggerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLTrigger", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSQLTriggerSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLTrigger", resp, "Failure sending request")
		return
	}

	result, err = client.GetSQLTriggerResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLTrigger", resp, "Failure responding to request")
		return
	}

	return
}

// GetSQLTriggerPreparer prepares the GetSQLTrigger request.
func (client SQLResourcesClient) GetSQLTriggerPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, triggerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"triggerName":       autorest.Encode("path", triggerName),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSQLTriggerSender sends the GetSQLTrigger request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) GetSQLTriggerSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSQLTriggerResponder handles the response to the GetSQLTrigger request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) GetSQLTriggerResponder(resp *http.Response) (result SQLTriggerGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSQLUserDefinedFunction gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
// userDefinedFunctionName - cosmos DB userDefinedFunction name.
func (client SQLResourcesClient) GetSQLUserDefinedFunction(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, userDefinedFunctionName string) (result SQLUserDefinedFunctionGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.GetSQLUserDefinedFunction")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "GetSQLUserDefinedFunction", err.Error())
	}

	req, err := client.GetSQLUserDefinedFunctionPreparer(ctx, resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLUserDefinedFunction", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSQLUserDefinedFunctionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLUserDefinedFunction", resp, "Failure sending request")
		return
	}

	result, err = client.GetSQLUserDefinedFunctionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "GetSQLUserDefinedFunction", resp, "Failure responding to request")
		return
	}

	return
}

// GetSQLUserDefinedFunctionPreparer prepares the GetSQLUserDefinedFunction request.
func (client SQLResourcesClient) GetSQLUserDefinedFunctionPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, userDefinedFunctionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":             autorest.Encode("path", accountName),
		"containerName":           autorest.Encode("path", containerName),
		"databaseName":            autorest.Encode("path", databaseName),
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
		"userDefinedFunctionName": autorest.Encode("path", userDefinedFunctionName),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSQLUserDefinedFunctionSender sends the GetSQLUserDefinedFunction request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) GetSQLUserDefinedFunctionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSQLUserDefinedFunctionResponder handles the response to the GetSQLUserDefinedFunction request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) GetSQLUserDefinedFunctionResponder(resp *http.Response) (result SQLUserDefinedFunctionGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSQLContainers lists the SQL container under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
func (client SQLResourcesClient) ListSQLContainers(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result SQLContainerListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.ListSQLContainers")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "ListSQLContainers", err.Error())
	}

	req, err := client.ListSQLContainersPreparer(ctx, resourceGroupName, accountName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLContainers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSQLContainersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLContainers", resp, "Failure sending request")
		return
	}

	result, err = client.ListSQLContainersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLContainers", resp, "Failure responding to request")
		return
	}

	return
}

// ListSQLContainersPreparer prepares the ListSQLContainers request.
func (client SQLResourcesClient) ListSQLContainersPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSQLContainersSender sends the ListSQLContainers request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) ListSQLContainersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSQLContainersResponder handles the response to the ListSQLContainers request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) ListSQLContainersResponder(resp *http.Response) (result SQLContainerListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSQLDatabases lists the SQL databases under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
func (client SQLResourcesClient) ListSQLDatabases(ctx context.Context, resourceGroupName string, accountName string) (result SQLDatabaseListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.ListSQLDatabases")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "ListSQLDatabases", err.Error())
	}

	req, err := client.ListSQLDatabasesPreparer(ctx, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLDatabases", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSQLDatabasesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLDatabases", resp, "Failure sending request")
		return
	}

	result, err = client.ListSQLDatabasesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLDatabases", resp, "Failure responding to request")
		return
	}

	return
}

// ListSQLDatabasesPreparer prepares the ListSQLDatabases request.
func (client SQLResourcesClient) ListSQLDatabasesPreparer(ctx context.Context, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSQLDatabasesSender sends the ListSQLDatabases request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) ListSQLDatabasesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSQLDatabasesResponder handles the response to the ListSQLDatabases request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) ListSQLDatabasesResponder(resp *http.Response) (result SQLDatabaseListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSQLRoleAssignments retrieves the list of all Azure Cosmos DB SQL Role Assignments.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
func (client SQLResourcesClient) ListSQLRoleAssignments(ctx context.Context, resourceGroupName string, accountName string) (result SQLRoleAssignmentListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.ListSQLRoleAssignments")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "ListSQLRoleAssignments", err.Error())
	}

	req, err := client.ListSQLRoleAssignmentsPreparer(ctx, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLRoleAssignments", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSQLRoleAssignmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLRoleAssignments", resp, "Failure sending request")
		return
	}

	result, err = client.ListSQLRoleAssignmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLRoleAssignments", resp, "Failure responding to request")
		return
	}

	return
}

// ListSQLRoleAssignmentsPreparer prepares the ListSQLRoleAssignments request.
func (client SQLResourcesClient) ListSQLRoleAssignmentsPreparer(ctx context.Context, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleAssignments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSQLRoleAssignmentsSender sends the ListSQLRoleAssignments request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) ListSQLRoleAssignmentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSQLRoleAssignmentsResponder handles the response to the ListSQLRoleAssignments request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) ListSQLRoleAssignmentsResponder(resp *http.Response) (result SQLRoleAssignmentListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSQLRoleDefinitions retrieves the list of all Azure Cosmos DB SQL Role Definitions.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
func (client SQLResourcesClient) ListSQLRoleDefinitions(ctx context.Context, resourceGroupName string, accountName string) (result SQLRoleDefinitionListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.ListSQLRoleDefinitions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "ListSQLRoleDefinitions", err.Error())
	}

	req, err := client.ListSQLRoleDefinitionsPreparer(ctx, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLRoleDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSQLRoleDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLRoleDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.ListSQLRoleDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLRoleDefinitions", resp, "Failure responding to request")
		return
	}

	return
}

// ListSQLRoleDefinitionsPreparer prepares the ListSQLRoleDefinitions request.
func (client SQLResourcesClient) ListSQLRoleDefinitionsPreparer(ctx context.Context, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleDefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSQLRoleDefinitionsSender sends the ListSQLRoleDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) ListSQLRoleDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSQLRoleDefinitionsResponder handles the response to the ListSQLRoleDefinitions request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) ListSQLRoleDefinitionsResponder(resp *http.Response) (result SQLRoleDefinitionListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSQLStoredProcedures lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
func (client SQLResourcesClient) ListSQLStoredProcedures(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result SQLStoredProcedureListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.ListSQLStoredProcedures")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "ListSQLStoredProcedures", err.Error())
	}

	req, err := client.ListSQLStoredProceduresPreparer(ctx, resourceGroupName, accountName, databaseName, containerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLStoredProcedures", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSQLStoredProceduresSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLStoredProcedures", resp, "Failure sending request")
		return
	}

	result, err = client.ListSQLStoredProceduresResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLStoredProcedures", resp, "Failure responding to request")
		return
	}

	return
}

// ListSQLStoredProceduresPreparer prepares the ListSQLStoredProcedures request.
func (client SQLResourcesClient) ListSQLStoredProceduresPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSQLStoredProceduresSender sends the ListSQLStoredProcedures request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) ListSQLStoredProceduresSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSQLStoredProceduresResponder handles the response to the ListSQLStoredProcedures request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) ListSQLStoredProceduresResponder(resp *http.Response) (result SQLStoredProcedureListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSQLTriggers lists the SQL trigger under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
func (client SQLResourcesClient) ListSQLTriggers(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result SQLTriggerListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.ListSQLTriggers")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "ListSQLTriggers", err.Error())
	}

	req, err := client.ListSQLTriggersPreparer(ctx, resourceGroupName, accountName, databaseName, containerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLTriggers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSQLTriggersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLTriggers", resp, "Failure sending request")
		return
	}

	result, err = client.ListSQLTriggersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLTriggers", resp, "Failure responding to request")
		return
	}

	return
}

// ListSQLTriggersPreparer prepares the ListSQLTriggers request.
func (client SQLResourcesClient) ListSQLTriggersPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSQLTriggersSender sends the ListSQLTriggers request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) ListSQLTriggersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSQLTriggersResponder handles the response to the ListSQLTriggers request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) ListSQLTriggersResponder(resp *http.Response) (result SQLTriggerListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSQLUserDefinedFunctions lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
func (client SQLResourcesClient) ListSQLUserDefinedFunctions(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result SQLUserDefinedFunctionListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.ListSQLUserDefinedFunctions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "ListSQLUserDefinedFunctions", err.Error())
	}

	req, err := client.ListSQLUserDefinedFunctionsPreparer(ctx, resourceGroupName, accountName, databaseName, containerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLUserDefinedFunctions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSQLUserDefinedFunctionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLUserDefinedFunctions", resp, "Failure sending request")
		return
	}

	result, err = client.ListSQLUserDefinedFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "ListSQLUserDefinedFunctions", resp, "Failure responding to request")
		return
	}

	return
}

// ListSQLUserDefinedFunctionsPreparer prepares the ListSQLUserDefinedFunctions request.
func (client SQLResourcesClient) ListSQLUserDefinedFunctionsPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSQLUserDefinedFunctionsSender sends the ListSQLUserDefinedFunctions request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) ListSQLUserDefinedFunctionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSQLUserDefinedFunctionsResponder handles the response to the ListSQLUserDefinedFunctions request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) ListSQLUserDefinedFunctionsResponder(resp *http.Response) (result SQLUserDefinedFunctionListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MigrateSQLContainerToAutoscale migrate an Azure Cosmos DB SQL container from manual throughput to autoscale
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
func (client SQLResourcesClient) MigrateSQLContainerToAutoscale(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result SQLResourcesMigrateSQLContainerToAutoscaleFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.MigrateSQLContainerToAutoscale")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "MigrateSQLContainerToAutoscale", err.Error())
	}

	req, err := client.MigrateSQLContainerToAutoscalePreparer(ctx, resourceGroupName, accountName, databaseName, containerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "MigrateSQLContainerToAutoscale", nil, "Failure preparing request")
		return
	}

	result, err = client.MigrateSQLContainerToAutoscaleSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "MigrateSQLContainerToAutoscale", result.Response(), "Failure sending request")
		return
	}

	return
}

// MigrateSQLContainerToAutoscalePreparer prepares the MigrateSQLContainerToAutoscale request.
func (client SQLResourcesClient) MigrateSQLContainerToAutoscalePreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default/migrateToAutoscale", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MigrateSQLContainerToAutoscaleSender sends the MigrateSQLContainerToAutoscale request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) MigrateSQLContainerToAutoscaleSender(req *http.Request) (future SQLResourcesMigrateSQLContainerToAutoscaleFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// MigrateSQLContainerToAutoscaleResponder handles the response to the MigrateSQLContainerToAutoscale request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) MigrateSQLContainerToAutoscaleResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MigrateSQLContainerToManualThroughput migrate an Azure Cosmos DB SQL container from autoscale to manual throughput
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
func (client SQLResourcesClient) MigrateSQLContainerToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result SQLResourcesMigrateSQLContainerToManualThroughputFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.MigrateSQLContainerToManualThroughput")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "MigrateSQLContainerToManualThroughput", err.Error())
	}

	req, err := client.MigrateSQLContainerToManualThroughputPreparer(ctx, resourceGroupName, accountName, databaseName, containerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "MigrateSQLContainerToManualThroughput", nil, "Failure preparing request")
		return
	}

	result, err = client.MigrateSQLContainerToManualThroughputSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "MigrateSQLContainerToManualThroughput", result.Response(), "Failure sending request")
		return
	}

	return
}

// MigrateSQLContainerToManualThroughputPreparer prepares the MigrateSQLContainerToManualThroughput request.
func (client SQLResourcesClient) MigrateSQLContainerToManualThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default/migrateToManualThroughput", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MigrateSQLContainerToManualThroughputSender sends the MigrateSQLContainerToManualThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) MigrateSQLContainerToManualThroughputSender(req *http.Request) (future SQLResourcesMigrateSQLContainerToManualThroughputFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// MigrateSQLContainerToManualThroughputResponder handles the response to the MigrateSQLContainerToManualThroughput request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) MigrateSQLContainerToManualThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MigrateSQLDatabaseToAutoscale migrate an Azure Cosmos DB SQL database from manual throughput to autoscale
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
func (client SQLResourcesClient) MigrateSQLDatabaseToAutoscale(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result SQLResourcesMigrateSQLDatabaseToAutoscaleFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.MigrateSQLDatabaseToAutoscale")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "MigrateSQLDatabaseToAutoscale", err.Error())
	}

	req, err := client.MigrateSQLDatabaseToAutoscalePreparer(ctx, resourceGroupName, accountName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "MigrateSQLDatabaseToAutoscale", nil, "Failure preparing request")
		return
	}

	result, err = client.MigrateSQLDatabaseToAutoscaleSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "MigrateSQLDatabaseToAutoscale", result.Response(), "Failure sending request")
		return
	}

	return
}

// MigrateSQLDatabaseToAutoscalePreparer prepares the MigrateSQLDatabaseToAutoscale request.
func (client SQLResourcesClient) MigrateSQLDatabaseToAutoscalePreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default/migrateToAutoscale", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MigrateSQLDatabaseToAutoscaleSender sends the MigrateSQLDatabaseToAutoscale request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) MigrateSQLDatabaseToAutoscaleSender(req *http.Request) (future SQLResourcesMigrateSQLDatabaseToAutoscaleFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// MigrateSQLDatabaseToAutoscaleResponder handles the response to the MigrateSQLDatabaseToAutoscale request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) MigrateSQLDatabaseToAutoscaleResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MigrateSQLDatabaseToManualThroughput migrate an Azure Cosmos DB SQL database from autoscale to manual throughput
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
func (client SQLResourcesClient) MigrateSQLDatabaseToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result SQLResourcesMigrateSQLDatabaseToManualThroughputFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.MigrateSQLDatabaseToManualThroughput")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "MigrateSQLDatabaseToManualThroughput", err.Error())
	}

	req, err := client.MigrateSQLDatabaseToManualThroughputPreparer(ctx, resourceGroupName, accountName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "MigrateSQLDatabaseToManualThroughput", nil, "Failure preparing request")
		return
	}

	result, err = client.MigrateSQLDatabaseToManualThroughputSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "MigrateSQLDatabaseToManualThroughput", result.Response(), "Failure sending request")
		return
	}

	return
}

// MigrateSQLDatabaseToManualThroughputPreparer prepares the MigrateSQLDatabaseToManualThroughput request.
func (client SQLResourcesClient) MigrateSQLDatabaseToManualThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default/migrateToManualThroughput", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MigrateSQLDatabaseToManualThroughputSender sends the MigrateSQLDatabaseToManualThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) MigrateSQLDatabaseToManualThroughputSender(req *http.Request) (future SQLResourcesMigrateSQLDatabaseToManualThroughputFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// MigrateSQLDatabaseToManualThroughputResponder handles the response to the MigrateSQLDatabaseToManualThroughput request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) MigrateSQLDatabaseToManualThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSQLContainerThroughput update RUs per second of an Azure Cosmos DB SQL container
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// containerName - cosmos DB container name.
// updateThroughputParameters - the parameters to provide for the RUs per second of the current SQL container.
func (client SQLResourcesClient) UpdateSQLContainerThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, updateThroughputParameters ThroughputSettingsUpdateParameters) (result SQLResourcesUpdateSQLContainerThroughputFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.UpdateSQLContainerThroughput")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: updateThroughputParameters,
			Constraints: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource.AutoscaleSettings", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource.AutoscaleSettings.MaxThroughput", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "UpdateSQLContainerThroughput", err.Error())
	}

	req, err := client.UpdateSQLContainerThroughputPreparer(ctx, resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "UpdateSQLContainerThroughput", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSQLContainerThroughputSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "UpdateSQLContainerThroughput", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdateSQLContainerThroughputPreparer prepares the UpdateSQLContainerThroughput request.
func (client SQLResourcesClient) UpdateSQLContainerThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, updateThroughputParameters ThroughputSettingsUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"containerName":     autorest.Encode("path", containerName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default", pathParameters),
		autorest.WithJSON(updateThroughputParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSQLContainerThroughputSender sends the UpdateSQLContainerThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) UpdateSQLContainerThroughputSender(req *http.Request) (future SQLResourcesUpdateSQLContainerThroughputFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateSQLContainerThroughputResponder handles the response to the UpdateSQLContainerThroughput request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) UpdateSQLContainerThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSQLDatabaseThroughput update RUs per second of an Azure Cosmos DB SQL database
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// databaseName - cosmos DB database name.
// updateThroughputParameters - the parameters to provide for the RUs per second of the current SQL database.
func (client SQLResourcesClient) UpdateSQLDatabaseThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, updateThroughputParameters ThroughputSettingsUpdateParameters) (result SQLResourcesUpdateSQLDatabaseThroughputFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLResourcesClient.UpdateSQLDatabaseThroughput")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: updateThroughputParameters,
			Constraints: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource.AutoscaleSettings", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource.AutoscaleSettings.MaxThroughput", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.SQLResourcesClient", "UpdateSQLDatabaseThroughput", err.Error())
	}

	req, err := client.UpdateSQLDatabaseThroughputPreparer(ctx, resourceGroupName, accountName, databaseName, updateThroughputParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "UpdateSQLDatabaseThroughput", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSQLDatabaseThroughputSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesClient", "UpdateSQLDatabaseThroughput", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdateSQLDatabaseThroughputPreparer prepares the UpdateSQLDatabaseThroughput request.
func (client SQLResourcesClient) UpdateSQLDatabaseThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, updateThroughputParameters ThroughputSettingsUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default", pathParameters),
		autorest.WithJSON(updateThroughputParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSQLDatabaseThroughputSender sends the UpdateSQLDatabaseThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client SQLResourcesClient) UpdateSQLDatabaseThroughputSender(req *http.Request) (future SQLResourcesUpdateSQLDatabaseThroughputFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateSQLDatabaseThroughputResponder handles the response to the UpdateSQLDatabaseThroughput request. The method always
// closes the http.Response Body.
func (client SQLResourcesClient) UpdateSQLDatabaseThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
