// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A summary of findings metrics in an account.
type AccountFindingsMetric struct {

	// The number of closed findings of each severity in an account on the specified
	// date.
	ClosedFindings *FindingMetricsValuePerSeverity

	// The date from which the finding metrics were retrieved.
	Date *time.Time

	// The average time it takes to close findings of each severity in days.
	MeanTimeToClose *FindingMetricsValuePerSeverity

	// The number of new findings of each severity in account on the specified date.
	NewFindings *FindingMetricsValuePerSeverity

	// The number of open findings of each severity in an account as of the specified
	// date.
	OpenFindings *FindingMetricsValuePerSeverity

	noSmithyDocumentSerde
}

// Contains information about the error that caused a finding to fail to be
// retrieved.
type BatchGetFindingsError struct {

	// A code associated with the type of error.
	//
	// This member is required.
	ErrorCode ErrorCode

	// The finding ID of the finding that was not fetched.
	//
	// This member is required.
	FindingId *string

	// Describes the error.
	//
	// This member is required.
	Message *string

	// The name of the scan that generated the finding.
	//
	// This member is required.
	ScanName *string

	noSmithyDocumentSerde
}

// Information about a finding category with open findings.
type CategoryWithFindingNum struct {

	// The name of the finding category. A finding category is determined by the
	// detector that detected the finding.
	CategoryName *string

	// The number of open findings in the category.
	FindingNumber *int32

	noSmithyDocumentSerde
}

// The line of code where a finding was detected.
type CodeLine struct {

	// The code that contains a vulnerability.
	Content *string

	// The code line number.
	Number *int32

	noSmithyDocumentSerde
}

// Information about account-level configuration.
type EncryptionConfig struct {

	// The KMS key ARN to use for encryption. This must be provided as a header when
	// uploading your code resource.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Information about the location of security vulnerabilities that Amazon CodeGuru
// Security detected in your code.
type FilePath struct {

	// A list of CodeLine objects that describe where the security vulnerability
	// appears in your code.
	CodeSnippet []CodeLine

	// The last line number of the code snippet where the security vulnerability
	// appears in your code.
	EndLine *int32

	// The name of the file.
	Name *string

	// The path to the resource with the security vulnerability.
	Path *string

	// The first line number of the code snippet where the security vulnerability
	// appears in your code.
	StartLine *int32

	noSmithyDocumentSerde
}

// Information about a finding that was detected in your code.
type Finding struct {

	// The time when the finding was created.
	CreatedAt *time.Time

	// A description of the finding.
	Description *string

	// The identifier for the detector that detected the finding in your code. A
	// detector is a defined rule based on industry standards and AWS best practices.
	DetectorId *string

	// The name of the detector that identified the security vulnerability in your
	// code.
	DetectorName *string

	// One or more tags or categorizations that are associated with a detector. These
	// tags are defined by type, programming language, or other classification such as
	// maintainability or consistency.
	DetectorTags []string

	// The identifier for the component that generated a finding such as
	// AWSCodeGuruSecurity or AWSInspector.
	GeneratorId *string

	// The identifier for a finding.
	Id *string

	// An object that contains the details about how to remediate a finding.
	Remediation *Remediation

	// The resource where Amazon CodeGuru Security detected a finding.
	Resource *Resource

	// The identifier for the rule that generated the finding.
	RuleId *string

	// The severity of the finding.
	Severity Severity

	// The status of the finding. A finding status can be open or closed.
	Status Status

	// The title of the finding.
	Title *string

	// The type of finding.
	Type *string

	// The time when the finding was last updated. Findings are updated when you
	// remediate them or when the finding code location changes.
	UpdatedAt *time.Time

	// An object that describes the detected security vulnerability.
	Vulnerability *Vulnerability

	noSmithyDocumentSerde
}

// An object that contains information about a finding and the scan that generated
// it.
type FindingIdentifier struct {

	// The identifier for a finding.
	//
	// This member is required.
	FindingId *string

	// The name of the scan that generated the finding.
	//
	// This member is required.
	ScanName *string

	noSmithyDocumentSerde
}

// The severity of the issue in the code that generated a finding.
type FindingMetricsValuePerSeverity struct {

	// The severity of the finding is critical and should be addressed immediately.
	Critical *float64

	// The severity of the finding is high and should be addressed as a near-term
	// priority.
	High *float64

	// The finding is related to quality or readability improvements and not
	// considered actionable.
	Info *float64

	// The severity of the finding is low and does require action on its own.
	Low *float64

	// The severity of the finding is medium and should be addressed as a mid-term
	// priority.
	Medium *float64

	noSmithyDocumentSerde
}

// Information about summary metrics in an account.
type MetricsSummary struct {

	// A list of CategoryWithFindingNum objects for the top 5 finding categories with
	// the most open findings in an account.
	CategoriesWithMostFindings []CategoryWithFindingNum

	// The date from which the metrics summary information was retrieved.
	Date *time.Time

	// The number of open findings of each severity in an account.
	OpenFindings *FindingMetricsValuePerSeverity

	// A list of ScanNameWithFindingNum objects for the top 3 scans with the most
	// number of open findings in an account.
	ScansWithMostOpenCriticalFindings []ScanNameWithFindingNum

	// A list of ScanNameWithFindingNum objects for the top 3 scans with the most
	// number of open critical findings in an account.
	ScansWithMostOpenFindings []ScanNameWithFindingNum

	noSmithyDocumentSerde
}

// Information about the recommended course of action to remediate a finding.
type Recommendation struct {

	// The recommended course of action to remediate the finding.
	Text *string

	// The URL address to the recommendation for remediating the finding.
	Url *string

	noSmithyDocumentSerde
}

// Information about how to remediate a finding.
type Remediation struct {

	// An object that contains information about the recommended course of action to
	// remediate a finding.
	Recommendation *Recommendation

	// A list of SuggestedFix objects. Each object contains information about a
	// suggested code fix to remediate the finding.
	SuggestedFixes []SuggestedFix

	noSmithyDocumentSerde
}

// Information about a resource, such as an Amazon S3 bucket or AWS Lambda
// function, that contains a finding.
type Resource struct {

	// The identifier for the resource.
	Id *string

	// The identifier for a section of the resource, such as an AWS Lambda layer.
	SubResourceId *string

	noSmithyDocumentSerde
}

// The identifier for a resource object that contains resources where a finding
// was detected.
//
// The following types satisfy this interface:
//
//	ResourceIdMemberCodeArtifactId
type ResourceId interface {
	isResourceId()
}

// The identifier for the code file uploaded to the resource where a finding was
// detected.
type ResourceIdMemberCodeArtifactId struct {
	Value string

	noSmithyDocumentSerde
}

func (*ResourceIdMemberCodeArtifactId) isResourceId() {}

// Information about a scan with open findings.
type ScanNameWithFindingNum struct {

	// The number of open findings generated by a scan.
	FindingNumber *int32

	// The name of the scan.
	ScanName *string

	noSmithyDocumentSerde
}

// Information about a scan.
type ScanSummary struct {

	//  The time when the scan was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The identifier for the scan run.
	//
	// This member is required.
	RunId *string

	// The name of the scan.
	//
	// This member is required.
	ScanName *string

	// The state of the scan. A scan can be In Progress , Complete , or Failed .
	//
	// This member is required.
	ScanState ScanState

	// The ARN for the scan name.
	ScanNameArn *string

	// The time the scan was last updated. A scan is updated when it is re-run.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Information about the suggested code fix to remediate a finding.
type SuggestedFix struct {

	// The suggested code to add to your file.
	Code *string

	// A description of the suggested code fix and why it is being suggested.
	Description *string

	noSmithyDocumentSerde
}

// Information about a validation exception.
type ValidationExceptionField struct {

	// Describes the exception.
	//
	// This member is required.
	Message *string

	// The name of the exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Information about a security vulnerability that Amazon CodeGuru Security
// detected.
type Vulnerability struct {

	//  An object that describes the location of the detected security vulnerability
	// in your code.
	FilePath *FilePath

	// The identifier for the vulnerability.
	Id *string

	//  The number of times the vulnerability appears in your code.
	ItemCount *int32

	// One or more URL addresses that contain details about a vulnerability.
	ReferenceUrls []string

	// One or more vulnerabilities that are related to the vulnerability being
	// described.
	RelatedVulnerabilities []string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isResourceId() {}
