# 자주 묻는 질문(FAQ)

### Noto는 무엇을 의미하나요?

컴퓨터가 텍스트를 렌더링할 때 문자가 작은 상자로 표시되는 경우가 있는데, 이는 기기에 그 글자를 표현할 이미지가 포함된 글꼴이 없기 때문입니다. 이 상자는 '두부(tofu)'라고 알려져 있습니다.  Noto라는 이름은 사용자에게 더 이상 두부가 표시되지 않도록(**no** more **to**fu) 하려는 Google의 목표를 담고 있습니다.


### 버그는 어떻게 신고하나요?

프로젝트의 [버그 목록](https://github.com/googlefonts/noto-cjk/issues) 페이지에서 신고해 주세요. 가능한 한 자세히 설명해 주셔야 합니다. 기술적 문제인 경우 사용 중인 소프트웨어 및 운영체제와 버전을 기재해 주세요. 디자인 문제인 경우 이미지와 도표를 첨부하면 큰 도움이 됩니다.


### 참여하려면 어떻게 해야 하나요?

저장소를 복제하고 글꼴을 시험해 본 후 버그를 신고해 주세요. 도구 개발에 참여하고 싶다면 도구 저장소의 참여자 약관을 작성해 주세요.  다양한 저장소를 확인하려면 아래를 참조하세요.


### 글꼴은 어디에서 찾을 수 있나요?

글꼴은 여러 저장소에서 찾을 수 있습니다.

* 대부분의 Noto 글꼴은 [GitHub 저장소](https://github.com/googlefonts/noto-fonts)에 있습니다.
* Noto CJK 글꼴은 [noto-cjk](https://github.com/googlefonts/noto-cjk)에 있습니다.
* Noto 그림 이모티콘과 Noto 컬러 그림 이모티콘은 [noto-emoji](https://github.com/googlefonts/noto-emoji)에 있습니다.

전체 Noto 글꼴 및 도구는 [GitHub 저장소](https://github.com/googlefonts?query=noto)에서 찾아볼 수 있습니다.


### 토론방이 있나요?

개발 및 사용자 토론은 [noto-font Google 그룹스](https://groups.google.com/d/forum/noto-font)에서 이루어집니다.


### Noto는 어떤 표기 체제를 지원하나요?

2016년 9월부로 Noto 글꼴은 유니코드 6.1에 정의된 문자/표기 체계를 모두 지원합니다.
* Noto에서는 현재 사용되는 모든 주요 문자에 두 가지 굵기(보통 및 굵게)와 UI 및 비 UI 글꼴을 모두 지원합니다. UI 글꼴은 높이 제한이 있는 UI 요소(예: 버튼, 메뉴)의 텍스트 표시에 사용됩니다.
* Noto에서는 현재 사용되는 대부분의 문자에 여러 글꼴 스타일을 지원합니다. 예를 들어 라틴어, 그리스어, 키릴어, 인도어(데바나가리, 타밀, 텔루구 등), 아르메니아어, 조지아어, 태국어, 크메르어, 라오스어의 Sans-serif 및 Serif 스타일을 지원하며 아랍어의 나스흐 및 쿠피 스타일, 시리아어의 동부, 서부 및 시리아 고대 문자 스타일을 지원합니다.
* Noto는 현재 사용되는 주요 문자 대부분에 힌팅된 글꼴과 힌팅되지 않은 글꼴을 모두 제공합니다. Windows 및 Linux의 경우 힌팅된 글꼴이 사용되며, Android 및 Mac의 경우 힌팅되지 않은 글꼴이 사용됩니다. 하지만 NotoSansSymbols는 힌팅되지 않은 글꼴입니다.
* 더 이상 사용되지 않는 문자의 경우 Noto는 한 가지 굵기의(보통) 힌팅되지 않은 글꼴을 지원합니다.


### 힌팅된 글꼴 버전이 없습니다

좋아하는 Noto 글꼴이 힌팅되지 않은 글꼴 디렉토리에는 있지만 [힌팅된 글꼴 디렉토리](https://github.com/googlefonts/noto-fonts/tree/master/hinted)에는 없는 경우, 먼저 [noto-hinted](https://github.com/lemzwerg/noto-hinted)를 확인해 보세요. 이미 여기에 있을 수도 있습니다. 여기에도 없다면 [ttfautohint](https://www.freetype.org/ttfautohint/)로 힌팅 프로세스를 실행하여 만들 수 있습니다. 프로세스는 [noto-hinted README](https://github.com/lemzwerg/noto-hinted/blob/master/README.md)에 설명되어 있습니다.  하지만 이 도구를 모든 문자에 사용할 수 있는 것은 아니며, 특히 현재 사용되고 있지만 Google에서 힌팅된 버전을 제공하지 않는 대부분의 문자에는 사용할 수 없습니다.  원하신다면 freetype 웹사이트의 [새로운 wscripts를 사용하여 ttfautohint 확장](https://www.freetype.org/ttfautohint/doc/ttfautohint.html#extending-ttfautohint-with-new-scripts)을 참조하세요.


### Noto에 관련된 Google의 계획은 무엇인가요(소위 '3단계')?
* CJK를 제외한 유니코드 9.0을 100% 지원할 수 있도록 문자 범위를 확장할 계획입니다. CJK의 경우 유니코드 9.0에서 Plane 0(BMP) CJK 문자를 지원하려고 합니다.
* 두 가지 굵기(보통 및 굵게)와 한 가지 너비로만 제공되는 Noto를 다양한 굵기(얇게~굵게)와 다양한 너비(좁게~보통)로 확장할 계획입니다.
* 모든 Noto 글꼴의 소스 문자 및 기타 소스 데이터를 오픈소스 방식으로 공유하고(Adobe에서 소스를 소유 중인 CJK 글꼴 제외), 이 소스로부터 바이너리 글꼴을 만들 수 있도록 파이프라인을 제공할 계획입니다. 글꼴 소스와 파이프라인이 있으면 누구나 나만의 글꼴을 만들고 Noto를 무료 기본 글꼴로 사용할 수 있습니다.


### X 언어 또는 문자는 Noto에서 언제 지원하나요?

유니코드에서 인코딩되는 문자를 모두 지원할 계획입니다. 하지만 여기에는 시간이 많이 소요되며 문자의 복잡성, 제품 및 프로젝트 요구, 문자 전문가와 디자이너의 참여 가능성, 언어 검토자의 수와 반응성 등 복잡하고 변동적인 요소들을 바탕으로 개발 순서가 정해집니다.


### Y 문자보다 X 문자 글꼴을 먼저 개발한 이유는 무엇인가요?

어떤 글꼴을 먼저 개발하기로 했는지와는 상관없이 어떤 문자는 다른 문자보다 먼저 개발됩니다. 1,000명분의 연회 식사를 제공하는 경우를 생각해 보겠습니다. 음식이 준비되는 대로 제공하면 어떤 손님은 다른 손님보다 먼저 음식을 받게 됩니다. 또는 음식이 모두 준비될 때까지 제공하지 않고 기다릴 수도 있습니다. Google에서는 준비되는 대로 제공하는 방식을 택하고 있습니다.


### Noto 디자인은 무엇인가요?

Noto는 모든 언어가 조화를 이루면서도 고유의 특징을 유지하도록 디자인됩니다. Noto의 목적은 각 문자의 독특한 특징을 놓치지 않으면서도 모든 언어를 온라인에서 매끄럽게 읽을 수 있도록 하는 것입니다. 아주 스타일리시하지만 한 시즌만에 유행에 뒤처지게 되는 옷보다는 평생 옷장에 보관할 수 있는, 스타일리시하면서도 수수한 옷 같은 디자인을 만들고자 합니다.


### Noto는 누가 디자인하나요?

Google에서는 방향성과 계획을 제공하며 디자인에 관한 최종 결정권을 갖습니다. 활자 및 디자인 관련 경력을 갖춘 '원어민'과 협력하고 글꼴 업계의 유능한 인재를 고용하여 Noto 디자인 목표에 부합하는 글꼴을 문자별로 개발합니다.


### Noto 글꼴은 어떻게 개발되나요?

각 문자의 Noto 글꼴은 협력을 통해 개발됩니다. 글꼴 제작 업체, 디자인 하우스, 유능한 디자이너와 협업하여 각 문자와 해당 문자를 사용하는 언어의 요구사항을 도출합니다. 이 같은 요구사항은 디자인 제안으로 이어집니다. 그런 다음 글꼴을 디자인 중인 언어(현재 사용 중인 언어)의 원어민 검토자(보통 언어 또는 서체 전문가인 경우가 많음)와 함께 디자인 제안을 다듬습니다. 여기서 상충하는 디자인 검토를 거치고 개인 취향을 조심스럽게 배제하는 과정이 필요할 때도 있습니다. 디자인 제안을 완전히 점검하면 글꼴 개발 주기가 진행되며 단계마다 검토가 이루어집니다. 복잡성, 검토자의 수 및 반응성, 필요한 문자의 수, 상충하는 리소스 할당 등 다양한 요소를 바탕으로 문자마다 다른 기간이 소요됩니다. 이 모든 단계를 마친 후 글꼴을 기술적으로 검토하여 문제가 없는지 살펴봅니다. 하지만 이 단계에서 모든 문제를 해결할 수는 없으며, 세상의 모든 소프트웨어 시스템과 마찬가지로 문제가 남아 있을 것입니다. 버그를 발견할 경우 신고해 주시면 Google에서 해결하겠습니다.


### Noto는 단순히 X 글꼴의 복사본인가요?

라틴 문자 Noto의 Sans-serif 버전은 이전에 라틴 문자 글꼴을 개발할 때도 협력했던 Steve Matteson이 디자인한 것입니다. 라틴 문자 Noto의 Sans-serif와 이전 디자인은 디자인 목표를 공유하며 디자이너도 같으므로 유사점이 있습니다.


### UI 버전과 비 UI 버전의 차이점은 무엇인가요?

UI 글꼴은 원래 Android UI용으로 만들어졌습니다. UI 글꼴은 세로 측정 기준이 더 좁은데, 너무 길어서 잘리는 문자는 공간에 맞게 다시 그렸습니다. 따라서 세로 공간에 제약이 있는 곳에 어디든지 사용할 수 있습니다. 이 같은 조정이 필요하지 않은 비 UI 버전의 문자도 있으며, 비 UI 버전은 본문 텍스트에 사용하는 것이 좋습니다.


### 한중일 문자 통합은 어떻게 생각하시나요?

한중일 문자 통합이 좋은지는 현재 논란의 여지가 있습니다. 이는 CJK 언어의 글꼴이나 텍스트 처리 시스템을 디자인할 때 고려해야 하는 현실입니다. Google에서는 현존하는 시스템에서 사용할, 즉 존재하는 프레임워크 내에서 작동하는 글꼴을 만듭니다. 이 프레임워크를 바꾸고자 하는 사람이 있다면 표준화 기관에 참여하여 표준 개발에 참여하는 방법으로 방향을 바꾸어 나가야 할 것입니다.


### Google은 언제 클링곤어, 엘프어 등을 지원하나요?

클링곤어, 엘프어 등이 유니코드에 포함되면 지원하겠습니다. :) [유니코드 컨소시엄에 문의](http://www.unicode.org/contacts.html)하여 내가 좋아하는 창작 언어를 지원해 달라고 요청하세요.


### Noto와 Droid는 어떤 관계인가요?

Google의 Droid 글꼴은 Noto로 대체되었습니다. Noto는 Droid로 시작했으며 현재 Noto 글꼴만 업데이트되고 있습니다. 이제 Noto는 Droid에서 지원하는 모든 언어를 더욱 효과적으로 지원하며, 버그는 더 적으면서 더 많은 문자와 언어를 지원합니다.  Android와 ChromeOS 모두 Noto로 전환되었으며, Google에서는 Droid를 Noto로 대체하는 것을 권장합니다. 마찬가지로 Droid Sans Fallback 글꼴은 Noto Sans CJK로 대체되었으며, [noto-cjk](https://github.com/googlefonts/noto-cjk)에서 찾아볼 수 있습니다.


### 모든 언어(또는 적어도 최대한 많은 문자)를 지원하는 하나의 글꼴 파일을 제공해줄 수 있나요?

하나의 글꼴에 포함할 수 없을 정도로 많은 문자가 Noto에 포함되어 있으므로 하나의 파일을 제공하는 것은 불가능합니다. CJK만 해도 이미 최대 크기에 도달합니다. 게다가 문자마다 선호되는 선 측정 기준이 서로 다릅니다. Noto를 디자인할 때는 모든 문자를 한 가지 측정 기준에 맞추는 대신 각 문자에 적절한 선 측정 기준을 적용합니다. UI 글꼴의 경우 예외적으로 선 높이가 같은 하나의 글꼴을 만들 수 있습니다. 하지만 적은 수의 파일로 폰트를 재구성하는 과정이 진행 중입니다. 현재 사용되는 언어의 일반적인 문자를 담은 글꼴 하나와, (탕구트어로 인해 한 가지 글꼴에 포함될 수 있는 비 CJK 문자 제한이 초과되는지 여부에 따라) 잘 알려지지 않은 문자를 담은 글꼴 하나, 그리고 CJK 글꼴 하나를 만들 수도 있을 것입니다. 글꼴 병합에 사용할 수 있는 도구는 있지만, 항상 문제는 사소한 곳에 있습니다. 일반적인 문자가 몇 가지 소스 글꼴에 포함되어 있는 경우가 있어서
이러한 문자들이 비정상적으로 표시된다면 문제를 해결해야 할 것입니다.


### 다른 사람과 공유할 수 있는 Noto YouTube 동영상이 있나요?

YouTube에서 찾아볼 수 있는 Noto 관련 동영상은 다음과 같습니다.
* [Google을 위한 Noto 개발](https://www.youtube.com/watch?v=16_NYHUZ1kM)
* [Google의 국제 글꼴 Noto — 하나로 충분한 만능 글꼴](https://www.youtube.com/watch?v=AAzvk9HSi84)

