# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

tabbrowser-empty-tab-title = Nova langeto
tabbrowser-empty-private-tab-title = Nova privata langeto
tabbrowser-menuitem-close-tab =
    .label = Fermi langeton
tabbrowser-menuitem-close =
    .label = Fermi
# Displayed as a tooltip on container tabs
# Variables:
#   $title (String): the title of the current tab.
#   $containerName (String): the name of the current container.
tabbrowser-container-tab-title = { $title } - { $containerName }
# This text serves as an on-screen tooltip as well as an accessible name for
# the "X" button that is shown on the active tab or, when multiple tabs are
# selected, to all their "X" buttons.
# Variables:
#   $tabCount (Number): The number of tabs that will be closed.
tabbrowser-close-tabs-button =
    .tooltiptext =
        { $tabCount ->
            [one] Fermi langeton
           *[other] Fermi { $tabCount } langetojn
        }
# Variables:
#   $tabCount (Number): The number of tabs that will be closed.
tabbrowser-close-tabs-tooltip =
    .label =
        { $tabCount ->
            [one] Fermi langeton
           *[other] Fermi { $tabCount } langetojn
        }

## Tooltips for tab audio control
## Variables:
##   $tabCount (Number): The number of tabs that will be affected.

# Variables:
#   $shortcut (String): The keyboard shortcut for "Mute tab".
tabbrowser-mute-tab-audio-tooltip =
    .label =
        { $tabCount ->
            [one] Silentigi langeton ({ $shortcut })
           *[other] Silentigi { $tabCount } langetojn ({ $shortcut })
        }
# Variables:
#   $shortcut (String): The keyboard shortcut for "Unmute tab".
tabbrowser-unmute-tab-audio-tooltip =
    .label =
        { $tabCount ->
            [one] Malsilentigi langeton ({ $shortcut })
           *[other] Malilentigi { $tabCount } langetojn ({ $shortcut })
        }
tabbrowser-mute-tab-audio-background-tooltip =
    .label =
        { $tabCount ->
            [one] Silentigi langeton
           *[other] Silentigi { $tabCount } langetojn
        }
tabbrowser-unmute-tab-audio-background-tooltip =
    .label =
        { $tabCount ->
            [one] Malsilentigi langeton
           *[other] Malsilentigi { $tabCount } langetojn
        }
tabbrowser-unblock-tab-audio-tooltip =
    .label =
        { $tabCount ->
            [one] Ludi langeton
           *[other] Ludi { $tabCount } langetojn
        }

## Confirmation dialog when closing a window with more than one tab open,
## or when quitting when only one window is open.

# The singular form is not considered since this string is used only for multiple tabs.
# Variables:
#   $tabCount (Number): The number of tabs that will be closed.
tabbrowser-confirm-close-tabs-title = Ĉu fermi { $tabCount } langetojn?
tabbrowser-confirm-close-tabs-button = Fermi langetojn
tabbrowser-ask-close-tabs-checkbox = Demandi antaŭ ol fermi plurajn langetojn
tabbrowser-confirm-close-tabs-checkbox = Konfirmi antaŭ fermi plurajn langetojn

## Confirmation dialog when quitting using the menu and multiple windows are open.

# The forms for 0 or 1 items are not considered since this string is used only for
# multiple windows.
# Variables:
#   $windowCount (Number): The number of windows that will be closed.
tabbrowser-confirm-close-windows-title = Ĉu fermi { $windowCount } fenestrojn?
tabbrowser-confirm-close-windows-button =
    { PLATFORM() ->
        [windows] Fermi kaj fini
       *[other] Fermi kaj fini
    }

## Confirmation dialog when quitting using the keyboard shortcut (Ctrl/Cmd+Q)
## Windows does not show a prompt on quit when using the keyboard shortcut by default.

tabbrowser-confirm-close-tabs-with-key-title = Ĉu fermi fenestron kaj fini { -brand-short-name }?
tabbrowser-confirm-close-tabs-with-key-button = Fini { -brand-short-name }
# Variables:
#   $quitKey (String): the text of the keyboard shortcut for quitting.
tabbrowser-ask-close-tabs-with-key-checkbox = Demandi antaŭ ol fini per { $quitKey }
# Variables:
#   $quitKey (String): the text of the keyboard shortcut for quitting.
tabbrowser-confirm-close-tabs-with-key-checkbox = Konfirmi antaŭ ol fini per { $quitKey }

## Confirmation dialog when quitting using the keyboard shortcut (Ctrl/Cmd+Q)
## and browser.warnOnQuitShortcut is true.

tabbrowser-confirm-close-warn-shortcut-title = Ĉu fini { -brand-short-name } aŭ ĉu fermi la nunan langeton?
tabbrowser-confirm-close-windows-warn-shortcut-button =
    { PLATFORM() ->
        [windows] Fini { -brand-short-name }
       *[other] Fini { -brand-short-name }
    }
tabbrowser-confirm-close-tab-only-button = Fermi nunan langeton

## Confirmation dialog when opening multiple tabs simultaneously

tabbrowser-confirm-open-multiple-tabs-title = Konfirmi malfermon
# Variables:
#   $tabCount (Number): The number of tabs that will be opened.
tabbrowser-confirm-open-multiple-tabs-message =
    { $tabCount ->
       *[other] Vi pretas malfermi { $tabCount } langetojn. Tio povas malrapidigi { -brand-short-name } dum la paĝoj estas ŝargataj. Ĉu vi certas ke vi volas daŭrigi?
    }
tabbrowser-confirm-open-multiple-tabs-button = Malfermi langetojn
tabbrowser-confirm-open-multiple-tabs-checkbox = Averti min se malfermado de pluraj langetoj povus malrapidigi { -brand-short-name }

## Confirmation dialog for enabling caret browsing

tabbrowser-confirm-caretbrowsing-title = Esplorado per montrilo
tabbrowser-confirm-caretbrowsing-message = Premo de F7 ŝaltas aŭ malŝaltas la esploradon per montrilo. Tiu trajto metas moveblan montrilon en retpaĝojn, kiu permesas al vi elekti tekston per la klavaro. Ĉu vi volas ŝalti la esploradon per montrilo?
tabbrowser-confirm-caretbrowsing-checkbox = Ne montri ĉi tiun dialogon denove.

## Confirmation dialog for closing all duplicate tabs

tabbrowser-confirm-close-duplicate-tabs-title = Atento!
tabbrowser-confirm-close-duplicate-tabs-text = Ni lasos la lastan aktivan langeton malfermita
tabbrowser-confirm-close-all-duplicate-tabs-title = Ĉu fermi duobligitajn langetojn?
tabbrowser-confirm-close-all-duplicate-tabs-text = Duobligitaj langetoj en tiu ĉi fenestro estos fermitaj. La laste aktiva langeto restos malfermita.
tabbrowser-confirm-close-all-duplicate-tabs-button-closetabs = Fermi langetojn

##

# Variables:
#   $domain (String): URL of the page that is trying to steal focus.
tabbrowser-allow-dialogs-to-get-focus =
    .label = Permesi ke sciigoj kiel tiu ĉi de { $domain } portu vin al sia langeto
tabbrowser-customizemode-tab-title = Personecigi { -brand-short-name }

## Context menu buttons, of which only one will be visible at a time

tabbrowser-context-mute-tab =
    .label = Silentigi langeton
    .accesskey = S
tabbrowser-context-unmute-tab =
    .label = Malsilentigi langeton
    .accesskey = s
# The accesskey should match the accesskey for tabbrowser-context-mute-tab
tabbrowser-context-mute-selected-tabs =
    .label = Silentigi langetojn
    .accesskey = S
# The accesskey should match the accesskey for tabbrowser-context-unmute-tab
tabbrowser-context-unmute-selected-tabs =
    .label = Malsilentigi langetojn
    .accesskey = M
# This string is used as an additional tooltip and accessibility description for tabs playing audio
tabbrowser-tab-audio-playing-description = Sono ludata

## Ctrl-Tab dialog

# Variables:
#   $tabCount (Number): The number of tabs in the current browser window. It will always be 2 at least.
tabbrowser-ctrl-tab-list-all-tabs =
    .label = Listigi ĉiujn { $tabCount } langetojn

## Tab manager menu buttons

tabbrowser-manager-mute-tab =
    .tooltiptext = Silentigi langeton
tabbrowser-manager-unmute-tab =
    .tooltiptext = Malsilentigi langeton
tabbrowser-manager-close-tab =
    .tooltiptext = Fermi langeton

## Tab Groups

tab-group-editor-title-create = Krei grupon de langetoj
tab-group-editor-title-edit = Administri grupon de langetoj
tab-group-editor-name-label = Nomo
tab-group-editor-name-field =
    .placeholder = Ekzemplo: Aĉetumo
tab-group-editor-cancel =
    .label = Nuligi
    .accesskey = N
tab-context-unnamed-group =
    .label = Grupo sen nomo

## Variables:
##  $tabCount (Number): the number of tabs that are affected by the action.

tab-context-move-tab-to-new-group =
    .label =
        { $tabCount ->
            [1] Aldoni langeton al nova grupo
           *[other] Aldoni langetojn al nova grupo
        }
    .accesskey = g
tab-context-move-tab-to-group =
    .label =
        { $tabCount ->
            [1] Aldoni langeton al grupo
           *[other] Aldoni langetojn al grupo
        }
    .accesskey = G
tab-group-editor-action-new-tab =
    .label = Nova langeto en grupo
tab-group-editor-action-new-window =
    .label = Movi grupon al nova fenestro
tab-group-editor-action-save =
    .label = Konservi kaj fermi grupon
tab-group-editor-action-ungroup =
    .label = Malgrupigi langetojn
tab-group-editor-action-delete =
    .label = Forigi grupon
tab-group-editor-done =
    .label = Farita
    .accessKey = F
tab-context-reopen-tab-group =
    .label = Denove malfermi grupon de langetoj
# Variables:
#  $groupCount (Number): the number of tab groups that are affected by the action.
tab-context-ungroup-tab =
    .label =
        { $groupCount ->
            [1] Forigi el grupo
           *[other] Forigi el grupoj
        }
    .accesskey = F
